/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas.report;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.model.ReportModel;
import kd.epm.eb.business.forecast.PredictParamService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;
import kd.epm.eb.formplugin.analysiscanvas.report.IReportHelper;
import kd.epm.eb.spread.command.lockcontroller.ISpreadLockControl;
import kd.epm.eb.spread.command.rangedefined.ContextMenuItemsEnum;
import kd.epm.eb.spread.command.rangedefined.ToolBarItemsEnum;
import kd.epm.eb.spread.command.rangedefined.WorkbookOptions;
import kd.epm.eb.spread.command.style.ContextMenuWorkArea;
import kd.epm.eb.spread.command.stylecontroller.ISpreadStyleControl;
import kd.epm.eb.spread.control.CmdSpreadContainer;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarUtil;

public abstract class AbstractReportHelper
implements IReportHelper {
    private static final Log log = LogFactory.getLog(AbstractReportHelper.class);
    protected CustomItem customItem;
    protected ReportModel reportModel;
    protected IModelCacheHelper modelCache;
    protected ITemplateModel templateModel;
    protected IEbSpreadManager spreadManager;
    protected IFormView formView;
    protected String pageCacheKeySuffix;
    protected Map<String, Map<String, String>> varValues;
    private final ISpreadContainer spreadContainer;

    public AbstractReportHelper(CustomItem customItem, ReportModel reportModel, ITemplateModel templateModel, IModelCacheHelper modelCache, IFormView formView) {
        this.customItem = customItem;
        this.reportModel = reportModel;
        this.templateModel = templateModel;
        this.modelCache = modelCache;
        this.formView = formView;
        this.pageCacheKeySuffix = "_" + customItem.getId();
        this.spreadContainer = new CmdSpreadContainer();
        this.varValues = TemplateVarUtil.isVarTemplate((ITemplateModel)templateModel) ? ReportVarUtil.getVarValues((String)ProcessTypeEnum.ANALYSIS.getNumber(), (Long)templateModel.getModelId(), (Long)IDUtils.toLong((Object)customItem.getId()), (String)templateModel.getTemplateBaseInfo().getVarBase()) : Collections.emptyMap();
    }

    public void buildSpreadCommand() {
        List cmdList = ((CmdSpreadContainer)this.spreadContainer).getCmdList();
        ArrayList commands = new ArrayList(cmdList.size());
        cmdList.forEach(cmd -> {
            Map.Entry entry = cmd.entrySet().iterator().next();
            if (entry == null) {
                return;
            }
            commands.add(ImmutableMap.of((Object)"k", entry.getKey(), (Object)"v", (Object)new Object[]{entry.getValue()}));
        });
        this.reportModel.setCommands(commands);
    }

    protected void setCacheVar() {
        if (this.getSpreadManager() != null) {
            this.getSpreadManager().setProcessId(IDUtils.toLong((Object)this.customItem.getId()));
            this.getSpreadManager().setProcessType(ProcessTypeEnum.ANALYSIS.getNumber());
        }
    }

    protected void initFormulaMap(ITemplateModel templateModel, IEbSpreadManager ebSpreadManager) {
        HashMap formulaMap = new HashMap(16);
        formulaMap.putAll(templateModel.getFormulaMap());
        ebSpreadManager.setFormulaMap(formulaMap);
    }

    protected void initOutAreaHyperLink(ITemplateModel templateModel, IEbSpreadManager ebSpreadManager) {
        HashMap hyperLink = new HashMap(16);
        hyperLink.putAll(templateModel.getOutAreaHyperLink());
        ebSpreadManager.setOutAreaHyperLink(hyperLink);
    }

    protected void initPageDim(ReportModel reportModel, IEbSpreadManager spreadManager, IModelCacheHelper modelCache, Map<String, String> filterDim) {
        Map dimensionViews = spreadManager.getDimemsionViews();
        reportModel.getDims().forEach(dimModel -> {
            String memNumber;
            MemberModel member;
            String dimNumber = dimModel.getDim();
            Long viewId = IDUtils.toLong(dimensionViews.get(dimNumber));
            if (dimModel.getS().booleanValue()) {
                member = (MemberModel)dimModel.getMems().get(0);
                memNumber = member.getNum();
            } else {
                memNumber = (String)filterDim.get(dimNumber);
            }
            member = AnalysisCanvasPluginHelper.getMember(modelCache, dimNumber, viewId, memNumber);
            if (member == null) {
                return;
            }
            spreadManager.getAlldimensionWithMembers().put(dimNumber, Sets.newHashSet((Object[])new String[]{member.getNumber()}));
            PageViewDimMember pageViewDimMember = new PageViewDimMember(member.getNumber(), member.isLeaf());
            if (SysDimensionEnum.Metric.getNumber().equals(dimNumber) && StringUtils.isNotEmpty((String)member.getUse())) {
                pageViewDimMember.setUse(member.getUse());
            }
            spreadManager.getPageViewDims().put(dimNumber, pageViewDimMember);
        });
    }

    protected void initHideDim(IEbSpreadManager spreadManager, ITemplateModel templateModel, IModelCacheHelper modelCache) {
        Map dimensionViews = spreadManager.getDimemsionViews();
        for (IViewPointDimensionEntry entry : templateModel.getViewpointmembentry()) {
            Member member;
            String dimNumber = entry.getDimension().getNumber();
            IDimensionMember entryMember = entry.getMember();
            Long viewId = IDUtils.toLong(dimensionViews.get(dimNumber));
            if (TemplateVarCommonUtil.checkIsVar((String)entryMember.getNumber(), (String)dimNumber).booleanValue()) {
                entryMember.setNumber(ReportVarUtil.getRealDimByVar((Long)templateModel.getModelId(), (String)entry.getMember().getNumber(), (String)dimNumber, this.varValues));
            }
            if ((member = AnalysisCanvasPluginHelper.getMember(modelCache, dimNumber, viewId, entryMember.getNumber())) == null) continue;
            spreadManager.getAlldimensionWithMembers().put(dimNumber, Sets.newHashSet((Object[])new String[]{member.getNumber()}));
            PageViewDimMember pageViewDimMember = new PageViewDimMember(member.getNumber(), member.isLeaf());
            if (SysDimensionEnum.Metric.getNumber().equals(dimNumber) && StringUtils.isNotEmpty((String)member.getUse())) {
                pageViewDimMember.setUse(member.getUse());
            }
            spreadManager.getPageViewDims().put(dimNumber, pageViewDimMember);
        }
    }

    public IFormView getView() {
        return this.formView;
    }

    public ISpreadContainer getSpreadContainer() {
        return this.spreadContainer;
    }

    public IEbSpreadManager getSpreadManager() {
        return this.spreadManager;
    }

    public ITemplateModel getTemplateModel() {
        return this.templateModel;
    }

    void cacheTemplate(String templateData) {
        this.formView.getPageCache().put("templateModelCacheKey" + this.pageCacheKeySuffix, templateData);
        this.formView.getPageCache().put("templateBaseCacheKey" + this.pageCacheKeySuffix, JSON.toJSONString((Object)this.templateModel.getTemplateBaseInfo()));
    }

    protected void beforeResolveStyles() {
    }

    abstract void invokeSpreadJson();

    protected void invokeWorkOperations() {
        this.hideToolbarAndContextMenuItems();
        this.addContextMenuItems();
        this.setWorkbookOptions();
    }

    protected void afterResolveStyles() {
    }

    protected abstract void resolveSpreadLock();

    abstract void resolveSpreadLockController(List<ISpreadLockControl> var1);

    abstract void lockAllData();

    abstract void setCellStyles();

    abstract void resolveSpreadStyleController(List<ISpreadStyleControl> var1);

    abstract void cacheSpreadManager();

    private void hideToolbarAndContextMenuItems() {
        List<ToolBarItemsEnum> lockToolBarItems = this.getHideToolBarItems();
        List<ContextMenuItemsEnum> hideContextItems = this.getHideContextMenuItems();
        if (lockToolBarItems != null && lockToolBarItems.size() > 0) {
            this.getSpreadContainer().lockToolbarItems(lockToolBarItems, new ArrayList());
        }
        if (hideContextItems != null && hideContextItems.size() > 0) {
            this.getSpreadContainer().hideContextMenuItems(hideContextItems, new ArrayList());
        }
    }

    protected abstract List<ToolBarItemsEnum> getHideToolBarItems();

    protected List<ContextMenuItemsEnum> getHideContextMenuItems() {
        return Lists.newArrayList((Object[])new ContextMenuItemsEnum[]{ContextMenuItemsEnum.CLEARCONTENTS, ContextMenuItemsEnum.INSERTROWS, ContextMenuItemsEnum.INSERTCOLUMNS, ContextMenuItemsEnum.INSERTROWMANY, ContextMenuItemsEnum.INSERTFLOATROWS, ContextMenuItemsEnum.INSERTCOLUMNMANY, ContextMenuItemsEnum.DELETEROWS, ContextMenuItemsEnum.DELETECOLUMNS, ContextMenuItemsEnum.INSERTSHEET, ContextMenuItemsEnum.DELETESHEET, ContextMenuItemsEnum.SORT, ContextMenuItemsEnum.SLICERSORTASCEND, ContextMenuItemsEnum.SLICERSORTDESCEND, ContextMenuItemsEnum.INSERTCOMMENT, ContextMenuItemsEnum.RICHTEXT, ContextMenuItemsEnum.EDITCOMMENT, ContextMenuItemsEnum.DELETECOMMENT, ContextMenuItemsEnum.TOGGLECOMMENT, ContextMenuItemsEnum.HIDEROWS, ContextMenuItemsEnum.UNHIDEROWS, ContextMenuItemsEnum.HIDECOLUMNS, ContextMenuItemsEnum.UNHIDECOLUMNS, ContextMenuItemsEnum.HIDESHEET, ContextMenuItemsEnum.UNHIDESHEET, ContextMenuItemsEnum.REMOVESLICER});
    }

    protected void addContextMenuItems() {
        this.getSpreadContainer().addContextMenuItems("viewComputeProcess", ResManager.loadKDString((String)"\u8ba1\u7b97\u8fc7\u7a0b", (String)"AnalysisCanvasReportConfigPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]), new ContextMenuWorkArea().setViewport(true));
        if (PredictParamService.getInstance().isShow(this.modelCache.getModelobj().getId())) {
            this.getSpreadContainer().addContextMenuItems("predictData", ResManager.loadKDString((String)"\u667a\u80fd\u9884\u6d4b", (String)"AnalysisCanvasReportConfigPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), new ContextMenuWorkArea().setViewport(true));
        }
    }

    protected void setWorkbookOptions() {
        WorkbookOptions workbookOptions = new WorkbookOptions();
        workbookOptions.setGrayAreaBackColor("#ffffff");
        workbookOptions.setClipBoardOptions(Integer.valueOf(1));
        boolean designMode = Boolean.parseBoolean(this.getView().getPageCache().get("designMode"));
        if (designMode) {
            workbookOptions.setAllowContextMenu(Boolean.valueOf(false));
        }
        this.getSpreadContainer().setWorkbookOptions(workbookOptions);
    }
}

