/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas.report;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.form.IFormView;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.ReportModel;
import kd.epm.eb.business.template.TemplateFormulaUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.utils.Point;
import kd.epm.eb.formplugin.analysiscanvas.report.AbstractReportHelper;
import kd.epm.eb.formplugin.template.templateview.FixTemplateProcessHelper;
import kd.epm.eb.formplugin.utils.TemplateHelper;
import kd.epm.eb.spread.command.lockcontroller.FixSpreadLockContext;
import kd.epm.eb.spread.command.lockcontroller.ISpreadLockControl;
import kd.epm.eb.spread.command.lockcontroller.lockcell.fix.FixDataLockCellLockController;
import kd.epm.eb.spread.command.lockcontroller.lockcell.fix.FixMetricCellLockController;
import kd.epm.eb.spread.command.lockcontroller.lockcell.fix.FixNoLeafCellLockController;
import kd.epm.eb.spread.command.lockcontroller.lockcell.fix.FixPageViewDimNoLeafController;
import kd.epm.eb.spread.command.lockcontroller.lockcell.fix.FixRollCellLockController;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.rangedefined.ContextMenuItemsEnum;
import kd.epm.eb.spread.command.rangedefined.ToolBarItemsEnum;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.command.style.CellStyleInfo;
import kd.epm.eb.spread.command.stylecontroller.FixSpreadStyleControlContext;
import kd.epm.eb.spread.command.stylecontroller.ISpreadStyleControl;
import kd.epm.eb.spread.command.stylecontroller.styleset.fix.FixEnumMetricCellController;
import kd.epm.eb.spread.command.stylecontroller.styleset.fix.FixSheetMetricDimStyleController;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.fix.FixSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.serializer.afix.FixSpreadManagerSerializerUtil;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.utils.AutoFloatHelper;
import org.apache.commons.collections4.CollectionUtils;

public class FixReportHelper
extends AbstractReportHelper {
    public FixReportHelper(CustomItem customItem, ReportModel reportModel, ITemplateModel templateModel, IModelCacheHelper modelCache, IFormView formView) {
        super(customItem, reportModel, templateModel, modelCache, formView);
    }

    @Override
    protected void beforeResolveStyles() {
    }

    @Override
    protected void invokeSpreadJson() {
        this.getSpreadContainer().rebuildSpread(this.templateModel.getSpreadSerial());
        this.invokeDeleteRowCol();
    }

    @Override
    protected void afterResolveStyles() {
        if (CollectionUtils.isEmpty((Collection)this.getSpreadManager().getMultiAreaManager())) {
            return;
        }
        this.resolveSpreadLock();
        this.setCellStyles();
    }

    @Override
    public void cacheSpreadManager() {
        this.formView.getPageCache().put("spreadManagerCacheKey" + this.pageCacheKeySuffix, FixSpreadManagerSerializerUtil.toJson((IEbSpreadManager)this.spreadManager));
    }

    @Override
    public void initSpreadManager(String itemId, ReportModel reportModel, ITemplateModel templateModel, IModelCacheHelper modelCache, Map<String, String> filterDim) {
        this.spreadManager = new FixSpreadManager();
        this.setCacheVar();
        this.spreadManager.buildReportManager(templateModel);
        this.initHideDim(this.spreadManager, templateModel, modelCache);
        this.initPageDim(reportModel, this.spreadManager, modelCache, filterDim);
        this.initFormulaMap(templateModel, this.spreadManager);
        this.initOutAreaHyperLink(templateModel, this.spreadManager);
    }

    protected void invokeDeleteRowCol() {
        List areaSettings = this.templateModel.getAreaRanges();
        if (areaSettings == null || areaSettings.size() == 0) {
            return;
        }
        for (int i = areaSettings.size() - 1; i >= 0; --i) {
            IMultiAreaSetting areaSetting = (IMultiAreaSetting)areaSettings.get(i);
            MultiAreaManager areaManager = (MultiAreaManager)this.getSpreadManager().getMultiAreaManager().get(i);
            Map propertyMap = areaManager.getDimPropertys();
            Point dataPoint = FixTemplateProcessHelper.getAbsolutePosPoint(areaManager.getAreaRange().toString(), areaSetting.getStartPosition());
            dataPoint = this.deleteRowColDimArea(areaManager, areaSetting, dataPoint, propertyMap);
            if (areaSetting.getFloatInfos() == null || areaSetting.getFloatInfos().size() <= 0) continue;
            this.setFloatAreaStyle(areaManager, dataPoint, areaSetting, propertyMap);
            this.setFloatCellF7Style(areaManager, dataPoint);
        }
    }

    private void setFloatCellF7Style(MultiAreaManager areaManager, Point dataPoint) {
        ArrayList floatcells = new ArrayList(16);
        ArrayList floatF7cells = new ArrayList(16);
        ArrayList floatF7cells_quickAddNew = new ArrayList(16);
        ArrayList floatF7Areas = new ArrayList(16);
        ArrayList fixMemberAreas = new ArrayList(16);
        areaManager.getData().getDataSheet().iteratorECells(cell -> {
            if (cell != null) {
                int absRow = cell.getRow() + dataPoint.y;
                int absCol = cell.getCol() + dataPoint.x;
                if (!TemplateHelper.checkPropertyCell(cell)) {
                    if (cell.isFloatCell()) {
                        ECell absCell = new ECell(absRow, absCol, cell.getValue());
                        if (cell.getValue() != null) {
                            floatcells.add(absCell);
                        }
                        if ("true".equals(cell.getUserObject("isQuickAddNew"))) {
                            floatF7cells_quickAddNew.add(absCell);
                        } else {
                            floatF7cells.add(absCell);
                        }
                        floatF7Areas.add(new CellArea(absRow, absCol, 1, 1));
                    } else {
                        fixMemberAreas.add(new CellArea(absRow, absCol, 1, 1));
                    }
                }
            }
        });
        if (floatF7cells.size() > 0) {
            this.getSpreadContainer().setFListCells(floatF7cells, true, false, false);
        }
        if (floatF7cells_quickAddNew.size() > 0) {
            this.getSpreadContainer().setFListCells(floatF7cells_quickAddNew, true, false, true);
        }
        if (fixMemberAreas.size() > 0) {
            this.getSpreadContainer().resetCell(fixMemberAreas);
        }
        this.getSpreadContainer().updateCellValue2(floatcells);
        this.getSpreadContainer().unlockCells(floatF7Areas);
        AreasStyle areasStyle = new AreasStyle();
        areasStyle.setRange(floatF7Areas);
        CellStyleInfo floatcellstyle = new CellStyleInfo();
        floatcellstyle.setBkc("");
        floatcellstyle.setFm("@");
        areasStyle.setStyle(floatcellstyle);
        this.getSpreadContainer().setCellStyle((List)Lists.newArrayList((Object[])new AreasStyle[]{areasStyle}));
    }

    private void setFloatAreaStyle(MultiAreaManager areaManager, Point dataPoint, IMultiAreaSetting areaSetting, Map<String, List<PropertyObj>> propertyMap) {
        boolean deleterowpartition = areaManager.getFloatonWhere() != 0;
        boolean deletecolpartition = areaManager.getFloatonWhere() != 1;
        int coldims = areaManager.getColpartitionDims().size();
        int rowdims = areaManager.getRowpartitionDims().size();
        if (propertyMap != null) {
            coldims += FixTemplateProcessHelper.getPropertyCount(propertyMap, areaSetting.getColdims());
            rowdims += FixTemplateProcessHelper.getPropertyCount(propertyMap, areaSetting.getRowdims());
        }
        CellArea floatarea = null;
        if (!deleterowpartition) {
            floatarea = new CellArea(dataPoint.y, dataPoint.x, areaManager.getAreaRange().getY_end() - dataPoint.y + 1, rowdims);
        }
        if (!deletecolpartition) {
            floatarea = new CellArea(dataPoint.y, dataPoint.x, areaManager.getAreaRange().getX_end() - dataPoint.x + 1, coldims);
        }
        if (floatarea != null) {
            AreasStyle areasStyle = new AreasStyle();
            areasStyle.setRange((List)Lists.newArrayList((Object[])new CellArea[]{floatarea}));
            CellStyleInfo cellStyle = new CellStyleInfo();
            cellStyle.setBkc("");
            areasStyle.setStyle(cellStyle);
            this.getSpreadContainer().setCellStyle((List)Lists.newArrayList((Object[])new AreasStyle[]{areasStyle}));
        }
    }

    private Point deleteRowColDimArea(MultiAreaManager areaManager, IMultiAreaSetting areaSetting, Point dataPoint, Map<String, List<PropertyObj>> propertyMap) {
        boolean isFloat = areaSetting.getFloatOnWhere() == 0 || areaSetting.getFloatOnWhere() == 1;
        int coldims = areaSetting.getColdims().size();
        int rowdims = areaSetting.getRowdims().size();
        boolean colPropertyCount = false;
        boolean rowPropertyCount = false;
        if (propertyMap != null) {
            coldims += FixTemplateProcessHelper.getPropertyCount(propertyMap, areaSetting.getColdims());
            rowdims += FixTemplateProcessHelper.getPropertyCount(propertyMap, areaSetting.getRowdims());
        }
        CellArea cellArea = new CellArea(areaSetting.getAreaRange());
        AutoFloatHelper autoFloatHelper = new AutoFloatHelper(this.getView(), this.getSpreadManager(), this.getSpreadContainer(), this.getTemplateModel());
        String overlapType = autoFloatHelper.checkRowColOverlap();
        boolean canDeleteRow = !"row".equals(overlapType);
        boolean canDeleteCol = !"col".equals(overlapType);
        Point newDataPoint = dataPoint;
        if (!isFloat) {
            int i;
            this.getSpreadContainer().fieldDeleteRowCol(cellArea, dataPoint.x, rowdims, false);
            this.getSpreadContainer().fieldDeleteRowCol(cellArea, dataPoint.y, coldims, true);
            areaManager.getAreaRange().setX_end(areaManager.getAreaRange().getX_end() - rowdims);
            areaManager.getAreaRange().setY_end(areaManager.getAreaRange().getY_end() - coldims);
            cellArea.setCc(cellArea.getCc() - rowdims);
            cellArea.setRc(cellArea.getRc() - coldims);
            for (i = 0; i < rowdims; ++i) {
                if (areaManager.getData().getDataSheet().getMaxColumnCount() <= 0) continue;
                areaManager.getData().getDataSheet().delColumn(0);
            }
            for (i = 0; i < coldims; ++i) {
                if (areaManager.getData().getDataSheet().getMaxRowCount() <= 0) continue;
                areaManager.getData().getDataSheet().delRow(0);
            }
        } else if (areaSetting.getFloatOnWhere() == 0) {
            boolean hasReservedFloatCols;
            String[] startPointSplit = areaManager.getStartpoint().split(":");
            boolean bl = hasReservedFloatCols = Integer.parseInt(startPointSplit[0]) >= rowdims;
            if (hasReservedFloatCols) {
                this.getSpreadContainer().fieldDeleteRowCol(cellArea, dataPoint.y, coldims, true);
                CellArea cellArea_header = new CellArea(cellArea.getR(), cellArea.getC() + rowdims, dataPoint.y - cellArea.getR(), cellArea.getCc() - rowdims);
                CellArea cellArea_data = new CellArea(dataPoint.y, cellArea.getC(), cellArea.getRc() - cellArea_header.getRc(), cellArea.getCc());
                this.getSpreadContainer().fieldDeleteRowCol(cellArea_header, dataPoint.x, rowdims, false);
                this.getSpreadContainer().fieldDeleteRowCol(cellArea_data, dataPoint.x - rowdims, rowdims, false);
                areaManager.getAreaRange().setX_end(areaManager.getAreaRange().getX_end() - rowdims);
                areaManager.getAreaRange().setY_end(areaManager.getAreaRange().getY_end() - coldims);
                for (int i = 0; i < coldims; ++i) {
                    if (areaManager.getData().getDataSheet().getMaxRowCount() <= 0) continue;
                    areaManager.getData().getDataSheet().delRow(0);
                }
                cellArea.setRc(cellArea.getRc() - coldims);
                areaManager.setStartpoint(Integer.parseInt(startPointSplit[0]) - rowdims + ":" + startPointSplit[1]);
                newDataPoint = new Point(dataPoint.x - rowdims, dataPoint.y);
            } else {
                this.getSpreadContainer().fieldDeleteRowCol(cellArea, dataPoint.y, coldims, true);
                areaManager.getAreaRange().setY_end(areaManager.getAreaRange().getY_end() - coldims);
                for (int i = 0; i < coldims; ++i) {
                    if (areaManager.getData().getDataSheet().getMaxRowCount() <= 0) continue;
                    areaManager.getData().getDataSheet().delRow(0);
                }
                cellArea.setRc(cellArea.getRc() - coldims);
            }
        }
        ArrayList<Integer> rowIndexes = new ArrayList<Integer>(coldims);
        if (canDeleteRow) {
            for (int i = coldims; i > 0; --i) {
                rowIndexes.add(i + areaManager.getAreaRange().getY_end());
            }
            this.getSpreadContainer().deleteRowCol(rowIndexes, null);
            List bottomAreas = autoFloatHelper.getListOfBottomAreas(areaManager);
            if (bottomAreas != null) {
                for (MultiAreaManager m : bottomAreas) {
                    m.getAreaRange().setY_start(m.getAreaRange().getY_start() - rowIndexes.size());
                    m.getAreaRange().setY_end(m.getAreaRange().getY_end() - rowIndexes.size());
                }
            }
        }
        ArrayList<Integer> colIndexes = new ArrayList<Integer>(16);
        if (canDeleteCol) {
            for (int i = rowdims; i > 0; --i) {
                colIndexes.add(i + areaManager.getAreaRange().getX_end());
            }
            this.getSpreadContainer().deleteRowCol(null, colIndexes);
            List rightAreas = autoFloatHelper.getListOfRightAreas(areaManager);
            if (rightAreas != null) {
                for (MultiAreaManager m : rightAreas) {
                    m.getAreaRange().setX_start(m.getAreaRange().getX_start() - colIndexes.size());
                    m.getAreaRange().setX_end(m.getAreaRange().getX_end() - colIndexes.size());
                }
            }
        }
        TemplateFormulaUtil.getInstance().updateFormulaMap(this.getSpreadManager().getFormulaMap(), rowIndexes, colIndexes);
        TemplateFormulaUtil.getInstance().updateFormulaMap(this.getSpreadManager().getOutAreaHyperLink(), rowIndexes, colIndexes);
        return newDataPoint;
    }

    @Override
    protected List<ContextMenuItemsEnum> getHideContextMenuItems() {
        return super.getHideContextMenuItems();
    }

    @Override
    protected List<ToolBarItemsEnum> getHideToolBarItems() {
        return null;
    }

    @Override
    protected void resolveSpreadLock() {
        boolean designMode = Boolean.parseBoolean(this.getView().getPageCache().get("designMode"));
        if (designMode) {
            this.lockAllData();
            return;
        }
        ArrayList<ISpreadLockControl> spreadStyleControls = new ArrayList<ISpreadLockControl>(16);
        this.resolveSpreadLockController(spreadStyleControls);
        FixSpreadLockContext controlContext = this.getFixSpreadContext();
        if (controlContext == null || controlContext.getEbSpreadManager() == null) {
            return;
        }
        for (ISpreadLockControl style : spreadStyleControls) {
            style.controlfix(controlContext);
            if (!controlContext.isStopcommand()) continue;
            break;
        }
        if (controlContext.getAreasStyles().size() > 0) {
            this.getSpreadContainer().setCellStyle(controlContext.getAreasStyles());
        }
    }

    protected FixSpreadLockContext getFixSpreadContext() {
        return new FixSpreadLockContext(this.getSpreadManager(), this.getTemplateModel());
    }

    @Override
    protected void resolveSpreadLockController(List<ISpreadLockControl> spreadLockControls) {
        spreadLockControls.add((ISpreadLockControl)new FixPageViewDimNoLeafController(this.getView()));
        spreadLockControls.add((ISpreadLockControl)new FixNoLeafCellLockController());
        spreadLockControls.add((ISpreadLockControl)new FixRollCellLockController());
        spreadLockControls.add((ISpreadLockControl)new FixDataLockCellLockController());
        spreadLockControls.add((ISpreadLockControl)new FixMetricCellLockController());
    }

    @Override
    protected void lockAllData() {
        FixSpreadLockContext fixSpreadContext = this.getFixSpreadContext();
        fixSpreadContext.lockAllData(null, "#FFF8E1");
        this.getSpreadContainer().setCellStyle(fixSpreadContext.getAreasStyles());
    }

    @Override
    protected void setCellStyles() {
        ArrayList<ISpreadStyleControl> spreadStyleControls = new ArrayList<ISpreadStyleControl>(16);
        this.resolveSpreadStyleController(spreadStyleControls);
        FixSpreadStyleControlContext spreadStyleControlContext = this.getFixSpreadStyleControlContext();
        spreadStyleControls.forEach(stylecontrol -> stylecontrol.controlFix(spreadStyleControlContext));
        if (spreadStyleControlContext.getAreasStyles().size() > 0) {
            this.getSpreadContainer().setCellStyle(spreadStyleControlContext.getAreasStyles());
        }
        if (spreadStyleControlContext.getEnumCells().size() > 0) {
            this.getSpreadContainer().setFListCells(spreadStyleControlContext.getEnumCells(), true, true);
        }
    }

    protected FixSpreadStyleControlContext getFixSpreadStyleControlContext() {
        return new FixSpreadStyleControlContext(this.getSpreadManager(), this.getTemplateModel());
    }

    @Override
    protected void resolveSpreadStyleController(List<ISpreadStyleControl> spreadStyleControls) {
        spreadStyleControls.add((ISpreadStyleControl)new FixSheetMetricDimStyleController());
        spreadStyleControls.add((ISpreadStyleControl)new FixEnumMetricCellController());
    }
}

