/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas.report;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.analysiscanvas.exception.AnalysisCanvasException;
import kd.epm.eb.business.analysiscanvas.model.BaseModel;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.ReportModel;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.BgTemplateTypeEnum;
import kd.epm.eb.common.enums.SpreadTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.analysiscanvas.report.AbstractReportHelper;
import kd.epm.eb.formplugin.analysiscanvas.report.DynamicReportHelper;
import kd.epm.eb.formplugin.analysiscanvas.report.FixReportHelper;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public interface IReportHelper {
    public static final Log log = LogFactory.getLog(IReportHelper.class);

    public void initSpreadManager(String var1, ReportModel var2, ITemplateModel var3, IModelCacheHelper var4, Map<String, String> var5);

    public static void build(List<CustomItem> itemList, IFormView formView) {
        if (CollectionUtils.isEmpty(itemList)) {
            return;
        }
        ArrayList errMsgList = new ArrayList(16);
        List filterItemList = ModelHelper.getItems((String)"select", itemList);
        List reportItemList = ModelHelper.getItems((String)"report", itemList);
        reportItemList.forEach(item -> {
            try {
                AbstractReportHelper reportHelper;
                Map filterDim = ModelHelper.getFilterFromSelector((String)item.getId(), (List)filterItemList);
                ReportModel reportModel = (ReportModel)ModelHelper.getModel((CustomItem)item, ReportModel.class);
                long modelId = IDUtils.toLong((Object)reportModel.getModel());
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
                Pair<ITemplateModel, String> pair = IReportHelper.getTemplateModel(reportModel.getTempId(), reportModel);
                if (pair == null) {
                    return;
                }
                String templateData = (String)pair.getRight();
                ITemplateModel templateModel = (ITemplateModel)pair.getLeft();
                if (Integer.parseInt(BgTemplateTypeEnum.EBFIX.getNumber()) == templateModel.getTemplateBaseInfo().getTemplatetype()) {
                    reportHelper = new FixReportHelper((CustomItem)item, reportModel, templateModel, modelCache, formView);
                } else {
                    reportHelper = new DynamicReportHelper((CustomItem)item, reportModel, templateModel, modelCache, formView);
                    templateModel.getTemplateBaseInfo().setSpreadType(SpreadTypeEnum.SPREADTYPE_REPORT.getIndex());
                }
                reportHelper.initSpreadManager(item.getId(), reportModel, templateModel, modelCache, filterDim);
                reportHelper.beforeResolveStyles();
                reportHelper.invokeSpreadJson();
                reportHelper.invokeWorkOperations();
                reportHelper.afterResolveStyles();
                reportHelper.cacheSpreadManager();
                reportHelper.cacheTemplate(templateData);
                reportHelper.buildSpreadCommand();
                ModelHelper.updateModel((CustomItem)item, (BaseModel)reportModel);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                errMsgList.add(e.getMessage());
            }
        });
        if (CollectionUtils.isNotEmpty(errMsgList)) {
            formView.showMessage(String.join((CharSequence)"\n", errMsgList));
        }
    }

    public static Pair<ITemplateModel, String> getTemplateModel(String tempId, ReportModel reportModel) {
        ITemplateModel templateModel;
        Pair<ITemplateModel, String> pair = IReportHelper.getTemplateModel(tempId);
        if (pair != null && (templateModel = (ITemplateModel)pair.getLeft()) != null) {
            Map modelViewMap = ModelHelper.getViewMap((JSONObject)reportModel.getDimensionViews());
            templateModel.getDimemsionViews().putAll(modelViewMap);
        }
        return pair;
    }

    public static Pair<ITemplateModel, String> getTemplateModel(String tempId) {
        String selectFields = "id,name,number,templatetype,dataunit,model,templateCatalog,dataset,dataset.businessmodel,isrelation,dimrelationinfo,data,dimmemdefaultdisplaytype,varbaseforeb,spreadserial";
        DynamicObject dyna = QueryServiceHelper.queryOne((String)"eb_templateentity", (String)selectFields, (QFilter[])new QFilter("id", "=", (Object)IDUtils.toLong((Object)tempId)).toArray());
        if (dyna == null) {
            throw new AnalysisCanvasException(ResManager.loadResFormat((String)"\u5f15\u7528\u7684\u62a5\u8868\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AnalysisCanvasDesignPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        BgTemplate templateBaseInfo = new BgTemplate();
        templateBaseInfo.setId(Long.valueOf(dyna.getLong("id")));
        templateBaseInfo.setName(dyna.getString("name"));
        templateBaseInfo.setNumber(dyna.getString("number"));
        templateBaseInfo.setTemplatetype(dyna.getInt("templatetype"));
        templateBaseInfo.setDataunit(dyna.getString("dataunit"));
        templateBaseInfo.setModelID(Long.valueOf(dyna.getLong("model")));
        templateBaseInfo.setCatalog(Long.valueOf(dyna.getLong("templateCatalog")));
        templateBaseInfo.setDatasetID(Long.valueOf(dyna.getLong("dataset")));
        templateBaseInfo.setIsDimRelation(dyna.getBoolean("isrelation") ? "1" : "0");
        templateBaseInfo.setVarBase(dyna.getString("varbaseforeb"));
        templateBaseInfo.setBizModel(Long.valueOf(dyna.getLong("dataset.businessmodel")));
        templateBaseInfo.setDimMemDefaultDisplayType(dyna.getInt("dimmemdefaultdisplaytype"));
        String data = dyna.getString("data");
        if (StringUtils.isEmpty((String)data)) {
            return null;
        }
        ITemplateModel templateModel = TemplateModelJSONUtil.parseITemplateModel((String)data);
        if (templateModel == null) {
            return null;
        }
        templateModel.setTemplateBaseInfo(templateBaseInfo);
        templateModel.setSpreadSerilal(dyna.getString("spreadserial"));
        return Pair.of((Object)templateModel, (Object)data);
    }
}

