/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas.table;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.MemberModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.TableModel;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.pageinteraction.CommandParam;
import kd.epm.eb.common.pageinteraction.MainPage;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasEnum;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasControlHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasUserSelHelper;
import kd.epm.eb.formplugin.analysiscanvas.table.TableHelper;
import kd.epm.eb.formplugin.qinganalysis.model.TextEditSelectItem;
import kd.epm.eb.olap.analysiscanvas.service.AnalysisCubeService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AnalysisCanvasTable2ConfigPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
ClickListener,
MainPage {
    private static final String ROW_DIM = "rowdim";
    private static final String COL_DIM = "coldim";
    private static final String SUB_PAGE_ID = "sub_page_id";
    static final String OPT_ROWCOL_CHANGE = "rowColChange";
    static final String ROW_ENTRY = "rowentry";
    static final String COL_ENTRY = "colentry";
    static final String F_SPLIT_CHAR = String.valueOf('_');

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String itemJson = params.get("customItem").toString();
        this.getPageCache().put("customItem", itemJson);
        String canvasId = params.get("canvasId").toString();
        this.getPageCache().put("canvasId", canvasId);
        this.getPageCache().put("usedBoxId", params.get("usedBoxId").toString());
        this.setInitData(canvasId, itemJson);
    }

    private void setInitData(String canvasId, String itemJson) {
        CustomItem customItem = (CustomItem)JSON.parseObject((String)itemJson, CustomItem.class);
        JSONObject tableModelJson = customItem.getC().getJSONObject("tableModel");
        if (tableModelJson != null && !AnalysisCanvasControlHelper.isAdd(customItem).booleanValue()) {
            TableModel tableModel = (TableModel)tableModelJson.toJavaObject(TableModel.class);
            Long modelId = IDUtils.toLong((Object)tableModel.getModel());
            Long datasetId = IDUtils.toLong((Object)tableModel.getDataset());
            this.getPageCache().put("model", String.valueOf(modelId));
            this.getModel().setValue("model", (Object)modelId);
            this.getPageCache().put("dataset", String.valueOf(datasetId));
            this.getModel().setValue("dataset", (Object)datasetId);
            JSONObject dimensionViews = tableModel.getDimensionViews();
            if (dimensionViews == null) {
                dimensionViews = new JSONObject();
            }
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
            this.initRowColDim(tableModel.getRowDim(), tableModel.getColDim());
            this.initTableData(canvasId, tableModel, datasetId, modelCache, dimensionViews);
            this.initRowColEntry(modelId, datasetId, itemJson, false);
        } else {
            String modelId = AnalysisCanvasUserSelHelper.getModel(this.getView());
            String datasetId = AnalysisCanvasUserSelHelper.getDataset(this.getView(), IDUtils.toLong((Object)canvasId), IDUtils.toLong((Object)modelId));
            if (StringUtils.isNotBlank((CharSequence)modelId)) {
                this.getModel().setValue("model", (Object)modelId);
                this.getPageCache().put("model", modelId);
            }
            if (StringUtils.isNotBlank((CharSequence)datasetId)) {
                this.getModel().setValue("dataset", (Object)datasetId);
                this.getPageCache().put("dataset", datasetId);
                this.setDefaultRowColDim(IDUtils.toLong((Object)canvasId), IDUtils.toLong((Object)datasetId));
            }
            if (StringUtils.isNotBlank((CharSequence)modelId) && StringUtils.isNotBlank((CharSequence)datasetId)) {
                this.initRowColEntry(IDUtils.toLong((Object)modelId), IDUtils.toLong((Object)datasetId), itemJson, true);
            }
        }
    }

    private void setDefaultRowColDim(long canvasId, long datasetId) {
        DimensionModel dimModel1 = new DimensionModel();
        dimModel1.setDim(SysDimensionEnum.Account.getNumber());
        List<List<DimensionModel>> rowDimList = Collections.singletonList(Lists.newArrayList((Object[])new DimensionModel[]{dimModel1}));
        DimensionModel dimModel2 = new DimensionModel();
        dimModel2.setDim(SysDimensionEnum.BudgetPeriod.getNumber());
        List<List<DimensionModel>> colDimList = Collections.singletonList(Lists.newArrayList((Object[])new DimensionModel[]{dimModel2}));
        this.initRowColDim(rowDimList, colDimList);
        List<DimensionModel> rowDimModelList = rowDimList.get(0);
        String rowDims = rowDimModelList.stream().map(DimensionModel::getDim).collect(Collectors.joining(","));
        this.getModel().setValue(ROW_DIM, (Object)rowDims);
        List<DimensionModel> colDimModelList = colDimList.get(0);
        String colDims = colDimModelList.stream().map(DimensionModel::getDim).collect(Collectors.joining(","));
        this.getModel().setValue(COL_DIM, (Object)colDims);
        ArrayList<String> rowColDim = new ArrayList<String>(2);
        rowColDim.addAll(Arrays.asList(rowDims.split(",")));
        rowColDim.addAll(Arrays.asList(colDims.split(",")));
        AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), canvasId, this.getModelId(), datasetId, AnalysisCanvasEnum.table, rowColDim);
        AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), canvasId, this.getModelId(), datasetId, AnalysisCanvasEnum.table, rowColDim);
    }

    private void initTableData(String canvasId, TableModel tableModel, long datasetId, IModelCacheHelper modelCache, JSONObject views) {
        List colDimList;
        List dimensionList = modelCache.getDimensionList(Long.valueOf(datasetId));
        ArrayList<String> rowColDim = new ArrayList<String>(dimensionList.size());
        List rowDimList = tableModel.getRowDim();
        if (CollectionUtils.isNotEmpty((Collection)rowDimList)) {
            List dimModelList = (List)rowDimList.get(0);
            String dims = dimModelList.stream().map(DimensionModel::getDim).collect(Collectors.joining(","));
            this.getModel().setValue(ROW_DIM, (Object)dims);
            rowColDim.addAll(Arrays.asList(dims.split(",")));
        }
        if (CollectionUtils.isNotEmpty((Collection)(colDimList = tableModel.getColDim()))) {
            List dimModelList = (List)colDimList.get(0);
            String dims = dimModelList.stream().map(DimensionModel::getDim).collect(Collectors.joining(","));
            this.getModel().setValue(COL_DIM, (Object)dims);
            rowColDim.addAll(Arrays.asList(dims.split(",")));
        }
        AnalysisCanvasUserSelHelper.putDimMemAndViewToPageCache(this.getView(), modelCache, IDUtils.toLong((Object)canvasId), datasetId, tableModel.getDims(), views, AnalysisCanvasEnum.table, rowColDim);
        AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), datasetId, AnalysisCanvasEnum.table, rowColDim);
    }

    private void initRowColEntry(long modelId, long datasetId, String itemJson, boolean initFlag) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"emptytab"});
        String pageId = "eb_analysiscanvas_t2entry_" + this.getView().getPageId() + "_" + System.currentTimeMillis();
        this.cachePageId(this.getPageCache(), "eb_analysiscanvas_t2entry", pageId);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_analysiscanvas_t2entry");
        showParameter.setPageId(pageId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("partitionpanel");
        showParameter.setCustomParam("model", (Object)modelId);
        showParameter.setCustomParam("dataset", (Object)datasetId);
        if (initFlag) {
            String rowDimValue = this.getModel().getValue(ROW_DIM) == null ? "" : this.getModel().getValue(ROW_DIM).toString();
            String colDimValue = this.getModel().getValue(COL_DIM) == null ? "" : this.getModel().getValue(COL_DIM).toString();
            List rowDim = Arrays.stream(rowDimValue.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            List colDim = Arrays.stream(colDimValue.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            showParameter.setCustomParam("rowDim", rowDim);
            showParameter.setCustomParam("colDim", colDim);
        } else {
            showParameter.setCustomParam("customItem", (Object)itemJson);
        }
        this.getPageCache().put(SUB_PAGE_ID, pageId);
        this.getView().showForm(showParameter);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok", "btn_cancel", "dimmember", "dimselect"});
        BasedataEdit model = (BasedataEdit)this.getControl("model");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dataSet = (BasedataEdit)this.getControl("dataset");
        dataSet.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        AnalysisCanvasPluginHelper.beforeF7Select(e, this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("dataset".equals(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldVal = (DynamicObject)e.getChangeSet()[0].getOldValue();
            if (newVal != null && oldVal != null) {
                String dataSetId = newVal.getString("id");
                this.getPageCache().put("dataset", dataSetId);
                AnalysisCanvasPluginHelper.clearDimViewInPageCache("dimension_view", this.getView());
                AnalysisCanvasUserSelHelper.refreshUserSelByDataset(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), this.getModelId(), IDUtils.toLong((Object)dataSetId));
                AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), this.getModelId(), IDUtils.toLong((Object)dataSetId), AnalysisCanvasEnum.table, Collections.emptyList());
                this.getModel().setValue(ROW_DIM, null);
                this.getModel().setValue(COL_DIM, null);
                this.getModel().deleteEntryData("entryentity");
                this.initRowColDim(null, null);
                this.setDefaultRowColDim(IDUtils.toLong((Object)this.getPageCache().get("canvasId")), IDUtils.toLong((Object)dataSetId));
                this.initRowColEntry(this.getModelId(), IDUtils.toLong((Object)dataSetId), "", true);
            } else {
                this.getModel().setValue("dataset", (Object)this.getPageCache().get("dataset"));
            }
        } else if ("model".equals(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newVal != null) {
                String modelId = newVal.getString("id");
                this.getPageCache().put("model", modelId);
                String datasetId = AnalysisCanvasUserSelHelper.getDataset(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), IDUtils.toLong((Object)modelId));
                this.getModel().setValue("dataset", (Object)datasetId);
            } else {
                this.getModel().setValue("model", (Object)String.valueOf(this.getModelId()));
            }
        } else if (ROW_DIM.equals(key)) {
            this.rebuildRowColDim(true);
        } else if (COL_DIM.equals(key)) {
            this.rebuildRowColDim(false);
        } else if ("dimmember".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                String dimNumber = this.getCurrEntryDim(rowIndex);
                this.getPageCache().remove(dimNumber + "_select");
            }
        } else if ("dimselect".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                this.getPageCache().remove("dimselect" + this.getCurrEntryDim(rowIndex));
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimmember"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimmember"});
            }
        } else if ("dimmemberismulti".equals(key)) {
            Boolean oldVal;
            Boolean newVal = (Boolean)e.getChangeSet()[0].getNewValue();
            if (newVal.equals(oldVal = (Boolean)e.getChangeSet()[0].getOldValue())) {
                return;
            }
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (!newVal.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimselect"});
                this.getModel().setValue("dimselect", null, rowIndex);
                this.getModel().setValue("dimmember", null, rowIndex);
                String currEntryDim = this.getCurrEntryDim(rowIndex);
                this.getPageCache().remove(currEntryDim + "_select");
                this.getPageCache().remove("dimselect" + currEntryDim);
            } else {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimselect"});
            }
        }
    }

    @Override
    public Long getModelId() {
        return AnalysisCanvasPluginHelper.getModelId(this.getView());
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String ctrlKey = ctrl.getKey();
        if ("btn_ok".equals(ctrlKey)) {
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("event", "ok");
            returnMap.put("data", (String)this.buildTabModel());
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        } else if ("btn_cancel".equals(ctrlKey)) {
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("event", "cancel");
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        } else if ("dimmember".equals(ctrlKey)) {
            String dimNumber = this.getCurrEntryDim(null);
            boolean isMulti = this.getCurrEntryIsMulti();
            this.openDimSelect(dimNumber, !isMulti);
        } else if ("dimselect".equals(ctrlKey)) {
            String dimNumber = this.getCurrEntryDim(null);
            boolean isMulti = this.getCurrEntryIsMulti();
            if (!isMulti) {
                return;
            }
            String relateId = this.getPageCache().get("dimselect" + dimNumber);
            this.openDropdownConfig(dimNumber, relateId);
        }
    }

    private void openDropdownConfig(String dimNumber, String relateId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("eb_analysiscanvas_select");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dropdownConfigCloseCallback"));
        fsp.setCustomParam("name", (Object)((CustomItem)JSON.parseObject((String)this.getPageCache().get("customItem"), CustomItem.class)).getName());
        fsp.setCustomParam("canvasId", (Object)this.getPageCache().get("canvasId"));
        fsp.setCustomParam("dataset", (Object)this.getPageCache().get("dataset"));
        fsp.setCustomParam("model", (Object)this.getModelId());
        fsp.setCustomParam("dimNumber", (Object)dimNumber);
        fsp.setCustomParam("relateId", (Object)relateId);
        this.getView().showForm(fsp);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("memberCloseCallback".equals(actionId)) {
            this.cacheSelectedDim(actionId, evt);
        }
        if ("dropdownConfigCloseCallback".equals(actionId)) {
            AnalysisCanvasPluginHelper.setSelectedDim(evt, this.getView(), AnalysisCanvasEnum.table);
        }
    }

    private void cacheSelectedDim(String actionId, ClosedCallBackEvent evt) {
        if (evt.getReturnData() == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<TextEditSelectItem> list = new ArrayList<TextEditSelectItem>();
        AnalysisCanvasPluginHelper.buildSelectF7ReturnValue(sb, list, evt, "dimension_view", this.getView());
        if ("memberCloseCallback".equals(actionId)) {
            String dimNumber = this.getCurrEntryDim(null);
            this.getModel().setValue("dimmember", (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), this.getCurrEntryRow());
            this.getPageCache().put(dimNumber + "_select", JSON.toJSONString(list));
        }
    }

    private void openDimSelect(String dimNumber, boolean singleSelect) {
        Long modelId = this.getModelId();
        Long dataSetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModelId = modelCache.getBusModelByDataSet(dataSetId);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("dataset", "=", (Object)dataSetId));
        } else if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("datatype", "in", (Object)Lists.newArrayList((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex(), MetricDataTypeEnum.RATE.getIndex()})));
        }
        long viewId = AnalysisCanvasPluginHelper.getViewId(modelId, dataSetId, dimNumber, "dimension_view", this.getView());
        String selectItemStr = this.getPageCache().get(dimNumber + "_select");
        if (singleSelect) {
            AnalysisCanvasPluginHelper.openNewF7(modelId, dataSetId, dimNumber, viewId, "memberCloseCallback", qFilters, selectItemStr, this.getView(), (IFormPlugin)this);
        } else {
            AnalysisCanvasPluginHelper.openCustomF7Range(modelId, bizModelId, dataSetId, dimNumber, viewId, "memberCloseCallback", qFilters, selectItemStr, this.getView(), (IFormPlugin)this);
        }
    }

    private void initRowColDim(List<List<DimensionModel>> rowDim, List<List<DimensionModel>> colDim) {
        Set<String> rowDimNumber = Collections.emptySet();
        Set<String> colDimNumber = Collections.emptySet();
        if (rowDim != null && rowDim.size() > 0) {
            rowDimNumber = rowDim.get(0).stream().map(DimensionModel::getDim).collect(Collectors.toSet());
        }
        if (colDim != null && colDim.size() > 0) {
            colDimNumber = colDim.get(0).stream().map(DimensionModel::getDim).collect(Collectors.toSet());
        }
        this.rebuildRowCombo(colDimNumber);
        this.rebuildColCombo(rowDimNumber);
    }

    private void rebuildRowCombo(Set<String> excludeDims) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List dimensionList = modelCache.getDimensionList(IDUtils.toLong((Object)this.getPageCache().get("dataset")));
        ComboEdit rowComboEdit = (ComboEdit)this.getControl(ROW_DIM);
        ArrayList data = new ArrayList();
        dimensionList.stream().filter(dim -> !SysDimensionEnum.Metric.getNumber().equals(dim.getNumber()) && !excludeDims.contains(dim.getNumber())).forEach(dim -> data.add(new ComboItem(new LocaleString(dim.getName()), dim.getNumber())));
        rowComboEdit.setComboItems(data);
    }

    private void rebuildColCombo(Set<String> excludeDims) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List dimensionList = modelCache.getDimensionList(IDUtils.toLong((Object)this.getPageCache().get("dataset")));
        ComboEdit rowComboEdit = (ComboEdit)this.getControl(COL_DIM);
        ArrayList data = new ArrayList();
        dimensionList.stream().filter(dim -> !SysDimensionEnum.Metric.getNumber().equals(dim.getNumber()) && !excludeDims.contains(dim.getNumber())).forEach(dim -> data.add(new ComboItem(new LocaleString(dim.getName()), dim.getNumber())));
        rowComboEdit.setComboItems(data);
    }

    private void rebuildRowColDim(Boolean rowChange) {
        String rowDimValue = this.getModel().getValue(ROW_DIM) == null ? "" : this.getModel().getValue(ROW_DIM).toString();
        String colDimValue = this.getModel().getValue(COL_DIM) == null ? "" : this.getModel().getValue(COL_DIM).toString();
        Set<String> rowSet = Arrays.stream(rowDimValue.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toCollection(LinkedHashSet::new));
        Set<String> colSet = Arrays.stream(colDimValue.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toCollection(LinkedHashSet::new));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List dimensionList = modelCache.getDimensionList(IDUtils.toLong((Object)this.getPageCache().get("dataset")));
        Set dimNumberSet = dimensionList.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
        rowSet = rowSet.stream().filter(dimNumberSet::contains).collect(Collectors.toSet());
        colSet = colSet.stream().filter(dimNumberSet::contains).collect(Collectors.toSet());
        ArrayList<Object> rowList = new ArrayList(16);
        ArrayList<Object> colList = new ArrayList(16);
        if (rowChange.booleanValue()) {
            rowList = new ArrayList(rowSet);
            Sets.SetView newColSet = Sets.difference(colSet, rowSet);
            String newColDimValue = "";
            if (CollectionUtils.isNotEmpty((Collection)newColSet)) {
                colList = new ArrayList(newColSet);
                newColDimValue = String.join((CharSequence)",", (Iterable<? extends CharSequence>)newColSet);
            }
            if (!newColDimValue.equals(colDimValue)) {
                this.getModel().setValue(COL_DIM, (Object)newColDimValue);
            }
            this.rebuildColCombo(rowSet);
        } else {
            colList = new ArrayList(colSet);
            Sets.SetView newRowSet = Sets.difference(rowSet, colSet);
            String newRowDimValue = "";
            if (CollectionUtils.isNotEmpty((Collection)newRowSet)) {
                rowList = new ArrayList(newRowSet);
                newRowDimValue = String.join((CharSequence)",", (Iterable<? extends CharSequence>)newRowSet);
            }
            if (!newRowDimValue.equals(colDimValue)) {
                this.getModel().setValue(ROW_DIM, (Object)newRowDimValue);
            }
            this.rebuildRowCombo(colSet);
        }
        ArrayList<String> rowColList = new ArrayList<String>(rowList);
        rowColList.addAll(colList);
        AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), this.getModelId(), IDUtils.toLong((Object)this.getPageCache().get("dataset")), AnalysisCanvasEnum.table, rowColList);
        JSONObject param = new JSONObject();
        param.fluentPut("rowDim", rowList).fluentPut("colDim", colList);
        this.sendSubPlugin(OPT_ROWCOL_CHANGE, param);
    }

    private String getCurrEntryDim(Integer rowIndex) {
        if (rowIndex == null) {
            rowIndex = this.getCurrEntryRow();
        }
        DynamicObject row = this.getModel().getEntryRowEntity("entryentity", rowIndex.intValue());
        return row.getString("dimnumber");
    }

    private int getCurrEntryRow() {
        return this.getModel().getEntryCurrentRowIndex("entryentity");
    }

    private Boolean getCurrEntryIsMulti() {
        DynamicObject row = this.getModel().getEntryRowEntity("entryentity", this.getCurrEntryRow());
        return row.getBoolean("dimmemberismulti");
    }

    private TableModel buildTabModel() {
        Object rowDim = this.getModel().getValue(ROW_DIM);
        if (rowDim == null || CollectionUtils.isEmpty((Collection)Arrays.stream(rowDim.toString().split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toList()))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u5206\u533a\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasTable2ConfigPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Object colDim = this.getModel().getValue(COL_DIM);
        if (colDim == null || CollectionUtils.isEmpty((Collection)Arrays.stream(colDim.toString().split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toList()))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5217\u5206\u533a\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasTable2ConfigPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        String datasetId = this.getPageCache().get("dataset");
        String canvasId = this.getPageCache().get("canvasId");
        String boxId = this.getPageCache().get("usedBoxId");
        JSONObject dimensionViews = AnalysisCanvasPluginHelper.getDimensionView("dimension_view", this.getView());
        dimensionViews.entrySet().removeIf(entry -> ((String)entry.getKey()).contains(F_SPLIT_CHAR));
        this.mergeChildPluginView(dimensionViews);
        ModelHelper.checkViewIdExisted((JSONObject)dimensionViews);
        List<DimensionModel> dimModels = AnalysisCanvasPluginHelper.buildDimensionModel(this.getView(), modelCache, dimensionViews, datasetId, AnalysisCanvasEnum.table);
        TableModel tableModel = new TableModel();
        tableModel.setModel(String.valueOf(this.getModelId()));
        tableModel.setDataset(datasetId);
        tableModel.setDims(dimModels);
        tableModel.setRowDim(this.buildRowColDim(ROW_ENTRY));
        tableModel.setColDim(this.buildRowColDim(COL_ENTRY));
        tableModel.setMeta(null);
        tableModel.setData(null);
        tableModel.setShow(Boolean.valueOf(true));
        tableModel.setAdd(Boolean.valueOf(false));
        tableModel.setEdit(Boolean.valueOf(false));
        tableModel.setDimensionViews(dimensionViews);
        AnalysisCubeService.getInstance().getAnalysisDataset(IDUtils.toLong((Object)canvasId).longValue(), IDUtils.toLong((Object)boxId).longValue(), IDUtils.toLong((Object)datasetId).longValue());
        return tableModel;
    }

    private void mergeChildPluginView(JSONObject dimensionViews) {
        String rowDimValue = this.getModel().getValue(ROW_DIM).toString();
        String colDimValue = this.getModel().getValue(COL_DIM).toString();
        Set rowSet = Arrays.stream(rowDimValue.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        Set colSet = Arrays.stream(colDimValue.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        HashSet rowColSet = new HashSet(rowSet.size() + colSet.size());
        rowColSet.addAll(rowSet);
        rowColSet.addAll(colSet);
        HashSet removeKeys = new HashSet(dimensionViews.size());
        dimensionViews.keySet().forEach(k -> {
            if (!k.contains(F_SPLIT_CHAR)) {
                return;
            }
            String dimNumber = k.split(F_SPLIT_CHAR)[0];
            if (rowColSet.contains(dimNumber)) {
                removeKeys.add(k);
            }
        });
        removeKeys.forEach(arg_0 -> ((JSONObject)dimensionViews).remove(arg_0));
        JSONArray rowVoCache = TableHelper.getRowColVoCache(ROW_ENTRY, this.getChildView());
        for (int i = 0; i < rowVoCache.size(); ++i) {
            JSONObject jsonObject = rowVoCache.getJSONObject(i);
            for (Map.Entry entry : jsonObject.entrySet()) {
                String dimNumber = (String)entry.getKey();
                if (!rowColSet.contains(dimNumber)) continue;
                TableHelper.RowColVo rowColVo = (TableHelper.RowColVo)((JSONObject)entry.getValue()).toJavaObject(TableHelper.RowColVo.class);
                if (rowColVo.viewId == null) continue;
                dimensionViews.put(dimNumber + F_SPLIT_CHAR + i, (Object)String.valueOf(rowColVo.viewId));
            }
        }
        JSONArray colVoCache = TableHelper.getRowColVoCache(COL_ENTRY, this.getChildView());
        for (int i = 0; i < colVoCache.size(); ++i) {
            JSONObject jsonObject = colVoCache.getJSONObject(i);
            for (Map.Entry entry : jsonObject.entrySet()) {
                String dimNumber = (String)entry.getKey();
                if (!rowColSet.contains(dimNumber)) continue;
                TableHelper.RowColVo rowColVo = (TableHelper.RowColVo)((JSONObject)entry.getValue()).toJavaObject(TableHelper.RowColVo.class);
                if (rowColVo.viewId == null) continue;
                dimensionViews.put(dimNumber + F_SPLIT_CHAR + i, (Object)String.valueOf(rowColVo.viewId));
            }
        }
    }

    private List<List<DimensionModel>> buildRowColDim(String entryKey) {
        List dimList;
        IFormView childView = this.getChildView();
        String entryName = ROW_ENTRY.equals(entryKey) ? ResManager.loadKDString((String)"\u884c\u5206\u533a", (String)"AnalysisCanvasTable2ConfigPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5217\u5206\u533a", (String)"AnalysisCanvasTable2ConfigPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        EntryGrid entryGrid = (EntryGrid)childView.getControl(entryKey);
        IDataModel dataModel = entryGrid.getModel();
        int entryRowCount = dataModel.getEntryRowCount(entryKey);
        if (entryRowCount <= 0) {
            if (ROW_ENTRY.equals(entryKey)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u884c\u5206\u533a\u6570\u636e\u3002", (String)"AnalysisCanvasTable2ConfigPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u5217\u5206\u533a\u6570\u636e\u3002", (String)"AnalysisCanvasTable2ConfigPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (ROW_ENTRY.equals(entryKey)) {
            String rowDimValue = this.getModel().getValue(ROW_DIM) == null ? "" : this.getModel().getValue(ROW_DIM).toString();
            dimList = Arrays.stream(rowDimValue.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        } else {
            String colDimValue = this.getModel().getValue(COL_DIM) == null ? "" : this.getModel().getValue(COL_DIM).toString();
            dimList = Arrays.stream(colDimValue.split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        long datasetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
        JSONArray rowColVoCacheList = TableHelper.getRowColVoCache(entryKey, this.getChildView());
        ArrayList<List<DimensionModel>> dimModelListArr = new ArrayList<List<DimensionModel>>(entryRowCount);
        for (int rowIndex = 0; rowIndex < entryRowCount; ++rowIndex) {
            JSONObject rowColVoCache = rowColVoCacheList.getJSONObject(rowIndex);
            ArrayList<DimensionModel> dimModelList = new ArrayList<DimensionModel>(dimList.size());
            for (String dimNumber : dimList) {
                Object cacheObj = rowColVoCache.get((Object)dimNumber);
                if (cacheObj == null) {
                    String dimName = modelCache.getDimension(dimNumber).getName();
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e%1$s\uff1a%2$s\u7684\u7ef4\u5ea6\u6210\u5458\u3002", (String)"AnalysisCanvasTable2ConfigPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), entryName, dimName));
                }
                TableHelper.RowColVo rowColVo = (TableHelper.RowColVo)((JSONObject)cacheObj).toJavaObject(TableHelper.RowColVo.class);
                List<TextEditSelectItem> selectItemList = rowColVo.getSelectItemList();
                if (CollectionUtils.isEmpty(selectItemList)) {
                    String dimName = modelCache.getDimension(dimNumber).getName();
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e%1$s\uff1a%2$s\u7684\u7ef4\u5ea6\u6210\u5458\u3002", (String)"AnalysisCanvasTable2ConfigPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]), entryName, dimName));
                }
                List memberModels = selectItemList.stream().map(s -> {
                    AnalysisCanvasPluginHelper.checkDimension(modelCache, datasetId, dimNumber, IDUtils.toLong((Object)rowColVo.getViewId()), s.getNumber());
                    MemberModel memberModel = new MemberModel();
                    memberModel.setNum(s.getNumber());
                    memberModel.setScope(Integer.valueOf(Integer.parseInt(s.getScope())));
                    return memberModel;
                }).collect(Collectors.toList());
                DimensionModel dimModel = new DimensionModel();
                dimModel.setDim(dimNumber);
                dimModel.setS(Boolean.valueOf(true));
                dimModel.setMems(memberModels);
                dimModelList.add(dimModel);
            }
            dimModelListArr.add(dimModelList);
        }
        return dimModelListArr;
    }

    private IFormView getChildView() {
        String pageId = this.getPageCache().get(SUB_PAGE_ID);
        return this.getView().getView(pageId);
    }

    private void sendSubPlugin(String operation, JSONObject param) {
        CommandParam cmd = new CommandParam("eb_analysiscanvas_table2", "eb_analysiscanvas_t2entry", operation, new Object[]{param});
        this.sendMsg(this.getView(), cmd);
    }
}

