/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas.table;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.TableModel;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.pageinteraction.CommandParam;
import kd.epm.eb.common.pageinteraction.SubPage;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasControlHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasEntryHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasUserSelHelper;
import kd.epm.eb.formplugin.analysiscanvas.table.AnalysisCanvasTable2ConfigPlugin;
import kd.epm.eb.formplugin.analysiscanvas.table.TableHelper;
import kd.epm.eb.formplugin.qinganalysis.model.TextEditSelectItem;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AnalysisCanvasTable2EntryPlugin
extends AbstractBasePlugin
implements ClickListener,
SubPage {
    private static final String F_ROW_FLAG = "row";
    private static final String F_COL_FLAG = "col";
    private static final String CLOSE_CALLBACK_MEMBER_ROW = "rowMemberCloseCallback";
    private static final String CLOSE_CALLBACK_MEMBER_COL = "colMemberCloseCallback";
    private static final String BTN_ROW_COPY = "row_copy";
    private static final String BTN_COL_COPY = "col_copy";

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"rowentry"});
        this.getView().addCustomControls(new String[]{"colentry"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        long modelId = IDUtils.toLong((Object)formShowParameter.getCustomParam("model"));
        long datasetId = IDUtils.toLong((Object)formShowParameter.getCustomParam("dataset"));
        this.getPageCache().put("model", String.valueOf(modelId));
        this.getPageCache().put("dataset", String.valueOf(datasetId));
        this.initEntry(datasetId);
        List rowDimList = (List)formShowParameter.getCustomParam("rowDim");
        List colDimList = (List)formShowParameter.getCustomParam("colDim");
        if (rowDimList != null && colDimList != null) {
            this.setRowColDimVisible(rowDimList, colDimList);
        } else {
            this.buildEntry(datasetId, (String)formShowParameter.getCustomParam("customItem"));
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_ROW_COPY, BTN_COL_COPY});
    }

    private void initEntry(long datasetId) {
        EntryAp rowEntryAp = AnalysisCanvasEntryHelper.createEntry("rowentry");
        EntryAp colEntryAp = AnalysisCanvasEntryHelper.createEntry("colentry");
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List dimensionList = modelCache.getDimensionList(Long.valueOf(datasetId));
        ArrayList<String> rowFieldKeys = new ArrayList<String>(dimensionList.size());
        ArrayList<String> colFieldKeys = new ArrayList<String>(dimensionList.size());
        for (Dimension dim : dimensionList) {
            String rowFieldKey = this.getRowFieldKey(dim.getNumber());
            AnalysisCanvasEntryHelper.createEntryTextFieldAp(rowEntryAp, rowFieldKey, dim.getName(), "default");
            String colFieldKey = this.getColFieldKey(dim.getNumber());
            AnalysisCanvasEntryHelper.createEntryTextFieldAp(colEntryAp, colFieldKey, dim.getName(), "default");
            rowFieldKeys.add(rowFieldKey);
            colFieldKeys.add(colFieldKey);
        }
        AnalysisCanvasEntryHelper.updateEntry(rowEntryAp, this.getView());
        AnalysisCanvasEntryHelper.updateEntry(colEntryAp, this.getView());
        this.registerDynamicProps(null);
        this.getView().setVisible(Boolean.FALSE, rowFieldKeys.toArray(new String[0]));
        this.getView().setVisible(Boolean.FALSE, colFieldKeys.toArray(new String[0]));
    }

    private void registerDynamicProps(MainEntityType mainEntityType) {
        if (mainEntityType == null) {
            mainEntityType = this.getModel().getDataEntityType();
        }
        if (StringUtils.isBlank((CharSequence)this.getPageCache().get("dataset"))) {
            return;
        }
        long datasetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List dimensionList = modelCache.getDimensionList(Long.valueOf(datasetId));
        EntryType rowEntryType = (EntryType)mainEntityType.getAllEntities().get("rowentry");
        rowEntryType.createPropIndexs();
        rowEntryType.setDbIgnore(true);
        EntryType colEntryType = (EntryType)mainEntityType.getAllEntities().get("colentry");
        colEntryType.createPropIndexs();
        colEntryType.setDbIgnore(true);
        for (Dimension dim : dimensionList) {
            AnalysisCanvasEntryHelper.registerSimpleProp((EntityType)rowEntryType, this.getRowFieldKey(dim.getNumber()));
            AnalysisCanvasEntryHelper.registerSimpleProp((EntityType)colEntryType, this.getColFieldKey(dim.getNumber()));
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            MainEntityType newEntityType = (MainEntityType)e.getOriginalEntityType().clone();
            this.registerDynamicProps(newEntityType);
            e.setNewEntityType(newEntityType);
        }
        catch (CloneNotSupportedException ex) {
            throw new KDException((Throwable)ex, new ErrorCode("getEntityType", ex.getMessage()), new Object[0]);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        String ctrlKey = e.getKey();
        if (ctrlKey.indexOf(AnalysisCanvasTable2ConfigPlugin.F_SPLIT_CHAR + F_ROW_FLAG) > 0 || ctrlKey.indexOf(AnalysisCanvasTable2ConfigPlugin.F_SPLIT_CHAR + F_COL_FLAG) > 0) {
            String entryKey = ctrlKey.indexOf(AnalysisCanvasTable2ConfigPlugin.F_SPLIT_CHAR + F_ROW_FLAG) > 0 ? "rowentry" : "colentry";
            TextEdit edit = AnalysisCanvasEntryHelper.createEntryTextCtl(ctrlKey, entryKey, this.getModel(), this.getView());
            edit.addClickListener((ClickListener)this);
            e.setControl((Control)edit);
        } else if ("rowentry".equals(ctrlKey) || "colentry".equals(ctrlKey)) {
            EntryGrid entryGrid = (EntryGrid)e.getControl();
            if (entryGrid == null) {
                return;
            }
            long datasetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
            List dimensionList = modelCache.getDimensionList(Long.valueOf(datasetId));
            entryGrid.getItems().clear();
            for (Dimension dim : dimensionList) {
                String fieldKey = "rowentry".equals(ctrlKey) ? this.getRowFieldKey(dim.getNumber()) : this.getColFieldKey(dim.getNumber());
                TextEdit colEdit = AnalysisCanvasEntryHelper.createEntryTextCtl(fieldKey, ctrlKey, entryGrid.getModel(), this.getView());
                entryGrid.getItems().add(colEdit);
            }
        }
    }

    private void buildEntry(long datasetId, String itemJson) {
        CustomItem customItem = (CustomItem)JSON.parseObject((String)itemJson, CustomItem.class);
        JSONObject tableModelJson = customItem.getC().getJSONObject("tableModel");
        if (tableModelJson == null || AnalysisCanvasControlHelper.isAdd(customItem).booleanValue()) {
            return;
        }
        TableModel tableModel = (TableModel)tableModelJson.toJavaObject(TableModel.class);
        long modelDatasetId = IDUtils.toLong((Object)tableModel.getDataset());
        if (datasetId != modelDatasetId) {
            return;
        }
        JSONObject dimensionViews = tableModel.getDimensionViews();
        if (dimensionViews == null) {
            dimensionViews = new JSONObject();
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List rowDimList = tableModel.getRowDim();
        this.setEntryData(modelCache, rowDimList, dimensionViews, "rowentry");
        List colDimList = tableModel.getColDim();
        this.setEntryData(modelCache, colDimList, dimensionViews, "colentry");
    }

    private void setEntryData(IModelCacheHelper modelCache, List<List<DimensionModel>> dimList, JSONObject dimensionViews, String entryKey) {
        IDataModel dataModel = this.getControl(entryKey).getModel();
        HashSet<String> fieldKeys = new HashSet<String>(16);
        dataModel.batchCreateNewEntryRow(entryKey, dimList.size());
        TableHelper.createNewCache(entryKey, dimList.size(), this.getView());
        for (int entryIndex = 0; entryIndex < dimList.size(); ++entryIndex) {
            List<DimensionModel> dimModelList = dimList.get(entryIndex);
            for (DimensionModel dimModel : dimModelList) {
                String dimNumber = dimModel.getDim();
                Long viewId = dimensionViews.getLong(dimNumber + AnalysisCanvasTable2ConfigPlugin.F_SPLIT_CHAR + entryIndex);
                List<TextEditSelectItem> selectItems = AnalysisCanvasUserSelHelper.dimensionToText(modelCache, dimModel, viewId);
                TableHelper.cacheRowColVo(entryKey, entryIndex, dimNumber, viewId, selectItems, this.getView());
                StringBuilder sb = AnalysisCanvasUserSelHelper.buildDimMembersName(selectItems, modelCache, dimNumber, viewId);
                String fieldKey = "rowentry".equals(entryKey) ? this.getRowFieldKey(dimNumber) : this.getColFieldKey(dimNumber);
                dataModel.setValue(fieldKey, (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), entryIndex);
                fieldKeys.add(fieldKey);
            }
        }
        this.getView().setVisible(Boolean.TRUE, fieldKeys.toArray(new String[0]));
        this.getView().updateView(entryKey);
    }

    @Override
    public Long getModelId() {
        return AnalysisCanvasPluginHelper.getModelId(this.getView());
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String ctrlKey = ctrl.getKey();
        if (ctrlKey.startsWith("dimmember")) {
            String[] split = ctrlKey.split(AnalysisCanvasTable2ConfigPlugin.F_SPLIT_CHAR);
            String fieldFlag = split[1];
            String fieldNumber = split[2];
            String dimNumber = this.getDimNumberByField(fieldNumber);
            this.openDimSelect(dimNumber, fieldFlag.equals(F_ROW_FLAG) ? "rowentry" : "colentry");
        } else if (BTN_ROW_COPY.equals(ctrlKey)) {
            this.copyEntryRow("rowentry");
        } else if (BTN_COL_COPY.equals(ctrlKey)) {
            this.copyEntryRow("colentry");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String newVal;
        super.propertyChanged(e);
        String ctrlKey = e.getProperty().getName();
        if (ctrlKey.startsWith("dimmember") && StringUtils.isBlank((CharSequence)(newVal = (String)e.getChangeSet()[0].getNewValue()))) {
            String[] split = ctrlKey.split(AnalysisCanvasTable2ConfigPlugin.F_SPLIT_CHAR);
            String fieldFlag = split[1];
            String fieldNumber = split[2];
            String dimNumber = this.getDimNumberByField(fieldNumber);
            String entryKey = fieldFlag.equals(F_ROW_FLAG) ? "rowentry" : "colentry";
            int currEntryRow = this.getCurrEntryRow(entryKey);
            JSONArray rowColVoCache = TableHelper.getRowColVoCache(entryKey, this.getView());
            JSONObject jsonObject = rowColVoCache.getJSONObject(currEntryRow);
            jsonObject.remove((Object)dimNumber);
            TableHelper.cacheRowColVo(entryKey, rowColVoCache, this.getView());
        }
    }

    private String getDimNumberByField(String fieldNumber) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List dimensionList = modelCache.getDimensionList(IDUtils.toLong((Object)this.getPageCache().get("dataset")));
        for (Dimension dimension : dimensionList) {
            if (!dimension.getNumber().equalsIgnoreCase(fieldNumber)) continue;
            return dimension.getNumber();
        }
        return "";
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (CLOSE_CALLBACK_MEMBER_ROW.equals(actionId) || CLOSE_CALLBACK_MEMBER_COL.equals(actionId)) {
            this.cacheSelectedDim(actionId, evt);
        }
    }

    private void cacheSelectedDim(String actionId, ClosedCallBackEvent evt) {
        IDataModel dataModel;
        int currEntryIndex;
        String fieldKey;
        String entryKey;
        if (evt.getReturnData() == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<TextEditSelectItem> selectItemList = new ArrayList<TextEditSelectItem>();
        Pair<String, Long> pair = AnalysisCanvasPluginHelper.buildSelectF7ReturnValue(sb, selectItemList, evt, "dimension_view", this.getView());
        String dimNumber = (String)pair.getLeft();
        Long viewId = (Long)pair.getRight();
        if (CLOSE_CALLBACK_MEMBER_ROW.equals(actionId)) {
            entryKey = "rowentry";
            fieldKey = this.getRowFieldKey(dimNumber);
            currEntryIndex = this.getCurrEntryRow("rowentry");
            dataModel = this.getControl("rowentry").getModel();
        } else if (CLOSE_CALLBACK_MEMBER_COL.equals(actionId)) {
            entryKey = "colentry";
            fieldKey = this.getColFieldKey(dimNumber);
            currEntryIndex = this.getCurrEntryRow("colentry");
            dataModel = this.getControl("colentry").getModel();
        } else {
            return;
        }
        dataModel.setValue(fieldKey, (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), currEntryIndex);
        TableHelper.cacheRowColVo(entryKey, currEntryIndex, dimNumber, viewId, selectItemList, this.getView());
        this.getView().updateView(entryKey);
    }

    private int getCurrEntryRow(String entryKey) {
        return this.getModel().getEntryCurrentRowIndex(entryKey);
    }

    private void openDimSelect(String dimNumber, String entryKey) {
        Long modelId = this.getModelId();
        Long dataSetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModelId = modelCache.getBusModelByDataSet(dataSetId);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("dataset", "=", (Object)dataSetId));
        } else if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("datatype", "in", (Object)Lists.newArrayList((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex(), MetricDataTypeEnum.RATE.getIndex()})));
        }
        int currEntryRow = this.getCurrEntryRow(entryKey);
        long viewId = 0L;
        String selectItemStr = "";
        TableHelper.RowColVo rowColVo = TableHelper.getRowColVo(entryKey, currEntryRow, dimNumber, this.getView());
        if (rowColVo != null) {
            viewId = IDUtils.toLong((Object)rowColVo.viewId);
            selectItemStr = JSON.toJSONString(rowColVo.selectItemList);
        }
        String callback = "rowentry".equals(entryKey) ? CLOSE_CALLBACK_MEMBER_ROW : CLOSE_CALLBACK_MEMBER_COL;
        RangeEnum defaultRange = "rowentry".equals(entryKey) ? null : RangeEnum.ONLY;
        AnalysisCanvasPluginHelper.openCustomF7Range(modelId, bizModelId, dataSetId, dimNumber, viewId, callback, qFilters, selectItemStr, this.getView(), (IFormPlugin)this, defaultRange);
    }

    private void copyEntryRow(String entryKey) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AnalysisCanvasTable2ConfigPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        IDataModel dataModel = entryGrid.getModel();
        int start = dataModel.getEntryRowCount(entryKey);
        dataModel.copyEntryRow(entryKey, selectRows, true);
        EntryProp entityProp = (EntryProp)dataModel.getProperty(entryKey);
        EntryType entryType = (EntryType)entityProp.getDynamicCollectionItemPropertyType();
        Map entityFields = entryType.getFields();
        for (int i = 0; i < selectRows.length; ++i) {
            int oldRowIndex = selectRows[i];
            int newRowIndex = start + i;
            for (Map.Entry fieldEntry : entityFields.entrySet()) {
                String fieldKey = (String)fieldEntry.getKey();
                String[] split = fieldKey.split(AnalysisCanvasTable2ConfigPlugin.F_SPLIT_CHAR);
                String fieldNumber = split[2];
                String dimNumber = this.getDimNumberByField(fieldNumber);
                dataModel.setValue(fieldKey, dataModel.getValue(fieldKey, oldRowIndex), newRowIndex);
                TableHelper.RowColVo rowColVo = TableHelper.getRowColVo(entryKey, oldRowIndex, dimNumber, this.getView());
                if (rowColVo == null) continue;
                TableHelper.cacheRowColVo(entryKey, newRowIndex, dimNumber, rowColVo.viewId, rowColVo.selectItemList, this.getView());
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryKey = e.getEntryProp().getName();
        this.addCacheRowColVo(entryKey);
    }

    private void addCacheRowColVo(String entryKey) {
        JSONArray dimVoCache = TableHelper.getRowColVoCache(entryKey, this.getView());
        dimVoCache.add((Object)new JSONObject());
        TableHelper.cacheRowColVo(entryKey, dimVoCache, this.getView());
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryKey = e.getEntryProp().getName();
        JSONArray dimVoCache = TableHelper.getRowColVoCache(entryKey, this.getView());
        for (int rowIndex : e.getRowIndexs()) {
            dimVoCache.remove(rowIndex);
        }
        TableHelper.cacheRowColVo(entryKey, dimVoCache, this.getView());
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        int[] rowIndexs;
        super.afterMoveEntryUp(e);
        String entryKey = e.getEntryProp().getName();
        for (int rowIndex : rowIndexs = e.getRowIndexs()) {
            JSONArray dimVoCache = TableHelper.getRowColVoCache(entryKey, this.getView());
            Object obj = dimVoCache.remove(rowIndex);
            dimVoCache.add(rowIndex - 1, obj);
            TableHelper.cacheRowColVo(entryKey, dimVoCache, this.getView());
        }
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        int[] rowIndexs;
        super.afterMoveEntryDown(e);
        String entryKey = e.getEntryProp().getName();
        for (int rowIndex : rowIndexs = e.getRowIndexs()) {
            JSONArray dimVoCache = TableHelper.getRowColVoCache(entryKey, this.getView());
            Object obj = dimVoCache.remove(rowIndex);
            dimVoCache.add(rowIndex + 1, obj);
            TableHelper.cacheRowColVo(entryKey, dimVoCache, this.getView());
        }
    }

    public void dealMsg(CommandParam cmd) {
        if ("rowColChange".equals(cmd.getOperation())) {
            JSONObject paramObj = (JSONObject)cmd.getParam().get(0);
            JSONArray rowDimList = paramObj.getJSONArray("rowDim");
            JSONArray colDimList = paramObj.getJSONArray("colDim");
            this.setRowColDimVisible((List<Object>)rowDimList, (List<Object>)colDimList);
        }
    }

    private void setRowColDimVisible(List<Object> rowDimList, List<Object> colDimList) {
        long datasetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List dimensionList = modelCache.getDimensionList(Long.valueOf(datasetId));
        ArrayList<String> rowDimNumList = new ArrayList<String>(dimensionList.size());
        ArrayList<String> colDimNumList = new ArrayList<String>(dimensionList.size());
        for (Dimension dim : dimensionList) {
            rowDimNumList.add(this.getRowFieldKey(dim.getNumber()));
            colDimNumList.add(this.getColFieldKey(dim.getNumber()));
        }
        EntryGrid rowDimEntry = (EntryGrid)this.getControl("rowentry");
        EntryGrid colDimEntry = (EntryGrid)this.getControl("colentry");
        rowDimEntry.getView().setVisible(Boolean.FALSE, rowDimNumList.toArray(new String[0]));
        colDimEntry.getView().setVisible(Boolean.FALSE, colDimNumList.toArray(new String[0]));
        rowDimEntry.getView().setVisible(Boolean.TRUE, (String[])rowDimList.stream().map(dimNum -> this.getRowFieldKey(dimNum.toString())).toArray(String[]::new));
        colDimEntry.getView().setVisible(Boolean.TRUE, (String[])colDimList.stream().map(dimNum -> this.getColFieldKey(dimNum.toString())).toArray(String[]::new));
        if (rowDimEntry.getModel().getEntryRowCount("rowentry") == 0) {
            rowDimEntry.getModel().batchCreateNewEntryRow("rowentry", 1);
            this.addCacheRowColVo("rowentry");
        }
        if (colDimEntry.getModel().getEntryRowCount("colentry") == 0) {
            colDimEntry.getModel().batchCreateNewEntryRow("colentry", 1);
            this.addCacheRowColVo("colentry");
        }
    }

    private String getRowFieldKey(String dimNumber) {
        return "dimmember" + AnalysisCanvasTable2ConfigPlugin.F_SPLIT_CHAR + F_ROW_FLAG + AnalysisCanvasTable2ConfigPlugin.F_SPLIT_CHAR + dimNumber.toLowerCase(Locale.getDefault());
    }

    private String getColFieldKey(String dimNumber) {
        return "dimmember" + AnalysisCanvasTable2ConfigPlugin.F_SPLIT_CHAR + F_COL_FLAG + AnalysisCanvasTable2ConfigPlugin.F_SPLIT_CHAR + dimNumber.toLowerCase(Locale.getDefault());
    }
}

