/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas.table;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.business.analysiscanvas.model.CustomItem;
import kd.epm.eb.business.analysiscanvas.model.DimensionModel;
import kd.epm.eb.business.analysiscanvas.model.ModelHelper;
import kd.epm.eb.business.analysiscanvas.model.TabModel;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.analysiscanvas.constant.AnalysisCanvasEnum;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasControlHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasPluginHelper;
import kd.epm.eb.formplugin.analysiscanvas.helper.AnalysisCanvasUserSelHelper;
import kd.epm.eb.formplugin.qinganalysis.model.TextEditSelectItem;
import kd.epm.eb.olap.analysiscanvas.service.AnalysisCubeService;
import org.apache.commons.lang3.StringUtils;

public class AnalysisCanvasTableConfigPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener,
ClickListener {
    private static final String TAB_DIM = "tabdim";
    private static final String TAB_ENTRY = "tabentryentity";
    private static final String FIELD_TAB_DIM_NAME = "tabdimname";
    private static final String FIELD_TAB_DIM_NUMBER = "tabdimnumber";
    private static final String FIELD_TAB_DIM_MEMBER = "tabdimmember";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.getPageCache().put("customItem", params.get("customItem").toString());
        String canvasId = params.get("canvasId").toString();
        this.getPageCache().put("canvasId", canvasId);
        this.getPageCache().put("usedBoxId", params.get("usedBoxId").toString());
        this.setInitData(canvasId, params);
    }

    private void setInitData(String canvasId, Map<String, Object> params) {
        CustomItem customItem = (CustomItem)JSON.parseObject((String)params.get("customItem").toString(), CustomItem.class);
        JSONObject tabModelJson = customItem.getC().getJSONObject("tabModel");
        if (tabModelJson != null && !AnalysisCanvasControlHelper.isAdd(customItem).booleanValue()) {
            TabModel tabModel = (TabModel)tabModelJson.toJavaObject(TabModel.class);
            Long modelId = IDUtils.toLong((Object)tabModel.getModel());
            Long dataSetId = IDUtils.toLong((Object)tabModel.getDataset());
            this.getPageCache().put("model", String.valueOf(modelId));
            this.getModel().setValue("model", (Object)modelId);
            this.getPageCache().put("dataset", String.valueOf(dataSetId));
            this.getModel().setValue("dataset", (Object)dataSetId);
            JSONObject dimensionViews = tabModel.getDimensionViews();
            if (dimensionViews == null) {
                dimensionViews = new JSONObject();
            }
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
            this.initTabDim();
            this.initTableData(canvasId, tabModel, dataSetId, modelCache, dimensionViews);
        } else {
            String modelId = AnalysisCanvasUserSelHelper.getModel(this.getView());
            String datasetId = AnalysisCanvasUserSelHelper.getDataset(this.getView(), IDUtils.toLong((Object)canvasId), IDUtils.toLong((Object)modelId));
            if (modelId != null) {
                this.getModel().setValue("model", (Object)modelId);
                this.getPageCache().put("model", modelId);
            }
            if (datasetId != null) {
                this.getModel().setValue("dataset", (Object)datasetId);
                this.getPageCache().put("dataset", datasetId);
                this.initTabDim();
                AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), IDUtils.toLong((Object)datasetId), AnalysisCanvasEnum.list, Collections.emptyList());
            }
        }
    }

    private void initTableData(String canvasId, TabModel tabModel, Long dataSetId, IModelCacheHelper modelCache, JSONObject views) {
        this.getModel().setValue(TAB_DIM, (Object)tabModel.getTabDims());
        List dimensionList = modelCache.getDimensionList(dataSetId);
        List<DimensionModel> tabs = Stream.concat(tabModel.getTabs().stream(), tabModel.getDims().stream()).filter(dim -> dimensionList.stream().anyMatch(dimension -> dimension.getNumber().equals(dim.getDim()))).collect(Collectors.toList());
        List<String> ignoreDimNumbers = Arrays.stream(tabModel.getTabDims().split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List<String> ignoreTabDimNumbers = dimensionList.stream().map(BaseCache::getNumber).filter(number -> !ignoreDimNumbers.contains(number)).collect(Collectors.toList());
        AnalysisCanvasUserSelHelper.putDimMemAndViewToPageCache(this.getView(), modelCache, IDUtils.toLong((Object)canvasId), dataSetId, tabs, views, AnalysisCanvasEnum.list, ignoreDimNumbers);
        AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), dataSetId, AnalysisCanvasEnum.listCol, ignoreTabDimNumbers);
        AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)canvasId), this.getModelId(), dataSetId, AnalysisCanvasEnum.list, ignoreDimNumbers);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_ok", "btn_cancel", FIELD_TAB_DIM_MEMBER, "dimmember", "dimselect"});
        BasedataEdit model = (BasedataEdit)this.getControl("model");
        model.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit dataSet = (BasedataEdit)this.getControl("dataset");
        dataSet.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        AnalysisCanvasPluginHelper.beforeF7Select(e, this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if ("dataset".equals(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject oldVal = (DynamicObject)e.getChangeSet()[0].getOldValue();
            AnalysisCanvasPluginHelper.clearDimViewInPageCache("dimension_view", this.getView());
            if (newVal != null && oldVal != null) {
                String dataSetId = newVal.getString("id");
                this.getPageCache().put("dataset", dataSetId);
                AnalysisCanvasUserSelHelper.refreshUserSelByDataset(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), this.getModelId(), IDUtils.toLong((Object)dataSetId));
                AnalysisCanvasUserSelHelper.initDimMemAndViewToPageCache(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), this.getModelId(), IDUtils.toLong((Object)dataSetId), AnalysisCanvasEnum.list, Collections.emptyList());
                this.getModel().setValue(TAB_DIM, null);
                this.getModel().deleteEntryData("entryentity");
                this.getModel().deleteEntryData(TAB_ENTRY);
                this.initTabDim();
            } else {
                this.getModel().setValue("dataset", (Object)this.getPageCache().get("dataset"));
            }
        } else if ("model".equals(key)) {
            DynamicObject newVal = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newVal != null) {
                String modelId = newVal.getString("id");
                this.getPageCache().put("model", modelId);
                String datasetId = AnalysisCanvasUserSelHelper.getDataset(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), IDUtils.toLong((Object)modelId));
                this.getModel().setValue("dataset", (Object)datasetId);
            } else {
                this.getModel().setValue("model", (Object)String.valueOf(this.getModelId()));
            }
        } else if (TAB_DIM.equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            String oldValue = (String)e.getChangeSet()[0].getOldValue();
            if (StringUtils.isBlank((CharSequence)newVal) || newVal.equals(oldValue)) {
                return;
            }
            this.getModel().getValue(TAB_DIM);
            String dim = newVal.substring(0, newVal.length() - 1).replaceFirst(",", "");
            List<String> dimList = Arrays.asList(dim.split(","));
            this.initDimEntry(dimList);
        } else if ("dimmember".equals(key) || FIELD_TAB_DIM_MEMBER.equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                String dimNumber = this.getCurrEntryDim(key, rowIndex);
                this.getPageCache().remove(dimNumber + "_select");
            }
        } else if ("dimselect".equals(key)) {
            String newVal = (String)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (StringUtils.isBlank((CharSequence)newVal)) {
                this.getPageCache().remove("dimselect" + this.getCurrEntryDim("dimmember", rowIndex));
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimmember"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimmember"});
            }
        } else if ("dimmemberismulti".equals(key)) {
            Boolean oldVal;
            Boolean newVal = (Boolean)e.getChangeSet()[0].getNewValue();
            if (newVal.equals(oldVal = (Boolean)e.getChangeSet()[0].getOldValue())) {
                return;
            }
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (!newVal.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"dimselect"});
                this.getModel().setValue("dimselect", null, rowIndex);
                this.getModel().setValue("dimmember", null, rowIndex);
                String currEntryDim = this.getCurrEntryDim("dimmember", rowIndex);
                this.getPageCache().remove(currEntryDim + "_select");
                this.getPageCache().remove("dimselect" + currEntryDim);
            } else {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dimselect"});
            }
        }
    }

    @Override
    public Long getModelId() {
        return AnalysisCanvasPluginHelper.getModelId(this.getView());
    }

    public void click(EventObject evt) {
        Control ctrl = (Control)evt.getSource();
        String ctrlKey = ctrl.getKey();
        if ("btn_ok".equals(ctrlKey)) {
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("event", "ok");
            returnMap.put("data", (String)this.buildTabModel());
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        } else if ("btn_cancel".equals(ctrlKey)) {
            HashMap<String, String> returnMap = new HashMap<String, String>();
            returnMap.put("event", "cancel");
            this.getView().returnDataToParent(returnMap);
            this.getView().close();
        } else if ("dimmember".equals(ctrlKey)) {
            String dimNumber = this.getCurrEntryDim(ctrlKey, null);
            if (StringUtils.isBlank((CharSequence)dimNumber)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8868\u683c\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasTableConfigPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            boolean isMulti = this.getCurrEntryIsMulti();
            this.openDimSelect(dimNumber, "memberCloseCallback", !isMulti);
        } else if (FIELD_TAB_DIM_MEMBER.equals(ctrlKey)) {
            String dimNumber = this.getCurrEntryDim(ctrlKey, null);
            if (StringUtils.isBlank((CharSequence)dimNumber)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8868\u683c\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasTableConfigPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.openDimSelect(dimNumber, "tabMemberCloseCallback", false);
        } else if ("dimselect".equals(ctrlKey)) {
            String dimNumber = this.getCurrEntryDim("dimmember", null);
            boolean isMulti = this.getCurrEntryIsMulti();
            if (!isMulti) {
                return;
            }
            String relateId = this.getPageCache().get("dimselect" + dimNumber);
            this.openDropdownConfig(dimNumber, relateId);
        }
    }

    private void openDropdownConfig(String dimNumber, String relateId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("eb_analysiscanvas_select");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dropdownConfigCloseCallback"));
        fsp.setCustomParam("name", (Object)((CustomItem)JSON.parseObject((String)this.getPageCache().get("customItem"), CustomItem.class)).getName());
        fsp.setCustomParam("canvasId", (Object)this.getPageCache().get("canvasId"));
        fsp.setCustomParam("dataset", (Object)this.getPageCache().get("dataset"));
        fsp.setCustomParam("model", (Object)this.getModelId());
        fsp.setCustomParam("dimNumber", (Object)dimNumber);
        fsp.setCustomParam("relateId", (Object)relateId);
        this.getView().showForm(fsp);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("tabMemberCloseCallback".equals(actionId) || actionId.startsWith("memberCloseCallback")) {
            this.cacheSelectedDim(actionId, evt);
        }
        if ("dropdownConfigCloseCallback".equals(actionId)) {
            AnalysisCanvasPluginHelper.setSelectedDim(evt, this.getView(), AnalysisCanvasEnum.list);
        }
    }

    private void cacheSelectedDim(String actionId, ClosedCallBackEvent evt) {
        String dimNumber;
        if (evt.getReturnData() == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<TextEditSelectItem> list = new ArrayList<TextEditSelectItem>();
        AnalysisCanvasPluginHelper.buildSelectF7ReturnValue(sb, list, evt, "dimension_view", this.getView());
        if ("tabMemberCloseCallback".equals(actionId)) {
            dimNumber = this.getCurrEntryDim(FIELD_TAB_DIM_MEMBER, null);
            this.getModel().setValue(FIELD_TAB_DIM_MEMBER, (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), this.getCurrEntryRow(FIELD_TAB_DIM_MEMBER));
            this.getPageCache().put(dimNumber + "_select", JSON.toJSONString(list));
        }
        if ("memberCloseCallback".equals(actionId)) {
            dimNumber = this.getCurrEntryDim("dimmember", null);
            this.getModel().setValue("dimmember", (Object)(sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : ""), this.getCurrEntryRow("dimmember"));
            this.getPageCache().put(dimNumber + "_select", JSON.toJSONString(list));
        }
    }

    private void openDimSelect(String dimNumber, String callback, boolean singleSelect) {
        Long modelId = this.getModelId();
        Long dataSetId = IDUtils.toLong((Object)this.getPageCache().get("dataset"));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModelId = modelCache.getBusModelByDataSet(dataSetId);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("dataset", "=", (Object)dataSetId));
        } else if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
            qFilters.add(new QFilter("datatype", "in", (Object)Lists.newArrayList((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex(), MetricDataTypeEnum.RATE.getIndex()})));
        }
        long viewId = AnalysisCanvasPluginHelper.getViewId(modelId, dataSetId, dimNumber, "dimension_view", this.getView());
        String selectItemStr = this.getPageCache().get(dimNumber + "_select");
        if (singleSelect) {
            AnalysisCanvasPluginHelper.openNewF7(modelId, dataSetId, dimNumber, viewId, callback, qFilters, selectItemStr, this.getView(), (IFormPlugin)this);
        } else {
            AnalysisCanvasPluginHelper.openCustomF7Range(modelId, bizModelId, dataSetId, dimNumber, viewId, callback, qFilters, selectItemStr, this.getView(), (IFormPlugin)this);
        }
    }

    private void initTabDim() {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List dimensionList = modelCache.getDimensionList(IDUtils.toLong((Object)this.getPageCache().get("dataset")));
        ComboEdit comboEdit = (ComboEdit)this.getControl(TAB_DIM);
        ArrayList data = new ArrayList();
        dimensionList.stream().filter(dimension -> !SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber())).forEach(dimension -> data.add(new ComboItem(new LocaleString(dimension.getName()), dimension.getNumber())));
        comboEdit.setComboItems(data);
    }

    private void initDimEntry(List<String> ignoreDimNumbers) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        List dimensionList = modelCache.getDimensionList(IDUtils.toLong((Object)this.getPageCache().get("dataset")));
        List<String> ignoreTabDimNumbers = dimensionList.stream().map(BaseCache::getNumber).filter(number -> !ignoreDimNumbers.contains(number)).collect(Collectors.toList());
        AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), this.getModelId(), IDUtils.toLong((Object)this.getPageCache().get("dataset")), AnalysisCanvasEnum.listCol, ignoreTabDimNumbers);
        AnalysisCanvasUserSelHelper.initDimEntryEntityData(this.getView(), IDUtils.toLong((Object)this.getPageCache().get("canvasId")), this.getModelId(), IDUtils.toLong((Object)this.getPageCache().get("dataset")), AnalysisCanvasEnum.list, ignoreDimNumbers);
    }

    private String getCurrEntryDim(String key, Integer rowIndex) {
        if (rowIndex == null) {
            rowIndex = this.getCurrEntryRow(key);
        }
        if ("dimmember".equals(key)) {
            DynamicObject row = this.getModel().getEntryRowEntity("entryentity", rowIndex.intValue());
            return row.getString("dimnumber");
        }
        DynamicObject row = this.getModel().getEntryRowEntity(TAB_ENTRY, rowIndex.intValue());
        return row.getString(FIELD_TAB_DIM_NUMBER);
    }

    private int getCurrEntryRow(String key) {
        if ("dimmember".equals(key)) {
            return this.getModel().getEntryCurrentRowIndex("entryentity");
        }
        return this.getModel().getEntryCurrentRowIndex(TAB_ENTRY);
    }

    private Boolean getCurrEntryIsMulti() {
        DynamicObject row = this.getModel().getEntryRowEntity("entryentity", this.getCurrEntryRow("dimmember"));
        return row.getBoolean("dimmemberismulti");
    }

    private TabModel buildTabModel() {
        Object tabDim = this.getModel().getValue(TAB_DIM);
        if (tabDim == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8868\u683c\u7ef4\u5ea6\u3002", (String)"AnalysisCanvasTableConfigPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        String datasetId = this.getPageCache().get("dataset");
        String canvasId = this.getPageCache().get("canvasId");
        String boxId = this.getPageCache().get("usedBoxId");
        JSONObject dimensionViews = AnalysisCanvasPluginHelper.getDimensionView("dimension_view", this.getView());
        ModelHelper.checkViewIdExisted((JSONObject)dimensionViews);
        List<DimensionModel> tabRanges = AnalysisCanvasPluginHelper.buildDimensionModel(this.getView(), modelCache, dimensionViews, datasetId, AnalysisCanvasEnum.listCol);
        List<DimensionModel> dimModels = AnalysisCanvasPluginHelper.buildDimensionModel(this.getView(), modelCache, dimensionViews, datasetId, AnalysisCanvasEnum.list);
        TabModel tabModel = new TabModel();
        tabModel.setModel(String.valueOf(this.getModelId()));
        tabModel.setDataset(datasetId);
        tabModel.setTabDims(tabDim.toString());
        tabModel.setTabs(tabRanges);
        tabModel.setDims(dimModels);
        tabModel.setShow(Boolean.valueOf(true));
        tabModel.setAdd(Boolean.valueOf(false));
        tabModel.setEdit(Boolean.valueOf(false));
        tabModel.setDimensionViews(dimensionViews);
        AnalysisCubeService.getInstance().getAnalysisDataset(IDUtils.toLong((Object)canvasId).longValue(), IDUtils.toLong((Object)boxId).longValue(), IDUtils.toLong((Object)datasetId).longValue());
        return tabModel;
    }
}

