/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analysiscanvas.table;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.bos.form.IFormView;
import kd.epm.eb.formplugin.qinganalysis.model.TextEditSelectItem;
import org.apache.commons.lang3.StringUtils;

public class TableHelper {
    private static final String ROW_DIM_SELECT = "row_dim_select";
    private static final String COL_DIM_SELECT = "col_dim_select";

    static void createNewCache(String entryKey, int size, IFormView formView) {
        JSONArray dimVoCache = TableHelper.getRowColVoCache(entryKey, formView);
        for (int i = 0; i < size; ++i) {
            dimVoCache.add((Object)new JSONObject());
        }
        TableHelper.cacheRowColVo(entryKey, dimVoCache, formView);
    }

    static void cacheRowColVo(String entryKey, int entryIndex, String dimNumber, Long viewId, List<TextEditSelectItem> selectItemList, IFormView formView) {
        RowColVo rowColVo = new RowColVo();
        rowColVo.viewId = viewId;
        rowColVo.selectItemList = selectItemList;
        JSONArray jsonArray = TableHelper.getRowColVoCache(entryKey, formView);
        JSONObject jsonObject = jsonArray.getJSONObject(entryIndex);
        jsonObject.put(dimNumber, (Object)rowColVo);
        TableHelper.cacheRowColVo(entryKey, jsonArray, formView);
    }

    static void cacheRowColVo(String entryKey, JSONArray jsonArray, IFormView formView) {
        String cacheKey = "rowentry".equals(entryKey) ? ROW_DIM_SELECT : COL_DIM_SELECT;
        formView.getPageCache().put(cacheKey, jsonArray.toJSONString());
    }

    static RowColVo getRowColVo(String entryKey, int index, String dimNumber, IFormView formView) {
        JSONObject jsonObject = TableHelper.getRowColVoCache(entryKey, formView).getJSONObject(index);
        return (RowColVo)jsonObject.getObject(dimNumber, RowColVo.class);
    }

    static JSONArray getRowColVoCache(String entryKey, IFormView formView) {
        String cacheKey = "rowentry".equals(entryKey) ? ROW_DIM_SELECT : COL_DIM_SELECT;
        String cacheStr = formView.getPageCache().get(cacheKey);
        JSONArray jsonArray = StringUtils.isBlank((CharSequence)cacheStr) ? new JSONArray() : JSON.parseArray((String)cacheStr);
        return jsonArray;
    }

    static void removeRowColVoCache(IFormView formView) {
        formView.getPageCache().remove(ROW_DIM_SELECT);
        formView.getPageCache().remove(COL_DIM_SELECT);
    }

    static class RowColVo {
        Long viewId;
        List<TextEditSelectItem> selectItemList;

        RowColVo() {
        }

        public Long getViewId() {
            return this.viewId;
        }

        public void setViewId(Long viewId) {
            this.viewId = viewId;
        }

        public List<TextEditSelectItem> getSelectItemList() {
            return this.selectItemList;
        }

        public void setSelectItemList(List<TextEditSelectItem> selectItemList) {
            this.selectItemList = selectItemList;
        }
    }
}

