/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analyze;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.New;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.ModelCacheServiceHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.F7RangeTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import kd.epm.eb.formplugin.utils.SingleMemberF7Util;
import kd.epm.eb.model.serviceHelper.QueryDimensionServiceHelper;

public class AddCostType
extends AbstractBasePlugin
implements SingleMemberF7Util.ISingleMemberF7Handle,
BeforeF7SelectListener {
    private Map<String, String> nameMap = new HashMap<String, String>(16);
    private static final String CLOSE = "close";
    private static final Set<String> dimNumberList = new LinkedHashSet<String>(Arrays.asList("entity", "year", "currency", "version", "period", "account"));
    private static final String ACCOUNTRANG = "accountrang";
    private static final Log log = LogFactory.getLog(AddCostType.class);

    public void initialize() {
        super.initialize();
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(ACCOUNTRANG);
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CLOSE, "saveandnew"});
        for (String dimNumber : dimNumberList) {
            TextEdit textEdit = (TextEdit)this.getControl(dimNumber);
            textEdit.addClickListener((ClickListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"schemetype"});
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        if (showParameter.getStatus().equals((Object)OperationStatus.ADDNEW)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"entrydef", "entryatt", "dimsion", "dimmember"});
            this.getModel().setValue("model", this.getView().getFormShowParameter().getCustomParam("model"));
            this.getModel().setValue("schemetype", this.getView().getFormShowParameter().getCustomParam("isShare"));
            this.getModel().setValue("creater", (Object)UserUtils.getUserId());
        }
        if (showParameter.getCustomParam("id") != null) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"schemetype"});
            this.initCopyPage();
        }
        if (Objects.nonNull(showParameter.getCustomParam("cacheData"))) {
            Map cacheMap = (Map)showParameter.getCustomParam("cacheData");
            this.initData(cacheMap);
        }
    }

    public void afterLoadData(EventObject e) {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"schemetype"});
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object pkId = ((BaseShowParameter)showParameter).getPkId();
        String model = (String)showParameter.getCustomParam("model");
        QFBuilder qfBuilder = new QFBuilder("model", "=", (Object)IDUtils.toLong((Object)model));
        qfBuilder.add(new QFilter("id", "=", (Object)IDUtils.toLong((Object)pkId)));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)showParameter.getFormId(), (String)"account,accountrang,accounttxt_tag", (QFilter[])qfBuilder.toArrays());
        if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)((String)dynamicObject.get("accounttxt_tag"))) && dynamicObject.get(ACCOUNTRANG) != null) {
            DynamicObjectCollection accountrang = (DynamicObjectCollection)dynamicObject.get(ACCOUNTRANG);
            ArrayList members = new ArrayList(16);
            HashMap<String, String> memberMap = null;
            StringBuilder accountName = new StringBuilder();
            int index = 0;
            for (DynamicObject object : accountrang) {
                memberMap = new HashMap<String, String>(16);
                DynamicObject fbasedataid = (DynamicObject)object.get("fbasedataid");
                memberMap.put("number", fbasedataid.getString("number"));
                memberMap.put("scope", "10");
                String name = fbasedataid.getString("name");
                if (index == accountrang.size() - 1) {
                    accountName.append(name);
                } else {
                    accountName.append(name).append(",");
                }
                memberMap.put("name", name);
                memberMap.put("pid", "");
                memberMap.put("id", fbasedataid.getString("id"));
                members.add(memberMap);
                ++index;
            }
            String toJsonString = SerializationUtils.toJsonString(members);
            dynamicObject.set("account", (Object)accountName);
            dynamicObject.set("accounttxt_tag", (Object)toJsonString);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            this.getModel().setValue("account", (Object)accountName);
            this.getModel().setValue("accounttxt_tag", (Object)toJsonString);
        }
        if (showParameter.getStatus().equals((Object)OperationStatus.EDIT)) {
            String dimsion = (String)this.getModel().getValue("dimsion");
            String divideway = (String)this.getModel().getValue("divideway");
            this.setComboBoxValueByDim(divideway);
            if ("1".equals(divideway)) {
                this.setComboBoxValueBydDimMem(dimsion);
            } else {
                this.setComboBoxValueByentryatt();
            }
        }
        this.initPageCache();
        this.getModel().setDataChanged(false);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (dimNumberList.contains(source.getKey())) {
            this.showMutilDimensionF7Form(source.getKey());
        } else if ("saveandnew".equals(source.getKey())) {
            IDataModel model = this.getModel();
            String retData = this.getPageCache().get("retData");
            if (StringUtils.isNotEmpty((String)retData)) {
                Map retDataMap = (Map)SerializationUtils.deSerializeFromBase64((String)retData);
                this.getPageCache().put("return", "1");
                model.setValue("schemetype", retDataMap.get("schemetype"));
                model.setValue("account", retDataMap.get("account"));
                model.setValue("entity", retDataMap.get("entity"));
                model.setValue("currency", retDataMap.get("currency"));
                model.setValue("year", retDataMap.get("year"));
                model.setValue("period", retDataMap.get("period"));
                model.setValue("version", retDataMap.get("version"));
                model.setValue(ACCOUNTRANG, retDataMap.get(ACCOUNTRANG));
                for (String dim : dimNumberList) {
                    if (!"account".equals(dim)) {
                        model.setValue(dim + "rang_tag", retDataMap.get(dim + "rang_tag"));
                        continue;
                    }
                    model.setValue(dim + "txt_tag", retDataMap.get(dim + "txt_tag"));
                }
                this.getPageCache().remove("return");
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        this.getModel().setDataChanged(false);
        Object retData = this.getView().getReturnData();
        if (Objects.nonNull(retData)) {
            this.getView().returnDataToParent(retData);
        } else {
            Object ret = this.getView().getFormShowParameter().getCustomParam("retData");
            if (Objects.nonNull(ret)) {
                this.getView().returnDataToParent(ret);
            }
        }
    }

    @Override
    public void beforeSingleMemberF7Select(BeforeF7SelectEvent arg0) {
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object operate = args.getSource();
        HashMap<String, Object> retData = new HashMap<String, Object>(dimNumberList.size() + 1);
        this.getView().returnDataToParent((Object)"success");
        if ("1".equals(this.getModel().getValue("divideway"))) {
            this.getModel().setValue("dividegist", (Object)ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458", (String)"AddCostType_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if ("2".equals(this.getModel().getValue("divideway"))) {
            this.getModel().setValue("dividegist", (Object)ResManager.loadKDString((String)"\u7ec4\u7ec7\u5c5e\u6027", (String)"AddCostType_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.getModel().setValue("dividegist", (Object)ResManager.loadKDString((String)"\u79d1\u76ee\u8303\u56f4", (String)"AddCostType_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection dcs = (DynamicObjectCollection)this.getModel().getValue(ACCOUNTRANG);
        StringBuilder accountname = null;
        ArrayList<String> accountid = new ArrayList<String>(16);
        for (DynamicObject doc : dcs) {
            DynamicObject dynamicObject = (DynamicObject)doc.get("fbasedataid");
            if (accountname != null) {
                accountname.append("\u3001").append(dynamicObject.getString("name"));
            } else {
                accountname = new StringBuilder();
                accountname.append(dynamicObject.getString("name"));
            }
            accountid.add(dynamicObject.getString("id"));
        }
        this.getModel().setValue("accountname", (Object)(accountname != null && accountname.length() > 255 ? accountname.substring(0, 252) + "..." : Objects.requireNonNull(accountname).toString()));
        if (this.getModel().getValue("dimsion") == null) {
            this.getModel().setValue("dimsion", (Object)0);
        }
        if (this.getModel().getValue("dimmember") == null) {
            this.getModel().setValue("dimmember", (Object)0);
        }
        if (this.getModel().getValue("entrydef") == null) {
            this.getModel().setValue("entrydef", (Object)0);
        }
        if (this.getModel().getValue("entryatt") == null) {
            this.getModel().setValue("entryatt", (Object)0);
        }
        if (!(args.getSource() instanceof New) && this.CheckTypeName()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u540d\u79f0\u3002", (String)"AddCostType_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        retData.put(ACCOUNTRANG, SerializationUtils.toJsonString(accountid));
        for (String dim : dimNumberList) {
            if (!"account".equals(dim)) {
                retData.put(dim, this.getModel().getValue(dim));
                retData.put(dim + "rang_tag", this.getModel().getValue(dim + "rang_tag"));
                continue;
            }
            retData.put(dim, this.getModel().getValue(dim));
            retData.put(dim + "txt_tag", this.getModel().getValue(dim + "txt_tag"));
        }
        if (operate instanceof SaveAndNew) {
            this.getView().getFormShowParameter().setCustomParam("retData", retData);
            HashMap<String, Object> echoMap = new HashMap<String, Object>(16);
            echoMap.put("schemetype", this.getModel().getValue("schemetype"));
            echoMap.put("account", this.getModel().getValue("account"));
            echoMap.put("entity", this.getModel().getValue("entity"));
            echoMap.put("currency", this.getModel().getValue("currency"));
            echoMap.put("year", this.getModel().getValue("year"));
            echoMap.put("period", this.getModel().getValue("period"));
            echoMap.put("version", this.getModel().getValue("version"));
            echoMap.put(ACCOUNTRANG, this.getModel().getValue(ACCOUNTRANG));
            for (String dim : dimNumberList) {
                if (!"account".equals(dim)) {
                    echoMap.put(dim + "rang_tag", this.getModel().getValue(dim + "rang_tag"));
                    continue;
                }
                echoMap.put(dim + "txt_tag", this.getModel().getValue(dim + "txt_tag"));
            }
            this.getPageCache().put("retData", SerializationUtils.serializeToBase64(echoMap));
        } else if (operate instanceof Save) {
            this.getView().setReturnData(retData);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String aReturn = this.getPageCache().get("return");
        if ("1".equals(aReturn)) {
            return;
        }
        String key = e.getProperty().getName();
        if (dimNumberList.contains(key)) {
            String value = (String)this.getModel().getValue(key);
            if (StringUtils.isEmpty((String)value)) {
                this.getModel().beginInit();
                if ("account".equals(key)) {
                    this.getModel().setValue(key + "txt_tag", (Object)"");
                } else {
                    this.getModel().setValue(key + "rang_tag", (Object)"");
                    this.getModel().setValue(key + "bdf", null);
                }
                this.getModel().endInit();
                this.setPageCache(key, null);
            }
            return;
        }
        switch (key) {
            case "divideway": {
                String divideway = (String)this.getModel().getValue("divideway");
                ArrayList list = Lists.newArrayList((Object[])new String[]{"dimsion", "dimmember", "entryatt", ACCOUNTRANG});
                this.setNull(list);
                this.setComboBoxValueByDim(divideway);
                break;
            }
            case "dimsion": {
                if (this.getModel().getValue(key) == null || "0".equals(this.getModel().getValue(key).toString())) break;
                String dimsion = (String)this.getModel().getValue("dimsion");
                ArrayList list1 = Lists.newArrayList((Object[])new String[]{"dimmember"});
                this.setNull(list1);
                if (dimsion == null) break;
                this.setComboBoxValueBydDimMem(dimsion);
                break;
            }
            case "entrydef": {
                if ("0".equals(this.getModel().getValue(key).toString())) break;
                this.setComboBoxValueByentryatt();
                break;
            }
            case "dimmember": {
                if (this.getModel().getValue("dimmember") == null) break;
                String dimmemberid = (String)this.getModel().getValue("dimmember");
                if (this.getPageCache().get("nameMap") == null) break;
                Map nameMap = (Map)ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get("nameMap"));
                String name = (String)nameMap.get(dimmemberid);
                this.getModel().setValue("dimmemname", (Object)name);
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String dimNumber = closedCallBackEvent.getActionId();
        if (dimNumberList.contains(dimNumber)) {
            DynamicObjectCollection returnData = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
            if (Objects.nonNull(returnData)) {
                StringBuilder text = new StringBuilder();
                ArrayList list = new ArrayList(16);
                for (DynamicObject dim : returnData) {
                    if (!StringUtils.isEmpty((String)text.toString())) {
                        text.append(",");
                    }
                    text.append(dim.getString("name"));
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    map.put("id", dim.getString("id"));
                    map.put("scope", dim.getString("scope"));
                    map.put("number", dim.getString("number"));
                    map.put("name", dim.getString("name"));
                    map.put("pid", dim.getString("pid"));
                    list.add(map);
                }
                String jsonString = SerializationUtils.toJsonString(list);
                this.getModel().setValue(dimNumber, (Object)text.substring(0, text.length() > 50 ? 49 : text.length()));
                if ("account".equals(dimNumber)) {
                    this.getModel().setValue(dimNumber + "txt_tag", (Object)jsonString);
                } else {
                    this.getModel().beginInit();
                    this.getModel().setValue(dimNumber + "rang_tag", (Object)jsonString);
                    this.getModel().endInit();
                    this.getView().updateView(dimNumber + "rang_tag");
                }
                this.setPageCache(dimNumber, jsonString);
                this.setDimIfOnlyOneNumber(this.firstCharacterToUpperCase(dimNumber));
            } else if ("empty".equals(this.getView().getReturnData())) {
                if ("account".equals(dimNumber)) {
                    this.getModel().setValue(ACCOUNTRANG, null);
                    this.getModel().setValue("accountname", null);
                } else {
                    this.getModel().setValue(dimNumber + "rang_tag", null);
                    this.getModel().setValue(dimNumber + "bdf", null);
                }
                this.getModel().setValue(dimNumber, (Object)"");
            }
        }
    }

    private void setComboBoxValueByentryatt() {
        this.nameMap.clear();
        ComboEdit Cmb = (ComboEdit)this.getControl("entryatt");
        ArrayList<ComboItem> dimmemitems = new ArrayList<ComboItem>(16);
        DynamicObjectCollection dcs = this.searchDefinedPropertValue();
        for (DynamicObject doc : dcs) {
            dimmemitems.add(new ComboItem(new LocaleString(doc.getString("name")), doc.get("id").toString()));
            this.nameMap.put(doc.get("id").toString(), doc.getString("name"));
            this.getPageCache().put(this.nameMap);
        }
        this.getPageCache().put("nameMap", ObjectSerialUtil.toByteSerialized(this.nameMap));
        Cmb.setComboItems(dimmemitems);
    }

    private void setComboBoxValueBydDimMem(String dimsion) {
        this.nameMap.clear();
        ComboEdit Cmb = (ComboEdit)this.getControl("dimmember");
        ArrayList<ComboItem> dimmemitems = new ArrayList<ComboItem>(16);
        DynamicObjectCollection dcs = this.searchDimMem();
        if (dcs != null) {
            for (DynamicObject doc : dcs) {
                dimmemitems.add(new ComboItem(new LocaleString(doc.getString("name")), doc.get("id").toString()));
                this.nameMap.put(doc.get("id").toString(), doc.getString("name"));
            }
            this.getPageCache().put("nameMap", ObjectSerialUtil.toByteSerialized(this.nameMap));
            Cmb.setComboItems(dimmemitems);
        }
    }

    private DynamicObjectCollection searchDefinedPropertValue() {
        String selectFiled = "id,name,number";
        QFilter qcf = new QFilter("property", "=", (Object)IDUtils.toLong((Object)this.getModel().getValue("entrydef")));
        return QueryServiceHelper.query((String)"eb_custompropertyvalue", (String)selectFiled, (QFilter[])new QFilter[]{qcf});
    }

    private void setComboBoxValueByDim(String divideway) {
        ComboEdit Cmb;
        if ("1".equals(divideway)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"dimsion", "dimmember"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"entrydef", "entryatt"});
            Cmb = (ComboEdit)this.getControl("dimsion");
            ArrayList<ComboItem> dimitems = new ArrayList<ComboItem>(16);
            DynamicObjectCollection dcs = this.searchDim(null);
            for (DynamicObject doc : dcs) {
                dimitems.add(new ComboItem(new LocaleString(doc.getString("name")), doc.get("id").toString()));
            }
            Cmb.setComboItems(dimitems);
            if (dcs.size() == 1) {
                this.getModel().setValue("dimsion", (Object)((DynamicObject)dcs.get(0)).getString("id"));
            }
        }
        if ("2".equals(divideway)) {
            Cmb = (ComboEdit)this.getControl("entrydef");
            ComboEdit Cmb1 = (ComboEdit)this.getControl("dimsion");
            ArrayList<ComboItem> dimitems = new ArrayList<ComboItem>(16);
            ArrayList<ComboItem> dimitems1 = new ArrayList<ComboItem>(16);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"entrydef", "entryatt"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"dimsion", "dimmember"});
            DynamicObjectCollection dynamicObjects = this.searchDim("entity");
            for (DynamicObject doc : dynamicObjects) {
                dimitems1.add(new ComboItem(new LocaleString(doc.getString("name")), doc.get("id").toString()));
            }
            Cmb1.setComboItems(dimitems1);
            this.getModel().setValue("dimsion", ((DynamicObject)dynamicObjects.get(0)).get("id"));
            DynamicObjectCollection dcs = this.searchDefproperty(((DynamicObject)dynamicObjects.get(0)).get("id").toString());
            for (DynamicObject doc : dcs) {
                dimitems.add(new ComboItem(new LocaleString(doc.getString("name")), doc.get("id").toString()));
            }
            Cmb.setComboItems(dimitems);
        }
        if ("3".equals(divideway)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"dimsion", "dimmember", "entrydef", "entryatt"});
        }
    }

    private DynamicObjectCollection searchDim(String state) {
        String selectFields = "id,name,number,shortnumber,membermodel,issysdimension";
        if (state == null) {
            QFilter dimqcf = new QFilter("model", "=", (Object)IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"))).and("issysdimension", "=", (Object)0);
            return QueryServiceHelper.query((String)"epm_dimension", (String)selectFields, (QFilter[])new QFilter[]{dimqcf});
        }
        QFilter dimqcf = new QFilter("model", "=", (Object)IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"))).and("number", "=", (Object)SysDimensionEnum.Entity.getNumber());
        return QueryServiceHelper.query((String)"epm_dimension", (String)selectFields, (QFilter[])new QFilter[]{dimqcf});
    }

    private DynamicObjectCollection searchDimMem() {
        String selectFields = "id,name,number";
        QFilter fdimenId = new QFilter("id", "=", (Object)((DynamicObject)this.getModel().getValue("dimsion")).getLong("id"));
        QFilter[] filters = new QFilter[]{fdimenId};
        DynamicObject doc = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"membermodel,number,issysdimension", (QFilter[])filters);
        if (!doc.getBoolean("issysdimension")) {
            String menberentityid = doc.getString("membermodel");
            QFilter qcf = new QFilter("model", "=", (Object)IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model")));
            QFilter qcd = new QFilter("dimension", "=", (Object)((DynamicObject)this.getModel().getValue("dimsion")).getLong("id"));
            return QueryServiceHelper.query((String)menberentityid, (String)selectFields, (QFilter[])new QFilter[]{qcf, qcd}, (String)"dseq");
        }
        return null;
    }

    private void setNull(List<String> nullList) {
        for (String filed : nullList) {
            this.getModel().setValue(filed, null);
        }
    }

    private DynamicObjectCollection searchDefproperty(String id) {
        String selectFiled = "id,name,number";
        QFilter qcf = new QFilter("model", "=", (Object)IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"))).and("dimension", "=", (Object)id);
        return QueryServiceHelper.query((String)"eb_dimproperty", (String)selectFiled, (QFilter[])new QFilter[]{qcf});
    }

    private Object getFormParam(String param) {
        Object customParam = this.getView().getFormShowParameter().getCustomParam(param);
        if (customParam == null) {
            return null;
        }
        return customParam;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (((BasedataEdit)beforeF7SelectEvent.getSource()).getKey().equals(ACCOUNTRANG)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList qFilterList = ((BasedataEdit)this.getControl(ACCOUNTRANG)).getQFilters();
            if (qFilterList == null) {
                qFilterList = new ArrayList(16);
            }
            ArrayList<QFilter> modelQFilters = new ArrayList<QFilter>(16);
            modelQFilters.add(new QFilter("model", "=", (Object)IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("model"))));
            qFilterList.addAll(modelQFilters);
            ((BasedataEdit)this.getControl(ACCOUNTRANG)).setQFilters(qFilterList);
            showParameter.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            beforeF7SelectEvent.setFormShowParameter((FormShowParameter)showParameter);
            this.switchDimF7(beforeF7SelectEvent);
        }
    }

    public String getCurrentDimNumber(String controlKey) {
        if (ACCOUNTRANG.equals(controlKey)) {
            return SysDimensionEnum.Account.getNumber();
        }
        return null;
    }

    private boolean CheckTypeName() {
        return OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus()) ? QueryServiceHelper.exists((String)"eb_costtype", (QFilter[])new QFilter[]{new QFilter("typename", "=", this.getModel().getValue("typename")).and("id", "!=", (Object)IDUtils.toLong((Object)((BaseShowParameter)this.getView().getFormShowParameter()).getPkId())).and("model", "=", (Object)this.getModelId())}) : QueryServiceHelper.exists((String)"eb_costtype", (QFilter[])new QFilter[]{new QFilter("typename", "=", this.getModel().getValue("typename")).and("model", "=", (Object)this.getModelId())});
    }

    private String firstCharacterToUpperCase(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        String newStr = str.toLowerCase();
        Character first = Character.valueOf(newStr.charAt(0));
        return newStr.replaceFirst(first.toString(), String.valueOf(Character.toUpperCase(first.charValue())));
    }

    private void showMutilDimensionF7Form(String number) {
        SysDimensionEnum dimensionEnum = this.getSysDimsionEnum(number);
        if (Objects.nonNull(dimensionEnum)) {
            List<Map<String, String>> members;
            Long modelId = this.getModelId();
            MemberF7Parameter f8Param = NewF7Utils.multipleF8((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimensionEnum.getNumber()), (String)DynamicObject.class.getName());
            f8Param.setRangeType(F7RangeTypeEnum.DEFAULT);
            if (!"epm_userdefinedmembertree".equals(f8Param.entityNumber())) {
                f8Param.setCanSelectRoot(false);
            }
            if ((members = this.getDimmensionRang(number)) != null && !members.isEmpty()) {
                LinkedHashMap selected = Maps.newLinkedHashMapWithExpectedSize((int)members.size());
                for (Map<String, String> _member : members) {
                    selected.put(IDUtils.toLong((Object)_member.get("id")), Integer.valueOf(_member.get("scope")));
                }
                f8Param.setSelectIds((Map)selected);
            }
            NewF7Utils.openF8((IFormView)this.getView(), (MemberF7Parameter)f8Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, number));
        }
    }

    private String getDimName(int dseq) {
        DynamicObject dim = QueryDimensionServiceHelper.getDimByDseq((int)dseq, (Long)this.getModelId());
        return dim == null ? null : dim.getString("name");
    }

    private SysDimensionEnum getSysDimsionEnum(String number) {
        String newnumber = this.firstCharacterToUpperCase(number);
        return SysDimensionEnum.getEnumByNumber((String)newnumber);
    }

    @Override
    public Long getModelId() {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        return model == null ? 0L : model.getLong("id");
    }

    private void initPageCache() {
        for (String dimNum : dimNumberList) {
            SysDimensionEnum sysDimsionEnum = this.getSysDimsionEnum(dimNum);
            String jsonString = "account".equals(dimNum) ? (String)this.getModel().getValue(dimNum + "txt_tag") : (String)this.getModel().getValue(dimNum + "rang_tag");
            if (!StringUtils.isNotEmpty((String)jsonString)) continue;
            try {
                SerializationUtils.fromJsonStringToList((String)jsonString, Map.class);
                this.getPageCache().put(sysDimsionEnum.getMemberTreemodel() + sysDimsionEnum.getDseq(), jsonString);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                this.getModel().setValue(dimNum, (Object)"");
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5206\u6790\u65b9\u6848\u7684\u201c%1\u201d\u6570\u636e\u6709\u8bef\uff0c\u5df2\u91cd\u7f6e\u3002", (String)"AddCostType_5", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getDimName(sysDimsionEnum.getDseq())}));
            }
        }
    }

    private List<Map<String, String>> getDimmensionRang(String dimKey) {
        String rang = "";
        rang = "account".equals(dimKey) ? (String)this.getModel().getValue(dimKey + "txt_tag") : (String)this.getModel().getValue(dimKey + "rang_tag");
        if (StringUtils.isEmpty((String)rang)) {
            return null;
        }
        try {
            return SerializationUtils.fromJsonStringToList((String)rang, Map.class);
        }
        catch (KDBizException e) {
            log.error((Throwable)e);
            return null;
        }
    }

    private void setDimIfOnlyOneNumber(String dimNumber) {
        this.getModel().beginInit();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Model model = modelCache.getModelobj();
        List<Map<String, String>> dimmensionRangList = this.getDimmensionRang(dimNumber.toLowerCase(Locale.getDefault()));
        ArrayList<Member> leafMember = new ArrayList<Member>(16);
        ArrayList<Long> accountMember = new ArrayList<Long>(16);
        if (dimmensionRangList == null) {
            if (!SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                this.getModel().setValue(dimNumber.toLowerCase() + "bdf", null);
            }
            return;
        }
        for (Map<String, String> memberRang : dimmensionRangList) {
            if ("10".equals(memberRang.get("scope"))) {
                Member member = modelCache.getMember(dimNumber, null, memberRang.get("number"));
                if (member.isLeaf()) {
                    leafMember.add(member);
                }
                if (SysDimensionEnum.Entity.getNumber().equals(dimNumber) && member.getParentId() != 0L) {
                    leafMember.add(member);
                }
                if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                    accountMember.add(member.getId());
                }
            } else {
                List memberList = ModelCacheServiceHelper.getMember((Model)model, (String)dimNumber, (String)memberRang.get("number"), (int)Integer.parseInt(memberRang.get("scope")));
                if (!SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                    for (Member member : memberList) {
                        if (SysDimensionEnum.Version.getNumber().equals(dimNumber) && "ACTUAL".equals(member.getNumber()) || !member.isLeaf() && !SysDimensionEnum.Entity.getNumber().equals(dimNumber)) continue;
                        leafMember.add(member);
                        if (leafMember.size() < 2) continue;
                        break;
                    }
                } else {
                    for (Member member : memberList) {
                        accountMember.add(member.getId());
                    }
                }
            }
            if (SysDimensionEnum.Account.getNumber().equals(dimNumber) || leafMember.size() < 2) continue;
            break;
        }
        if (leafMember.size() == 1) {
            if (SysDimensionEnum.Entity.getNumber().equals(dimNumber) && SysDimensionEnum.Entity.getNumber().equals(((Member)leafMember.get(0)).getNumber())) {
                this.getModel().setValue(dimNumber.toLowerCase() + "bdf", null);
            }
            Member member = (Member)leafMember.get(0);
            if (!SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                this.getModel().setValue(dimNumber.toLowerCase() + "bdf", (Object)member.getId());
            }
        } else if (!SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            this.getModel().setValue(dimNumber.toLowerCase() + "bdf", null);
        }
        if (accountMember.size() > 0) {
            this.getModel().setValue(ACCOUNTRANG, (Object)accountMember.toArray());
        }
        this.getModel().endInit();
        this.getView().updateView(dimNumber.toLowerCase() + "bdf");
        this.getView().updateView(ACCOUNTRANG);
    }

    private void setPageCache(String dimNumber, String jsonString) {
        SysDimensionEnum sysDimsionEnum = this.getSysDimsionEnum(dimNumber);
        this.getPageCache().put(sysDimsionEnum.getMemberTreemodel() + sysDimsionEnum.getDseq(), jsonString);
    }

    private void initCopyPage() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String id = (String)formShowParameter.getCustomParam("id");
        formShowParameter.setCustomParam("id", null);
        DynamicObject doj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_costtype");
        this.getModel().setValue(ACCOUNTRANG, doj.get(ACCOUNTRANG));
        String text = null;
        String jsonString = null;
        for (String dimNum : dimNumberList) {
            text = doj.getString(dimNum);
            jsonString = "account".equals(dimNum) ? doj.getString(dimNum + "txt_tag") : doj.getString(dimNum + "rang_tag");
            this.getModel().setValue(dimNum, (Object)text.substring(0, text.length() > 50 ? 49 : text.length()));
            this.getModel().beginInit();
            if ("account".equals(dimNum)) {
                this.getModel().setValue(dimNum + "txt_tag", (Object)jsonString);
            } else {
                this.getModel().setValue(dimNum + "rang_tag", (Object)jsonString);
            }
            this.getModel().endInit();
            this.getView().updateView(dimNum + "rang_tag");
            this.setPageCache(dimNum, jsonString);
            this.setDimIfOnlyOneNumber(this.firstCharacterToUpperCase(dimNum));
        }
    }

    private void initData(Map<String, Object> map) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List accountList = (List)SerializationUtils.fromJsonString((String)map.get(ACCOUNTRANG).toString(), List.class);
        this.getModel().setValue(ACCOUNTRANG, (Object)IDUtils.toLongs((List)accountList).toArray());
        String jsonString = null;
        formShowParameter.setCustomParam("cacheData", null);
        for (String dimNum : dimNumberList) {
            this.getModel().setValue(dimNum, map.get(dimNum));
            this.getModel().beginInit();
            if (!"account".equals(dimNum)) {
                if (map.get(dimNum + "rang_tag") != null) {
                    jsonString = map.get(dimNum + "rang_tag").toString();
                }
                this.getModel().setValue(dimNum + "rang_tag", (Object)jsonString);
            } else {
                if (map.get(dimNum + "txt_tag") != null) {
                    jsonString = map.get(dimNum + "txt_tag").toString();
                }
                this.getModel().setValue(dimNum + "txt_tag", (Object)jsonString);
            }
            this.getModel().endInit();
            if (!"account".equals(dimNum)) {
                this.getView().updateView(dimNum + "rang_tag");
            } else {
                this.getView().updateView(dimNum + "txt_tag");
            }
            this.setPageCache(dimNum, jsonString);
            this.setDimIfOnlyOneNumber(this.firstCharacterToUpperCase(dimNum));
        }
    }
}

