/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analyze;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.control.BillPreOpenCheckUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgConstant;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.BgControlCallerImpl;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.control.impl.model.BgControlScheme;
import kd.epm.eb.control.utils.BgControlUtils;
import kd.epm.eb.ebBusiness.serviceHelper.DimensionServiceHelper;
import kd.epm.eb.formplugin.AbstractListPlugin;
import kd.epm.eb.model.utils.ModelUtil;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class AnalyzeWayPlugin
extends AbstractListPlugin
implements HyperLinkClickListener,
RowClickEventListener {
    private static final String CUSTOMDIMSINFOCACHE = "customDimsInfoCache";
    private static final String ENTRYENTITY = "entryentity";
    private static final List<String> keys = Arrays.asList("account", "entity", "period", "execustomdim1", "execustomdim2", "execustomdim3", "execustomdim4", "execustomdim5", "execustomdim6");
    private static final List<String> periodLists = Arrays.asList("M_Q", "M_HF", "Q_HF");
    private static final List<String> analyzeLists = Arrays.asList("budget", "occupy", "execute", "balance");
    private static final List<String> budgetLists = Arrays.asList("budget", "budget1", "balance", "balance1");
    private static final String EB_RELEVANCEANALYZE = "eb_relevanceanalyze";
    private DynamicInfoCollection customdimInfo = null;
    private Map<String, String> userDefine = null;
    private static final Pattern COM = Pattern.compile("[^0-9]");
    private static final Log log = LogFactory.getLog(AnalyzeWayPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (!this.isPandectView()) {
            this.buildCustomDimInfo();
        } else {
            this.buildRelevanceAnalyze();
        }
    }

    private void buildRelevanceAnalyze() {
        IFormView view = this.getView();
        String retureMap1 = (String)view.getFormShowParameter().getCustomParam("retureMap");
        Map retureMap = (Map)SerializationUtils.deSerializeFromBase64((String)retureMap1);
        Long modelId = this.getFormModelId();
        this.getPageCache().put("modelId", String.valueOf(modelId));
        String custom = (String)retureMap.get("customdimMap");
        this.getPageCache().put("customdimMap", custom);
        this.getPageCache().put("retureMap", retureMap1);
        String fieldName = (String)view.getFormShowParameter().getCustomParam("fieldName");
        this.getPageCache().put("fieldName", fieldName);
        String dimen = (String)retureMap.get("dimen");
        String analyze = (String)retureMap.get("analyze");
        Map<String, DynamicObject> dimenMap = this.getStringDynamicObjectMap(view);
        if (dimenMap.get("period") != null) {
            this.getPageCache().put("period", dimenMap.get("period").getString("number"));
        }
        Map<String, DynamicInfoCollection.InfoObject> customdimMap = this.getCustomdimMap();
        String labelAp = this.buildLabelAp(dimen, dimenMap, customdimMap);
        Map<Integer, IBudgetBalance> balanceMap = null;
        if ("exehierarchy".equals(analyze)) {
            DynamicObject[] dimObj = this.getDynamicObjects(modelId, dimen, dimenMap, customdimMap, null);
            ArrayList<DynamicObject> dimenObject = new ArrayList<DynamicObject>(dimObj.length);
            dimenObject.addAll(Arrays.asList(dimObj));
            if (dimen.contains("execustomdim")) {
                HashMap levelCustom = new HashMap(dimenObject.size());
                HashMap<String, DynamicObject> levelMap = new HashMap<String, DynamicObject>(dimenObject.size());
                for (DynamicObject dynamicObject : dimenObject) {
                    levelMap.put(dynamicObject.getString("name"), dynamicObject);
                }
                levelCustom.put(dimen, levelMap);
                this.getPageCache().put("levelCustom", SerializationUtils.serializeToBase64(levelCustom));
            }
            this.getPageCache().put("resInit", "tier");
            balanceMap = this.setIBudgetBalance(modelId, fieldName, dimen, dimenMap, customdimMap, null, dimenObject, null);
        } else {
            String entityName;
            ArrayList<DynamicObject> wrongNodeList;
            DynamicObject[] dimObj = this.getDynamicObjects(modelId, dimen, dimenMap, customdimMap, null);
            List<DynamicObject> nodeList = this.getWrongNodeList(dimObj, wrongNodeList = new ArrayList<DynamicObject>(16), modelId, entityName = this.getPageCache().get("entityName"));
            List<Map<String, String>> dimlist = this.getMapsFlite(nodeList, dimenMap, dimen, customdimMap, null, null);
            if (dimlist.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u6ca1\u6709\u660e\u7ec6\u6570\u636e\u3002", (String)"AnalyzeWayPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.getPageCache().put("resInit", "detail");
            balanceMap = this.setDetailEntity(modelId, fieldName, customdimMap, dimlist);
        }
        if (balanceMap != null) {
            this.setPathEntityMap(labelAp, balanceMap);
        }
    }

    private Map<Integer, IBudgetBalance> setDetailEntity(Long modelId, String fieldName, Map<String, DynamicInfoCollection.InfoObject> customdimMap, List<Map<String, String>> dimlist) {
        BgControlCallerImpl bgControlCaller = new BgControlCallerImpl();
        if (!analyzeLists.contains(fieldName) && dimlist.size() > 0) {
            String periodNumber = dimlist.get(0).get(SysDimensionEnum.Period.getNumber());
            this.getDimensionCoyes(dimlist, periodNumber);
        }
        Collection<String> type = this.dealSettingType(dimlist);
        Collection<IBudgetBalance> iBudgetBalances = this.getSelectBalance(modelId, bgControlCaller, dimlist, type);
        HashMap<String, Object> balanceCacheMap = new HashMap<String, Object>(16);
        balanceCacheMap.put("modelId", modelId);
        balanceCacheMap.put("dimlist", dimlist);
        balanceCacheMap.put("type", type);
        balanceCacheMap.put("fieldName", fieldName);
        balanceCacheMap.put("customdimMap", customdimMap);
        this.getPageCache().put("balanceCache", SerializationUtils.serializeToBase64(balanceCacheMap));
        Collection<IBudgetBalance> moniBudgetBalances = this.getiBudgetBalances(type, iBudgetBalances);
        Map<Integer, IBudgetBalance> balanceMap = null;
        if (moniBudgetBalances.size() > 0) {
            this.getiBudgetBalances(iBudgetBalances);
            String priceStr = "1";
            BigDecimal price = new BigDecimal(priceStr);
            Collection<IBudgetBalance> filterIBudgetBalance = this.getiFilterBalances(fieldName, moniBudgetBalances);
            if (filterIBudgetBalance.size() > 0) {
                this.isTimeSort(filterIBudgetBalance);
                balanceMap = this.buildEntryentity(customdimMap, price, filterIBudgetBalance);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u65e0\u6709\u6548\u6570\u636e\u3002", (String)"AnalyzeWayPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        return balanceMap;
    }

    private void isTimeSort(Collection<IBudgetBalance> filterIBudgetBalance) {
        if (filterIBudgetBalance instanceof ArrayList) {
            ((ArrayList)filterIBudgetBalance).sort(new Comparator<IBudgetBalance>(){

                @Override
                public int compare(IBudgetBalance o1, IBudgetBalance o2) {
                    String account1 = o1.getPeriod(true).getNumber();
                    String account2 = o2.getPeriod(true).getNumber();
                    return account1.compareTo(account2);
                }
            });
        }
    }

    private String buildLabelAp(String dimen, Map<String, DynamicObject> dimenMap, Map<String, DynamicInfoCollection.InfoObject> customdimMap) {
        DynamicObject dynamicObject;
        String label = null;
        if ("account".equals(dimen)) {
            dynamicObject = dimenMap.get(dimen);
            DynamicObject fbasedataid = (DynamicObject)dynamicObject.get("fbasedataid");
            label = fbasedataid.getString("name");
        }
        if ("entity".equals(dimen)) {
            dynamicObject = dimenMap.get(dimen);
            label = dynamicObject.getString("name");
        }
        if (dimen.contains("execustomdim")) {
            DynamicInfoCollection.InfoObject stringMap = customdimMap.get(dimen);
            label = (String)stringMap.getValueByPropName("name");
        }
        LinkedList<String> labelList = new LinkedList<String>();
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey("flexpanelaps");
        LabelAp labelAp = new LabelAp();
        labelAp.setKey("labelAp0");
        labelAp.setFontSize(14);
        labelAp.setForeColor("themeColor");
        labelAp.setName(new LocaleString(label));
        labelList.add(label);
        this.getPageCache().put("labelList", SerializationUtils.serializeToBase64(labelList));
        flexPanelAp.getItems().add(labelAp);
        this.getView().updateControlMetadata("flexpanelaps", flexPanelAp.createControl());
        return label;
    }

    private Map<Integer, IBudgetBalance> setIBudgetBalance(Long modelId, String fieldName, String dimen, Map<String, DynamicObject> dimenMap, Map<String, DynamicInfoCollection.InfoObject> customdimMap, IBudgetBalance iBudget, List<DynamicObject> dimenObject, List<String> periodList) {
        Collection<IBudgetBalance> filterIBudgetBalance;
        BigDecimal price;
        BgControlCallerImpl bgControlCaller = new BgControlCallerImpl();
        String analyze = this.getPageCache().get("analyzeLists");
        List<Map<String, String>> dimlist = this.getMapsFlite(dimenObject, dimenMap, dimen, customdimMap, iBudget, periodList);
        if (!analyzeLists.contains(fieldName) && StringUtils.isEmpty((String)analyze) && dimlist.size() > 0) {
            String periodNumber = dimlist.get(0).get(SysDimensionEnum.Period.getNumber());
            this.getDimensionCoyes(dimlist, periodNumber);
        }
        Collection<String> type = this.dealSettingType(dimlist);
        Collection<IBudgetBalance> iBudgetBalances = this.getSelectBalance(modelId, bgControlCaller, dimlist, type);
        HashMap<String, Object> balanceCacheMap = new HashMap<String, Object>(16);
        balanceCacheMap.put("modelId", modelId);
        balanceCacheMap.put("dimlist", dimlist);
        balanceCacheMap.put("type", type);
        balanceCacheMap.put("fieldName", fieldName);
        balanceCacheMap.put("customdimMap", customdimMap);
        this.getPageCache().put("balanceCache", SerializationUtils.serializeToBase64(balanceCacheMap));
        Map<Integer, IBudgetBalance> integerIBudgetBalanceMap = null;
        Collection<IBudgetBalance> moniBudgetBalances = this.getiBudgetBalances(type, iBudgetBalances);
        if (moniBudgetBalances.size() > 0) {
            this.getiBudgetBalances(moniBudgetBalances);
            String priceStr = "1";
            price = new BigDecimal(priceStr);
            filterIBudgetBalance = this.getiFilterBalances(fieldName, moniBudgetBalances);
            if (filterIBudgetBalance.size() <= 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u65e0\u6709\u6548\u6570\u636e\u3002", (String)"AnalyzeWayPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u6ca1\u6709\u4e0b\u7ea7\uff0c\u65e0\u6cd5\u6309\u5c42\u7ea7\u5206\u6790\u3002", (String)"AnalyzeWayPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.isTimeSort(filterIBudgetBalance);
        integerIBudgetBalanceMap = this.buildEntryentity(customdimMap, price, filterIBudgetBalance);
        return integerIBudgetBalanceMap;
    }

    private void getDimensionCoyes(List<Map<String, String>> dimlist, String periodNumber) {
        Matcher matcher = COM.matcher(periodNumber);
        String trim = matcher.replaceAll("").trim();
        String substring = null;
        if (trim.equals(periodNumber.substring(periodNumber.length() - 2))) {
            substring = periodNumber.substring(0, periodNumber.length() - 2);
        } else if (trim.equals(periodNumber.substring(periodNumber.length() - 1))) {
            substring = periodNumber.substring(0, periodNumber.length() - 1);
        } else {
            return;
        }
        int month = Integer.parseInt(trim);
        if (month > 1) {
            ArrayList dimlists = new ArrayList(dimlist.size());
            HashMap<String, String> dimMap = null;
            for (Map<String, String> map : dimlist) {
                dimMap = new HashMap<String, String>(16);
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    dimMap.put(entry.getKey(), entry.getValue());
                }
                dimlists.add(dimMap);
            }
            for (int i = 0; i < month - 1; ++i) {
                ArrayList arrayList = new ArrayList(dimlist.size());
                HashMap hashMap = null;
                for (Map map : dimlists) {
                    hashMap = new HashMap(16);
                    for (Map.Entry entry : map.entrySet()) {
                        hashMap.put(entry.getKey(), entry.getValue());
                    }
                    arrayList.add(hashMap);
                }
                for (Map map : arrayList) {
                    map.put(SysDimensionEnum.Period.getNumber(), substring + (i + 1));
                }
                dimlist.addAll(arrayList);
            }
        }
        this.getPageCache().put("analyzeLists", "1");
    }

    private Collection<IBudgetBalance> getSelectBalance(Long modelId, BgControlCallerImpl bgControlCaller, List<Map<String, String>> dimlist, Collection<String> type) {
        Collection iBudgetBalances = null;
        try {
            iBudgetBalances = bgControlCaller.queryBalance(modelId, dimlist, type, true);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getView().showTipNotification(e.getMessage());
        }
        return iBudgetBalances;
    }

    private DynamicObject[] getDynamicObjects(Long modelId, String dimen, Map<String, DynamicObject> dimenMap, Map<String, DynamicInfoCollection.InfoObject> customdimMap, IBudgetBalance iBudget) {
        DynamicObject dimenId = null;
        String entityName = null;
        DynamicObject[] dimObj = new DynamicObject[]{};
        Long dimensionID = this.getDimensionID(dimen, iBudget);
        if ("account".equals(dimen)) {
            entityName = "epm_accountmembertree";
            if (dimensionID == 0L) {
                if (dimenMap.get(dimen) != null) {
                    dimenId = dimenMap.get(dimen);
                    dimenId = this.getDimenId(modelId, dimenId.getLong("fbasedataid_id"), entityName);
                }
            } else {
                dimenId = this.getDimenId(modelId, dimensionID, entityName);
            }
            dimObj = this.getDynamicObjects(dimenId, modelId, entityName);
        } else if ("entity".equals(dimen)) {
            entityName = "epm_entitymembertree";
            if (dimensionID == 0L) {
                if (dimenMap.get(dimen) != null) {
                    dimenId = dimenMap.get(dimen);
                    dimenId = this.getDimenId(modelId, dimenId.getLong("id"), entityName);
                }
            } else {
                dimenId = this.getDimenId(modelId, dimensionID, entityName);
            }
            dimObj = this.getDynamicObjects(dimenId, modelId, entityName);
        } else if ("period".equals(dimen)) {
            entityName = "epm_periodmembertree";
            if (dimensionID == 0L) {
                if (dimenMap.get(dimen) != null) {
                    dimenId = dimenMap.get(dimen);
                    dimenId = this.getDimenId(modelId, dimenId.getLong("id"), entityName);
                }
            } else {
                dimenId = this.getDimenId(modelId, dimensionID, entityName);
            }
            dimObj = this.getDynamicObjects(dimenId, modelId, entityName);
        } else if (dimen.contains("execustomdim")) {
            DynamicInfoCollection.InfoObject stringMap = customdimMap.get(dimen);
            entityName = "epm_userdefinedmembertree";
            dimenId = dimensionID == 0L ? this.getDimenIdByNumber(modelId, (String)stringMap.getValueByPropName("number"), entityName) : this.getDimenId(modelId, dimensionID, entityName);
            if (dimenId != null) {
                dimObj = this.getDynamicObjects(dimenId, modelId, entityName);
            }
        }
        this.getPageCache().put("entityName", entityName);
        if (dimObj.length == 0) {
            dimObj = new DynamicObject[]{dimenId};
        }
        return dimObj;
    }

    private Map<String, DynamicInfoCollection.InfoObject> getCustomdimMap() {
        String customdims = this.getPageCache().get("customdimMap");
        Map<String, Object> customdimMap = new HashMap<String, DynamicInfoCollection.InfoObject>(16);
        if (StringUtils.isNotEmpty((String)customdims)) {
            customdimMap = (Map)SerializationUtils.deSerializeFromBase64((String)customdims);
        }
        return customdimMap;
    }

    private Map<Integer, IBudgetBalance> buildEntryentity(Map<String, DynamicInfoCollection.InfoObject> customdimMap, BigDecimal price, Collection<IBudgetBalance> filterIBudgetBalance) {
        IDataModel model = this.getModel();
        HashMap<Integer, IBudgetBalance> filterIBudgetMap = new HashMap<Integer, IBudgetBalance>(16);
        model.deleteEntryData(ENTRYENTITY);
        ArrayList visibles = new ArrayList(16);
        List controls = ((EntryGrid)this.getControl(ENTRYENTITY)).getControls();
        controls.forEach(e -> {
            if (e.getKey().contains("map")) {
                visibles.add(e.getKey());
            }
        });
        visibles.addAll(Lists.newArrayList((Object[])new String[]{"entitytpye", "entitynumber", "entitydate", "deletedate", "btn_baritemap"}));
        visibles.addAll(Lists.newArrayList((Object[])new String[]{"entryfieldgroupap", "entryfieldgroupap6", "execustomdimmap11", "execustomdimmap21", "execustomdimmap31", "execustomdimmap41", "execustomdimmap51", "execustomdimmap61"}));
        this.getView().setVisible(Boolean.valueOf(false), visibles.toArray(new String[0]));
        if (filterIBudgetBalance.size() > 0) {
            model.batchCreateNewEntryRow(ENTRYENTITY, filterIBudgetBalance.size());
            int ll = 0;
            for (IBudgetBalance balance : filterIBudgetBalance) {
                DynamicObject entryen = model.getEntryRowEntity(ENTRYENTITY, ll);
                if (balance.getAccount(true) != null) {
                    entryen.set("account", (Object)balance.getAccount(true).getName());
                }
                if (balance.getBudget() != null) {
                    entryen.set("budget", (Object)balance.getBudget().divide(price));
                }
                if (balance.getOccupation() != null) {
                    entryen.set("occupy", (Object)balance.getOccupation().divide(price));
                }
                if (balance.getExecute() != null) {
                    entryen.set("execute", (Object)balance.getExecute().divide(price));
                }
                if (balance.getOccupation() != null && balance.getExecute() != null) {
                    entryen.set("budgetcount", (Object)balance.getOccupation().divide(price).add(balance.getExecute().divide(price)));
                }
                if (balance.getOccupation() != null && balance.getExecute() == null) {
                    entryen.set("budgetcount", (Object)balance.getOccupation().divide(price));
                }
                if (balance.getOccupation() == null && balance.getExecute() != null) {
                    entryen.set("budgetcount", (Object)balance.getExecute().divide(price));
                }
                if (balance.getBalance() != null) {
                    entryen.set("balance", (Object)balance.getBalance().divide(price));
                }
                if (balance.getExecute() != null && balance.getBudget() != null) {
                    String format = "";
                    int k = balance.getBudget().compareTo(BigDecimal.ZERO);
                    format = k == 0 ? balance.getExecute().multiply(BgConstant.HUNDRED).toPlainString() : balance.getExecute().multiply(BgConstant.HUNDRED).divide(balance.getBudget(), 2, 4).toPlainString();
                    entryen.set("decimalfield", (Object)(format + "%"));
                }
                if (balance.getOrgUnit(true) != null) {
                    entryen.set("entity", (Object)balance.getOrgUnit(true).getName());
                }
                if (balance.getPeriod(true) != null) {
                    String periodName = this.getPeriodName(balance);
                    entryen.set("period", (Object)periodName);
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"execustomdim1", "execustomdim2", "execustomdim3", "execustomdim4", "execustomdim5", "execustomdim6"});
                EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
                if (customdimMap != null) {
                    for (Map.Entry<String, DynamicInfoCollection.InfoObject> stringMapEntry : customdimMap.entrySet()) {
                        grid.setColumnProperty(stringMapEntry.getKey(), "header", (Object)new LocaleString((String)stringMapEntry.getValue().getValueByPropName("name")));
                        grid.setColumnProperty(stringMapEntry.getKey() + "2", "header", (Object)new LocaleString((String)stringMapEntry.getValue().getValueByPropName("name")));
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{stringMapEntry.getKey()});
                        if (balance.getMember(true, (String)stringMapEntry.getValue().getValueByPropName("number")) == null) continue;
                        entryen.set(stringMapEntry.getKey(), (Object)balance.getMember(true, (String)stringMapEntry.getValue().getValueByPropName("number")).getName());
                    }
                    this.getView().updateView(ENTRYENTITY);
                }
                filterIBudgetMap.put(ll, balance);
                ++ll;
            }
        }
        this.getPageCache().put("iBudgetBalance", SerializationUtils.serializeToBase64(filterIBudgetMap));
        this.getPageCache().put("header", "1");
        return filterIBudgetMap;
    }

    private String getPeriodName(IBudgetBalance balance) {
        if (balance.getPeriod(true) != null) {
            List acPeriod = balance.getAcPeriod();
            if (acPeriod.size() == 1) {
                return balance.getPeriod(true).getName();
            }
            if (acPeriod.size() == 3) {
                if (ResManager.loadKDString((String)"3\u6708", (String)"AnalyzeWayPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(balance.getPeriod(true).getName())) {
                    return ResManager.loadKDString((String)"\u4e00\u5b63\u5ea6", (String)"AnalyzeWayPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
                if (ResManager.loadKDString((String)"6\u6708", (String)"AnalyzeWayPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(balance.getPeriod(true).getName())) {
                    return ResManager.loadKDString((String)"\u4e8c\u5b63\u5ea6", (String)"AnalyzeWayPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
                if (ResManager.loadKDString((String)"9\u6708", (String)"AnalyzeWayPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(balance.getPeriod(true).getName())) {
                    return ResManager.loadKDString((String)"\u4e09\u5b63\u5ea6", (String)"AnalyzeWayPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
                if (ResManager.loadKDString((String)"12\u6708", (String)"AnalyzeWayPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(balance.getPeriod(true).getName())) {
                    return ResManager.loadKDString((String)"\u56db\u5b63\u5ea6", (String)"AnalyzeWayPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
            }
            if (acPeriod.size() == 6) {
                if (ResManager.loadKDString((String)"6\u6708", (String)"AnalyzeWayPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(balance.getPeriod(true).getName())) {
                    return ResManager.loadKDString((String)"\u4e0a\u534a\u5e74", (String)"AnalyzeWayPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
                if (ResManager.loadKDString((String)"12\u6708", (String)"AnalyzeWayPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(balance.getPeriod(true).getName())) {
                    return ResManager.loadKDString((String)"\u4e0b\u534a\u5e74", (String)"AnalyzeWayPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
            }
            if (acPeriod.size() == 2) {
                if (ResManager.loadKDString((String)"2\u5b63\u5ea6", (String)"AnalyzeWayPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(balance.getPeriod(true).getName())) {
                    return ResManager.loadKDString((String)"\u4e0a\u534a\u5e74", (String)"AnalyzeWayPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
                if (ResManager.loadKDString((String)"4\u5b63\u5ea6", (String)"AnalyzeWayPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(balance.getPeriod(true).getName())) {
                    return ResManager.loadKDString((String)"\u4e0b\u534a\u5e74", (String)"AnalyzeWayPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]);
                }
            }
        }
        return "";
    }

    private Collection<IBudgetBalance> getiFilterBalances(String fieldName, Collection<IBudgetBalance> moniBudgetBalances) {
        ArrayList<IBudgetBalance> filterIBudgetBalance = new ArrayList<IBudgetBalance>(16);
        BigInteger integer = new BigInteger("0");
        if (budgetLists.contains(fieldName)) {
            for (IBudgetBalance balance : moniBudgetBalances) {
                if ((balance.getBudget() == null || balance.getBudget().toBigInteger().equals(integer)) && (balance.getBalance() == null || balance.getBalance().toBigInteger().equals(integer))) continue;
                filterIBudgetBalance.add(balance);
            }
        } else {
            for (IBudgetBalance balance : moniBudgetBalances) {
                if ((balance.getOccupation() == null || balance.getOccupation().toBigInteger().equals(integer)) && (balance.getExecute() == null || balance.getExecute().toBigInteger().equals(integer))) continue;
                filterIBudgetBalance.add(balance);
            }
        }
        return filterIBudgetBalance;
    }

    private Collection<IBudgetBalance> getiBudgetBalances(Collection<IBudgetBalance> iBudgetBalances) {
        if (!(iBudgetBalances instanceof ArrayList)) {
            throw new KDBizException("ExecuteAnalyze createEntry()");
        }
        ((ArrayList)iBudgetBalances).sort(new Comparator<IBudgetBalance>(){

            @Override
            public int compare(IBudgetBalance o1, IBudgetBalance o2) {
                String account1 = o1.getAccount(true).getNumber();
                String account2 = o2.getAccount(true).getNumber();
                return account2.compareTo(account1);
            }
        });
        return iBudgetBalances;
    }

    private Collection<IBudgetBalance> getiBudgetBalances(Collection<String> type, Collection<IBudgetBalance> iBudgetBalances) {
        ArrayList<IBudgetBalance> moniBudgetBalances = new ArrayList<IBudgetBalance>(16);
        if (iBudgetBalances != null) {
            ArrayList<String> list = new ArrayList<String>(16);
            Iterator<String> iterator = type.iterator();
            if (iterator.hasNext()) {
                list.add(iterator.next());
            }
            for (IBudgetBalance ib : iBudgetBalances) {
                if (!ib.getSetting().getSettingType().getNumber().equals(list.get(0))) continue;
                moniBudgetBalances.add(ib);
            }
        }
        return moniBudgetBalances;
    }

    private List<Map<String, String>> getMapsFlite(List<DynamicObject> dimenObject, Map<String, DynamicObject> dimenMap, String dimen, Map<String, DynamicInfoCollection.InfoObject> customdimMap, IBudgetBalance iBudget, List<String> periodList) {
        ArrayList<Map<String, String>> dimlist = new ArrayList<Map<String, String>>(16);
        if (dimenObject != null) {
            for (DynamicObject dynamicObject : dimenObject) {
                HashMap<String, String> accountMap = new HashMap<String, String>(6);
                this.getAccountMap(dimenMap, dimen, iBudget, accountMap, dynamicObject);
                this.getEntityMap(dimenMap, dimen, iBudget, accountMap, dynamicObject);
                this.getDimensionMap(dimenMap, dimen, iBudget, accountMap, dynamicObject);
                if (dimenMap != null) {
                    accountMap.put(SysDimensionEnum.Version.getNumber(), dimenMap.get("version").getString("number"));
                } else if (iBudget != null) {
                    accountMap.put(SysDimensionEnum.Version.getNumber(), iBudget.getVersion(true).getNumber());
                }
                if (dimen.contains("execustomdim")) {
                    this.setcustomMap(dimen, customdimMap, iBudget, accountMap, dynamicObject);
                } else {
                    for (Map.Entry<String, DynamicInfoCollection.InfoObject> stringMapEntry : customdimMap.entrySet()) {
                        if (iBudget != null) {
                            accountMap.put((String)stringMapEntry.getValue().getValueByPropName("number"), iBudget.getMember(true, (String)stringMapEntry.getValue().getValueByPropName("number")).getNumber());
                            continue;
                        }
                        accountMap.put((String)stringMapEntry.getValue().getValueByPropName("number"), (String)stringMapEntry.getValue().getValueByPropName("number"));
                    }
                }
                dimlist.add(accountMap);
            }
        } else {
            for (String period : periodList) {
                HashMap<String, String> accountMap = new HashMap<String, String>(6);
                this.buildAccountMap(dimenMap, iBudget, accountMap);
                if ("period".equals(dimen)) {
                    accountMap.put(SysDimensionEnum.Period.getNumber(), period);
                } else if (dimenMap != null) {
                    accountMap.put(SysDimensionEnum.Period.getNumber(), dimenMap.get("period").getString("number"));
                } else if (iBudget != null) {
                    accountMap.put(SysDimensionEnum.Period.getNumber(), iBudget.getPeriod(true).getNumber());
                }
                if (dimen.startsWith("execustomdim")) {
                    for (Map.Entry<String, DynamicInfoCollection.InfoObject> stringMapEntry : customdimMap.entrySet()) {
                        if (iBudget != null) {
                            accountMap.put((String)stringMapEntry.getValue().getValueByPropName("number"), iBudget.getMember(true, (String)stringMapEntry.getValue().getValueByPropName("number")).getNumber());
                            continue;
                        }
                        accountMap.put((String)stringMapEntry.getValue().getValueByPropName("number"), (String)stringMapEntry.getValue().getValueByPropName("number"));
                    }
                }
                dimlist.add(accountMap);
            }
        }
        return dimlist;
    }

    private void getDimensionMap(Map<String, DynamicObject> dimenMap, String dimen, IBudgetBalance iBudget, Map<String, String> accountMap, DynamicObject dynamicObject) {
        if (dimenMap != null) {
            accountMap.put(SysDimensionEnum.Currency.getNumber(), dimenMap.get("currency").getString("number"));
        } else if (iBudget != null) {
            accountMap.put(SysDimensionEnum.Currency.getNumber(), iBudget.getCurrency(true).getNumber());
        }
        if (dimenMap != null) {
            accountMap.put(SysDimensionEnum.Year.getNumber(), dimenMap.get("year").getString("number"));
        } else if (iBudget != null) {
            accountMap.put(SysDimensionEnum.Year.getNumber(), iBudget.getYear(true).getNumber());
        }
        if ("period".equals(dimen)) {
            accountMap.put(SysDimensionEnum.Period.getNumber(), dynamicObject.getString("number"));
        } else if (dimenMap != null) {
            accountMap.put(SysDimensionEnum.Period.getNumber(), dimenMap.get("period").getString("number"));
        } else if (iBudget != null) {
            List acPeriod = iBudget.getAcPeriod();
            if (acPeriod.size() > 2) {
                String periodNumber = (String)((List)acPeriod.get(acPeriod.size() - 1)).get(1);
                this.setAccountMap(accountMap, acPeriod, periodNumber);
            } else if (acPeriod.size() == 2) {
                String periodNumber = (String)((List)acPeriod.get(acPeriod.size() - 1)).get(1);
                if ("Q_Q2".equals(periodNumber)) {
                    accountMap.put(SysDimensionEnum.Period.getNumber(), "Q_HF1");
                } else {
                    accountMap.put(SysDimensionEnum.Period.getNumber(), "Q_HF2");
                }
            } else {
                accountMap.put(SysDimensionEnum.Period.getNumber(), iBudget.getPeriod(true).getNumber());
            }
        }
    }

    private void getEntityMap(Map<String, DynamicObject> dimenMap, String dimen, IBudgetBalance iBudget, Map<String, String> accountMap, DynamicObject dynamicObject) {
        if ("entity".equals(dimen)) {
            accountMap.put(SysDimensionEnum.Entity.getNumber(), dynamicObject.getString("number"));
        } else if (dimenMap != null) {
            accountMap.put(SysDimensionEnum.Entity.getNumber(), dimenMap.get("entity").getString("number"));
        } else if (iBudget != null) {
            accountMap.put(SysDimensionEnum.Entity.getNumber(), iBudget.getOrgUnit(true).getNumber());
        }
    }

    private void getAccountMap(Map<String, DynamicObject> dimenMap, String dimen, IBudgetBalance iBudget, Map<String, String> accountMap, DynamicObject dynamicObject) {
        if ("account".equals(dimen)) {
            accountMap.put(SysDimensionEnum.Account.getNumber(), dynamicObject.getString("number"));
        } else if (dimenMap != null) {
            Object data = dimenMap.get("account").get("fbasedataid");
            if (data instanceof DynamicObject) {
                DynamicObject object = (DynamicObject)data;
                accountMap.put(SysDimensionEnum.Account.getNumber(), object.getString("number"));
            }
        } else if (iBudget != null) {
            accountMap.put(SysDimensionEnum.Account.getNumber(), iBudget.getAccount(true).getNumber());
        }
    }

    private void buildAccountMap(Map<String, DynamicObject> dimenMap, IBudgetBalance iBudget, Map<String, String> accountMap) {
        if (dimenMap != null) {
            accountMap.put(SysDimensionEnum.Account.getNumber(), dimenMap.get("account").getString("number"));
            accountMap.put(SysDimensionEnum.Entity.getNumber(), dimenMap.get("entity").getString("number"));
            accountMap.put(SysDimensionEnum.Currency.getNumber(), dimenMap.get("currency").getString("number"));
            accountMap.put(SysDimensionEnum.Year.getNumber(), dimenMap.get("year").getString("number"));
            accountMap.put(SysDimensionEnum.Version.getNumber(), dimenMap.get("version").getString("number"));
        } else {
            accountMap.put(SysDimensionEnum.Account.getNumber(), iBudget.getAccount(true).getNumber());
            accountMap.put(SysDimensionEnum.Entity.getNumber(), iBudget.getOrgUnit(true).getNumber());
            accountMap.put(SysDimensionEnum.Currency.getNumber(), iBudget.getCurrency(true).getNumber());
            accountMap.put(SysDimensionEnum.Year.getNumber(), iBudget.getYear(true).getNumber());
            accountMap.put(SysDimensionEnum.Version.getNumber(), iBudget.getVersion(true).getNumber());
        }
    }

    private void setcustomMap(String dimen, Map<String, DynamicInfoCollection.InfoObject> customdimMap, IBudgetBalance iBudget, Map<String, String> accountMap, DynamicObject dynamicObject) {
        for (Map.Entry<String, DynamicInfoCollection.InfoObject> stringMapEntry : customdimMap.entrySet()) {
            if (dimen.equals(stringMapEntry.getKey())) {
                DynamicInfoCollection.InfoObject stringStringMap = customdimMap.get(dimen);
                accountMap.put((String)stringStringMap.getValueByPropName("number"), dynamicObject.getString("number"));
                continue;
            }
            if (iBudget != null) {
                accountMap.put((String)stringMapEntry.getValue().getValueByPropName("number"), iBudget.getMember(true, (String)stringMapEntry.getValue().getValueByPropName("number")).getNumber());
                continue;
            }
            accountMap.put((String)stringMapEntry.getValue().getValueByPropName("number"), (String)stringMapEntry.getValue().getValueByPropName("number"));
        }
    }

    private void setAccountMap(Map<String, String> accountMap, List<List<String>> acPeriod, String periodNumber) {
        if ("M_M03".equals(periodNumber)) {
            accountMap.put(SysDimensionEnum.Period.getNumber(), "M_Q1");
        } else if ("M_M06".equals(periodNumber) && acPeriod.size() == 3) {
            accountMap.put(SysDimensionEnum.Period.getNumber(), "M_Q2");
        } else if ("M_M09".equals(periodNumber)) {
            accountMap.put(SysDimensionEnum.Period.getNumber(), "M_Q3");
        } else if ("M_M12".equals(periodNumber) && acPeriod.size() == 3) {
            accountMap.put(SysDimensionEnum.Period.getNumber(), "M_Q4");
        } else if ("M_M06".equals(periodNumber) && acPeriod.size() == 6) {
            accountMap.put(SysDimensionEnum.Period.getNumber(), "M_HF1");
        } else if ("M_M12".equals(periodNumber) && acPeriod.size() == 6) {
            accountMap.put(SysDimensionEnum.Period.getNumber(), "M_HF2");
        }
    }

    private List<DynamicObject> getWrongNodeList(DynamicObject[] dimObj, List<DynamicObject> wrongNodeList, Long modelId, String entityName) {
        for (int i = 0; i < dimObj.length; ++i) {
            boolean isleaf = (Boolean)dimObj[i].get("isleaf");
            if (isleaf) {
                wrongNodeList.add(dimObj[i]);
                continue;
            }
            DynamicObject[] dynamicObjects = this.getDynamicObjects(dimObj[i], modelId, entityName);
            if (dynamicObjects.length <= 0) continue;
            this.getWrongNodeList(dynamicObjects, wrongNodeList, modelId, entityName);
        }
        return wrongNodeList;
    }

    private DynamicObject[] getDynamicObjects(DynamicObject dimenId, Long modelId, String indicate) {
        if (dimenId != null) {
            QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
            QFilter parentFilterId = new QFilter("parent", "=", (Object)dimenId.getLong("id"));
            return BusinessDataServiceHelper.load((String)indicate, (String)"id,number,name,dseq,isleaf,longnumber", (QFilter[])new QFilter[]{modelFilter, parentFilterId});
        }
        return new DynamicObject[0];
    }

    private DynamicObject getDimenId(Long modelId, Long dimenId, String indicate) {
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        QFilter parentFilter = new QFilter("id", "=", (Object)dimenId);
        return BusinessDataServiceHelper.loadSingleFromCache((String)indicate, (String)"id,number,name,dseq,isleaf", (QFilter[])new QFilter[]{modelFilter, parentFilter});
    }

    private DynamicObject getDimenIdByNumber(Long modelId, String dimenNumber, String indicate) {
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        QFilter parentFilter = new QFilter("number", "=", (Object)dimenNumber);
        return BusinessDataServiceHelper.loadSingleFromCache((String)indicate, (String)"id,number,name,dseq,isleaf", (QFilter[])new QFilter[]{modelFilter, parentFilter});
    }

    private Collection<String> dealSettingType(List<Map<String, String>> dimlist) {
        ArrayList<String> type = new ArrayList<String>(2);
        if (dimlist.size() > 0) {
            String periodNumber = dimlist.get(0).get(SysDimensionEnum.Period.getNumber());
            if (periodNumber.startsWith("M_Q")) {
                type.add(BgControlSettingTypeEnum.QUARTER.getNumber());
                type.add(BgControlSettingTypeEnum.QUARTER_ADDUP.getNumber());
            } else if (periodNumber.startsWith("Q_Q")) {
                type.add(BgControlSettingTypeEnum.QUARTER.getNumber());
                type.add(BgControlSettingTypeEnum.QUARTER_ADDUP.getNumber());
            } else if (periodNumber.startsWith("M_HF")) {
                type.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
                type.add(BgControlSettingTypeEnum.MONTH_BY_YEAR_CURR_GROSS.getNumber());
            } else if (periodNumber.startsWith("Q_HF")) {
                type.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
                type.add(BgControlSettingTypeEnum.QUARTER_HALFYEAR_ADDUP.getNumber());
            } else if (periodNumber.endsWith("_YearTotal")) {
                type.add(BgControlSettingTypeEnum.YEAR.getNumber());
            } else if (periodNumber.startsWith("HF_")) {
                type.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
                type.add(BgControlSettingTypeEnum.HALFYEAR_ADDUP.getNumber());
            } else {
                type.add(BgControlSettingTypeEnum.MONTH.getNumber());
                type.add(BgControlSettingTypeEnum.MONTH_BY_YEAR_CURR_GROSS.getNumber());
            }
        }
        return type;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"account", "entity", "execustomdim1", "execustomdim2", "execustomdim3", "execustomdim4", "execustomdim5", "execustomdim6", "exehierarchy", "exedetail"});
        this.addClickListeners(new String[]{"bnt_conform", "bnt_cancel"});
        String formId = this.getView().getFormShowParameter().getFormId();
        if (EB_RELEVANCEANALYZE.equals(formId)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_baritemap": {
                this.bariteBariteMap();
                this.getView().updateView(ENTRYENTITY);
                break;
            }
            case "btn_closemap": {
                this.bariteCloseMap();
                this.getView().updateView(ENTRYENTITY);
                break;
            }
            case "btn_export": {
                this.exportData();
                break;
            }
            case "btn_refresh": {
                this.refreshEntryentity();
                break;
            }
        }
    }

    private void bariteCloseMap() {
        if ("3".equals(this.getPageCache().get("header"))) {
            this.getPageCache().put("header", "2");
            this.refreshEntryentity();
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryfieldgroupap", "entryfieldgroupap6", "execustomdimmap11", "execustomdimmap21", "execustomdimmap31", "execustomdimmap41", "execustomdimmap51", "execustomdimmap61"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"accountmap1", "accountmap2", "entitymap1", "entitymap2", "auxaccountmap11", "auxentitymap11"});
        this.setUserdefVisible(false);
        Map<String, DynamicInfoCollection.InfoObject> customdimMap = this.getCustomdimMap();
        for (Map.Entry<String, DynamicInfoCollection.InfoObject> stringMapEntry : customdimMap.entrySet()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{stringMapEntry.getKey() + "2"});
        }
        this.getPageCache().put("header", "2");
    }

    private Map<String, List<IBudgetBalance>> loadMapping(Map<Object, DynamicObject> docs) {
        if (!"3".equals(this.getPageCache().get("header"))) {
            return new HashMap<String, List<IBudgetBalance>>(10);
        }
        HashMap billMap = Maps.newHashMapWithExpectedSize((int)10);
        if (docs != null) {
            for (DynamicObject record : docs.values()) {
                billMap.computeIfAbsent(record.getString("entitynumber"), f -> new HashSet(10)).add(record.getString("bizid"));
            }
        }
        HashMap balanceMap = Maps.newHashMapWithExpectedSize((int)10);
        if (billMap.isEmpty()) {
            return balanceMap;
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getFormModelId());
        List dimensions = modelCache.getDimensionList();
        BgControlCallerImpl caller = new BgControlCallerImpl();
        ArrayList<Object> keys = new ArrayList<Object>();
        for (Map.Entry entry : billMap.entrySet()) {
            Map subMap = caller.queryMapping((String)entry.getKey(), (Set)entry.getValue(), Long.valueOf(this.getFormModelId()));
            if (subMap == null) continue;
            for (Map.Entry subEntry : subMap.entrySet()) {
                for (IBudgetBalance balance : (List)subEntry.getValue()) {
                    balance.setCheckPermission(false);
                    keys.clear();
                    keys.add(entry.getKey());
                    keys.add(subEntry.getKey());
                    for (Dimension dimension : dimensions) {
                        if (this.isIrgDimension(dimension.getNumber())) continue;
                        keys.add(balance.getMember(false, dimension.getNumber()));
                    }
                    String key = StringUtils.join(keys, (String)",");
                    balanceMap.computeIfAbsent(key, f -> new ArrayList(10)).add(balance);
                    keys.remove(0);
                    key = StringUtils.join(keys, (String)",");
                    balanceMap.computeIfAbsent(key, f -> new ArrayList(10)).add(balance);
                }
            }
        }
        return balanceMap;
    }

    private boolean isIrgDimension(String dimensionNumber) {
        return SysDimensionEnum.Scenario.getNumber().equals(dimensionNumber) || SysDimensionEnum.Version.getNumber().equals(dimensionNumber) || SysDimensionEnum.AuditTrail.getNumber().equals(dimensionNumber) || SysDimensionEnum.ChangeType.getNumber().equals(dimensionNumber) || SysDimensionEnum.DataType.getNumber().equals(dimensionNumber) || SysDimensionEnum.InternalCompany.getNumber().equals(dimensionNumber) || SysDimensionEnum.Process.getNumber().equals(dimensionNumber);
    }

    private void bariteBariteMap() {
        if (!"3".equals(this.getPageCache().get("header"))) {
            this.getPageCache().put("header", "3");
            this.refreshEntryentity();
        }
        if (StringUtils.isNotEmpty((String)this.getPageCache().get("accountfield"))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"entryfieldgroupap", "accountmap1", "accountmap2", "auxaccountmap11"});
        }
        if (StringUtils.isNotEmpty((String)this.getPageCache().get("entryfield"))) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"entryfieldgroupap6", "entitymap1", "entitymap2", "auxentitymap11"});
        }
        this.setUserdefVisible(true);
        this.getPageCache().put("header", "3");
    }

    private void setUserdefVisible(boolean isVisible) {
        String custom = this.getPageCache().get("custom");
        if (StringUtils.isNotEmpty((String)custom)) {
            Map customMap = (Map)SerializationUtils.deSerializeFromBase64((String)custom);
            Set integers = customMap.keySet();
            for (Integer index : integers) {
                this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"customdimmap" + index + "1", "customdimmap" + index + "2", "auxcustomdimmap" + index + "1", "execustomdimmap" + index + "1"});
            }
        }
    }

    private void exportData() {
        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"AnalyzeWayPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        LinkedList<DynamicObject> entityList = new LinkedList<DynamicObject>();
        for (int selectRow : selectRows) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, selectRow);
            entityList.add(entryRowEntity);
        }
        XSSFWorkbook excelBook = new XSSFWorkbook();
        Map<String, DynamicInfoCollection.InfoObject> customdimMap = this.getCustomdimMap();
        ArrayList header1 = Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u79d1\u76ee", (String)"AnalyzeWayPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"AnalyzeWayPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u671f\u95f4\u8303\u56f4", (String)"AnalyzeWayPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0])});
        ArrayList headerz = Lists.newArrayList((Object[])new String[]{"account", "entity", "period"});
        ArrayList headery = Lists.newArrayList((Object[])new String[]{"account", "entity", "period"});
        if (customdimMap.size() > 0) {
            for (Map.Entry<String, DynamicInfoCollection.InfoObject> stringMapEntry : customdimMap.entrySet()) {
                header1.add(stringMapEntry.getValue().getValueByPropName("name"));
                headerz.add(stringMapEntry.getKey());
                headery.add(stringMapEntry.getKey());
            }
        }
        this.handleData(entityList, excelBook, customdimMap, header1, headerz, headery);
        if ("1".equals(this.getPageCache().get("header")) || "2".equals(this.getPageCache().get("header"))) {
            this.constructionExcel(excelBook, header1, headerz, headery, entityList);
        }
        this.exportEntity(excelBook);
    }

    private void handleData(List<DynamicObject> entityList, XSSFWorkbook excelBook, Map<String, DynamicInfoCollection.InfoObject> customdimMap, ArrayList<String> header1, ArrayList<String> headerz, ArrayList<String> headery) {
        if ("1".equals(this.getPageCache().get("header"))) {
            ArrayList header = Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u9884\u7b97\u6570", (String)"AnalyzeWayPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5360\u7528\u6570", (String)"AnalyzeWayPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6267\u884c\u6570", (String)"AnalyzeWayPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5360\u7528\u6267\u884c\u603b\u6570", (String)"AnalyzeWayPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9884\u7b97\u4f59\u989d", (String)"AnalyzeWayPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9884\u5b9e\u6bd4", (String)"AnalyzeWayPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0])});
            ArrayList headers = Lists.newArrayList((Object[])new String[]{"budget", "occupy", "execute", "budgetcount", "balance", "decimalfield"});
            header1.addAll(header);
            headerz.addAll(headers);
        } else if ("2".equals(this.getPageCache().get("header"))) {
            ArrayList header = Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b", (String)"AnalyzeWayPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"AnalyzeWayPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6263\u51cf\u65e5\u671f", (String)"AnalyzeWayPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5360\u7528\u6570", (String)"AnalyzeWayPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6267\u884c\u6570", (String)"AnalyzeWayPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0])});
            ArrayList headers = Lists.newArrayList((Object[])new String[]{"entitytpye", "entitynumber", "deletedate", "occupy", "execute"});
            header1.addAll(header);
            headery.addAll(headers);
        } else {
            LinkedList<String> custHeader = new LinkedList<String>();
            LinkedList<String> idenHeader = new LinkedList<String>();
            ArrayList headerName = Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u4e1a\u52a1\u5b57\u6bb5", (String)"AnalyzeWayPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8f85\u52a9\u4e1a\u52a1\u5b57\u6bb5", (String)"AnalyzeWayPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e1a\u52a1\u57fa\u7840\u8d44\u6599", (String)"AnalyzeWayPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0])});
            custHeader.add(ResManager.loadKDString((String)"\u79d1\u76ee", (String)"AnalyzeWayPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            idenHeader.add("account");
            if (StringUtils.isNotEmpty((String)this.getPageCache().get("accountfield"))) {
                custHeader.addAll(headerName);
                idenHeader.add("accountmap1");
                idenHeader.add("auxaccountmap11");
                idenHeader.add("accountmap2");
            }
            custHeader.add(ResManager.loadKDString((String)"\u7ec4\u7ec7", (String)"AnalyzeWayPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            idenHeader.add("entity");
            if (StringUtils.isNotEmpty((String)this.getPageCache().get("entryfield"))) {
                custHeader.addAll(headerName);
                idenHeader.add("entitymap1");
                idenHeader.add("auxentitymap11");
                idenHeader.add("entitymap2");
            }
            custHeader.add(ResManager.loadKDString((String)"\u671f\u95f4\u8303\u56f4", (String)"AnalyzeWayPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            idenHeader.add("period");
            String custom = this.getPageCache().get("custom");
            Map customMap = new HashMap(16);
            if (StringUtils.isNotEmpty((String)custom)) {
                customMap = (Map)SerializationUtils.deSerializeFromBase64((String)custom);
            }
            if (customdimMap.size() > 0) {
                for (Map.Entry<String, DynamicInfoCollection.InfoObject> stringMapEntry : customdimMap.entrySet()) {
                    custHeader.add((String)stringMapEntry.getValue().getValueByPropName("name"));
                    idenHeader.add(stringMapEntry.getKey());
                    for (int i = 1; i <= 6; ++i) {
                        if (!StringUtils.isNotEmpty((String)this.getPageCache().get("userdefined" + i + "field")) || !stringMapEntry.getKey().contains(String.valueOf(i))) continue;
                        custHeader.addAll(headerName);
                        idenHeader.add((String)customMap.get(i) + "1");
                        idenHeader.add("auxcustomdimmap" + i + "1");
                        idenHeader.add((String)customMap.get(i) + "2");
                    }
                }
            }
            ArrayList header = Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b", (String)"AnalyzeWayPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"AnalyzeWayPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6263\u51cf\u65e5\u671f", (String)"AnalyzeWayPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5360\u7528\u6570", (String)"AnalyzeWayPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6267\u884c\u6570", (String)"AnalyzeWayPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0])});
            ArrayList headers = Lists.newArrayList((Object[])new String[]{"entitytpye", "entitynumber", "deletedate", "occupy", "execute"});
            custHeader.addAll(header);
            idenHeader.addAll(headers);
            this.construcutsExcel(excelBook, custHeader, idenHeader, entityList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportEntity(XSSFWorkbook excelBook) {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            try {
                excelBook.write((OutputStream)outStream);
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
            try {
                outStream.flush();
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(ResManager.loadKDString((String)"\u5173\u8054\u5206\u6790.xlsx", (String)"AnalyzeWayPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]), (InputStream)inStream, 10000);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)url);
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
        }
    }

    private void construcutsExcel(XSSFWorkbook excelBook, LinkedList<String> header1, LinkedList<String> headerz, List<DynamicObject> entityList) {
        String billName = ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e", (String)"AnalyzeWayPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        XSSFSheet billSheet = excelBook.createSheet(billName);
        XSSFCellStyle cellStyle = excelBook.createCellStyle();
        int index = 0;
        int count = 0;
        for (int ll = 0; ll < entityList.size() + 1; ++ll) {
            XSSFRow row = billSheet.createRow(ll);
            for (int i1 = 0; i1 < header1.size(); ++i1) {
                XSSFCell cell = null;
                cell = row.createCell(i1);
                if (index == 0) {
                    cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    cellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.index);
                    billSheet.setColumnWidth(count, 3584);
                    cell.setCellStyle((CellStyle)cellStyle);
                    ++count;
                    cell.setCellType(CellType.STRING);
                    cell.setCellValue(header1.get(i1));
                    continue;
                }
                if (!"3".equals(this.getPageCache().get("header"))) continue;
                cell.setCellType(CellType.STRING);
                String strDate = entityList.get(ll - 1).getString(headerz.get(i1));
                if (StringUtils.isEmpty((String)strDate)) continue;
                if ("deletedate".equals(headerz.get(i1))) {
                    Date format1 = new Date();
                    try {
                        format1 = new SimpleDateFormat("yyyy-MM-dd").parse(strDate);
                    }
                    catch (ParseException e) {
                        log.error((Throwable)e);
                    }
                    String format = new SimpleDateFormat("yyyy-MM-dd").format(format1);
                    cell.setCellValue(format);
                    continue;
                }
                if ("occupy".equals(headerz.get(i1)) || "execute".equals(headerz.get(i1))) {
                    BigDecimal bigDecimal = new BigDecimal(strDate).setScale(4, 4);
                    cell.setCellValue(bigDecimal.toString());
                    continue;
                }
                cell.setCellValue(entityList.get(ll - 1).getString(headerz.get(i1)));
            }
            ++index;
        }
    }

    private void constructionExcel(XSSFWorkbook excelBook, ArrayList<String> header1, ArrayList<String> headerz, ArrayList<String> headery, List<DynamicObject> entityList) {
        String billName = ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e", (String)"AnalyzeWayPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        XSSFSheet billSheet = excelBook.createSheet(billName);
        XSSFCellStyle cellStyle = excelBook.createCellStyle();
        int i = 0;
        int y = 0;
        for (int ll = 0; ll < entityList.size() + 1; ++ll) {
            XSSFRow row = billSheet.createRow(ll);
            for (int i1 = 0; i1 < header1.size(); ++i1) {
                BigDecimal bigDecimal;
                XSSFCell cell = null;
                cell = row.createCell(i1);
                if (i == 0) {
                    cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    cellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.index);
                    billSheet.setColumnWidth(y, 3584);
                    cell.setCellStyle((CellStyle)cellStyle);
                    ++y;
                    cell.setCellType(CellType.STRING);
                    cell.setCellValue(header1.get(i1));
                    continue;
                }
                if ("1".equals(this.getPageCache().get("header"))) {
                    cell.setCellType(CellType.STRING);
                    String str = entityList.get(ll - 1).getString(headerz.get(i1));
                    if ("occupy".equals(headerz.get(i1)) || "execute".equals(headerz.get(i1)) || "budget".equals(headerz.get(i1)) || "balance".equals(headerz.get(i1)) || "budgetcount".equals(headerz.get(i1))) {
                        bigDecimal = new BigDecimal(str).setScale(4, 4);
                        cell.setCellValue(bigDecimal.toString());
                    } else {
                        cell.setCellValue(entityList.get(ll - 1).getString(headerz.get(i1)));
                    }
                }
                if (!"2".equals(this.getPageCache().get("header"))) continue;
                cell.setCellType(CellType.STRING);
                String strDate = entityList.get(ll - 1).getString(headery.get(i1));
                if (StringUtils.isEmpty((String)strDate)) continue;
                if ("deletedate".equals(headery.get(i1))) {
                    Date format1 = new Date();
                    try {
                        format1 = new SimpleDateFormat("yyyy-MM-dd").parse(strDate);
                    }
                    catch (ParseException e) {
                        log.error((Throwable)e);
                    }
                    String format = new SimpleDateFormat("yyyy-MM-dd").format(format1);
                    cell.setCellValue(format);
                    continue;
                }
                if ("occupy".equals(headery.get(i1)) || "execute".equals(headery.get(i1))) {
                    bigDecimal = new BigDecimal(strDate).setScale(4, 4);
                    cell.setCellValue(bigDecimal.toString());
                    continue;
                }
                cell.setCellValue(entityList.get(ll - 1).getString(headery.get(i1)));
            }
            ++i;
        }
    }

    private void refreshEntryentity() {
        String header = this.getPageCache().get("header");
        if (StringUtils.isNotEmpty((String)header) && "2".equals(header)) {
            this.refreshEntryentityBill();
        } else if (StringUtils.isNotEmpty((String)header) && "3".equals(header)) {
            this.refreshEntryentityBill();
            this.bariteBariteMap();
            this.getView().updateView(ENTRYENTITY);
        } else {
            String balanceCache = this.getPageCache().get("balanceCache");
            if (StringUtils.isEmpty((String)balanceCache)) {
                return;
            }
            Map balanceCacheMap = (Map)SerializationUtils.deSerializeFromBase64((String)balanceCache);
            BgControlCallerImpl bgControlCaller = new BgControlCallerImpl();
            Collection<IBudgetBalance> iBudgetBalances = this.getSelectBalance(AnalyzeWayPlugin.toLong(balanceCacheMap.get("modelId")), bgControlCaller, (List)balanceCacheMap.get("dimlist"), (Collection)balanceCacheMap.get("type"));
            Collection<IBudgetBalance> moniBudgetBalances = this.getiBudgetBalances((Collection)balanceCacheMap.get("type"), iBudgetBalances);
            if (moniBudgetBalances.size() > 0) {
                this.getiBudgetBalances(iBudgetBalances);
                String priceStr = "1";
                BigDecimal price = new BigDecimal(priceStr);
                Collection<IBudgetBalance> filterIBudgetBalance = this.getiFilterBalances(String.valueOf(balanceCacheMap.get("fieldName")), moniBudgetBalances);
                if (filterIBudgetBalance.size() > 0) {
                    this.isTimeSort(filterIBudgetBalance);
                    this.buildEntryentity((Map)balanceCacheMap.get("customdimMap"), price, filterIBudgetBalance);
                } else {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u65e0\u6709\u6548\u6570\u636e\u3002", (String)"AnalyzeWayPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private void refreshEntryentityBill() {
        String bgControl = this.getPageCache().get("bgControl");
        if (StringUtils.isNotEmpty((String)bgControl)) {
            Map bgControlMap = (Map)SerializationUtils.deSerializeFromBase64((String)bgControl);
            Map fromCache = BusinessDataServiceHelper.loadFromCache((String)"eb_bgcontrolrecord", (String)this.selectField(), (QFilter[])new QFilter[]{(QFilter)bgControlMap.get("bgControl")}, (String)"createtime");
            this.createNetherEntity(fromCache, String.valueOf(bgControlMap.get("fieldName")), this.loadMapping(fromCache));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("bnt_conform".equals(key)) {
            this.openRelevanceView();
        }
        if ("bnt_cancel".equals(key)) {
            this.getView().close();
        }
        if (key.contains("labelap")) {
            this.personMessage(key);
        }
    }

    private void personMessage(String key) {
        String labelLists = this.getPageCache().get("labelList");
        String pathMaps = this.getPageCache().get("pathMap");
        if (StringUtils.isNotEmpty((String)labelLists) && StringUtils.isNotEmpty((String)pathMaps)) {
            LinkedList<String> newLabelList = new LinkedList<String>();
            LinkedList labelList = (LinkedList)SerializationUtils.deSerializeFromBase64((String)labelLists);
            LinkedMap pathMap = (LinkedMap)SerializationUtils.deSerializeFromBase64((String)pathMaps);
            if (!((String)pathMap.get(pathMap.get(labelList.size() - 1))).equals(pathMap.get((Object)key))) {
                ArrayList visibles = new ArrayList(16);
                List controls = ((EntryGrid)this.getControl(ENTRYENTITY)).getControls();
                controls.forEach(e -> {
                    if (e.getKey().contains("map")) {
                        visibles.add(e.getKey());
                    }
                });
                visibles.addAll(Lists.newArrayList((Object[])new String[]{"entitytpye", "entitynumber", "entitydate", "deletedate", "btn_baritemap"}));
                visibles.addAll(Lists.newArrayList((Object[])new String[]{"entryfieldgroupap", "entryfieldgroupap6", "execustomdimmap11", "execustomdimmap21", "execustomdimmap31", "execustomdimmap41", "execustomdimmap51", "execustomdimmap61"}));
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"account", "entity", "period", "budget", "occupy", "execute", "budgetcount", "balance", "decimalfield"});
                this.getView().setVisible(Boolean.valueOf(false), visibles.toArray(new String[0]));
                EntryGrid control = (EntryGrid)this.getControl(ENTRYENTITY);
                control.setColumnProperty("account", "ln", (Object)true);
                control.setColumnProperty("entity", "ln", (Object)true);
                control.setColumnProperty("period", "ln", (Object)true);
                control.setColumnProperty("occupy", "ln", (Object)true);
                control.setColumnProperty("execute", "ln", (Object)true);
                control.setColumnProperty("budgetcount", "ln", (Object)true);
                if (pathMap.size() > 1) {
                    if (pathMap.get((Object)key) != null) {
                        for (int i = 0; i < labelList.size(); ++i) {
                            if (((String)pathMap.get(pathMap.get(i))).equals(pathMap.get((Object)key))) {
                                newLabelList.add((String)labelList.get(i));
                                break;
                            }
                            newLabelList.add((String)labelList.get(i));
                        }
                    }
                    this.getPageCache().put("bgControl", null);
                    this.getPageCache().put("balanceCache", null);
                    this.getPageCache().put("fieldName", (String)this.getCustomFormParam("fieldName"));
                    this.buildStateLaberl(newLabelList);
                    Map pathEntityMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("pathEntityMap"));
                    Map objects = (Map)pathEntityMap.get(pathMap.get((Object)key));
                    this.getModel().deleteEntryData(ENTRYENTITY);
                    this.getModel().batchCreateNewEntryRow(ENTRYENTITY, objects.size());
                    int ll = 0;
                    BigDecimal price = new BigDecimal("1");
                    for (Map.Entry balanceEntry : objects.entrySet()) {
                        IBudgetBalance balance = (IBudgetBalance)balanceEntry.getValue();
                        DynamicObject entryen = this.getModel().getEntryRowEntity(ENTRYENTITY, ll);
                        if (balance.getAccount(true) != null) {
                            entryen.set("account", (Object)balance.getAccount(true).getName());
                        }
                        if (balance.getBudget() != null) {
                            entryen.set("budget", (Object)balance.getBudget().divide(price));
                        }
                        if (balance.getOccupation() != null) {
                            entryen.set("occupy", (Object)balance.getOccupation().divide(price));
                        }
                        if (balance.getExecute() != null) {
                            entryen.set("execute", (Object)balance.getExecute().divide(price));
                        }
                        if (balance.getOccupation() != null && balance.getExecute() != null) {
                            entryen.set("budgetcount", (Object)balance.getOccupation().divide(price).add(balance.getExecute().divide(price)));
                        }
                        if (balance.getOccupation() != null && balance.getExecute() == null) {
                            entryen.set("budgetcount", (Object)balance.getOccupation().divide(price));
                        }
                        if (balance.getOccupation() == null && balance.getExecute() != null) {
                            entryen.set("budgetcount", (Object)balance.getExecute().divide(price));
                        }
                        if (balance.getBalance() != null) {
                            entryen.set("balance", (Object)balance.getBalance().divide(price));
                        }
                        if (balance.getExecute() != null && balance.getBudget() != null) {
                            String format = "";
                            int k = balance.getBudget().compareTo(BigDecimal.ZERO);
                            format = k == 0 ? balance.getExecute().multiply(BgConstant.HUNDRED).toPlainString() : balance.getExecute().multiply(BgConstant.HUNDRED).divide(balance.getBudget(), 2, 4).toPlainString();
                            entryen.set("decimalfield", (Object)(format + "%"));
                        }
                        if (balance.getOrgUnit(true) != null) {
                            entryen.set("entity", (Object)balance.getOrgUnit(true).getName());
                        }
                        if (balance.getPeriod(true) != null) {
                            String periodName = this.getPeriodName(balance);
                            entryen.set("period", (Object)periodName);
                        }
                        Map<String, DynamicInfoCollection.InfoObject> customdimMap = this.getCustomdimMap();
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"execustomdim1", "execustomdim2", "execustomdim3", "execustomdim4", "execustomdim5", "execustomdim6"});
                        EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
                        if (customdimMap != null) {
                            for (Map.Entry<String, DynamicInfoCollection.InfoObject> stringMapEntry : customdimMap.entrySet()) {
                                grid.setColumnProperty((String)stringMapEntry.getValue().getValueByPropName("controlkey"), "header", (Object)new LocaleString((String)stringMapEntry.getValue().getValueByPropName("name")));
                                grid.setColumnProperty(stringMapEntry.getValue().getValueByPropName("controlkey") + "2", "header", (Object)new LocaleString((String)stringMapEntry.getValue().getValueByPropName("name")));
                                this.getView().setVisible(Boolean.valueOf(true), new String[]{stringMapEntry.getKey()});
                                control.setColumnProperty(stringMapEntry.getKey(), "ln", (Object)true);
                                if (balance.getMember(true, (String)stringMapEntry.getValue().getValueByPropName("number")) == null) continue;
                                entryen.set(stringMapEntry.getKey(), (Object)balance.getMember(true, (String)stringMapEntry.getValue().getValueByPropName("number")).getName());
                            }
                        }
                        ++ll;
                    }
                    this.getView().updateView(ENTRYENTITY);
                }
                this.getPageCache().put("header", "1");
            } else {
                this.refreshEntryentity();
            }
        }
    }

    public void onGetControl(OnGetControlArgs arg0) {
        super.onGetControl(arg0);
        String key = arg0.getKey();
        if (key.contains("labelap")) {
            Container flex = new Container();
            flex.setKey(key);
            flex.addClickListener((ClickListener)this);
            arg0.setControl((Control)flex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "account": 
            case "entity": 
            case "execustomdim1": 
            case "execustomdim2": 
            case "execustomdim3": 
            case "execustomdim4": 
            case "execustomdim5": 
            case "execustomdim6": {
                this.setCheckBoxField(key);
                break;
            }
            case "exehierarchy": {
                boolean exehierarchy = (Boolean)this.getModel().getValue(key);
                if (exehierarchy) {
                    this.getModel().setValue(key, (Object)true);
                    this.getPageCache().put("analyze", key);
                    this.getModel().setValue("exedetail", (Object)false);
                    break;
                }
                boolean exedetail = (Boolean)this.getModel().getValue("exedetail");
                if (exedetail) break;
                this.getModel().setValue(key, (Object)true);
                this.getPageCache().put("analyze", key);
                break;
            }
            case "exedetail": {
                boolean exedetail = (Boolean)this.getModel().getValue(key);
                if (exedetail) {
                    this.getModel().setValue(key, (Object)true);
                    this.getPageCache().put("analyze", key);
                    this.getModel().setValue("exehierarchy", (Object)false);
                    break;
                }
                boolean exehierarchy1 = (Boolean)this.getModel().getValue("exehierarchy");
                if (exehierarchy1) break;
                this.getModel().setValue(key, (Object)true);
                this.getPageCache().put("analyze", key);
                break;
            }
        }
    }

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("bnt_conform".equals(key)) {
            this.verifyConform();
        }
    }

    private void verifyConform() {
        IPageCache pageCache = this.getPageCache();
        IFormView view = this.getView();
        Long modelId = this.getFormModelId();
        Map<String, DynamicInfoCollection.InfoObject> customdimMap = this.getCustomdimMap();
        Map<String, DynamicObject> dimenMap = this.getStringDynamicObjectMap(view);
        String dimen = pageCache.get("dimen");
        String analyze = pageCache.get("analyze");
        if ("exehierarchy".equals(analyze)) {
            DynamicObject dimenId = new DynamicObject();
            DynamicObject dimension = null;
            String entityName = null;
            if ("account".equals(dimen)) {
                entityName = "epm_accountmembertree";
                dimenId = dimenMap.get(dimen);
                dimension = this.getDimenId(modelId, dimenId.getLong("fbasedataid_id"), entityName);
            } else if ("entity".equals(dimen)) {
                entityName = "epm_entitymembertree";
                dimenId = dimenMap.get(dimen);
                dimension = this.getDimenId(modelId, dimenId.getLong("id"), entityName);
            } else {
                DynamicInfoCollection.InfoObject custom = customdimMap.get(dimen);
                entityName = "epm_userdefinedmembertree";
                dimenId = this.getDimenIdByNumber(modelId, (String)custom.getValueByPropName("number"), entityName);
            }
            if (dimension == null) {
                return;
            }
            boolean isleaf = (Boolean)dimension.get("isleaf");
            if (isleaf) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u662f\u660e\u7ec6\u8282\u70b9\uff0c\u65e0\u6cd5\u6309\u5c42\u7ea7\u5206\u6790\u3002", (String)"AnalyzeWayPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private Map<String, DynamicObject> getStringDynamicObjectMap(IFormView view) {
        String dimens = (String)view.getFormShowParameter().getCustomParam("dimenMap");
        Map<String, Object> dimenMap = new HashMap<String, DynamicObject>(16);
        if (StringUtils.isNotEmpty((String)dimens)) {
            dimenMap = (Map)SerializationUtils.deSerializeFromBase64((String)dimens);
        }
        return dimenMap;
    }

    private void openRelevanceView() {
        HashMap<String, Object> dimen = new HashMap<String, Object>(16);
        dimen.put("dimen", this.getPageCache().get("dimen"));
        dimen.put("analyze", this.getPageCache().get("analyze"));
        dimen.put("customdimMap", this.getPageCache().get("customdimMap"));
        dimen.put("entry", this.getView().getFormShowParameter().getCustomParam("entry"));
        dimen.put("dc", "2");
        this.getView().returnDataToParent(dimen);
        this.getView().close();
    }

    private void setCheckBoxField(String key) {
        boolean taskall = (Boolean)this.getModel().getValue(key);
        if (taskall) {
            this.getModel().setValue(key, (Object)true);
            this.getPageCache().put("dimen", key);
            for (String counter : keys) {
                if (key.equals(counter)) continue;
                this.getModel().setValue(counter, (Object)false);
            }
        } else {
            int ll = 0;
            for (String counter : keys) {
                if (key.equals(counter)) continue;
                boolean counter1 = (Boolean)this.getModel().getValue(counter);
                if (!counter1) {
                    ++ll;
                }
                if (ll != 8) continue;
                this.getModel().setValue(key, (Object)true);
            }
        }
    }

    public void buildCustomDimInfo() {
        IFormView formView = this.getView();
        formView.setVisible(Boolean.valueOf(false), new String[]{"execustomdim1", "execustomdim2", "execustomdim3", "execustomdim4", "execustomdim5", "execustomdim6"});
        DynamicInfoCollection customdimInfo = this.getCustomDimsInfoCache();
        HashMap<String, DynamicInfoCollection.InfoObject> customdimMaps = new HashMap<String, DynamicInfoCollection.InfoObject>(customdimInfo.getValues().size());
        if (!customdimInfo.isEmpty()) {
            String controlkey = null;
            String name = null;
            for (DynamicInfoCollection.InfoObject info : customdimInfo.getValues()) {
                controlkey = (String)info.getValueByPropName("controlkey");
                FieldEdit checkBoxField = (FieldEdit)this.getControl(controlkey);
                name = (String)info.getValueByPropName("name");
                checkBoxField.setCaption(new LocaleString(name));
                customdimMaps.put(controlkey, info);
                formView.setVisible(Boolean.valueOf(true), new String[]{controlkey});
            }
        }
        this.getPageCache().put("dimen", "account");
        this.getPageCache().put("analyze", "exehierarchy");
        this.getPageCache().put("customdimMap", SerializationUtils.serializeToBase64(customdimMaps));
        this.getPageCache().put(CUSTOMDIMSINFOCACHE, SerializationUtils.serializeToBase64((Object)customdimInfo));
    }

    private long getFormModelId() {
        return AnalyzeWayPlugin.toLong((String)this.getView().getFormShowParameter().getCustomParam("modelId"));
    }

    private static Long toLong(String id) {
        if (StringUtils.isEmpty((String)id)) {
            return 0L;
        }
        if (StringUtils.isNumeric((String)id)) {
            return Long.valueOf(id);
        }
        return 0L;
    }

    public static <T> Long toLong(T t) {
        if (t instanceof Long) {
            return (Long)t;
        }
        if (t == null) {
            return 0L;
        }
        return AnalyzeWayPlugin.toLong(t.toString());
    }

    public static <T> List<Long> toLongs(List<T> ids) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Long> _ids = new ArrayList<Long>(ids.size());
        for (T id : ids) {
            _ids.add(AnalyzeWayPlugin.toLong(id));
        }
        return _ids;
    }

    public DynamicInfoCollection getCustomDimsInfoCache() {
        Long mdoelId = this.getFormModelId();
        if (this.customdimInfo != null) {
            return this.customdimInfo;
        }
        String customDimStr = this.getPageCache().get(CUSTOMDIMSINFOCACHE);
        if (customDimStr != null) {
            this.customdimInfo = (DynamicInfoCollection)SerializationUtils.deSerializeFromBase64((String)customDimStr);
        } else {
            DynamicObjectCollection dims = QueryServiceHelper.query((String)"epm_dimension", (String)"number,name,id,shortnumber", (QFilter[])new QFBuilder().add("model", "=", (Object)mdoelId).add("issysdimension", "=", (Object)false).toArray(), (String)"dseq");
            this.customdimInfo = new DynamicInfoCollection("customDimInfo--controlkey,number,shortnumber,name,id,defMemberId", new String[]{"controlkey", "number", "shortnumber", "name", "id", "defMemberId", "defMemberNum"});
            int seq = 1;
            for (DynamicObject customDim : dims) {
                String name = customDim.getString("name");
                String number = customDim.getString("number");
                String id = customDim.getString("id");
                String shortNum = customDim.getString("shortnumber");
                this.customdimInfo.addInfo(new Object[]{"execustomdim" + seq++, number, shortNum, name, id, null, null});
            }
            if (!this.customdimInfo.isEmpty()) {
                QFBuilder qb = new QFBuilder("dimension", "in", AnalyzeWayPlugin.toLongs(this.customdimInfo.getAllValOfOneProp("id")));
                qb.add("membersource", "=", (Object)"1");
                qb.add("number", "like", (Object)"%None");
                DynamicObjectCollection defMembers = QueryServiceHelper.query((String)"epm_userdefinedmembertree", (String)"id,dimension,number", (QFilter[])qb.toArray());
                DynamicInfoCollection.InfoObject infoOb = null;
                for (DynamicObject member : defMembers) {
                    String memberId = member.getString("id");
                    String dimensionId = member.getString("dimension");
                    infoOb = this.customdimInfo.getInfoByOneProp("id", (Object)dimensionId);
                    infoOb.setValueByPropName("defMemberId", (Object)memberId);
                    infoOb.setValueByPropName("defMemberNum", (Object)member.getString("number"));
                }
            }
        }
        return this.customdimInfo;
    }

    private boolean isPandectView() {
        return !"1".equals(this.getView().getFormShowParameter().getCustomParam("dc"));
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if ("entitynumber".equals(fieldName)) {
            this.openBill(evt);
        } else {
            this.openLeaf(evt);
        }
    }

    private void openLeaf(HyperLinkClickEvent evt) {
        LinkedList labelList;
        String fieName;
        String pathEntity = this.getPageCache().get("pathEntityMap");
        if (StringUtils.isEmpty((String)pathEntity)) {
            return;
        }
        String fieldName = evt.getFieldName();
        int rowIndex = evt.getRowIndex();
        Map iBudget = (Map)SerializationUtils.deSerializeFromBase64((String)pathEntity);
        Map integerIBudgetBalanceMap = (Map)iBudget.get(fieName = (String)(labelList = (LinkedList)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("labelList"))).get(labelList.size() - 1));
        if (integerIBudgetBalanceMap == null) {
            return;
        }
        IBudgetBalance balance = (IBudgetBalance)integerIBudgetBalanceMap.get(rowIndex);
        DynamicObject entity = this.getModel().getEntryRowEntity(ENTRYENTITY, rowIndex);
        String entityName = entity.getString(fieldName);
        Long dimensionId = this.getDimensionID(fieldName, balance);
        Long modelId = this.getFormModelId();
        this.getPageCache().put("resField", fieldName);
        this.getPageCache().put("rowIndex", String.valueOf(rowIndex));
        String entityMember = null;
        DynamicObject dimen = null;
        List<String> periodList = null;
        int ll = 0;
        if (fieldName.contains("execustomdim")) {
            entityMember = "epm_userdefinedmembertree";
            dimen = this.getDimenId(modelId, dimensionId, entityMember);
            ++ll;
        }
        switch (fieldName) {
            case "account": {
                entityMember = "epm_accountmembertree";
                dimen = this.getDimenId(modelId, dimensionId, entityMember);
                ++ll;
                break;
            }
            case "entity": {
                entityMember = "epm_entitymembertree";
                dimen = this.getDimenId(modelId, dimensionId, entityMember);
                ++ll;
                break;
            }
            case "period": {
                String period = this.getPageCache().get("period");
                for (String periodNumber : periodLists) {
                    if (!period.contains(periodNumber)) continue;
                    periodList = this.setPeriodList(entityName, periodList, period);
                }
                ++ll;
                break;
            }
        }
        Map<String, DynamicInfoCollection.InfoObject> customdimMap = this.getCustomdimMap();
        Map<Integer, IBudgetBalance> balanceMap = null;
        if (ll > 0 && dimen != null || "period".equals(fieldName)) {
            boolean isleaf = true;
            if (dimen != null) {
                isleaf = (Boolean)dimen.get("isleaf");
            } else if (periodList != null) {
                isleaf = false;
            }
            if (isleaf) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6682\u65e0\u4e0b\u7ea7\uff0c\u65e0\u6cd5\u4e0b\u94bb\u5206\u6790\u3002", (String)"AnalyzeWayPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                if (periodList != null) {
                    this.getPageCache().put("periodList", SerializationUtils.serializeToBase64(periodList));
                }
                balanceMap = this.setIBudget(fieldName, modelId, customdimMap, balance, periodList);
                labelList.add(entityName);
                this.buildStateLaberl(labelList);
                this.setPathEntityMap((String)labelList.get(labelList.size() - 1), balanceMap);
            }
        } else {
            this.getPageCache().put("header", "2");
            this.getPageCache().put("fieldName", fieldName);
            this.structureAnalyze(balance, fieldName);
            labelList.add(ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e", (String)"AnalyzeWayPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            this.buildStateLaberl(labelList);
        }
    }

    private void openBill(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, rowIndex);
        String entitytpye = entryRowEntity.getString("billnumber");
        String billid = entryRowEntity.getString("billid");
        String appId = BillPreOpenCheckUtil.getInstance().checkViewPerm(entitytpye, (Object)billid, this.getView());
        IFormView parentPageView = this.getView().getParentView().getParentView();
        String menuPageID = null;
        if (parentPageView != null) {
            menuPageID = parentPageView.getPageId() + ModelUtil.queryApp((IFormView)this.getView()).getAppnum();
            IFormView childFormView = this.getView().getView(menuPageID);
            if (childFormView != null) {
                childFormView.activate();
                this.getView().sendFormAction(childFormView);
            }
            HashMap<String, String> openParameter = new HashMap<String, String>();
            HashMap<String, String> customParams = new HashMap<String, String>();
            openParameter.put("formId", entitytpye);
            openParameter.put("pkId", billid);
            customParams.put("checkRightAppId", appId);
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(openParameter);
            showParameter.setCustomParams(customParams);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm(showParameter);
        }
    }

    private Long getDimensionID(String fieldName, IBudgetBalance balance) {
        if (balance == null) {
            return 0L;
        }
        if ("account".equals(fieldName)) {
            return balance.getAccount(true).getId();
        }
        if ("entity".equals(fieldName)) {
            return balance.getOrgUnit(true).getId();
        }
        if (fieldName.contains("execustomdim")) {
            Matcher matcher = COM.matcher(fieldName);
            String trim = matcher.replaceAll("").trim();
            int month = Integer.parseInt(trim);
            Map<String, DynamicInfoCollection.InfoObject> customdimMap = this.getCustomdimMap();
            DynamicInfoCollection.InfoObject stringStringMap = customdimMap.get(fieldName);
            return balance.getMember(true, (String)stringStringMap.getValueByPropName("number")).getId();
        }
        return 0L;
    }

    private List<String> setPeriodList(String entityName, List<String> periodList, String period) {
        if (entityName.contains(ResManager.loadKDString((String)"\u534a\u5e74", (String)"AnalyzeWayPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]))) {
            periodList = ResManager.loadKDString((String)"\u4e0a\u534a\u5e74", (String)"AnalyzeWayPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(entityName) && period.contains("M_HF") ? Lists.newArrayList((Object[])new String[]{"M_Q1", "M_Q2"}) : (ResManager.loadKDString((String)"\u4e0a\u534a\u5e74", (String)"AnalyzeWayPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(entityName) && period.contains("Q_HF") ? Lists.newArrayList((Object[])new String[]{"Q_Q1", "Q_Q2"}) : (ResManager.loadKDString((String)"\u4e0b\u534a\u5e74", (String)"AnalyzeWayPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(entityName) && period.contains("M_HF") ? Lists.newArrayList((Object[])new String[]{"M_Q3", "M_Q4"}) : Lists.newArrayList((Object[])new String[]{"Q_Q3", "Q_Q4"})));
        }
        if (entityName.contains(ResManager.loadKDString((String)"\u5b63\u5ea6", (String)"AnalyzeWayPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]))) {
            if (ResManager.loadKDString((String)"\u4e00\u5b63\u5ea6", (String)"AnalyzeWayPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(entityName)) {
                periodList = Lists.newArrayList((Object[])new String[]{"M_M01", "M_M02", "M_M03"});
            }
            if (ResManager.loadKDString((String)"\u4e8c\u5b63\u5ea6", (String)"AnalyzeWayPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(entityName)) {
                periodList = Lists.newArrayList((Object[])new String[]{"M_M04", "M_M05", "M_M06"});
            }
            if (ResManager.loadKDString((String)"\u4e09\u5b63\u5ea6", (String)"AnalyzeWayPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(entityName)) {
                periodList = Lists.newArrayList((Object[])new String[]{"M_M07", "M_M08", "M_M09"});
            }
            if (ResManager.loadKDString((String)"\u56db\u5b63\u5ea6", (String)"AnalyzeWayPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]).equals(entityName)) {
                periodList = Lists.newArrayList((Object[])new String[]{"M_M10", "M_M11", "M_M12"});
            }
        }
        return periodList;
    }

    private void structureAnalyze(IBudgetBalance bgBalance, String fieldName) {
        boolean isbudget = true;
        Long aLong = bgBalance.getBizModel().getId();
        QFilter qFilter = new QFilter("model", "=", (Object)aLong);
        qFilter.and(new QFilter("currency", "=", (Object)bgBalance.getCurrency(isbudget).getId()));
        qFilter.and(new QFilter("year", "=", (Object)bgBalance.getYear(isbudget).getId()));
        Collection dimensions = bgBalance.getBizModel().getUserDefinedDimensions();
        for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
            kd.epm.eb.common.model.Member member = bgBalance.getMember(true, dimension.getNumber());
            List<Long> childenId = AnalyzeWayPlugin.toLongs(AnalyzeWayPlugin.getAllChildenId(dimension.getMemberModel(), this.getFormModelId(), member.getId(), true));
            String index = dimension.getFieldMapped().replaceAll("dim", "");
            qFilter.and(new QFilter("userdefined" + index, "in", childenId));
        }
        List<Long> orgunits = AnalyzeWayPlugin.getAllChildenId(SysDimensionEnum.Entity.getMemberTreemodel(), this.getFormModelId(), bgBalance.getOrgUnit(true).getId(), true);
        qFilter.and(new QFilter("orgunit", "in", orgunits));
        List<Long> accounts = AnalyzeWayPlugin.getAllChildenId(SysDimensionEnum.Account.getMemberTreemodel(), this.getFormModelId(), bgBalance.getAccount(true).getId(), true);
        qFilter.and(new QFilter("account", "in", accounts));
        int controltypeindex = bgBalance.getSetting().getSettingType().getIndex();
        long periodid = bgBalance.getPeriod(isbudget).getId();
        if (controltypeindex == BgControlSettingTypeEnum.MONTH.getIndex()) {
            qFilter.and(new QFilter("period", "=", (Object)periodid));
        } else if (controltypeindex != BgControlSettingTypeEnum.MONTH_ADDUP.getIndex() && controltypeindex != BgControlSettingTypeEnum.QUARTER_ADDUP.getIndex() && controltypeindex != BgControlSettingTypeEnum.YEAR.getIndex()) {
            String period;
            if (controltypeindex == BgControlSettingTypeEnum.QUARTER.getIndex()) {
                period = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_periodmembertree", (String)"id,number,parent,level", (QFilter[])new QFilter("id", "=", (Object)periodid).toArray());
                if (period != null) {
                    String number = period.getString("number");
                    QFilter qFilter1 = null;
                    qFilter1 = number.startsWith("M_M") ? (number.compareTo("M_M04") < 0 ? new QFilter("number", "in", (Object)Lists.newArrayList((Object[])new String[]{"M_M01", "M_M02", "M_M03"})) : (number.compareTo("M_M07") < 0 ? new QFilter("number", "in", (Object)Lists.newArrayList((Object[])new String[]{"M_M04", "M_M05", "M_M06"})) : (number.compareTo("M_M10") < 0 ? new QFilter("number", "in", (Object)Lists.newArrayList((Object[])new String[]{"M_M07", "M_M08", "M_M09"})) : new QFilter("number", "in", (Object)Lists.newArrayList((Object[])new String[]{"M_M10", "M_M11", "M_M12"}))))) : new QFilter("number", "in", (Object)Lists.newArrayList((Object[])new String[]{number}));
                    qFilter1.and("model", "=", (Object)bgBalance.getBizModel().getId());
                    List objects = QueryServiceHelper.queryPrimaryKeys((String)"epm_periodmembertree", (QFilter[])qFilter1.toArray(), null, (int)20);
                    qFilter.and(new QFilter("period", "in", AnalyzeWayPlugin.toLongs(objects)));
                }
            } else if (controltypeindex == BgControlSettingTypeEnum.HALFYEAR.getIndex()) {
                period = this.getPageCache().get("period");
                if ("Q_HF2".equals(period) || "M_HF2".equals(period) || "HF_HF2".equals(period)) {
                    if ("Q_Q2".equals(bgBalance.getPeriod(isbudget).getNumber())) {
                        period = "Q_HF1";
                    } else if ("M_Q2".equals(bgBalance.getPeriod(isbudget).getNumber())) {
                        period = "M_HF1";
                    } else if ("M_M06".equals(bgBalance.getPeriod(isbudget).getNumber())) {
                        period = "M_HF1";
                    } else if ("HF_HF1".equals(bgBalance.getPeriod(isbudget).getNumber())) {
                        period = "HF_HF1";
                    }
                }
                QFilter qFilter1 = null;
                qFilter1 = "M_HF1".equals(period) ? new QFilter("number", "in", (Object)Lists.newArrayList((Object[])new String[]{"M_M01", "M_M02", "M_M03", "M_M04", "M_M05", "M_M06"})) : ("M_HF2".equals(period) ? new QFilter("number", "in", (Object)Lists.newArrayList((Object[])new String[]{"M_M07", "M_M08", "M_M09", "M_M10", "M_M11", "M_M12"})) : ("Q_HF1".equals(period) ? new QFilter("number", "in", (Object)Lists.newArrayList((Object[])new String[]{"Q_Q1", "Q_Q2"})) : ("Q_HF2".equals(period) ? new QFilter("number", "in", (Object)Lists.newArrayList((Object[])new String[]{"Q_Q3", "Q_Q4"})) : ("HF_HF1".equals(period) ? new QFilter("number", "in", (Object)Lists.newArrayList((Object[])new String[]{"HF_HF1"})) : new QFilter("number", "in", (Object)Lists.newArrayList((Object[])new String[]{"HF_HF2"}))))));
                qFilter1.and("model", "=", (Object)bgBalance.getBizModel().getId());
                List objects = QueryServiceHelper.queryPrimaryKeys((String)"epm_periodmembertree", (QFilter[])qFilter1.toArray(), null, (int)20);
                qFilter.and(new QFilter("period", "in", AnalyzeWayPlugin.toLongs(objects)));
            }
        }
        String[] properties = this.selectField().split(",");
        HashSet<String> select = new HashSet<String>(properties.length);
        String[] var4 = properties;
        int var5 = properties.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            String prop = var4[var6];
            select.add(prop.trim());
        }
        BusinessDataServiceHelper.removeCache((DynamicObjectType)EntityMetadataCache.getSubDataEntityType((String)"eb_bgcontrolrecord", select));
        Map docs = BusinessDataServiceHelper.loadFromCache((String)"eb_bgcontrolrecord", (String)this.selectField(), (QFilter[])new QFilter[]{qFilter}, (String)"createtime");
        kd.epm.eb.common.model.Member member = bgBalance.getMember(false, SysDimensionEnum.ChangeType.getNumber());
        boolean isRequest = member != null && "Occupation".equals(member.getNumber());
        Map<String, List<IBudgetBalance>> mappings = this.loadMapping(docs);
        HashMap<String, Object> bgControlMap = new HashMap<String, Object>(16);
        bgControlMap.put("bgControl", qFilter);
        bgControlMap.put("fieldName", fieldName);
        bgControlMap.put("isRequest", isRequest);
        this.getPageCache().put("bgControl", SerializationUtils.serializeToBase64(bgControlMap));
        log.info("[analyze][Qfilter]" + qFilter.toString());
        this.createNetherEntity(docs, fieldName, mappings);
    }

    public static List<Long> getAllChildenId(String entityform, Long model, Long id, boolean self) {
        QFilter qFModel = new QFilter("model", "=", (Object)model);
        HashMap<Long, Long> allMembers = new HashMap<Long, Long>(16);
        DynamicObjectCollection query = QueryServiceHelper.query((String)entityform, (String)"id,parent.id", (QFilter[])new QFilter[]{qFModel});
        for (DynamicObject object : query) {
            allMembers.put(object.getLong("id"), object.getLong("parent.id"));
        }
        ArrayList<Long> ids = new ArrayList<Long>(16);
        if (self) {
            ids.add(id);
        }
        AnalyzeWayPlugin.queryChildenId(allMembers, id, ids);
        return ids;
    }

    private static void queryChildenId(Map<Long, Long> allMembers, long parentid, List<Long> ids) {
        for (Map.Entry<Long, Long> entry : allMembers.entrySet()) {
            if (entry.getValue() != parentid) continue;
            Long id = entry.getKey();
            ids.add(id);
            AnalyzeWayPlugin.queryChildenId(allMembers, id, ids);
        }
    }

    private void createNetherEntity(Map<Object, DynamicObject> docs, String fieldName, Map<String, List<IBudgetBalance>> mappings) {
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRYENTITY);
        this.userDefine = DimensionServiceHelper.getUserDefineDimensionNumAndNameByModel((Object)this.getFormModelId(), (boolean)true);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"budget", "occupy", "execute", "budgetcount", "balance", "decimalfield"});
        if ("budgetcount".equals(fieldName)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"entitytpye", "entitynumber", "deletedate", "btn_baritemap", "occupy", "execute"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"entitytpye", "entitynumber", "deletedate", "btn_baritemap", fieldName});
        }
        EntryGrid control = (EntryGrid)this.getControl(ENTRYENTITY);
        control.setColumnProperty("account", "ln", (Object)false);
        control.setColumnProperty("entity", "ln", (Object)false);
        control.setColumnProperty("period", "ln", (Object)false);
        if ("budgetcount".equals(fieldName)) {
            control.setColumnProperty("occupy", "ln", (Object)false);
            control.setColumnProperty("execute", "ln", (Object)false);
        } else {
            control.setColumnProperty(fieldName, "ln", (Object)false);
        }
        if (docs != null && docs.size() > 0) {
            Row row = null;
            DynamicObjectCollection occ = new DynamicObjectCollection();
            DynamicObjectCollection exe = new DynamicObjectCollection();
            for (Map.Entry<Object, DynamicObject> doc : docs.entrySet()) {
                Long changeType = doc.getValue().getLong("changetype");
                DynamicObject dynamicObject = this.getDimensionNumber(changeType, "epm_changetypemembertree");
                if (dynamicObject == null) continue;
                if (dynamicObject.getString("number").equals("Occupation")) {
                    occ.add((Object)doc.getValue());
                    continue;
                }
                if (!dynamicObject.getString("number").equals("Execute")) continue;
                exe.add((Object)doc.getValue());
            }
            HashSet<String> eitityNumbers = new HashSet<String>(16);
            for (Map.Entry entry : docs.entrySet()) {
                String eitityNumber = ((DynamicObject)entry.getValue()).getString("entitynumber");
                if (!StringUtils.isNotEmpty((String)eitityNumber)) continue;
                eitityNumbers.add(eitityNumber);
            }
            HashMap<String, String> numberMap = new HashMap<String, String>(16);
            if (eitityNumbers.size() > 0) {
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"eb_structofbill", (String)"name, number", (QFilter[])new QFilter("number", "in", eitityNumbers).toArray(), null);){
                    while (dataSet.hasNext()) {
                        row = dataSet.next();
                        numberMap.put(row.getString("number"), row.getString("name"));
                    }
                }
            }
            LinkedList<DynamicObject> linkedList = new LinkedList<DynamicObject>();
            if ("occupy".equals(fieldName)) {
                linkedList.addAll((Collection<DynamicObject>)occ);
            } else if ("execute".equals(fieldName)) {
                linkedList.addAll((Collection<DynamicObject>)exe);
            } else {
                linkedList.addAll((Collection<DynamicObject>)occ);
                linkedList.addAll((Collection<DynamicObject>)exe);
            }
            this.billSort(linkedList);
            IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)this.getFormModelId());
            HashMap<Long, String> entryNumberMap = new HashMap<Long, String>(16);
            HashSet entryNumberSet = new HashSet(16);
            HashMap entryBizNumberMap = new HashMap(16);
            HashSet<Long> entryNumberId = new HashSet<Long>(16);
            linkedList.forEach(e -> {
                entryNumberSet.add(e.getString("entitynumber"));
                entryBizNumberMap.put(e.getString("biznumber"), e.getString("entitynumber"));
            });
            Map fromCache = BusinessDataServiceHelper.loadFromCache((String)"eb_structofbill", (String)"id,name,number", (QFilter[])new QFilter("number", "in", entryNumberSet).toArray());
            for (Map.Entry entry : fromCache.entrySet()) {
                long id = ((DynamicObject)entry.getValue()).getLong("id");
                entryNumberMap.put(id, ((DynamicObject)entry.getValue()).getString("number"));
                entryNumberId.add(id);
            }
            Map propCache = BusinessDataServiceHelper.loadFromCache((String)"eb_bgcontrolbizreg", (String)"bizunitid,number,name", (QFilter[])new QFilter("bizunitid", "in", entryNumberId).toArray());
            HashMap<String, String> bizPropNames = new HashMap<String, String>(20);
            for (DynamicObject prop : propCache.values()) {
                bizPropNames.put((String)entryNumberMap.get(prop.getLong("bizunitid")) + "," + prop.getString("number"), prop.getString("name"));
            }
            HashMap<Integer, String> customMap = new HashMap<Integer, String>(10);
            for (DynamicObject doc : linkedList) {
                this.buildRelevanceEntity(numberMap, doc, orCreate, bizPropNames, mappings, customMap);
            }
            this.getPageCache().put("custom", SerializationUtils.serializeToBase64(customMap));
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private DynamicObject getDimensionNumber(Long dimensionId, String formConstant) {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getFormModelId());
        qFilter.and(new QFilter("id", "=", (Object)dimensionId));
        return BusinessDataServiceHelper.loadSingleFromCache((String)formConstant, (String)"id,name,number", (QFilter[])qFilter.toArray());
    }

    private void billSort(List<DynamicObject> dynamicObjects) {
        dynamicObjects.sort(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                String o1String = o1.getString("biznumber");
                String o2String = o2.getString("biznumber");
                return o1String.compareTo(o2String);
            }
        });
    }

    private int buildRelevanceEntity(Map<String, String> numberMap, DynamicObject doc, IModelCacheHelper orCreate, Map<String, String> bizPropNames, Map<String, List<IBudgetBalance>> mappings, Map<Integer, String> customMap) {
        int newEntryRow = this.getModel().createNewEntryRow(ENTRYENTITY);
        DynamicObject entity = this.getModel().getEntryRowEntity(ENTRYENTITY, newEntryRow);
        Long changetype = doc.getLong("changetype");
        Member changeMember = orCreate.getMember(SysDimensionEnum.ChangeType.getNumber(), Long.valueOf(0L), changetype);
        if (changeMember == null) {
            return newEntryRow;
        }
        boolean isOcc = false;
        if ("Occupation".equals(changeMember.getNumber())) {
            entity.set("occupy", (Object)doc.getBigDecimal("amount"));
            isOcc = true;
        } else if ("Execute".equals(changeMember.getNumber())) {
            entity.set("execute", (Object)doc.getBigDecimal("amount"));
        }
        Member accountMember = orCreate.getMember(SysDimensionEnum.Account.getNumber(), Long.valueOf(0L), Long.valueOf(doc.getLong("account")));
        if (accountMember == null) {
            return newEntryRow;
        }
        entity.set("account", (Object)accountMember.getName());
        Member orgunitMember = orCreate.getMember(SysDimensionEnum.Entity.getNumber(), Long.valueOf(0L), Long.valueOf(doc.getLong("orgunit")));
        if (orgunitMember == null) {
            return newEntryRow;
        }
        entity.set("entity", (Object)orgunitMember.getName());
        Member periodMember = orCreate.getMember(SysDimensionEnum.Period.getNumber(), Long.valueOf(0L), Long.valueOf(doc.getLong("period")));
        if (periodMember == null) {
            return newEntryRow;
        }
        entity.set("period", (Object)periodMember.getName());
        this.entitySetUserdef(doc, orCreate, entity);
        String eitityNumber = doc.getString("entitynumber");
        entity.set("entitytpye", (Object)numberMap.get(eitityNumber));
        entity.set("entitynumber", (Object)doc.getString("biznumber"));
        entity.set("deletedate", (Object)doc.getDate("createtime"));
        entity.set("billid", (Object)doc.getString("bizid"));
        entity.set("billnumber", (Object)doc.getString("entitynumber"));
        Member yearMember = orCreate.getMember(SysDimensionEnum.Year.getNumber(), Long.valueOf(0L), Long.valueOf(doc.getLong("year")));
        if (yearMember == null) {
            return newEntryRow;
        }
        this.fillMapping(newEntryRow, doc, mappings, orCreate, bizPropNames, customMap, isOcc);
        return newEntryRow;
    }

    private void fillMapping(int newEntryRow, DynamicObject doc, Map<String, List<IBudgetBalance>> mappings, IModelCacheHelper orCreate, Map<String, String> bizPropNames, Map<Integer, String> customMap, boolean isOcc) {
        if (doc == null || mappings == null || mappings.isEmpty()) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>(10);
        String entityNumber = doc.getString("entitynumber");
        keys.add(entityNumber);
        keys.add(doc.getString("bizid"));
        List dimensions = orCreate.getDimensionList();
        String field = null;
        for (Dimension dimension : dimensions) {
            if (this.isIrgDimension(dimension.getNumber())) continue;
            field = dimension.getNumber().toLowerCase();
            if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
                field = BgControlUtils.getEBUserDefined((Dimension)dimension);
            } else if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) {
                field = "orgunit";
            }
            keys.add(dimension.getMember(Long.valueOf(0L), Long.valueOf(doc.getLong(field))).getNumber());
        }
        String key = StringUtils.join(keys, (String)",");
        List<IBudgetBalance> balances = mappings.get(key);
        try {
            if ((balances == null || balances.isEmpty()) && StringUtils.isNotEmpty((String)doc.getString("refbizid")) && IDUtils.isNull((long)doc.getLong("occperiod"))) {
                keys.remove(0);
                keys.set(0, doc.getString("refbizid"));
                key = StringUtils.join(keys, (String)",");
                balances = mappings.get(key);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (balances == null || balances.isEmpty()) {
            return;
        }
        HashMap<String, List> mappingStr = new HashMap<String, List>(dimensions.size());
        List subList = null;
        Map mappingData = null;
        String bizName = null;
        String bizExtName = null;
        String str = null;
        String propName = null;
        ArrayList<IBudgetBalance> matchBalances = new ArrayList<IBudgetBalance>(balances.size());
        log.info("budget-control-log : fillMap-key:" + key + " amount:" + doc.getBigDecimal("amount"));
        IBudgetBalance _balance = null;
        IBudgetBalance _lastBalance = null;
        BigDecimal amount = null;
        for (IBudgetBalance balance : balances) {
            boolean isMatch;
            if (!balance.hasMappingData()) continue;
            log.info("budget-control-log : fillMap-balance:" + JSONUtils.toString((Object)balance.toMap()));
            amount = isOcc ? balance.getOccAmount() : balance.getExeAmount();
            boolean isEqualsAmount = amount != null && amount.compareTo(doc.getBigDecimal("amount")) == 0;
            if (!isEqualsAmount) continue;
            boolean bl = isMatch = isOcc ? balance.isOccMatch() : balance.isExeMatch();
            if (!isMatch) {
                _balance = balance;
                if (isOcc) {
                    balance.setOccMatch(true);
                    break;
                }
                balance.setExeMatch(true);
                break;
            }
            _lastBalance = balance;
        }
        if (_balance == null) {
            _balance = _lastBalance;
        }
        if (_balance != null) {
            matchBalances.add(_balance);
        } else {
            matchBalances.addAll(balances);
        }
        for (IBudgetBalance balance : matchBalances) {
            if (!balance.hasMappingData()) continue;
            for (Dimension dimension : dimensions) {
                mappingData = balance.getMappingData(dimension.getNumber());
                if (mappingData == null || mappingData.isEmpty()) continue;
                propName = null;
                if (SysDimensionEnum.Account.getNumber().equals(dimension.getNumber())) {
                    propName = balance.getControlScheme().getAccountFields();
                } else if (SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())) {
                    propName = balance.getControlScheme().getOrgUnitFields();
                } else if (SysDimensionEnum.ChangeType.getNumber().equals(dimension.getNumber())) {
                    propName = balance.getControlScheme().getChangeTypeField();
                } else if (SysDimensionEnum.Currency.getNumber().equals(dimension.getNumber())) {
                    propName = balance.getControlScheme().getCurrencyFields();
                } else if (SysDimensionEnum.Period.getNumber().equals(dimension.getNumber())) {
                    propName = balance.getControlScheme().getPeriodFields();
                } else if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension)) {
                    propName = (String)balance.getControlScheme().getUserDefendPropMap().get(BgControlScheme.getUserDefendKey((kd.epm.eb.common.model.Dimension)new kd.epm.eb.common.model.Dimension(dimension.getId(), dimension.getName(), dimension.getNumber())));
                }
                if (propName == null) continue;
                if (bizPropNames.containsKey(entityNumber + "," + propName)) {
                    propName = bizPropNames.get(entityNumber + "," + propName);
                }
                bizName = (String)mappingData.get("bina");
                bizExtName = (String)mappingData.get("bena");
                str = StringUtils.isEmpty((String)bizExtName) ? propName + "\f" + bizName : propName + "\f" + bizName + "\f" + bizExtName;
                subList = mappingStr.computeIfAbsent(dimension.getNumber(), f -> new ArrayList(10));
                if (subList.contains(str)) continue;
                subList.add(str);
            }
        }
        DynamicObject entity = null;
        entity = this.getModel().getEntryRowEntity(ENTRYENTITY, newEntryRow);
        for (Map.Entry entry : mappingStr.entrySet()) {
            String mappingValue = (String)((List)entry.getValue()).get(0);
            if (((List)entry.getValue()).size() > 1) {
                boolean hasExt = false;
                for (String _mpv : (List)entry.getValue()) {
                    if (_mpv.split("\f").length <= 2) continue;
                    hasExt = true;
                    break;
                }
                mappingValue = hasExt ? mappingValue.split("\f")[0] + "\f---\f---" : mappingValue.split("\f")[0] + "\f---";
            }
            if (SysDimensionEnum.Account.getNumber().equals(entry.getKey())) {
                this.entitySetMemberMapping(mappingValue, entity, "accountfield", "accountdimsionmap", "accountmap1", "auxaccountmap11", "accountmap2");
                continue;
            }
            if (SysDimensionEnum.Entity.getNumber().equals(entry.getKey())) {
                this.entitySetMemberMapping(mappingValue, entity, "entryfield", "entrydimsionmap", "entitymap1", "auxentitymap11", "entitymap2");
                continue;
            }
            if (!BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)orCreate.getDimension((String)entry.getKey()))) continue;
            this.setUserDefCustom(entity, customMap, Integer.parseInt(orCreate.getDimension((String)entry.getKey()).getFieldMapped().replaceFirst("dim", "")), mappingValue);
        }
    }

    private void entitySetMemberMapping(String mappingSplit, DynamicObject entity, String accountfield, String accountdimsionmap, String accountmap1, String auxaccountmap11, String accountmap2) {
        this.getPageCache().put(accountfield, "1");
        String[] split = mappingSplit.split("\f");
        if (split.length > 2) {
            entity.set(accountmap1, (Object)split[0]);
            entity.set(auxaccountmap11, (Object)split[2]);
            entity.set(accountmap2, (Object)split[1]);
        } else {
            entity.set(accountmap1, (Object)split[0]);
            entity.set(accountmap2, (Object)split[1]);
        }
    }

    private void entitySetUserdef(DynamicObject doc, IModelCacheHelper orCreate, DynamicObject entity) {
        EntryGrid control = (EntryGrid)this.getControl(ENTRYENTITY);
        for (Map.Entry<String, String> entry : this.userDefine.entrySet()) {
            String[] split = entry.getValue().split("\\.");
            if (split.length <= 1) continue;
            String index = split[1];
            Member member = orCreate.getMember(entry.getKey(), Long.valueOf(doc.getLong("userdefined" + index)));
            entity.set("execustomdim" + index, (Object)member.getName());
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"execustomdim" + index});
            control.setColumnProperty("execustomdim" + index, "ln", (Object)false);
        }
    }

    private void setUserDefCustom(DynamicObject entity, Map<Integer, String> customMap, int userFefineIndex, String mapping) {
        this.getPageCache().put("userdefined" + userFefineIndex + "field", null);
        this.getPageCache().put("userdefined" + userFefineIndex + "field", "1");
        String[] split = mapping.split("\f");
        if (split.length > 2) {
            entity.set("customdimmap" + userFefineIndex + "1", (Object)split[0]);
            entity.set("auxcustomdimmap" + userFefineIndex + "1", (Object)split[2]);
            entity.set("customdimmap" + userFefineIndex + "2", (Object)split[1]);
        } else {
            entity.set("customdimmap" + userFefineIndex + "1", (Object)split[0]);
            entity.set("customdimmap" + userFefineIndex + "2", (Object)split[1]);
        }
        Map<String, DynamicInfoCollection.InfoObject> customdimMap = this.getCustomdimMap();
        for (Map.Entry<String, DynamicInfoCollection.InfoObject> stringMapEntry : customdimMap.entrySet()) {
            if (!stringMapEntry.getKey().contains(String.valueOf(userFefineIndex))) continue;
            EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY);
            grid.setColumnProperty("execustomdimmap" + userFefineIndex + "1", "header", (Object)new LocaleString(ResManager.loadResFormat((String)"%1\u6620\u5c04", (String)"AnalyzeWayPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[]{stringMapEntry.getValue().getValueByPropName("name")})));
        }
        customMap.put(userFefineIndex, "customdimmap" + userFefineIndex);
    }

    private String selectField() {
        return "account,reqaccount,reqorgunit,orgunit,operation,changetype,bizid,refbizid,metric,currency,userdefined1,userdefined2,userdefined3,userdefined4,userdefined5,userdefined6,userdefined7,amount,entitynumber,biznumber,createtime,creator,period,year,occperiod";
    }

    private Map<Integer, IBudgetBalance> setIBudget(String fieldName, Long modelId, Map<String, DynamicInfoCollection.InfoObject> customdimMap, IBudgetBalance budgetBalance, List<String> periodList) {
        String clickName = this.getPageCache().get("fieldName");
        Map<Integer, IBudgetBalance> balanceMap = null;
        if ("period".equals(fieldName) && periodList != null) {
            balanceMap = this.setIBudgetBalance(modelId, clickName, fieldName, null, customdimMap, budgetBalance, null, periodList);
        } else {
            DynamicObject[] dynamicObjects = this.getDynamicObjects(modelId, fieldName, null, customdimMap, budgetBalance);
            ArrayList<DynamicObject> dimenObject = new ArrayList<DynamicObject>(dynamicObjects.length);
            dimenObject.addAll(Arrays.asList(dynamicObjects));
            balanceMap = this.setIBudgetBalance(modelId, clickName, fieldName, null, customdimMap, budgetBalance, dimenObject, null);
        }
        return balanceMap;
    }

    private void setPathEntityMap(String entityName, Map<Integer, IBudgetBalance> balanceMap) {
        Map<String, Map<Integer, IBudgetBalance>> pathEntityMap = null;
        if (StringUtils.isEmpty((String)this.getPageCache().get("pathEntityMap"))) {
            pathEntityMap = new HashMap<String, Map<Integer, IBudgetBalance>>(16);
            pathEntityMap.put(entityName, balanceMap);
            this.getPageCache().put("pathEntityMap", SerializationUtils.serializeToBase64(pathEntityMap));
        } else {
            pathEntityMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("pathEntityMap"));
            pathEntityMap.put(entityName, balanceMap);
            this.getPageCache().put("pathEntityMap", SerializationUtils.serializeToBase64(pathEntityMap));
        }
    }

    private void buildStateLaberl(LinkedList<String> labelList) {
        LinkedMap pathMap = new LinkedMap(16);
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey("flexPanelAps");
        LabelAp labelap = null;
        for (int i = 0; i < labelList.size(); ++i) {
            labelap = new LabelAp();
            labelap.setKey("labelap" + i);
            if (i > 0) {
                VectorAp vectorAp = new VectorAp();
                vectorAp.setKey("vectorAp" + i);
                vectorAp.setfontClass("kdfont kdfont-houfan");
                flexPanelAp.getItems().add(vectorAp);
            }
            labelap.setName(new LocaleString(labelList.get(i)));
            labelap.setClickable(true);
            labelap.setFontSize(14);
            if (i == labelList.size() - 1) {
                labelap.setForeColor("themeColor");
            }
            flexPanelAp.getItems().add(labelap);
            pathMap.put("labelap" + i, labelList.get(i));
        }
        this.getPageCache().put("labelList", SerializationUtils.serializeToBase64(labelList));
        this.getPageCache().put("pathMap", SerializationUtils.serializeToBase64((Object)pathMap));
        this.getView().updateControlMetadata("flexpanelaps", flexPanelAp.createControl());
    }
}

