/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analyze;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.cache.threadlocal.EpmThreadLocalUtils;
import kd.epm.eb.common.ebcommon.common.enums.MemberDisplayTypeEnum;
import kd.epm.eb.common.enums.GroupNodeTypeEnum;
import kd.epm.eb.common.enums.QuickAnalyzeActionEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.permission.IMemberPermCache;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.period.PeriodLeadUtils;
import kd.epm.eb.ebSpread.domain.view.js.SpreadProperties;
import kd.epm.eb.formplugin.analyze.DiffAnalyzePlugin;
import kd.epm.eb.formplugin.analyze.IDiffAnalyzePlugin;
import kd.epm.eb.olap.api.metadata.IDataRow;
import kd.epm.eb.olap.enums.DataRowEnum;
import kd.epm.eb.olap.impl.metadata.DataRow;
import kd.epm.eb.spread.analyze.DiffAnalyzeScheme;
import kd.epm.eb.spread.command.style.CellGroupNodeInfo;
import kd.epm.eb.spread.control.SpreadContainer;
import kd.epm.eb.spread.template.spreadmanager.DiffCellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IDiffAnalyzeSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.hander.ESpanInfo;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.StyleCell;
import kd.epm.eb.spread.utils.ReportHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class DiffAnalyzeHelper {
    private static final Log log = LogFactory.getLog(DiffAnalyzeHelper.class);

    public static DiffAnalyzeScheme dynamicObject2SchemeObject(DynamicObject dynamicObject) {
        if (dynamicObject != null) {
            DiffAnalyzeScheme scheme = new DiffAnalyzeScheme();
            LinkedList<DiffAnalyzeScheme.DiffAnalyzeColumn> analyzeColumns = new LinkedList<DiffAnalyzeScheme.DiffAnalyzeColumn>();
            scheme.setAnalyzeColumns(analyzeColumns);
            scheme.setConfigJson(dynamicObject.getString("configjson"));
            Set<Object> allDimNumbers = new HashSet(16);
            Long modelId = dynamicObject.getLong("model.id");
            Long datasetId = dynamicObject.getLong("dataset.id");
            if (IDUtils.isNotNull((Long)modelId) && IDUtils.isNotNull((Long)datasetId)) {
                allDimNumbers = ModelCacheContext.getOrCreate((Long)modelId).getDimensionList(datasetId).stream().map(e -> e.getNumber()).collect(Collectors.toSet());
            }
            if (StringUtils.isNotEmpty((String)scheme.getConfigJson())) {
                DiffAnalyzeScheme.DiffAnalyzeConfig config = new DiffAnalyzeScheme.DiffAnalyzeConfig();
                Map configJson = (Map)SerializationUtils.fromJsonString((String)scheme.getConfigJson(), Map.class);
                String rowDimension = (String)configJson.get("row_dimension");
                String topItems = (String)configJson.get("TOP_ITEMS");
                if (rowDimension != null && allDimNumbers.contains(rowDimension)) {
                    config.setRowDimension(rowDimension);
                }
                if (topItems != null) {
                    config.setTopItems(DiffAnalyzeHelper.getTopItems(topItems));
                }
                scheme.setConfig(config);
            }
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            DataRow dataRow = null;
            Map configMap = null;
            String colconfigjson = null;
            for (DynamicObject ob : entryentity) {
                dataRow = new DataRow();
                dataRow.setIndex("A" + ob.getString("id"));
                int coltype = ob.getInt("coltype");
                dataRow.setDataRowType(DataRowEnum.valueOf((int)coltype));
                DiffAnalyzeScheme.DiffAnalyzeColumn diffAnalyzeColumn = new DiffAnalyzeScheme.DiffAnalyzeColumn(ob.getString("colname"), false, (IDataRow)dataRow);
                analyzeColumns.add(diffAnalyzeColumn);
                colconfigjson = ob.getString("colconfigjson");
                if (!StringUtils.isNotEmpty((String)colconfigjson)) continue;
                configMap = (Map)SerializationUtils.fromJsonString((String)colconfigjson, Map.class);
                if (coltype == DataRowEnum.DATA.getIndex()) {
                    String removeValue = (String)configMap.remove("_PERIOD_OFFSET");
                    if (removeValue != null) {
                        dataRow.setLead(removeValue.replaceAll("Y", "").replaceAll("Q", "").replaceAll("M", ""));
                    }
                    if (configMap != null && !configMap.isEmpty()) {
                        Set<Object> finalAllDimNumbers = allDimNumbers;
                        configMap.keySet().removeIf(k -> !k.startsWith("_") && !finalAllDimNumbers.contains(k));
                    }
                    dataRow.setMetas(configMap);
                    continue;
                }
                if (coltype == DataRowEnum.CUSTOM.getIndex()) {
                    dataRow.setExpression((String)configMap.get("_EXPRESSION"));
                    Pattern pattern = Pattern.compile("A[0-9]+");
                    Matcher matcher = pattern.matcher(dataRow.getExpression());
                    if (matcher.find()) {
                        dataRow.setRefIndex(matcher.group());
                    }
                }
                diffAnalyzeColumn.setDisplayFormat((String)configMap.get("_DISP_FORMAT"));
            }
            return scheme;
        }
        return null;
    }

    public static List<String> getTopItems(String topItems) {
        if (StringUtils.isNotEmpty((String)topItems)) {
            Object[] items;
            if (DiffAnalyzeHelper.isJson(topItems)) {
                ArrayList item = new ArrayList(8);
                List topMap = (List)SerializationUtils.fromJsonString((String)topItems, List.class);
                for (Map stringStringMap : topMap) {
                    item.add(stringStringMap.get("number"));
                }
                items = item.toArray(new String[0]);
            } else {
                items = topItems.split(",");
            }
            return Lists.newArrayList((Object[])items);
        }
        return null;
    }

    public static boolean isJson(String config) {
        boolean result = false;
        if (config.startsWith("{") && config.endsWith("}")) {
            result = true;
        } else if (config.startsWith("[") && config.endsWith("]")) {
            result = true;
        }
        return result;
    }

    public static boolean setMultiSelectF7Value(List<Map<String, String>> f7Value, String f7Key, IFormView formView) {
        if (f7Value != null && f7Key != null && formView != null) {
            IPageCache pageCache = (IPageCache)formView.getService(IPageCache.class);
            StringBuilder displayValue = new StringBuilder();
            for (Map<String, String> map : f7Value) {
                DiffAnalyzeHelper.buildMultiSelectF7ReturnValue(displayValue, map.get("name"), Integer.parseInt(map.get("scope")));
            }
            String oldValue = (String)formView.getModel().getValue(f7Key);
            String newValue = displayValue.indexOf(",") > 0 ? displayValue.substring(0, displayValue.length() - 1) : "";
            boolean triggerPropertyChange = false;
            if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
                String actualF7ValueOld = pageCache.get(f7Key);
                String actualF7ValueNew = SerializationUtils.toJsonString(f7Value);
                triggerPropertyChange = !actualF7ValueNew.equals(actualF7ValueOld);
            }
            pageCache.put(f7Key, SerializationUtils.toJsonString(f7Value));
            formView.setVisible(Boolean.valueOf(true), new String[]{f7Key});
            formView.getModel().setValue(f7Key, (Object)newValue);
            return triggerPropertyChange;
        }
        return false;
    }

    public static List<Map<String, String>> toListOfMap(DynamicObjectCollection rows) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        if (rows != null) {
            for (int i = 0; i < rows.size(); ++i) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", ((DynamicObject)rows.get(i)).getString("memberid"));
                map.put("scope", ((DynamicObject)rows.get(i)).getString("scope"));
                map.put("number", ((DynamicObject)rows.get(i)).getString("number"));
                map.put("name", ((DynamicObject)rows.get(i)).getString("name"));
                map.put("pid", ((DynamicObject)rows.get(i)).getString("pid"));
                list.add(map);
            }
        }
        return list;
    }

    public static List<Map<String, String>> toListOfMap(ListSelectedRowCollection rows) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        if (rows != null) {
            for (int i = 0; i < rows.size(); ++i) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", rows.get(i).getDataMap().get("memberid") + "");
                map.put("scope", rows.get(i).getDataMap().get("scope") + "");
                map.put("number", rows.get(i).getDataMap().get("number") + "");
                map.put("name", rows.get(i).getDataMap().get("name") + "");
                map.put("pid", rows.get(i).getDataMap().get("pid") + "");
                list.add(map);
            }
        }
        return list;
    }

    public static void buildMultiSelectF7ReturnValue(StringBuilder sb, String name, int val) {
        if (RangeEnum.getRangeByVal((int)val) == RangeEnum.ONLY) {
            sb.append(name).append(",");
        } else {
            sb.append(name).append(ResManager.loadKDString((String)"\u7684", (String)"DiffAnalyzePlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)val).getName()).append(",");
        }
    }

    public static String[] translateMessage(String text) {
        text = text.substring(1, text.length() - 1);
        String[] msg = text.split(",");
        for (int i = 0; i < msg.length; ++i) {
            msg[i] = msg[i].substring(1, msg[i].length() - 1);
        }
        return msg;
    }

    public static void validateSchemeEntity(DynamicObject dynamicObject) {
        DynamicObjectCollection dynamicObjects = null;
        if (dynamicObject != null && (dynamicObjects = dynamicObject.getDynamicObjectCollection("entryentity")) != null) {
            HashSet<String> names = new HashSet<String>(16);
            for (DynamicObject d : dynamicObjects) {
                String name = d.getString("colname");
                int coltype = d.getInt("coltype");
                if (StringUtils.isEmpty((String)name)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5217\u540d\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"DiffAnalyzePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                if (names.contains(name)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5217\u540d\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"DiffAnalyzePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                names.add(name);
                if (DataRowEnum.CUSTOM.getIndex() != coltype) continue;
                String colconfigjson = d.getString("colconfigjson");
                if (colconfigjson != null) {
                    Map configMap = (Map)SerializationUtils.fromJsonString((String)colconfigjson, Map.class);
                    if (StringUtils.isEmpty((String)((String)configMap.get("_EXPRESSION"))) || StringUtils.isEmpty((String)((String)configMap.get("_EXPRESSION_DISP")))) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DiffAnalyzePlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    try {
                        FormulaEngine.parseFormula((String)((String)configMap.get("_EXPRESSION")));
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Throwable)e);
                        throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bef\u3002", (String)"DiffAnalyzePlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"DiffAnalyzePlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public static DynamicObject getOrCreateDefaultSchemeConfig(long modelID, long datasetID) {
        if (modelID == 0L || datasetID == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u521b\u5efa\u9ed8\u8ba4\u5206\u6790\u65b9\u6848\u5931\u8d25\uff0c\u672a\u6307\u5b9a\u4f53\u7cfb\u6216\u6570\u636e\u96c6\u3002", (String)"DiffAnalyzePlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_diffanalyzescheme", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelID), new QFilter("dataset", "=", (Object)datasetID), new QFilter("type", "=", (Object)"2"), new QFilter("number", "like", (Object)"D-%")});
        if (dynamicObject != null) {
            return dynamicObject;
        }
        dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_diffanalyzescheme");
        dynamicObject.set("id", (Object)DBServiceHelper.genGlobalLongId());
        dynamicObject.set("model", (Object)modelID);
        dynamicObject.set("dataset", (Object)datasetID);
        dynamicObject.set("type", (Object)2);
        dynamicObject.set("creator", (Object)UserUtils.getUserId());
        dynamicObject.set("createtime", (Object)TimeServiceHelper.now());
        dynamicObject.set("number", (Object)("D-" + dynamicObject.getString("id")));
        dynamicObject.set("name", (Object)ResManager.loadKDString((String)"\u9ed8\u8ba4\u65b9\u6848", (String)"DiffAnalyzePlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        DynamicObjectCollection col = dynamicObject.getDynamicObjectCollection("entryentity");
        DynamicObject entry = col.addNew();
        entry.set("coltype", (Object)0);
        entry.set("colname", (Object)ResManager.loadKDString((String)"\u9ed8\u8ba4\u5217", (String)"DiffAnalyzePlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return dynamicObject;
    }

    public static List<DynamicObject> ensureDefaultSchemes(long modelID) {
        if (modelID == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u521b\u5efa\u9ed8\u8ba4\u5206\u6790\u65b9\u6848\u5931\u8d25\uff0c\u672a\u6307\u5b9a\u4f53\u7cfb\u3002", (String)"DiffAnalyzePlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        LinkedHashMap<Long, String> noSchemeDS = new LinkedHashMap<Long, String>();
        try (DataSet ds = DB.queryDataSet((String)"ensureDefaultSchemes", (DBRoute)DBRoute.of((String)"epm"), (String)"select distinct fid, fname from t_eb_dataset ds where ds.fmodel = ? and not exists (select 1 from t_eb_diffanalyzescheme where fmodelid = ds.fmodel and fdatasetid = ds.fid and fnumber like 'D-%')", (Object[])new Object[]{modelID});){
            while (ds.hasNext()) {
                Row row = ds.next();
                noSchemeDS.put(row.getLong("fid"), row.getString("fname"));
            }
        }
        if (noSchemeDS.size() > 0) {
            ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(noSchemeDS.size());
            long[] ids = DBServiceHelper.genLongIds((String)"t_eb_diffanalyzescheme", (int)noSchemeDS.size());
            int i = 0;
            for (Map.Entry dsIdName : noSchemeDS.entrySet()) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_diffanalyzescheme");
                dynamicObject.set("id", (Object)ids[i]);
                dynamicObject.set("model", (Object)modelID);
                dynamicObject.set("dataset", dsIdName.getKey());
                dynamicObject.set("type", (Object)2);
                dynamicObject.set("creator", (Object)UserUtils.getUserId());
                dynamicObject.set("createtime", (Object)TimeServiceHelper.now());
                dynamicObject.set("number", (Object)("D-" + ids[i]));
                dynamicObject.set("status", (Object)true);
                dynamicObject.set("name", (Object)ResManager.loadResFormat((String)"%1\u9ed8\u8ba4\u65b9\u6848", (String)"DiffAnalyzePlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[]{dsIdName.getValue()}));
                DynamicObjectCollection col = dynamicObject.getDynamicObjectCollection("entryentity");
                DynamicObject entry = col.addNew();
                entry.set("coltype", (Object)DataRowEnum.DATA.getIndex());
                entry.set("colname", (Object)ResManager.loadKDString((String)"\u9ed8\u8ba4\u5217", (String)"DiffAnalyzePlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                dynamicObjects.add(dynamicObject);
                ++i;
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects.toArray(new DynamicObject[0]));
            return dynamicObjects;
        }
        return null;
    }

    public static List<kd.epm.eb.common.cache.impl.Member> getMembers(Long datasetId, IModelCacheHelper modelCacheHelper, IMemberPermCache memberPermCache, Long viewId, String dimensionNumber) {
        List members = null;
        if (modelCacheHelper != null) {
            boolean exists;
            if (IDUtils.isNotNull((Long)viewId) && !(exists = QueryServiceHelper.exists((String)"eb_dimensionview", (Object)viewId))) {
                viewId = modelCacheHelper.getViewByDataSetAndDimNumber(datasetId, dimensionNumber);
            }
            members = modelCacheHelper.getMembers(viewId, dimensionNumber);
            if (memberPermCache != null && members != null && members.size() > 0) {
                if (SysDimensionEnum.Account.getNumber().equals(dimensionNumber)) {
                    members = members.stream().filter(member -> member.getDatasetId() != null && member.getDatasetId().equals(datasetId) && !memberPermCache.isNoperm(dimensionNumber, member.getNumber(), Long.valueOf(0L))).collect(Collectors.toList());
                } else if (SysDimensionEnum.Metric.getNumber().equals(dimensionNumber)) {
                    members = members.stream().filter(member -> member.getDatatype() != null && (member.getDatatype().equals(MetricDataTypeEnum.CURRENCY.getIndex()) || member.getDatatype().equals(MetricDataTypeEnum.NONMONETARY.getIndex()))).collect(Collectors.toList());
                } else {
                    Long view = viewId;
                    members = members.stream().filter(member -> !memberPermCache.isNoperm(dimensionNumber, member.getNumber(), view)).collect(Collectors.toList());
                }
            }
        }
        return members;
    }

    public static List<kd.epm.eb.common.cache.impl.Member> getMember(Long datasetId, IModelCacheHelper modelCacheHelper, IMemberPermCache memberPermCache, String dimensionNumber, Long viewId, String memberNumber, int range) {
        List members = null;
        if (modelCacheHelper != null) {
            boolean exists;
            if (IDUtils.isNotNull((Long)viewId) && !(exists = QueryServiceHelper.exists((String)"eb_dimensionview", (Object)viewId))) {
                viewId = modelCacheHelper.getViewByDataSetAndDimNumber(datasetId, dimensionNumber);
            }
            members = modelCacheHelper.getMemberSort(dimensionNumber, viewId, memberNumber, range);
            if (memberPermCache != null && members != null && members.size() > 0) {
                if (SysDimensionEnum.Account.getNumber().equals(dimensionNumber)) {
                    members = members.stream().filter(member -> member.getDatasetId() != null && member.getDatasetId().equals(datasetId) && !memberPermCache.isNoperm(dimensionNumber, member.getNumber(), Long.valueOf(0L))).collect(Collectors.toList());
                } else if (SysDimensionEnum.Metric.getNumber().equals(dimensionNumber)) {
                    members = members.stream().filter(member -> member.getDatatype() != null && (member.getDatatype().equals(MetricDataTypeEnum.CURRENCY.getIndex()) || member.getDatatype().equals(MetricDataTypeEnum.NONMONETARY.getIndex()))).collect(Collectors.toList());
                } else {
                    Long view = viewId;
                    members = members.stream().filter(member -> !memberPermCache.isNoperm(dimensionNumber, member.getNumber(), view)).collect(Collectors.toList());
                }
            }
        }
        return members;
    }

    public static kd.epm.eb.common.cache.impl.Member getMember(Long datasetId, IModelCacheHelper modelCacheHelper, IMemberPermCache memberPermCache, String dimensionNumber, Long viewId, String memberNumber) {
        kd.epm.eb.common.cache.impl.Member member = null;
        if (modelCacheHelper != null) {
            boolean exists;
            if (IDUtils.isNotNull((Long)viewId) && !(exists = QueryServiceHelper.exists((String)"eb_dimensionview", (Object)viewId))) {
                viewId = modelCacheHelper.getViewByDataSetAndDimNumber(datasetId, dimensionNumber);
            }
            member = modelCacheHelper.getMember(dimensionNumber, viewId, memberNumber);
            if (memberPermCache != null && member != null) {
                if (memberPermCache.isNoperm(dimensionNumber, memberNumber, viewId)) {
                    member = null;
                }
                if (member != null && SysDimensionEnum.Account.getNumber().equals(dimensionNumber) && !IDUtils.equals((Object)datasetId, (Object)member.getDatasetId())) {
                    member = null;
                }
            }
        }
        return member;
    }

    public static kd.epm.eb.common.cache.impl.Member getMember(IModelCacheHelper modelCacheHelper, IMemberPermCache memberPermCache, String dimensionNumber, Long viewId, String memberNumber) {
        if (memberPermCache != null && memberPermCache.isNoperm(dimensionNumber, memberNumber, viewId)) {
            return null;
        }
        List members = null;
        if (modelCacheHelper != null) {
            boolean exists;
            if (IDUtils.isNotNull((Long)viewId) && !(exists = QueryServiceHelper.exists((String)"eb_dimensionview", (Object)viewId))) {
                viewId = 0L;
            }
            if ((members = modelCacheHelper.getMember(dimensionNumber, viewId, memberNumber, RangeEnum.ONLY.getIndex())) != null && members.size() > 0) {
                return (kd.epm.eb.common.cache.impl.Member)members.get(0);
            }
        }
        return null;
    }

    public static String updateExpression(String expr, Set<String> validCols) {
        String[] splited;
        if (StringUtils.isNotEmpty((String)expr) && (splited = StringUtils.split((String)expr, (boolean)false, (char[])new char[]{'+', '-', '*', '/', '(', ')'})) != null) {
            for (String col : splited) {
                if (validCols.contains(col.trim()) || QuickAnalyzeActionEnum.getNameByNumber((String)col.trim()) != null) continue;
                expr = expr.replaceAll(col.trim(), "");
            }
        }
        return expr;
    }

    public static String updateExpressionDisplay(String expr, Map<String, String> idNameMap, String colPrefix) {
        if (StringUtils.isNotEmpty((String)expr) && idNameMap != null) {
            for (Map.Entry<String, String> entry : idNameMap.entrySet()) {
                String col = colPrefix != null && !entry.getKey().startsWith(colPrefix) ? colPrefix + entry.getKey() : entry.getKey();
                expr = expr.replaceAll(col, entry.getValue());
            }
            for (QuickAnalyzeActionEnum actionEnum : QuickAnalyzeActionEnum.values()) {
                if (!expr.startsWith(actionEnum.getNumber())) continue;
                expr = expr.replaceAll(actionEnum.getNumber(), actionEnum.getName());
                break;
            }
        }
        return expr;
    }

    public static List<ECell> insertMemberRows(IDiffAnalyzeSpreadManager spreadManager, SpreadContainer spreadContainer, int row, List<kd.epm.eb.common.cache.impl.Member> cacheMembers, IModelCacheHelper modelCacheHelper) {
        if (spreadManager != null && cacheMembers != null && cacheMembers.size() > 0 && spreadManager.getRowCellDimMembers() != null) {
            List rowCellDimMembers = spreadManager.getRowCellDimMembers();
            ISheet sheet = spreadManager.getEbook().getSheet(0);
            StyleCell parentCell = (StyleCell)sheet.getECell(row, 0);
            DiffCellDimMember parentCellDimMember = (DiffCellDimMember)rowCellDimMembers.get(row);
            if (parentCell == null || parentCellDimMember == null) {
                return null;
            }
            String metricDT = null;
            if (SysDimensionEnum.Metric.getNumber().equals(spreadManager.getRowDimension().getNumber())) {
                for (int i = row; i >= 0; --i) {
                    ECell metricRowCell = sheet.getECellNotAdd(i, 0);
                    if (metricRowCell == null || !(metricRowCell.getUserObject("metricDT") instanceof String)) continue;
                    metricDT = (String)metricRowCell.getUserObject("metricDT");
                    break;
                }
            }
            int size = cacheMembers.size();
            for (int i = 0; i < size; ++i) {
                rowCellDimMembers.add(row + 1, null);
                sheet.insertRow(row + 1);
            }
            int initTi = parentCell.getTextIndent() + 1;
            int levelOffset = cacheMembers.get(0).getLevel();
            DiffCellDimMember cellDimMember = null;
            HashMap<String, DiffCellDimMember> cellDimMemberMap = new HashMap<String, DiffCellDimMember>(16);
            LinkedList<ECell> updateUICells = new LinkedList<ECell>();
            int r = row + 1;
            List longDisplayDimNums = ReportHelper.getLongDisplayDimNums((int)spreadManager.getMemberDisplayType(), (IModelCacheHelper)modelCacheHelper);
            for (kd.epm.eb.common.cache.impl.Member member : cacheMembers) {
                Long viewId = 0L;
                if (spreadManager.getDimemsionViews() != null) {
                    viewId = IDUtils.toLong(spreadManager.getDimemsionViews().get(member.getDimension().getNumber()));
                }
                StyleCell cell = DiffAnalyzeHelper.getStyleCell(sheet, r, 0, member.getName(), member.getNumber(), member.getSimpleName(), member.getLevel() - levelOffset + initTi, spreadManager.getMemberDisplayType(), modelCacheHelper, member, viewId, longDisplayDimNums);
                cell.setUserObject("dimnumber", (Object)member.getDimension().getNumber());
                cell.setUserObject("memnumber", (Object)member.getNumber());
                cell.setUserObject("name", (Object)member.getName());
                cell.setUserObject("simplename", (Object)member.getSimpleName());
                if (metricDT != null) {
                    cell.setUserObject("metricDT", (Object)metricDT);
                }
                updateUICells.add((ECell)cell);
                String longNumber = member.getLongNumber();
                String parentLongNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
                cellDimMember = new DiffCellDimMember(member.getDimension().getNumber(), member.getNumber(), member.getLevel(), member.isLeaf(), cellDimMemberMap.get(parentLongNumber) == null ? parentCellDimMember : (DiffCellDimMember)cellDimMemberMap.get(parentLongNumber));
                if (!member.isLeaf()) {
                    cellDimMemberMap.putIfAbsent(longNumber, cellDimMember);
                    cellDimMember.setGroupNodeType(1);
                }
                cellDimMember.setTi(member.getLevel() - levelOffset + initTi);
                rowCellDimMembers.set(r, cellDimMember);
                ++r;
            }
            return updateUICells;
        }
        return null;
    }

    public static List<ECell> insertMemberCols(IDiffAnalyzeSpreadManager spreadManager, SpreadContainer spreadContainer, int index, List<kd.epm.eb.common.cache.impl.Member> cacheMembers, IModelCacheHelper modelCacheHelper, Set<Long> scopeMemberIds, int range) {
        if (spreadManager != null && cacheMembers != null && cacheMembers.size() > 0 && spreadManager.getColCellDimMembers() != null) {
            Optional<Dimension> optional;
            Dimension metricDim;
            List cellDimMembers = spreadManager.getColCellDimMembers();
            ISheet sheet = spreadManager.getEbook().getSheet(0);
            StyleCell parentCell = (StyleCell)sheet.getECell(0, index);
            DiffCellDimMember parentCellDimMember = (DiffCellDimMember)cellDimMembers.get(index);
            if (parentCell == null || parentCellDimMember == null) {
                return null;
            }
            List schemeColumns = spreadManager.getDiffAnalyzeScheme().getAnalyzeColumns();
            int schemeColSize = schemeColumns.size();
            String METRIC = SysDimensionEnum.Metric.getNumber();
            String dimNumber = spreadManager.getColDimension().getNumber();
            String commonMetric = null;
            String colMetric = null;
            HashMap metricDataTypes = new HashMap(16);
            List members = modelCacheHelper.getMembers(null, SysDimensionEnum.Metric.getNumber());
            if (members != null) {
                members.forEach(m -> metricDataTypes.put(m.getNumber(), m.getDatatype()));
            }
            Dimension dimension = metricDim = (optional = spreadManager.getCommonDimension().stream().filter(e -> METRIC.equals(e.getNumber())).findFirst()).isPresent() ? optional.get() : null;
            if (metricDim != null && metricDim.getMembers() != null && metricDim.getMembers().size() > 0) {
                commonMetric = ((Member)metricDim.getMembers().get(0)).getNumber();
            }
            int size = cacheMembers.size();
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < schemeColSize; ++j) {
                    cellDimMembers.add(index + schemeColSize, null);
                    sheet.insertColumn(index + schemeColSize);
                }
            }
            int initTi = parentCell.getTextIndent() + 1;
            int levelOffset = cacheMembers.get(0).getLevel();
            DiffCellDimMember cellDimMember = null;
            HashMap<String, DiffCellDimMember> cellDimMemberMap = new HashMap<String, DiffCellDimMember>(16);
            LinkedList<ECell> updateUICells = new LinkedList<ECell>();
            int c = index + schemeColSize;
            List longDisplayDimNums = ReportHelper.getLongDisplayDimNums((int)spreadManager.getMemberDisplayType(), (IModelCacheHelper)modelCacheHelper);
            for (kd.epm.eb.common.cache.impl.Member member : cacheMembers) {
                String parentLongNumber;
                String longNumber;
                Long viewId = 0L;
                if (spreadManager.getDimemsionViews() != null) {
                    viewId = IDUtils.toLong(spreadManager.getDimemsionViews().get(member.getDimension().getNumber()));
                }
                StyleCell memberCell = DiffAnalyzeHelper.getStyleCell(sheet, 0, c, member.getName(), member.getNumber(), member.getSimpleName(), member.getLevel() - levelOffset + initTi, spreadManager.getMemberDisplayType(), modelCacheHelper, member, viewId, longDisplayDimNums);
                memberCell.setUserObject("dimnumber", (Object)member.getDimension().getNumber());
                memberCell.setUserObject("memnumber", (Object)member.getNumber());
                memberCell.setUserObject("name", (Object)member.getName());
                memberCell.setUserObject("simplename", (Object)member.getSimpleName());
                memberCell.setSpanInfo(new ESpanInfo(memberCell.getRow(), memberCell.getCol(), 1, schemeColSize));
                updateUICells.add((ECell)memberCell);
                for (int i = 0; i < schemeColSize; ++i) {
                    colMetric = (String)((DiffAnalyzeScheme.DiffAnalyzeColumn)schemeColumns.get(i)).getDataRow().getMetas().get(METRIC);
                    if (colMetric == null && commonMetric != null) {
                        colMetric = commonMetric;
                    } else if (colMetric == null && dimNumber.equals(METRIC)) {
                        colMetric = member.getNumber();
                    }
                    StyleCell schemeCell = DiffAnalyzeHelper.getStyleCell(sheet, 1, c + i);
                    schemeCell.setValue((Object)((DiffAnalyzeScheme.DiffAnalyzeColumn)schemeColumns.get(i)).getDisplayName());
                    schemeCell.setUserObject("dimnumber", (Object)dimNumber);
                    schemeCell.setUserObject("number", (Object)member.getNumber());
                    schemeCell.setUserObject("simplename", (Object)member.getSimpleName());
                    schemeCell.setUserObject("index", (Object)i);
                    schemeCell.setUserObject("metric", (Object)colMetric);
                    schemeCell.setUserObject("metricDT", metricDataTypes.get(colMetric));
                    if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) && member.getNumber() != null && ((DiffAnalyzeScheme.DiffAnalyzeColumn)schemeColumns.get(i)).getDataRow().getLead() != null) {
                        String leadPeriod = PeriodLeadUtils.get((String)member.getNumber(), (PeriodLeadUtils.PeriodLead)PeriodLeadUtils.parse((String)((DiffAnalyzeScheme.DiffAnalyzeColumn)schemeColumns.get(i)).getDataRow().getLead()));
                        schemeCell.setUserObject("leadPeriod", (Object)leadPeriod);
                    } else {
                        schemeCell.setUserObject("leadPeriod", null);
                    }
                    longNumber = member.getLongNumber();
                    parentLongNumber = longNumber != null && longNumber.contains("!") ? longNumber.substring(0, longNumber.lastIndexOf("!")) : longNumber;
                    cellDimMember = new DiffCellDimMember(dimNumber, member.getNumber(), member.getLevel(), member.isLeaf(), (DiffCellDimMember)cellDimMemberMap.get(parentLongNumber));
                    if (!member.isLeaf()) {
                        cellDimMemberMap.putIfAbsent(longNumber, cellDimMember);
                        cellDimMember.setGroupNodeType(1);
                    }
                    cellDimMembers.set(schemeCell.getCol(), cellDimMember);
                    updateUICells.add((ECell)schemeCell);
                }
                longNumber = member.getLongNumber();
                parentLongNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
                cellDimMember = new DiffCellDimMember(member.getDimension().getNumber(), member.getNumber(), member.getLevel(), member.isLeaf(), cellDimMemberMap.get(parentLongNumber) == null ? parentCellDimMember : (DiffCellDimMember)cellDimMemberMap.get(parentLongNumber));
                if (!member.isLeaf()) {
                    cellDimMemberMap.putIfAbsent(longNumber, cellDimMember);
                    if (scopeMemberIds != null) {
                        boolean isExpandAll = range == RangeEnum.ALL_EXCLUDE.getIndex();
                        List allMembers1 = member.getChildren();
                        Set collect = allMembers1.stream().map(x -> x.getId()).collect(Collectors.toSet());
                        boolean disjoint = Collections.disjoint(scopeMemberIds, collect);
                        cellDimMember.setGroupNodeType(disjoint ? GroupNodeTypeEnum.NONE.getIndex() : (isExpandAll ? GroupNodeTypeEnum.COLLAPSE.getIndex() : GroupNodeTypeEnum.EXPEND.getIndex()));
                    } else {
                        cellDimMember.setGroupNodeType(GroupNodeTypeEnum.EXPEND.getIndex());
                    }
                }
                cellDimMember.setTi(member.getLevel() - levelOffset + initTi);
                for (int j = 0; j < schemeColSize; ++j) {
                    cellDimMembers.set(c + j, cellDimMember);
                }
                c += schemeColSize;
            }
            return updateUICells;
        }
        return null;
    }

    public static void packageCells(List<Map<String, Object>> parameters, ECell cell) {
        HashMap<String, Object> valMap = new HashMap<String, Object>(3);
        valMap.put(SpreadProperties.UpdataValueMethod.R.k(), cell.getRow());
        valMap.put(SpreadProperties.UpdataValueMethod.C.k(), cell.getCol());
        valMap.put(SpreadProperties.UpdataValueMethod.V.k(), cell.getValue());
        parameters.add(valMap);
    }

    public static void refreshGroupNodeType(SpreadContainer spreadContainer, IDiffAnalyzeSpreadManager spreadManager) {
        if (spreadContainer != null && spreadManager != null) {
            List rowCellDimMembers = spreadManager.getRowCellDimMembers();
            List colCellDimMembers = spreadManager.getColCellDimMembers();
            if (rowCellDimMembers != null && rowCellDimMembers.size() > 0) {
                DiffAnalyzeHelper.refreshGroupNodeType(spreadContainer, rowCellDimMembers, 0, rowCellDimMembers.size(), spreadManager.getEbook().getSheet(0), true);
            }
            if (colCellDimMembers != null && colCellDimMembers.size() > 0) {
                DiffAnalyzeHelper.refreshGroupNodeType(spreadContainer, colCellDimMembers, 0, colCellDimMembers.size(), spreadManager.getEbook().getSheet(0), false);
            }
        }
    }

    public static void refreshGroupNodeType(SpreadContainer spreadContainer, List<DiffCellDimMember> cellDimMembers, int index, int count, ISheet sheet, boolean isRow) {
        if (spreadContainer != null && cellDimMembers != null && cellDimMembers.size() > 0 && index >= 0) {
            LinkedList<CellGroupNodeInfo> groupNodeTypes = new LinkedList<CellGroupNodeInfo>();
            int size = cellDimMembers.size();
            for (int i = 0; i < count && i < size; ++i) {
                int col;
                DiffCellDimMember cellDimMember = cellDimMembers.get(i + index);
                if (cellDimMember == null) continue;
                int groupNodeType = cellDimMember.getGroupNodeType();
                if (groupNodeType == GroupNodeTypeEnum.EXPEND.getIndex()) {
                    StyleCell nextCell;
                    StyleCell currentCell = isRow ? DiffAnalyzeHelper.getStyleCellNotAdd(sheet, i + index, 0) : DiffAnalyzeHelper.getStyleCellNotAdd(sheet, 0, i + index);
                    StyleCell styleCell = nextCell = isRow ? DiffAnalyzeHelper.getStyleCellNotAdd(sheet, i + index + 1, 0) : DiffAnalyzeHelper.getStyleCellNotAdd(sheet, 0, i + index + 1);
                    if (currentCell != null && nextCell != null && nextCell.getTextIndent() > currentCell.getTextIndent()) {
                        groupNodeType = GroupNodeTypeEnum.COLLAPSE.getIndex();
                    }
                }
                int row = isRow ? i + index : 0;
                int n = col = isRow ? 0 : i + index;
                if (isRow) {
                    groupNodeTypes.add(new CellGroupNodeInfo(row, col, groupNodeType, cellDimMember.getDrill(), cellDimMember.getTi()));
                    continue;
                }
                groupNodeTypes.add(CellGroupNodeInfo.ofSmallRadix((int)row, (int)col, (int)groupNodeType, (int)cellDimMember.getTi(), (boolean)true));
            }
            if (groupNodeTypes.size() > 0) {
                spreadContainer.setGroupColNode(groupNodeTypes);
            }
        }
    }

    public static StyleCell getStyleCell(ISheet sheet, int row, int col, String cellName, String cellNum, String simpleName, int ti, int memberDisplayType, IModelCacheHelper modelCacheHelper, kd.epm.eb.common.cache.impl.Member member, Long viewId, List<String> longDisplayDimNums) {
        StyleCell cell = (StyleCell)sheet.getECell(row, col);
        if (MemberDisplayTypeEnum.NUMBER.getIndex() == memberDisplayType || MemberDisplayTypeEnum.LONGNUMBER.getIndex() == memberDisplayType) {
            cell.setValue((Object)cellNum);
        } else if (MemberDisplayTypeEnum.NAMEANDNUMBER.getIndex() == memberDisplayType || MemberDisplayTypeEnum.LONGNAMENUMBER.getIndex() == memberDisplayType) {
            cell.setValue((Object)(cellName + ":" + cellNum));
        } else if (MemberDisplayTypeEnum.SIMPLENAME.getIndex() == memberDisplayType) {
            cell.setValue((Object)(StringUtils.isEmpty((String)simpleName) ? cellName : simpleName));
        } else if (MemberDisplayTypeEnum.SIMNAMENUMBER.getIndex() == memberDisplayType) {
            cell.setValue((Object)(StringUtils.isEmpty((String)simpleName) ? cellName + ":" + cellNum : simpleName + ":" + cellNum));
        } else if (MemberDisplayTypeEnum.NAME.getIndex() == memberDisplayType || MemberDisplayTypeEnum.LONGNAME.getIndex() == memberDisplayType) {
            cell.setValue((Object)cellName);
        }
        DiffAnalyzeHelper.setCellValueByLongDisplayType(cell, longDisplayDimNums, member, viewId, modelCacheHelper, memberDisplayType);
        cell.setFont("13px Microsoft YaHei");
        cell.setTextIndent(ti);
        return cell;
    }

    public static void setCellValueByLongDisplayType(StyleCell cell, List<String> longDisplayDimNums, kd.epm.eb.common.cache.impl.Member cacheMember, Long viewId, IModelCacheHelper modelCacheHelper, int memberDisplayType) {
        boolean displayLong;
        if (cell == null || CollectionUtils.isEmpty(longDisplayDimNums) || cacheMember == null || cacheMember.getDimension() == null || modelCacheHelper == null) {
            return;
        }
        boolean bl = displayLong = MemberDisplayTypeEnum.LONGNUMBER.getIndex() == memberDisplayType || MemberDisplayTypeEnum.LONGNAME.getIndex() == memberDisplayType || MemberDisplayTypeEnum.LONGNAMENUMBER.getIndex() == memberDisplayType;
        if (longDisplayDimNums.contains(cacheMember.getDimension().getNumber()) && displayLong) {
            String longName;
            String longNumber = cacheMember.getLongNumber();
            String string = longName = StringUtils.isNotEmpty((String)longNumber) ? cacheMember.getLongName(modelCacheHelper.getParentsByOrder(viewId, cacheMember, false)) : "";
            if (StringUtils.isEmpty((String)longName)) {
                longName = cacheMember.getName();
            }
            if (StringUtils.isEmpty((String)longNumber)) {
                longNumber = cacheMember.getNumber();
            }
            cell.setUserObject("longname", (Object)longName);
            cell.setUserObject("longnumber", (Object)longNumber);
            if (MemberDisplayTypeEnum.LONGNUMBER.getIndex() == memberDisplayType) {
                cell.setValue((Object)longNumber);
            } else if (MemberDisplayTypeEnum.LONGNAME.getIndex() == memberDisplayType) {
                cell.setValue((Object)longName);
            } else if (MemberDisplayTypeEnum.LONGNAMENUMBER.getIndex() == memberDisplayType) {
                cell.setValue((Object)(longName + ":" + longNumber));
            }
        }
    }

    public static StyleCell getStyleCell(ISheet sheet, int row, int col) {
        return (StyleCell)sheet.getECell(row, col);
    }

    public static StyleCell getStyleCellNotAdd(ISheet sheet, int row, int col) {
        return (StyleCell)sheet.getECellNotAdd(row, col);
    }

    public static List<Member> defaultCurrentNextYear(List<Member> members) {
        if (members != null && members.size() > 0 && SysDimensionEnum.BudgetPeriod.getNumber().equals(members.get(0).getDimension().getNumber())) {
            int currentYear = Calendar.getInstance().get(1);
            String fyCurrentYear = "FY" + currentYear;
            String fyNextYear = "FY" + (currentYear + 1);
            List<Member> mems = members.stream().filter(m -> m.getNumber().equals(fyCurrentYear) || m.getNumber().equals(fyNextYear)).collect(Collectors.toList());
            if (mems != null && mems.size() > 0) {
                return mems;
            }
            return members.stream().filter(m -> m.getLevel() == 2).collect(Collectors.toList());
        }
        return members;
    }

    public static String getPrintInfo(Map<MembersKey, Object[]> datas, int topN) {
        if (datas != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("datas.size()=").append(datas.size()).append(", topN=").append(topN).append(": ");
            int i = 0;
            for (Map.Entry<MembersKey, Object[]> entry : datas.entrySet()) {
                if (i >= topN) break;
                sb.append("{").append(entry.getKey()).append("=").append(Arrays.toString(entry.getValue())).append("}");
                ++i;
            }
            return sb.toString();
        }
        return "null";
    }

    public static Map<String, Object> getConfigMapByKey(String configJson, String key) {
        Map configMap;
        String value;
        if (StringUtils.isNotEmpty((String)configJson) && StringUtils.isNotEmpty((String)(value = (String)(configMap = (Map)SerializationUtils.fromJsonString((String)configJson, Map.class)).get(key)))) {
            return (Map)SerializationUtils.fromJsonString((String)value, Map.class);
        }
        return null;
    }

    public static Map<String, Object> getConfigMapByKey(Map<String, Object> configMap, String key) {
        String value;
        if (configMap != null && StringUtils.isNotEmpty((String)(value = (String)configMap.get(key)))) {
            return (Map)SerializationUtils.fromJsonString((String)value, Map.class);
        }
        return null;
    }

    public static Set<String> getSetValueByConfigKey(Map<String, Object> configMap, String key) {
        String value;
        if (configMap != null && StringUtils.isNotEmpty((String)(value = (String)configMap.get(key)))) {
            return (Set)SerializationUtils.fromJsonString((String)value, Set.class);
        }
        return null;
    }

    public static Map<String, Object> getMetricDisplay(String configJson) {
        return DiffAnalyzeHelper.getConfigMapByKey(configJson, "metricdisplay");
    }

    public static Map<String, Object> getDimensionDisplay(String configJson) {
        return DiffAnalyzeHelper.getConfigMapByKey(configJson, "hide_dimensions");
    }

    public static String getSchemeConfigJson(IDiffAnalyzePlugin formPlugin) {
        DynamicObject dynamicObject;
        Object configJson;
        if (formPlugin == null) {
            return null;
        }
        Map cacheMap = formPlugin.getView().getPageCache().getAll();
        Map<String, Long> dimensionViews = formPlugin.getDimensionViews();
        Map<String, Object> configMap = new HashMap<String, String>(8);
        Long schemeId = formPlugin.getSchemeId();
        if (IDUtils.isNotNull((Long)schemeId) && StringUtils.isNotEmpty((String)(configJson = (dynamicObject = QueryServiceHelper.queryOne((String)"eb_diffanalyzescheme", (String)"configJson", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)})).getString("configJson")))) {
            configMap = (Map)SerializationUtils.fromJsonString((String)configJson, Map.class);
        }
        Set dimNumbers = formPlugin.getAllDimension().stream().map(e -> e.getNumber()).collect(Collectors.toSet());
        for (String dimNumber : dimNumbers) {
            String viewIdKey = dimNumber + "viewId";
            if (!IDUtils.isNotNull((Long)dimensionViews.get(dimNumber))) continue;
            configMap.put(viewIdKey, dimensionViews.get(dimNumber) + "");
        }
        String value = formPlugin.getCachedRowDimension();
        if (StringUtils.isNotEmpty((String)value)) {
            configMap.put("row_dimension", value);
        } else if (formPlugin != null) {
            configMap.put("row_dimension", formPlugin.getCurrentRowDimension());
        }
        value = (String)cacheMap.get("def_col_dimension");
        if (StringUtils.isNotEmpty((String)value)) {
            configMap.put("def_col_dimension", value);
        }
        if (StringUtils.isNotEmpty((String)(value = (String)cacheMap.get("defmemberdisplay")))) {
            configMap.put("defmemberdisplay", value);
        }
        if (StringUtils.isNotEmpty((String)(value = (String)cacheMap.get("defemptyrowdisplay")))) {
            configMap.put("defemptyrowdisplay", value);
        }
        if (StringUtils.isNotEmpty((String)(value = (String)cacheMap.get("defunitdisplay")))) {
            configMap.put("defunitdisplay", value);
        }
        if (StringUtils.isNotEmpty((String)(value = (String)cacheMap.get("metricdisplay")))) {
            configMap.put("metricdisplay", value);
        }
        if (StringUtils.isNotEmpty((String)(value = (String)cacheMap.get("metricdisplay_no_sep")))) {
            configMap.put("metricdisplay_no_sep", value);
        }
        if (StringUtils.isNotEmpty((String)(value = (String)cacheMap.get("hide_dimensions")))) {
            configMap.put("hide_dimensions", value);
        }
        DiffAnalyzeHelper.getConfigParam(configMap, cacheMap, "account_range", "TOP_ITEMS");
        for (String ctrlKey : DiffAnalyzePlugin.F7_KEYS_DIMPOOL) {
            String dimNumber = formPlugin.getF7KeyDimMapPage().get(ctrlKey);
            if (dimNumber == null) continue;
            String configKey = "ebf7_page_" + dimNumber.toLowerCase(Locale.ROOT);
            DiffAnalyzeHelper.getConfigParam(configMap, cacheMap, ctrlKey, configKey);
        }
        return SerializationUtils.toJsonString(configMap);
    }

    public static Map<String, Object> getConfigParam(Map<String, Object> configMap, Map<String, String> cacheMap, String ctrlKey, String configKey) {
        String value;
        String string = value = cacheMap == null ? null : cacheMap.get(ctrlKey);
        if (StringUtils.isNotEmpty((String)value)) {
            List list = (List)SerializationUtils.fromJsonString((String)value, List.class);
            ArrayList valList = new ArrayList(8);
            if (list != null && list.size() > 0) {
                for (Map map : list) {
                    HashMap valMap = new HashMap(1);
                    if (StringUtils.isNotEmpty((String)((String)map.get("number")))) {
                        valMap.put("number", map.get("number"));
                    }
                    if (StringUtils.isNotEmpty((String)((String)map.get("scope")))) {
                        valMap.put("scope", map.get("scope"));
                    }
                    valList.add(valMap);
                }
                configMap.put(configKey, SerializationUtils.toJsonString(valList));
            }
        } else {
            configMap.remove(configKey);
        }
        return configMap;
    }

    public static List<Member> fromCacheMembers(List<kd.epm.eb.common.cache.impl.Member> cacheMembers) {
        if (cacheMembers != null) {
            ArrayList<Member> members = new ArrayList<Member>(cacheMembers.size());
            for (kd.epm.eb.common.cache.impl.Member m : cacheMembers) {
                members.add(Member.loadFormCache((kd.epm.eb.common.cache.impl.Member)m));
            }
            return members;
        }
        return null;
    }

    public static Set<kd.epm.eb.common.cache.impl.Member> resolveHasPermMember(IModelCacheHelper modelCacheHelper, long busModelId, String dimNumber, Long viewId, @NotNull List<Map<String, String>> memberQuote) {
        boolean exists;
        Set permMembNumbers = EpmThreadLocalUtils.getPermMembNumbers((Long)UserUtils.getUserId(), (String)dimNumber, (Long)modelCacheHelper.getModelobj().getId(), (Long)busModelId, (Long)viewId, (DimMembPermType)DimMembPermType.READ, (boolean)true);
        if (IDUtils.isNotNull((Long)viewId) && !(exists = QueryServiceHelper.exists((String)"eb_dimensionview", (Object)viewId))) {
            viewId = 0L;
        }
        LinkedHashSet<kd.epm.eb.common.cache.impl.Member> memberSet = new LinkedHashSet<kd.epm.eb.common.cache.impl.Member>(16);
        if (CollectionUtils.isEmpty(memberQuote)) {
            return memberSet;
        }
        for (Map<String, String> map : memberQuote) {
            List members;
            String scope;
            String number = map.get("number");
            if (org.apache.commons.lang3.StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{number, scope = map.get("scope")}) || !CollectionUtils.isNotEmpty((Collection)(members = modelCacheHelper.getMember(dimNumber, viewId, number, Integer.parseInt(scope))))) continue;
            if (permMembNumbers != null) {
                members.removeIf(member -> !permMembNumbers.contains(member.getNumber()));
            }
            memberSet.addAll(members);
        }
        return memberSet;
    }
}

