/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analyze;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.ebSpread.domain.view.SpreadSelector;
import kd.epm.eb.formplugin.analyze.DiffAnalyzePluginConstant;
import kd.epm.eb.formplugin.analyze.IDiffAnalyzePlugin;
import kd.epm.eb.formplugin.analyze.command.CollapseColChildCommand;
import kd.epm.eb.formplugin.analyze.command.CollapseRowChildCommand;
import kd.epm.eb.formplugin.analyze.command.DrillRowDimCommand;
import kd.epm.eb.formplugin.analyze.command.ExpandColChildCommand;
import kd.epm.eb.formplugin.analyze.command.ExpandRowChildCommand;
import kd.epm.eb.spread.analyze.DiffAnalyzeScheme;
import kd.epm.eb.spread.command.rangedefined.ContextMenuItemsEnum;
import kd.epm.eb.spread.command.rangedefined.ToolBarItemsEnum;
import kd.epm.eb.spread.command.style.ContextMenuWorkArea;
import kd.epm.eb.spread.control.SpreadContainer;
import kd.epm.eb.spread.model.MenuItem;
import kd.epm.eb.spread.template.spreadmanager.DiffCellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IDiffAnalyzeSpreadManager;

public interface DiffAnalyzeMenuActions
extends IDiffAnalyzePlugin,
DiffAnalyzePluginConstant {
    public static final Log log = LogFactory.getLog(DiffAnalyzeMenuActions.class);

    default public void drillDimensionEntity(Object param) {
        this.drillDimemsion(SysDimensionEnum.Entity.getNumber());
    }

    default public void drillDimensionAuditTrail(Object param) {
        this.drillDimemsion(SysDimensionEnum.AuditTrail.getNumber());
    }

    default public void drillDimensionChangeType(Object param) {
        this.drillDimemsion(SysDimensionEnum.ChangeType.getNumber());
    }

    default public void drillDimensionAccount(Object param) {
        this.drillDimemsion(SysDimensionEnum.Account.getNumber());
    }

    default public void drillDimensionUserDefined0(Object param) {
        this.drillUserDefinded(this.getView().getPageCache().get("drillDimensionUserDefined0"));
    }

    default public void drillDimensionUserDefined1(Object param) {
        this.drillUserDefinded(this.getView().getPageCache().get("drillDimensionUserDefined1"));
    }

    default public void drillDimensionUserDefined2(Object param) {
        this.drillUserDefinded(this.getView().getPageCache().get("drillDimensionUserDefined2"));
    }

    default public void drillDimensionUserDefined3(Object param) {
        this.drillUserDefinded(this.getView().getPageCache().get("drillDimensionUserDefined3"));
    }

    default public void drillDimensionUserDefined4(Object param) {
        this.drillUserDefinded(this.getView().getPageCache().get("drillDimensionUserDefined4"));
    }

    default public void drillDimensionUserDefined5(Object param) {
        this.drillUserDefinded(this.getView().getPageCache().get("drillDimensionUserDefined5"));
    }

    default public void drillDimensionUserDefined6(Object param) {
        this.drillUserDefinded(this.getView().getPageCache().get("drillDimensionUserDefined6"));
    }

    default public void drillDimensionUserDefined7(Object param) {
        this.drillUserDefinded(this.getView().getPageCache().get("drillDimensionUserDefined7"));
    }

    default public void drillDimensionUserDefined8(Object param) {
        this.drillUserDefinded(this.getView().getPageCache().get("drillDimensionUserDefined8"));
    }

    default public void drillDimensionUserDefined9(Object param) {
        this.drillUserDefinded(this.getView().getPageCache().get("drillDimensionUserDefined9"));
    }

    default public void groupNodeChange(Object param) {
        Map cellMap;
        if (param instanceof Map && (cellMap = (Map)((Map)param).get("cell")) != null) {
            int r = (Integer)cellMap.get("r");
            int c = (Integer)cellMap.get("c");
            int groupNodeType = (Integer)cellMap.get("groupNodeType");
            boolean isRow = c == 0;
            try {
                DiffAnalyzeScheme scheme = this.refreshMetas(this.getSchemeConfig());
                if (!this.canRefreshCellData(scheme)) {
                    return;
                }
                IDiffAnalyzeSpreadManager spreadManager = this.getSpreadManager();
                spreadManager.getDimemsionViews().putAll(this.getDimensionViews());
                this.getSpreadManager().setDiffAnalyzeScheme(scheme);
                if (isRow) {
                    if (groupNodeType == 1) {
                        new ExpandRowChildCommand(r, RangeEnum.DIRECTSUB_EXCLUDE.getIndex(), this.getSpreadManager(), scheme).execute(this);
                    } else if (groupNodeType == 2) {
                        new CollapseRowChildCommand(r, this.getSpreadManager(), this.getspreadContainer()).execute(this);
                    }
                } else if (groupNodeType == 1) {
                    new ExpandColChildCommand(c, RangeEnum.DIRECTSUB_EXCLUDE.getIndex(), this.getSpreadManager(), scheme).execute(this);
                } else if (groupNodeType == 2) {
                    new CollapseColChildCommand(c, this.getSpreadManager(), this.getspreadContainer(), this.getSchemeConfig()).execute(this);
                }
            }
            catch (KDBizException e) {
                log.error((Throwable)e);
                this.getView().showErrorNotification(e.getMessage());
            }
        }
    }

    default public void drillUserDefinded(String subMenuKey) {
        if (subMenuKey != null) {
            String dimNumber = subMenuKey.replaceFirst("drillDimension", "");
            this.drillDimemsion(dimNumber);
        }
    }

    default public void drillDimemsion(String dimNumber) {
        int row;
        DiffCellDimMember cellDimMember;
        SpreadSelector selector = this.getSpreadSelector();
        if (selector != null && dimNumber != null && (cellDimMember = this.getCellDimMember(row = selector.getStartRow(), 0)) != null) {
            DiffAnalyzeScheme scheme;
            String memNumber = null;
            if (dimNumber.equals(cellDimMember.getDimNumber())) {
                memNumber = cellDimMember.getMemNumber();
            }
            if (memNumber == null) {
                while (cellDimMember.getUpperDimParent() != null) {
                    if (!dimNumber.equals((cellDimMember = cellDimMember.getUpperDimParent()).getDimNumber())) continue;
                    memNumber = cellDimMember.getMemNumber();
                    break;
                }
            }
            if (memNumber == null) {
                DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getValue(this.getF7KeyDimMap().get(dimNumber));
                memNumber = dynamicObject.getString("number");
            }
            if (!this.canRefreshCellData(scheme = this.refreshMetas(this.getSchemeConfig()))) {
                return;
            }
            IDiffAnalyzeSpreadManager spreadManager = this.getSpreadManager();
            spreadManager.setDiffAnalyzeScheme(scheme);
            this.collapseChild(null);
            try {
                Map<String, Long> dimensionViews = this.getDimensionViews();
                spreadManager.getDimemsionViews().putAll(dimensionViews);
                new DrillRowDimCommand(row, dimNumber, memNumber, RangeEnum.DIRECTSUB_EXCLUDE.getIndex(), spreadManager, scheme).execute(this);
            }
            catch (KDBizException e) {
                log.error((Throwable)e);
                this.getView().showErrorNotification(e.getMessage());
            }
        }
    }

    default public void expandChild(Object param) {
        DiffCellDimMember cellDimMember;
        SpreadSelector selector = this.getSpreadSelector();
        if (this.isClickRowDimCell(selector) && (cellDimMember = this.getCellDimMember(selector.getStartRow(), selector.getStartCol())) != null && !cellDimMember.isIsleaf()) {
            try {
                DiffAnalyzeScheme scheme = this.refreshMetas(this.getSchemeConfig());
                if (!this.canRefreshCellData(scheme)) {
                    return;
                }
                new ExpandRowChildCommand(selector.getStartRow(), RangeEnum.DIRECTSUB_EXCLUDE.getIndex(), this.getSpreadManager(), scheme).execute(this);
            }
            catch (KDBizException e) {
                log.error((Throwable)e);
                this.getView().showErrorNotification(e.getMessage());
            }
        }
    }

    default public void collapseChild(Object param) {
        SpreadSelector selector = this.getSpreadSelector();
        if (selector != null && this.isClickRowDimCell(selector)) {
            try {
                new CollapseRowChildCommand(selector.getStartRow(), this.getSpreadManager(), this.getspreadContainer()).execute(this);
            }
            catch (KDBizException e) {
                log.error((Throwable)e);
                this.getView().showErrorNotification(e.getMessage());
            }
        }
    }

    default public DiffCellDimMember getCellDimMember(int row, int col) {
        IDiffAnalyzeSpreadManager spreadManager = this.getSpreadManager();
        if (col == 0) {
            if (spreadManager.getRowCellDimMembers() != null && row < spreadManager.getRowCellDimMembers().size()) {
                return (DiffCellDimMember)spreadManager.getRowCellDimMembers().get(row);
            }
        } else if (row == 0 && spreadManager.getColCellDimMembers() != null && col < spreadManager.getColCellDimMembers().size()) {
            return (DiffCellDimMember)spreadManager.getColCellDimMembers().get(col);
        }
        return null;
    }

    default public void setContextMenus() {
        SpreadContainer spreadContainer = this.getspreadContainer();
        spreadContainer.addContextMenuItems(this.getDrillDimensionMenuItem(true), ResManager.loadKDString((String)"\u94bb\u53d6\u7ef4\u5ea6", (String)"DiffAnalyzePlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]), this.getDrillDimensionSubMenuItems(), new ContextMenuWorkArea().setViewport(true));
        spreadContainer.addContextMenuItems("drillDown", ResManager.loadKDString((String)"\u94bb\u53d6\u4e0b\u7ea7", (String)"DiffAnalyzePlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]), new ContextMenuWorkArea().setViewport(true));
        spreadContainer.hideContextMenuItems((List)Lists.newArrayList((Object[])new ContextMenuItemsEnum[]{ContextMenuItemsEnum.INSERTROWMANY, ContextMenuItemsEnum.INSERTCOLUMNMANY, ContextMenuItemsEnum.INSERTROWS, ContextMenuItemsEnum.HIDEROWS, ContextMenuItemsEnum.UNHIDEROWS, ContextMenuItemsEnum.INSERTCOLUMNS, ContextMenuItemsEnum.DELETEROWS, ContextMenuItemsEnum.DELETECOLUMNS, ContextMenuItemsEnum.CLEARCONTENTS, ContextMenuItemsEnum.CUT, ContextMenuItemsEnum.COPY, ContextMenuItemsEnum.PASTE, ContextMenuItemsEnum.PASTEOPTIONS, ContextMenuItemsEnum.PASTEALL, ContextMenuItemsEnum.PASTEFORMULA, ContextMenuItemsEnum.PASTEVALUES, ContextMenuItemsEnum.PASTEFORMATTING, ContextMenuItemsEnum.PASTEVALUESFORMATTING, ContextMenuItemsEnum.PASTEFORMULAFORMATTING, ContextMenuItemsEnum.SORT, ContextMenuItemsEnum.INSERTCOMMENT, ContextMenuItemsEnum.RICHTEXT, ContextMenuItemsEnum.INSERTCOPIEDCELLS, ContextMenuItemsEnum.INSERTCUTCELLS, ContextMenuItemsEnum.CELLSFORMAT, ContextMenuItemsEnum.DELETEROWORCOLUMNS, ContextMenuItemsEnum.SLICERSORTASCEND, ContextMenuItemsEnum.SLICERSORTDESCEND, ContextMenuItemsEnum.INSERTROWORCOLUMNS}), (List)Lists.newArrayList());
        this.getspreadContainer().lockToolbarItems((List)Lists.newArrayList((Object[])new ToolBarItemsEnum[]{ToolBarItemsEnum.SWITCHVIEW, ToolBarItemsEnum.LOCKCELLS, ToolBarItemsEnum.SETTING, ToolBarItemsEnum.UPLOADFILE, ToolBarItemsEnum.INSERTROWANDCOL}), new ArrayList());
    }

    default public List<Map<String, Object>> getDrillDimensionSubMenuItems() {
        LinkedList<Map<String, Object>> subMenus = new LinkedList<Map<String, Object>>();
        int userDimIndex = 0;
        for (Dimension dimension : this.getAllDimension()) {
            if (!SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber()) && !SysDimensionEnum.AuditTrail.getNumber().equals(dimension.getNumber()) && !SysDimensionEnum.ChangeType.getNumber().equals(dimension.getNumber()) && !SysDimensionEnum.Account.getNumber().equals(dimension.getNumber()) && dimension.isPreset()) continue;
            HashMap<String, String> drillDimension = new HashMap<String, String>();
            if (dimension.isPreset()) {
                drillDimension.put("name", "drillDimension" + dimension.getNumber());
            } else {
                drillDimension.put("name", "drillDimensionUserDefined" + userDimIndex);
                this.getView().getPageCache().put("drillDimensionUserDefined" + userDimIndex, "drillDimension" + dimension.getNumber());
                this.getView().getPageCache().put("drillDimension" + dimension.getNumber(), "drillDimensionUserDefined" + userDimIndex);
                ++userDimIndex;
            }
            drillDimension.put("text", dimension.getName());
            subMenus.add(drillDimension);
        }
        return subMenus;
    }

    default public String getDrillDimensionMenuItem(boolean reCreate) {
        String drillDimensionMenuItem = this.getView().getPageCache().get("DrillDimensionMenuItem");
        if (drillDimensionMenuItem == null) {
            drillDimensionMenuItem = "drillDimension";
        }
        if (reCreate) {
            this.getspreadContainer().deleteContextMenuItems(new String[]{drillDimensionMenuItem});
            drillDimensionMenuItem = "drillDimension" + System.currentTimeMillis();
            this.getView().getPageCache().put("DrillDimensionMenuItem", drillDimensionMenuItem);
        }
        return drillDimensionMenuItem;
    }

    default public List<Dimension> getDrillDimensionList() {
        return this.getAllDimension().stream().filter(e -> SysDimensionEnum.Entity.getNumber().equals(e.getNumber()) || SysDimensionEnum.AuditTrail.getNumber().equals(e.getNumber()) || SysDimensionEnum.ChangeType.getNumber().equals(e.getNumber()) || SysDimensionEnum.Account.getNumber().equals(e.getNumber()) || !e.isPreset()).collect(Collectors.toList());
    }

    default public void handleCellClick(SpreadSelector selector) {
        if (selector != null) {
            SpreadContainer spreadContainer = this.getspreadContainer();
            ArrayList<MenuItem> hideItems = new ArrayList<MenuItem>(16);
            ArrayList<MenuItem> showItems = new ArrayList<MenuItem>(16);
            String menuName_drillDim = this.getDrillDimensionMenuItem(true);
            boolean display_drillDim = false;
            if (this.isClickRowDimCell(selector)) {
                this.addToMenuItems(hideItems, "drillDown", null);
                this.addToMenuItems(hideItems, "drillUp", null);
                Map<String, String> f7KeyDimMap = this.getF7KeyDimMap();
                Set<String> schemeDims = this.getSchemeDims();
                String f7Key = null;
                String childDim = null;
                DiffCellDimMember cellDimMember = this.getCellDimMember(selector.getStartRow(), selector.getStartCol());
                DiffCellDimMember nextCellDimMember = this.getCellDimMember(selector.getStartRow() + 1, selector.getStartCol());
                if (nextCellDimMember != null && nextCellDimMember.getParent() != null && nextCellDimMember.getParent().getDimNumber().equals(cellDimMember.getDimNumber()) && nextCellDimMember.getParent().getMemNumber().equals(cellDimMember.getMemNumber())) {
                    childDim = nextCellDimMember.getDimNumber();
                }
                if (cellDimMember != null) {
                    HashMap<String, DiffCellDimMember> rowCellDimMap = new HashMap<String, DiffCellDimMember>();
                    String dimNumber = cellDimMember.getDimNumber();
                    rowCellDimMap.put(cellDimMember.getDimNumber(), cellDimMember);
                    while (cellDimMember.getUpperDimParent() != null) {
                        cellDimMember = cellDimMember.getUpperDimParent();
                        rowCellDimMap.putIfAbsent(cellDimMember.getDimNumber(), cellDimMember);
                    }
                    String currentColDim = null;
                    IDiffAnalyzeSpreadManager spreadManager = this.getSpreadManager();
                    if (spreadManager != null && spreadManager.getColDimension() != null) {
                        currentColDim = spreadManager.getColDimension().getNumber();
                    }
                    for (Dimension dimension : this.getDrillDimensionList()) {
                        if (currentColDim != null && currentColDim.equals(dimension.getNumber())) {
                            this.addToMenuItems(hideItems, menuName_drillDim, this.getDrillDimensionSubMenuItem(dimension));
                            continue;
                        }
                        if (childDim != null && childDim.equals(dimension.getNumber())) {
                            this.addToMenuItems(hideItems, menuName_drillDim, this.getDrillDimensionSubMenuItem(dimension));
                            continue;
                        }
                        if (rowCellDimMap.containsKey(dimension.getNumber())) {
                            if (((DiffCellDimMember)rowCellDimMap.get(dimension.getNumber())).isIsleaf()) {
                                this.addToMenuItems(hideItems, menuName_drillDim, this.getDrillDimensionSubMenuItem(dimension));
                                continue;
                            }
                            this.addToMenuItems(showItems, menuName_drillDim, this.getDrillDimensionSubMenuItem(dimension));
                            display_drillDim = true;
                            continue;
                        }
                        f7Key = f7KeyDimMap.get(dimension.getNumber());
                        if (schemeDims == null || !schemeDims.contains(dimension.getNumber())) {
                            DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getValue(f7Key);
                            Member member = null;
                            if (dynamicObject != null) {
                                member = this.getModelCacheHelper().getMember(dimension.getNumber(), (Long)this.getSpreadManager().getDimemsionViews().get(dimension.getNumber()), dynamicObject.getString("number"));
                            }
                            if (dimension.getNumber().equals(dimNumber) || member == null || member != null && member.isLeaf()) {
                                this.addToMenuItems(hideItems, menuName_drillDim, this.getDrillDimensionSubMenuItem(dimension));
                                continue;
                            }
                            this.addToMenuItems(showItems, menuName_drillDim, this.getDrillDimensionSubMenuItem(dimension));
                            display_drillDim = true;
                            continue;
                        }
                        this.addToMenuItems(hideItems, menuName_drillDim, this.getDrillDimensionSubMenuItem(dimension));
                    }
                }
            } else {
                this.addToMenuItems(hideItems, "drillDown", null);
                this.addToMenuItems(hideItems, "drillUp", null);
                this.addToMenuItems(hideItems, menuName_drillDim, null);
                this.displayDimInfoOnStatusBar(selector);
            }
            if (hideItems.size() > 0 || showItems.size() > 0) {
                if (display_drillDim) {
                    spreadContainer.addContextMenuItems(menuName_drillDim, ResManager.loadKDString((String)"\u94bb\u53d6\u7ef4\u5ea6", (String)"DiffAnalyzePlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]), this.getDrillDimensionSubMenuItems(), new ContextMenuWorkArea().setViewport(true));
                }
                spreadContainer.hideShowContextMenuItems(hideItems, showItems);
            }
        }
    }

    default public Set<String> getVisibleF7Keys() {
        String key = this.getView().getPageCache().get("VISIBLE_F7KEYS");
        if (StringUtils.isNotEmpty((String)key)) {
            return (Set)SerializationUtils.fromJsonString((String)key, Set.class);
        }
        return Collections.EMPTY_SET;
    }

    default public String getDrillDimensionSubMenuItem(Dimension dimension) {
        if (dimension != null) {
            if (dimension.isPreset()) {
                return "drillDimension" + dimension.getNumber();
            }
            return this.getView().getPageCache().get("drillDimension" + dimension.getNumber());
        }
        return null;
    }

    default public void addToMenuItems(List<MenuItem> menuItems, String menuName, String subMenuName) {
        if (menuItems != null && menuName != null) {
            MenuItem _menuItem = null;
            for (MenuItem m : menuItems) {
                if (!menuName.equals(m.getName())) continue;
                _menuItem = m;
                break;
            }
            if (_menuItem == null) {
                _menuItem = new MenuItem(menuName);
                menuItems.add(_menuItem);
            }
            if (_menuItem != null && subMenuName != null) {
                _menuItem.addSubMenuItem(new MenuItem(subMenuName));
            }
        }
    }
}

