/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analyze;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.MapType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.EntryGridOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.event.ISpreadAction;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.executeanalyse.ExecuteAnalyseUtil;
import kd.epm.eb.business.executeanalyse.ReportShareHelper;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.userremember.entity.UserRememberEntity;
import kd.epm.eb.business.userremember.service.UserRememberService;
import kd.epm.eb.business.userselect.UserSelectUtils;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.threadlocal.EpmThreadLocalUtils;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.ebcommon.common.MessageConstant;
import kd.epm.eb.common.ebcommon.common.enums.MemberDisplayTypeEnum;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.permission.IMemberPermCache;
import kd.epm.eb.common.permission.MemberPermCacheServiceHelper;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.spread.util.GZIPUtils;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.EntityUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebSpread.domain.view.SpreadSelector;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.adminmode.utils.AdminModelUtil;
import kd.epm.eb.formplugin.analyze.DiffAnalyzeHelper;
import kd.epm.eb.formplugin.analyze.DiffAnalyzeMenuActions;
import kd.epm.eb.formplugin.analyze.DiffAnalyzePluginConstant;
import kd.epm.eb.formplugin.analyze.IDiffAnalyzePlugin;
import kd.epm.eb.formplugin.analyze.command.CollapseColChildCommand;
import kd.epm.eb.formplugin.analyze.command.CollapseRowChildCommand;
import kd.epm.eb.formplugin.analyze.command.DataUnitChangeCommand;
import kd.epm.eb.formplugin.analyze.command.ExpandColChildCommand;
import kd.epm.eb.formplugin.analyze.command.ExpandRowChildCommand;
import kd.epm.eb.formplugin.analyze.command.HideShowEmptyRowsCommand;
import kd.epm.eb.formplugin.analyze.command.RefreshCellDataCommand;
import kd.epm.eb.formplugin.analyze.command.RefreshMemberDisplayCommand;
import kd.epm.eb.formplugin.analyze.command.ShowFormCommand;
import kd.epm.eb.formplugin.analyze.command.SwitchColDimensionCommand;
import kd.epm.eb.formplugin.executeanalyse.ExecuteAnalyseSchemeListPlugin;
import kd.epm.eb.formplugin.report.query.ReportQueryHelper;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.model.serviceHelper.DataSetServiceHelper;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;
import kd.epm.eb.olap.api.metadata.IDataRow;
import kd.epm.eb.olap.enums.DataRowEnum;
import kd.epm.eb.spread.adaptor.OlapQuerySync;
import kd.epm.eb.spread.adaptor.SpreadJsAction;
import kd.epm.eb.spread.analyze.DiffAnalyzeScheme;
import kd.epm.eb.spread.command.event.SpreadActionListener;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.rangedefined.SheetFrozenInfo;
import kd.epm.eb.spread.command.rangedefined.Shortcut;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.command.style.CellStyleInfo;
import kd.epm.eb.spread.command.stylecontroller.DiffAnalyzeStyleController;
import kd.epm.eb.spread.control.SpreadContainer;
import kd.epm.eb.spread.listener.ISpreadBaseSupport;
import kd.epm.eb.spread.template.spreadmanager.DiffAnalyzeSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.DiffCellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IDiffAnalyzeSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.serializer.DiffAnalyzeSpreadManagerSerializerUtil;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.utils.ReportHelper;

public class DiffAnalyzePlugin
extends AbstractFormPlugin
implements ISpreadBaseSupport,
SpreadActionListener,
ClickListener,
BeforeF7SelectListener,
AfterF7SelectListener,
IDiffAnalyzePlugin,
DiffAnalyzeMenuActions,
DiffAnalyzePluginConstant,
CellClickListener,
RowClickEventListener {
    private static final Log log = LogFactory.getLog(DiffAnalyzePlugin.class);
    private static final String[] F7_KEYS_PAGE = new String[]{"ebf7_entity_p", "ebf7_account_p", "ebf7_metric_p", "ebf7_budgetperiod_p", "ebf7_changetype_p", "ebf7_internalcompany_p", "ebf7_currency_p", "ebf7_audittrail_p", "ebf7_version_p", "ebf7_datatype_p", "ebf7_customize1_p", "ebf7_customize2_p", "ebf7_customize3_p", "ebf7_customize4_p", "ebf7_customize5_p", "ebf7_customize6_p", "ebf7_customize7_p", "ebf7_customize8_p", "ebf7_customize9_p"};
    private static final String[] F7_KEYS_PAGE1 = new String[]{"ebf7_entity_p1", "ebf7_account_p1", "ebf7_metric_p1", "ebf7_budgetperiod_p1", "ebf7_changetype_p1", "ebf7_internalcompany_p1", "ebf7_currency_p1", "ebf7_audittrail_p1", "ebf7_version_p1", "ebf7_datatype_p1", "ebf7_customize1_p1", "ebf7_customize2_p1", "ebf7_customize3_p1", "ebf7_customize4_p1", "ebf7_customize5_p1", "ebf7_customize6_p1", "ebf7_customize7_p1", "ebf7_customize8_p1", "ebf7_customize9_p1"};
    private static final String[] F7_KEYS_CARD = new String[]{"col_entity", "col_budgetperiod", "col_audittrail", "col_account", "col_version", "col_currency", "col_datatype", "col_internalcompany", "col_metric", "col_changetype", "col_customize1", "col_customize2", "col_customize3", "col_customize4", "col_customize5", "col_customize6", "col_customize7", "col_customize8", "col_customize9"};
    public static String[] F7_KEYS_DIMPOOL = new String[]{"ebf7_page_entity", "ebf7_page_budgetperiod", "ebf7_page_audittrail", "ebf7_page_account", "ebf7_page_version", "ebf7_page_currency", "ebf7_page_datatype", "ebf7_page_internalcompany", "ebf7_page_metric", "ebf7_page_changetype", "ebf7_page_customize1", "ebf7_page_customize2", "ebf7_page_customize3", "ebf7_page_customize4", "ebf7_page_customize5", "ebf7_page_customize6", "ebf7_page_customize7", "ebf7_page_customize8", "ebf7_page_customize9"};
    private static final String[] MULTI_SELECT_KEYS = new String[]{"ebf7_entity_mul", "ebf7_account_mul", "ebf7_metric_mul", "ebf7_budgetperiod_mul", "ebf7_changetype_mul", "ebf7_internalcompany_mul", "ebf7_currency_mul", "ebf7_audittrail_mul", "ebf7_version_mul", "ebf7_datatype_mul", "ebf7_customize1_mul", "ebf7_customize2_mul", "ebf7_customize3_mul", "ebf7_customize4_mul", "ebf7_customize5_mul", "ebf7_customize6_mul", "ebf7_customize7_mul", "ebf7_customize8_mul", "ebf7_customize9_mul"};
    private static final String[] DIM_KEYS = new String[]{"entity", "account", "metric", "budgetperiod", "changetype", "internalcompany", "currency", "audittrail", "version", "datatype", "customize1", "customize2", "customize3", "customize4", "customize5", "customize6", "customize7", "customize8", "customize9"};
    private static final String LABEL_ROWDIMENSION = "label_rowdimension";
    private static final String SHOWEMPTYROW = "1";
    private static final String HIDEEMPTYROW = "2";
    private SpreadContainer spreadContainer = null;
    private SpreadSelector spreadSelector = null;
    private IDiffAnalyzeSpreadManager spreadManager = null;
    private Map<String, String> dimNamesMap = null;
    private Map<String, String> dimCtrlKeyMap = null;
    private Map<String, String> f7KeyDimMap = null;
    private Map<String, String> f7KeyDimMap2 = null;
    private Map<String, String> f7KeyDimMapMul = null;
    private Map<String, String> f7KeyDimMapPage = null;
    private List<Dimension> allDims = null;
    private Map<String, Long> dimemsionViews = null;
    private Map<String, Long> entryDimemsionViews = null;
    private Map<String, String> colIndexNameMap = null;
    private Map<String, String> colNameIndexMap = null;
    private Map<String, Object> configMap = null;
    private boolean isAdminMode = false;
    private DiffAnalyzeScheme scheme = null;
    private static final String SELECTROW_CAHCE = "selectRow";
    private IMemberPermCache memberPerm;
    private IModelCacheHelper modelCacheHelper = null;
    private Long datasetID = null;
    private Map<String, Long> defaultDimMember = null;
    private Map<String, String> cacheF7Select = null;
    private String defMemberDisplay = null;
    private String defEmptyrowDisplay = null;
    private String defUnitDisplay = null;
    private Set<String> hideDimensions = null;

    public static String[] getF7KeysCard() {
        return F7_KEYS_CARD;
    }

    public void initialize() {
        super.initialize();
        this.initService();
    }

    public void initService() {
        this.getView().addService(ISpreadAction.class, (Object)new SpreadJsAction((kd.bos.form.plugin.AbstractFormPlugin)this, this.getSpreadKey()));
    }

    @Override
    public void groupNodeChange(Object param) {
        if (this.isAdminMode) {
            return;
        }
        DiffAnalyzeMenuActions.super.groupNodeChange(param);
        this.hideDisableMemberEmptyRowCols();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.handleFormShowParam();
        Long modelId = IDUtils.toLong((Object)this.getCache("KEY_MODEL_ID"));
        if (IDUtils.isNull((Long)modelId)) {
            modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"model", (boolean)false);
        }
        if (IDUtils.isNull((Long)modelId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"maincontentpanel"});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DiffAnalyzePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setControlVisible(this.isEditSchemeMode());
        this.getModel().setValue("model", (Object)modelId);
        this.setCache("KEY_MODEL_ID", modelId.toString());
        this.initDimensionViewsFromDataSet();
        this.initDimensionViewsFromSchemeConfig();
        this.refreshPageViewPanel(true);
        this.refreshSpread();
        this.setUserDefinedRowColSize();
        this.getView().updateView();
        if (this.isFormEnjoy()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"dataset", "model"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"model"});
        }
        ReportHelper.setLongNameNumDisVisible((Long)this.getModelId(), (IFormView)this.getView());
    }

    private void initDimensionViewsFromSchemeConfig() {
        Long viewId = 0L;
        Map<String, Object> config = this.getConfigMap();
        if (config != null && this.getSpreadManager() != null) {
            boolean updatedViewId = false;
            Map viewGroupViewsByDataSet = this.getModelCacheHelper().getViewGroupViewsByDataSet(Long.valueOf(this.getDatasetId()));
            for (Map.Entry<String, Object> entry : config.entrySet()) {
                if (!entry.getKey().endsWith("viewId")) continue;
                String dimNumber = entry.getKey().replaceAll("viewId", "");
                viewId = IDUtils.toLong((Object)entry.getValue());
                List viewIds = (List)viewGroupViewsByDataSet.get(dimNumber);
                if (CollectionUtils.isNotEmpty((Collection)viewIds) && !viewIds.contains(viewId)) {
                    viewId = this.getModelCacheHelper().getViewGroupByDataSetAndDimNumber(Long.valueOf(this.getDatasetId()), dimNumber);
                }
                if (!IDUtils.isNotEmptyLong((Long)viewId).booleanValue()) continue;
                this.cacheDimensionViews(dimNumber, viewId);
                updatedViewId = true;
            }
            if (updatedViewId) {
                this.cacheSpreadManager();
            }
        }
    }

    public void hideDisableMemberEmptyRowCols() {
        this.spreadManager = this.getSpreadManager();
        ISheet sheet = this.spreadManager.getEbook().getSheet(0);
        if (sheet != null) {
            List table = sheet.getTable();
            List rowCellDimMembers = this.spreadManager.getRowCellDimMembers();
            int rStart = sheet.getValueAreaRowStart();
            int rEnd = sheet.getRealMaxRows();
            int cStart = sheet.getValueAreaColStart();
            int cEnd = sheet.getRealMaxCols();
            HashSet<Integer> rows = new HashSet<Integer>(16);
            HashSet<Integer> notDisableRows = new HashSet<Integer>(16);
            block0: for (int i = rStart; i < rEnd; ++i) {
                rows.add(i);
                DiffCellDimMember diffCellDimMember = (DiffCellDimMember)rowCellDimMembers.get(i);
                if (diffCellDimMember == null) continue;
                Long viewId = this.getDimensionViews().getOrDefault(diffCellDimMember.getDimNumber(), 0L);
                Member member = this.getModelCacheHelper().getMember(diffCellDimMember.getDimNumber(), viewId, diffCellDimMember.getMemNumber());
                if (member.isDisable()) {
                    for (int j = cStart; j < cEnd; ++j) {
                        List cells = (List)table.get(i);
                        if (cells == null || cells.get(j) == null || ((ECell)cells.get(j)).getValue() == null) continue;
                        notDisableRows.add(i);
                        continue block0;
                    }
                    continue;
                }
                notDisableRows.add(i);
            }
            rows.removeAll(notDisableRows);
            this.getspreadContainer().setRowsVisible((List)Lists.newArrayList(rows), false);
        }
    }

    protected void handleFormShowParam() {
        String dimemsionViews_str;
        String defaultDimMember_str;
        String schemeId;
        String datasetId;
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (kd.bos.util.StringUtils.isNotEmpty((String)modelId)) {
            this.setCache("KEY_MODEL_ID", modelId);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)(datasetId = (String)this.getView().getFormShowParameter().getCustomParam("eb_dataset")))) {
            this.getModel().setValue("dataset", (Object)Long.valueOf(datasetId));
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)(schemeId = (String)this.getView().getFormShowParameter().getCustomParam("eb_diffanalyzescheme")))) {
            this.getModel().setValue("analyzescheme", (Object)Long.valueOf(schemeId));
        }
        if ((defaultDimMember_str = (String)this.getFormShowParameter("defaultDimMember")) != null) {
            this.defaultDimMember = (Map)SerializationUtils.fromJsonString((String)defaultDimMember_str, Map.class);
        }
        if ((dimemsionViews_str = (String)this.getFormShowParameter("dimemsionViews")) != null) {
            MapType javaType = JSONUtils.getMapper().getTypeFactory().constructMapType(Map.class, String.class, Long.class);
            this.dimemsionViews = (Map)JSONUtils.parse((String)dimemsionViews_str, (JavaType)javaType);
        }
    }

    @Override
    public boolean isEditSchemeMode() {
        return "true".equals(this.getCache("IS_EDIT_SCHEME_MODE"));
    }

    protected void setControlDraggable() {
        this.getControl("colconfigpanel").setDroppable(true);
        this.getControl("dimpoolpanel").setDroppable(true);
        this.getControl("rowdimpanel").setDroppable(true);
        ((Container)this.getControl("dimpoolpanel")).getItems().forEach(item -> item.setDraggable(true));
        for (String key : F7_KEYS_CARD) {
            this.getControl(key).setDraggable(true);
        }
        this.getControl("account_range").setDraggable(false);
    }

    private void cacheSchemeDims(Set<String> schemeDims) {
        if (schemeDims != null) {
            this.setCache("schemeDims", SerializationUtils.toJsonString(schemeDims));
        } else {
            this.setCache("schemeDims", null);
        }
    }

    @Override
    public Set<String> getSchemeDims() {
        String str = this.getCache("schemeDims");
        if (str != null) {
            return (Set)SerializationUtils.fromJsonString((String)str, Set.class);
        }
        this.scheme = this.getSchemeConfig();
        HashSet<String> schemeDims = new HashSet<String>(16);
        if (this.scheme != null) {
            for (DiffAnalyzeScheme.DiffAnalyzeColumn diffAnalyzeColumn : this.scheme.getAnalyzeColumns()) {
                for (Map.Entry entry : diffAnalyzeColumn.getDataRow().getMetas().entrySet()) {
                    if (!"_SECOND_PAGE".equals(entry.getValue()) && (entry.getValue() == null || ((String)entry.getKey()).startsWith("_DIMVIEW_"))) continue;
                    schemeDims.add((String)entry.getKey());
                }
            }
            this.setCache("schemeDims", SerializationUtils.toJsonString(schemeDims));
        }
        return schemeDims;
    }

    protected void setControlVisible(boolean isEditSchemeMode) {
        this.getView().setVisible(Boolean.valueOf(isEditSchemeMode), new String[]{"colconfigpanel", "dimpoolpanel", "btn_savescheme", "btn_saveschemeas", "btn_canceleditscheme"});
        this.getView().setVisible(Boolean.valueOf(!isEditSchemeMode), new String[]{"dimspanel", "entryentity1panel", "btn_editscheme", "btn_refresh", "model", "analyzescheme", "hideshowiconpanel"});
        if (!isEditSchemeMode) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"icon_showpagedim"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"icon_hidepagedim"});
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain", "floatmenuap"});
        PluginUtils.registerF7Listener(new String[]{"model", "dataset", "analyzescheme"}, true, false, this);
        PluginUtils.registerF7Listener(F7_KEYS_PAGE, true, true, this);
        PluginUtils.registerF7Listener(F7_KEYS_PAGE1, true, true, this);
        PluginUtils.registerF7Listener(F7_KEYS_CARD, true, true, this);
        this.addClickListeners(MULTI_SELECT_KEYS);
        this.addClickListeners(F7_KEYS_DIMPOOL);
        this.addClickListeners(new String[]{"btn_ok", "btn_cancel", "editcol", "account_range", "moveup", "movedown", "icon_hidepagedim", "icon_showpagedim"});
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity1");
        cardEntry.addCellClickListener((CellClickListener)this);
        cardEntry.addRowClickListener((RowClickEventListener)this);
        this.getspreadContainer().setShortcutKey(new Shortcut("pageCacheQuery", "P", true, true, true, false));
    }

    private void addOrRemoveSchemeDims(String dimKey, boolean isAdd) {
        if (dimKey == null) {
            return;
        }
        this.getView().setVisible(Boolean.valueOf(!isAdd), new String[]{"ebf7_page_" + dimKey});
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
        this.modelCacheHelper = this.getModelCacheHelper();
        if (dynamicObjects != null) {
            String dimNumber = this.getDimCtrlKeyMap().get(dimKey);
            Map<String, String> dimNamesMap = this.getDimNamesMap();
            String dimName = dimNamesMap.get(dimNumber);
            int size = dynamicObjects.size();
            for (int i = 0; i < size; ++i) {
                if (((DynamicObject)dynamicObjects.get(i)).getInt("col_type") != 0) continue;
                cardEntry.setChildVisible(isAdd, i, new String[]{"col_" + dimKey});
                this.getModel().setValue("col_" + dimKey, null, i);
                dimKey = this.dimCtrlKeyMap.get(dimNumber);
                HashMap<String, Serializable> prop = new HashMap<String, Serializable>(4);
                HashMap<String, LocaleString> itemprop = new HashMap<String, LocaleString>(1);
                itemprop.put("emptytip", new LocaleString(dimName));
                prop.put("item", itemprop);
                prop.put("draggable", Boolean.valueOf(true));
                if (dimKey.startsWith("customize")) {
                    prop.put("caption", (Serializable)new LocaleString(this.getDimNamesMap().get(dimNumber)));
                }
                this.getView().updateControlMetadata("ebf7_" + dimKey + "_p", prop);
                this.getView().updateControlMetadata("ebf7_" + dimKey + "_mul", prop);
                this.getView().updateControlMetadata("ebf7_" + dimKey + "_p1", prop);
                this.getView().updateControlMetadata("col_" + dimKey, prop);
            }
            Set<String> schemeDims = this.getSchemeDims();
            if (schemeDims == null) {
                return;
            }
            if (isAdd) {
                schemeDims.add(dimNumber);
            } else {
                schemeDims.remove(dimNumber);
            }
            this.cacheSchemeDims(schemeDims);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (!"btn_exit".equals(key)) {
            this.verify();
            if (this.check()) {
                return;
            }
        }
        switch (key) {
            case "btn_refresh": {
                this.clickBtnOK();
                break;
            }
            case "btn_bybudgetperiod": 
            case "btn_byentity": 
            case "btn_byaudittrail": 
            case "btn_byversion": 
            case "btn_bycurrency": 
            case "btn_bydatatype": 
            case "btn_byinternalcompany": 
            case "btn_bychangetype": 
            case "btn_bymetric": 
            case "btn_byaccount": 
            case "btn_bycustomize1": 
            case "btn_bycustomize2": 
            case "btn_bycustomize3": 
            case "btn_bycustomize4": 
            case "btn_bycustomize5": 
            case "btn_bycustomize6": 
            case "btn_bycustomize7": 
            case "btn_bycustomize8": 
            case "btn_bycustomize9": {
                if (!this.canRefreshCellData(this.refreshMetas(this.getSchemeConfig()))) break;
                this.switchColDimension(key);
                if (!this.isEditSchemeMode()) break;
                String dimNumber = this.getDimCtrlKeyMap().get(key.replaceAll("btn_by", ""));
                this.setCache("def_col_dimension", dimNumber);
                break;
            }
            case "btn_savescheme": 
            case "btn_saveschemeas": {
                if (key.equals("btn_savescheme")) {
                    this.checkPermission("eb_diffanalysis", "btn_editscheme");
                } else if (key.equals("btn_saveschemeas")) {
                    this.checkPermission("eb_executeanalyselist", "btn_addnew");
                }
                new ShowFormCommand(key).execute(this);
                break;
            }
            case "btn_editscheme": {
                this.onOffEditSchemeMode(true);
                break;
            }
            case "btn_canceleditscheme": {
                this.onOffEditSchemeMode(false);
                break;
            }
            case "btn_setaccountroot": {
                int row;
                DiffCellDimMember cellDimMember;
                if (this.getSpreadSelector() == null || (cellDimMember = this.getCellDimMember(row = this.getSpreadSelector().getStartRow(), 0)) == null) break;
                if (cellDimMember.getDimNumber() != null && cellDimMember.getDimNumber().equals(this.getCurrentRowDimension())) {
                    this.setAccountRoot(cellDimMember.getMemNumber());
                    this.updateControlText("btn_setaccount", ResManager.loadKDString((String)"\u4f5c\u4e3a\u6839", (String)"DiffAnalyzePlugin_48", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.refreshSpread();
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u88ab\u94bb\u53d6\u7684\u7ef4\u5ea6\u6210\u5458\u4e0d\u80fd\u4f5c\u4e3a\u6839\u6210\u5458\u3002", (String)"DiffAnalyzePlugin_52", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                break;
            }
            case "btn_clearaccountroot": {
                this.setAccountRoot(null);
                this.updateControlText("btn_setaccount", ResManager.loadKDString((String)"\u663e\u793a\u5168\u90e8", (String)"DiffAnalyzePlugin_49", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.refreshSpread();
                break;
            }
            case "btn_expendrow": {
                boolean isRow;
                DiffAnalyzeScheme diffAnalyzeScheme;
                SpreadSelector selector = this.getSpreadSelector();
                if (selector == null || !this.canRefreshCellData(diffAnalyzeScheme = this.refreshMetas(this.getSchemeConfig()))) break;
                boolean bl = isRow = selector.getStartCol() == 0;
                if (isRow) {
                    new ExpandRowChildCommand(selector.getStartRow(), RangeEnum.ALL_EXCLUDE.getIndex(), this.getSpreadManager(), diffAnalyzeScheme).execute(this);
                    break;
                }
                new ExpandColChildCommand(selector.getStartCol(), RangeEnum.ALL_EXCLUDE.getIndex(), this.getSpreadManager(), diffAnalyzeScheme).execute(this);
                break;
            }
            case "btn_shrinkrow": {
                boolean isRow;
                SpreadSelector selector1 = this.getSpreadSelector();
                if (selector1 == null) break;
                boolean bl = isRow = selector1.getStartCol() == 0;
                if (isRow) {
                    new CollapseRowChildCommand(selector1.getStartRow(), this.getSpreadManager(), this.getspreadContainer()).execute(this);
                    break;
                }
                new CollapseColChildCommand(selector1.getStartCol(), this.getSpreadManager(), this.getspreadContainer(), this.getSchemeConfig()).execute(this);
                break;
            }
            case "btn_exit": {
                this.getUserDefinedRowColSize();
                break;
            }
            case "displaysetting": {
                new ShowFormCommand(key).execute(this);
                break;
            }
            case "btn_export": {
                this.exportSpread();
                break;
            }
            case "btn_share": {
                new ShowFormCommand(key).execute(this);
                break;
            }
        }
    }

    private void cacheMemberDisplayType(int memberDisplayType) {
        this.getPageCache().put("MemberDisplayType", String.valueOf(memberDisplayType));
    }

    private int getMemberDisplayType() {
        String str = this.getPageCache().get("MemberDisplayType");
        if (str != null) {
            return Integer.parseInt(str);
        }
        return MemberDisplayTypeEnum.NAME.getIndex();
    }

    protected void onOffEditSchemeMode(boolean isOn) {
        this.setCache("IS_EDIT_SCHEME_MODE", Boolean.toString(isOn));
        this.setControlVisible(isOn);
        if (isOn) {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("analyzescheme");
            if (dynamicObject == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u65b9\u6848\u3002", (String)"DiffAnalyzePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getLong("id"), (String)"eb_diffanalyzescheme");
            if (object == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u76f8\u5173\u6570\u636e\u3002", (String)"DiffAnalyzePlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.setCachedRowDimension(null);
            Set<String> schemeDims = this.displaySchemeConfig(object);
            this.initSchemeDimpool(schemeDims);
            this.cacheSchemeDims(schemeDims);
            this.setControlDraggable();
        } else {
            Set<String> schemeDims = this.getSchemeDims();
            if (schemeDims == null || schemeDims.isEmpty()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryentity1panel"});
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)this.getCachedRowDimension())) {
                this.setCachedRowDimension(null);
                this.cacheSchemeDims(null);
                this.hideDimensions = null;
                this.resetSpreadManager();
                this.refreshPageViewPanel(true);
                this.refreshSpread();
            } else {
                this.refreshCellData();
            }
            this.updateByWhichDimLabel(this.getCurrentColDimension());
        }
    }

    protected void initSchemeDimpool(Set<String> schemeDims) {
        Lang lang;
        this.dimNamesMap = this.getDimNamesMap();
        this.dimCtrlKeyMap = this.getDimCtrlKeyMap();
        this.dimNamesMap = this.getDimNamesMap();
        String rowDim = this.getCurrentRowDimension();
        HashSet<String> invisible_dimKeys = new HashSet<String>(16);
        HashSet visible_dimKeys = new HashSet(16);
        invisible_dimKeys.add("ebf7_page_" + this.dimCtrlKeyMap.get(rowDim));
        if (schemeDims != null) {
            for (String schemeDim : schemeDims) {
                if (kd.bos.util.StringUtils.isNotEmpty((String)this.dimCtrlKeyMap.get(schemeDim))) {
                    invisible_dimKeys.add("ebf7_page_" + this.dimCtrlKeyMap.get(schemeDim));
                    continue;
                }
                invisible_dimKeys.add("ebf7_page_" + schemeDim.toLowerCase());
            }
        }
        ((Container)this.getControl("dimpoolpanel")).getItems().forEach(item -> {
            if (item.getKey().startsWith("ebf7_page_") && !this.dimCtrlKeyMap.containsKey(item.getKey().replaceAll("ebf7_page_", ""))) {
                invisible_dimKeys.add(item.getKey());
            } else {
                visible_dimKeys.add(item.getKey());
            }
        });
        String customDim = "ebf7_page_customize";
        HashSet visible_dimKeys_custom = new HashSet(16);
        HashSet visible_dimKeys_common = new HashSet(16);
        visible_dimKeys.forEach(k -> {
            if (k.startsWith(customDim)) {
                visible_dimKeys_custom.add(k);
            } else if (k.startsWith("ebf7_page_")) {
                visible_dimKeys_common.add(k);
            }
        });
        if (visible_dimKeys_custom.size() > 0) {
            for (String ctrlKey : visible_dimKeys_custom) {
                if (!kd.bos.util.StringUtils.isEmpty((String)((String)this.getModel().getValue(ctrlKey)))) continue;
                this.getModel().setValue(ctrlKey, (Object)this.dimNamesMap.get(this.dimCtrlKeyMap.get(ctrlKey.replaceAll("ebf7_page_", ""))));
            }
            this.getView().updateView("dimpoolpanel");
        }
        if (Lang.zh_CN != (lang = RequestContext.getOrCreate().getLang()) && visible_dimKeys_common.size() > 0) {
            for (String ctrlKey : visible_dimKeys_common) {
                this.getModel().setValue(ctrlKey, (Object)this.dimNamesMap.get(this.dimCtrlKeyMap.get(ctrlKey.replaceAll("ebf7_page_", ""))));
            }
            this.getView().updateView("dimpoolpanel");
        }
        this.getView().setVisible(Boolean.valueOf(true), visible_dimKeys.toArray(new String[0]));
        this.getView().setVisible(Boolean.valueOf(false), invisible_dimKeys.toArray(new String[0]));
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        if (e.getEntryProp() != null && "entryentity".equals(e.getEntryProp().getName()) && e.getRowIndexs() != null && e.getRowIndexs().length > 0) {
            DynamicObject dynamicObject;
            int row = e.getRowIndexs()[0];
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
            if (dynamicObjects != null && dynamicObjects.size() > row && (dynamicObject = (DynamicObject)dynamicObjects.get(row)) != null && dynamicObject.getInt("col_type") == 0) {
                if (this.checkColReference(dynamicObject.getString("id"))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5217\u5df2\u88ab\u8868\u8fbe\u5f0f\u5f15\u7528\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DiffAnalyzePlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                boolean hasDataRow = false;
                int size = dynamicObjects.size();
                for (int i = 0; i < size; ++i) {
                    if (i == row || ((DynamicObject)dynamicObjects.get(i)).getInt("col_type") != 0) continue;
                    hasDataRow = true;
                    break;
                }
                String entityId = dynamicObject.getString("id");
                ArrayList<String> key = new ArrayList<String>(16);
                for (Map.Entry<String, Long> stringLongEntry : this.getEntryDimensionViews().entrySet()) {
                    boolean contains = stringLongEntry.getKey().contains(entityId);
                    if (!contains) continue;
                    key.add(stringLongEntry.getKey());
                }
                if (!hasDataRow) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u4e2d\u5e94\u81f3\u5c11\u5b58\u5728\u4e00\u4e2a\u6570\u636e\u5217\u3002", (String)"DiffAnalyzePlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                if (CollectionUtils.isNotEmpty(key)) {
                    for (String s : key) {
                        this.cacheEntryDimensionViews(s, null);
                    }
                }
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.clearCacheColIndexNameMap();
    }

    private void hideshowPageDimPanel(String ctrlKey) {
        if (this.isEditSchemeMode()) {
            return;
        }
        if ("icon_hidepagedim".equals(ctrlKey)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"dimspanel", "icon_hidepagedim"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"icon_showpagedim"});
        } else if ("icon_showpagedim".equals(ctrlKey)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"dimspanel", "icon_hidepagedim"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"icon_showpagedim"});
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object opSource = args.getSource();
        if (opSource instanceof EntryGridOperate) {
            this.setCache("opKey", ((EntryGridOperate)opSource).getOperateKey());
        } else {
            this.setCache("opKey", null);
        }
    }

    @Override
    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        AdminModelUtil.checkAdminModeBeforeClick(evt, this.getModelId(), this.getView());
        if (evt.getSource() instanceof Button) {
            int[] rowIndexs;
            String opKey = ((Button)evt.getSource()).getOperationKey();
            boolean moveEntryDown = "moveentrydown".equals(opKey);
            boolean moveEntryUp = "moveentryup".equals(opKey);
            if ((moveEntryDown || moveEntryUp) && (rowIndexs = ((CardEntry)this.getControl("entryentity")).getSelectRows()) != null && rowIndexs.length > 0) {
                if (moveEntryDown && Arrays.stream(rowIndexs).max().getAsInt() >= this.getModel().getEntryRowCount("entryentity") - 1) {
                    this.getView().showTipNotification(MessageConstant.getSELECT_LAST());
                    evt.setCancel(true);
                } else if (moveEntryUp && Arrays.stream(rowIndexs).min().getAsInt() <= 0) {
                    this.getView().showTipNotification(MessageConstant.getSELECT_FIRST());
                    evt.setCancel(true);
                }
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (!this.isEditSchemeMode()) {
            try {
                this.savePageDimSelect();
            }
            catch (Exception exception) {
                log.info("\u4fdd\u5b58\u65b9\u6848\u7528\u6237\u8bb0\u5fc6\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458:{}", (Object)e);
            }
        }
    }

    private void savePageDimSelect() {
        HashMap<String, String> userRememberMap = new HashMap<String, String>(16);
        ArrayList<String> pageDimNums = new ArrayList<String>(10);
        List<Dimension> dimensionList = this.getAllDimension();
        String rowDimension = this.getCurrentRowDimension();
        String colDimension = this.getCurrentColDimension();
        Set<String> schemeDims = this.getSchemeDims();
        for (Dimension dimension : dimensionList) {
            String dimNumber = dimension.getNumber();
            if (rowDimension != null && rowDimension.equals(dimNumber) || colDimension != null && colDimension.equals(dimNumber) || CollectionUtils.isNotEmpty(schemeDims) && schemeDims.contains(dimNumber)) continue;
            pageDimNums.add(dimNumber);
        }
        Map<String, String> f7Map = this.getF7KeyDimMap();
        for (String dimNum : pageDimNums) {
            String f7Key = f7Map.get(dimNum);
            Object value = this.getModel().getValue(f7Key);
            if (!(value instanceof DynamicObject)) continue;
            userRememberMap.put(dimNum, ((DynamicObject)value).getString("number"));
        }
        List dataCols = this.getSchemeConfig().getAnalyzeColumns().stream().filter(c -> c.getDataRow().getDataRowType().getIndex() == DataRowEnum.DATA.getIndex()).collect(Collectors.toList());
        boolean hasF7 = dataCols.stream().anyMatch(d -> d.getDataRow().getMetas().size() > 0);
        if (hasF7) {
            for (int i = 0; i < dataCols.size(); ++i) {
                DiffAnalyzeScheme.DiffAnalyzeColumn diffAnalyzeColumn = (DiffAnalyzeScheme.DiffAnalyzeColumn)dataCols.get(i);
                IDataRow dataRow = diffAnalyzeColumn.getDataRow();
                Map colConfigMap = dataRow.getMetas();
                for (Map.Entry entry : colConfigMap.entrySet()) {
                    String metaKey = (String)entry.getKey();
                    if (pageDimNums.contains(metaKey)) continue;
                    String ctrlKey = "ebf7_" + this.dimCtrlKeyMap.get(metaKey) + "_p1";
                    Object value = this.getModel().getValue(ctrlKey, i);
                    if (!(value instanceof DynamicObject)) continue;
                    userRememberMap.put(metaKey + i, ((DynamicObject)value).getString("number"));
                }
            }
        }
        UserRememberService.getInstance().saveRemember(this.getUserRememberKey(), (Object)JSON.toJSONString(userRememberMap), this.getKeyGroup());
    }

    private void switchColDimension(String key) {
        this.spreadManager = this.getSpreadManager();
        if (key == null || this.spreadManager == null || this.spreadManager.getColDimension() == null) {
            return;
        }
        String dimNumber = this.getDimCtrlKeyMap().get(key.replaceAll("btn_by", ""));
        Long aLong = this.getDimensionViews().get(dimNumber);
        Member rootMember = this.getModelCacheHelper().getRootMember(dimNumber, aLong);
        IDiffAnalyzeSpreadManager spreadManager = this.getSpreadManager();
        spreadManager.getDimemsionViews().putAll(this.getDimensionViews());
        new SwitchColDimensionCommand(dimNumber, rootMember == null ? dimNumber : rootMember.getNumber(), RangeEnum.DIRECTSUB_EXCLUDE.getIndex(), spreadManager).execute(this);
        this.refreshSpread();
        this.setContextMenus();
        this.updateByWhichDimLabel(dimNumber);
    }

    private void updateByWhichDimLabel(String dimNumber) {
        if (kd.bos.util.StringUtils.isEmpty((String)dimNumber)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_bywhichdim"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_bywhichdim"});
            this.updateControlText("btn_bywhichdim", ResManager.loadResFormat((String)"\u6309%1", (String)"DiffAnalyzePlugin_46", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getDimNamesMap().get(dimNumber)}));
        }
    }

    public void updateByWhichDimLabels() {
        this.dimCtrlKeyMap = this.getDimCtrlKeyMap();
        boolean isEditSchemeMode = this.isEditSchemeMode();
        List<String> colDims = this.getSwitchColDims();
        Set<Object> hideDims = isEditSchemeMode ? new HashSet(16) : this.getHideDimensions();
        HashSet<String> visibleKeys = new HashSet<String>(16);
        HashSet<String> invisibleKeys = new HashSet<String>(16);
        for (String dimNumber : colDims) {
            if (hideDims.contains(dimNumber)) continue;
            visibleKeys.add("btn_by" + this.dimCtrlKeyMap.get(dimNumber));
        }
        for (int i = 1; i <= 9; ++i) {
            String dimNumber = this.dimCtrlKeyMap.get("customize" + i);
            this.updateControlTitle("btn_bycustomize" + i, ResManager.loadResFormat((String)"\u6309%1", (String)"DiffAnalyzePlugin_46", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getDimNamesMap().get(dimNumber)}));
        }
        for (String key : DIM_KEYS) {
            String itemKey = "btn_by" + key;
            if (visibleKeys.contains(itemKey)) continue;
            invisibleKeys.add(itemKey);
        }
        this.getView().setVisible(Boolean.valueOf(true), visibleKeys.toArray(new String[0]));
        this.getView().setVisible(Boolean.valueOf(false), invisibleKeys.toArray(new String[0]));
    }

    private void updateControlTitle(String item, String label) {
        HashMap language = Maps.newHashMapWithExpectedSize((int)1);
        HashMap parm = Maps.newHashMapWithExpectedSize((int)1);
        language.put(Lang.get().toString(), label);
        parm.put("title", language);
        this.getView().updateControlMetadata(item, (Map)parm);
    }

    private void updateControlText(String item, String label) {
        HashMap language = Maps.newHashMapWithExpectedSize((int)1);
        HashMap parm = Maps.newHashMapWithExpectedSize((int)1);
        language.put(Lang.get().toString(), label);
        parm.put("text", language);
        this.getView().updateControlMetadata(item, (Map)parm);
    }

    public String getCurrentColDimension() {
        List<String> colDims;
        String colDimension = null;
        this.spreadManager = this.getSpreadManager();
        if (this.spreadManager != null && this.spreadManager.getColDimension() != null) {
            colDimension = this.spreadManager.getColDimension().getNumber();
        }
        if (colDimension == null && (colDims = this.getSwitchColDims()) != null && !colDims.isEmpty()) {
            String defColDim = (String)this.getConfigMap().get("def_col_dimension");
            colDimension = colDims.contains(defColDim) ? defColDim : (colDims.contains(SysDimensionEnum.BudgetPeriod.getNumber()) ? SysDimensionEnum.BudgetPeriod.getNumber() : (colDims.contains(SysDimensionEnum.Entity.getNumber()) ? SysDimensionEnum.Entity.getNumber() : (colDims.contains(SysDimensionEnum.AuditTrail.getNumber()) ? SysDimensionEnum.AuditTrail.getNumber() : colDims.get(0))));
        }
        return colDimension;
    }

    public List<String> getSwitchColDims() {
        List<String> colDims = this.getAllDimension().stream().map(e -> e.getNumber()).collect(Collectors.toList());
        colDims.remove(this.getCurrentRowDimension());
        colDims.removeAll(this.getSchemeDims());
        if (!this.isEditSchemeMode()) {
            colDims.removeAll(this.getHideDimensions());
        }
        return colDims;
    }

    @Override
    public String getCurrentRowDimension() {
        String rowDim = this.getCachedRowDimension();
        if (kd.bos.util.StringUtils.isEmpty((String)rowDim)) {
            DiffAnalyzeScheme.DiffAnalyzeConfig schemeConfig;
            this.spreadManager = this.getSpreadManager();
            rowDim = this.spreadManager == null || this.spreadManager.getRowDimension() == null || this.spreadManager.getRowDimension().getNumber() == null ? ((schemeConfig = this.getSchemeConfig().getConfig()) != null ? schemeConfig.getRowDimension() : SysDimensionEnum.Account.getNumber()) : this.spreadManager.getRowDimension().getNumber();
        }
        return rowDim;
    }

    @Override
    public String getCachedRowDimension() {
        return this.getCache("cachedRowDimension");
    }

    public void setCachedRowDimension(String dimNumber) {
        this.setCache("cachedRowDimension", dimNumber);
    }

    protected void setVirtualMode(boolean isopen) {
        this.getspreadContainer().setVirtualMode("virtualModelCallBack", isopen);
        this.setCache("isVirtualMode", isopen ? SHOWEMPTYROW : null);
    }

    public void virtualModelCallBack(Object dataInfo) {
        if (this.isEditSchemeMode()) {
            return;
        }
        try {
            if (dataInfo instanceof LinkedHashMap) {
                OlapQuerySync.ViewArea viewAreaToRefresh;
                LinkedHashMap data = (LinkedHashMap)((LinkedHashMap)dataInfo).get("data");
                OlapQuerySync.ViewArea viewArea = new OlapQuerySync.ViewArea(((Integer)data.get("topRow")).intValue(), ((Integer)data.get("bottomRow")).intValue(), ((Integer)data.get("leftCol")).intValue(), ((Integer)data.get("rightCol")).intValue());
                RefreshCellDataCommand cmd = new RefreshCellDataCommand(viewArea.getStartrow(), viewArea.getEndrow(), this);
                cmd.cacheLastViewArea(viewArea);
                if (cmd.isViewDataRefreshed(viewArea)) {
                    log.info(viewArea + " all rows refreshed, returning..");
                    return;
                }
                DiffAnalyzeScheme diffAnalyzeScheme = this.refreshMetas(this.getSchemeConfig());
                if (this.canRefreshCellData(diffAnalyzeScheme) && (viewAreaToRefresh = cmd.viewAreaToRefresh(viewArea)) != null) {
                    IDiffAnalyzeSpreadManager spreadManager = this.getSpreadManager();
                    spreadManager.getDimemsionViews().putAll(this.getDimensionViews());
                    new RefreshCellDataCommand(viewAreaToRefresh.getStartrow(), viewAreaToRefresh.getEndrow(), diffAnalyzeScheme, this.getSpreadManager()).execute(this);
                }
                log.info(viewArea + " refreshed..");
            }
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            if (ex instanceof KDBizException) {
                this.getView().showErrorNotification(ex.getMessage());
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DiffAnalyzePlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public boolean canRefreshCellData(DiffAnalyzeScheme scheme) {
        if (this.isEditSchemeMode()) {
            return true;
        }
        List<kd.epm.eb.common.model.Dimension> dimensions = this.getCommonDimension();
        boolean flag = false;
        if (dimensions != null) {
            for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
                if (dimension != null && dimension.getMembers() != null && !dimension.getMembers().isEmpty()) continue;
                flag = true;
                break;
            }
            if (flag) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u901a\u7528\u7ef4\u5ea6\u5b58\u5728\u672a\u9009\u62e9\u6210\u5458\u3002", (String)"DiffAnalyzePlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if (scheme != null && scheme.getAnalyzeColumns() != null) {
            for (DiffAnalyzeScheme.DiffAnalyzeColumn analysisColumn : scheme.getAnalyzeColumns()) {
                IDataRow dataRow = analysisColumn.getDataRow();
                if (dataRow.getDataRowType().getIndex() != DataRowEnum.DATA.getIndex() || dataRow.getMetas() == null || !dataRow.getMetas().values().contains(null)) continue;
                flag = true;
                break;
            }
            if (flag) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5217\u7ef4\u5ea6\u5b58\u5728\u672a\u9009\u62e9\u6210\u5458\u3002", (String)"DiffAnalyzePlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    protected boolean refreshSpread() {
        this.verify();
        this.setVirtualMode(true);
        try {
            this.invokeSpreadJson();
            this.setContextMenus();
            this.hideDisableMemberEmptyRowCols();
        }
        catch (KDBizException e) {
            log.error((Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
            return false;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DiffAnalyzePlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        if ("drop".equals(e.getEventName())) {
            String eventArgs = e.getEventArgs();
            String[] msg = DiffAnalyzeHelper.translateMessage(eventArgs);
            String target = msg[0];
            String source = msg[1];
            if (source != null && Arrays.asList(F7_KEYS_DIMPOOL).contains(source) && "colconfigpanel".equals(target)) {
                String dimKey = "";
                if (source.startsWith("ebf7_page_")) {
                    dimKey = source.replaceAll("ebf7_page_", "");
                }
                this.addOrRemoveSchemeDims(dimKey, true);
            } else if (source != null && source.startsWith("col_") && "dimpoolpanel".equals(target)) {
                this.addOrRemoveSchemeDims(source.replaceAll("col_", ""), false);
            } else if (source != null && Arrays.asList(F7_KEYS_DIMPOOL).contains(source) && "rowdimpanel".equals(target)) {
                String newRowDimension = this.getDimCtrlKeyMap().get(source.replaceAll("ebf7_page_", ""));
                String oldRowDimension = this.getCachedRowDimension();
                if (kd.bos.util.StringUtils.isEmpty((String)oldRowDimension)) {
                    oldRowDimension = this.getCurrentRowDimension();
                }
                this.setCachedRowDimension(newRowDimension);
                Label label = (Label)this.getView().getControl(LABEL_ROWDIMENSION);
                if (label != null) {
                    label.setText(this.getDimNamesMap().get(newRowDimension));
                }
                String oldRowDimMembersVal = (String)this.getModel().getValue("account_range");
                String oldRowDimMembersStr = this.getCache("account_range");
                String ctrlKey_pageF7 = "ebf7_page_" + this.getDimCtrlKeyMap().get(oldRowDimension);
                if (kd.bos.util.StringUtils.isNotEmpty((String)oldRowDimMembersVal) && kd.bos.util.StringUtils.isNotEmpty((String)oldRowDimMembersStr)) {
                    this.getModel().setValue(ctrlKey_pageF7, (Object)oldRowDimMembersVal);
                    this.setCache(ctrlKey_pageF7, oldRowDimMembersStr);
                }
                this.getModel().setValue("account_range", null);
                this.setCache("account_range", null);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{source});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{ctrlKey_pageF7});
                this.refreshSpread();
            }
        }
    }

    private String getAccountRoot() {
        return this.getCache("account_root");
    }

    private void setAccountRoot(String topItemNumber) {
        this.setCache("account_root", topItemNumber);
    }

    private kd.epm.eb.common.model.Dimension getInitRowDimension() {
        String dimNumber = this.getCurrentRowDimension();
        kd.epm.eb.common.model.Dimension dimension = kd.epm.eb.common.model.Dimension.loadFormCache((Dimension)this.getModelCacheHelper().getDimension(dimNumber));
        dimension.setNumber(dimNumber);
        List<Object> cacheMembers = null;
        String[] topItems = this.getTopItems();
        Long viewStr = this.getDimensionViews().get(dimNumber);
        if (topItems != null && topItems.length > 0) {
            cacheMembers = new LinkedList();
            for (String item : topItems) {
                List<Member> tempMembers;
                if (!kd.bos.util.StringUtils.isNotEmpty((String)item) || (tempMembers = DiffAnalyzeHelper.getMember(this.getDatasetId(), this.getModelCacheHelper(), this.getMemberPerm(), dimNumber, viewStr, item, RangeEnum.ONLY.getIndex())) == null || tempMembers.isEmpty()) continue;
                cacheMembers.addAll(tempMembers);
            }
        }
        if (cacheMembers == null) {
            Member rootMember = this.getModelCacheHelper().getRootMember(dimNumber, viewStr);
            cacheMembers = DiffAnalyzeHelper.getMember(this.getDatasetId(), this.getModelCacheHelper(), this.getMemberPerm(), dimNumber, viewStr, rootMember.getNumber(), RangeEnum.DIRECTSUB_EXCLUDE.getIndex());
        }
        if (cacheMembers != null) {
            for (Member member : cacheMembers) {
                dimension.add(kd.epm.eb.common.model.Member.loadFormCache((Member)member));
            }
        }
        return dimension;
    }

    protected void invokeSpreadJson() {
        try {
            this.spreadManager = this.getSpreadManager();
            if (this.spreadManager != null) {
                this.spreadManager.setModelCacheHelper(this.getModelCacheHelper());
                this.spreadManager.setMemberPerm(this.getMemberPerm());
                this.spreadManager.initSpreadManager(this.getModelId(), Long.valueOf(this.getDatasetId()), this.refreshMetas(this.getSchemeConfig()));
                this.spreadManager.setRowDimension(this.getInitRowDimension());
                this.spreadManager.setColDimension(this.getInitColDimension());
                this.spreadManager.setCommonDimension(this.getCommonDimension());
                this.spreadManager.setHideEmptyRows(this.isHideEmptyRows());
                this.spreadManager.setDataUnit(this.getDataUnit());
                this.spreadManager.setMemberDisplayType(this.getMemberDisplayType());
                this.spreadManager.getDimemsionViews().putAll(this.getDimensionViews());
                this.getCommonDimemsionViews().forEach((k, v) -> this.spreadManager.getDimemsionViews().put(k, v));
                this.spreadManager.buildSpreadManager();
                String spreadjson = this.spreadManager.getEbook().toJsonWithRealRowCol();
                byte[] bb = Base64.getEncoder().encode(GZIPUtils.compress((String)spreadjson));
                this.spreadContainer = this.getspreadContainer();
                this.spreadContainer.rebuildSpread("base64" + new String(bb));
                this.spreadContainer.frozenSheet(new SheetFrozenInfo(Integer.valueOf(this.spreadManager.getColDimension() == null ? 1 : 2), null, Integer.valueOf(1), null));
                this.spreadContainer.lockSheets(Collections.singletonList(this.spreadManager.getEbook().getSheet(0).getSheetName()));
                this.spreadContainer.setColumnsWidth(Collections.singletonList(0), 200);
                this.spreadContainer.closeToolbar();
                DiffAnalyzeHelper.refreshGroupNodeType(this.spreadContainer, this.spreadManager);
                this.spreadContainer.setRowsHeight(Collections.singletonList(0), 60);
                this.refreshCellData();
                this.setCache("firstRefresh", SHOWEMPTYROW);
                this.cacheSpreadManager();
            }
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DiffAnalyzePlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public void refreshCellData() {
        this.refreshCellData(false);
    }

    public void refreshCellData(boolean clearOldData) {
        if (clearOldData) {
            new RefreshCellDataCommand(this).clearCellData();
        }
        new RefreshCellDataCommand(this).removeRefreshRows();
        OlapQuerySync.ViewArea lastViewArea = new RefreshCellDataCommand(this).getLastViewArea();
        if (lastViewArea == null) {
            lastViewArea = OlapQuerySync.ViewArea.ofFirstScreenView();
        }
        LinkedHashMap dataInfo = new LinkedHashMap(1);
        LinkedHashMap<String, Integer> data = new LinkedHashMap<String, Integer>(4);
        dataInfo.put("data", data);
        data.put("topRow", lastViewArea.getStartrow());
        data.put("bottomRow", lastViewArea.getEndrow());
        data.put("leftCol", lastViewArea.getStartcol());
        data.put("rightCol", lastViewArea.getEndcol());
        this.virtualModelCallBack(dataInfo);
    }

    private kd.epm.eb.common.model.Dimension getInitColDimension() {
        String dimNumber = this.getCurrentColDimension();
        if (dimNumber == null) {
            return null;
        }
        kd.epm.eb.common.model.Dimension dimension = kd.epm.eb.common.model.Dimension.loadFormCache((Dimension)this.getModelCacheHelper().getDimension(dimNumber));
        dimension.setNumber(dimNumber);
        String str = this.getCache(this.getF7KeyDimMapMul().get(dimNumber));
        List multiSelectValues = null;
        if (str != null) {
            multiSelectValues = (List)SerializationUtils.fromJsonString((String)str, List.class);
        }
        if (multiSelectValues != null && multiSelectValues.size() > 0) {
            multiSelectValues.forEach(m -> {
                Member cacheMember = DiffAnalyzeHelper.getMember(this.getDatasetId(), this.getModelCacheHelper(), this.getMemberPerm(), dimNumber, this.getDimensionViews().get(dimNumber), (String)m.get("number"));
                if (cacheMember != null) {
                    kd.epm.eb.common.model.Member member = kd.epm.eb.common.model.Member.loadFormCache((Member)cacheMember);
                    member.setRange(Integer.parseInt((String)m.get("scope")));
                    dimension.add(member);
                }
            });
        } else {
            Member cacheMember = DiffAnalyzeHelper.getMember(this.getDatasetId(), this.getModelCacheHelper(), this.getMemberPerm(), dimNumber, this.getDimensionViews().get(dimNumber), dimNumber);
            if (cacheMember != null) {
                kd.epm.eb.common.model.Member member = kd.epm.eb.common.model.Member.loadFormCache((Member)cacheMember);
                member.setRange(RangeEnum.DIRECTSUB_EXCLUDE.getIndex());
                dimension.add(member);
            }
        }
        return dimension;
    }

    @Override
    public DiffAnalyzeScheme refreshMetas(DiffAnalyzeScheme scheme) {
        if (scheme == null || scheme.getAnalyzeColumns() == null) {
            return scheme;
        }
        List analysisColumns = scheme.getAnalyzeColumns();
        this.entryDimemsionViews = this.getEntryDimensionViews();
        Long viewId = 0L;
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity1");
        this.dimCtrlKeyMap = this.getDimCtrlKeyMap();
        int index = 0;
        for (DiffAnalyzeScheme.DiffAnalyzeColumn analysisColumn : analysisColumns) {
            IDataRow dataRow = analysisColumn.getDataRow();
            if (dataRow != null && dataRow.getDataRowType().getIndex() == DataRowEnum.DATA.getIndex() && dataRow.getMetas() != null) {
                Iterator entryIter = dataRow.getMetas().entrySet().iterator();
                while (entryIter.hasNext()) {
                    viewId = 0L;
                    Map.Entry entry = entryIter.next();
                    String metaKey = (String)entry.getKey();
                    String metaValue = (String)entry.getValue();
                    String dataRowIndex = dataRow.getIndex();
                    if ("_SECOND_PAGE".equals(metaValue)) {
                        entry.setValue(null);
                        String f7Key = this.getF7KeyDimMap2().get(metaKey);
                        for (DynamicObject d : dynamicObjects) {
                            DynamicObject dynamicObject;
                            if (dataRowIndex == null || !dataRowIndex.equals(d.getString("col_index1")) || (dynamicObject = d.getDynamicObject(f7Key)) == null) continue;
                            entry.setValue(dynamicObject.getString("number"));
                            break;
                        }
                        if (!IDUtils.isNotNull((Long)(viewId = this.entryDimemsionViews.get(metaKey + "_" + dataRowIndex)))) continue;
                        dataRow.getDimensionViews().put(metaKey, viewId);
                        continue;
                    }
                    if (metaValue == null) continue;
                    if (metaKey.startsWith("_DIMVIEW_")) {
                        dataRow.getDimensionViews().put(metaKey.replaceAll("_DIMVIEW_", ""), IDUtils.toLong((Object)metaValue));
                        entryIter.remove();
                        continue;
                    }
                    if (metaKey.startsWith("_DIMVIEW_")) continue;
                    Object viewIdObj = null;
                    Member member = null;
                    Object v = dataRow.getDimensionViews().get(metaKey);
                    viewIdObj = v;
                    if (v != null) {
                        boolean exists;
                        viewId = IDUtils.toLong(viewIdObj);
                        member = IDUtils.isNull((Long)viewId) ? this.getModelCacheHelper().getMember(metaKey, null, metaValue) : ((exists = QueryServiceHelper.exists((String)"eb_dimensionview", viewIdObj)) ? this.getModelCacheHelper().getMember(metaKey, viewId, metaValue) : this.getModelCacheHelper().getMember(metaKey, null, metaValue));
                    } else {
                        if (dataRow.getMetas().containsKey("_DIMVIEW_" + metaKey)) {
                            viewId = IDUtils.toLong(dataRow.getMetas().get("_DIMVIEW_" + metaKey));
                        }
                        member = this.getModelCacheHelper().getMember(metaKey, viewId, metaValue);
                    }
                    String ctrlKey = "ebf7_" + this.dimCtrlKeyMap.get(metaKey) + "_p1";
                    String entryRow = dataRow.getIndex();
                    String cacheKey = ctrlKey;
                    if (!ctrlKey.contains("ebf7_page_")) {
                        cacheKey = entryRow != null ? "lastselect_" + entryRow + cacheKey : "lastselect_" + cacheKey;
                    }
                    Member cacheMember = null;
                    String cache = this.getCache(cacheKey);
                    if (kd.bos.util.StringUtils.isNotEmpty((String)cache)) {
                        boolean exists;
                        Object v2 = dataRow.getDimensionViews().get(metaKey);
                        viewIdObj = v2;
                        cacheMember = v2 != null ? (IDUtils.isNull((Long)(viewId = IDUtils.toLong(viewIdObj))) ? this.getModelCacheHelper().getMember(metaKey, null, IDUtils.toLong((Object)cache)) : (!(exists = QueryServiceHelper.exists((String)"eb_dimensionview", (Object)viewId)) ? this.getModelCacheHelper().getMember(metaKey, null, IDUtils.toLong((Object)cache)) : this.getModelCacheHelper().getMember(metaKey, viewId, IDUtils.toLong((Object)cache)))) : this.getModelCacheHelper().getMember(metaKey, null, IDUtils.toLong((Object)cache));
                    }
                    if (cacheMember != null) {
                        member = cacheMember;
                    }
                    if (member == null || this.getMemberPerm().isNoperm(metaKey, metaValue, viewId)) {
                        Long f7Value = this.getF7Value(ctrlKey, metaKey, entryRow, null);
                        if (IDUtils.isNotNull((Long)f7Value)) {
                            Member defaultMember = this.getModelCacheHelper().getMember(metaKey, null, f7Value);
                            if (defaultMember != null) {
                                dataRow.getMetas().put(metaKey, defaultMember.getNumber());
                                this.getView().setEnable(Boolean.valueOf(true), index, new String[]{ctrlKey});
                                this.getModel().setValue(ctrlKey, (Object)f7Value, index);
                                this.getView().updateView(ctrlKey, index);
                                continue;
                            }
                            dataRow.getMetas().put(metaKey, null);
                            this.getView().setEnable(Boolean.valueOf(true), index, new String[]{ctrlKey});
                            this.getModel().setValue(ctrlKey, null, index);
                            this.getView().updateView(ctrlKey, index);
                            continue;
                        }
                        dataRow.getMetas().put(metaKey, null);
                        this.getView().setEnable(Boolean.valueOf(true), index, new String[]{ctrlKey});
                        this.getModel().setValue(ctrlKey, null, index);
                        this.getView().updateView(ctrlKey, index);
                        continue;
                    }
                    dataRow.getMetas().put(metaKey, member.getNumber());
                }
            }
            ++index;
        }
        return scheme;
    }

    private List<kd.epm.eb.common.model.Dimension> getCommonDimension() {
        Map<String, String> f7Map = this.getF7KeyDimMap();
        List<Dimension> allDims = this.getAllDimension();
        String colDim = this.getCurrentColDimension();
        String rowDim = this.getCurrentRowDimension();
        String dimNumber = null;
        LinkedList<kd.epm.eb.common.model.Dimension> commonDims = new LinkedList<kd.epm.eb.common.model.Dimension>();
        Set<String> schemeDims = this.getSchemeDims();
        for (Dimension cacheDim : allDims) {
            dimNumber = cacheDim.getNumber();
            if (dimNumber.equals(colDim) || dimNumber.equals(rowDim) || schemeDims.contains(dimNumber)) continue;
            kd.epm.eb.common.model.Dimension dimension = kd.epm.eb.common.model.Dimension.loadFormCache((Dimension)cacheDim);
            kd.epm.eb.common.model.Member member = null;
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue(f7Map.get(dimNumber));
            if (dynamicObject != null) {
                member = kd.epm.eb.common.model.Member.loadFromDynamicObject((DynamicObject)dynamicObject);
                dimension.add(member);
            }
            commonDims.add(dimension);
        }
        return commonDims;
    }

    @Override
    public IMemberPermCache getMemberPerm() {
        if (this.memberPerm == null) {
            this.memberPerm = MemberPermCacheServiceHelper.build(null, (Long)this.getModelId(), (Long)this.getBusModelId(), null);
        }
        return this.memberPerm;
    }

    @Override
    public void setMultiSelectMembers(String dimNumber, List<kd.epm.eb.common.model.Member> members) {
        String multiKey;
        if (dimNumber == null) {
            return;
        }
        if (members == null) {
            if (this.defaultDimMember != null && this.defaultDimMember.containsKey(dimNumber)) {
                Member m2 = this.getModelCacheHelper().getMember(dimNumber, this.getDimensionViews().get(dimNumber), this.defaultDimMember.get(dimNumber));
                if (m2 != null) {
                    members = Collections.singletonList(kd.epm.eb.common.model.Member.loadFormCache((Member)m2));
                }
            } else {
                int range = SysDimensionEnum.Entity.getNumber().equals(dimNumber) ? RangeEnum.ALL_EXCLUDE.getIndex() : RangeEnum.ALL.getIndex();
                Member rootMember = this.getModelCacheHelper().getRootMember(dimNumber, this.getDimensionViews().get(dimNumber));
                members = DiffAnalyzeHelper.fromCacheMembers(DiffAnalyzeHelper.getMember(this.getDatasetId(), this.getModelCacheHelper(), this.getMemberPerm(), dimNumber, this.getDimensionViews().get(dimNumber), rootMember.getNumber(), range));
            }
            if (members == null || members.isEmpty()) {
                return;
            }
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
                this.scheme = this.getSchemeConfig();
                Map configMap = new HashMap(8);
                if (this.scheme != null && kd.bos.util.StringUtils.isNotEmpty((String)this.scheme.getConfigJson())) {
                    configMap = (Map)SerializationUtils.fromJsonString((String)this.scheme.getConfigJson(), Map.class);
                }
                if (configMap.containsKey("ebf7_page_budgetperiod")) {
                    String value = (String)configMap.get("ebf7_page_budgetperiod");
                    if (kd.bos.util.StringUtils.isNotEmpty((String)value)) {
                        List list = (List)SerializationUtils.fromJsonString((String)value, List.class);
                        ArrayList numList = new ArrayList(8);
                        for (Map mem : list) {
                            numList.add(mem.get("number"));
                        }
                        members = members.stream().filter(m -> numList.contains(m.getNumber())).collect(Collectors.toList());
                    }
                } else {
                    members = DiffAnalyzeHelper.defaultCurrentNextYear(members);
                }
            }
        }
        ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
        if (members != null) {
            for (kd.epm.eb.common.model.Member member : members) {
                ListSelectedRow selectedRow = new ListSelectedRow();
                HashMap dataMap = Maps.newHashMapWithExpectedSize((int)4);
                dataMap.put("memberid", member.getId());
                dataMap.put("name", member.getName());
                dataMap.put("number", member.getNumber());
                dataMap.put("scope", member.getRange());
                selectedRow.setDataMap((Map)dataMap);
                listSelectedRows.add((Object)selectedRow);
            }
        }
        if ((multiKey = this.getF7KeyDimMapMul().get(dimNumber)) != null) {
            ClosedCallBackEvent closedCallBackEvent = new ClosedCallBackEvent((Object)this, multiKey, (Object)listSelectedRows);
            this.closedCallBack(closedCallBackEvent);
        }
    }

    public void verify() {
        if (this.getModelId() == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"DiffAnalyzePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (this.getDatasetId() == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u96c6\u3002", (String)"DiffAnalyzePlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (this.getSchemeConfig() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u65b9\u6848\u3002", (String)"DiffAnalyzePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void doubleClickLockedCell(int row, int col) {
    }

    @Override
    public void displayDimInfoOnStatusBar(SpreadSelector selector) {
        StringBuilder cellMsg = new StringBuilder();
        if (selector != null) {
            DiffCellDimMember rowCell;
            int r = selector.getStartRow();
            int c = selector.getStartCol();
            this.spreadManager = this.getSpreadManager();
            int schemeowIndex = this.spreadManager.getSchemeRowIndex();
            ISheet sheet = this.spreadManager.getEbook().getSheet(0);
            List rowCells = this.spreadManager.getRowCellDimMembers();
            List colCells = this.spreadManager.getColCellDimMembers();
            if (rowCells != null && r > 0 && r < rowCells.size() && (rowCell = (DiffCellDimMember)rowCells.get(r)) != null && rowCell.getDimNumber() != null) {
                Member member;
                Dimension dimension;
                DiffCellDimMember colCell;
                this.modelCacheHelper = this.getModelCacheHelper();
                this.dimemsionViews = this.getDimensionViews();
                Stack<String> stack = new Stack<String>();
                HashSet<String> dimNumbers = new HashSet<String>(16);
                if (colCells != null && c > 0 && c < colCells.size() && (colCell = (DiffCellDimMember)colCells.get(c)) != null && colCell.getDimNumber() != null) {
                    ECell schemeCell;
                    dimension = this.modelCacheHelper.getDimension(colCell.getDimNumber());
                    String memNumber = colCell.getMemNumber();
                    if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber()) && (schemeCell = sheet.getECellNotAdd(schemeowIndex, c)) != null && schemeCell.getUserObject("leadPeriod") != null) {
                        memNumber = schemeCell.getUserObject("leadPeriod") + "";
                    }
                    member = this.modelCacheHelper.getMember(colCell.getDimNumber(), this.dimemsionViews.get(colCell.getDimNumber()), memNumber);
                    stack.push((dimension != null ? dimension.getName() : ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"DiffAnalyzePlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[]{colCell.getDimNumber()})) + ":" + (member != null ? member.getName() : ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458%1\u4e0d\u5b58\u5728\u3002", (String)"DiffAnalyzePlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[]{memNumber})));
                    dimNumbers.add(colCell.getDimNumber());
                }
                dimension = this.modelCacheHelper.getDimension(rowCell.getDimNumber());
                member = this.modelCacheHelper.getMember(rowCell.getDimNumber(), this.dimemsionViews.get(rowCell.getDimNumber()), rowCell.getMemNumber());
                stack.push((dimension != null ? dimension.getName() : ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"DiffAnalyzePlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[]{rowCell.getDimNumber()})) + ":" + (member != null ? member.getName() : ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458%1\u4e0d\u5b58\u5728\u3002", (String)"DiffAnalyzePlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[]{rowCell.getMemNumber()})));
                dimNumbers.add(rowCell.getDimNumber());
                if (rowCell.getUpperDimParent() != null) {
                    do {
                        if (dimNumbers.contains((rowCell = rowCell.getUpperDimParent()).getDimNumber())) continue;
                        dimension = this.modelCacheHelper.getDimension(rowCell.getDimNumber());
                        member = this.modelCacheHelper.getMember(rowCell.getDimNumber(), this.dimemsionViews.get(rowCell.getDimNumber()), rowCell.getMemNumber());
                        stack.push((dimension != null ? dimension.getName() : ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"DiffAnalyzePlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[]{rowCell.getDimNumber()})) + ":" + (member != null ? member.getName() : ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458%1\u4e0d\u5b58\u5728\u3002", (String)"DiffAnalyzePlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[]{rowCell.getMemNumber()})));
                        dimNumbers.add(rowCell.getDimNumber());
                    } while (rowCell.getUpperDimParent() != null);
                }
                while (!stack.empty()) {
                    cellMsg.append((String)stack.pop()).append(" ");
                }
            }
        }
        this.getspreadContainer().setDisplayContent("", cellMsg.toString(), "");
    }

    @Override
    public boolean isClickRowDimCell(SpreadSelector selector) {
        return selector.getStartRow() > 1 && selector.getStartCol() == 0;
    }

    @Override
    public boolean isClickColDimCell(SpreadSelector selector) {
        return selector.getStartCol() > 0 && selector.getStartRow() == 0;
    }

    public void cellClick(SpreadSelector selector) {
        if (AdminModelUtil.checkAdminModeNeedResult(this.getModelId(), this.getView())) {
            this.isAdminMode = true;
            return;
        }
        this.handleCellClick(selector);
    }

    @Override
    public List<Dimension> getAllDimension() {
        if (this.allDims == null) {
            this.allDims = this.getModelCacheHelper().getDimensionList(Long.valueOf(this.getDatasetId())).stream().sorted(Comparator.comparingInt(d -> d.getSeq())).collect(Collectors.toList());
        }
        return this.allDims;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String opKey = this.getCache("opKey");
        if (opKey != null && e.getRowDataEntities() != null) {
            CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
            int rowIndex = e.getRowDataEntities()[0].getRowIndex();
            this.getModel().updateCache();
            ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(rowIndex)).set("id", (Object)DBServiceHelper.genGlobalLongId());
            if ("newdataentry".equals(opKey)) {
                ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(rowIndex)).set("col_type", (Object)DataRowEnum.DATA.getIndex());
                this.getModel().setValue("col_name", (Object)ResManager.loadResFormat((String)"\u6570\u503c\u5217%1", (String)"DiffAnalyzePlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[]{rowIndex}), rowIndex);
                cardEntry.setChildVisible(false, rowIndex, new String[]{"col_exprdisplay", "editcol"});
                cardEntry.setChildVisible(false, rowIndex, F7_KEYS_CARD);
                Set<String> schemeDims = this.getSchemeDims();
                if (schemeDims != null && schemeDims.size() > 0) {
                    String[] dimCtrlKeys = new String[schemeDims.size()];
                    String[] dimCtrlOpKeys = new String[schemeDims.size()];
                    int i = 0;
                    for (String dimNumber : schemeDims) {
                        dimCtrlKeys[i++] = this.dimNumber2CtrlKey(dimNumber, 3);
                    }
                    cardEntry.setChildVisible(true, rowIndex, dimCtrlKeys);
                    cardEntry.setChildVisible(true, rowIndex, dimCtrlOpKeys);
                }
            } else if ("newexprentry".equals(opKey)) {
                ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(rowIndex)).set("col_type", (Object)DataRowEnum.CUSTOM.getIndex());
                this.getModel().setValue("col_name", (Object)ResManager.loadResFormat((String)"\u516c\u5f0f\u5217%1", (String)"DiffAnalyzePlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[]{rowIndex}), rowIndex);
                cardEntry.setChildVisible(false, rowIndex, F7_KEYS_CARD);
                cardEntry.setChildVisible(false, rowIndex, new String[]{"col_periodoffset"});
                cardEntry.setChildVisible(false, rowIndex, new String[]{"editcol1"});
                cardEntry.setChildVisible(true, rowIndex, new String[]{"col_exprdisplay"});
            }
        }
    }

    @Override
    public Map<String, String> getF7KeyDimMap() {
        if (this.f7KeyDimMap == null) {
            this.cacheF7KeyDimMap();
        }
        return this.f7KeyDimMap;
    }

    private String dimNumber2CtrlKey(String dimNumber, int ctrlKeyType) {
        this.dimCtrlKeyMap = this.getDimCtrlKeyMap();
        if (this.dimCtrlKeyMap.containsKey(dimNumber)) {
            if (ctrlKeyType == 1) {
                return "ebf7_" + this.dimCtrlKeyMap.get(dimNumber) + "_p";
            }
            if (ctrlKeyType == 2) {
                return "ebf7_" + this.dimCtrlKeyMap.get(dimNumber) + "_p1";
            }
            if (ctrlKeyType == 3) {
                return "col_" + this.dimCtrlKeyMap.get(dimNumber);
            }
        } else {
            throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u4e0d\u5b58\u5728\u3002", (String)"DiffAnalyzePlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[]{dimNumber}));
        }
        return null;
    }

    private Map<String, String> getF7KeyDimMap2() {
        if (this.f7KeyDimMap2 == null) {
            this.cacheF7KeyDimMap();
        }
        return this.f7KeyDimMap2;
    }

    @Override
    public Map<String, String> getF7KeyDimMapMul() {
        if (this.f7KeyDimMapMul == null) {
            this.cacheF7KeyDimMap();
        }
        return this.f7KeyDimMapMul;
    }

    @Override
    public Map<String, String> getF7KeyDimMapPage() {
        if (this.f7KeyDimMapPage == null) {
            this.cacheF7KeyDimMap();
        }
        return this.f7KeyDimMapPage;
    }

    protected Set<String> displaySchemeConfig(DynamicObject dynamicObject) {
        if (dynamicObject != null) {
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            if (entryentity == null || entryentity.isEmpty()) {
                return Collections.emptySet();
            }
            IDataModel dataModel = this.getModel();
            this.modelCacheHelper = this.getModelCacheHelper();
            String schemeConfigJson = dynamicObject.getString("configjson");
            HashMap<String, String> schemeConfigMap = kd.bos.util.StringUtils.isNotEmpty((String)schemeConfigJson) ? (Map)SerializationUtils.fromJsonString((String)schemeConfigJson, Map.class) : new HashMap(16);
            this.setPageF7(schemeConfigMap);
            List<String> switchColDims = this.getSwitchColDims();
            String defColDimension = (String)schemeConfigMap.get("def_col_dimension");
            if (defColDimension == null) {
                defColDimension = SysDimensionEnum.BudgetPeriod.getNumber();
            }
            this.updateByWhichDimLabels();
            this.updateByWhichDimLabel(defColDimension);
            if (switchColDims.contains(defColDimension) && !defColDimension.equals(this.getCurrentColDimension())) {
                new SwitchColDimensionCommand(defColDimension, defColDimension, RangeEnum.DIRECTSUB_EXCLUDE.getIndex(), this.getSpreadManager()).execute(this);
                this.refreshSpread();
            }
            int size = entryentity.size();
            this.dimCtrlKeyMap = this.getDimCtrlKeyMap();
            this.colIndexNameMap = this.cacheColIndexNameMap(entryentity, true, true);
            HashSet<Integer> dataRows = new HashSet<Integer>(16);
            HashSet<Integer> exprRows = new HashSet<Integer>(16);
            HashSet<String> visibleKeys = new HashSet<String>(16);
            HashSet<String> schemeDims = new HashSet<String>(16);
            Set allDimNumbers = this.getAllDimension().stream().map(e -> e.getNumber()).collect(Collectors.toSet());
            dataModel.deleteEntryData("entryentity");
            dataModel.beginInit();
            dataModel.batchCreateNewEntryRow("entryentity", size);
            for (int i = 0; i < size; ++i) {
                DynamicObject entry = (DynamicObject)entryentity.get(i);
                int coltype = entry.getInt("coltype");
                dataModel.setValue("col_type", (Object)coltype, i);
                dataModel.setValue("col_name", (Object)entry.getString("colname"), i);
                String colconfigjson = entry.getString("colconfigjson");
                String entryId = entry.getString("id");
                dataModel.getEntryRowEntity("entryentity", i).set("id", (Object)entryId);
                Map colConfigMap = null;
                colConfigMap = kd.bos.util.StringUtils.isEmpty((String)colconfigjson) ? new HashMap(1) : (Map)SerializationUtils.fromJsonString((String)colconfigjson, Map.class);
                if (DataRowEnum.DATA.getIndex() == coltype) {
                    dataRows.add(i);
                    for (Map.Entry e2 : colConfigMap.entrySet()) {
                        Member member;
                        if ("_PERIOD_OFFSET".equals(e2.getKey()) && e2.getValue() != null) {
                            String offsetValue = ((String)e2.getValue()).replaceAll("Y", "").replaceAll("Q", "").replaceAll("M", "");
                            dataModel.setValue("col_periodoffset", (Object)offsetValue, i);
                            continue;
                        }
                        String dimNumber = (String)e2.getKey();
                        String memNumber = (String)e2.getValue();
                        if (!allDimNumbers.contains(dimNumber)) continue;
                        String ctrlKey_f7 = this.dimNumber2CtrlKey(dimNumber, 3);
                        String ctrlKey_f7card = this.dimNumber2CtrlKey(dimNumber, 3);
                        if ("_SECOND_PAGE".equals(memNumber)) {
                            dataModel.setValue(ctrlKey_f7, null, i);
                            visibleKeys.add(ctrlKey_f7card);
                            schemeDims.add(dimNumber);
                            continue;
                        }
                        if (e2.getValue() == null || ((String)e2.getKey()).startsWith("_DIMVIEW_")) continue;
                        String viewId = (String)colConfigMap.get("_DIMVIEW_" + dimNumber);
                        if (viewId != null) {
                            if (IDUtils.isNotNull((Long)IDUtils.toLong((Object)viewId))) {
                                boolean exists = QueryServiceHelper.exists((String)"eb_dimensionview", (Object)viewId);
                                if (exists) {
                                    member = this.modelCacheHelper.getMember(dimNumber, IDUtils.toLong((Object)viewId), memNumber);
                                    String key = dimNumber + "_" + entryId;
                                    this.cacheEntryDimensionViews(key, IDUtils.toLong((Object)viewId));
                                } else {
                                    member = this.modelCacheHelper.getMember(dimNumber, null, memNumber);
                                }
                            } else {
                                member = this.modelCacheHelper.getMember(dimNumber, null, memNumber);
                            }
                        } else {
                            member = this.modelCacheHelper.getMember(dimNumber, null, memNumber);
                        }
                        if (member != null && !this.getMemberPerm().isNoperm(dimNumber, memNumber, IDUtils.toLong((Object)viewId))) {
                            dataModel.setValue(ctrlKey_f7, (Object)member.getId(), i);
                        }
                        visibleKeys.add(ctrlKey_f7card);
                        schemeDims.add(dimNumber);
                    }
                    continue;
                }
                if (DataRowEnum.CUSTOM.getIndex() != coltype) continue;
                exprRows.add(i);
                String expr = (String)colConfigMap.get("_EXPRESSION");
                String expr_disp = (String)colConfigMap.get("_EXPRESSION_DISP");
                String fm = (String)colConfigMap.get("_DISP_FORMAT");
                dataModel.setValue("col_expr", (Object)expr, i);
                dataModel.setValue("col_exprdisplay", (Object)expr_disp, i);
                dataModel.setValue("col_type", (Object)DataRowEnum.CUSTOM.getIndex(), i);
                dataModel.setValue("col_fm", (Object)fm, i);
            }
            dataModel.endInit();
            CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
            for (Integer r : exprRows) {
                cardEntry.setChildVisible(false, r.intValue(), F7_KEYS_CARD);
                cardEntry.setChildVisible(false, r.intValue(), new String[]{"col_periodoffset"});
                cardEntry.setChildVisible(true, r.intValue(), new String[]{"col_exprdisplay", "editcol"});
                cardEntry.setChildVisible(false, r.intValue(), new String[]{"editcol1"});
            }
            for (Integer r : dataRows) {
                cardEntry.setChildVisible(false, r.intValue(), F7_KEYS_CARD);
                cardEntry.setChildVisible(false, r.intValue(), new String[]{"col_exprdisplay", "editcol"});
                cardEntry.setChildVisible(true, r.intValue(), new String[]{"editcol1"});
                cardEntry.setChildVisible(true, r.intValue(), visibleKeys.toArray(new String[0]));
            }
            this.getView().updateView("entryentity");
            return schemeDims;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u6682\u65e0\u5206\u6790\u65b9\u6848\uff0c\u52a0\u8f7d\u5931\u8d25\u3002", (String)"DiffAnalyzePlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void setPageF7(Map<String, String> schemeConfigMap) {
        Label label;
        String rowDimension;
        if (schemeConfigMap == null) {
            schemeConfigMap = new HashMap<String, String>(16);
        }
        if ((rowDimension = schemeConfigMap.get("row_dimension")) == null) {
            rowDimension = SysDimensionEnum.Account.getNumber();
        }
        if ((label = (Label)this.getView().getControl(LABEL_ROWDIMENSION)) != null) {
            label.setText(this.getDimNamesMap().get(rowDimension));
        }
        this.setPageItem(schemeConfigMap.get("TOP_ITEMS"), rowDimension, "account_range", schemeConfigMap.get(rowDimension + "viewId"));
        Set f7KeysDimPool = Arrays.stream(F7_KEYS_DIMPOOL).collect(Collectors.toSet());
        Set allDimNumbers = this.getAllDimension().stream().map(e -> e.getNumber()).collect(Collectors.toSet());
        for (Map.Entry<String, String> entry : schemeConfigMap.entrySet()) {
            String dimNumber;
            if (!entry.getKey().startsWith("ebf7_page_")) continue;
            String ctrlKey = entry.getKey();
            if (f7KeysDimPool.contains(ctrlKey)) {
                dimNumber = this.getF7KeyDimMapPage().get(ctrlKey);
                this.setPageItem(entry.getValue(), dimNumber, ctrlKey, schemeConfigMap.get(dimNumber + "viewId"));
                continue;
            }
            dimNumber = null;
            String dimNumber_lowerCase = ctrlKey.replaceAll("ebf7_page_", "");
            for (String d : allDimNumbers) {
                if (!d.toLowerCase(Locale.ROOT).equals(dimNumber_lowerCase)) continue;
                dimNumber = d;
            }
            if (dimNumber == null) continue;
            ctrlKey = "ebf7_page_" + this.getDimCtrlKeyMap().get(dimNumber);
            this.setPageItem(entry.getValue(), dimNumber, ctrlKey, schemeConfigMap.get(dimNumber + "viewId"));
        }
    }

    private void setPageItem(String config, String dimNumber, String pageItem, String viewId) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(8);
        if (kd.bos.util.StringUtils.isNotEmpty((String)config)) {
            if (this.isJson(config)) {
                List membList = (List)SerializationUtils.fromJsonString((String)config, List.class);
                for (Map memb : membList) {
                    Member cacheMember;
                    if (!kd.bos.util.StringUtils.isNotEmpty((String)((String)memb.get("number")))) continue;
                    if (kd.bos.util.StringUtils.isNotEmpty((String)viewId)) {
                        boolean exists = QueryServiceHelper.exists((String)"eb_dimensionview", (Object)IDUtils.toLong((Object)viewId));
                        if (exists) {
                            cacheMember = this.modelCacheHelper.getMember(dimNumber, IDUtils.toLong((Object)viewId), (String)memb.get("number"));
                            this.cacheDimensionViews(dimNumber, IDUtils.toLong((Object)viewId));
                        } else {
                            cacheMember = this.modelCacheHelper.getMember(dimNumber, null, (String)memb.get("number"));
                        }
                    } else {
                        cacheMember = this.modelCacheHelper.getMember(dimNumber, null, (String)memb.get("number"));
                    }
                    if (cacheMember == null) continue;
                    HashMap<String, String> map = new HashMap<String, String>(8);
                    map.put("id", String.valueOf(cacheMember.getId()));
                    map.put("scope", (String)memb.get("scope"));
                    map.put("number", cacheMember.getNumber());
                    map.put("name", cacheMember.getName());
                    map.put("pid", String.valueOf(cacheMember.getId()));
                    list.add(map);
                }
            } else {
                String[] topItem_split;
                for (String item : topItem_split = config.split(",")) {
                    Member cacheMember;
                    if (!kd.bos.util.StringUtils.isNotEmpty((String)item) || (cacheMember = this.modelCacheHelper.getMember(this.getCurrentRowDimension(), IDUtils.toLong((Object)viewId), item)) == null) continue;
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    map.put("id", String.valueOf(cacheMember.getId()));
                    map.put("scope", RangeEnum.ALL.getIndex() + "");
                    map.put("number", cacheMember.getNumber());
                    map.put("name", cacheMember.getName());
                    map.put("pid", String.valueOf(cacheMember.getId()));
                    list.add(map);
                }
            }
        }
        DiffAnalyzeHelper.setMultiSelectF7Value(list, pageItem, this.getView());
    }

    private boolean isJson(String config) {
        boolean result = false;
        if (config.startsWith("{") && config.endsWith("}")) {
            result = true;
        } else if (config.startsWith("[") && config.endsWith("]")) {
            result = true;
        }
        return result;
    }

    private Map<String, String> getDimNamesMap() {
        if (this.dimNamesMap == null) {
            this.cacheF7KeyDimMap();
        }
        return this.dimNamesMap;
    }

    private String[] getTopItems() {
        String accountRoot = this.getAccountRoot();
        if (kd.bos.util.StringUtils.isNotEmpty((String)accountRoot)) {
            return new String[]{accountRoot};
        }
        this.scheme = this.getSchemeConfig();
        if (this.scheme != null && kd.bos.util.StringUtils.isNotEmpty((String)this.scheme.getConfigJson())) {
            Map configMap = (Map)SerializationUtils.fromJsonString((String)this.scheme.getConfigJson(), Map.class);
            String topItems = (String)configMap.get("TOP_ITEMS");
            String currentRowDim = this.getCurrentRowDimension();
            String configRowDim = (String)configMap.get("row_dimension");
            if (kd.bos.util.StringUtils.isNotEmpty((String)topItems) && currentRowDim != null && currentRowDim.equals(configRowDim)) {
                String[] items;
                if (this.isJson(topItems)) {
                    ArrayList item = new ArrayList(8);
                    List topMap = (List)SerializationUtils.fromJsonString((String)topItems, List.class);
                    for (Map stringStringMap : topMap) {
                        item.add(stringStringMap.get("number"));
                    }
                    items = item.toArray(new String[0]);
                } else {
                    items = topItems.split(",");
                }
                if (items.length > 0) {
                    String s = (String)configMap.get(currentRowDim + "viewId");
                    List members = this.getModelCacheHelper().getMembers(currentRowDim, IDUtils.toLong((Object)s), Arrays.asList(items));
                    if (CollectionUtils.isEmpty((Collection)members)) {
                        this.scheme.getConfig().setTopItems(null);
                        this.getPageCache().put("scheme_config_cache_key", SerializationUtils.serializeToBase64((Object)this.scheme));
                        return null;
                    }
                    if (IDUtils.isNotNull((Long)IDUtils.toLong((Object)s))) {
                        this.cacheDimensionViews(currentRowDim, IDUtils.toLong((Object)s));
                    }
                }
                return items;
            }
        }
        return null;
    }

    @Override
    public DiffAnalyzeScheme getSchemeConfig() {
        if (this.scheme == null) {
            String str = this.getCache("scheme_config_cache_key");
            if (kd.bos.util.StringUtils.isNotEmpty((String)str)) {
                this.scheme = (DiffAnalyzeScheme)SerializationUtils.deSerializeFromBase64((String)str);
            }
            if (this.scheme == null) {
                DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("analyzescheme");
                if (dynamicObject == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u65b9\u6848\u3002", (String)"DiffAnalyzePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getLong("id"), (String)"eb_diffanalyzescheme");
                if (object == null) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u672a\u627e\u5230\u5206\u6790\u65b9\u6848\uff1a%1\u3002", (String)"DiffAnalyzePlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[]{dynamicObject.getString("name")}));
                }
                this.scheme = DiffAnalyzeHelper.dynamicObject2SchemeObject(object);
                if (this.scheme == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u65b9\u6848\u3002", (String)"DiffAnalyzePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                this.setCache("scheme_config_cache_key", SerializationUtils.serializeToBase64((Object)this.scheme));
            }
        }
        return this.scheme;
    }

    @Override
    public Map<String, String> getDimCtrlKeyMap() {
        if (this.dimCtrlKeyMap == null) {
            this.cacheF7KeyDimMap();
        }
        return this.dimCtrlKeyMap;
    }

    private void cacheF7KeyDimMap() {
        String str_f7KeyDimMap = this.getCache("f7KeyDimMap");
        String str_f7KeyDimMapMul = this.getCache("f7KeyDimMapMul");
        String str_f7KeyDimMapPage = this.getCache("f7KeyDimMapPage");
        String str_f7KeyDimMap2 = this.getCache("f7KeyDimMap2");
        String str_dimNamesMap = this.getCache("dimNamesMap");
        String str_dimCtrlKeyMap = this.getCache("dimCtrlKeyMap");
        if (str_f7KeyDimMap != null) {
            this.f7KeyDimMap = (Map)SerializationUtils.fromJsonString((String)str_f7KeyDimMap, Map.class);
            this.f7KeyDimMapMul = (Map)SerializationUtils.fromJsonString((String)str_f7KeyDimMapMul, Map.class);
            this.f7KeyDimMapPage = (Map)SerializationUtils.fromJsonString((String)str_f7KeyDimMapPage, Map.class);
            this.f7KeyDimMap2 = (Map)SerializationUtils.fromJsonString((String)str_f7KeyDimMap2, Map.class);
            this.dimNamesMap = (Map)SerializationUtils.fromJsonString((String)str_dimNamesMap, Map.class);
            this.dimCtrlKeyMap = (Map)SerializationUtils.fromJsonString((String)str_dimCtrlKeyMap, Map.class);
        } else {
            this.f7KeyDimMap = new HashMap<String, String>(this.getAllDimension().size());
            this.f7KeyDimMapMul = new HashMap<String, String>(this.getAllDimension().size());
            this.f7KeyDimMapPage = new HashMap<String, String>(this.getAllDimension().size());
            this.f7KeyDimMap2 = new HashMap<String, String>(this.getAllDimension().size());
            this.dimNamesMap = new HashMap<String, String>(this.getAllDimension().size());
            this.dimCtrlKeyMap = new HashMap<String, String>(this.getAllDimension().size());
            int customIndex = 1;
            for (Dimension dimension : this.getAllDimension()) {
                String f7Key2;
                String f7Key_page;
                String f7Key_mul;
                String f7Key;
                String dimNumber = dimension.getNumber();
                this.dimNamesMap.put(dimNumber, dimension.getName());
                if (dimension.isPreset()) {
                    f7Key = "ebf7_" + dimNumber.toLowerCase() + "_p";
                    f7Key_mul = "ebf7_" + dimNumber.toLowerCase() + "_mul";
                    f7Key_page = "ebf7_page_" + dimNumber.toLowerCase();
                    f7Key2 = "ebf7_" + dimNumber.toLowerCase() + "_p1";
                    this.f7KeyDimMap.put(dimNumber, f7Key);
                    this.f7KeyDimMap.put(f7Key, dimNumber);
                    this.f7KeyDimMapMul.put(dimNumber, f7Key_mul);
                    this.f7KeyDimMapMul.put(f7Key_mul, dimNumber);
                    this.f7KeyDimMapPage.put(dimNumber, f7Key_page);
                    this.f7KeyDimMapPage.put(f7Key_page, dimNumber);
                    this.f7KeyDimMap2.put(dimNumber, f7Key2);
                    this.f7KeyDimMap2.put(f7Key2, dimNumber);
                    this.dimCtrlKeyMap.put(dimNumber, dimNumber.toLowerCase());
                    this.dimCtrlKeyMap.put(dimNumber.toLowerCase(), dimNumber);
                    continue;
                }
                f7Key = "ebf7_customize" + customIndex + "_p";
                f7Key_mul = "ebf7_customize" + customIndex + "_mul";
                f7Key_page = "ebf7_page_customize" + customIndex;
                f7Key2 = "ebf7_customize" + customIndex + "_p1";
                this.f7KeyDimMap.put(dimNumber, f7Key);
                this.f7KeyDimMap.put(f7Key, dimNumber);
                this.f7KeyDimMapMul.put(dimNumber, f7Key_mul);
                this.f7KeyDimMapMul.put(f7Key_mul, dimNumber);
                this.f7KeyDimMapPage.put(dimNumber, f7Key_page);
                this.f7KeyDimMapPage.put(f7Key_page, dimNumber);
                this.f7KeyDimMap2.put(dimNumber, f7Key2);
                this.f7KeyDimMap2.put(f7Key2, dimNumber);
                this.dimCtrlKeyMap.put(dimNumber, "customize" + customIndex);
                this.dimCtrlKeyMap.put("customize" + customIndex, dimNumber);
                ++customIndex;
            }
            this.setCache("f7KeyDimMap", SerializationUtils.toJsonString(this.f7KeyDimMap));
            this.setCache("f7KeyDimMapMul", SerializationUtils.toJsonString(this.f7KeyDimMapMul));
            this.setCache("f7KeyDimMapPage", SerializationUtils.toJsonString(this.f7KeyDimMapPage));
            this.setCache("f7KeyDimMap2", SerializationUtils.toJsonString(this.f7KeyDimMap2));
            this.setCache("dimNamesMap", SerializationUtils.toJsonString(this.dimNamesMap));
            this.setCache("dimCtrlKeyMap", SerializationUtils.toJsonString(this.dimCtrlKeyMap));
        }
    }

    private void clearF7KeyDimMapCache() {
        this.f7KeyDimMap = null;
        this.dimNamesMap = null;
        this.dimCtrlKeyMap = null;
        this.getPageCache().remove("f7KeyDimMap");
        this.getPageCache().remove("dimNamesMap");
        this.getPageCache().remove("dimCtrlKeyMap");
    }

    @Override
    public IModelCacheHelper getModelCacheHelper() {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        }
        return this.modelCacheHelper;
    }

    @Override
    public long getDatasetId() {
        if (this.datasetID != null) {
            return this.datasetID;
        }
        if (this.getModel().getValue("dataset") != null) {
            return ((DynamicObject)this.getModel().getValue("dataset")).getLong("id");
        }
        return 0L;
    }

    private void setDatasetId(Long datasetId) {
        this.datasetID = datasetId;
        this.getModel().setValue("dataset", (Object)datasetId);
    }

    @Override
    public long getBusModelId() {
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("dataset");
        if (dynamicObject != null) {
            return dynamicObject.getLong("businessmodel.id");
        }
        return 0L;
    }

    public void click(EventObject evt) {
        String key;
        if (this.check()) {
            return;
        }
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_ok": {
                this.clickBtnOK();
                break;
            }
            case "icon_hidepagedim": 
            case "icon_showpagedim": {
                this.hideshowPageDimPanel(key);
                break;
            }
            case "editcol": 
            case "account_range": {
                new ShowFormCommand(key).execute(this);
                break;
            }
            default: {
                String dimNumber;
                if (!this.isF7Key(key) || !kd.bos.util.StringUtils.isNotEmpty((String)(dimNumber = this.getCurrentDimNumber(key)))) break;
                Long modelId = this.getModelId();
                MemberF7Parameter f8Param = NewF7Utils.multipleF8((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)DynamicObject.class.getName());
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(new QFilter("model", "=", (Object)modelId));
                FormShowParameter showParameter = new FormShowParameter();
                if (SysDimensionEnum.AuditTrail.getNumber().equals(dimNumber)) {
                    f8Param.setShowNotEnable(true);
                    f8Param.setHideDecompose(false);
                } else if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                    f8Param.setDatasetId(Long.valueOf(this.getDatasetId()));
                } else if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
                    qFilters.add(new QFilter("dataType", "in", (Object)Sets.newHashSet((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex()})));
                }
                ArrayList<MemberCondition> memberConditions = new ArrayList<MemberCondition>(8);
                String cacheValue = this.getPageCache().get(key);
                if (kd.bos.util.StringUtils.isNotEmpty((String)cacheValue)) {
                    List members = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
                    for (Map member : members) {
                        MemberCondition memberCondition = new MemberCondition();
                        memberCondition.setId(String.valueOf(member.get("id")));
                        memberCondition.setName((String)member.get("name"));
                        memberCondition.setNumber((String)member.get("number"));
                        memberCondition.setRange((String)member.get("scope"));
                        memberConditions.add(memberCondition);
                    }
                }
                Map<String, Object> config = this.getConfigMap();
                this.getConList(memberConditions, config, key);
                Long viewId = 0L;
                if (DimensionViewServiceHelper.hasView((String)dimNumber)) {
                    List viewGroupViewsByDataSetAndDimNumber;
                    viewId = IDUtils.toLong((Object)this.getPageCache().get(dimNumber + "viewId"));
                    if (IDUtils.isNull((Long)viewId)) {
                        viewId = IDUtils.toLong((Object)config.get(dimNumber + "viewId"));
                    }
                    if (IDUtils.isNotNull((Long)viewId) && !(viewGroupViewsByDataSetAndDimNumber = this.getModelCacheHelper().getViewGroupViewsByDataSetAndDimNumber(Long.valueOf(this.getDatasetId()), dimNumber)).contains(viewId)) {
                        viewId = this.getModelCacheHelper().getViewByDataSetAndDimNumber(Long.valueOf(this.getDatasetId()), dimNumber);
                    }
                }
                f8Param.setBusModelId(Long.valueOf(this.getBusModelId()));
                if (IDUtils.isNotNull((Long)viewId)) {
                    f8Param.setViewId(viewId);
                }
                f8Param.setEnableView(true);
                f8Param.setVerifyPermission(true);
                List after = NewF7Utils.filterF7Param(qFilters);
                if (!after.isEmpty()) {
                    f8Param.addCustomCommFilter(after);
                }
                if (CollectionUtils.isNotEmpty(memberConditions)) {
                    CustomF7utils.loadSelectedData(memberConditions, (MemberF7Parameter)f8Param, (Dimension)this.getModelCacheHelper().getDimension(dimNumber));
                }
                if (kd.bos.util.StringUtils.isNotEmpty((String)key)) {
                    f8Param.setViewSign(key);
                    CustomF7utils.loadCacheSelectedData((IFormView)this.getView(), (MemberF7Parameter)f8Param);
                }
                if (!this.isEditSchemeMode()) {
                    this.addFilterByScheme(dimNumber, f8Param);
                }
                NewF7Utils.openF8((IFormView)this.getView(), (MemberF7Parameter)f8Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, key));
            }
        }
    }

    private void clickBtnOK() {
        this.refreshSpread();
    }

    private List<MemberCondition> getConList(List<MemberCondition> memberConditions, Map<String, Object> config, String key) {
        String f7key = this.getF7KeyDimMapMul().get("ebf7_page_" + this.getF7KeyDimMapMul().get(key));
        if (config.containsKey(f7key)) {
            List valueList = null;
            Object value = config.get(f7key);
            if (value instanceof String) {
                valueList = (List)SerializationUtils.fromJsonString((String)((String)value), List.class);
            } else if (value instanceof List) {
                valueList = (List)value;
            }
            if (valueList != null) {
                for (Map mem : valueList) {
                    MemberCondition memberCondition = new MemberCondition();
                    memberCondition.setId((String)mem.get("id"));
                    memberCondition.setNumber((String)mem.get("number"));
                    memberCondition.setName((String)mem.get("name"));
                    memberCondition.setRange((String)mem.get("scope"));
                    memberConditions.add(memberCondition);
                }
            }
        }
        return memberConditions;
    }

    @Override
    public Map<String, Long> getDimensionViews() {
        Map viewsByDataSet;
        if (this.dimemsionViews == null) {
            String str = this.getCache("dimemsionViews");
            if (kd.bos.util.StringUtils.isNotEmpty((String)str)) {
                this.dimemsionViews = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
            }
            if (this.dimemsionViews == null) {
                this.dimemsionViews = this.getSpreadManager().getDimemsionViews();
            }
        }
        if (CollectionUtils.isEmpty(this.dimemsionViews) && (viewsByDataSet = this.getModelCacheHelper().getViewsByDataSet(Long.valueOf(this.getDatasetId()))) != null) {
            for (Map.Entry dimView : viewsByDataSet.entrySet()) {
                this.dimemsionViews.put((String)dimView.getKey(), (Long)dimView.getValue());
            }
        }
        return this.dimemsionViews;
    }

    private void cacheDimensionViews(String key, Long viewId) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)key)) {
            this.dimemsionViews = this.getDimensionViews();
            if (this.dimemsionViews == null) {
                this.dimemsionViews = new HashMap<String, Long>(16);
            }
            if (viewId != null && viewId != 0L) {
                this.dimemsionViews.put(key, viewId);
            } else {
                this.dimemsionViews.remove(key);
            }
            this.setCache("dimemsionViews", SerializationUtils.toJsonString(this.dimemsionViews));
        }
    }

    @Override
    public Map<String, Long> getEntryDimensionViews() {
        if (this.entryDimemsionViews != null) {
            return this.entryDimemsionViews;
        }
        String str = this.getCache("entryDimemsionViews");
        if (kd.bos.util.StringUtils.isNotEmpty((String)str)) {
            this.entryDimemsionViews = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        }
        if (this.entryDimemsionViews == null) {
            this.entryDimemsionViews = new HashMap<String, Long>(16);
        }
        return this.entryDimemsionViews;
    }

    private void cacheEntryDimensionViews(String key, Long viewId) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)key)) {
            this.entryDimemsionViews = this.getEntryDimensionViews();
            if (this.entryDimemsionViews == null) {
                this.entryDimemsionViews = new HashMap<String, Long>(16);
            }
            if (viewId != null && viewId != 0L) {
                this.entryDimemsionViews.put(key, viewId);
            } else {
                this.entryDimemsionViews.remove(key);
            }
            this.setCache("entryDimemsionViews", SerializationUtils.toJsonString(this.entryDimemsionViews));
        }
    }

    @Override
    public Map<String, String> getColIndexNameMap() {
        if (this.colIndexNameMap == null) {
            this.cacheColIndexNameMap(this.getModel().getEntryEntity("entryentity"), false, true);
            String str = this.getCache("colIndexNameMap");
            String str2 = this.getCache("colNameIndexMap");
            if (kd.bos.util.StringUtils.isNotEmpty((String)str)) {
                this.colIndexNameMap = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
                this.colNameIndexMap = (Map)SerializationUtils.fromJsonString((String)str2, Map.class);
            }
        }
        return this.colIndexNameMap;
    }

    private Map<String, String> cacheColIndexNameMap(DynamicObjectCollection entryentity, boolean isFromDB, boolean isOnlyDataCol) {
        if (entryentity != null) {
            this.colIndexNameMap = new HashMap<String, String>(16);
            this.colNameIndexMap = new HashMap<String, String>(16);
            String colName = isFromDB ? "colname" : "col_name";
            String colType = isFromDB ? "coltype" : "col_type";
            for (DynamicObject entry : entryentity) {
                if (isOnlyDataCol && entry.getInt(colType) != DataRowEnum.DATA.getIndex()) continue;
                this.colNameIndexMap.put(entry.getString(colName), entry.getString("id"));
                this.colIndexNameMap.put(entry.getString("id"), entry.getString(colName));
            }
            this.setCache("colIndexNameMap", SerializationUtils.toJsonString(this.colIndexNameMap));
            this.setCache("colNameIndexMap", SerializationUtils.toJsonString(this.colNameIndexMap));
        } else {
            this.setCache("colIndexNameMap", null);
            this.setCache("colNameIndexMap", null);
            this.colIndexNameMap = null;
            this.colNameIndexMap = null;
        }
        return this.colIndexNameMap;
    }

    private void clearCacheColIndexNameMap() {
        this.cacheColIndexNameMap(null, false, false);
    }

    private Map<String, String> rebuildExpression() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity == null) {
            return null;
        }
        this.colIndexNameMap = this.cacheColIndexNameMap(entryEntity, false, true);
        Set<String> validCols = null;
        if (this.colIndexNameMap != null) {
            validCols = this.colIndexNameMap.keySet().stream().map(e -> "A" + e).collect(Collectors.toSet());
        }
        int size = entryEntity.size();
        for (int i = 0; i < size; ++i) {
            String expr;
            if (((DynamicObject)entryEntity.get(i)).getInt("col_type") == DataRowEnum.DATA.getIndex() || !kd.bos.util.StringUtils.isNotEmpty((String)(expr = ((DynamicObject)entryEntity.get(i)).getString("col_expr")))) continue;
            this.getModel().setValue("col_expr", (Object)DiffAnalyzeHelper.updateExpression(expr, validCols), i);
            this.getModel().setValue("col_exprdisplay", (Object)DiffAnalyzeHelper.updateExpressionDisplay(expr, this.colIndexNameMap, "A"), i);
        }
        return this.colIndexNameMap;
    }

    private boolean checkColReference(String colIndex) {
        if (kd.bos.util.StringUtils.isNotEmpty((String)colIndex)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            int size = entryEntity.size();
            for (int i = 0; i < size; ++i) {
                String expr;
                if (((DynamicObject)entryEntity.get(i)).getInt("col_type") == DataRowEnum.DATA.getIndex() || !kd.bos.util.StringUtils.isNotEmpty((String)(expr = ((DynamicObject)entryEntity.get(i)).getString("col_expr"))) || expr.indexOf(colIndex) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object oldVal = e.getChangeSet()[0].getOldValue();
        Object newVal = e.getChangeSet()[0].getNewValue();
        if ("dataset".equals(key) && newVal != null) {
            this.setDatasetId(((DynamicObject)newVal).getLong("id"));
            if (oldVal instanceof DynamicObject && ((DynamicObject)oldVal).getLong("businessmodel_id") != ((DynamicObject)newVal).getLong("businessmodel_id")) {
                this.clearCacheF7Select(null);
            }
            this.setCachedRowDimension(null);
            this.cacheSchemeDims(null);
            this.resetSpreadManager();
            this.clearCachedSchemeConfig();
            this.initDimensionViewsFromDataSet();
            this.initDimensionViewsFromSchemeConfig();
            this.refreshPageViewPanel(true);
            this.refreshSpread();
        } else if ("model".equals(key)) {
            if (newVal == null && oldVal != null) {
                if (oldVal instanceof DynamicObject) {
                    EntityUtils.setDataWithOutPropertychanged((IDataModel)this.getModel(), (String)key, (Object)((DynamicObject)oldVal).getLong("id"));
                } else {
                    EntityUtils.setDataWithOutPropertychanged((IDataModel)this.getModel(), (String)key, (Object)IDUtils.toLong((Object)oldVal));
                }
                this.getView().updateView(key);
                return;
            }
            if (newVal instanceof DynamicObject) {
                Long modelId = ((DynamicObject)newVal).getLong("id");
                this.setCache("KEY_MODEL_ID", String.valueOf(modelId));
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
                this.clearCacheF7Select(null);
                DynamicObject defaultDS = DataSetServiceHelper.loadDefault((Long)modelId);
                Long defaultDSId = defaultDS.getLong("id");
                List<DynamicObject> defaultSchemes = DiffAnalyzeHelper.ensureDefaultSchemes(modelId);
                DynamicObject defaultScheme = null;
                if (defaultSchemes != null) {
                    for (DynamicObject dynamicObject : defaultSchemes) {
                        if (defaultDSId.longValue() != dynamicObject.getLong("dataset")) continue;
                        defaultScheme = dynamicObject;
                        break;
                    }
                }
                if (defaultScheme == null) {
                    defaultScheme = DiffAnalyzeHelper.getOrCreateDefaultSchemeConfig(this.getModelId(), defaultDS != null ? defaultDS.getLong("id") : 0L);
                }
                if (defaultScheme != null) {
                    this.getModel().setValue("analyzescheme", (Object)defaultScheme.getLong("id"));
                }
            }
        } else if ("analyzescheme".equals(key)) {
            if (newVal == null && oldVal != null) {
                if (oldVal instanceof DynamicObject) {
                    EntityUtils.setDataWithOutPropertychanged((IDataModel)this.getModel(), (String)key, (Object)((DynamicObject)oldVal).getLong("id"));
                } else {
                    EntityUtils.setDataWithOutPropertychanged((IDataModel)this.getModel(), (String)key, (Object)IDUtils.toLong((Object)oldVal));
                }
                this.getView().updateView(key);
                return;
            }
            if (newVal instanceof DynamicObject) {
                this.clearCachedSchemeConfig();
                long dsBefore = this.getDatasetId();
                Long datasetid = ((DynamicObject)newVal).getLong("dataset.id");
                boolean isDsChanged = datasetid != null && datasetid != dsBefore;
                this.getModel().setValue("dataset", (Object)datasetid);
                if (!isDsChanged) {
                    this.cacheSchemeDims(null);
                    this.resetSpreadManager();
                    this.initDimensionViewsFromDataSet();
                    this.initDimensionViewsFromSchemeConfig();
                    this.refreshPageViewPanel(true);
                    this.refreshSpread();
                }
            }
            this.getView().setEnable(Boolean.valueOf(!this.isEnjoyedScheme()), new String[]{"btn_savescheme"});
        } else if (this.isF7Key(key)) {
            if (key.endsWith("_p1")) {
                String selectRowCache = this.getPageCache().get(SELECTROW_CAHCE);
                if (selectRowCache != null) {
                    int row = Integer.parseInt(selectRowCache);
                    Object colIndex = this.getModel().getValue("col_index1", row);
                    if (colIndex instanceof String) {
                        this.cacheF7Select(key, (String)colIndex, newVal);
                    }
                } else {
                    int[] selecteRows = ((CardEntry)this.getView().getControl("entryentity1")).getSelectRows();
                    if (selecteRows != null && selecteRows.length > 0) {
                        int row = selecteRows[0];
                        Object colIndex = this.getModel().getValue("col_index1", row);
                        if (colIndex instanceof String) {
                            this.cacheF7Select(key, (String)colIndex, newVal);
                        }
                    }
                }
            } else if (key.endsWith("_mul")) {
                this.cacheF7Select(key, null, this.getCache(key));
                if (newVal instanceof String && kd.bos.util.StringUtils.isEmpty((String)((String)newVal))) {
                    EntityUtils.setDataWithOutPropertychanged((IDataModel)this.getModel(), (String)key, (Object)oldVal);
                    this.getView().updateView(key);
                }
            } else if (key.startsWith("ebf7_page_")) {
                if (newVal instanceof String && kd.bos.util.StringUtils.isEmpty((String)((String)newVal))) {
                    this.cacheF7Select(key, null, newVal);
                } else {
                    String cacheValue = this.getCache(key);
                    String currentDimNumber = this.getCurrentDimNumber(key);
                    if (kd.bos.util.StringUtils.isNotEmpty((String)cacheValue) && kd.bos.util.StringUtils.isNotEmpty((String)currentDimNumber)) {
                        Long viewId = IDUtils.toLong((Object)this.getConfigMap().get(currentDimNumber + "viewId"));
                        List list = (List)SerializationUtils.fromJsonString((String)cacheValue, List.class);
                        if (CollectionUtils.isNotEmpty((Collection)list)) {
                            key = "ebf7_" + key.replace("ebf7_page_", "") + "_p";
                            Set<Member> memberSet = DiffAnalyzeHelper.resolveHasPermMember(this.getModelCacheHelper(), this.getBusModelId(), currentDimNumber, viewId, list);
                            if (CollectionUtils.isNotEmpty(memberSet)) {
                                this.cacheF7Select(key, null, memberSet.iterator().next().getId());
                            } else {
                                this.cacheF7Select(key, null, "");
                            }
                        }
                    }
                }
            } else {
                this.cacheF7Select(key, null, newVal);
            }
            if (!this.isEditSchemeMode()) {
                if (key.endsWith("_mul")) {
                    this.clickBtnOK();
                } else {
                    this.getSpreadManager().setCommonDimension(this.getCommonDimension());
                    this.refreshCellData(true);
                }
            }
        } else if ("col_name".equals(key)) {
            this.rebuildExpression();
        } else if ("account_range".equals(key) && (newVal == null || kd.bos.util.StringUtils.isEmpty((String)String.valueOf(newVal)))) {
            this.setCache(key, null);
        }
    }

    protected void initDimensionViewsFromDataSet() {
    }

    private Map<String, Long> getDefaultDimMember(String dimensionNumber, Integer colIndex) {
        if (this.defaultDimMember == null || colIndex != null && !this.defaultDimMember.containsKey(dimensionNumber + colIndex)) {
            String value;
            this.defaultDimMember = new HashMap<String, Long>(16);
            UserRememberEntity userRemember = UserRememberService.getInstance().getUserRemember(this.getUserRememberKey(), this.getKeyGroup());
            Map userRememberMap = new HashMap(16);
            if (userRemember != null && kd.bos.util.StringUtils.isNotEmpty((String)(value = userRemember.getValue()))) {
                userRememberMap = (Map)JSONUtils.parse((String)value, Map.class);
            }
            List<Dimension> dimensionList = this.getAllDimension();
            String dimNumber = null;
            String rowDimension = this.getCurrentRowDimension();
            String colDimension = this.getCurrentColDimension();
            Map memberQuotes = this.getSchemeConfig().getMulF7MemberQuotes();
            for (Dimension dimension : dimensionList) {
                Member member;
                dimNumber = dimension.getNumber();
                if (rowDimension != null && rowDimension.equals(dimNumber) || colDimension != null && colDimension.equals(dimNumber)) continue;
                String key = dimNumber;
                if (dimensionNumber.equals(dimNumber) && colIndex != null) {
                    key = dimNumber + colIndex;
                }
                if (this.defaultDimMember.containsKey(key)) continue;
                Long viewId = IDUtils.toLong((Object)this.getConfigMap().get(dimNumber + "viewId"));
                List memberQuote = (List)memberQuotes.get(dimNumber.toLowerCase(Locale.ROOT));
                String cacheNumber = "";
                if (userRememberMap != null && userRememberMap.containsKey(key)) {
                    cacheNumber = (String)userRememberMap.get(key);
                }
                if (CollectionUtils.isNotEmpty((Collection)memberQuote) && colIndex == null) {
                    Set<Member> memberSet = DiffAnalyzeHelper.resolveHasPermMember(this.getModelCacheHelper(), this.getBusModelId(), dimNumber, viewId, memberQuote);
                    String finalCacheNumber = cacheNumber;
                    Optional<Member> any = memberSet.stream().filter(_member -> Objects.equals(_member.getNumber(), finalCacheNumber)).findAny();
                    member = any.orElseGet(() -> memberSet.isEmpty() ? null : (Member)memberSet.iterator().next());
                } else {
                    member = DiffAnalyzeHelper.getMember(this.getModelCacheHelper(), this.getMemberPerm(), dimNumber, viewId, cacheNumber);
                    if (member == null) {
                        member = this.getDefaultDimMember(dimension);
                    }
                }
                if (member == null) continue;
                this.defaultDimMember.put(key, member.getId());
            }
            if (this.defaultDimMember.containsKey(SysDimensionEnum.Entity.getNumber()) && (userRememberMap == null || !userRememberMap.containsKey(SysDimensionEnum.Currency.getNumber()))) {
                try (DataSet ds = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)"epm"), (String)"select fcurrencyid from t_eb_structofent where fmodelid = ? and fid = ? ", (Object[])new Object[]{this.getModelId(), this.defaultDimMember.get(SysDimensionEnum.Entity.getNumber())});){
                    while (ds.hasNext()) {
                        Long fcurrencyid = ds.next().getLong("fcurrencyid");
                        if (!IDUtils.isNotNull((Long)fcurrencyid)) continue;
                        this.defaultDimMember.put(SysDimensionEnum.Currency.getNumber(), fcurrencyid);
                        if (colIndex == null) continue;
                        this.defaultDimMember.put(SysDimensionEnum.Currency.getNumber() + colIndex, fcurrencyid);
                    }
                }
            }
        }
        return this.defaultDimMember;
    }

    @Override
    public Long getF7Value(String ctrlKey, String dimNumber, String entryRow, Integer colIndex) {
        Long value = null;
        if (ctrlKey != null) {
            if (this.cacheF7Select == null) {
                this.cacheF7Select = this.getCacheF7Select();
            }
            if (this.cacheF7Select.size() > 0) {
                value = entryRow != null ? IDUtils.toLong((Object)this.cacheF7Select.get("lastselect_" + entryRow + ctrlKey)) : IDUtils.toLong((Object)this.cacheF7Select.get("lastselect_" + ctrlKey));
            } else {
                List list = null;
                Map<String, Object> map = this.getConfigMap();
                Object config = map.get(this.getF7KeyDimMapMul().get("ebf7_page_" + dimNumber));
                if (config instanceof String && kd.bos.util.StringUtils.isNotEmpty((String)((String)config))) {
                    list = (List)SerializationUtils.fromJsonString((String)((String)config), List.class);
                } else if (config instanceof List) {
                    list = (List)config;
                }
                if (list != null) {
                    value = IDUtils.toLong((Object)this.getModelCacheHelper().getMember(dimNumber, null, (String)((Map)list.get(0)).get("number")).getId());
                }
            }
        }
        if (IDUtils.isNull(value) && dimNumber != null) {
            this.defaultDimMember = this.getDefaultDimMember(dimNumber, colIndex);
            if (this.defaultDimMember != null && dimNumber != null) {
                value = colIndex == null ? this.defaultDimMember.get(dimNumber) : this.defaultDimMember.get(dimNumber + colIndex);
            }
        }
        return value;
    }

    protected void refreshPageViewPanel(boolean userCache) {
        String f7Key;
        List<Dimension> dimensionList = this.getAllDimension();
        LinkedList<String> pageDimNums = new LinkedList<String>();
        this.scheme = this.getSchemeConfig();
        String dimNumber = null;
        String rowDimension = this.getCurrentRowDimension();
        String colDimension = this.getCurrentColDimension();
        for (Dimension dimension : dimensionList) {
            dimNumber = dimension.getNumber();
            if (rowDimension != null && rowDimension.equals(dimNumber) || colDimension != null && colDimension.equals(dimNumber)) continue;
            pageDimNums.add(dimNumber);
        }
        this.clearF7KeyDimMapCache();
        Map<String, String> f7Map = this.getF7KeyDimMap();
        Map<String, String> dimNames = this.getDimNamesMap();
        HashSet<String> visibleKeys = new HashSet<String>(pageDimNums.size());
        HashSet<String> disableKeys = new HashSet<String>(pageDimNums.size());
        Set<String> hideDims = this.getHideDimensions();
        this.getView().setVisible(Boolean.valueOf(false), F7_KEYS_PAGE);
        this.getView().setVisible(Boolean.valueOf(false), MULTI_SELECT_KEYS);
        this.getModel().beginInit();
        for (String dimNum : pageDimNums) {
            f7Key = f7Map.get(dimNum);
            if (!hideDims.contains(dimNum)) {
                visibleKeys.add(f7Key);
            }
            this.getModel().setValue(f7Key, (Object)this.getF7Value(f7Key, dimNum, null, null));
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(f7Key);
            basedataEdit.setCaption(new LocaleString(dimNames.get(dimNum)));
        }
        this.refreshPageViewPanle2(this.scheme);
        this.setEntryEntityItemProps();
        if (this.scheme != null) {
            for (DiffAnalyzeScheme.DiffAnalyzeColumn diffAnalyzeColumn : this.scheme.getAnalyzeColumns()) {
                for (Map.Entry entry : diffAnalyzeColumn.getDataRow().getMetas().entrySet()) {
                    f7Key = f7Map.get(entry.getKey());
                    if (f7Key == null || !kd.bos.util.StringUtils.isNotEmpty((String)((String)entry.getValue()))) continue;
                    disableKeys.add(f7Key);
                }
            }
        }
        this.getModel().endInit();
        if (colDimension != null) {
            Map configMap = new HashMap(8);
            LinkedList<Object> members = null;
            String value = (String)this.getCacheF7Select().get("lastselect_" + this.getF7KeyDimMapMul().get(colDimension));
            if ((!userCache || kd.bos.util.StringUtils.isEmpty((String)value) || "[]".equals(value)) && this.scheme != null && kd.bos.util.StringUtils.isNotEmpty((String)this.scheme.getConfigJson())) {
                configMap = (Map)SerializationUtils.fromJsonString((String)this.scheme.getConfigJson(), Map.class);
                value = (String)configMap.get("ebf7_page_" + colDimension.toLowerCase(Locale.ROOT));
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)value)) {
                members = new LinkedList<kd.epm.eb.common.model.Member>();
                HashSet<String> hasAddNumber = new HashSet<String>(16);
                List valueList = (List)SerializationUtils.fromJsonString((String)value, List.class);
                Long viewId = IDUtils.toLong(configMap.get(colDimension + "viewId"));
                if (IDUtils.isNull((Long)viewId)) {
                    viewId = this.getDimensionViews().get(colDimension);
                }
                for (Map memb : valueList) {
                    List memberList = this.getModelCacheHelper().getMember(colDimension, viewId, (String)memb.get("number"), Integer.parseInt((String)memb.get("scope")));
                    if (!CollectionUtils.isNotEmpty((Collection)memberList)) continue;
                    for (Member member : memberList) {
                        if (!hasAddNumber.add(member.getNumber())) continue;
                        kd.epm.eb.common.model.Member modelMember = kd.epm.eb.common.model.Member.loadFormCache((Member)member);
                        modelMember.setRange(RangeEnum.ONLY.getIndex());
                        members.add(modelMember);
                    }
                }
            } else {
                Member rootMember = this.getModelCacheHelper().getRootMember(colDimension, this.getDimensionViews().get(colDimension));
                List<Member> cacheMembers = DiffAnalyzeHelper.getMember(this.getDatasetId(), this.getModelCacheHelper(), this.getMemberPerm(), colDimension, (Long)this.spreadManager.getDimemsionViews().get(colDimension), rootMember.getNumber(), RangeEnum.DIRECTSUB_EXCLUDE.getIndex());
                if (cacheMembers == null || cacheMembers.isEmpty()) {
                    cacheMembers = DiffAnalyzeHelper.getMember(this.getDatasetId(), this.getModelCacheHelper(), this.getMemberPerm(), colDimension, (Long)this.spreadManager.getDimemsionViews().get(colDimension), rootMember.getNumber(), RangeEnum.ALL_EXCLUDE.getIndex());
                }
                if (cacheMembers != null && !cacheMembers.isEmpty()) {
                    members = new LinkedList();
                    for (Member m : cacheMembers) {
                        members.add(kd.epm.eb.common.model.Member.loadFormCache((Member)m));
                    }
                }
            }
            this.setMultiSelectMembers(colDimension, members);
            visibleKeys.add("ebf7_" + colDimension.toLowerCase() + "_mul");
        }
        this.updateByWhichDimLabels();
        this.updateByWhichDimLabel(colDimension);
        this.cacheMemberDisplayType(Integer.parseInt(this.getDefMemberDisplay()));
        this.cacheHideEmptyRows(HIDEEMPTYROW.equals(this.getDefEmptyrowDisplay()));
        this.cacheDataUnit(this.getDefUnitDisplay());
        this.getView().setVisible(Boolean.valueOf(true), visibleKeys.toArray(new String[0]));
        this.getView().setEnable(Boolean.valueOf(true), visibleKeys.toArray(new String[0]));
        if (disableKeys.size() > 0) {
            this.getView().setVisible(Boolean.valueOf(false), disableKeys.toArray(new String[0]));
            this.getView().setEnable(Boolean.valueOf(false), disableKeys.toArray(new String[0]));
        }
        this.getView().updateView("dimspanel");
        this.setCache("VISIBLE_F7KEYS", SerializationUtils.toJsonString(visibleKeys));
    }

    private void setEntryEntityItemProps() {
        this.dimNamesMap = this.getDimNamesMap();
        this.dimCtrlKeyMap = this.getDimCtrlKeyMap();
        if (this.dimNamesMap != null) {
            for (Map.Entry<String, String> entry : this.dimNamesMap.entrySet()) {
                String dimNumber = entry.getKey();
                String dimName = entry.getValue();
                String dimKey = this.dimCtrlKeyMap.get(dimNumber);
                HashMap<String, Serializable> prop = new HashMap<String, Serializable>(4);
                HashMap<String, LocaleString> itemprop = new HashMap<String, LocaleString>(1);
                itemprop.put("emptytip", new LocaleString(dimName));
                prop.put("item", itemprop);
                prop.put("draggable", Boolean.valueOf(true));
                if (dimKey.startsWith("customize")) {
                    prop.put("caption", (Serializable)new LocaleString(this.getDimNamesMap().get(dimNumber)));
                }
                this.getView().updateControlMetadata("ebf7_" + dimKey + "_p", prop);
                this.getView().updateControlMetadata("ebf7_" + dimKey + "_mul", prop);
                this.getView().updateControlMetadata("ebf7_" + dimKey + "_p1", prop);
                this.getView().updateControlMetadata("col_" + dimKey, prop);
            }
        }
    }

    private void refreshPageViewPanle2(DiffAnalyzeScheme scheme) {
        if (scheme != null && scheme.getAnalyzeColumns() != null) {
            List dataCols = scheme.getAnalyzeColumns().stream().filter(c -> c.getDataRow().getDataRowType().getIndex() == DataRowEnum.DATA.getIndex()).collect(Collectors.toList());
            boolean hasF7 = dataCols.stream().anyMatch(d -> d.getDataRow().getMetas().size() > 0);
            if (!hasF7) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryentity1panel"});
                return;
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"entryentity1panel"});
            this.modelCacheHelper = this.getModelCacheHelper();
            this.dimCtrlKeyMap = this.getDimCtrlKeyMap();
            Member member = null;
            HashSet<String> visibleKeys = new HashSet<String>(16);
            Set<String> hideDims = this.getHideDimensions();
            HashSet<String> schemeDims = new HashSet<String>(16);
            Set allDimNumbers = this.getAllDimension().stream().map(e -> e.getNumber()).collect(Collectors.toSet());
            int size = dataCols.size();
            IDataModel dataModel = this.getModel();
            dataModel.deleteEntryData("entryentity1");
            dataModel.batchCreateNewEntryRow("entryentity1", size);
            dataModel.beginInit();
            boolean isNeedCacheScheme = false;
            for (int i = 0; i < size; ++i) {
                DiffAnalyzeScheme.DiffAnalyzeColumn col = (DiffAnalyzeScheme.DiffAnalyzeColumn)dataCols.get(i);
                IDataRow dataRow = col.getDataRow();
                dataModel.setValue("col_name1", (Object)col.getDisplayName(), i);
                dataModel.setValue("col_index1", (Object)dataRow.getIndex(), i);
                Map colConfigMap = dataRow.getMetas();
                for (Map.Entry e2 : colConfigMap.entrySet()) {
                    String metaKey = (String)e2.getKey();
                    String metaValue = (String)e2.getValue();
                    if (!allDimNumbers.contains(metaKey)) continue;
                    String ctrlKey = "ebf7_" + this.dimCtrlKeyMap.get(metaKey) + "_p1";
                    if ("_SECOND_PAGE".equals(metaValue)) {
                        schemeDims.add(metaKey);
                        dataModel.setValue(ctrlKey, (Object)this.getF7Value(ctrlKey, metaKey, dataRow.getIndex(), i), i);
                    } else if (metaValue != null && !metaKey.startsWith("_DIMVIEW_")) {
                        boolean exists;
                        schemeDims.add(metaKey);
                        String viewId = (String)colConfigMap.get("_DIMVIEW_" + metaKey);
                        member = viewId != null ? (IDUtils.isNotNull((Long)IDUtils.toLong((Object)viewId)) ? ((exists = QueryServiceHelper.exists((String)"eb_dimensionview", (Object)IDUtils.toLong((Object)viewId))) ? this.modelCacheHelper.getMember(metaKey, IDUtils.toLong((Object)viewId), metaValue) : this.modelCacheHelper.getMember(metaKey, null, metaValue)) : this.modelCacheHelper.getMember(metaKey, null, metaValue)) : this.modelCacheHelper.getMember(metaKey, null, metaValue);
                        if (member != null && !this.getMemberPerm().isNoperm(metaKey, metaValue, IDUtils.toLong((Object)viewId))) {
                            dataModel.setValue(ctrlKey, (Object)member.getId(), i);
                            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{ctrlKey});
                        } else {
                            Long memberId = this.getF7Value(ctrlKey, metaKey, dataRow.getIndex(), i);
                            if (IDUtils.isNotNull((Long)memberId)) {
                                dataModel.setValue(ctrlKey, (Object)memberId, i);
                                Member member1 = null;
                                if (IDUtils.isNotNull((Long)IDUtils.toLong((Object)viewId))) {
                                    member1 = this.getModelCacheHelper().getMember(metaKey, IDUtils.toLong((Object)viewId), memberId);
                                } else {
                                    Dimension dimension = this.getModelCacheHelper().getDimension(metaKey);
                                    member1 = dimension.getStructOfMember(memberId);
                                }
                                if (member1 != null) {
                                    isNeedCacheScheme = true;
                                    col.getDataRow().getMetas().put(metaKey, member1.getNumber());
                                }
                            }
                        }
                    }
                    if (hideDims.contains(metaKey)) continue;
                    visibleKeys.add(ctrlKey);
                }
            }
            dataModel.endInit();
            if (isNeedCacheScheme) {
                this.getPageCache().put("scheme_config_cache_key", SerializationUtils.serializeToBase64((Object)scheme));
            }
            this.cacheSchemeDims(schemeDims);
            CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity1");
            for (int i = 0; i < size; ++i) {
                cardEntry.setChildVisible(false, i, F7_KEYS_PAGE1);
                cardEntry.setChildVisible(true, i, visibleKeys.toArray(new String[0]));
            }
            this.getView().updateView("entryentity1");
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryentity1panel"});
        }
    }

    public String getSelectedEntryId(String entryentityKey, String field, int index) {
        DynamicObjectCollection entryentity;
        Control control = this.getControl(entryentityKey);
        if (control instanceof EntryGrid && (entryentity = this.getModel().getEntryEntity(entryentityKey)) != null && entryentity.size() > index) {
            return ((DynamicObject)entryentity.get(index)).getString(field);
        }
        return null;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        if (this.check()) {
            e.setCancel(true);
            return;
        }
        int row = e.getRow();
        String controlKey = e.getProperty().getName();
        String dimNumber = this.getCurrentDimNumber(controlKey);
        String sign = controlKey;
        if (dimNumber != null && controlKey != null && (controlKey.startsWith("ebf7_") || controlKey.startsWith("col_"))) {
            String entryId = null;
            if (this.isSchemeDimF7(controlKey)) {
                entryId = this.getSelectedEntryId("entryentity", "id", row);
            } else if (this.isSecondPageDimF7(controlKey)) {
                entryId = this.getSelectedEntryId("entryentity1", "col_index1", row);
            }
            if (entryId != null) {
                sign = controlKey + entryId;
            }
            e.getFormShowParameter().getCustomParams().put("sign", sign);
            Long modelId = this.getModelId();
            MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
            f7Param.setBusModelId(Long.valueOf(this.getBusModelId()));
            if ("Account".equals(dimNumber)) {
                f7Param.setDatasetId(Long.valueOf(this.getDatasetId()));
            } else if ("AuditTrail".equals(dimNumber)) {
                f7Param.setShowNotEnable(true);
                f7Param.setHideDecompose(false);
            } else if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
                f7Param.addCustomFilter(new QFilter("datatype", "in", (Object)new String[]{SHOWEMPTYROW, HIDEEMPTYROW}));
            } else if (DimensionViewServiceHelper.hasView((String)dimNumber)) {
                String viewIdKey = dimNumber + "viewId";
                String viewIdValue = null;
                Long viewId = 0L;
                if (this.isSchemeDimF7(controlKey) || this.isSecondPageDimF7(controlKey)) {
                    viewId = this.getEntryDimensionViews().get(dimNumber + "_" + entryId);
                } else {
                    viewIdValue = this.getPageCache().get(viewIdKey);
                    if (viewIdValue != null) {
                        viewId = IDUtils.toLong((Object)viewIdValue);
                    }
                }
                if (IDUtils.isNull((Long)viewId)) {
                    boolean exists;
                    viewId = IDUtils.toLong((Object)this.getConfigMap().get(viewIdKey));
                    if (IDUtils.isNull((Long)viewId)) {
                        viewId = this.getViewId(dimNumber);
                    }
                    if (!(exists = QueryServiceHelper.exists((String)"eb_dimensionview", (Object)viewId))) {
                        viewId = this.getModelCacheHelper().getViewByDataSetAndDimNumber(Long.valueOf(this.getDatasetId()), dimNumber);
                    }
                }
                f7Param.setViewId(viewId);
            }
            if (!this.isEditSchemeMode() && !controlKey.endsWith("_p1")) {
                this.addFilterByScheme(dimNumber, f7Param);
            }
            f7Param.setEnableView(true);
            NewF7Utils.openF7((BeforeF7SelectEvent)e, (MemberF7Parameter)f7Param);
        } else if ("model".equals(controlKey)) {
            ApplicationTypeEnum application;
            ListShowParameter showP = (ListShowParameter)e.getFormShowParameter();
            String entityId = this.getCheckPermEntityId();
            if (this.existSpecialParam()) {
                application = ModelUtil.queryApp((IFormView)this.getCheckPermView());
            } else {
                String curBizAppIndex = ExecuteAnalyseUtil.getInstance().getCurBizAppIndex(this.getView());
                showP.setCustomParam("special_appId", (Object)curBizAppIndex);
                application = ApplicationTypeEnum.getEnumByIndex((String)curBizAppIndex);
            }
            Set ids = ModelUtil.getModelIdsWithPerm((String)entityId, (ApplicationTypeEnum)application);
            if ("getLookUpList".equals(e.getSourceMethod())) {
                ArrayList<QFilter> qFilterList = ((BasedataEdit)this.getControl(controlKey)).getQFilters();
                if (qFilterList == null) {
                    qFilterList = new ArrayList<QFilter>(16);
                }
                qFilterList.add(new QFilter("id", "in", (Object)ids));
                showP.setListFilterParameter(new ListFilterParameter(qFilterList, null));
            } else {
                List qs = showP.getListFilterParameter().getQFilters();
                this.addSpecialParam((FormShowParameter)showP);
                qs.add(new QFilter("id", "in", (Object)ids));
                e.setFormShowParameter((FormShowParameter)showP);
            }
        } else if ("analyzescheme".equals(controlKey)) {
            Long modelId = this.getModelId();
            e.getCustomQFilters().add(ExecuteAnalyseUtil.getInstance().getQFilter(null, "dataset", "creator", modelId, true, true));
            if ("click".equals(e.getSourceMethod())) {
                DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("analyzescheme");
                ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
                if (dynamicObject != null) {
                    listShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
                    listShowParameter.setCustomParam("currentAnalyzeScheme", dynamicObject.getPkValue());
                }
                if (NewEbAppUtil.isNewEbModel((Long)modelId)) {
                    listShowParameter.setFormId("bos_listf7");
                    listShowParameter.addCustPlugin("kd.epm.eb.formplugin.analyze.DiffAnalyzeSchemeTreeListF7");
                }
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
        } else {
            e.getCustomQFilters().add(new QFilter("model", "=", (Object)this.getModelId()));
        }
    }

    private void addFilterByScheme(String dimNumber, MemberF7Parameter f7Param) {
        Map memberQuotes = this.getSchemeConfig().getMulF7MemberQuotes();
        Long viewId = IDUtils.toLong((Object)this.getConfigMap().get(dimNumber + "viewId"));
        List memberQuote = (List)memberQuotes.get(dimNumber.toLowerCase(Locale.ROOT));
        if (CollectionUtils.isNotEmpty((Collection)memberQuote)) {
            Set<Member> members = DiffAnalyzeHelper.resolveHasPermMember(this.getModelCacheHelper(), this.getBusModelId(), dimNumber, viewId, memberQuote);
            if (CollectionUtils.isNotEmpty(members)) {
                if (View.NoViewDimNums.contains(dimNumber)) {
                    f7Param.addCustomCommFilter(new QFilter("id", "in", members.stream().map(BaseCache::getId).collect(Collectors.toSet())));
                } else {
                    f7Param.addCustomCommFilter(new QFilter("memberid", "in", members.stream().map(BaseCache::getId).collect(Collectors.toSet())));
                }
            } else {
                if (View.NoViewDimNums.contains(dimNumber)) {
                    Set permMembNumbers;
                    Member rootMember = this.getModelCacheHelper().getRootMember(dimNumber, viewId);
                    if (rootMember != null && ((permMembNumbers = EpmThreadLocalUtils.getPermMembNumbers((Long)this.getUserId(), (String)dimNumber, (Long)this.modelCacheHelper.getModelobj().getId(), (Long)this.getBusModelId(), (Long)viewId, (DimMembPermType)DimMembPermType.READ, (boolean)true)) == null || permMembNumbers.size() > 0)) {
                        return;
                    }
                } else {
                    List number = memberQuote.stream().map(x -> (String)x.get("number")).collect(Collectors.toList());
                    HashSet<Long> numberId = new HashSet<Long>(members.size());
                    for (String s : number) {
                        Member memberByAnyView = this.getModelCacheHelper().getMemberByAnyView(dimNumber, s);
                        if (memberByAnyView == null) continue;
                        numberId.add(memberByAnyView.getId());
                    }
                    if (CollectionUtils.isNotEmpty(numberId)) {
                        Dimension dimension = this.getModelCacheHelper().getDimension(dimNumber);
                        Long viewGroupByBusModelAndDimNumber = this.getModelCacheHelper().getViewGroupByBusModelAndDimNumber(Long.valueOf(this.getBusModelId()), dimNumber);
                        if (dimension != null && IDUtils.isNotNull((Long)viewGroupByBusModelAndDimNumber)) {
                            Set permMembNumbers;
                            Member rootMember;
                            Long aLong = DimensionViewServiceHelper.queryViewIdByMemberId((Long)this.getModelId(), (Long)this.getBusModelId(), (Long)dimension.getId(), (Long)viewGroupByBusModelAndDimNumber, numberId, (Long)viewId);
                            if (IDUtils.isNotNull((Long)viewId) && !viewId.equals(aLong) && (rootMember = this.getModelCacheHelper().getRootMember(dimNumber, viewId)) != null && ((permMembNumbers = EpmThreadLocalUtils.getPermMembNumbers((Long)this.getUserId(), (String)dimNumber, (Long)this.modelCacheHelper.getModelobj().getId(), (Long)this.getBusModelId(), (Long)viewId, (DimMembPermType)DimMembPermType.READ, (boolean)true)) == null || permMembNumbers.size() > 0)) {
                                return;
                            }
                        }
                    }
                }
                f7Param.addCustomCommFilter(new QFilter(SHOWEMPTYROW, "!=", (Object)1));
            }
        }
    }

    protected String getCheckPermEntityId() {
        return this.getView().getEntityId();
    }

    protected IFormView getCheckPermView() {
        return this.getView();
    }

    @Override
    public void afterF7Select(AfterF7SelectEvent e) {
        String key = ((BasedataEdit)e.getSource()).getKey();
        String dimNumber = this.getCurrentDimNumber(key);
        if (kd.bos.util.StringUtils.isNotEmpty((String)dimNumber)) {
            if (this.isCommonDimF7(key)) {
                String viewId = this.getCache(key + "viewId");
                if (viewId != null) {
                    this.getDimensionViews().put(dimNumber, IDUtils.toLong((Object)viewId));
                    this.cacheSpreadManager();
                }
            } else {
                String entryId;
                Object viewid;
                int rowIndex = e.getCurrentRowIndex();
                String viewId = null;
                ListSelectedRowCollection listSelectedRowCollection = e.getListSelectedRowCollection();
                if (CollectionUtils.isNotEmpty((Collection)listSelectedRowCollection) && (viewid = listSelectedRowCollection.get(0).getDataMap().get("viewid")) != null && IDUtils.isNotNull((Long)IDUtils.toLong(viewid))) {
                    viewId = IDUtils.toString(viewid);
                }
                if (this.isSchemeDimF7(key)) {
                    entryId = ((DynamicObject)this.getModel().getEntryEntity("entryentity").get(rowIndex)).getString("id");
                    if (kd.bos.util.StringUtils.isNotEmpty((String)viewId)) {
                        this.cacheEntryDimensionViews(dimNumber + "_" + entryId, IDUtils.toLong((Object)viewId));
                    }
                } else if (this.isSecondPageDimF7(key)) {
                    entryId = ((DynamicObject)this.getModel().getEntryEntity("entryentity1").get(rowIndex)).getString("col_index1");
                    if (kd.bos.util.StringUtils.isNotEmpty((String)viewId)) {
                        this.cacheEntryDimensionViews(dimNumber + "_" + entryId, IDUtils.toLong((Object)viewId));
                    }
                }
            }
        }
    }

    private Map<String, Long> getCommonDimemsionViews() {
        HashMap<String, Long> dimViews = new HashMap<String, Long>(16);
        String colDim = this.getCurrentColDimension();
        String rowDim = this.getCurrentRowDimension();
        for (String key : F7_KEYS_PAGE) {
            String dimNumber;
            String viewId;
            if (key == null || (viewId = this.getCache(key + "viewId")) == null || !kd.bos.util.StringUtils.isNotEmpty((String)(dimNumber = this.getCurrentDimNumber(key))) || dimNumber.equals(colDim) || dimNumber.equals(rowDim)) continue;
            dimViews.put(dimNumber, IDUtils.toLong((Object)viewId));
        }
        return dimViews;
    }

    private long getDimViewId(String sign, String dimNumber, long dataSetId) {
        long viewId = 0L;
        if (sign != null && this.getCache(sign + "viewId") != null) {
            viewId = Long.parseLong(this.getCache(sign + "viewId"));
        }
        if (viewId == 0L) {
            viewId = ReportQueryHelper.getDimViewId(this.getModelCacheHelper(), dataSetId, dimNumber, (Boolean)true);
        }
        return viewId;
    }

    public String getCurrentDimNumber(String controlKey) {
        if (controlKey != null && (controlKey.startsWith("ebf7_") || controlKey.startsWith("col_"))) {
            if (controlKey.startsWith("col_")) {
                controlKey = controlKey.replaceAll("col_", "ebf7_") + "_p";
            }
            String dimNumber = this.getF7KeyDimMap().containsKey(controlKey) ? this.getF7KeyDimMap().get(controlKey) : (this.getF7KeyDimMap2().containsKey(controlKey) ? this.getF7KeyDimMap2().get(controlKey) : (this.getF7KeyDimMapMul().containsKey(controlKey) ? this.getF7KeyDimMapMul().get(controlKey) : this.getF7KeyDimMapPage().get(controlKey)));
            return dimNumber;
        }
        return null;
    }

    @Override
    public Long getModelId() {
        String modelId = this.getCache("KEY_MODEL_ID");
        if (modelId != null) {
            return Long.parseLong(modelId);
        }
        return 0L;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key;
        super.closedCallBack(closedCallBackEvent);
        switch (key = closedCallBackEvent.getActionId()) {
            case "showFormSchemeSave": {
                if (!(closedCallBackEvent.getReturnData() instanceof Long)) break;
                Object returnData = closedCallBackEvent.getReturnData();
                this.getModel().setValue("analyzescheme", returnData);
                this.getView().updateView("analyzescheme");
                this.setCache("IS_EDIT_SCHEME_MODE", Boolean.toString(false));
                this.setControlVisible(false);
                Set<String> schemeDims = this.getSchemeDims();
                if (schemeDims == null || schemeDims.isEmpty()) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryentity1panel"});
                }
                this.updateByWhichDimLabel(this.getCurrentColDimension());
                this.clearCachedSchemeConfig();
                this.clearCachedDisplaysettings();
                this.hideDimensions = null;
                this.resetSpreadManager();
                this.initDimensionViewsFromDataSet();
                this.initDimensionViewsFromSchemeConfig();
                this.refreshPageViewPanel(false);
                this.refreshSpread();
                break;
            }
            case "showFormEditExpr": {
                String expr_row = this.getCache("expr_row");
                if (!(closedCallBackEvent.getReturnData() instanceof Map) || expr_row == null) break;
                Map map = (Map)closedCallBackEvent.getReturnData();
                String expr = (String)map.get("expr");
                String exprdisplay = (String)map.get("exprdisplay");
                String fm = (String)map.get("fm");
                int row = Integer.parseInt(expr_row);
                this.getModel().setValue("col_fm", (Object)fm, row);
                this.getModel().setValue("col_expr", (Object)expr, row);
                this.getModel().setValue("col_exprdisplay", (Object)exprdisplay, row);
                break;
            }
            case "closeTip": {
                this.getView().close();
                break;
            }
            case "displaysetting": {
                if (!(closedCallBackEvent.getReturnData() instanceof String)) break;
                Map map = (Map)SerializationUtils.deSerializeFromBase64((String)((String)closedCallBackEvent.getReturnData()));
                if (this.isEditSchemeMode()) {
                    for (Map.Entry entry : map.entrySet()) {
                        if (entry.getValue() instanceof String) {
                            this.setCache((String)entry.getKey(), (String)entry.getValue());
                            continue;
                        }
                        this.setCache((String)entry.getKey(), SerializationUtils.toJsonString(entry.getValue()));
                    }
                    break;
                }
                Set<String> hideDimensions_old = this.getHideDimensions();
                Collection hideDimensions_new = (Collection)map.get("hide_dimensions");
                if (this.getCurrentColDimension() == null || hideDimensions_new != null && hideDimensions_new.contains(this.getCurrentColDimension())) {
                    this.getPageCache().put("diffDisplaySettings", SerializationUtils.toJsonString((Object)map));
                    this.cacheSchemeDims(null);
                    this.hideDimensions = hideDimensions_new == null ? new HashSet<String>(16) : new HashSet(hideDimensions_new);
                    this.resetSpreadManager();
                    this.refreshPageViewPanel(true);
                    this.refreshSpread();
                    this.getView().updateView();
                    break;
                }
                int memberDisplayType_old = this.getMemberDisplayType();
                int memberDisplayType_new = Integer.parseInt(map.get("defmemberdisplay") + "");
                boolean hideEmptyRows_old = this.isHideEmptyRows();
                boolean hideEmptyRows_new = HIDEEMPTYROW.equals(map.get("defemptyrowdisplay"));
                String unitDisplay_old = this.getDataUnit();
                String unitDisplay_new = (String)map.get("defunitdisplay");
                if (memberDisplayType_new != memberDisplayType_old) {
                    this.getSpreadManager().setMemberDisplayType(memberDisplayType_new);
                    new RefreshMemberDisplayCommand(memberDisplayType_new).setCacheSMAfterExecute(false).execute(this);
                    this.cacheMemberDisplayType(memberDisplayType_new);
                }
                if (Boolean.compare(hideEmptyRows_new, hideEmptyRows_old) != 0) {
                    new HideShowEmptyRowsCommand(hideEmptyRows_new ? "btn_hideemptyrows" : "btn_showemptyrows").setCacheSMAfterExecute(false).execute(this);
                }
                if (kd.bos.util.StringUtils.isNotEmpty((String)unitDisplay_new) && !unitDisplay_new.equals(unitDisplay_old)) {
                    new DataUnitChangeCommand(unitDisplay_new).setCacheSMAfterExecute(false).execute(this);
                }
                if (hideDimensions_new == null || hideDimensions_old == null || !hideDimensions_new.equals(hideDimensions_old)) {
                    this.hideDimensions = hideDimensions_new == null ? new HashSet<String>(16) : new HashSet(hideDimensions_new);
                    this.refreshPageViewPanel(true);
                }
                String oldSettingStr = this.getCache("diffDisplaySettings");
                Map oldSettingMap = new HashMap(16);
                if (kd.bos.util.StringUtils.isNotEmpty((String)oldSettingStr)) {
                    oldSettingMap = (Map)SerializationUtils.fromJsonString((String)oldSettingStr, Map.class);
                }
                Collection noSep_new = (Collection)map.get("metricdisplay_no_sep");
                Collection noSep_old = (Collection)oldSettingMap.get("metricdisplay_no_sep");
                Map mDisp_new = (Map)map.get("metricdisplay");
                Map mDisp_old = (Map)oldSettingMap.get("metricdisplay");
                if (noSep_new != null && noSep_old != null && !Sets.newHashSet((Iterable)noSep_new).equals(Sets.newHashSet((Iterable)noSep_old)) || mDisp_new != null && !mDisp_new.equals(mDisp_old)) {
                    Set<Integer> rows = new RefreshCellDataCommand(this).getRefreshedRows();
                    Integer minRow = (Integer)rows.stream().min(Integer::compareTo).get();
                    Integer maxRow = (Integer)rows.stream().max(Integer::compareTo).get();
                    this.spreadManager = this.getSpreadManager();
                    this.spreadManager.setDiffAnalyzeScheme(this.getSchemeConfig());
                    DiffAnalyzeStyleController.setCellStyles((int)minRow, (int)maxRow, (IDiffAnalyzeSpreadManager)this.spreadManager, (SpreadContainer)this.getspreadContainer(), (Map)map);
                }
                this.getPageCache().put("diffDisplaySettings", SerializationUtils.toJsonString((Object)map));
                this.cacheSpreadManager();
                break;
            }
            case "share": {
                ExecuteAnalyseSchemeListPlugin plugin = new ExecuteAnalyseSchemeListPlugin();
                plugin.setView(this.getView());
                plugin.closedCallBack(closedCallBackEvent);
                break;
            }
            default: {
                DynamicObjectCollection returnData;
                if (!this.isF7Key(key) && !"account_range".equals(key)) break;
                String viewIdStr = null;
                if (key.endsWith("_mul") && kd.bos.util.StringUtils.isNotEmpty((String)(viewIdStr = this.getCache(key + "viewId")))) {
                    String dimNumber = this.getF7KeyDimMapMul().get(key);
                    this.getDimensionViews().put(dimNumber, IDUtils.toLong((Object)viewIdStr));
                    this.cacheSpreadManager();
                }
                boolean triggerPropertyChange = false;
                String dimNumber = null;
                Long viewId = null;
                if (closedCallBackEvent.getReturnData() instanceof DynamicObjectCollection) {
                    returnData = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
                    if (returnData.size() > 0) {
                        viewId = ((DynamicObject)returnData.get(0)).getLong("viewid");
                        dimNumber = ((DynamicObject)returnData.get(0)).getString("dimNum");
                    }
                    triggerPropertyChange = DiffAnalyzeHelper.setMultiSelectF7Value(DiffAnalyzeHelper.toListOfMap((DynamicObjectCollection)closedCallBackEvent.getReturnData()), key, this.getView());
                } else if (closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection) {
                    returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                    if (returnData.size() > 0) {
                        viewId = (Long)returnData.get(0).getDataMap().get("viewid");
                        dimNumber = (String)returnData.get(0).getDataMap().get("dimNumber");
                    }
                    triggerPropertyChange = DiffAnalyzeHelper.setMultiSelectF7Value(DiffAnalyzeHelper.toListOfMap((ListSelectedRowCollection)closedCallBackEvent.getReturnData()), key, this.getView());
                }
                if (kd.bos.util.StringUtils.isNotEmpty(dimNumber) && IDUtils.isNotNull(viewId)) {
                    this.cacheDimensionViews(dimNumber, viewId);
                }
                if (!triggerPropertyChange) break;
                kd.epm.eb.common.model.Dimension dimension = new kd.epm.eb.common.model.Dimension();
                dimension.setNumber(dimNumber);
                this.getSpreadManager().setColDimension(dimension);
                this.cacheSpreadManager();
                this.clickBtnOK();
            }
        }
    }

    public void clearCachedSchemeConfig() {
        this.clearCache("scheme_config_cache_key");
        this.scheme = null;
        this.configMap = null;
    }

    private void clearCachedDisplaysettings() {
        this.clearCache("diffDisplaySettings");
    }

    public Long getUserId() {
        return UserUtils.getUserId();
    }

    @Override
    public String getSpreadKey() {
        return "report";
    }

    @Override
    public SpreadContainer getspreadContainer() {
        if (this.spreadContainer == null) {
            this.spreadContainer = new SpreadContainer(this.getView(), this.getSpreadKey());
        }
        return this.spreadContainer;
    }

    public SpreadContainer getspreadContainer4Export() {
        return new SpreadContainer(this.getView(), "report4export");
    }

    @Override
    public SpreadSelector getSpreadSelector() {
        String serial;
        if (this.spreadSelector == null && StringUtils.isNotEmpty((String)(serial = this.getCache("spread_selector_cache_key")))) {
            this.spreadSelector = (SpreadSelector)ObjectSerialUtil.deSerializedBytes((String)serial);
        }
        return this.spreadSelector;
    }

    public void setSpreadSelector(SpreadSelector spreadSelector) {
        this.spreadSelector = spreadSelector;
        this.cacheSpreadSelector();
    }

    public void cacheSpreadSelector() {
        if (this.spreadSelector == null) {
            this.setCache("spread_selector_cache_key", null);
        } else {
            this.setCache("spread_selector_cache_key", ObjectSerialUtil.toByteSerialized((Object)this.spreadSelector));
        }
    }

    @Override
    public void cacheSpreadManager() {
        if (this.spreadManager == null) {
            this.setBigCache("spread_manager_cache_key", null);
        } else {
            this.setBigCache("spread_manager_cache_key", DiffAnalyzeSpreadManagerSerializerUtil.toJson((IDiffAnalyzeSpreadManager)this.spreadManager));
        }
    }

    @Override
    public IDiffAnalyzeSpreadManager getSpreadManager() {
        if (this.spreadManager == null) {
            String serial = this.getBigCache("spread_manager_cache_key");
            if (StringUtils.isNotEmpty((String)serial)) {
                this.spreadManager = DiffAnalyzeSpreadManagerSerializerUtil.read((String)serial);
            } else {
                this.spreadManager = new DiffAnalyzeSpreadManager();
                this.spreadManager.setModelid(this.getModelId());
                this.spreadManager.setDatasetid(Long.valueOf(this.getDatasetId()));
            }
        }
        return this.spreadManager;
    }

    protected void resetSpreadManager() {
        this.spreadManager = null;
        this.clearBigCache("spread_manager_cache_key");
    }

    public void cacheHideEmptyRows(boolean isHideEmptyRows) {
        this.getPageCache().put("isHideEmptyRows", isHideEmptyRows ? "true" : "false");
    }

    public boolean isHideEmptyRows() {
        return "true".equals(this.getPageCache().get("isHideEmptyRows"));
    }

    public void cacheDataUnit(String dataUnit) {
        this.setCache("dataunit", dataUnit);
    }

    public String getDataUnit() {
        return this.getCache("dataunit");
    }

    @Override
    public String getBizAppId() {
        return this.getBizAppId4WF(true);
    }

    protected boolean validescheme() {
        return this.getSchemeDims().containsAll(Arrays.asList(SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.AuditTrail.getNumber()));
    }

    public String getAppIdFromMsgCentral(String appId, Long modelId) {
        return this.getAppIdFromMsgCentral4BGRP(appId, modelId);
    }

    public String getModelCustomKey() {
        return "KEY_MODEL_ID";
    }

    public boolean notCheckPermInWorkFlow() {
        return false;
    }

    private boolean check() {
        if (this.getPageCache().get("isScheme") != null) {
            return false;
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "closeTip");
        if (!this.checkSchemeDelete()) {
            ExecuteAnalyseUtil.getInstance().openTipPage(ResManager.loadKDString((String)"\u5f53\u524d\u62a5\u8868\u5bf9\u5e94\u7684\u65b9\u6848\u5df2\u88ab\u5220\u9664", (String)"DiffAnalyzePlugin_44", (String)"epm-eb-formplugin", (Object[])new Object[0]), this.getView(), closeCallBack);
            return true;
        }
        if (!this.checkEnjoyCancel()) {
            ExecuteAnalyseUtil.getInstance().openTipPage(ResManager.loadKDString((String)"\u5f53\u524d\u591a\u7ef4\u5206\u6790\u8868\u5df2\u88ab\u53d6\u6d88\u5206\u4eab", (String)"DiffAnalyzePlugin_45", (String)"epm-eb-formplugin", (Object[])new Object[0]), this.getView(), closeCallBack);
            return true;
        }
        return false;
    }

    private boolean checkSchemeDelete() {
        return QueryServiceHelper.exists((String)"eb_diffanalyzescheme", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getSchemeId())});
    }

    private boolean checkEnjoyCancel() {
        if (!this.isEnjoyedScheme()) {
            return true;
        }
        return ReportShareHelper.checkSingleEnjoyed((Long)this.getSchemeId());
    }

    private boolean isFormEnjoy() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object isFormEnjoy = formShowParameter.getCustomParam("isFormEnjoy");
        return isFormEnjoy != null;
    }

    private boolean isEnjoyedScheme() {
        Long schemeId = this.getSchemeId();
        return ReportShareHelper.checkIsReceiver((Long)schemeId);
    }

    @Override
    public Long getSchemeId() {
        Object analyzeScheme = this.getModel().getValue("analyzescheme");
        if (analyzeScheme == null) {
            return 0L;
        }
        return ((DynamicObject)analyzeScheme).getLong("id");
    }

    private Map<String, Object> getConfigMap() {
        if (this.configMap == null) {
            this.configMap = this.getSchemeConfig().getConfigMap();
        }
        return this.configMap;
    }

    private void getUserDefinedRowColSize() {
        IDiffAnalyzeSpreadManager ebSpreadManager = this.getSpreadManager();
        int cols = ebSpreadManager.getEbook().getSheet(0).getRealMaxCols();
        if (cols >= 20) {
            cols = 20;
        }
        ArrayList<Integer> colwidths = new ArrayList<Integer>(16);
        for (int i = 0; i < cols; ++i) {
            colwidths.add(i);
        }
        this.getspreadContainer().getColumnsWidth(colwidths.toArray(new Integer[0]), "cacheColumnsWidth");
        log.info("start: cacheColumnsWidth");
    }

    private void setUserDefinedRowColSize() {
        ArrayList cachewidths = (ArrayList)UserSelectUtils.getWholeUserSelectByBusinessModelId((IFormView)this.getView(), (Long)this.getSchemeId(), ArrayList.class);
        if (cachewidths != null && cachewidths.size() > 0) {
            for (Map cachewidth : cachewidths) {
                Integer index = (Integer)cachewidth.get("c");
                Integer width = (Integer)cachewidth.get("w");
                this.getspreadContainer().setColumnsWidth(Collections.singletonList(index), width.intValue());
            }
        }
    }

    public void cacheColumnsWidth(Object paras) {
        log.info("callPluginMethod:cacheColumnsWidth");
        try {
            if (paras == null) {
                return;
            }
            IDiffAnalyzeSpreadManager spreadManager = this.getSpreadManager();
            ISheet sheet = spreadManager.getEbook().getSheet(0);
            if (sheet != null) {
                Map parasmap = (Map)Map.class.cast(paras);
                ArrayList cachewidths = (ArrayList)parasmap.get("infos");
                UserSelectUtils.saveWholeUserSelect((IFormView)this.getView(), (long)this.getSchemeId(), (Object)cachewidths);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DiffAnalyzePlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        finally {
            this.getView().close();
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        AdminModelUtil.checkAdminModeBeforeItemClick(evt, this.getModelId(), this.getView(), Sets.newHashSet((Object[])new String[]{"btn_exit"}));
    }

    public void exportSpread() {
        ISheet sheet = this.getSpreadManager().getEbook().getSheet(0);
        int tableSize = sheet.getRealMaxRows() * sheet.getRealMaxCols();
        if (tableSize > 1000000) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d85\u51fa\u6700\u5927\u5bfc\u51fa\u5355\u5143\u683c\u6570\uff0c\u8bf7\u51cf\u5c0f\u67e5\u8be2\u8303\u56f4\u540e\u518d\u8fdb\u884c\u5bfc\u51fa\u3002", (String)"DiffAnalyzePlugin_42", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.refreshAllRows();
        this.getspreadContainer().getSpreadJson("getSpreadJson4Export");
    }

    public void getSpreadJson4Export(Object params) {
        if (params instanceof Map) {
            Object areasStyle;
            LinkedList<CellArea> range;
            CellStyleInfo style;
            DiffCellDimMember cellDimMember;
            int i;
            String spreadserial = ((Map)params).get("data") + "";
            this.getspreadContainer4Export().rebuildSpread(spreadserial);
            List rowCellDimMembers = this.getSpreadManager().getRowCellDimMembers();
            List colCellDimMembers = this.getSpreadManager().getColCellDimMembers();
            LinkedList<Object> areasStyles = new LinkedList<Object>();
            HashMap<Integer, Set> rowStyleInfoSetMap = new HashMap<Integer, Set>(16);
            HashMap<Integer, Set> colStyleInfoSetMap = new HashMap<Integer, Set>(16);
            if (rowCellDimMembers != null) {
                for (i = 0; i < rowCellDimMembers.size(); ++i) {
                    cellDimMember = (DiffCellDimMember)rowCellDimMembers.get(i);
                    if (cellDimMember == null) continue;
                    Set rows = rowStyleInfoSetMap.computeIfAbsent(cellDimMember.getTi(), f -> new HashSet(16));
                    rows.add(i);
                }
            }
            if (colCellDimMembers != null) {
                for (i = 0; i < colCellDimMembers.size(); ++i) {
                    cellDimMember = (DiffCellDimMember)colCellDimMembers.get(i);
                    if (cellDimMember == null) continue;
                    Set cols = colStyleInfoSetMap.computeIfAbsent(cellDimMember.getTi(), f -> new HashSet(16));
                    cols.add(i);
                }
            }
            for (Map.Entry entry : rowStyleInfoSetMap.entrySet()) {
                style = new CellStyleInfo();
                style.setTi((Integer)entry.getKey());
                range = new LinkedList<CellArea>();
                for (Integer row : (Set)entry.getValue()) {
                    range.add(new CellArea(row.intValue(), 0, 1, 1));
                }
                areasStyle = new AreasStyle();
                areasStyle.setStyle(style);
                areasStyle.setRange(range);
                areasStyles.add(areasStyle);
            }
            for (Map.Entry entry : colStyleInfoSetMap.entrySet()) {
                style = new CellStyleInfo();
                style.setTi((Integer)entry.getKey());
                range = new LinkedList();
                for (Integer col : (Set)entry.getValue()) {
                    range.add(new CellArea(0, col.intValue(), 1, 1));
                }
                areasStyle = new AreasStyle();
                areasStyle.setStyle(style);
                areasStyle.setRange(range);
                areasStyles.add(areasStyle);
            }
            String fileName = "export";
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("analyzescheme");
            if (dynamicObject != null) {
                fileName = dynamicObject.getString("name");
            }
            this.getspreadContainer4Export().setCellStyle(areasStyles);
            this.getspreadContainer4Export().exportExcelFile(fileName);
        }
    }

    public void refreshAllRows() {
        if (this.getSpreadManager() == null || this.getSpreadManager().getEbook() == null) {
            return;
        }
        ISheet sheet = this.getSpreadManager().getEbook().getSheet(0);
        if (sheet != null) {
            LinkedHashMap dataInfo = new LinkedHashMap();
            LinkedHashMap<String, Integer> dataMap = new LinkedHashMap<String, Integer>();
            dataMap.put("topRow", sheet.getValueAreaRowStart());
            dataMap.put("bottomRow", sheet.getRealMaxRows());
            dataMap.put("leftCol", 0);
            dataMap.put("rightCol", 50);
            dataInfo.put("data", dataMap);
            this.virtualModelCallBack(dataInfo);
        }
    }

    private String getDefMemberDisplay() {
        if (this.defMemberDisplay == null) {
            Map map;
            String str = this.getCache("diffDisplaySettings");
            if (kd.bos.util.StringUtils.isNotEmpty((String)str) && (map = (Map)SerializationUtils.fromJsonString((String)str, Map.class)).get("defmemberdisplay") instanceof String) {
                this.defMemberDisplay = (String)map.get("defmemberdisplay");
            }
            if (this.defMemberDisplay == null) {
                this.defMemberDisplay = this.getSchemeConfig().getDefMemberDisplay();
            }
            if (this.defMemberDisplay == null) {
                this.defMemberDisplay = SHOWEMPTYROW;
            }
        }
        return this.defMemberDisplay;
    }

    private String getDefEmptyrowDisplay() {
        if (this.defEmptyrowDisplay == null) {
            Map map;
            String str = this.getCache("diffDisplaySettings");
            if (kd.bos.util.StringUtils.isNotEmpty((String)str) && (map = (Map)SerializationUtils.fromJsonString((String)str, Map.class)).get("defemptyrowdisplay") instanceof String) {
                this.defEmptyrowDisplay = (String)map.get("defemptyrowdisplay");
            }
            if (this.defEmptyrowDisplay == null) {
                this.defEmptyrowDisplay = this.getSchemeConfig().getDefEmptyrowDisplay();
            }
        }
        return this.defEmptyrowDisplay;
    }

    private String getDefUnitDisplay() {
        if (this.defUnitDisplay == null) {
            Map map;
            String str = this.getCache("diffDisplaySettings");
            if (kd.bos.util.StringUtils.isNotEmpty((String)str) && (map = (Map)SerializationUtils.fromJsonString((String)str, Map.class)).get("defunitdisplay") instanceof String) {
                this.defUnitDisplay = (String)map.get("defunitdisplay");
            }
            if (this.defUnitDisplay == null) {
                this.defUnitDisplay = this.getSchemeConfig().getDefUnitDisplay();
            }
            if (this.defUnitDisplay == null) {
                this.defUnitDisplay = "0";
            }
        }
        return this.defUnitDisplay;
    }

    private Set<String> getHideDimensions() {
        if (this.hideDimensions == null) {
            String str = this.getCache("diffDisplaySettings");
            if (kd.bos.util.StringUtils.isNotEmpty((String)str)) {
                Map map = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
                Object value = map.get("hide_dimensions");
                if (value instanceof Set) {
                    this.hideDimensions = (Set)value;
                } else if (value instanceof Collection) {
                    this.hideDimensions = Sets.newHashSet((Iterable)((Collection)value));
                } else if (value instanceof String) {
                    this.hideDimensions = (Set)SerializationUtils.fromJsonString((String)((String)value), Set.class);
                }
            }
            if (this.hideDimensions == null) {
                this.hideDimensions = this.getSchemeConfig().getHideDimensions();
            }
            if (this.hideDimensions == null) {
                this.hideDimensions = new HashSet<String>(16);
            }
        }
        return this.hideDimensions;
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        EntryGrid source = (EntryGrid)cellClickEvent.getSource();
        String key = source.getKey();
        if ("entryentity1".equals(key)) {
            this.getPageCache().put(SELECTROW_CAHCE, cellClickEvent.getRow() + "");
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }
}

