/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analyze;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.executeanalyse.ExecuteAnalyseUtil;
import kd.epm.eb.common.permission.EBPermission;
import kd.epm.eb.common.permission.EBPermissionUtils;
import kd.epm.eb.common.utils.NewEbAppUtil;
import kd.epm.eb.formplugin.executeanalyse.AnalyseCommonMethod;
import kd.epm.eb.formplugin.executeanalyse.entity.BizModel;

public class DiffAnalyzeSchemeTreeListF7
extends StandardTreeListPlugin
implements EBPermission,
AnalyseCommonMethod {
    private static final String TREEVIEW_KEY = "treeview";

    public void afterCreateNewData(EventObject e) {
        if (!NewEbAppUtil.isNewEbModel((Long)this.getModelId())) {
            this.initLeftTree();
        }
    }

    private void initLeftTree() {
        TreeNode leftNode = this.generateTree();
        TreeView treeLeft = (TreeView)this.getControl(TREEVIEW_KEY);
        treeLeft.deleteAllNodes();
        if (leftNode != null) {
            treeLeft.updateNode(leftNode);
            treeLeft.addNode(leftNode);
            this.spreadAllNode(leftNode);
            this.cacheLeftRoot(leftNode);
            treeLeft.focusNode(leftNode);
            this.treeNodeClick(new TreeNodeEvent((Object)treeLeft, null, (Object)leftNode.getId()));
        }
    }

    private TreeNode generateTree() {
        List qFilters = ((ListShowParameter)this.getView().getFormShowParameter()).getListFilterParameter().getQFilters();
        if (qFilters == null) {
            return null;
        }
        TreeNode rootLeft = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"DiffAnalyzeSchemeTreeListF7_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        List bizModels = this.getBizModels(null, this.getModelId());
        bizModels.forEach(k -> {
            List busModels = this.getExistDataBusModels(k.getBusModels(), "multidim");
            if (busModels.size() != 0) {
                this.addNodeToChild(rootLeft, (BizModel)k, busModels);
            }
        });
        return rootLeft;
    }

    private void spreadAllNode(TreeNode treenode) {
        if (treenode == null) {
            return;
        }
        treenode.setIsOpened(true);
        if (treenode.getChildren() != null) {
            List nodes = treenode.getChildren();
            for (TreeNode t : nodes) {
                this.spreadAllNode(t);
            }
        }
    }

    protected void cacheLeftRoot(TreeNode rootleft) {
        this.getPageCache().put(TREEVIEW_KEY, SerializationUtils.toJsonString((Object)rootleft));
    }

    protected TreeNode getCacheLeftRoot() {
        String str = this.getPageCache().get(TREEVIEW_KEY);
        TreeNode leftRoot = null;
        if (str != null) {
            leftRoot = (TreeNode)SerializationUtils.fromJsonString((String)str, TreeNode.class);
        }
        return leftRoot;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
        TreeNode leftRoot = this.getCacheLeftRoot();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        if (leftRoot != null && billList != null) {
            TreeNode treeNode = leftRoot.getTreeNode(String.valueOf(e.getNodeId()), 3);
            Set<TreeNode> leafTreeNodes = this.getLeafTreeNodes(treeNode);
            HashSet datasetIds = new HashSet(16);
            leafTreeNodes.forEach(k -> {
                String[] split = k.getId().split("_");
                if (split.length >= 3) {
                    datasetIds.add(Long.parseLong(split[2]));
                }
            });
            QFilter qf = ExecuteAnalyseUtil.getInstance().getQFilter(datasetIds, "dataset", "creator", this.getModelId(), true, true);
            billList.setFilter(qf);
            billList.refresh();
        }
    }

    private Set<TreeNode> getLeafTreeNodes(TreeNode treeNode) {
        HashSet<TreeNode> result = new HashSet<TreeNode>(16);
        if (treeNode != null) {
            if (treeNode.getChildren() == null || treeNode.getChildren().size() == 0) {
                result.add(treeNode);
            } else if (treeNode.getChildren() != null) {
                for (TreeNode node : treeNode.getChildren()) {
                    result.addAll(this.getLeafTreeNodes(node));
                }
            }
        }
        return result;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedRows;
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        this.checkPermission(operateKey);
        if ("delete".equals(operateKey) && (listSelectedRows = args.getListSelectedData()) != null) {
            for (ListSelectedRow selectedRow : listSelectedRows) {
                if (selectedRow.getNumber() == null || !selectedRow.getNumber().startsWith("D-")) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u7cfb\u7edf\u521b\u5efa\u7684\u9ed8\u8ba4\u65b9\u6848\u3002", (String)"DiffAnalyzeSchemeTreeListF7_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void checkPermission(String operateKey) {
        String[] items;
        String permItem;
        Map permItemsMap;
        Map entityItems;
        if ("delete".equals(operateKey) && (entityItems = (Map)(permItemsMap = EBPermissionUtils.getInstance().getPermItem().getPermItemsMap()).get("eb_diffanalysis")) != null && (permItem = (String)entityItems.get("btn_editscheme")) != null && (items = permItem.split("@")) != null && items.length >= 3) {
            this.doEBCheckPermission(items[0], items[1], items[2]);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("delete".equals(e.getOperateKey()) && e.getOperationResult().isSuccess()) {
            TreeView treeLeft = (TreeView)this.getControl(TREEVIEW_KEY);
            this.treeNodeClick(new TreeNodeEvent((Object)treeLeft, null, (Object)treeLeft.getTreeState().getFocusNodeId()));
        }
    }

    public Long getModelId() {
        return (Long)((ListShowParameter)this.getView().getFormShowParameter()).getCustomParam("KEY_MODEL_ID");
    }

    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    public boolean isCheckModel() {
        return true;
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List listColumns = args.getListColumns();
        if (NewEbAppUtil.isNewEbModel((Long)this.getModelId())) {
            this.removeColumn(listColumns, "dataset.name");
        }
        this.removeColumn(listColumns, "bardelete");
        args.setListColumns(listColumns);
    }

    private void removeColumn(List<IListColumn> listColumns, String colKey) {
        IListColumn specialColumn = this.getSpecialColumn(listColumns, colKey);
        if (specialColumn == null) {
            return;
        }
        listColumns.remove(specialColumn);
    }

    private IListColumn getSpecialColumn(List<IListColumn> listColumns, String colKey) {
        IListColumn column = null;
        for (IListColumn listColumn : listColumns) {
            String listFieldKey = listColumn.getListFieldKey();
            if (!colKey.equals(listFieldKey)) continue;
            column = listColumn;
            break;
        }
        return column;
    }

    @Override
    public List<Long> getBusModelIdsByExecute() {
        return null;
    }

    @Override
    public List<Long> getBusModelIdsByMultiDim() {
        ArrayList<Long> busModelIds = new ArrayList<Long>(16);
        List qFilters = ((ListShowParameter)this.getView().getFormShowParameter()).getListFilterParameter().getQFilters();
        if (qFilters == null || qFilters.size() == 0) {
            return busModelIds;
        }
        DynamicObjectCollection multiSchemes = QueryServiceHelper.query((String)"eb_diffanalyzescheme", (String)"dataset.id", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (multiSchemes != null) {
            multiSchemes.forEach(e -> busModelIds.add(e.getLong("dataset.id")));
        }
        return busModelIds;
    }
}

