/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analyze;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.analyzeReport.service.AnalyseReportUtil;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.applybill.MemberShowType;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.enums.MemberDisplayTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.member.f7.MemberParamsUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.MetricUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class DiffDisplaySettingPlugin
extends AbstractFormPlugin {
    private static final String ENTRYENTITY = "entryentity";
    private static final String ENTRYENTITY1 = "entryentity1";
    private static final String CTRLKEY_DEFMEMBERDISPLAY = "defmemberdisplay";
    private static final String CTRLKEY_DEFEMPTYROWDISPLAY = "defemptyrowdisplay";
    private static final String CTRLKEY_DEFUNITDISPLAY = "defunitdisplay";
    private static final String CTRLKEY_METRIC = "metric";
    private static final String CTRLKEY_DECIMALNUM = "decimalnum";
    private static final String CTRLKEY_USE_SEP = "use_sep";
    private static final String CTRLKEY_DIMNUMBER = "dimnumber";
    private static final String CTRLKEY_DIMNAME = "dimname";
    private static final String CTRLKEY_HIDE = "hide";

    public void afterCreateNewData(EventObject e) {
        this.loadData();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_confirm", "btn_cancel", "defvalue"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String clickKey = ((Control)evt.getSource()).getKey();
        if ("btn_confirm".equals(clickKey)) {
            DynamicObjectCollection entryentity;
            Object defunitdisplay;
            Object defemptyrowdisplay;
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            Object defmemberdisplay = this.getModel().getValue(CTRLKEY_DEFMEMBERDISPLAY);
            if (defmemberdisplay != null) {
                map.put(CTRLKEY_DEFMEMBERDISPLAY, defmemberdisplay);
            }
            if ((defemptyrowdisplay = this.getModel().getValue(CTRLKEY_DEFEMPTYROWDISPLAY)) != null) {
                map.put(CTRLKEY_DEFEMPTYROWDISPLAY, defemptyrowdisplay);
            }
            if ((defunitdisplay = this.getModel().getValue(CTRLKEY_DEFUNITDISPLAY)) != null) {
                map.put(CTRLKEY_DEFUNITDISPLAY, defunitdisplay);
            }
            if ((entryentity = this.getModel().getEntryEntity(ENTRYENTITY)) != null) {
                HashMap<String, Integer> metricdisplay = new HashMap<String, Integer>(16);
                HashSet<String> metricdisplay_no_sep = new HashSet<String>(16);
                for (Object o : entryentity) {
                    metricdisplay.put(o.getString("metric.number"), o.getInt(CTRLKEY_DECIMALNUM));
                    if (o.getBoolean(CTRLKEY_USE_SEP)) continue;
                    metricdisplay_no_sep.add(o.getString("metric.number"));
                }
                map.put("metricdisplay", metricdisplay);
                map.put("metricdisplay_no_sep", metricdisplay_no_sep);
            }
            HashMap<String, String> defMember = new HashMap<String, String>(16);
            DynamicObjectCollection entryentity1 = this.getModel().getEntryEntity(ENTRYENTITY1);
            HashSet<String> hideDimensions = new HashSet<String>(16);
            if (entryentity1 != null) {
                for (DynamicObject o : entryentity1) {
                    if (o.getBoolean(CTRLKEY_HIDE)) {
                        hideDimensions.add(o.getString(CTRLKEY_DIMNUMBER));
                    }
                    if (!"eb_execanalysescheme".equals(this.getView().getParentView().getFormShowParameter().getFormId())) continue;
                    String defDimNumber = o.getString("defvaluenumber");
                    if (!o.getBoolean(CTRLKEY_HIDE)) continue;
                    if (StringUtils.isEmpty((String)defDimNumber)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u8bbe\u7f6e\u9690\u85cf\u65f6\u5fc5\u987b\u8981\u8bbe\u7f6e\u9ed8\u8ba4\u503c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"DiffDisplaySettingPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    defMember.put(o.getString(CTRLKEY_DIMNUMBER), defDimNumber);
                }
            }
            map.put("defmember", defMember);
            map.put("hide_dimensions", hideDimensions);
            this.getView().returnDataToParent((Object)SerializationUtils.serializeToBase64(map));
            this.getView().close();
        } else if ("defvalue".equals(clickKey)) {
            EntryGrid grid = (EntryGrid)this.getControl(ENTRYENTITY1);
            int[] selectRows = grid.getSelectRows();
            if (selectRows == null || selectRows.length < 1) {
                return;
            }
            DynamicObject clickRow = this.getModel().getEntryRowEntity(ENTRYENTITY1, selectRows[0]);
            String dimNumber = clickRow.getString(CTRLKEY_DIMNUMBER);
            Long modelId = this.getModelId();
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            Long datasetId = this.getDatasetId();
            Long businessModelId = modelCacheHelper.getBusModelByDataSet(datasetId);
            Long viewId = modelCacheHelper.getViewByBusModelAndDimNumber(businessModelId, dimNumber);
            MemberF7Parameter f7Param = NewF7Utils.singleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimNumber), (String)ListSelectedRow.class.getName());
            if (IDUtils.isNotNull((Long)businessModelId)) {
                f7Param.setBusModelId(businessModelId);
                f7Param.setDatasetIds(Collections.singletonList(datasetId));
            }
            if (IDUtils.isNotNull((Long)viewId)) {
                f7Param.setViewId(viewId);
            }
            if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
                f7Param.addCustomFilter(new QFilter("datatype", "in", (Object)AnalyseReportUtil.dataTypes));
            } else if (SysDimensionEnum.AuditTrail.getNumber().equals(dimNumber)) {
                f7Param.setHideDecompose(false);
            }
            NewF7Utils.openF7((IFormView)this.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "selectDim$" + dimNumber));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.startsWith("selectDim")) {
            String dimNumber = actionId.substring(actionId.indexOf("$"));
            if (closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection) {
                ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
                ListSelectedRow selectedRow = selectedRows.get(0);
                EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY1);
                int[] selectRows = entryGrid.getSelectRows();
                this.getModel().setValue("defvalue", (Object)selectedRow.getName(), selectRows[0]);
                this.getModel().setValue("defvaluenumber", (Object)selectedRow.getNumber(), selectRows[0]);
            }
        }
    }

    private void loadData() {
        Long modelid = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("modelid"));
        String displaySettingsStr = (String)this.getView().getFormShowParameter().getCustomParam("diffdisplaysettings");
        if (IDUtils.isNotNull((Long)modelid) && StringUtils.isNotEmpty((String)displaySettingsStr)) {
            Map metric_decimalnum = new HashMap(16);
            Collection metric_no_sep = new HashSet(16);
            Collection hideDimensions = new HashSet(16);
            HashMap defMemberMap = new HashMap(16);
            Map diffDisplaySettingsMap = (Map)SerializationUtils.fromJsonString((String)displaySettingsStr, Map.class);
            Object value = null;
            boolean hasLongNumberName = CollectionUtils.isNotEmpty((Collection)MemberParamsUtils.getLongNameNumDisplayParamsByCache((long)modelid));
            ComboEdit comboEdit = (ComboEdit)this.getControl(CTRLKEY_DEFMEMBERDISPLAY);
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
            if ("eb_execanalysescheme".equals(this.getView().getParentView().getFormShowParameter().getFormId())) {
                comboItems.add(new ComboItem(new LocaleString(MemberShowType.NAME.getDesc()), MemberShowType.NAME.getValue()));
                comboItems.add(new ComboItem(new LocaleString(MemberShowType.NUMBER.getDesc()), MemberShowType.NUMBER.getValue()));
                comboItems.add(new ComboItem(new LocaleString(MemberShowType.NAME_NUMBER.getDesc()), MemberShowType.NAME_NUMBER.getValue()));
            } else {
                comboItems.add(new ComboItem(new LocaleString(MemberDisplayTypeEnum.NAME.getDisplayName().loadKDString()), MemberDisplayTypeEnum.NAME.getIndex() + ""));
                comboItems.add(new ComboItem(new LocaleString(MemberDisplayTypeEnum.SIMPLENAME.getDisplayName().loadKDString()), MemberDisplayTypeEnum.SIMPLENAME.getIndex() + ""));
                comboItems.add(new ComboItem(new LocaleString(MemberDisplayTypeEnum.NUMBER.getDisplayName().loadKDString()), MemberDisplayTypeEnum.NUMBER.getIndex() + ""));
                comboItems.add(new ComboItem(new LocaleString(MemberDisplayTypeEnum.NAMEANDNUMBER.getDisplayName().loadKDString()), MemberDisplayTypeEnum.NAMEANDNUMBER.getIndex() + ""));
                comboItems.add(new ComboItem(new LocaleString(MemberDisplayTypeEnum.SIMNAMENUMBER.getDisplayName().loadKDString()), MemberDisplayTypeEnum.SIMNAMENUMBER.getIndex() + ""));
                if (hasLongNumberName) {
                    comboItems.add(new ComboItem(new LocaleString(MemberDisplayTypeEnum.LONGNUMBER.getDisplayName().loadKDString()), MemberDisplayTypeEnum.LONGNUMBER.getIndex() + ""));
                    comboItems.add(new ComboItem(new LocaleString(MemberDisplayTypeEnum.LONGNAME.getDisplayName().loadKDString()), MemberDisplayTypeEnum.LONGNAME.getIndex() + ""));
                    comboItems.add(new ComboItem(new LocaleString(MemberDisplayTypeEnum.LONGNAMENUMBER.getDisplayName().loadKDString()), MemberDisplayTypeEnum.LONGNAMENUMBER.getIndex() + ""));
                }
            }
            comboEdit.setComboItems(comboItems);
            if ("eb_execanalysescheme".equals(this.getView().getParentView().getFormShowParameter().getFormId())) {
                value = diffDisplaySettingsMap.get(CTRLKEY_DEFMEMBERDISPLAY);
                MemberShowType enumByValue = MemberShowType.getEnumByValue((String)String.valueOf(value));
                if (enumByValue == null) {
                    enumByValue = MemberShowType.NAME;
                }
                this.getModel().setValue(CTRLKEY_DEFMEMBERDISPLAY, (Object)enumByValue.getValue());
                value = diffDisplaySettingsMap.get(CTRLKEY_DEFEMPTYROWDISPLAY);
                if (value != null) {
                    this.getModel().setValue(CTRLKEY_DEFEMPTYROWDISPLAY, value);
                } else {
                    this.getModel().setValue(CTRLKEY_DEFEMPTYROWDISPLAY, (Object)"2");
                }
            } else {
                Object v = diffDisplaySettingsMap.get(CTRLKEY_DEFMEMBERDISPLAY);
                value = v;
                if (v != null) {
                    if (!hasLongNumberName && (value.equals(MemberDisplayTypeEnum.LONGNUMBER.getIndex() + "") || value.equals(MemberDisplayTypeEnum.LONGNAME.getIndex() + "") || value.equals(MemberDisplayTypeEnum.LONGNAMENUMBER.getIndex() + ""))) {
                        value = MemberDisplayTypeEnum.NAME.getIndex() + "";
                    }
                    this.getModel().setValue(CTRLKEY_DEFMEMBERDISPLAY, value);
                }
                Object v2 = diffDisplaySettingsMap.get(CTRLKEY_DEFEMPTYROWDISPLAY);
                value = v2;
                if (v2 != null) {
                    this.getModel().setValue(CTRLKEY_DEFEMPTYROWDISPLAY, value);
                }
            }
            Object v = diffDisplaySettingsMap.get(CTRLKEY_DEFUNITDISPLAY);
            value = v;
            if (v != null) {
                this.getModel().setValue(CTRLKEY_DEFUNITDISPLAY, value);
            }
            if ((value = diffDisplaySettingsMap.get("metricdisplay")) instanceof Map) {
                metric_decimalnum = (Map)value;
            }
            if (diffDisplaySettingsMap.get("metricdisplay_no_sep") instanceof Collection) {
                metric_no_sep = (Collection)diffDisplaySettingsMap.get("metricdisplay_no_sep");
            }
            if (diffDisplaySettingsMap.get("hide_dimensions") instanceof Collection) {
                hideDimensions = (Collection)diffDisplaySettingsMap.get("hide_dimensions");
            }
            if (diffDisplaySettingsMap.get("defmember") instanceof Map) {
                defMemberMap = (HashMap)diffDisplaySettingsMap.get("defmember");
            }
            this.getModel().deleteEntryData(ENTRYENTITY);
            DynamicObjectCollection metrics = MetricUtils.getMetricsByNumber((Long)this.getModelId(), metric_decimalnum.keySet());
            if (metrics != null && metrics.size() > 0) {
                this.getModel().batchCreateNewEntryRow(ENTRYENTITY, metrics.size());
                this.getModel().beginInit();
                int i = 0;
                for (DynamicObject metric : metrics) {
                    this.getModel().setValue(CTRLKEY_METRIC, (Object)metric.getLong("id"), i);
                    this.getModel().setValue(CTRLKEY_DECIMALNUM, metric_decimalnum.get(metric.getString("number")), i);
                    this.getModel().setValue(CTRLKEY_USE_SEP, (Object)(!metric_no_sep.contains(metric.getString("number")) ? 1 : 0), i);
                    ++i;
                }
                this.getModel().endInit();
                this.getView().updateView(ENTRYENTITY);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{CTRLKEY_METRIC});
            }
            if ("eb_execanalysescheme".equals(this.getView().getParentView().getFormShowParameter().getFormId())) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"defvalue"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"defvalue"});
            }
            this.getModel().deleteEntryData(ENTRYENTITY1);
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            List<kd.epm.eb.common.model.Dimension> dimensions = new ArrayList(16);
            if (this.getView().getFormShowParameter().getCustomParam("dimensionList") != null) {
                dimensions = (List)SerializationUtils.deSerializeFromBase64((String)((String)this.getView().getFormShowParameter().getCustomParam("dimensionList")));
            } else {
                List dimensionList = modelCacheHelper.getDimensionList(this.getDatasetId());
                for (Dimension dimension : dimensionList) {
                    kd.epm.eb.common.model.Dimension dim = new kd.epm.eb.common.model.Dimension(dimension.getId(), dimension.getName(), dimension.getNumber());
                    dimensions.add(dim);
                }
            }
            if (dimensions.size() > 0) {
                this.getModel().batchCreateNewEntryRow(ENTRYENTITY1, dimensions.size());
                int i = 0;
                this.getModel().beginInit();
                Long businessModelId = modelCacheHelper.getBusModelByDataSet(this.getDatasetId());
                for (kd.epm.eb.common.model.Dimension dimension : dimensions) {
                    String dimNumber = dimension.getNumber();
                    this.getModel().setValue(CTRLKEY_DIMNUMBER, (Object)dimNumber, i);
                    this.getModel().setValue(CTRLKEY_DIMNAME, (Object)dimension.getName(), i);
                    this.getModel().setValue(CTRLKEY_HIDE, (Object)hideDimensions.contains(dimNumber), i);
                    this.getView().setEnable(Boolean.valueOf(hideDimensions.contains(dimNumber)), i, new String[]{"defvalue"});
                    Member m = modelCacheHelper.getMemberByAnyView(businessModelId, dimNumber, (String)defMemberMap.get(dimNumber));
                    if (!defMemberMap.isEmpty() && defMemberMap.containsKey(dimNumber)) {
                        this.getModel().setValue("defvalue", (Object)(m != null ? m.getName() : null), i);
                        this.getModel().setValue("defvaluenumber", defMemberMap.get(dimNumber), i);
                    }
                    ++i;
                }
                this.getModel().endInit();
                this.getView().updateView(ENTRYENTITY1);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if ("defvalue".equals(e.getProperty().getName())) {
            if ("".equals(changeData.getNewValue())) {
                this.getModel().setValue("defvaluenumber", null, rowIndex);
            }
        } else if (CTRLKEY_HIDE.equals(e.getProperty().getName())) {
            Boolean newValue = (Boolean)changeData.getNewValue();
            if (!newValue.booleanValue()) {
                this.getModel().setValue("defvalue", null, rowIndex);
                this.getModel().setValue("defvaluenumber", null, rowIndex);
            }
            this.getView().setEnable(newValue, rowIndex, new String[]{"defvalue"});
        }
    }

    @Override
    public Long getModelId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("modelid"));
    }

    public Long getDatasetId() {
        return IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("datasetid"));
    }
}

