/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analyze;

import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.epm.eb.common.enums.QuickAnalyzeActionEnum;
import kd.epm.eb.formplugin.analyze.DiffAnalyzeHelper;

public class DiffExpressionEditPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final Map<String, String> operationsMap = new HashMap<String, String>(){
        {
            this.put("plus", "+");
            this.put("subtract", "-");
            this.put("multiple", "*");
            this.put("divide", "/");
            this.put("leftparentheses", "(");
            this.put("rightparentheses", ")");
        }
    };
    private static final Map<String, String> functionsMap = new LinkedHashMap<String, String>(){
        {
            this.put(QuickAnalyzeActionEnum.YEAR_ON_YEAR.getNumber(), QuickAnalyzeActionEnum.YEAR_ON_YEAR.getName());
            this.put(QuickAnalyzeActionEnum.MONTH_ON_MONTH.getNumber(), QuickAnalyzeActionEnum.MONTH_ON_MONTH.getName());
        }
    };
    private static final List<String> RATIO_FUNCS = Lists.newArrayList((Object[])new String[]{QuickAnalyzeActionEnum.RATIO_COL.getNumber(), QuickAnalyzeActionEnum.RATIO_ROW.getNumber(), QuickAnalyzeActionEnum.RATIO_SHEET.getNumber(), QuickAnalyzeActionEnum.RATIO_CURCOL_DMEM.getNumber(), QuickAnalyzeActionEnum.RATIO_CURROW_DMEM.getNumber(), QuickAnalyzeActionEnum.RATIO_CURSHEET_DMEM.getNumber()});
    private static final List<String> RANK_FUNCS = Lists.newArrayList((Object[])new String[]{QuickAnalyzeActionEnum.RANK_COL.getNumber(), QuickAnalyzeActionEnum.RANK_ROW.getNumber(), QuickAnalyzeActionEnum.RANK_SHEET.getNumber(), QuickAnalyzeActionEnum.RANK_CURCOL_DMEM.getNumber(), QuickAnalyzeActionEnum.RANK_CURROW_DMEM.getNumber(), QuickAnalyzeActionEnum.RANK_CURSHEET_DMEM.getNumber()});
    private static final String[] fieldList = new String[]{"+", "-", "*", "/"};
    private static final String KEY_EXPRDISPLAY = "textareafield";
    private static final String KEY_EXPR = "expr";
    private static final String RADIOGROUP_FM = "radiogroup_fm";
    private static final String PRECISION_DECIMAL = "precision_decimal";
    private static final String PRECISION_PERCENT = "precision_percent";
    private static final String ROOT_ID = "0";
    private static final String FM_DECIMAL = "1";
    private static final String FM_PERCENT = "2";
    private static final String TREEVIEW_DATACOL = "treeviewap";
    private static final String TREEVIEW_FUNCS = "treeviewap1";
    private TreeNode treeRoot_dataCol = null;
    private TreeNode treeRoot_funcs = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btn = null;
        for (String key : operationsMap.keySet()) {
            btn = (Button)this.getControl(key);
            if (btn == null) continue;
            btn.addClickListener((ClickListener)this);
        }
        this.addClickListeners(new String[]{"btnok", "btncancel", "backspace", "clr"});
        ((TreeView)this.getView().getControl(TREEVIEW_DATACOL)).addTreeNodeClickListener((TreeNodeClickListener)this);
        ((TreeView)this.getView().getControl(TREEVIEW_FUNCS)).addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map<String, String> dataColNamesMap = this.getDataColNamesMap();
        if (dataColNamesMap != null) {
            this.treeRoot_dataCol = this.buildTreeDataCol(dataColNamesMap);
            ((TreeView)this.getView().getControl(TREEVIEW_DATACOL)).addNode(this.treeRoot_dataCol);
            this.treeRoot_funcs = this.buildTreeFuncs(functionsMap);
            ((TreeView)this.getView().getControl(TREEVIEW_FUNCS)).addNode(this.treeRoot_funcs);
            String expr = (String)this.getView().getFormShowParameter().getCustomParams().get(KEY_EXPR);
            dataColNamesMap.putAll(functionsMap);
            String exprdisplay = DiffAnalyzeHelper.updateExpressionDisplay(expr, dataColNamesMap, null);
            this.getModel().setValue(KEY_EXPR, (Object)expr);
            this.getModel().setValue(KEY_EXPRDISPLAY, (Object)exprdisplay);
            int[] fm_type = this.fmToType((String)this.getView().getFormShowParameter().getCustomParams().get("fm"));
            if (fm_type != null && fm_type.length == 2) {
                this.getModel().setValue(RADIOGROUP_FM, (Object)String.valueOf(fm_type[0]));
                if (FM_DECIMAL.equals(String.valueOf(fm_type[0]))) {
                    this.getModel().setValue(PRECISION_DECIMAL, (Object)fm_type[1]);
                } else if (FM_PERCENT.equals(String.valueOf(fm_type[0]))) {
                    this.getModel().setValue(PRECISION_PERCENT, (Object)fm_type[1]);
                }
            }
            this.getPageCache().put("cache_treeRoot_dataCol", SerializationUtils.toJsonString((Object)this.treeRoot_dataCol));
            this.getPageCache().put("cache_treeRoot_funcs", SerializationUtils.toJsonString((Object)this.treeRoot_funcs));
        }
    }

    public void click(EventObject evt) {
        Button btn = (Button)evt.getSource();
        String key = btn.getKey();
        if ("btnok".equalsIgnoreCase(key)) {
            this.closeAndReturn();
        } else if ("btncancel".equalsIgnoreCase(key)) {
            this.getView().close();
        } else if ("clr".equalsIgnoreCase(key)) {
            this.getModel().setValue(KEY_EXPRDISPLAY, (Object)"");
            this.getModel().setValue(KEY_EXPR, (Object)"");
        } else if ("backspace".equalsIgnoreCase(key)) {
            String expr = (String)this.getModel().getValue(KEY_EXPR);
            if (this.getFunc(expr) != null) {
                this.getModel().setValue(KEY_EXPRDISPLAY, (Object)"");
                this.getModel().setValue(KEY_EXPR, (Object)"");
            } else {
                this.backSpaceExpression(this.getView(), key, KEY_EXPR);
                this.backSpaceExpression(this.getView(), key, KEY_EXPRDISPLAY);
            }
        } else if (key != null) {
            this.insertExpression(key, operationsMap.get(key));
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        if (e.getNodeId() != null && !ROOT_ID.equals(e.getNodeId()) && !"".equals(e.getNodeId().toString().trim())) {
            String key = ((TreeView)e.getSource()).getKey();
            if (TREEVIEW_DATACOL.equals(key)) {
                this.insertDataCol(e.getNodeId().toString().trim());
            } else if (TREEVIEW_FUNCS.equals(key)) {
                this.insertFuncs(e.getNodeId().toString().trim());
            }
        }
    }

    private void insertFuncs(String func) {
        if (func != null && functionsMap.containsKey(func)) {
            String expr = (String)this.getModel().getValue(KEY_EXPR);
            String expr_disp = (String)this.getModel().getValue(KEY_EXPRDISPLAY);
            String funcInExpr = this.getFunc(expr);
            if (funcInExpr != null) {
                this.getModel().setValue(KEY_EXPR, (Object)expr.replaceAll(funcInExpr, func));
                this.getModel().setValue(KEY_EXPRDISPLAY, (Object)expr_disp.replaceAll(QuickAnalyzeActionEnum.getNameByNumber((String)funcInExpr), QuickAnalyzeActionEnum.getNameByNumber((String)func)));
            } else {
                this.getModel().setValue(KEY_EXPR, (Object)func);
                this.getModel().setValue(KEY_EXPRDISPLAY, (Object)QuickAnalyzeActionEnum.getNameByNumber((String)func));
            }
        }
    }

    private void insertDataCol(String id) {
        String expr = (String)this.getModel().getValue(KEY_EXPR);
        String funcInExpr = this.getFunc(expr);
        if (funcInExpr != null) {
            this.getModel().setValue(KEY_EXPR, (Object)(funcInExpr + " ( " + id + " ) "));
            this.getModel().setValue(KEY_EXPRDISPLAY, (Object)(QuickAnalyzeActionEnum.getNameByNumber((String)funcInExpr) + " ( " + this.transIDtoName(TREEVIEW_DATACOL, id) + " ) "));
        } else {
            this.insertExpression(this.getView(), TREEVIEW_DATACOL, KEY_EXPR, id);
            this.insertExpression(this.getView(), TREEVIEW_DATACOL, KEY_EXPRDISPLAY, this.transIDtoName(TREEVIEW_DATACOL, id));
        }
    }

    private String getFunc(String expr) {
        if (expr != null) {
            for (String func : functionsMap.keySet()) {
                if (expr.indexOf(func) < 0) continue;
                return func;
            }
        }
        return null;
    }

    private void closeAndReturn() {
        HashMap<String, String> map = new HashMap<String, String>();
        String exprdisplay = (String)this.getModel().getValue(KEY_EXPRDISPLAY);
        String expr = (String)this.getModel().getValue(KEY_EXPR);
        if (expr != null) {
            String fm_decimal;
            if (StringUtils.isBlank((CharSequence)expr)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"DiffAnalyzePlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean validExpr = true;
            String func = this.getFunc(expr);
            if (func != null) {
                validExpr = Pattern.matches("^" + func + "\\(" + "A" + "[0-9]*\\)$", expr.replaceAll(" ", ""));
            } else {
                try {
                    FormulaEngine.parseFormula((String)expr);
                }
                catch (Exception e) {
                    validExpr = false;
                }
            }
            if (!validExpr) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bef\u3002", (String)"DiffAnalyzePlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            map.put(KEY_EXPR, expr);
            map.put("exprdisplay", exprdisplay);
            int index = 2;
            String fm_display = String.valueOf(this.getModel().getValue(RADIOGROUP_FM));
            if (FM_DECIMAL.equals(fm_display)) {
                fm_decimal = String.valueOf(this.getModel().getValue(PRECISION_DECIMAL));
                index = Integer.parseInt(fm_decimal);
                map.put("fm", this.typeToFm(new int[]{Integer.parseInt(fm_display), index}));
            }
            if (FM_PERCENT.equals(fm_display)) {
                fm_decimal = String.valueOf(this.getModel().getValue(PRECISION_PERCENT));
                index = Integer.parseInt(fm_decimal);
                map.put("fm", this.typeToFm(new int[]{Integer.parseInt(fm_display), index}));
            }
            if (index == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c0f\u6570\u4fdd\u7559\u7684\u4f4d\u6570\u8981\u5927\u4e8e0", (String)"", (String)"", (Object[])new Object[0]));
                return;
            }
            this.getView().returnDataToParent(map);
            this.getView().close();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"DiffAnalyzePlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private TreeNode buildTreeDataCol(Map<String, String> idNameMap) {
        TreeNode treeRoot = new TreeNode(null, ROOT_ID, "Root");
        treeRoot.setIsOpened(true);
        if (idNameMap != null) {
            for (Map.Entry<String, String> entry : idNameMap.entrySet()) {
                treeRoot.addChild(new TreeNode(treeRoot.getId(), entry.getKey(), entry.getValue()));
            }
        }
        return treeRoot;
    }

    private TreeNode buildTreeFuncs(Map<String, String> idNameMap) {
        TreeNode treeRoot = new TreeNode(null, ROOT_ID, "Root");
        treeRoot.setIsOpened(true);
        if (idNameMap != null) {
            TreeNode ratioNode = new TreeNode(ROOT_ID, "ratioNode", ResManager.loadKDString((String)"\u5360\u6bd4", (String)"DiffMenuList_2", (String)"epm-eb-spread", (Object[])new Object[0]));
            TreeNode rankNode = new TreeNode(ROOT_ID, "rankNode", ResManager.loadKDString((String)"\u6392\u540d", (String)"DiffMenuList_5", (String)"epm-eb-spread", (Object[])new Object[0]));
            for (Map.Entry<String, String> entry : idNameMap.entrySet()) {
                if (RATIO_FUNCS.contains(entry.getKey())) {
                    ratioNode.addChild(new TreeNode(treeRoot.getId(), entry.getKey(), entry.getValue()));
                    continue;
                }
                if (RANK_FUNCS.contains(entry.getKey())) {
                    rankNode.addChild(new TreeNode(treeRoot.getId(), entry.getKey(), entry.getValue()));
                    continue;
                }
                treeRoot.addChild(new TreeNode(treeRoot.getId(), entry.getKey(), entry.getValue()));
            }
            if (ratioNode.getChildren() != null && ratioNode.getChildren().size() > 0) {
                treeRoot.addChild(ratioNode);
                ratioNode.setIsOpened(true);
            }
            if (rankNode.getChildren() != null && rankNode.getChildren().size() > 0) {
                treeRoot.addChild(rankNode);
                rankNode.setIsOpened(true);
            }
        }
        return treeRoot;
    }

    private Map<String, String> getDataColNamesMap() {
        String colIndexNameMap_str = (String)this.getView().getFormShowParameter().getCustomParams().get("colIndexNameMap");
        if (colIndexNameMap_str != null) {
            Map colIndexNameMap = (Map)SerializationUtils.fromJsonString((String)colIndexNameMap_str, Map.class);
            LinkedHashMap<String, String> colNamesMap = new LinkedHashMap<String, String>(colIndexNameMap.size());
            colIndexNameMap.forEach((k, v) -> colNamesMap.put("A" + k, (String)v));
            return colNamesMap;
        }
        return null;
    }

    private Map<String, String> getFuncNamesMap() {
        HashMap<String, String> colNamesMap = new HashMap<String, String>(functionsMap.size());
        functionsMap.forEach((k, v) -> colNamesMap.put((String)v, QuickAnalyzeActionEnum.getNameByNumber((String)v)));
        return colNamesMap;
    }

    private int[] fmToType(String fm) {
        if (fm != null) {
            int[] type = new int[2];
            if (fm.endsWith("%")) {
                type[0] = Integer.parseInt(FM_PERCENT);
                fm = fm.replace("%", "");
            } else {
                type[0] = Integer.parseInt(FM_DECIMAL);
            }
            type[1] = fm.indexOf(".") > 0 ? fm.length() - fm.lastIndexOf(".") - 1 : 2;
            return type;
        }
        return null;
    }

    private String typeToFm(int[] type) {
        if (type != null && type.length == 2) {
            boolean isRatio = FM_PERCENT.equals(String.valueOf(type[0]));
            StringBuilder sb = new StringBuilder();
            if (type[1] > 0) {
                sb.append("#,##0.");
                for (int i = 0; i < type[1]; ++i) {
                    sb.append('0');
                }
            } else {
                sb.append("#,##0");
            }
            if (isRatio) {
                sb.append('%');
            }
            return sb.toString();
        }
        return null;
    }

    private String insertCharacter(String pStr, String str, int pos) {
        int i;
        if (pStr.length() < pos) {
            pos = pStr.length();
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < pos; ++i) {
            sb.append(pStr.charAt(i));
        }
        sb.append(str);
        for (i = pos; i < pStr.length(); ++i) {
            sb.append(pStr.charAt(i));
        }
        return sb.toString();
    }

    private void insertExpression(IFormView view, String buttonKey, String textFieldKey, String str) {
        int pos = this.getCursorIndex(view, buttonKey, textFieldKey);
        String expression = (String)view.getModel().getValue(textFieldKey);
        if (StringUtils.isBlank((CharSequence)expression)) {
            expression = str;
        } else {
            String insertStr = " " + str + " ";
            expression = this.insertCharacter(expression, insertStr, pos);
        }
        view.getModel().setValue(textFieldKey, (Object)expression);
    }

    public void backSpaceExpression(IFormView view, String buttonKey, String textFieldKey) {
        String expression = (String)view.getModel().getValue(textFieldKey);
        if (!StringUtils.isBlank((CharSequence)expression)) {
            int cursorIndex = this.getCursorIndex(view, buttonKey, textFieldKey);
            String part1 = expression.substring(0, cursorIndex);
            String part2 = expression.substring(cursorIndex);
            String partDel = part1;
            int length = fieldList.length;
            for (int i = 0; i < length; ++i) {
                String str = fieldList[i];
                int lastIndex = partDel.lastIndexOf(str);
                if (lastIndex <= 0 || !"".equals((partDel = partDel.substring(lastIndex + str.length())).trim())) continue;
                partDel = str;
                break;
            }
            String[] partDelSplit = partDel.split(" ");
            for (length = partDelSplit.length - 1; length >= 0; --length) {
                if ("".equals(partDelSplit[length].trim())) continue;
                partDel = partDelSplit[length];
                break;
            }
            expression = part1.substring(0, part1.lastIndexOf(partDel)) + part2;
            view.getModel().setValue(textFieldKey, (Object)expression);
        }
    }

    private int getCursorIndex(IFormView view, String buttonKey, String textFieldKey) {
        String textValue = (String)view.getModel().getValue(textFieldKey);
        return StringUtils.isBlank((CharSequence)textValue) ? 0 : textValue.length();
    }

    private void insertExpression(String buttonKey, String str) {
        this.insertExpression(this.getView(), buttonKey, KEY_EXPR, str);
        if (TREEVIEW_DATACOL.equals(buttonKey) || TREEVIEW_FUNCS.equals(buttonKey)) {
            this.insertExpression(this.getView(), buttonKey, KEY_EXPRDISPLAY, this.transIDtoName(buttonKey, str));
        } else {
            this.insertExpression(this.getView(), buttonKey, KEY_EXPRDISPLAY, str);
        }
    }

    private String transIDtoName(String treeKey, String id) {
        TreeNode treeNode;
        TreeNode root = null;
        if (TREEVIEW_DATACOL.equals(treeKey)) {
            root = this.getTreeRoot_dataCol();
        } else if (TREEVIEW_FUNCS.equals(treeKey)) {
            root = this.getTreeRoot_funcs();
        }
        if (root != null && (treeNode = root.getTreeNode(id, 5)) != null) {
            return treeNode.getText();
        }
        return null;
    }

    private TreeNode getTreeRoot_dataCol() {
        String cache_treeRoot_dataCol;
        if (this.treeRoot_dataCol == null && (cache_treeRoot_dataCol = this.getPageCache().get("cache_treeRoot_dataCol")) != null) {
            this.treeRoot_dataCol = (TreeNode)SerializationUtils.fromJsonString((String)cache_treeRoot_dataCol, TreeNode.class);
        }
        return this.treeRoot_dataCol;
    }

    private TreeNode getTreeRoot_funcs() {
        String cache_treeRoot_funcs;
        if (this.treeRoot_funcs == null && (cache_treeRoot_funcs = this.getPageCache().get("cache_treeRoot_funcs")) != null) {
            this.treeRoot_funcs = (TreeNode)SerializationUtils.fromJsonString((String)cache_treeRoot_funcs, TreeNode.class);
        }
        return this.treeRoot_funcs;
    }
}

