/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analyze;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.entity.memberF7.SingleTreeF7Parameter;
import kd.epm.eb.common.enums.QuickAnalyzeActionEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.olap.enums.DataRowEnum;

public class DiffVersionComparePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String F7_PREFIX_BASE = "base_";
    private static final String F7_PREFIX_TARGET = "target_";
    private static final String CUSTOMIZE = "customize";
    private static final String PANEL_BASEDIMS = "panel_basedims";
    private static final String PANEL_TARGETDIMS = "cardentryflexpanelap";
    private List<Dimension> allDims = null;
    private Map<String, String> dimNamesMap = null;
    private Map<String, String> dimCtrlKeyMap = null;
    private Map<String, String> f7KeyDimMap_base = null;
    private Map<String, String> f7KeyDimMap_target = null;
    private static final String[] BASE_F7KEYS = new String[]{"base_entity", "base_account", "base_metric", "base_budgetperiod", "base_changetype", "base_internalcompany", "base_currency", "base_audittrail", "base_version", "base_datatype", "base_customize1", "base_customize2", "base_customize3", "base_customize4", "base_customize5", "base_customize6", "base_customize7", "base_customize8", "base_customize9"};
    private static final String[] TARGET_F7KEYS = new String[]{"target_entity", "target_account", "target_metric", "target_budgetperiod", "target_changetype", "target_internalcompany", "target_currency", "target_audittrail", "target_version", "target_datatype", "target_customize1", "target_customize2", "target_customize3", "target_customize4", "target_customize5", "target_customize6", "target_customize7", "target_customize8", "target_customize9"};
    private Set<String> selectedDims = null;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        PluginUtils.registerF7Listener(BASE_F7KEYS, true, false, this);
        PluginUtils.registerF7Listener(TARGET_F7KEYS, true, false, this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put("model", (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        this.getPageCache().put("DATASETID", (String)this.getView().getFormShowParameter().getCustomParam("DATASETID"));
        this.bulidComboItems();
        this.updateControlMetas();
        this.setDimensionF7(this.getSelectedDims());
        this.initDefaultValues();
    }

    private void initDefaultValues() {
        Map<String, List<String>> dimMems = this.getCompareDimMembers();
        if (dimMems != null && dimMems.size() > 0) {
            this.f7KeyDimMap_base = this.getF7KeyDimMap_base();
            IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
            Long datasetId = this.getDatasetId();
            Map viewIds = modelCacheHelper.getViewsByDataSet(datasetId);
            for (Map.Entry<String, List<String>> entry : dimMems.entrySet()) {
                String f7Key = this.f7KeyDimMap_base.get(entry.getKey());
                List<String> members = entry.getValue();
                if (members == null || members.size() <= 0) continue;
                Member member = modelCacheHelper.getMember(entry.getKey(), (Long)viewIds.get(entry.getKey()), members.get(0));
                if (f7Key == null || member == null) continue;
                this.getModel().setValue(f7Key, (Object)member.getId());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("dimselect".equals(key)) {
            Object newVal = e.getChangeSet()[0].getNewValue();
            Set<String> dimNumbers = this.getVisibleDims(newVal);
            this.setDimensionF7(dimNumbers);
        }
    }

    private Set<String> getVisibleDims(Object object) {
        HashSet<String> dimNumbers = new HashSet<String>();
        if (object instanceof String) {
            String[] splited;
            for (String dimNumber : splited = ((String)object).split(",")) {
                if (!StringUtils.isNotEmpty((String)dimNumber)) continue;
                dimNumbers.add(dimNumber);
            }
        }
        return dimNumbers;
    }

    private Set<String> getSelectedDims() {
        if (this.selectedDims == null) {
            this.selectedDims = this.getVisibleDims(this.getModel().getValue("dimselect"));
        }
        return this.selectedDims;
    }

    private void setDimensionF7(Set<String> dimNumbers) {
        HashSet<String> visibleBaseF7 = new HashSet<String>(16);
        HashSet<String> visibleTargetF7 = new HashSet<String>(16);
        for (String dimNumber : dimNumbers) {
            visibleBaseF7.add(this.getF7KeyDimMap_base().get(dimNumber));
            visibleTargetF7.add(this.getF7KeyDimMap_target().get(dimNumber));
        }
        this.getView().setVisible(Boolean.valueOf(false), BASE_F7KEYS);
        this.getView().setVisible(Boolean.valueOf(true), visibleBaseF7.toArray(new String[0]));
        int size = this.getModel().getEntryEntity(ENTRYENTITY).size();
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
        for (int i = 0; i < size; ++i) {
            cardEntry.setChildVisible(false, i, TARGET_F7KEYS);
            cardEntry.setChildVisible(true, i, visibleTargetF7.toArray(new String[0]));
        }
    }

    private void updateControlMetas() {
        this.dimNamesMap = this.getDimNamesMap();
        if (this.dimNamesMap != null) {
            for (Map.Entry<String, String> entry : this.dimNamesMap.entrySet()) {
                String dimNumber = entry.getKey();
                String dimKey = this.dimCtrlKeyMap.get(dimNumber);
                if (!dimKey.contains(CUSTOMIZE)) continue;
                String dimName = entry.getValue();
                HashMap<String, LocaleString> prop = new HashMap<String, LocaleString>(1);
                prop.put("caption", new LocaleString(dimName));
                this.getView().updateControlMetadata(F7_PREFIX_BASE + dimKey, prop);
                this.getView().updateControlMetadata(F7_PREFIX_TARGET + dimKey, prop);
            }
            HashMap prop = new HashMap(1);
            HashMap<String, LocaleString> itemprop = new HashMap<String, LocaleString>(1);
            itemprop.put("emptytip", new LocaleString(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6807\u9898\uff0c\u5982\uff1a\u76ee\u6807\u3002", (String)"DiffVersionComparePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0])));
            prop.put("item", itemprop);
            this.getView().updateControlMetadata("title_target", prop);
        }
    }

    public void click(EventObject evt) {
        DynamicObject scheme;
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.equals("btnok") && this.validateInput() && (scheme = this.generateScheme()) != null) {
            this.forwordPage(scheme);
        }
    }

    private void forwordPage(DynamicObject scheme) {
        IFormView formView = this.getView();
        if (formView != null && scheme != null) {
            IFormView mainPageView = this.getView().getMainView();
            IFormView parentView = this.getView().getParentView();
            String pageId = this.getView().getPageId() + scheme.getString("id");
            if (parentView != null && mainPageView != null) {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("eb_diffanalysis");
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)String.valueOf(this.getModelId()));
                formShowParameter.setCustomParam("eb_dataset", (Object)String.valueOf(this.getDatasetId()));
                formShowParameter.setCustomParam("eb_diffanalyzescheme", (Object)scheme.getString("id"));
                formShowParameter.setPageId(pageId);
                formShowParameter.setParentPageId(parentView.getPageId());
                formShowParameter.setParentFormId(parentView.getEntityId());
                parentView.showForm(formShowParameter);
                this.getView().sendFormAction(parentView);
            }
            formView.close();
        }
    }

    private DynamicObject generateScheme() {
        DynamicObject dynamicObject = this.generateSchemeHeader();
        if (dynamicObject != null) {
            this.generateSchemeCols(dynamicObject);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            return dynamicObject;
        }
        return null;
    }

    private boolean validateInput() {
        boolean versionSelected;
        Set<String> selectedDims = this.getSelectedDims();
        boolean bl = versionSelected = selectedDims != null && selectedDims.contains(SysDimensionEnum.Version.getNumber());
        if (!versionSelected) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5bf9\u6bd4\u7684\u7ef4\u5ea6\u3002", (String)"DiffVersionComparePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection compareTargets = this.getModel().getEntryEntity(ENTRYENTITY);
        HashSet<String> fields = new HashSet<String>(16);
        HashSet<String> titles = new HashSet<String>(16);
        titles.add((String)this.getModel().getValue("title_base"));
        for (DynamicObject target : compareTargets) {
            if (StringUtils.isEmpty((String)target.getString("title_target"))) {
                fields.add(ResManager.loadKDString((String)"\u76ee\u6807\u6807\u9898", (String)"DiffVersionComparePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else {
                if (titles.contains(target.getString("title_target"))) {
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u6807\u9898\u4e0d\u5141\u8bb8\u91cd\u590d\uff1a%1\u3002", (String)"DiffVersionComparePlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{target.getString("title_target")}));
                    return false;
                }
                titles.add(target.getString("title_target"));
            }
            for (String dimNumber : selectedDims) {
                if (target.get(this.getF7KeyDimMap_target().get(dimNumber)) != null) continue;
                fields.add(this.getDimNamesMap().get(dimNumber));
            }
        }
        if (fields.size() > 0) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8bf7\u8f93\u5165\u5fc5\u5f55\u9879\uff1a%1\u3002", (String)"DiffVersionComparePlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{fields}));
            return false;
        }
        return true;
    }

    private DynamicObject generateSchemeHeader() {
        String userId = RequestContext.get().getUserId();
        Date now = TimeServiceHelper.now();
        long id = DBServiceHelper.genGlobalLongId();
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_diffanalyzescheme");
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("number", (Object)("Q-" + id));
        dynamicObject.set("type", (Object)1);
        dynamicObject.set("creator", (Object)userId);
        dynamicObject.set("createtime", (Object)now);
        dynamicObject.set("modifier", (Object)userId);
        dynamicObject.set("modifytime", (Object)now);
        dynamicObject.set("model", (Object)this.getModelId());
        dynamicObject.set("dataset", (Object)this.getDatasetId());
        dynamicObject.set("name", this.getFormCustomParam("name") != null ? this.getFormCustomParam("name") : QuickAnalyzeActionEnum.VERSION_COMPARE.getName());
        return dynamicObject;
    }

    /*
     * WARNING - void declaration
     */
    private void generateSchemeCols(DynamicObject dynamicObject) {
        void var15_19;
        String f7Key;
        if (dynamicObject == null) {
            return;
        }
        this.selectedDims = this.getSelectedDims();
        this.f7KeyDimMap_base = this.getF7KeyDimMap_base();
        this.f7KeyDimMap_target = this.getF7KeyDimMap_target();
        this.dimNamesMap = this.getDimNamesMap();
        HashMap<String, String> dataColConfigMap_base = new HashMap<String, String>(16);
        LinkedList dataColConfigs = new LinkedList();
        String col_name_key = "_COL_NAME_KEY_";
        String highlight_target_key = "HIGHLIGHT_TARGET";
        Boolean showdiff = (Boolean)this.getModel().getValue("showdiff");
        String list_diff = (String)this.getModel().getValue("list_diff");
        Boolean highlight_diff = (Boolean)this.getModel().getValue("highlight_diff");
        Boolean showratio = (Boolean)this.getModel().getValue("showratio");
        String list_ratio = (String)this.getModel().getValue("list_ratio");
        Boolean highlight_ratio = (Boolean)this.getModel().getValue("highlight_ratio");
        for (String string : this.selectedDims) {
            f7Key = this.f7KeyDimMap_base.get(string);
            DynamicObject f7Value = (DynamicObject)this.getModel().getValue(f7Key);
            if (f7Value == null) continue;
            dataColConfigMap_base.put(string, f7Value.getString("number"));
        }
        dataColConfigMap_base.put(col_name_key, (String)this.getModel().getValue("title_base"));
        dataColConfigs.add(dataColConfigMap_base);
        DynamicObjectCollection compareTargets = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject target : compareTargets) {
            HashMap<String, String> dataColConfigMap_target = new HashMap<String, String>(16);
            for (String string : this.selectedDims) {
                f7Key = this.f7KeyDimMap_target.get(string);
                if (!(target.get(f7Key) instanceof DynamicObject)) continue;
                dataColConfigMap_target.put(string, ((DynamicObject)target.get(f7Key)).getString("number"));
            }
            dataColConfigMap_target.put(col_name_key, target.getString("title_target"));
            dataColConfigMap_target.put(highlight_target_key, target.getString("highlight_target"));
            dataColConfigs.add(dataColConfigMap_target);
        }
        boolean bl = true;
        if (showdiff.booleanValue()) {
            void var15_18;
            ++var15_18;
        }
        if (showratio.booleanValue()) {
            ++var15_19;
        }
        long[] entryIds = DBServiceHelper.genLongIds((String)"t_eb_analyzeschemecols", (int)(dataColConfigs.size() * var15_19));
        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection(ENTRYENTITY);
        int colIndex = 0;
        for (Map map : dataColConfigs) {
            DynamicObject dataCol = entryentity.addNew();
            dataCol.set("id", (Object)entryIds[colIndex]);
            dataCol.set("seq", (Object)colIndex);
            dataCol.set("coltype", (Object)DataRowEnum.DATA.getIndex());
            dataCol.set("colname", map.remove(col_name_key));
            if ("true".equalsIgnoreCase((String)map.remove(highlight_target_key))) {
                // empty if block
            }
            dataCol.set("colconfigjson", (Object)SerializationUtils.toJsonString((Object)map));
            ++colIndex;
        }
        if (showdiff.booleanValue() || showratio.booleanValue()) {
            DynamicObject baseDataCol = (DynamicObject)entryentity.get(0);
            for (int i = 1; i < dataColConfigs.size(); ++i) {
                void var20_40;
                void var19_32;
                HashMap<String, Object> calColConfigMap;
                DynamicObject calCol;
                DynamicObject targetDataCol = (DynamicObject)entryentity.get(i);
                if (showdiff.booleanValue()) {
                    void var20_37;
                    void var19_29;
                    calCol = entryentity.addNew();
                    calCol.set("id", (Object)entryIds[colIndex]);
                    calCol.set("seq", (Object)colIndex);
                    calCol.set("coltype", (Object)DataRowEnum.CUSTOM.getIndex());
                    if ("1".equalsIgnoreCase(list_diff)) {
                        String string = String.format("%s - %s", targetDataCol.getString("colname"), baseDataCol.getString("colname"));
                        String string2 = String.format("%s - %s", "A" + targetDataCol.getString("id"), "A" + baseDataCol.getString("id"));
                    } else {
                        String string = String.format("%s - %s", baseDataCol.getString("colname"), targetDataCol.getString("colname"));
                        String string3 = String.format("%s - %s", "A" + baseDataCol.getString("id"), "A" + targetDataCol.getString("id"));
                    }
                    calCol.set("colname", (Object)var19_29);
                    calColConfigMap = new HashMap<String, Object>(2);
                    calColConfigMap.put("_EXPRESSION", var20_37);
                    calColConfigMap.put("_EXPRESSION_DISP", (String)calCol.get("colname"));
                    calCol.set("colconfigjson", (Object)SerializationUtils.toJsonString(calColConfigMap));
                    if (highlight_diff.booleanValue()) {
                        // empty if block
                    }
                    ++colIndex;
                }
                if (!showratio.booleanValue()) continue;
                if ("1".equalsIgnoreCase(list_ratio)) {
                    String string = String.format("(%s-%s)/%s", targetDataCol.getString("colname"), baseDataCol.getString("colname"), baseDataCol.getString("colname"));
                    String string4 = String.format("(%s-%s)/%s", "A" + targetDataCol.getString("id"), "A" + baseDataCol.getString("id"), "A" + baseDataCol.getString("id"));
                } else {
                    String string = String.format("(%s-%s)/%s", baseDataCol.getString("colname"), targetDataCol.getString("colname"), targetDataCol.getString("colname"));
                    String string5 = String.format("(%s-%s)/%s", "A" + baseDataCol.getString("id"), "A" + targetDataCol.getString("id"), "A" + targetDataCol.getString("id"));
                }
                calCol = entryentity.addNew();
                calCol.set("id", (Object)entryIds[colIndex]);
                calCol.set("seq", (Object)colIndex);
                calCol.set("coltype", (Object)DataRowEnum.CUSTOM.getIndex());
                calCol.set("colname", (Object)var19_32);
                calColConfigMap = new HashMap(2);
                calColConfigMap.put("_EXPRESSION", var20_40);
                calColConfigMap.put("_EXPRESSION_DISP", (String)calCol.get("colname"));
                calCol.set("colconfigjson", (Object)SerializationUtils.toJsonString(calColConfigMap));
                if (highlight_ratio.booleanValue()) {
                    // empty if block
                }
                ++colIndex;
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        DynamicObjectCollection dynamicObjects;
        super.beforeDeleteRow(e);
        if (e.getEntryProp() != null && ENTRYENTITY.equals(e.getEntryProp().getName()) && ((dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY)) == null || dynamicObjects.size() <= 1)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4fdd\u7559\u81f3\u5c11\u4e00\u4e2a\u6bd4\u8f83\u76ee\u6807\u3002", (String)"DiffVersionComparePlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("newentry".equals(operateKey)) {
            HashSet<String> visibleTargetF7 = new HashSet<String>(16);
            for (String dimNumber : this.getVisibleDims(this.getModel().getValue("dimselect"))) {
                visibleTargetF7.add(this.getF7KeyDimMap_target().get(dimNumber));
            }
            int size = this.getModel().getEntryEntity(ENTRYENTITY).size();
            CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
            for (int i = 0; i < size; ++i) {
                cardEntry.setChildVisible(false, i, TARGET_F7KEYS);
                cardEntry.setChildVisible(true, i, visibleTargetF7.toArray(new String[0]));
            }
        }
    }

    private void bulidComboItems() {
        List<Dimension> dimensions = this.getAllDimension();
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(16);
        Map<String, List<String>> compareDimMembers = this.getCompareDimMembers();
        StringBuilder dimselect = new StringBuilder();
        for (Dimension dimension : dimensions) {
            if (SysDimensionEnum.Account.getNumber().equals(dimension.getNumber())) continue;
            if (compareDimMembers != null && compareDimMembers.containsKey(dimension.getNumber())) {
                dimselect.append(dimension.getNumber()).append(',');
            }
            list.add(new ComboItem(new LocaleString(dimension.getName()), dimension.getNumber()));
        }
        ComboEdit baseValue = (ComboEdit)this.getControl("dimselect");
        baseValue.setComboItems(list);
        if (dimselect.length() > 0) {
            this.getModel().setValue("dimselect", (Object)dimselect.substring(0, dimselect.length() - 1));
        }
    }

    private Map<String, List<String>> getCompareDimMembers() {
        String str = (String)this.getView().getFormShowParameter().getCustomParam("compareDimMembers");
        if (str != null) {
            return (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        }
        return null;
    }

    private Map<String, String> getDimCtrlKeyMap() {
        if (this.dimCtrlKeyMap == null) {
            this.cacheF7KeyDimMap();
        }
        return this.dimCtrlKeyMap;
    }

    private Map<String, String> getF7KeyDimMap_base() {
        if (this.f7KeyDimMap_base == null) {
            this.cacheF7KeyDimMap();
        }
        return this.f7KeyDimMap_base;
    }

    private Map<String, String> getF7KeyDimMap_target() {
        if (this.f7KeyDimMap_target == null) {
            this.cacheF7KeyDimMap();
        }
        return this.f7KeyDimMap_target;
    }

    private Map<String, String> getDimNamesMap() {
        if (this.dimNamesMap == null) {
            this.cacheF7KeyDimMap();
        }
        return this.dimNamesMap;
    }

    private void cacheF7KeyDimMap() {
        String str_f7KeyDimMap_base = this.getCache("f7KeyDimMap_base");
        String str_f7KeyDimMap_target = this.getCache("f7KeyDimMap_target");
        String str_dimNamesMap = this.getCache("dimNamesMap");
        String str_dimCtrlKeyMap = this.getCache("dimCtrlKeyMap");
        if (str_f7KeyDimMap_base != null) {
            this.f7KeyDimMap_base = (Map)SerializationUtils.fromJsonString((String)str_f7KeyDimMap_base, Map.class);
            this.f7KeyDimMap_target = (Map)SerializationUtils.fromJsonString((String)str_f7KeyDimMap_target, Map.class);
            this.dimNamesMap = (Map)SerializationUtils.fromJsonString((String)str_dimNamesMap, Map.class);
            this.dimCtrlKeyMap = (Map)SerializationUtils.fromJsonString((String)str_dimCtrlKeyMap, Map.class);
        } else {
            this.f7KeyDimMap_base = new HashMap<String, String>(this.getAllDimension().size());
            this.f7KeyDimMap_target = new HashMap<String, String>(this.getAllDimension().size());
            this.dimNamesMap = new HashMap<String, String>(this.getAllDimension().size());
            this.dimCtrlKeyMap = new HashMap<String, String>(this.getAllDimension().size());
            int customIndex = 1;
            for (Dimension dimension : this.getAllDimension()) {
                String f7Key_target;
                String f7Key_base;
                String dimNumber = dimension.getNumber();
                this.dimNamesMap.put(dimNumber, dimension.getName());
                if (dimension.isPreset()) {
                    f7Key_base = F7_PREFIX_BASE + dimNumber.toLowerCase();
                    f7Key_target = F7_PREFIX_TARGET + dimNumber.toLowerCase();
                    this.f7KeyDimMap_base.put(dimNumber, f7Key_base);
                    this.f7KeyDimMap_base.put(f7Key_base, dimNumber);
                    this.f7KeyDimMap_target.put(dimNumber, f7Key_target);
                    this.f7KeyDimMap_target.put(f7Key_target, dimNumber);
                    this.dimCtrlKeyMap.put(dimNumber, dimNumber.toLowerCase());
                    this.dimCtrlKeyMap.put(dimNumber.toLowerCase(), dimNumber);
                    continue;
                }
                f7Key_base = "base_customize" + customIndex;
                f7Key_target = "target_customize" + customIndex;
                this.f7KeyDimMap_base.put(dimNumber, f7Key_base);
                this.f7KeyDimMap_base.put(f7Key_base, dimNumber);
                this.f7KeyDimMap_target.put(dimNumber, f7Key_target);
                this.f7KeyDimMap_target.put(f7Key_target, dimNumber);
                this.dimCtrlKeyMap.put(dimNumber, CUSTOMIZE + customIndex);
                this.dimCtrlKeyMap.put(CUSTOMIZE + customIndex, dimNumber);
                ++customIndex;
            }
            this.setCache("f7KeyDimMap_base", SerializationUtils.toJsonString(this.f7KeyDimMap_base));
            this.setCache("f7KeyDimMap_target", SerializationUtils.toJsonString(this.f7KeyDimMap_target));
            this.setCache("dimNamesMap", SerializationUtils.toJsonString(this.dimNamesMap));
            this.setCache("dimCtrlKeyMap", SerializationUtils.toJsonString(this.dimCtrlKeyMap));
        }
    }

    private void setCache(String cacheKey, String cacheValue) {
        this.getPageCache().put(cacheKey, cacheValue);
    }

    private String getCache(String cacheKey) {
        return this.getPageCache().get(cacheKey);
    }

    private List<Dimension> getAllDimension() {
        if (this.allDims == null) {
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
            this.allDims = modelCacheHelper.getDimensionList(this.getDatasetId());
        }
        return this.allDims;
    }

    private Long getDatasetId() {
        return IDUtils.toLong((Object)this.getPageCache().get("DATASETID"));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit basedataEdit = (BasedataEdit)e.getSource();
        String dimNumber = this.getCurrentDimNumber(basedataEdit.getKey());
        if (StringUtils.isNotEmpty((String)dimNumber)) {
            SingleTreeF7Parameter singleTreeF7Parameter = new SingleTreeF7Parameter();
            singleTreeF7Parameter.setCheckPerm(true);
            singleTreeF7Parameter.setOnlyLeaf(true);
            singleTreeF7Parameter.setKeepTree(true);
            this.switchSingleTreeF7(e, DatasetServiceHelper.getInstance().getBizModelIdByDataSetId(this.getDatasetId()), singleTreeF7Parameter);
        }
    }

    public String getCurrentDimNumber(String controlKey) {
        if (controlKey != null && controlKey.startsWith(F7_PREFIX_BASE)) {
            return this.getF7KeyDimMap_base().get(controlKey);
        }
        if (controlKey != null && controlKey.startsWith(F7_PREFIX_TARGET)) {
            return this.getF7KeyDimMap_target().get(controlKey);
        }
        return null;
    }
}

