/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analyze;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.threadlocal.EpmThreadLocalUtils;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.permission.IMemberPermCache;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebSpread.domain.view.SpreadSelector;
import kd.epm.eb.formplugin.analyze.DiffAnalyzeHelper;
import kd.epm.eb.formplugin.analyze.DiffAnalyzePluginConstant;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.spread.analyze.DiffAnalyzeScheme;
import kd.epm.eb.spread.control.SpreadContainer;
import kd.epm.eb.spread.template.spreadmanager.IDiffAnalyzeSpreadManager;

public interface IDiffAnalyzePlugin
extends IFormPlugin,
DiffAnalyzePluginConstant {
    public static final Log log = LogFactory.getLog(IDiffAnalyzePlugin.class);

    public IFormView getView();

    public IDiffAnalyzeSpreadManager getSpreadManager();

    public SpreadSelector getSpreadSelector();

    public void cacheSpreadManager();

    public SpreadContainer getspreadContainer();

    public IModelCacheHelper getModelCacheHelper();

    public IMemberPermCache getMemberPerm();

    public DiffAnalyzeScheme getSchemeConfig();

    public List<Dimension> getAllDimension();

    public Map<String, String> getF7KeyDimMap();

    public Map<String, String> getF7KeyDimMapMul();

    public Map<String, String> getF7KeyDimMapPage();

    public Long getF7Value(String var1, String var2, String var3, Integer var4);

    public void setMultiSelectMembers(String var1, List<Member> var2);

    public Long getModelId();

    public Long getSchemeId();

    public String getSpreadKey();

    public long getDatasetId();

    public long getBusModelId();

    public String getCurrentRowDimension();

    public String getCachedRowDimension();

    public Set<String> getSchemeDims();

    public Map<String, String> getDimCtrlKeyMap();

    public Map<String, Long> getDimensionViews();

    public Map<String, Long> getEntryDimensionViews();

    public Map<String, String> getColIndexNameMap();

    public DiffAnalyzeScheme refreshMetas(DiffAnalyzeScheme var1);

    public boolean isClickRowDimCell(SpreadSelector var1);

    public boolean isClickColDimCell(SpreadSelector var1);

    public boolean canRefreshCellData(DiffAnalyzeScheme var1);

    public void displayDimInfoOnStatusBar(SpreadSelector var1);

    default public void setCache(String cacheKey, String cacheValue) {
        this.getView().getPageCache().put(cacheKey, cacheValue);
    }

    default public String getCache(String cacheKey) {
        return this.getView().getPageCache().get(cacheKey);
    }

    default public void clearCache(String cacheKey) {
        this.getView().getPageCache().remove(cacheKey);
    }

    default public void setBigCache(String cacheKey, String cacheValue) {
        this.getView().getPageCache().putBigObject(cacheKey, cacheValue);
    }

    default public String getBigCache(String cacheKey) {
        return this.getView().getPageCache().getBigObject(cacheKey);
    }

    default public void clearBigCache(String cacheKey) {
        this.getView().getPageCache().removeBigObject(cacheKey);
    }

    default public Object getFormShowParameter(String key) {
        return this.getView().getFormShowParameter().getCustomParam(key);
    }

    default public Long getViewId(String dimNumber) {
        Long viewId = this.getDimensionViews().get(dimNumber);
        if (viewId == null) {
            viewId = 0L;
        }
        return viewId;
    }

    default public kd.epm.eb.common.cache.impl.Member getDefaultDimMember(Dimension dimension) {
        List members;
        if (dimension == null) {
            return null;
        }
        kd.epm.eb.common.cache.impl.Member member = null;
        member = SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber()) ? DiffAnalyzeHelper.getMember(this.getModelCacheHelper(), this.getMemberPerm(), dimension.getNumber(), this.getViewId(dimension.getNumber()), "Money") : (SysDimensionEnum.AuditTrail.getNumber().equals(dimension.getNumber()) ? DiffAnalyzeHelper.getMember(this.getModelCacheHelper(), this.getMemberPerm(), dimension.getNumber(), this.getViewId(dimension.getNumber()), "ATTotal") : (SysDimensionEnum.InternalCompany.getNumber().equals(dimension.getNumber()) ? DiffAnalyzeHelper.getMember(this.getModelCacheHelper(), this.getMemberPerm(), dimension.getNumber(), this.getViewId(dimension.getNumber()), "ICNone") : (SysDimensionEnum.DataType.getNumber().equals(dimension.getNumber()) ? DiffAnalyzeHelper.getMember(this.getModelCacheHelper(), this.getMemberPerm(), dimension.getNumber(), this.getViewId(dimension.getNumber()), "Budget") : (SysDimensionEnum.ChangeType.getNumber().equals(dimension.getNumber()) ? DiffAnalyzeHelper.getMember(this.getModelCacheHelper(), this.getMemberPerm(), dimension.getNumber(), this.getViewId(dimension.getNumber()), "CurrentPeriod") : (SysDimensionEnum.Currency.getNumber().equals(dimension.getNumber()) ? DiffAnalyzeHelper.getMember(this.getModelCacheHelper(), this.getMemberPerm(), dimension.getNumber(), this.getViewId(dimension.getNumber()), "CNY") : (!dimension.isPreset() ? DiffAnalyzeHelper.getMember(this.getModelCacheHelper(), this.getMemberPerm(), dimension.getNumber(), this.getViewId(dimension.getNumber()), dimension.getNumber()) : DiffAnalyzeHelper.getMember(this.getModelCacheHelper(), this.getMemberPerm(), dimension.getNumber(), this.getViewId(dimension.getNumber()), dimension.getNoneNumber())))))));
        if ((member == null || member != null && this.getMemberPerm().isNoperm(dimension.getNumber(), member.getNumber(), this.getViewId(dimension.getNumber()))) && (members = DiffAnalyzeHelper.getMembers(this.getDatasetId(), this.getModelCacheHelper(), this.getMemberPerm(), this.getViewId(dimension.getNumber()), dimension.getNumber()).stream().filter(m -> !m.getNumber().equals(dimension.getNumber())).collect(Collectors.toList())) != null && members.size() > 0) {
            Optional<kd.epm.eb.common.cache.impl.Member> first;
            member = SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber()) ? ((first = members.stream().filter(x -> x.getLevel() == 2).findFirst()).isPresent() ? first.get() : (kd.epm.eb.common.cache.impl.Member)members.get(0)) : (kd.epm.eb.common.cache.impl.Member)members.get(0);
        }
        return member;
    }

    default public void cacheF7Select(String ctrlKey, String entryRow, Object value) {
        if (StringUtils.isEmpty((String)ctrlKey)) {
            return;
        }
        String cacheValue = null;
        String cacheKey = null;
        cacheKey = !ctrlKey.contains("ebf7_page_") ? (entryRow != null ? "lastselect_" + entryRow + ctrlKey : "lastselect_" + ctrlKey) : ctrlKey;
        if (value instanceof Long || value instanceof String) {
            cacheValue = String.valueOf(value);
        } else if (value instanceof DynamicObject) {
            cacheValue = ((DynamicObject)value).getString("id");
        } else if (value instanceof ListSelectedRowCollection) {
            cacheValue = SerializationUtils.toJsonString((Object)value);
        }
        this.setCache(cacheKey, cacheValue);
    }

    default public boolean isF7Key(String controlKey) {
        return controlKey != null && controlKey.startsWith("ebf7_");
    }

    default public Map<String, String> getCacheF7Select() {
        return this.getView().getPageCache().getAll().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("lastselect_")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    default public void clearCacheF7Select(String ctrlKey) {
        if (StringUtils.isEmpty((String)ctrlKey)) {
            HashSet keys = new HashSet(16);
            IPageCache pageCache = this.getView().getPageCache();
            pageCache.getAll().keySet().forEach(key -> {
                if (key.startsWith("lastselect_")) {
                    keys.add(key);
                }
            });
            keys.forEach(key -> this.getView().getPageCache().remove(key));
        } else {
            this.setCache("lastselect_" + ctrlKey, null);
        }
    }

    default public boolean isCommonDimF7(String controlKey) {
        return controlKey != null && controlKey.startsWith("ebf7_") && controlKey.endsWith("_p");
    }

    default public boolean isSecondPageDimF7(String controlKey) {
        return controlKey != null && controlKey.startsWith("ebf7_") && controlKey.endsWith("_p1");
    }

    default public boolean isSchemeDimF7(String controlKey) {
        return controlKey != null && controlKey.startsWith("col_");
    }

    default public void pageCacheQuery(Object o) {
        try {
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            if (pageCache != null) {
                Map map = pageCache.getAll();
                StringBuilder sb = new StringBuilder();
                char char_eq = '=';
                char char_semicolon = ';';
                map.entrySet().forEach(entry -> sb.append((String)entry.getKey()).append(char_eq).append((String)entry.getValue()).append(char_semicolon));
                FormShowParameter formparam = new FormShowParameter();
                formparam.setFormId("eb_crossdiminfo");
                formparam.setParentPageId(this.getView().getPageId());
                formparam.getOpenStyle().setShowType(ShowType.Modal);
                formparam.setCaption("Message");
                formparam.setCustomParam("showMessage", (Object)sb.toString());
                this.getView().showForm(formparam);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    default public List<Member> getMembers(Map<String, String> configMap, String dimNumber, List<Member> members) {
        String key;
        if (dimNumber != null && configMap != null && configMap.containsKey(key = "ebf7_page_" + dimNumber.toLowerCase(Locale.ROOT))) {
            boolean exists;
            String value = configMap.get(key);
            Long viewId = IDUtils.toLong((Object)configMap.get(dimNumber + "viewId"));
            if (IDUtils.isNull((Long)viewId)) {
                viewId = this.getDimensionViews().get(dimNumber);
            }
            if (IDUtils.isNotNull((Long)viewId) && !(exists = QueryServiceHelper.exists((String)"eb_dimensionview", (Object)viewId))) {
                viewId = 0L;
            }
            Set permMembNumbers = EpmThreadLocalUtils.getPermMembNumbers((Long)UserUtils.getUserId(), (String)dimNumber, (Long)this.getModelId(), (Long)this.getBusModelId(), (Long)viewId, (DimMembPermType)DimMembPermType.READ, (boolean)true);
            if (StringUtils.isNotEmpty((String)value)) {
                members.clear();
                HashSet<String> hasAddNumber = new HashSet<String>(16);
                List valueList = (List)SerializationUtils.fromJsonString((String)value, List.class);
                for (Map memb : valueList) {
                    List memberList;
                    Dimension dimension = this.getModelCacheHelper().getDimension(dimNumber);
                    if (dimension == null || !CollectionUtils.isNotEmpty((Collection)(memberList = this.getModelCacheHelper().getMember(dimNumber, viewId, (String)memb.get("number"), Integer.parseInt((String)memb.get("scope")))))) continue;
                    if (permMembNumbers != null) {
                        memberList.removeIf(member -> !permMembNumbers.contains(member.getNumber()));
                    }
                    for (kd.epm.eb.common.cache.impl.Member member2 : memberList) {
                        Member m = Member.loadFormCache((kd.epm.eb.common.cache.impl.Member)member2);
                        if (!memb.containsKey("scope") || m == null) continue;
                        m.setRange(RangeEnum.ONLY.getIndex());
                        if (!hasAddNumber.add(m.getNumber())) continue;
                        members.add(m);
                    }
                }
            }
        }
        return members;
    }

    public boolean isEditSchemeMode();

    public void refreshCellData();

    default public String getUserRememberKey() {
        return UserUtils.getUserId() + "diffAnalyze" + this.getSchemeId();
    }

    default public String getKeyGroup() {
        ApplicationTypeEnum app = ModelUtil.queryApp((IFormView)this.getView());
        String formId = this.getView().getEntityId();
        String appIndex = app == null ? ModelUtil.getOtherAppNum((IFormView)this.getView()) : app.getIndex();
        return appIndex + '`' + formId + "`" + this.getModelId();
    }
}

