/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analyze;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.utils.EpmTreeUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractListPlugin;

public class analyzeSelectPlugin
extends AbstractListPlugin {
    public static final String BILLLISTAP = "billlistap";
    public static final String EB_COSTTYPE = "eb_costtype";
    public static final String KEY_MODEL_ID = "model";
    private static final String FOCUSNODEID = "focusnodeid";
    private static final String HEADNODEID = "headnodeid";
    private static final String CTRL_KEY_CATALOGTREE = "treeviewap";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.setBillFormId(EB_COSTTYPE);
        TreeView tview = (TreeView)this.getControl(CTRL_KEY_CATALOGTREE);
        tview.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                analyzeSelectPlugin.this.getPageCache().put(analyzeSelectPlugin.FOCUSNODEID, evt.getNodeId().toString());
                analyzeSelectPlugin.this.refreshBillList();
            }
        });
        this.addClickListeners(new String[]{"btnok", "btnclose"});
        billList.addSetFilterListener(new SetFilterListener(){

            public void setFilter(SetFilterEvent e) {
                QFilter qFilter1 = analyzeSelectPlugin.this.getqFilter();
                if (qFilter1 == null) {
                    qFilter1 = new QFilter(analyzeSelectPlugin.KEY_MODEL_ID, "=", (Object)IDUtils.toLong((Object)analyzeSelectPlugin.this.getPageCache().get(analyzeSelectPlugin.KEY_MODEL_ID)));
                }
                e.getCustomQFilters().add(new QFilter("typemodifyer", "=", (Object)UserUtils.getUserId()).or(new QFilter("typemodifyer", "=", (Object)0L).and(new QFilter("schemetype", "=", (Object)"2").or(new QFilter("schemetype", "=", (Object)"1").and(new QFilter("creater", "=", (Object)UserUtils.getUserId()))))));
                e.getQFilters().add(new QFilter("id", "not in", (Object)IDUtils.toLongs((List)analyzeSelectPlugin.this.getSourceIds(IDUtils.toLong((Object)analyzeSelectPlugin.this.getPageCache().get(analyzeSelectPlugin.KEY_MODEL_ID))))));
                e.getQFilters().add(qFilter1);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam(KEY_MODEL_ID);
        if (modelId == null || modelId == 0L) {
            BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
            billList.setFilter(new QFilter("1", "!=", (Object)1));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4efb\u4f55\u4f53\u7cfb\uff0c\u8bf7\u5148\u65b0\u589e\u4f53\u7cfb\u3002", (String)"analyzeSelectPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(KEY_MODEL_ID, String.valueOf(modelId));
        this.refreshTree();
        this.refreshBillList();
    }

    protected void refreshBillList() {
        QFilter qFilter1 = this.getqFilter();
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.setFilter(qFilter1);
        billList.setClearSelection(true);
        billList.refresh();
    }

    protected QFilter getqFilter() {
        String nodeid;
        QFilter modelqf = new QFilter(KEY_MODEL_ID, "=", (Object)IDUtils.toLong((Object)this.getPageCache().get(KEY_MODEL_ID)));
        if (this.getPageCache().get(FOCUSNODEID) != null && !"0".equals(nodeid = this.getPageCache().get(FOCUSNODEID))) {
            QFilter qFilter1 = new QFilter("schemetype", "=", (Object)nodeid);
            return modelqf.and(qFilter1);
        }
        return modelqf;
    }

    private void refreshTree() {
        TreeView Tree = (TreeView)this.getControl(CTRL_KEY_CATALOGTREE);
        Tree.deleteAllNodes();
        this.initTree();
    }

    private void initTree() {
        TreeNode catalog = new TreeNode();
        ArrayList treeList = new ArrayList(16);
        String headid = "";
        long[] ids = new long[]{0L, 1L, 2L};
        headid = ids[0] + "";
        catalog.setId(headid);
        catalog.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"analyzeSelectPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        catalog.addChild(new TreeNode(headid, "1", ResManager.loadKDString((String)"\u79c1\u6709", (String)"analyzeSelectPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        catalog.addChild(new TreeNode(headid, "2", ResManager.loadKDString((String)"\u5171\u4eab", (String)"analyzeSelectPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0])));
        this.getPageCache().put(FOCUSNODEID, headid);
        this.getPageCache().put(HEADNODEID, headid);
        this.getPageCache().put("treelist", SerializationUtils.toJsonString(treeList));
        EpmTreeUtils.setEntryNode((TreeNode)catalog, treeList, (String)headid);
        EpmTreeUtils.spreadAllNode((TreeNode)catalog);
        TreeView tree = (TreeView)this.getControl(CTRL_KEY_CATALOGTREE);
        tree.addNode(catalog);
        tree.focusNode(catalog);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("btnok".equals(key)) {
            this.exitAndReturnData();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        String key = Control2.getKey();
        if ("btnok".equals(key)) {
            this.exitAndReturnData();
        }
    }

    private void exitAndReturnData() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        ListSelectedRow selectedRow = billList.getCurrentSelectedRowInfo();
        if (selectedRow == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u884c", (String)"analyzeSelectPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long primaryKeyValue = (Long)selectedRow.getPrimaryKeyValue();
        DynamicObject doc = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)EB_COSTTYPE);
        this.getView().returnDataToParent((Object)doc);
        this.getView().close();
    }

    private List<String> getSourceIds(Long modelId) {
        String entityName = EB_COSTTYPE;
        String selects = "id,schemetype,sourceid,typemodifyer";
        QFilter qFilter = new QFilter(KEY_MODEL_ID, "=", (Object)modelId);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entityName, (String)selects, (QFilter[])new QFilter[]{qFilter});
        ArrayList<String> ids = new ArrayList<String>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (dynamicObject.get("sourceid") == null || dynamicObject.getLong("sourceid") == 0L || dynamicObject.get("typemodifyer") == null || !UserUtils.getUserId().equals(dynamicObject.getLong("typemodifyer"))) continue;
            ids.add(dynamicObject.get("sourceid").toString());
        }
        return ids;
    }
}

