/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analyze.command;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import kd.epm.eb.common.enums.GroupNodeTypeEnum;
import kd.epm.eb.formplugin.analyze.DiffAnalyzeHelper;
import kd.epm.eb.formplugin.analyze.IDiffAnalyzePlugin;
import kd.epm.eb.formplugin.analyze.command.DiffAnalyzeCommand;
import kd.epm.eb.spread.analyze.DiffAnalyzeScheme;
import kd.epm.eb.spread.command.style.CellGroupNodeInfo;
import kd.epm.eb.spread.control.SpreadContainer;
import kd.epm.eb.spread.template.spreadmanager.DiffCellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IDiffAnalyzeSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.StyleCell;

public class CollapseColChildCommand
extends DiffAnalyzeCommand {
    private int index;
    private IDiffAnalyzeSpreadManager spreadManager = null;
    private SpreadContainer spreadContainer = null;
    private DiffAnalyzeScheme diffAnalyzeScheme;

    public CollapseColChildCommand(int index, IDiffAnalyzeSpreadManager spreadManager, SpreadContainer spreadContainer, DiffAnalyzeScheme diffAnalyzeScheme) {
        this.index = index;
        this.spreadManager = spreadManager;
        this.spreadContainer = spreadContainer;
        this.diffAnalyzeScheme = diffAnalyzeScheme;
    }

    @Override
    protected void beforeExecute(IDiffAnalyzePlugin formPlugin) {
        super.beforeExecute(formPlugin);
        if (this.spreadContainer == null) {
            this.spreadContainer = new SpreadContainer(this.formView, formPlugin.getSpreadKey());
        }
        if (this.diffAnalyzeScheme != null && this.spreadManager != null) {
            this.spreadManager.setDiffAnalyzeScheme(this.diffAnalyzeScheme);
        }
    }

    @Override
    protected void doExecute(IDiffAnalyzePlugin formPlugin) {
        List cellDimMembers = this.spreadManager.getColCellDimMembers();
        List schemeColumns = this.spreadManager.getDiffAnalyzeScheme().getAnalyzeColumns();
        int schemeColSize = schemeColumns.size();
        ISheet sheet = this.spreadManager.getEbook().getSheet(0);
        if (this.index > 0 && cellDimMembers != null && cellDimMembers.size() > this.index) {
            StyleCell parentStyleCell = DiffAnalyzeHelper.getStyleCellNotAdd(sheet, 0, this.index);
            DiffCellDimMember parentCellDimMember = (DiffCellDimMember)cellDimMembers.get(this.index);
            if (parentStyleCell == null || parentCellDimMember == null) {
                return;
            }
            int parentIndent = parentStyleCell.getTextIndent();
            int size = cellDimMembers.size();
            LinkedList<Integer> indexes = new LinkedList<Integer>();
            for (int i = this.index + schemeColSize; i < size && i < sheet.getRealMaxCols(); i += schemeColSize) {
                DiffCellDimMember cellDimMember = (DiffCellDimMember)cellDimMembers.get(i);
                StyleCell styleCell = DiffAnalyzeHelper.getStyleCellNotAdd(sheet, 0, i);
                if (cellDimMember == null || styleCell == null || styleCell.getTextIndent() <= parentIndent) break;
                for (int j = 0; j < schemeColSize; ++j) {
                    indexes.add(i + j);
                }
            }
            if (indexes.size() > 0) {
                Collections.reverse(indexes);
                for (Integer i : indexes) {
                    cellDimMembers.remove(i);
                    sheet.delColumn(i.intValue());
                }
                this.getSpreadContainer().deleteRowCol(null, indexes);
            }
            this.getSpreadContainer().setGroupColNode(Collections.singletonList(CellGroupNodeInfo.ofSmallRadix((int)0, (int)this.index, (int)(parentCellDimMember.isIsleaf() ? GroupNodeTypeEnum.NONE.getIndex() : GroupNodeTypeEnum.EXPEND.getIndex()), (int)0, (boolean)true)));
        }
    }

    public SpreadContainer getSpreadContainer() {
        return this.spreadContainer;
    }

    public CollapseColChildCommand setSpreadContainer(SpreadContainer spreadContainer) {
        this.spreadContainer = spreadContainer;
        return this;
    }
}

