/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analyze.command;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import kd.epm.eb.common.enums.GroupNodeTypeEnum;
import kd.epm.eb.formplugin.analyze.DiffAnalyzeHelper;
import kd.epm.eb.formplugin.analyze.IDiffAnalyzePlugin;
import kd.epm.eb.formplugin.analyze.command.DiffAnalyzeCommand;
import kd.epm.eb.formplugin.analyze.command.RefreshCellDataCommand;
import kd.epm.eb.spread.command.style.CellGroupNodeInfo;
import kd.epm.eb.spread.control.SpreadContainer;
import kd.epm.eb.spread.template.spreadmanager.DiffCellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IDiffAnalyzeSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.StyleCell;

public class CollapseRowChildCommand
extends DiffAnalyzeCommand {
    private int row;
    private IDiffAnalyzeSpreadManager spreadManager = null;
    private SpreadContainer spreadContainer = null;

    public CollapseRowChildCommand(int row, IDiffAnalyzeSpreadManager spreadManager, SpreadContainer spreadContainer) {
        this.row = row;
        this.spreadManager = spreadManager;
        this.spreadContainer = spreadContainer;
    }

    @Override
    protected void beforeExecute(IDiffAnalyzePlugin formPlugin) {
        super.beforeExecute(formPlugin);
        if (this.spreadContainer == null) {
            this.spreadContainer = new SpreadContainer(this.formView, formPlugin.getSpreadKey());
        }
    }

    @Override
    protected void doExecute(IDiffAnalyzePlugin formPlugin) {
        List rowCellDimMembers = this.spreadManager.getRowCellDimMembers();
        ISheet sheet = this.spreadManager.getEbook().getSheet(0);
        if (this.row > 0 && rowCellDimMembers != null && rowCellDimMembers.size() > this.row) {
            StyleCell parentStyleCell = DiffAnalyzeHelper.getStyleCellNotAdd(sheet, this.row, 0);
            DiffCellDimMember parentCellDimMember = (DiffCellDimMember)rowCellDimMembers.get(this.row);
            if (parentStyleCell == null || parentCellDimMember == null) {
                return;
            }
            int parentIndent = parentStyleCell.getTextIndent();
            int size = rowCellDimMembers.size();
            LinkedList<Integer> rowIndexes = new LinkedList<Integer>();
            for (int i = this.row + 1; i < size; ++i) {
                DiffCellDimMember cellDimMember = (DiffCellDimMember)rowCellDimMembers.get(i);
                StyleCell styleCell = DiffAnalyzeHelper.getStyleCellNotAdd(sheet, i, 0);
                if (cellDimMember == null || styleCell == null || styleCell.getTextIndent() <= parentIndent) break;
                rowIndexes.add(i);
            }
            if (rowIndexes.size() > 0) {
                Collections.reverse(rowIndexes);
                for (Integer r : rowIndexes) {
                    rowCellDimMembers.remove(r);
                    sheet.delRow(r.intValue());
                }
                this.getSpreadContainer().deleteRowCol(rowIndexes, null);
                new RefreshCellDataCommand(formPlugin).renewRefreshedRows(this.row, this.row + rowIndexes.size(), false);
            }
            this.getSpreadContainer().setGroupColNode(Collections.singletonList(new CellGroupNodeInfo(this.row, 0, parentCellDimMember.isIsleaf() ? GroupNodeTypeEnum.NONE.getIndex() : GroupNodeTypeEnum.EXPEND.getIndex(), parentCellDimMember.getDrill(), parentCellDimMember.getTi())));
        }
    }

    public SpreadContainer getSpreadContainer() {
        return this.spreadContainer;
    }

    public CollapseRowChildCommand setSpreadContainer(SpreadContainer spreadContainer) {
        this.spreadContainer = spreadContainer;
        return this;
    }
}

