/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analyze.command;

import java.util.Map;
import kd.bos.form.IFormView;
import kd.bos.util.StringUtils;
import kd.epm.eb.formplugin.analyze.IDiffAnalyzePlugin;
import kd.epm.eb.formplugin.analyze.command.DiffAnalyzeCommand;
import kd.epm.eb.formplugin.analyze.command.RefreshCellDataCommand;
import kd.epm.eb.spread.adaptor.OlapQuerySync;
import kd.epm.eb.spread.analyze.DiffAnalyzeScheme;
import kd.epm.eb.spread.template.spreadmanager.IDiffAnalyzeSpreadManager;
import kd.epm.eb.spread.utils.ReportHelper;

public class DataUnitChangeCommand
extends DiffAnalyzeCommand {
    private String key;

    public DataUnitChangeCommand(String key) {
        this.key = key;
    }

    @Override
    public void doExecute(IDiffAnalyzePlugin formPlugin) {
        String changeunit;
        String dataunit = formPlugin.getSpreadManager().getDataUnit();
        if (StringUtils.isEmpty((String)dataunit)) {
            dataunit = "0";
        }
        if (dataunit.equals(changeunit = this.key.substring(this.key.length() - 1))) {
            return;
        }
        this.formView.getPageCache().put("dataunit", changeunit);
        ReportHelper.refreshBtnUnitStyle((int)Integer.parseInt(changeunit), (IFormView)this.formView, (String)"btn_dataunit");
        this.refreshDataWhenUnitChange(dataunit, changeunit);
    }

    private void refreshDataWhenUnitChange(String oldunit, String newunit) {
        IDiffAnalyzeSpreadManager spreadManager = this.formPlugin.getSpreadManager();
        Map<String, Long> dimensionViews = this.formPlugin.getDimensionViews();
        spreadManager.getDimemsionViews().putAll(dimensionViews);
        spreadManager.setDataUnit(newunit);
        RefreshCellDataCommand cmd = new RefreshCellDataCommand(this.formPlugin);
        cmd.removeRefreshRows();
        DiffAnalyzeScheme scheme = this.formPlugin.refreshMetas(this.formPlugin.getSchemeConfig());
        if (this.formPlugin.canRefreshCellData(scheme)) {
            OlapQuerySync.ViewArea viewArea = cmd.getLastViewArea();
            if (spreadManager.isHideEmptyRows()) {
                viewArea = new OlapQuerySync.ViewArea(spreadManager.getValueRowStart(), spreadManager.getValueRowEnd(), 0, 50);
            }
            if (viewArea != null) {
                new RefreshCellDataCommand(viewArea.getStartrow(), viewArea.getEndrow(), scheme, spreadManager).execute(this.formPlugin);
            } else {
                new RefreshCellDataCommand(0, 1000, scheme, spreadManager).execute(this.formPlugin);
            }
        }
    }
}

