/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analyze.command;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.utils.MetricUtils;
import kd.epm.eb.formplugin.analyze.DiffAnalyzeHelper;
import kd.epm.eb.formplugin.analyze.DiffAnalyzePluginConstant;
import kd.epm.eb.formplugin.analyze.IDiffAnalyzePlugin;

public abstract class DiffAnalyzeCommand
implements DiffAnalyzePluginConstant {
    protected IDiffAnalyzePlugin formPlugin = null;
    protected IFormView formView = null;
    protected IPageCache pageCache = null;
    protected boolean cacheSMAfterExecute = true;
    protected Log log = LogFactory.getLog(this.getClass());

    protected void beforeExecute(IDiffAnalyzePlugin formPlugin) {
        this.formPlugin = formPlugin;
        this.formView = formPlugin.getView();
        this.pageCache = (IPageCache)this.formView.getService(IPageCache.class);
    }

    protected abstract void doExecute(IDiffAnalyzePlugin var1);

    protected void afterExecute(IDiffAnalyzePlugin formPlugin) {
        if (this.isCacheSMAfterExecute()) {
            formPlugin.cacheSpreadManager();
        }
    }

    public final void execute(IDiffAnalyzePlugin formPlugin) {
        this.beforeExecute(formPlugin);
        try {
            this.doExecute(formPlugin);
        }
        catch (Exception e) {
            this.log.error("DiffAnalyzeCommand:execute " + ThrowableHelper.toString((Exception)e));
            if (e instanceof KDBizException) {
                throw e;
            }
            this.log.error("DiffAnalyzeCommand:execute " + ThrowableHelper.toString((Exception)e));
            throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DiffAnalyzePlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        this.afterExecute(formPlugin);
    }

    public boolean isCacheSMAfterExecute() {
        return this.cacheSMAfterExecute;
    }

    public DiffAnalyzeCommand setCacheSMAfterExecute(boolean cacheSMAfterExecute) {
        this.cacheSMAfterExecute = cacheSMAfterExecute;
        return this;
    }

    public Map<String, Object> getDiffDisplaySettings(boolean isEditSchemeMode) {
        Map displaySettings = null;
        if (isEditSchemeMode) {
            displaySettings = this.getDiffDisplaySettings();
        } else {
            String str = this.pageCache.get("diffDisplaySettings");
            if (StringUtils.isNotEmpty((String)str)) {
                displaySettings = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
            } else {
                displaySettings = this.getDiffDisplaySettings();
                this.pageCache.put("diffDisplaySettings", SerializationUtils.toJsonString((Object)displaySettings));
            }
        }
        return displaySettings;
    }

    public Map<String, Object> getDiffDisplaySettings() {
        String defUnitDisplay;
        String defEmptyrowDisplay;
        Set set;
        Object map;
        HashMap displaySettings = Maps.newHashMapWithExpectedSize((int)4);
        HashMap<String, Integer> metricDisplays = new HashMap<String, Integer>(16);
        HashSet metricDisplays_no_sep = new HashSet(16);
        HashSet hideDimensions = new HashSet(16);
        HashMap<String, Object> configMap = new HashMap(16);
        DynamicObject schemeObject = (DynamicObject)this.formView.getModel().getValue("analyzescheme");
        if (schemeObject != null && StringUtils.isNotEmpty((String)schemeObject.getString("configjson"))) {
            configMap = (Map)SerializationUtils.fromJsonString((String)schemeObject.getString("configjson"), Map.class);
        }
        DynamicObjectCollection metrics = MetricUtils.getMetricsByDataType((Long)this.formPlugin.getModelId(), (Set)Sets.newHashSet((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex()}));
        String cachedValue = this.formView.getPageCache().get("metricdisplay");
        if (StringUtils.isNotEmpty((String)cachedValue)) {
            map = (Map)SerializationUtils.fromJsonString((String)cachedValue, Map.class);
            metricDisplays.putAll((Map<String, Integer>)map);
        } else {
            map = DiffAnalyzeHelper.getConfigMapByKey(configMap, "metricdisplay");
            if (map != null) {
                metricDisplays.putAll((Map<String, Integer>)map);
            }
        }
        for (DynamicObject dynamicObject : metrics) {
            metricDisplays.putIfAbsent(dynamicObject.getString("number"), dynamicObject.getInt("decimalnum"));
        }
        cachedValue = this.formView.getPageCache().get("metricdisplay_no_sep");
        if (StringUtils.isNotEmpty((String)cachedValue)) {
            set = (Set)SerializationUtils.fromJsonString((String)cachedValue, Set.class);
            metricDisplays_no_sep.addAll(set);
        } else {
            set = DiffAnalyzeHelper.getSetValueByConfigKey(configMap, "metricdisplay_no_sep");
            if (set != null) {
                metricDisplays_no_sep.addAll(set);
            }
        }
        cachedValue = this.formView.getPageCache().get("hide_dimensions");
        if (StringUtils.isNotEmpty((String)cachedValue)) {
            set = (Set)SerializationUtils.fromJsonString((String)cachedValue, Set.class);
            hideDimensions.addAll(set);
        } else {
            set = DiffAnalyzeHelper.getSetValueByConfigKey(configMap, "hide_dimensions");
            if (set != null) {
                hideDimensions.addAll(set);
            }
        }
        String defMemberDisplay = this.formView.getPageCache().get("defmemberdisplay");
        if (defMemberDisplay == null) {
            defMemberDisplay = (String)configMap.get("defmemberdisplay");
        }
        if ((defEmptyrowDisplay = this.formView.getPageCache().get("defemptyrowdisplay")) == null) {
            defEmptyrowDisplay = (String)configMap.get("defemptyrowdisplay");
        }
        if ((defUnitDisplay = this.formView.getPageCache().get("defunitdisplay")) == null) {
            defUnitDisplay = (String)configMap.get("defunitdisplay");
        }
        displaySettings.put("defmemberdisplay", defMemberDisplay);
        displaySettings.put("defemptyrowdisplay", defEmptyrowDisplay);
        displaySettings.put("defunitdisplay", defUnitDisplay);
        displaySettings.put("metricdisplay", metricDisplays);
        displaySettings.put("metricdisplay_no_sep", metricDisplays_no_sep);
        displaySettings.put("hide_dimensions", hideDimensions);
        return displaySettings;
    }
}

