/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analyze.command;

import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.permission.IMemberPermCache;
import kd.epm.eb.common.permission.MemberPermCacheServiceHelper;
import kd.epm.eb.common.spread.util.GZIPUtils;
import kd.epm.eb.formplugin.analyze.DiffAnalyzeHelper;
import kd.epm.eb.formplugin.analyze.IDiffAnalyzePlugin;
import kd.epm.eb.formplugin.analyze.command.DiffAnalyzeCommand;
import kd.epm.eb.formplugin.analyze.command.RefreshCellDataCommand;
import kd.epm.eb.spread.command.rangedefined.SheetFrozenInfo;
import kd.epm.eb.spread.control.SpreadContainer;
import kd.epm.eb.spread.template.spreadmanager.DiffCellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IDiffAnalyzeSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;

public class DrillColDimCommand
extends DiffAnalyzeCommand {
    private String dimNumber;
    private String memNumber;
    private int col;
    private int range;
    private IDiffAnalyzeSpreadManager spreadManager = null;
    private IModelCacheHelper modelCacheHelper = null;
    private IMemberPermCache memberPerm = null;
    private SpreadContainer spreadContainer = null;
    private boolean isDrillDown = true;

    public DrillColDimCommand(String dimNumber, String memNumber, int col, int range, IDiffAnalyzeSpreadManager spreadManager) {
        this.dimNumber = dimNumber;
        this.memNumber = memNumber;
        this.col = col;
        this.range = range;
        this.spreadManager = spreadManager;
    }

    @Override
    protected void beforeExecute(IDiffAnalyzePlugin formPlugin) {
        super.beforeExecute(formPlugin);
        if (this.modelCacheHelper == null && this.spreadManager != null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.spreadManager.getModelid());
        }
        if (this.memberPerm == null && this.modelCacheHelper != null && this.spreadManager != null) {
            this.memberPerm = MemberPermCacheServiceHelper.build(null, (Long)this.spreadManager.getModelid(), (Long)this.modelCacheHelper.getBusModelByDataSet(this.spreadManager.getDatasetid()), null);
        }
        if (this.spreadContainer == null) {
            this.spreadContainer = new SpreadContainer(this.formView, formPlugin.getSpreadKey());
        }
        if (this.spreadManager != null) {
            this.spreadManager.setModelCacheHelper(this.modelCacheHelper);
            this.spreadManager.setMemberPerm(this.memberPerm);
        }
    }

    @Override
    protected void doExecute(IDiffAnalyzePlugin formPlugin) {
        DiffCellDimMember member;
        List colCellDimMembers = this.spreadManager.getColCellDimMembers();
        if (this.dimNumber != null && this.memNumber != null && colCellDimMembers != null && colCellDimMembers.size() > this.col && this.spreadManager != null && (member = (DiffCellDimMember)colCellDimMembers.get(this.col)) != null) {
            boolean isDrillUp = this.range < 0;
            List<kd.epm.eb.common.cache.impl.Member> cacheMembers = null;
            if (isDrillUp) {
                kd.epm.eb.common.cache.impl.Member cacheMember = this.modelCacheHelper.getMember(this.dimNumber, (Long)this.spreadManager.getDimemsionViews().get(this.dimNumber), this.memNumber);
                if (cacheMember != null && cacheMember.getParentNumber() != null && !cacheMember.getParentNumber().equals(this.dimNumber)) {
                    cacheMembers = DiffAnalyzeHelper.getMember(formPlugin.getDatasetId(), this.modelCacheHelper, this.memberPerm, this.dimNumber, (Long)this.spreadManager.getDimemsionViews().get(this.dimNumber), cacheMember.getParentNumber(), RangeEnum.ONLY.getIndex());
                }
            } else {
                cacheMembers = DiffAnalyzeHelper.getMember(formPlugin.getDatasetId(), this.modelCacheHelper, this.memberPerm, this.dimNumber, (Long)this.spreadManager.getDimemsionViews().get(this.dimNumber), this.memNumber, this.range);
            }
            if (cacheMembers != null && cacheMembers.size() > 0) {
                ISheet sheet = this.spreadManager.getEbook().getSheet(0);
                Dimension colDimension = this.spreadManager.getColDimension();
                List rowCellDimMembers = this.spreadManager.getRowCellDimMembers();
                int maxCol = sheet.getRealMaxCols();
                ArrayList<Integer> indexes = new ArrayList<Integer>(maxCol - 1);
                for (int i = maxCol - 1; i > 0; --i) {
                    sheet.delColumn(i);
                    indexes.add(i);
                }
                sheet.resetRealMaxCols();
                this.spreadContainer.deleteRowCol(null, indexes);
                colDimension.clearMember();
                for (kd.epm.eb.common.cache.impl.Member m : cacheMembers) {
                    colDimension.add(Member.loadFormCache((kd.epm.eb.common.cache.impl.Member)m));
                }
                this.spreadManager.setDiffAnalyzeScheme(formPlugin.refreshMetas(formPlugin.getSchemeConfig()));
                List updateUICells = this.spreadManager.buildReportColPartition();
                new RefreshCellDataCommand(formPlugin).removeRefreshRows();
                try {
                    String spreadjson = this.spreadManager.getEbook().toJsonWithRealRowCol();
                    byte[] bb = Base64.getEncoder().encode(GZIPUtils.compress((String)spreadjson));
                    this.spreadContainer.rebuildSpread("base64" + new String(bb));
                    this.spreadContainer.frozenSheet(new SheetFrozenInfo(Integer.valueOf(this.spreadManager.getColDimension() == null ? 1 : 2), null, Integer.valueOf(1), null));
                    this.spreadContainer.lockSheets(Collections.singletonList(this.spreadManager.getEbook().getSheet(0).getSheetName()));
                    this.spreadContainer.setColumnsWidth(Collections.singletonList(0), 200);
                    this.spreadContainer.closeToolbar();
                    DiffAnalyzeHelper.refreshGroupNodeType(this.spreadContainer, this.spreadManager);
                }
                catch (Exception e) {
                    this.log.error((Throwable)e);
                    if (e instanceof KDBizException) {
                        throw new KDBizException(ThrowableHelper.getMessage((Exception)e));
                    }
                    throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DiffAnalyzePlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            } else {
                this.formView.showTipNotification(ResManager.loadKDString((String)"\u5c55\u5f00\u6216\u94bb\u53d6\u7684\u6210\u5458\u6ca1\u6709\u6570\u636e\u6743\u9650\u3002", (String)"DiffAnalyzePlugin_53", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public boolean isDrillDown() {
        return this.isDrillDown;
    }

    public void setDrillDown(boolean drillDown) {
        this.isDrillDown = drillDown;
    }

    public IModelCacheHelper getModelCacheHelper() {
        return this.modelCacheHelper;
    }

    public DrillColDimCommand setModelCacheHelper(IModelCacheHelper modelCacheHelper) {
        this.modelCacheHelper = modelCacheHelper;
        return this;
    }

    public IMemberPermCache getMemberPerm() {
        return this.memberPerm;
    }

    public DrillColDimCommand setMemberPerm(IMemberPermCache memberPerm) {
        this.memberPerm = memberPerm;
        return this;
    }

    public SpreadContainer getSpreadContainer() {
        return this.spreadContainer;
    }

    public DrillColDimCommand setSpreadContainer(SpreadContainer spreadContainer) {
        this.spreadContainer = spreadContainer;
        return this;
    }
}

