/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analyze.command;

import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.DrillTypeEnum;
import kd.epm.eb.common.enums.GroupNodeTypeEnum;
import kd.epm.eb.common.permission.IMemberPermCache;
import kd.epm.eb.common.permission.MemberPermCacheServiceHelper;
import kd.epm.eb.formplugin.analyze.DiffAnalyzeHelper;
import kd.epm.eb.formplugin.analyze.IDiffAnalyzePlugin;
import kd.epm.eb.formplugin.analyze.command.DiffAnalyzeCommand;
import kd.epm.eb.formplugin.analyze.command.RefreshCellDataCommand;
import kd.epm.eb.spread.analyze.DiffAnalyzeScheme;
import kd.epm.eb.spread.command.style.CellGroupNodeInfo;
import kd.epm.eb.spread.control.SpreadContainer;
import kd.epm.eb.spread.template.spreadmanager.DiffCellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IDiffAnalyzeSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;

public class DrillRowDimCommand
extends DiffAnalyzeCommand {
    private int row;
    private String dimNumber;
    private String memNumber;
    private int range;
    private IDiffAnalyzeSpreadManager spreadManager = null;
    private IModelCacheHelper modelCacheHelper = null;
    private IMemberPermCache memberPerm = null;
    private SpreadContainer spreadContainer = null;
    private DiffAnalyzeScheme diffAnalyzeScheme;

    public DrillRowDimCommand(int row, String dimNumber, String memNumber, int range, IDiffAnalyzeSpreadManager spreadManager, DiffAnalyzeScheme diffAnalyzeScheme) {
        this.row = row;
        this.dimNumber = dimNumber;
        this.memNumber = memNumber;
        this.range = range;
        this.spreadManager = spreadManager;
        this.diffAnalyzeScheme = diffAnalyzeScheme;
    }

    @Override
    protected void beforeExecute(IDiffAnalyzePlugin formPlugin) {
        super.beforeExecute(formPlugin);
        if (this.modelCacheHelper == null && this.spreadManager != null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.spreadManager.getModelid());
        }
        if (this.memberPerm == null && this.modelCacheHelper != null && this.spreadManager != null) {
            this.memberPerm = MemberPermCacheServiceHelper.build(null, (Long)this.spreadManager.getModelid(), (Long)this.modelCacheHelper.getBusModelByDataSet(this.spreadManager.getDatasetid()), null);
        }
        if (this.spreadContainer == null) {
            this.spreadContainer = new SpreadContainer(this.formView, formPlugin.getSpreadKey());
        }
        if (this.spreadManager != null) {
            this.spreadManager.setModelCacheHelper(this.modelCacheHelper);
            this.spreadManager.setMemberPerm(this.memberPerm);
        }
    }

    @Override
    protected void doExecute(IDiffAnalyzePlugin formPlugin) {
        List<Member> cacheMembers;
        List<ECell> updateUICells;
        if (this.dimNumber == null || this.memNumber == null) {
            return;
        }
        DiffCellDimMember parentCellDimMember = (DiffCellDimMember)this.spreadManager.getRowCellDimMembers().get(this.row);
        if (parentCellDimMember != null) {
            boolean isDrill = !parentCellDimMember.getDimNumber().equals(this.dimNumber);
            this.getSpreadContainer().setGroupColNode(Collections.singletonList(new CellGroupNodeInfo(this.row, 0, GroupNodeTypeEnum.COLLAPSE.getIndex(), isDrill ? DrillTypeEnum.DEFAULT.getIndex() : DrillTypeEnum.NONE.getIndex(), parentCellDimMember.getTi())));
        }
        if ((updateUICells = DiffAnalyzeHelper.insertMemberRows(this.spreadManager, this.spreadContainer, this.row, cacheMembers = DiffAnalyzeHelper.getMember(formPlugin.getDatasetId(), this.getModelCacheHelper(), this.getMemberPerm(), this.dimNumber, (Long)this.spreadManager.getDimemsionViews().get(this.dimNumber), this.memNumber, this.range), this.modelCacheHelper)) != null && updateUICells.size() > 0) {
            this.spreadContainer.insertRowsBelow(this.row, updateUICells.size(), true);
            this.spreadContainer.updateCellValue2(updateUICells);
            DiffAnalyzeHelper.refreshGroupNodeType(this.spreadContainer, this.spreadManager.getRowCellDimMembers(), this.row + 1, updateUICells.size(), this.spreadManager.getEbook().getSheet(0), true);
            new RefreshCellDataCommand(formPlugin).renewRefreshedRows(this.row, this.row + updateUICells.size(), true);
            new RefreshCellDataCommand(this.row + 1, this.row + 1 + updateUICells.size(), this.diffAnalyzeScheme, this.spreadManager, false).execute(formPlugin);
            this.spreadContainer.lockSheets(Collections.singletonList(this.spreadManager.getEbook().getSheet(0).getSheetName()));
        } else {
            this.formView.showTipNotification(ResManager.loadKDString((String)"\u5c55\u5f00\u6216\u94bb\u53d6\u7684\u6210\u5458\u6ca1\u6709\u6570\u636e\u6743\u9650\u3002", (String)"DiffAnalyzePlugin_53", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public IModelCacheHelper getModelCacheHelper() {
        return this.modelCacheHelper;
    }

    public DrillRowDimCommand setModelCacheHelper(IModelCacheHelper modelCacheHelper) {
        this.modelCacheHelper = modelCacheHelper;
        return this;
    }

    public IMemberPermCache getMemberPerm() {
        return this.memberPerm;
    }

    public DrillRowDimCommand setMemberPerm(IMemberPermCache memberPerm) {
        this.memberPerm = memberPerm;
        return this;
    }

    public SpreadContainer getSpreadContainer() {
        return this.spreadContainer;
    }

    public DrillRowDimCommand setSpreadContainer(SpreadContainer spreadContainer) {
        this.spreadContainer = spreadContainer;
        return this;
    }
}

