/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analyze.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.GroupNodeTypeEnum;
import kd.epm.eb.common.permission.IMemberPermCache;
import kd.epm.eb.common.permission.MemberPermCacheServiceHelper;
import kd.epm.eb.formplugin.analyze.DiffAnalyzeHelper;
import kd.epm.eb.formplugin.analyze.IDiffAnalyzePlugin;
import kd.epm.eb.formplugin.analyze.command.DiffAnalyzeCommand;
import kd.epm.eb.spread.analyze.DiffAnalyzeScheme;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.command.style.CellGroupNodeInfo;
import kd.epm.eb.spread.command.style.CellStyleInfo;
import kd.epm.eb.spread.command.style.HorizontalAlignEnum;
import kd.epm.eb.spread.control.SpreadContainer;
import kd.epm.eb.spread.template.spreadmanager.DiffCellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IDiffAnalyzeSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.hander.ESpanInfo;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.StyleCell;

public class ExpandColChildCommand
extends DiffAnalyzeCommand {
    private int index;
    private int range;
    private IDiffAnalyzeSpreadManager spreadManager = null;
    private IModelCacheHelper modelCacheHelper = null;
    private IMemberPermCache memberPerm = null;
    private SpreadContainer spreadContainer = null;
    private DiffAnalyzeScheme diffAnalyzeScheme;

    public ExpandColChildCommand(int index, int range, IDiffAnalyzeSpreadManager spreadManager, DiffAnalyzeScheme diffAnalyzeScheme) {
        this.index = index;
        this.range = range;
        this.spreadManager = spreadManager;
        this.diffAnalyzeScheme = diffAnalyzeScheme;
    }

    @Override
    protected void beforeExecute(IDiffAnalyzePlugin formPlugin) {
        super.beforeExecute(formPlugin);
        if (this.modelCacheHelper == null && this.spreadManager != null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.spreadManager.getModelid());
        }
        if (this.memberPerm == null && this.modelCacheHelper != null && this.spreadManager != null) {
            this.memberPerm = MemberPermCacheServiceHelper.build(null, (Long)this.spreadManager.getModelid(), (Long)this.modelCacheHelper.getBusModelByDataSet(this.spreadManager.getDatasetid()), null);
        }
        if (this.spreadContainer == null) {
            this.spreadContainer = new SpreadContainer(this.formView, formPlugin.getSpreadKey());
        }
        if (this.diffAnalyzeScheme != null && this.spreadManager != null) {
            this.spreadManager.setDiffAnalyzeScheme(this.diffAnalyzeScheme);
        }
    }

    @Override
    protected void doExecute(IDiffAnalyzePlugin formPlugin) {
        DiffCellDimMember parentCellDimMember = null;
        List cellDimMembers = this.spreadManager.getColCellDimMembers();
        ISheet sheet = this.spreadManager.getEbook().getSheet(0);
        int cnt = this.diffAnalyzeScheme.getAnalyzeColumns().size();
        if (this.index > 0 && cellDimMembers != null && cellDimMembers.size() > this.index && (parentCellDimMember = (DiffCellDimMember)cellDimMembers.get(this.index)) != null && !parentCellDimMember.isIsleaf()) {
            List<ECell> updateUICells;
            StyleCell currentCell = DiffAnalyzeHelper.getStyleCellNotAdd(sheet, 0, this.index);
            StyleCell nextCell = DiffAnalyzeHelper.getStyleCellNotAdd(sheet, 0, this.index + cnt);
            if (currentCell != null && nextCell != null && nextCell.getTextIndent() > currentCell.getTextIndent()) {
                return;
            }
            this.spreadContainer.setGroupColNode(Collections.singletonList(CellGroupNodeInfo.ofSmallRadix((int)0, (int)this.index, (int)GroupNodeTypeEnum.COLLAPSE.getIndex(), (int)parentCellDimMember.getTi(), (boolean)true)));
            String dimNumber = parentCellDimMember.getDimNumber();
            String memNumber = parentCellDimMember.getMemNumber();
            Long viewId = (Long)this.spreadManager.getDimemsionViews().get(dimNumber);
            List<Object> members = DiffAnalyzeHelper.getMember(formPlugin.getDatasetId(), this.modelCacheHelper, this.memberPerm, dimNumber, viewId, memNumber, this.range);
            ECell scopeCell = this.getScopeCell(sheet, this.index);
            Set scopeMemberIds = null;
            int scopeMemberRange = this.range;
            if (scopeCell != null) {
                String rootNumber = (String)scopeCell.getUserObject("memnumber");
                int rootNumberScope = Integer.parseInt(scopeCell.getUserObject("scope") + "");
                List allMembers = this.getModelCacheHelper().getMember(dimNumber, viewId, rootNumber, rootNumberScope);
                Set allMemberIds = allMembers.stream().map(x -> x.getId()).collect(Collectors.toSet());
                members = members.stream().filter(x -> allMemberIds.contains(x.getId())).collect(Collectors.toList());
                scopeMemberIds = allMemberIds;
                scopeMemberRange = rootNumberScope;
            }
            if ((updateUICells = DiffAnalyzeHelper.insertMemberCols(this.spreadManager, this.spreadContainer, this.index, members, this.modelCacheHelper, scopeMemberIds, this.range)) != null && updateUICells.size() > 0) {
                List memberCells = updateUICells.stream().filter(e -> e.getRow() == 0).collect(Collectors.toList());
                this.spreadContainer.insertColsAfter(this.index + cnt - 1, memberCells.size() * cnt, false);
                this.spreadContainer.updateCellValue2(updateUICells);
                this.spreadContainer.setCellStyle(Collections.singletonList(new AreasStyle(Collections.singletonList(new CellArea(0, 0, 1, sheet.getMaxColumnCount())), new CellStyleInfo().ofHa(HorizontalAlignEnum.Center).ofF("13px Microsoft YaHei"))));
                int groupNodeIndex = this.index + cnt;
                ArrayList<CellArea> cellAreas = new ArrayList<CellArea>(16);
                for (ECell memberCell : memberCells) {
                    DiffAnalyzeHelper.refreshGroupNodeType(this.spreadContainer, this.spreadManager.getColCellDimMembers(), groupNodeIndex, 1, this.spreadManager.getEbook().getSheet(0), false);
                    groupNodeIndex += cnt;
                    ESpanInfo spanInfo = memberCell.getSpanInfo();
                    if (spanInfo == null) continue;
                    cellAreas.add(new CellArea(spanInfo.getRow(), spanInfo.getCol(), spanInfo.getRowcount(), spanInfo.getColcount()));
                }
                this.spreadContainer.setSpan(cellAreas);
                formPlugin.refreshCellData();
                this.spreadContainer.lockSheets(Collections.singletonList(this.spreadManager.getEbook().getSheet(0).getSheetName()));
            } else {
                this.formView.showTipNotification(ResManager.loadKDString((String)"\u5c55\u5f00\u6216\u94bb\u53d6\u7684\u6210\u5458\u6ca1\u6709\u6570\u636e\u6743\u9650\u3002", (String)"DiffAnalyzePlugin_53", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private ECell getScopeCell(ISheet sheet, int index) {
        ECell eCell = null;
        if (sheet != null) {
            for (int i = index; i > 0; --i) {
                eCell = sheet.getECellNotAdd(0, i);
                if (eCell == null || eCell.getUserObject("scope") == null || eCell.getUserObject("memnumber") == null) continue;
                return eCell;
            }
        }
        return null;
    }

    public IModelCacheHelper getModelCacheHelper() {
        return this.modelCacheHelper;
    }

    public ExpandColChildCommand setModelCacheHelper(IModelCacheHelper modelCacheHelper) {
        this.modelCacheHelper = modelCacheHelper;
        return this;
    }

    public IMemberPermCache getMemberPerm() {
        return this.memberPerm;
    }

    public ExpandColChildCommand setMemberPerm(IMemberPermCache memberPerm) {
        this.memberPerm = memberPerm;
        return this;
    }

    public SpreadContainer getSpreadContainer() {
        return this.spreadContainer;
    }

    public ExpandColChildCommand setSpreadContainer(SpreadContainer spreadContainer) {
        this.spreadContainer = spreadContainer;
        return this;
    }
}

