/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analyze.command;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.permission.IMemberPermCache;
import kd.epm.eb.common.permission.MemberPermCacheServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.adjustdecompose.AdjustServiceHelper;
import kd.epm.eb.formplugin.analyze.DiffAnalyzeHelper;
import kd.epm.eb.formplugin.analyze.IDiffAnalyzePlugin;
import kd.epm.eb.formplugin.analyze.command.DiffAnalyzeCommand;
import kd.epm.eb.olap.api.metadata.IDataRow;
import kd.epm.eb.olap.enums.DataRowEnum;
import kd.epm.eb.olap.service.DiffAnalyzeService;
import kd.epm.eb.olap.service.request.DrillQueryRequest;
import kd.epm.eb.spread.adaptor.OlapQuerySync;
import kd.epm.eb.spread.analyze.DiffAnalyzeScheme;
import kd.epm.eb.spread.command.stylecontroller.DiffAnalyzeStyleController;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.control.SpreadContainer;
import kd.epm.eb.spread.template.spreadmanager.DiffCellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IDiffAnalyzeSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.utils.AttachmentHelper;

public class RefreshCellDataCommand
extends DiffAnalyzeCommand {
    private int startRow;
    private int endRow;
    private DiffAnalyzeScheme diffAnalyzeScheme;
    private IDiffAnalyzeSpreadManager spreadManager = null;
    private IModelCacheHelper modelCacheHelper = null;
    private IMemberPermCache memberPerm = null;
    private SpreadContainer spreadContainer = null;
    protected Set<Integer> refreshRows;
    BigDecimal dataUnitInBigDecimal = null;

    public RefreshCellDataCommand(IDiffAnalyzePlugin formPlugin) {
        if (formPlugin != null) {
            this.formPlugin = formPlugin;
            this.formView = formPlugin.getView();
            this.pageCache = (IPageCache)this.formView.getService(IPageCache.class);
        }
    }

    public RefreshCellDataCommand(int startRow, int endRow, IDiffAnalyzePlugin formPlugin) {
        this.startRow = startRow;
        this.endRow = endRow;
        if (formPlugin != null) {
            this.formPlugin = formPlugin;
            this.formView = formPlugin.getView();
            this.pageCache = (IPageCache)this.formView.getService(IPageCache.class);
        }
    }

    public RefreshCellDataCommand(int startRow, int endRow, DiffAnalyzeScheme diffAnalyzeScheme, IDiffAnalyzeSpreadManager spreadManager) {
        this.startRow = startRow;
        this.endRow = endRow;
        this.diffAnalyzeScheme = diffAnalyzeScheme;
        this.spreadManager = spreadManager;
    }

    public RefreshCellDataCommand(int startRow, int endRow, DiffAnalyzeScheme diffAnalyzeScheme, IDiffAnalyzeSpreadManager spreadManager, boolean cacheSMAfterExecute) {
        this.startRow = startRow;
        this.endRow = endRow;
        this.diffAnalyzeScheme = diffAnalyzeScheme;
        this.spreadManager = spreadManager;
        this.cacheSMAfterExecute = cacheSMAfterExecute;
    }

    @Override
    protected void beforeExecute(IDiffAnalyzePlugin formPlugin) {
        super.beforeExecute(formPlugin);
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = formPlugin.getModelCacheHelper();
            if (this.modelCacheHelper == null && this.spreadManager != null) {
                this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.spreadManager.getModelid());
            }
        }
        if (this.memberPerm == null && this.modelCacheHelper != null && this.spreadManager != null) {
            this.memberPerm = MemberPermCacheServiceHelper.build(null, (Long)this.spreadManager.getModelid(), (Long)this.modelCacheHelper.getBusModelByDataSet(this.spreadManager.getDatasetid()), null);
        }
        if (this.spreadContainer == null) {
            this.spreadContainer = new SpreadContainer(this.formView, formPlugin.getSpreadKey());
        }
        if (this.spreadManager != null) {
            this.spreadManager.setModelCacheHelper(this.modelCacheHelper);
            this.spreadManager.setMemberPerm(this.memberPerm);
        }
    }

    @Override
    protected void doExecute(IDiffAnalyzePlugin formPlugin) {
        kd.epm.eb.common.model.Dimension metricDim;
        if (formPlugin.isEditSchemeMode()) {
            return;
        }
        DrillQueryRequest request = this.getDrillRequest(this.startRow, this.endRow, this.diffAnalyzeScheme);
        Map<MembersKey, Object[]> datas = this.getDrillData(request);
        List rowCellDimMembers = this.spreadManager.getRowCellDimMembers();
        List colCellDimMembers = this.spreadManager.getColCellDimMembers();
        List commonDimension = this.spreadManager.getCommonDimension();
        String METRIC = SysDimensionEnum.Metric.getNumber();
        boolean metricInRow = this.spreadManager.getRowDimension() != null && this.spreadManager.getRowDimension().getNumber().equals(METRIC);
        boolean metricInCol = this.spreadManager.getColDimension() != null && this.spreadManager.getColDimension().getNumber().equals(METRIC);
        String metricDT = null;
        Optional<kd.epm.eb.common.model.Dimension> optional = this.spreadManager.getCommonDimension().stream().filter(e -> METRIC.equals(e.getNumber())).findFirst();
        kd.epm.eb.common.model.Dimension dimension = metricDim = optional.isPresent() ? optional.get() : null;
        if (metricDim != null && metricDim.getMembers() != null && metricDim.getMembers().size() > 0) {
            String commonMetric = ((Member)metricDim.getMembers().get(0)).getNumber();
            metricDT = this.getModelCacheHelper().getMember(METRIC, null, commonMetric).getDatatype();
        }
        if (datas != null && datas.size() > 0 && rowCellDimMembers != null) {
            HashMap<String, String> colFm = new HashMap<String, String>(16);
            HashMap<String, Map> colDimMemberMap = new HashMap<String, Map>(16);
            HashSet colDims = new HashSet(16);
            ArrayList<String> rangesInAdjust = new ArrayList<String>(16);
            List dimensionList = this.spreadManager.getModelCacheHelper().getDimensionList(this.spreadManager.getDatasetid());
            List dimensionNumbers = dimensionList.stream().map(BaseCache::getNumber).collect(Collectors.toList());
            List columns = this.diffAnalyzeScheme.getAnalyzeColumns();
            for (Object column : columns) {
                colFm.put(column.getDisplayName(), column.getDisplayFormat());
                IDataRow dataRow = column.getDataRow();
                if (DataRowEnum.DATA != dataRow.getDataRowType()) continue;
                Map metas = dataRow.getMetas();
                metas.entrySet().removeIf(entry -> !dimensionNumbers.contains(entry.getKey()));
                colDimMemberMap.put(column.getDisplayName(), metas);
                colDims.addAll(metas.keySet());
                if (!metas.containsKey(METRIC)) continue;
                metricInCol = true;
            }
            HashMap<String, String> memberMap = new HashMap<String, String>(16);
            for (kd.epm.eb.common.model.Dimension dimension2 : commonDimension) {
                List members = dimension2.getMembers();
                if (CollectionUtils.isEmpty((Collection)members)) {
                    return;
                }
                if (colDims.contains(dimension2.getNumber())) continue;
                memberMap.put(dimension2.getNumber(), ((Member)members.get(0)).getNumber());
            }
            Map adjustMemberMap = AdjustServiceHelper.getAdjustMemberMap((IModelCacheHelper)this.modelCacheHelper, (Long)formPlugin.getBusModelId(), (Long)formPlugin.getDatasetId(), memberMap, (Map)this.spreadManager.getDimemsionViews());
            ISheet sheet = this.spreadManager.getEbook().getSheet(0);
            ArrayList<Map<String, Object>> parameters = new ArrayList<Map<String, Object>>(16);
            MembersKey membersKey = null;
            Object value = null;
            int schemeRowIndex = this.spreadManager.getSchemeRowIndex();
            int valueColStart = this.spreadManager.getValueColStart();
            LinkedList<String> keyDims = new LinkedList<String>();
            if (request != null && request.getRowDims() != null) {
                keyDims.addAll(request.getRowDims().stream().map(kd.epm.eb.common.model.Dimension::getNumber).collect(Collectors.toList()));
            }
            if (request != null && request.getColDims() != null) {
                keyDims.addAll(request.getColDims().stream().map(kd.epm.eb.common.model.Dimension::getNumber).collect(Collectors.toList()));
            }
            boolean hasColMember = this.spreadManager.getColDimension() != null && colCellDimMembers != null && colCellDimMembers.size() > 0;
            int row = this.startRow;
            int cnt = 0;
            while (row <= this.endRow && row < rowCellDimMembers.size()) {
                ECell rowCell = sheet.getECellNotAdd(row, 0);
                DiffCellDimMember rowCellDimMember = (DiffCellDimMember)rowCellDimMembers.get(row);
                if (rowCell != null && rowCellDimMember != null && !this.getRefreshedRows().contains(row)) {
                    ECell cell;
                    int col;
                    boolean refreshedWithData = false;
                    if (hasColMember) {
                        for (col = 0; datas != null && col < sheet.getRealMaxCols() && col < colCellDimMembers.size(); ++col) {
                            Integer indexInGroup;
                            Map colMemberMap;
                            ECell colCell = sheet.getECellNotAdd(schemeRowIndex, col);
                            DiffCellDimMember colCellDimMember = (DiffCellDimMember)colCellDimMembers.get(col);
                            if (colCell == null || colCellDimMember == null) continue;
                            boolean isRadix = false;
                            Object cellValue = colCell.getValue();
                            if (colFm.get(cellValue) != null && ((String)colFm.get(cellValue)).endsWith("%")) {
                                isRadix = true;
                            }
                            if ((colMemberMap = (Map)colDimMemberMap.get(cellValue)) != null) {
                                memberMap.putAll(colMemberMap);
                            }
                            memberMap.put(rowCellDimMember.getDimNumber(), rowCellDimMember.getMemNumber());
                            memberMap.put(colCellDimMember.getDimNumber(), colCellDimMember.getMemNumber());
                            Set adjustMemberSet = (Set)adjustMemberMap.get(memberMap.hashCode());
                            if (adjustMemberSet != null && adjustMemberSet.contains(memberMap)) {
                                String posStr = ExcelUtils.xy2Pos((int)col, (int)row);
                                rangesInAdjust.add(posStr);
                            }
                            if ((membersKey = this.computeMembersKey(rowCellDimMember, colCellDimMember, commonDimension, keyDims)).getKeys() == null) continue;
                            cell = sheet.getECell(row, col);
                            Object[] groupValues = datas.get(membersKey);
                            if (groupValues == null || groupValues.length <= 0 || (indexInGroup = (Integer)colCell.getUserObject("index")) == null) continue;
                            value = isRadix ? groupValues[indexInGroup] : this.getRealValueWithDataUnit(metricInRow ? rowCell.getUserObject("metricDT") : (metricInCol ? colCell.getUserObject("metricDT") : metricDT), groupValues[indexInGroup]);
                            cell.setValue(value);
                            DiffAnalyzeHelper.packageCells(parameters, cell);
                            refreshedWithData = true;
                        }
                    } else {
                        for (col = 0; datas != null && col < columns.size(); ++col) {
                            Object[] groupValues;
                            ECell schemeCell = sheet.getECellNotAdd(schemeRowIndex, col + valueColStart);
                            if (schemeCell == null) continue;
                            memberMap.put(rowCellDimMember.getDimNumber(), rowCellDimMember.getMemNumber());
                            Set adjustMemberSet = (Set)adjustMemberMap.get(memberMap.hashCode());
                            if (adjustMemberSet != null && adjustMemberSet.contains(memberMap)) {
                                String posStr = ExcelUtils.xy2Pos((int)(col + valueColStart), (int)row);
                                rangesInAdjust.add(posStr);
                            }
                            if ((membersKey = this.computeMembersKey(rowCellDimMember, null, commonDimension, keyDims)).getKeys() == null || (groupValues = datas.get(membersKey)) == null || groupValues.length <= 0) continue;
                            cell = sheet.getECell(row, col + valueColStart);
                            value = this.getRealValueWithDataUnit(metricInRow ? rowCell.getUserObject("metricDT") : schemeCell.getUserObject("metricDT"), groupValues[col]);
                            cell.setValue(value);
                            DiffAnalyzeHelper.packageCells(parameters, cell);
                            refreshedWithData = true;
                        }
                    }
                    rowCellDimMember.setRefreshed(refreshedWithData);
                }
                ++row;
                ++cnt;
            }
            if (parameters.size() > 0) {
                this.spreadContainer.updateCellValue(parameters);
            }
            this.spreadManager.setDiffAnalyzeScheme(this.diffAnalyzeScheme);
            Map<Object, Object> displaySettings = new HashMap(16);
            String str = this.pageCache.get("diffDisplaySettings");
            displaySettings = kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)str) ? (Map)SerializationUtils.fromJsonString((String)str, Map.class) : this.getDiffDisplaySettings(false);
            DiffAnalyzeStyleController.setCellStyles((int)this.startRow, (int)this.endRow, (IDiffAnalyzeSpreadManager)this.spreadManager, (SpreadContainer)this.spreadContainer, displaySettings);
            if (sheet.getRealMaxRows() < 1000) {
                this.cacheLastViewArea(null);
            }
            AttachmentHelper.setTaskCellTagsByRange(rangesInAdjust, (Boolean)true, (ISpreadContainer)this.spreadContainer, (int)3);
        }
        if (this.spreadManager.isHideEmptyRows()) {
            DiffAnalyzeStyleController.hideEmptyRows((IDiffAnalyzeSpreadManager)this.spreadManager, (SpreadContainer)this.spreadContainer);
        }
    }

    @Override
    protected void afterExecute(IDiffAnalyzePlugin formPlugin) {
        super.afterExecute(formPlugin);
        this.cacheRefreshRows(this.startRow, this.endRow);
    }

    private DrillQueryRequest getDrillRequest(int startRow, int endRow, DiffAnalyzeScheme diffAnalyzeScheme) {
        if (diffAnalyzeScheme == null || diffAnalyzeScheme.getAnalyzeColumns() == null) {
            return null;
        }
        Long modelId = this.spreadManager.getModelid();
        Long datasetId = this.spreadManager.getDatasetid();
        if (modelId == null || modelId == 0L || datasetId == null || datasetId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"Olap\u67e5\u8be2\u5931\u8d25\u3002\u8bf7\u786e\u4fdd\u4f53\u7cfb\u548c\u6570\u636e\u96c6\u4e0d\u4e3a\u7a7a\u3002", (String)"DiffAnalyzeSpreadManager_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Long busModelId = this.spreadManager.getBusmodelid();
        if (busModelId == null) {
            busModelId = DatasetServiceHelper.getBusModelIdByDataset((Long)datasetId);
        }
        HashMap<String, kd.epm.eb.common.model.Dimension> rowDimMap = new HashMap<String, kd.epm.eb.common.model.Dimension>();
        HashMap<String, kd.epm.eb.common.model.Dimension> colDimMap = new HashMap<String, kd.epm.eb.common.model.Dimension>();
        HashMap<String, Set<String>> memsMap = new HashMap<String, Set<String>>();
        HashSet mems = null;
        kd.epm.eb.common.model.Dimension dimension = null;
        Dimension cacheDimension = null;
        DiffCellDimMember cellDimMember = null;
        List rowCellDimMembers = this.spreadManager.getRowCellDimMembers();
        if (rowCellDimMembers != null) {
            int i = startRow;
            int cnt = 0;
            int size = rowCellDimMembers.size();
            while (i <= endRow && i < size) {
                cellDimMember = (DiffCellDimMember)rowCellDimMembers.get(i);
                if (cellDimMember != null && !this.getRefreshedRows().contains(i)) {
                    this.setDimMemsFromCell(cellDimMember, rowDimMap, memsMap);
                    while (cellDimMember != null && cellDimMember.getUpperDimParent() != null) {
                        this.setDimMemsFromCell(cellDimMember.getUpperDimParent(), rowDimMap, memsMap);
                        cellDimMember = cellDimMember.getUpperDimParent();
                    }
                }
                ++i;
                ++cnt;
            }
        }
        if (rowDimMap.isEmpty()) {
            return null;
        }
        DrillQueryRequest drillQueryRequest = new DrillQueryRequest();
        drillQueryRequest.setModelId(modelId);
        drillQueryRequest.setBizModelId(busModelId);
        drillQueryRequest.setDatasetId(datasetId);
        drillQueryRequest.setViewMap(this.spreadManager.getDimemsionViews());
        drillQueryRequest.setRowDims((List)Lists.newArrayList(rowDimMap.values()));
        List colCellDimMembers = this.spreadManager.getColCellDimMembers();
        if (colCellDimMembers != null) {
            for (int i = 0; i < colCellDimMembers.size(); ++i) {
                kd.epm.eb.common.cache.impl.Member member;
                cellDimMember = (DiffCellDimMember)colCellDimMembers.get(i);
                if (cellDimMember == null) continue;
                String dimNumber = cellDimMember.getDimNumber();
                String memNumber = cellDimMember.getMemNumber();
                dimension = (kd.epm.eb.common.model.Dimension)colDimMap.get(dimNumber);
                if (dimension == null) {
                    cacheDimension = this.modelCacheHelper.getDimension(dimNumber);
                    if (cacheDimension == null) {
                        throw new KDBizException(ResManager.loadResFormat((String)"\u7f16\u7801%1\u5bf9\u5e94\u7684\u7ef4\u5ea6\u4e0d\u5b58\u5728\u3002", (String)"DiffAnalyzeSpreadManager_5", (String)"epm-eb-formplugin", (Object[])new Object[]{dimNumber}));
                    }
                    dimension = kd.epm.eb.common.model.Dimension.loadFormCache((Dimension)cacheDimension);
                    colDimMap.put(dimNumber, dimension);
                }
                if ((mems = (HashSet)memsMap.get(dimNumber)) == null) {
                    mems = new HashSet(16);
                    memsMap.put(dimNumber, mems);
                }
                if (mems.contains(memNumber) || (member = this.modelCacheHelper.getMember(dimension.getNumber(), (Long)this.spreadManager.getDimemsionViews().get(dimension.getNumber()), memNumber)) == null) continue;
                dimension.add(Member.loadFormCache((kd.epm.eb.common.cache.impl.Member)member));
            }
        }
        if (this.spreadManager.getColDimension() != null && colDimMap.isEmpty()) {
            return null;
        }
        drillQueryRequest.setColDims((List)Lists.newArrayList(colDimMap.values()));
        List commonDimension = this.spreadManager.getCommonDimension();
        if (commonDimension != null) {
            for (kd.epm.eb.common.model.Dimension d : commonDimension) {
                kd.epm.eb.common.model.Dimension drilledDimension = (kd.epm.eb.common.model.Dimension)rowDimMap.get(d.getNumber());
                for (Member m : d.getMembers()) {
                    kd.epm.eb.common.cache.impl.Member cacheMem;
                    if (drilledDimension != null) {
                        drilledDimension.getMembers().add(m);
                    }
                    if (m.getId() != null || m.getNumber() == null || (cacheMem = this.modelCacheHelper.getMember(d.getNumber(), (Long)this.spreadManager.getDimemsionViews().get(d.getNumber()), m.getNumber())) == null) continue;
                    m.setId(cacheMem.getId());
                }
            }
            drillQueryRequest.setCommDims(commonDimension);
        }
        drillQueryRequest.setDataRows(diffAnalyzeScheme.getAnalyzeColumns().stream().map(c -> c.getDataRow()).collect(Collectors.toList()));
        return drillQueryRequest;
    }

    private void setDimMemsFromCell(DiffCellDimMember cellDimMember, Map<String, kd.epm.eb.common.model.Dimension> dimMap, Map<String, Set<String>> memsMap) {
        if (cellDimMember != null) {
            kd.epm.eb.common.cache.impl.Member member;
            Set<String> mems;
            String dimNumber = cellDimMember.getDimNumber();
            String memNumber = cellDimMember.getMemNumber();
            kd.epm.eb.common.model.Dimension dimension = dimMap.get(dimNumber);
            if (dimension == null) {
                Dimension cacheDimension = this.modelCacheHelper.getDimension(dimNumber);
                if (cacheDimension == null) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u7f16\u7801%1\u5bf9\u5e94\u7684\u7ef4\u5ea6\u4e0d\u5b58\u5728\u3002", (String)"DiffAnalyzeSpreadManager_5", (String)"epm-eb-formplugin", (Object[])new Object[]{dimNumber}));
                }
                dimension = kd.epm.eb.common.model.Dimension.loadFormCache((Dimension)cacheDimension);
                dimMap.put(dimNumber, dimension);
            }
            if ((mems = memsMap.get(dimNumber)) == null) {
                mems = new HashSet<String>(16);
                memsMap.put(dimNumber, mems);
            }
            if (mems.add(memNumber) && (member = this.modelCacheHelper.getMember(dimension.getNumber(), (Long)this.spreadManager.getDimemsionViews().get(dimension.getNumber()), memNumber)) != null) {
                dimension.add(Member.loadFormCache((kd.epm.eb.common.cache.impl.Member)member));
            }
        }
    }

    private SelectCommandInfo getQueryInfo() {
        SelectCommandInfo queryInfo = new SelectCommandInfo();
        List commonDimension = this.spreadManager.getCommonDimension();
        kd.epm.eb.common.model.Dimension rowDimension = this.spreadManager.getRowDimension();
        kd.epm.eb.common.model.Dimension colDimension = this.spreadManager.getColDimension();
        int dimSize = commonDimension.size();
        if (rowDimension != null) {
            ++dimSize;
        }
        if (colDimension != null) {
            ++dimSize;
        }
        String[] dims = new String[dimSize];
        int index = 0;
        if (rowDimension != null) {
            dims[index++] = rowDimension.getNumber();
        }
        if (colDimension != null) {
            dims[index++] = colDimension.getNumber();
        }
        if (commonDimension != null) {
            for (kd.epm.eb.common.model.Dimension dimension : commonDimension) {
                dims[index++] = dimension.getNumber();
            }
        }
        queryInfo.addDims(dims);
        queryInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        return queryInfo;
    }

    private Map<MembersKey, Object[]> getDrillData(DrillQueryRequest request) {
        Map datas = null;
        if (request != null) {
            try {
                this.log.info("getDrillData: drillQuery=" + (request == null ? "null" : request.toString()));
                long time1 = TimeServiceHelper.now().getTime();
                datas = DiffAnalyzeService.getInstance().drill(request);
                long time2 = TimeServiceHelper.now().getTime();
                this.log.info("getDrillData: cost time=" + (time2 - time1) + ", datas=" + DiffAnalyzeHelper.getPrintInfo(datas, 50));
            }
            catch (Exception ex) {
                this.log.error((Throwable)ex);
                if (ex instanceof KDBizException) {
                    String message = ThrowableHelper.getMessage((Exception)ex);
                    if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)message) && message.endsWith("\u3002")) {
                        throw new KDBizException(ResManager.loadResFormat((String)"Olap\u67e5\u8be2\u5931\u8d25\u3002%1\u3002", (String)"DiffAnalyzeSpreadManager_3", (String)"epm-eb-formplugin", (Object[])new Object[]{message}));
                    }
                    throw new KDBizException(ResManager.loadResFormat((String)"Olap\u67e5\u8be2\u5931\u8d25\u3002%1\u3002", (String)"DiffAnalyzeSpreadManager_6", (String)"epm-eb-formplugin", (Object[])new Object[]{message}));
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DiffAnalyzePlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.log.info("getDrillData: request is null.");
        }
        return datas;
    }

    private MembersKey computeMembersKey(DiffCellDimMember rowCellDimMem, DiffCellDimMember colCellDimMem, List<kd.epm.eb.common.model.Dimension> commonDimension, List<String> keyDims) {
        MembersKey membersKey = new MembersKey();
        HashMap<String, DiffCellDimMember> dimMap = new HashMap<String, DiffCellDimMember>(2);
        if (rowCellDimMem != null) {
            dimMap.putAll(rowCellDimMem.getDimMap());
        }
        if (colCellDimMem != null) {
            dimMap.putAll(colCellDimMem.getDimMap());
        }
        if (keyDims.size() > dimMap.size() && commonDimension != null) {
            for (kd.epm.eb.common.model.Dimension dimension : commonDimension) {
                String dimNumber = dimension.getNumber();
                if (!keyDims.contains(dimNumber) || dimMap.containsKey(dimNumber) || dimension.getMembers() == null || dimension.getMembers().isEmpty()) continue;
                String memNumber = ((Member)dimension.getMembers().get(0)).getNumber();
                DiffCellDimMember cellDimMember = new DiffCellDimMember();
                cellDimMember.setDimNumber(dimNumber);
                cellDimMember.setMemNumber(memNumber);
                dimMap.put(dimNumber, cellDimMember);
            }
        }
        Object[] dimMemNums = new String[dimMap.size() + 1];
        int i = 1;
        for (String dimK : keyDims) {
            DiffCellDimMember cellDimMember = (DiffCellDimMember)dimMap.get(dimK);
            if (cellDimMember == null) continue;
            dimMemNums[i] = cellDimMember.getMemNumber();
            ++i;
        }
        membersKey.setKeys(dimMemNums);
        return membersKey;
    }

    private Object getRealValueWithDataUnit(Object metricDataType, Object value) {
        if (value != null && this.getDataUnitInBigDecimal() != null && MetricDataTypeEnum.CURRENCY.getIndex().equals(metricDataType)) {
            value = ((BigDecimal)value).divide(this.getDataUnitInBigDecimal());
        }
        return value;
    }

    private BigDecimal getDataUnitInBigDecimal() {
        if (this.dataUnitInBigDecimal != null) {
            return this.dataUnitInBigDecimal;
        }
        if (StringUtils.isNotEmpty((String)this.spreadManager.getDataUnit()) && !"0".equals(this.spreadManager.getDataUnit())) {
            this.dataUnitInBigDecimal = BigDecimal.TEN.pow(Integer.parseInt(this.spreadManager.getDataUnit()));
        }
        return this.dataUnitInBigDecimal;
    }

    public IModelCacheHelper getModelCacheHelper() {
        return this.modelCacheHelper;
    }

    public RefreshCellDataCommand setModelCacheHelper(IModelCacheHelper modelCacheHelper) {
        this.modelCacheHelper = modelCacheHelper;
        return this;
    }

    public IMemberPermCache getMemberPerm() {
        return this.memberPerm;
    }

    public RefreshCellDataCommand setMemberPerm(IMemberPermCache memberPerm) {
        this.memberPerm = memberPerm;
        return this;
    }

    public SpreadContainer getSpreadContainer() {
        return this.spreadContainer;
    }

    public RefreshCellDataCommand setSpreadContainer(SpreadContainer spreadContainer) {
        this.spreadContainer = spreadContainer;
        return this;
    }

    public void cacheRefreshRows(OlapQuerySync.ViewArea viewArea) {
        this.getRefreshedRows();
        for (int i = viewArea.getStartrow(); i <= viewArea.getEndrow(); ++i) {
            this.refreshRows.add(i);
        }
        this.formView.getPageCache().put("refreshDataRows", SerializationUtils.toJsonString(this.refreshRows));
    }

    public void cacheRefreshRows(int startRow, int endRow) {
        this.cacheRefreshRows(new OlapQuerySync.ViewArea(startRow, endRow, 0, 100));
    }

    public void cacheRefreshRows(Set<Integer> rows) {
        this.refreshRows = rows;
        if (rows != null) {
            this.formView.getPageCache().put("refreshDataRows", SerializationUtils.toJsonString(rows));
        } else {
            this.removeRefreshRows();
        }
    }

    public Set<Integer> getRefreshedRows() {
        if (this.refreshRows != null) {
            return this.refreshRows;
        }
        String serial = this.formView.getPageCache().get("refreshDataRows");
        this.refreshRows = kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)serial) ? (Set<Object>)SerializationUtils.fromJsonString((String)serial, Set.class) : new HashSet<Integer>();
        return this.refreshRows;
    }

    public void removeRefreshRows() {
        this.formView.getPageCache().remove("refreshDataRows");
        this.refreshRows = new HashSet<Integer>();
    }

    public boolean isViewDataRefreshed(OlapQuerySync.ViewArea viewArea) {
        Set<Integer> rows = this.getRefreshedRows();
        if (rows == null || rows.isEmpty()) {
            return false;
        }
        if (viewArea == null) {
            return false;
        }
        Integer minRow = (Integer)rows.stream().min(Integer::compareTo).get();
        Integer maxRow = (Integer)rows.stream().max(Integer::compareTo).get();
        boolean noJumpRows = maxRow - minRow == rows.size() - 1;
        return noJumpRows && minRow <= viewArea.getStartrow() && maxRow >= viewArea.getEndrow();
    }

    public void renewRefreshedRows(int sRow, int eRow, boolean isInsert) {
        this.refreshRows = this.getRefreshedRows();
        if (this.refreshRows != null && this.refreshRows.size() > 0) {
            this.log.info("before renewRefreshedRows(" + sRow + "," + eRow + "," + isInsert + ") refreshRows=" + this.refreshRows);
            HashSet<Integer> renewRefreshRows = new HashSet<Integer>(16);
            int count = eRow - sRow;
            if (isInsert) {
                this.refreshRows.forEach(r -> {
                    if (r <= sRow) {
                        renewRefreshRows.add((Integer)r);
                    } else {
                        renewRefreshRows.add(r + count);
                    }
                });
            } else {
                this.refreshRows.forEach(r -> {
                    if (r > eRow) {
                        renewRefreshRows.add(r - count);
                    } else {
                        renewRefreshRows.add((Integer)r);
                    }
                });
            }
            this.log.info("after renewRefreshedRows, refreshRows=" + renewRefreshRows);
            this.cacheRefreshRows(renewRefreshRows);
        }
    }

    public void cacheLastViewArea(OlapQuerySync.ViewArea viewArea) {
        if (viewArea == null) {
            this.formView.getPageCache().remove("lastViewArea");
        } else {
            this.formView.getPageCache().put("lastViewArea", ObjectSerialUtil.toByteSerialized((Object)viewArea));
        }
    }

    public OlapQuerySync.ViewArea getLastViewArea() {
        String serial = this.formView.getPageCache().get("lastViewArea");
        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)serial)) {
            return (OlapQuerySync.ViewArea)ObjectSerialUtil.deSerializedBytes((String)serial);
        }
        return null;
    }

    public OlapQuerySync.ViewArea viewAreaToRefresh(OlapQuerySync.ViewArea viewArea) {
        if (viewArea != null) {
            int startRow = viewArea.getStartrow();
            int endRow = viewArea.getEndrow();
            int count = endRow - startRow;
            this.refreshRows = this.getRefreshedRows();
            int notRefreshedRowStart = startRow;
            boolean isAllRowsRefreshed = true;
            for (int i = startRow; i <= endRow; ++i) {
                if (this.refreshRows.contains(i)) continue;
                notRefreshedRowStart = i;
                isAllRowsRefreshed = false;
                break;
            }
            if (isAllRowsRefreshed) {
                this.log.info("viewAreaToRefresh:all rows refreshed: " + viewArea);
                return null;
            }
            OlapQuerySync.ViewArea viewAreaToRefresh = new OlapQuerySync.ViewArea(notRefreshedRowStart, notRefreshedRowStart + count, viewArea.getStartcol(), viewArea.getEndcol());
            this.log.info("viewAreaToRefresh:resetting " + viewArea + " to " + viewAreaToRefresh + ", count=" + count + ", refreshRows=" + this.refreshRows);
            return viewAreaToRefresh;
        }
        return viewArea;
    }

    public void clearCellData() {
        this.clearCellData(true);
    }

    public void clearCellData(boolean onlyRefreshedRows) {
        this.spreadManager = this.formPlugin.getSpreadManager();
        if (this.spreadManager != null && (this.spreadContainer = this.formPlugin.getspreadContainer()) != null) {
            LinkedList<ECell> eCells = new LinkedList<ECell>();
            ISheet sheet = this.spreadManager.getEbook().getSheet(0);
            List cellDimMembers = this.spreadManager.getRowCellDimMembers();
            int valueRowStart = sheet.getValueAreaRowStart();
            int valueColStart = sheet.getValueAreaColStart();
            int maxCol = sheet.getRealMaxCols();
            int maxRow = sheet.getRealMaxRows();
            if (onlyRefreshedRows) {
                this.refreshRows = this.getRefreshedRows();
                for (int row : this.refreshRows) {
                    DiffCellDimMember cellDimMember;
                    if (row < valueRowStart) continue;
                    for (int col = valueColStart; col < maxCol; ++col) {
                        eCells.add(new ECell(row, col, (Object)""));
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)cellDimMembers) || (cellDimMember = (DiffCellDimMember)cellDimMembers.get(row)) == null) continue;
                    cellDimMember.setRefreshed(false);
                }
            } else {
                for (int row = valueRowStart; row < maxRow; ++row) {
                    DiffCellDimMember cellDimMember;
                    for (int col = valueColStart; col < maxCol; ++col) {
                        eCells.add(new ECell(row, col, (Object)""));
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)cellDimMembers) || (cellDimMember = (DiffCellDimMember)cellDimMembers.get(row)) == null) continue;
                    cellDimMember.setRefreshed(false);
                }
            }
            this.spreadContainer.updateCellValue2(eCells);
        }
    }
}

