/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analyze.command;

import java.util.LinkedList;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.enums.MemberDisplayTypeEnum;
import kd.epm.eb.formplugin.analyze.IDiffAnalyzePlugin;
import kd.epm.eb.formplugin.analyze.command.DiffAnalyzeCommand;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;

public class RefreshMemberDisplayCommand
extends DiffAnalyzeCommand {
    private int memberDisplayType = -1;
    private static final int nameIndex = MemberDisplayTypeEnum.NAME.getIndex();
    private static final int numberIndex = MemberDisplayTypeEnum.NUMBER.getIndex();
    private static final int nameandnumberIndex = MemberDisplayTypeEnum.NAMEANDNUMBER.getIndex();
    private static final int simplenameIndex = MemberDisplayTypeEnum.SIMPLENAME.getIndex();
    private static final int simnamenumberIndex = MemberDisplayTypeEnum.SIMNAMENUMBER.getIndex();
    private static final int longnameIndex = MemberDisplayTypeEnum.LONGNAME.getIndex();
    private static final int longnumberIndex = MemberDisplayTypeEnum.LONGNUMBER.getIndex();
    private static final int longnamenumberIndex = MemberDisplayTypeEnum.LONGNAMENUMBER.getIndex();

    public RefreshMemberDisplayCommand(int memberDisplayType) {
        this.memberDisplayType = memberDisplayType;
    }

    @Override
    public void doExecute(IDiffAnalyzePlugin formPlugin) {
        ECell eCell;
        LinkedList<ECell> eCells = new LinkedList<ECell>();
        if (this.memberDisplayType < 0) {
            this.memberDisplayType = formPlugin.getSpreadManager().getMemberDisplayType();
        }
        ISheet sheet = formPlugin.getSpreadManager().getEbook().getSheet(0);
        int valueRowStart = sheet.getValueAreaRowStart();
        int valueColStart = sheet.getValueAreaColStart();
        int maxRow = sheet.getRealMaxRows();
        int maxCol = sheet.getRealMaxCols();
        Object value = null;
        for (int row = valueRowStart; row < maxRow; ++row) {
            eCell = sheet.getECellNotAdd(row, 0);
            if (eCell == null) continue;
            this.setCellValueByDisplayType(eCell);
            eCells.add(eCell);
        }
        if (valueRowStart > 1) {
            for (int col = valueColStart; col < maxCol; ++col) {
                eCell = sheet.getECellNotAdd(0, col);
                if (eCell == null) continue;
                this.setCellValueByDisplayType(eCell);
                eCells.add(eCell);
            }
        }
        formPlugin.getspreadContainer().updateCellValue2(eCells);
    }

    private void setCellValueByDisplayType(ECell eCell) {
        Object shnum;
        Object object = shnum = eCell.getUserObject("shnum") != null ? eCell.getUserObject("shnum") : eCell.getUserObject("memnumber");
        if (this.memberDisplayType == nameIndex) {
            eCell.setValue(eCell.getUserObject("name"));
        } else if (this.memberDisplayType == numberIndex) {
            eCell.setValue(shnum);
        } else if (this.memberDisplayType == nameandnumberIndex) {
            eCell.setValue((Object)(eCell.getUserObject("name") + ":" + (String)shnum));
        } else if (this.memberDisplayType == longnameIndex) {
            this.ensureLongDisplay(eCell);
            eCell.setValue(eCell.getUserObject("longname"));
        } else if (this.memberDisplayType == longnumberIndex) {
            this.ensureLongDisplay(eCell);
            eCell.setValue(eCell.getUserObject("longnumber"));
        } else if (this.memberDisplayType == longnamenumberIndex) {
            this.ensureLongDisplay(eCell);
            eCell.setValue((Object)(eCell.getUserObject("longname") + ":" + eCell.getUserObject("longnumber")));
        } else {
            String simpleName;
            String string = simpleName = StringUtils.isNotEmpty((String)((String)eCell.getUserObject("simplename"))) ? (String)eCell.getUserObject("simplename") : (String)eCell.getUserObject("name");
            if (this.memberDisplayType == simplenameIndex) {
                eCell.setValue((Object)simpleName);
            } else if (this.memberDisplayType == simnamenumberIndex) {
                eCell.setValue((Object)(simpleName + ":" + (String)shnum));
            }
        }
    }

    private void ensureLongDisplay(ECell eCell) {
        if (eCell != null && (eCell.getUserObject("longname") == null || eCell.getUserObject("longnumber") == null)) {
            Long viewId;
            String dimNumber = (String)eCell.getUserObject("dimnumber");
            String memNumber = (String)eCell.getUserObject("memnumber");
            IModelCacheHelper modelCacheHelper = this.formPlugin.getModelCacheHelper();
            Member member = modelCacheHelper.getMember(dimNumber, viewId = this.formPlugin.getViewId(dimNumber), memNumber);
            if (member != null) {
                eCell.setUserObject("longnumber", (Object)member.getLongNumber());
                eCell.setUserObject("longname", (Object)member.getLongName(modelCacheHelper.getParentsByOrder(viewId, member, false)));
            } else {
                eCell.setUserObject("longnumber", (Object)memNumber);
                eCell.setUserObject("longname", eCell.getUserObject("name"));
            }
        }
    }
}

