/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analyze.command;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.execanalyse.AnalyseType;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.analyze.DiffAnalyzeHelper;
import kd.epm.eb.formplugin.analyze.DiffAnalyzePlugin;
import kd.epm.eb.formplugin.analyze.IDiffAnalyzePlugin;
import kd.epm.eb.formplugin.analyze.command.DiffAnalyzeCommand;
import kd.epm.eb.olap.enums.DataRowEnum;

public class ShowFormCommand
extends DiffAnalyzeCommand {
    private String key;

    public ShowFormCommand(String key) {
        this.key = key;
    }

    @Override
    public void doExecute(IDiffAnalyzePlugin formPlugin) {
        switch (this.key) {
            case "editcol": {
                this.showFormEditExpr();
                break;
            }
            case "btn_savescheme": {
                this.showFormSchemeSave(false);
                break;
            }
            case "btn_saveschemeas": {
                this.showFormSchemeSave(true);
                break;
            }
            case "account_range": {
                this.showFormAccountRange();
                break;
            }
            case "displaysetting": {
                this.showFormDisplaySetting();
                break;
            }
            case "btn_share": {
                this.showFormSchemeShare();
            }
        }
    }

    private void showFormAccountRange() {
        List list;
        String dimNumber = this.formPlugin.getCurrentRowDimension();
        IModelCacheHelper modelCacheHelper = this.formPlugin.getModelCacheHelper();
        MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)this.formPlugin.getModelId(), (Long)modelCacheHelper.getDimension(dimNumber).getId());
        f7Param.setMustSelected(false);
        f7Param.setReturnClassName(ListSelectedRow.class.getName());
        f7Param.setBusModelId(Long.valueOf(this.formPlugin.getBusModelId()));
        f7Param.setEnableView(true);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("model", "=", (Object)this.formPlugin.getModelId()));
        if (SysDimensionEnum.AuditTrail.getNumber().equals(dimNumber)) {
            f7Param.setShowNotEnable(true);
            f7Param.setHideDecompose(false);
        } else if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
            f7Param.setDatasetId(Long.valueOf(this.formPlugin.getDatasetId()));
            filters.add(new QFilter("dataset", "=", (Object)this.formPlugin.getDatasetId()));
        } else if (SysDimensionEnum.Metric.getNumber().equals(dimNumber)) {
            filters.add(new QFilter("dataType", "in", (Object)Sets.newHashSet((Object[])new String[]{MetricDataTypeEnum.CURRENCY.getIndex(), MetricDataTypeEnum.NONMONETARY.getIndex()})));
        }
        f7Param.addCustomFilter(filters);
        String selectedItems_str = this.formView.getPageCache().get(this.key);
        if (StringUtils.isNotEmpty((String)selectedItems_str) && (list = (List)SerializationUtils.fromJsonString((String)selectedItems_str, List.class)) != null) {
            f7Param.setSelectIds(new LinkedHashSet(list.stream().map(e -> IDUtils.toLong(e.get("id"))).collect(Collectors.toList())));
        }
        if (DimensionViewServiceHelper.hasView((String)dimNumber)) {
            List viewGroupViewsByDataSetAndDimNumber;
            Long viewId = this.formPlugin.getDimensionViews().get(dimNumber);
            if (IDUtils.isNull((Long)viewId)) {
                viewId = this.formPlugin.getSchemeConfig().getViewId(dimNumber);
            }
            if (IDUtils.isNotNull((Long)viewId) && !(viewGroupViewsByDataSetAndDimNumber = modelCacheHelper.getViewGroupViewsByDataSetAndDimNumber(Long.valueOf(this.formPlugin.getDatasetId()), dimNumber)).contains(viewId)) {
                viewId = modelCacheHelper.getViewByDataSetAndDimNumber(Long.valueOf(this.formPlugin.getDatasetId()), dimNumber);
            }
            if (IDUtils.isNotNull((Long)viewId)) {
                f7Param.setViewId(viewId);
            }
        }
        NewF7Utils.openF7((IFormView)this.formPlugin.getView(), (MemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this.formPlugin, this.key));
    }

    private void showFormSchemeSave(boolean createNew) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(createNew ? ResManager.loadKDString((String)"\u65b9\u6848\u53e6\u5b58\u4e3a", (String)"DiffAnalyzePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4fdd\u5b58\u65b9\u6848", (String)"DiffAnalyzePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        formShowParameter.setFormId("eb_diffanalyzescheme");
        DynamicObject dynamicObject = this.getSchemeEntityFromDataModel(createNew);
        DiffAnalyzeHelper.validateSchemeEntity(dynamicObject);
        if (dynamicObject != null) {
            formShowParameter.setCustomParam("schemeEntity", (Object)SerializationUtils.serializeToBase64((Object)dynamicObject));
        }
        formShowParameter.setCustomParam("createNew", (Object)createNew);
        formShowParameter.setCustomParam("modelid", (Object)this.formPlugin.getModelId());
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.formPlugin, "showFormSchemeSave"));
        this.formView.showForm(formShowParameter);
    }

    private void showFormDisplaySetting() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("modelid", (Object)this.formPlugin.getModelId());
        formShowParameter.setCustomParam("datasetid", (Object)this.formPlugin.getDatasetId());
        formShowParameter.setCustomParam("diffdisplaysettings", (Object)SerializationUtils.toJsonString(this.getDiffDisplaySettings(this.formPlugin.isEditSchemeMode())));
        formShowParameter.setFormId("eb_diffdisplaysetting");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.formPlugin, "displaysetting"));
        this.formView.showForm(formShowParameter);
    }

    private void showFormSchemeShare() {
        DynamicObject dynamicObject = (DynamicObject)this.formView.getModel().getValue("analyzescheme");
        if (dynamicObject != null) {
            String reportName = dynamicObject.getString("name");
            String datasetId = this.formPlugin.getDatasetId() + "";
            String reportId = dynamicObject.getString("id");
            String reportType = AnalyseType.MULTI_DIM.getValue();
            HashMap<String, String> cardMap = new HashMap<String, String>(4);
            cardMap.put("reportName", reportName);
            cardMap.put("datasetId", datasetId);
            cardMap.put("reportId", reportId);
            cardMap.put("reportType", reportType);
            this.formView.getPageCache().put("shareCache", SerializationUtils.toJsonString(cardMap));
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"bos_user", (boolean)true);
            ListFilterParameter listFilterParameter = listShowParameter.getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(new QFilter("id", "!=", (Object)UserUtils.getUserId()));
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.formPlugin, "share"));
            this.formView.showForm((FormShowParameter)listShowParameter);
        }
    }

    private DynamicObject getSchemeEntityFromDataModel(boolean createNew) {
        IDataModel dataModel = this.formView.getModel();
        DynamicObjectCollection cols = dataModel.getEntryEntity("entryentity");
        DynamicObject ob = dataModel.getDataEntity();
        DynamicObject dynamicObject = null;
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        HashMap<String, String> oldAndNewIds = new HashMap<String, String>(16);
        if (createNew) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_diffanalyzescheme");
            long id = DBServiceHelper.genGlobalLongId();
            dynamicObject.set("id", (Object)id);
            long[] ids = DBServiceHelper.genLongIds((String)"t_eb_analyzeschemecols", (int)cols.size());
            for (int i = 0; i < cols.size(); ++i) {
                oldAndNewIds.put(((DynamicObject)cols.get(i)).getString("id"), String.valueOf(ids[i]));
                ((DynamicObject)cols.get(i)).set("id", (Object)ids[i]);
            }
            for (DynamicObject col : cols) {
                if (DataRowEnum.CUSTOM.getIndex() != col.getInt("col_type")) continue;
                String expr = col.getString("col_expr");
                if (StringUtils.isNotEmpty((String)expr)) {
                    for (Map.Entry entry : oldAndNewIds.entrySet()) {
                        expr = expr.replaceAll((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                col.set("col_expr", (Object)expr);
            }
            dynamicObject.set("number", (Object)("S-" + id));
            dynamicObject.set("creator", (Object)userId);
            dynamicObject.set("createtime", (Object)now);
            dynamicObject.set("model", (Object)ob.getString("model.id"));
            dynamicObject.set("dataset", (Object)ob.getString("dataset.id"));
            if (dataModel.getValue("analyzescheme") != null) {
                dynamicObject.set("type", (Object)((DynamicObject)dataModel.getValue("analyzescheme")).getString("type"));
            }
        } else {
            DynamicObject analyzescheme = (DynamicObject)this.formView.getModel().getValue("analyzescheme");
            if (analyzescheme == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u6790\u65b9\u6848\u3002", (String)"DiffAnalyzePlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)analyzescheme.getLong("id"), (String)"eb_diffanalyzescheme");
        }
        dynamicObject.set("modifier", (Object)userId);
        dynamicObject.set("modifytime", (Object)now);
        dynamicObject.set("configjson", (Object)DiffAnalyzeHelper.getSchemeConfigJson(this.formPlugin));
        DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
        entryentity.clear();
        for (DynamicObject col : cols) {
            DynamicObject entry = entryentity.addNew();
            Object entryId = col.get("id");
            entry.set("id", entryId);
            entry.set("seq", col.get("seq"));
            entry.set("coltype", col.get("col_type"));
            entry.set("colname", col.get("col_name"));
            entry.set("colconfigjson", (Object)this.getColConfigJson(col, oldAndNewIds));
        }
        return dynamicObject;
    }

    private String getColConfigJson(DynamicObject col, Map<String, String> oldAndNewIds) {
        if (col == null) {
            return null;
        }
        HashMap<String, String> configMap = new HashMap<String, String>(16);
        Set<String> schemeDims = this.formPlugin.getSchemeDims();
        Map<String, String> dimCtrlKeyMap = this.formPlugin.getDimCtrlKeyMap();
        Map<String, Long> entryDimemsionViews = this.formPlugin.getEntryDimensionViews();
        if (DataRowEnum.DATA.getIndex() == col.getInt("col_type")) {
            for (String key : DiffAnalyzePlugin.getF7KeysCard()) {
                String memNumber;
                String dimNumber = dimCtrlKeyMap.get(key.replaceAll("col_", ""));
                DynamicObject dynamicObject = col.getDynamicObject(key);
                if (dynamicObject != null && (memNumber = dynamicObject.getString("number")) != null) {
                    Long viewId;
                    configMap.put(dimNumber, memNumber);
                    String colId = col.getString("id");
                    if (oldAndNewIds != null) {
                        for (Map.Entry<String, String> entry : oldAndNewIds.entrySet()) {
                            if (!entry.getValue().equals(colId)) continue;
                            colId = entry.getKey();
                            break;
                        }
                    }
                    if (entryDimemsionViews == null || (viewId = entryDimemsionViews.get(dimNumber + "_" + colId)) == null) continue;
                    configMap.put("_DIMVIEW_" + dimNumber, String.valueOf(viewId));
                    continue;
                }
                if (schemeDims == null || !schemeDims.contains(dimNumber)) continue;
                configMap.put(dimNumber, "_SECOND_PAGE");
            }
            if (!StringUtils.isEmpty((String)col.getString("col_periodoffset"))) {
                configMap.put("_PERIOD_OFFSET", col.getString("col_periodoffset").trim().toUpperCase());
            }
        } else if (DataRowEnum.CUSTOM.getIndex() == col.getInt("col_type")) {
            configMap.put("_EXPRESSION", col.getString("col_expr"));
            configMap.put("_EXPRESSION_DISP", col.getString("col_exprdisplay"));
            configMap.put("_DISP_FORMAT", col.getString("col_fm"));
        }
        return SerializationUtils.toJsonString(configMap);
    }

    private void showFormEditExpr() {
        int[] selectRows;
        EntryGrid entryGrid;
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        Map<String, String> colIndexNameMap = this.formPlugin.getColIndexNameMap();
        if (colIndexNameMap != null) {
            formShowParameter.setCustomParam("colIndexNameMap", (Object)SerializationUtils.toJsonString(colIndexNameMap));
        }
        if ((entryGrid = (EntryGrid)this.formView.getControl("entryentity")) != null && (selectRows = entryGrid.getSelectRows()) != null && selectRows.length > 0) {
            String expr = (String)this.formView.getModel().getValue("col_expr", selectRows[0]);
            String fm = (String)this.formView.getModel().getValue("col_fm", selectRows[0]);
            formShowParameter.setCustomParam("expr", (Object)expr);
            formShowParameter.setCustomParam("fm", (Object)fm);
            this.formView.getPageCache().put("expr_row", selectRows[0] + "");
        }
        formShowParameter.setFormId("eb_diffeditexpr");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.formPlugin, "showFormEditExpr"));
        this.formView.showForm(formShowParameter);
    }

    @Override
    public boolean isCacheSMAfterExecute() {
        return false;
    }
}

