/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.analyze.command;

import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.epm.eb.business.userremember.entity.UserRememberEntity;
import kd.epm.eb.business.userremember.service.UserRememberService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.permission.IMemberPermCache;
import kd.epm.eb.common.permission.MemberPermCacheServiceHelper;
import kd.epm.eb.common.spread.util.GZIPUtils;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.EntityUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.formplugin.analyze.DiffAnalyzeHelper;
import kd.epm.eb.formplugin.analyze.IDiffAnalyzePlugin;
import kd.epm.eb.formplugin.analyze.command.DiffAnalyzeCommand;
import kd.epm.eb.formplugin.analyze.command.RefreshCellDataCommand;
import kd.epm.eb.spread.analyze.DiffAnalyzeScheme;
import kd.epm.eb.spread.command.rangedefined.SheetFrozenInfo;
import kd.epm.eb.spread.control.SpreadContainer;
import kd.epm.eb.spread.template.spreadmanager.DiffCellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IDiffAnalyzeSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;

public class SwitchColDimensionCommand
extends DiffAnalyzeCommand {
    private String dimNumber;
    private String memNumber;
    private int range;
    private IDiffAnalyzeSpreadManager spreadManager = null;
    private IModelCacheHelper modelCacheHelper = null;
    private IMemberPermCache memberPerm = null;
    private SpreadContainer spreadContainer = null;
    private static final Log log = LogFactory.getLog(SwitchColDimensionCommand.class);

    public SwitchColDimensionCommand(String dimNumber, String memNumber, int range, IDiffAnalyzeSpreadManager spreadManager) {
        this.dimNumber = dimNumber;
        this.memNumber = memNumber;
        this.range = range;
        this.spreadManager = spreadManager;
    }

    @Override
    protected void beforeExecute(IDiffAnalyzePlugin formPlugin) {
        super.beforeExecute(formPlugin);
        if (this.modelCacheHelper == null && this.spreadManager != null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.spreadManager.getModelid());
        }
        if (this.memberPerm == null && this.modelCacheHelper != null && this.spreadManager != null) {
            this.memberPerm = MemberPermCacheServiceHelper.build(null, (Long)this.spreadManager.getModelid(), (Long)this.modelCacheHelper.getBusModelByDataSet(this.spreadManager.getDatasetid()), null);
        }
        if (this.spreadContainer == null) {
            this.spreadContainer = new SpreadContainer(this.formView, formPlugin.getSpreadKey());
        }
        if (this.spreadManager != null) {
            this.spreadManager.setModelCacheHelper(this.modelCacheHelper);
            this.spreadManager.setMemberPerm(this.memberPerm);
        }
    }

    @Override
    protected void doExecute(IDiffAnalyzePlugin formPlugin) {
        kd.epm.eb.common.model.Dimension colDimension = this.spreadManager.getColDimension();
        List commonDimension = this.spreadManager.getCommonDimension();
        List rowCellDimMembers = this.spreadManager.getRowCellDimMembers();
        List colCellDimMembers = this.spreadManager.getColCellDimMembers();
        ISheet sheet = this.spreadManager.getEbook().getSheet(0);
        DiffAnalyzeScheme schemeConfig = formPlugin.getSchemeConfig();
        HashMap<String, String> configMap = new HashMap(8);
        if (schemeConfig != null && StringUtils.isNotEmpty((String)schemeConfig.getConfigJson())) {
            configMap = (Map)SerializationUtils.fromJsonString((String)schemeConfig.getConfigJson(), Map.class);
        }
        if (this.dimNumber == null || this.memNumber == null || colDimension == null || commonDimension == null) {
            return;
        }
        if (colDimension == null || this.dimNumber.equals(colDimension.getNumber())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u4e0e\u5207\u6362\u7ef4\u5ea6\u76f8\u540c\u3002", (String)"DiffAnalyzeSpreadManager_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (rowCellDimMembers != null) {
            for (DiffCellDimMember cellDimMember : rowCellDimMembers) {
                if (cellDimMember == null || !cellDimMember.getDimNumber().equals(this.dimNumber)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u7ef4\u5ea6\u5df2\u94bb\u53d6\u8fc7\u884c\u3002", (String)"DiffAnalyzeSpreadManager_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        String originColDimNumber = colDimension.getNumber();
        String originColDimMember = null;
        kd.epm.eb.common.model.Dimension originColDimension = kd.epm.eb.common.model.Dimension.loadFormCache((Dimension)this.getModelCacheHelper().getDimension(originColDimNumber));
        kd.epm.eb.common.model.Dimension newColDimension = null;
        Long viewId = this.getSpreadManager().getDimemsionViews().getOrDefault(originColDimNumber, 0L);
        if (colCellDimMembers != null && colCellDimMembers.size() > 0) {
            String value;
            UserRememberEntity userRemember = UserRememberService.getInstance().getUserRemember(formPlugin.getUserRememberKey(), formPlugin.getKeyGroup());
            Map userRememberMap = new HashMap(16);
            if (userRemember != null && StringUtils.isNotEmpty((String)(value = userRemember.getValue()))) {
                userRememberMap = (Map)JSONUtils.parse((String)value, Map.class);
            }
            String number = (String)userRememberMap.get(originColDimension.getNumber());
            List collect = colCellDimMembers.stream().filter(e -> e != null && !this.getMemberPerm().isNoperm(e.getDimNumber(), e.getMemNumber(), viewId)).collect(Collectors.toList());
            if (StringUtils.isNotEmpty((String)number)) {
                Optional<DiffCellDimMember> first = collect.stream().filter(e -> e != null && e.getMemNumber().equals(number)).findFirst();
                if (first.isPresent()) {
                    originColDimMember = first.get().getMemNumber();
                }
            } else if (CollectionUtils.isNotEmpty(collect)) {
                originColDimMember = ((DiffCellDimMember)collect.get(0)).getMemNumber();
            }
            originColDimension.add(Member.loadFormCache((kd.epm.eb.common.cache.impl.Member)this.getModelCacheHelper().getMember(originColDimNumber, viewId, originColDimMember)));
        }
        if (originColDimension.getMembers().isEmpty()) {
            originColDimension.add(Member.loadFormCache((kd.epm.eb.common.cache.impl.Member)this.getModelCacheHelper().getMember(originColDimNumber, viewId, originColDimNumber)));
        }
        for (kd.epm.eb.common.model.Dimension dimension : commonDimension) {
            if (!this.dimNumber.equals(dimension.getNumber())) continue;
            newColDimension = dimension;
            break;
        }
        if (newColDimension == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u9875\u9762\u7ef4\u4e2d\u672a\u627e\u5230\u7ef4\u5ea6%1\u3002", (String)"DiffAnalyzeSpreadManager_2", (String)"epm-eb-formplugin", (Object[])new Object[]{this.dimNumber}));
        }
        commonDimension.remove(newColDimension);
        commonDimension.add(originColDimension);
        if (originColDimension.getMembers().size() > 0) {
            Object member = (Member)originColDimension.getMembers().get(0);
            this.formView.setVisible(Boolean.valueOf(false), new String[]{formPlugin.getF7KeyDimMap().get(newColDimension.getNumber())});
            this.formView.setVisible(Boolean.valueOf(true), new String[]{formPlugin.getF7KeyDimMap().get(originColDimension.getNumber())});
            String ctrlKey = formPlugin.getF7KeyDimMap().get(originColDimension.getNumber());
            if (SysDimensionEnum.Entity.getNumber().equals(originColDimension.getNumber()) && SysDimensionEnum.Entity.getNumber().equals(member.getNumber())) {
                member = originColDimension.getMembers().size() > 1 ? (Member)originColDimension.getMembers().get(1) : null;
            }
            EntityUtils.setDataWithOutPropertychanged((IDataModel)this.formView.getModel(), (String)ctrlKey, (Object)(member == null ? null : member.getId()));
            this.formView.updateView(ctrlKey);
        }
        colDimension = newColDimension;
        this.spreadManager.setColDimension(colDimension);
        List<Member> members = null;
        List<Object> cacheMembers = DiffAnalyzeHelper.getMember(formPlugin.getDatasetId(), this.getModelCacheHelper(), this.getMemberPerm(), this.dimNumber, (Long)this.spreadManager.getDimemsionViews().get(this.dimNumber), this.memNumber, this.range);
        if (cacheMembers != null) {
            if (SysDimensionEnum.Metric.getNumber().equals(this.dimNumber)) {
                cacheMembers = cacheMembers.stream().filter(e -> MetricDataTypeEnum.CURRENCY.getIndex().equals(e.getDatatype()) || MetricDataTypeEnum.NONMONETARY.getIndex().equals(e.getDatatype())).collect(Collectors.toList());
            }
            members = DiffAnalyzeHelper.fromCacheMembers(cacheMembers);
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(this.dimNumber)) {
                members = DiffAnalyzeHelper.defaultCurrentNextYear(members);
            }
            int maxCol = sheet.getRealMaxCols();
            ArrayList<Integer> indexes = new ArrayList<Integer>(16);
            for (int i = maxCol - 1; i > 0; --i) {
                sheet.delColumn(i);
                indexes.add(i);
            }
            this.getSpreadContainer().deleteRowCol(null, indexes);
            if (members != null && !members.isEmpty()) {
                colDimension.clearMember();
                for (Member m : members) {
                    colDimension.add(m);
                }
            } else {
                if (this.memNumber.equals(this.dimNumber) && this.range == RangeEnum.DIRECTSUB_EXCLUDE.getIndex()) {
                    cacheMembers = DiffAnalyzeHelper.getMember(formPlugin.getDatasetId(), this.getModelCacheHelper(), this.getMemberPerm(), this.dimNumber, (Long)this.spreadManager.getDimemsionViews().get(this.dimNumber), this.memNumber, RangeEnum.ALL_EXCLUDE.getIndex());
                }
                if (cacheMembers.isEmpty()) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7684\u7ef4\u5ea6\u65e0\u6709\u6548\u6210\u5458\u3002", (String)"DiffAnalyzePlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[]{this.dimNumber}));
                }
                members = DiffAnalyzeHelper.fromCacheMembers(cacheMembers);
            }
            this.formView.setVisible(Boolean.valueOf(false), new String[]{formPlugin.getF7KeyDimMapMul().get(originColDimension.getNumber())});
            this.formView.setVisible(Boolean.valueOf(true), new String[]{formPlugin.getF7KeyDimMapMul().get(colDimension.getNumber())});
            this.spreadManager.setDiffAnalyzeScheme(formPlugin.refreshMetas(formPlugin.getSchemeConfig()));
            this.spreadManager.buildReportColPartition();
            new RefreshCellDataCommand(formPlugin).removeRefreshRows();
            try {
                String spreadjson = this.spreadManager.getEbook().toJsonWithRealRowCol();
                byte[] bb = Base64.getEncoder().encode(GZIPUtils.compress((String)spreadjson));
                this.spreadContainer.rebuildSpread("base64" + new String(bb));
                this.spreadContainer.frozenSheet(new SheetFrozenInfo(Integer.valueOf(this.spreadManager.getColDimension() == null ? 1 : 2), null, Integer.valueOf(1), null));
                this.spreadContainer.lockSheets(Collections.singletonList(this.spreadManager.getEbook().getSheet(0).getSheetName()));
                this.spreadContainer.setColumnsWidth(Collections.singletonList(0), 200);
                this.spreadContainer.closeToolbar();
                DiffAnalyzeHelper.refreshGroupNodeType(this.spreadContainer, this.spreadManager);
            }
            catch (Exception e2) {
                log.error((Throwable)e2);
                throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DiffAnalyzePlugin_47", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            formPlugin.setMultiSelectMembers(colDimension.getNumber(), formPlugin.getMembers(configMap, this.dimNumber, members));
        }
    }

    public IDiffAnalyzeSpreadManager getSpreadManager() {
        return this.spreadManager;
    }

    public SwitchColDimensionCommand setSpreadManager(IDiffAnalyzeSpreadManager spreadManager) {
        this.spreadManager = spreadManager;
        return this;
    }

    public IModelCacheHelper getModelCacheHelper() {
        return this.modelCacheHelper;
    }

    public SwitchColDimensionCommand setModelCacheHelper(IModelCacheHelper modelCacheHelper) {
        this.modelCacheHelper = modelCacheHelper;
        return this;
    }

    public IMemberPermCache getMemberPerm() {
        return this.memberPerm;
    }

    public SwitchColDimensionCommand setMemberPerm(IMemberPermCache memberPerm) {
        this.memberPerm = memberPerm;
        return this;
    }

    public SpreadContainer getSpreadContainer() {
        return this.spreadContainer;
    }

    public SwitchColDimensionCommand setSpreadContainer(SpreadContainer spreadContainer) {
        this.spreadContainer = spreadContainer;
        return this;
    }
}

