/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.api;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.JSONUtils;
import kd.epm.eb.business.servicehelper.EbBatchSave;
import kd.epm.eb.business.servicehelper.EbOlapServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BgData;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.control.BgControlCallerImpl;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.control.face.IControlParam;
import kd.epm.eb.control.impl.model.BudgetBalance;
import kd.epm.eb.control.impl.model.ControlParam;

public class AdjustApi
implements IBillWebApiPlugin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult result = null;
        if (params == null || params.size() == 0) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u5165\u5b57\u6bb5\u4e3a\u7a7a", (String)"AdjustApi_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        long id = (Long)params.get("id");
        String billType = (String)params.get("billType");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)billType);
        Map dimMember = (Map)params.get("dimmember");
        this.checkAdjustFiled(dimMember);
        Collection<IControlParam> iControlParams = this.queryOlapData(dynamicObject, dimMember);
        BizModel model = ((IBudgetBalance)iControlParams.toArray()[0]).getBizModel();
        HashMap<String, Map<String, Member>> numberAndDimMemberId = new HashMap<String, Map<String, Member>>(16);
        LinkedList<Dimension> defDimension = new LinkedList<Dimension>();
        Map<String, Map<String, String>> adjustMap = this.getAdjustMap(iControlParams, model, dimMember, numberAndDimMemberId, defDimension);
        DLock lock = DLock.create((String)"eb/AdjustIAdjustExternal");
        try {
            if (!lock.tryLock(5000L)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u9879\u76ee\u4e91\u8c03\u5242\u7533\u8bf7\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u5b58\u5728\u540c\u65f6\u521b\u5efa\u3002", (String)"AdjustApi_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            Collection<IBudgetBalance> newBalances = this.getNewBalances(adjustMap, model);
            this.putBudgetToAdjustList(adjustMap, newBalances);
            this.checkBalance(adjustMap);
            this.removeAdjustIdZeroValue(adjustMap);
            this.createAdjustBillByAdjustMap(adjustMap, dynamicObject, numberAndDimMemberId, model, defDimension);
            List<Map<String, String>> adjustList = this.removeMapOtherDataAndGetList(adjustMap);
            this.saveOlapData(adjustList, model.getId(), model.getCubeNumber());
            String returnData = this.getReturnData(adjustList);
            result = ApiResult.success((Object)returnData);
        }
        catch (Exception ex) {
            ApiResult apiResult;
            try {
                apiResult = ApiResult.ex((Throwable)ex);
            }
            catch (Throwable throwable) {
                try {
                    lock.unlock();
                    throw throwable;
                }
                catch (Exception ex2) {
                    result = ApiResult.ex((Throwable)ex2);
                }
            }
            lock.unlock();
            return apiResult;
        }
        lock.unlock();
        return result;
    }

    private void checkAdjustFiled(Map<String, Object> dimMember) {
        if (dimMember == null || dimMember.size() == 0 || dimMember.get("filed") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684map\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"AdjustApi_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private Collection<IControlParam> queryOlapData(DynamicObject dynamicObject, Map<String, Object> dimMember) {
        try {
            ArrayList<Map> tmpColls = new ArrayList<Map>(16);
            BgControlCallerImpl bgControlCaller = new BgControlCallerImpl();
            Set<String> applyValue = this.getApplyValue(dimMember);
            Collection iBudgetBalances = bgControlCaller.queryDimensionMemberBySetFiled(dynamicObject, applyValue);
            for (IBudgetBalance balance : iBudgetBalances) {
                tmpColls.add(balance.toMap());
            }
            return iBudgetBalances;
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private Set<String> getApplyValue(Map<String, Object> dimMember) {
        HashSet<String> applyFiled = new HashSet<String>(16);
        applyFiled.add(dimMember.get("filed").toString());
        return applyFiled;
    }

    private Map<String, Map<String, String>> getAdjustMap(Collection<IControlParam> iControlParams, BizModel model, Map<String, Object> dimMember, Map<String, Map<String, Member>> numberAndDimMemberId, LinkedList<Dimension> defDimension) {
        try {
            HashMap<String, Map<String, String>> dimMap = new HashMap<String, Map<String, String>>(16);
            List<Dimension> dimensions = this.getDimension(model, defDimension);
            Map<String, String> defNumber = this.getDefNumber(defDimension);
            this.queryAllDimMembers(dimensions, true, numberAndDimMemberId);
            for (IControlParam iControlParam : iControlParams) {
                StringBuilder budgetKey = new StringBuilder(model.getId().toString());
                Map budget_member = (Map)((BudgetBalance)iControlParam).get("BUDGET_MEMBER");
                HashMap<String, String> memberMap = new HashMap<String, String>(16);
                memberMap.put("adjust", iControlParam.getPropValueMap().get(dimMember.get("filed").toString()).toString());
                for (Map.Entry mapEntry : budget_member.entrySet()) {
                    String dimNumber = (String)mapEntry.getKey();
                    String memNumber = ((Member)mapEntry.getValue()).getNumber();
                    Map<String, Member> leafMem = numberAndDimMemberId.get(dimNumber);
                    memberMap.put(dimNumber, memNumber);
                    if (defNumber.containsKey(dimNumber)) {
                        if (!leafMem.containsKey(memNumber)) {
                            Member member = leafMem.get(memNumber);
                            memNumber = member != null ? member.getDimension().getShortNumber() + "None" : defNumber.get(dimNumber);
                            memberMap.put(dimNumber, memNumber);
                        }
                    } else {
                        if (!leafMem.containsKey(memNumber) && !dimNumber.equals(SysDimensionEnum.AuditTrail.getNumber())) {
                            throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u4e0d\u5b58\u5728\u6216\u7ef4\u5ea6\u6210\u5458\u4e0d\u662f\u660e\u7ec6\u8282\u70b9%2\u3002", (String)"AdjustApi_3", (String)"epm-eb-formplugin", (Object[])new Object[]{dimNumber, memNumber}));
                        }
                        if (((String)mapEntry.getKey()).equals(SysDimensionEnum.AuditTrail.getNumber())) {
                            memNumber = "EntityInput";
                            memberMap.put((String)mapEntry.getKey(), memNumber);
                        }
                    }
                    budgetKey.append("!").append(dimNumber).append("_").append(memNumber);
                }
                String budget = budgetKey.toString();
                if (dimMap.containsKey(budget)) {
                    Map map = (Map)dimMap.get(budget);
                    String adjust_old = (String)map.get("adjust");
                    String adjust = (String)memberMap.get("adjust");
                    BigDecimal bigDecimal = new BigDecimal(adjust);
                    BigDecimal bigDecimal_old = new BigDecimal(adjust_old);
                    bigDecimal = bigDecimal.add(bigDecimal_old);
                    memberMap.put("adjust", bigDecimal.toPlainString());
                }
                dimMap.put(budget, memberMap);
            }
            return dimMap;
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    private List<Dimension> getDimension(BizModel model, List<Dimension> defDimension) {
        ArrayList<Dimension> dimensionList = new ArrayList<Dimension>();
        String selectFiled = "id,name,number,shortnumber,membermodel,fieldmapped,issysdimension,dseq";
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("model", "=", (Object)model.getId()));
        DataSet result = QueryServiceHelper.queryDataSet((String)"EPM", (String)"epm_dimension", (String)selectFiled, (QFilter[])qfBuilder.toArrays(), (String)"dseq");
        if (!result.isEmpty()) {
            for (Row row : result) {
                Dimension dimension = new Dimension();
                dimension.setId(row.getLong("id"));
                dimension.setNumber(row.getString("number"));
                dimension.setName(row.getString("name"));
                dimension.setShortNumber(row.getString("shortnumber"));
                dimension.setSeq(row.getInteger("dseq").intValue());
                dimension.setPreset(row.getBoolean("issysdimension").booleanValue());
                dimension.setMemberModel(row.getString("membermodel"));
                if (!dimension.isPreset()) {
                    defDimension.add(dimension);
                }
                dimensionList.add(dimension);
            }
        }
        return dimensionList;
    }

    private Map<String, String> getDefNumber(LinkedList<Dimension> defDimension) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        for (Dimension dimension : defDimension) {
            map.put(dimension.getNumber(), dimension.getShortNumber() + "None");
        }
        return map;
    }

    private void queryAllDimMembers(List<Dimension> dimensions, boolean isLeaf, Map<String, Map<String, Member>> numberAndDimMemberId) {
        for (Dimension dimension : dimensions) {
            String selectFiled = "id,name,number,parent.number,parent.id,parent.name,isleaf";
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("dimension", "=", (Object)dimension.getId());
            if (isLeaf) {
                qfBuilder.add("isleaf", "=", (Object)true);
            }
            DataSet result = QueryServiceHelper.queryDataSet((String)"epm", (String)dimension.getMemberModel(), (String)selectFiled, (QFilter[])qfBuilder.toArrays(), (String)"level");
            Iterator rows = result.iterator();
            HashMap<String, Member> map = new HashMap<String, Member>(16);
            while (rows.hasNext()) {
                Row memberRow = (Row)rows.next();
                Member member = new Member(memberRow.getLong("id"), memberRow.getString("name"), memberRow.getString("number"));
                member.setLeaf(memberRow.getBoolean("isleaf").booleanValue());
                map.put(memberRow.getString("number"), member);
            }
            numberAndDimMemberId.put(dimension.getNumber(), map);
        }
    }

    private Collection<IBudgetBalance> getNewBalances(Map<String, Map<String, String>> dimMap, BizModel model) {
        ArrayList<String> types = new ArrayList<String>();
        ArrayList adjustList = new ArrayList(16);
        for (Map.Entry<String, Map<String, String>> mapEntry : dimMap.entrySet()) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.putAll(mapEntry.getValue());
            map.remove("adjust");
            adjustList.add(map);
        }
        BgControlCallerImpl bgControlCaller = new BgControlCallerImpl();
        types.add(BgControlSettingTypeEnum.MONTH.getNumber());
        return bgControlCaller.queryBalance(model.getId(), adjustList, types, false);
    }

    private void putBudgetToAdjustList(Map<String, Map<String, String>> adjustMap, Collection<IBudgetBalance> newBalances) {
        for (IBudgetBalance iBudgetBalance : newBalances) {
            Map budget_member = (Map)((ControlParam)iBudgetBalance).get("BUDGET_MEMBER");
            for (Map.Entry<String, Map<String, String>> mapEntry : adjustMap.entrySet()) {
                boolean isExit = true;
                String key = mapEntry.getKey();
                for (Map.Entry map : budget_member.entrySet()) {
                    Member member = (Member)map.getValue();
                    if (member == null) {
                        isExit = false;
                        break;
                    }
                    if (key.contains(member.getNumber())) continue;
                    isExit = false;
                    break;
                }
                if (!isExit) continue;
                BigDecimal budget = iBudgetBalance.getBudget();
                if (budget == null) {
                    mapEntry.getValue().put("budget", BigDecimal.ZERO.toPlainString());
                } else {
                    mapEntry.getValue().put("budget", budget.toPlainString());
                }
                BigDecimal balane = iBudgetBalance.getBalance();
                if (balane == null) {
                    mapEntry.getValue().put("balance", BigDecimal.ZERO.toPlainString());
                    continue;
                }
                mapEntry.getValue().put("balance", balane.toPlainString());
            }
        }
    }

    private void checkBalance(Map<String, Map<String, String>> adjustMap) {
        for (Map.Entry<String, Map<String, String>> mapEntry : adjustMap.entrySet()) {
            Map<String, String> value = mapEntry.getValue();
            String adjust = value.get("adjust");
            String balance = value.get("balance");
            String budget = value.get("budget");
            BigDecimal bigDecimal_adjust = new BigDecimal(adjust);
            BigDecimal bigDecimal_balance = new BigDecimal(balance);
            BigDecimal bigDecimal_budget = new BigDecimal(budget);
            if (bigDecimal_adjust.compareTo(BigDecimal.ZERO) < 0 && bigDecimal_balance.add(bigDecimal_adjust).compareTo(BigDecimal.ZERO) < 0) {
                throw new KDBizException(ResManager.loadResFormat((String)"%1\u7684\u9884\u7b97\u4f59\u989d\u4e0d\u8db3\u3002", (String)"AdjustApi_5", (String)"epm-eb-formplugin", (Object[])new Object[]{mapEntry.getKey()}));
            }
            value.put("finaladjust", bigDecimal_budget.add(bigDecimal_adjust).toPlainString());
        }
    }

    private void removeAdjustIdZeroValue(Map<String, Map<String, String>> adjustMap) {
        ArrayList<String> removeKey = new ArrayList<String>(16);
        for (Map.Entry<String, Map<String, String>> mapEntry : adjustMap.entrySet()) {
            Map<String, String> value = mapEntry.getValue();
            String adjust = value.get("adjust");
            BigDecimal bigDecimal_adjust = new BigDecimal(adjust);
            if (bigDecimal_adjust.compareTo(BigDecimal.ZERO) != 0) continue;
            removeKey.add(mapEntry.getKey());
        }
        for (String key : removeKey) {
            adjustMap.remove(key);
        }
    }

    private void createAdjustBillByAdjustMap(Map<String, Map<String, String>> adjustMap, DynamicObject dynamicObject, Map<String, Map<String, Member>> numberAndDimMemberIdMap, BizModel model, LinkedList<Dimension> defDimension) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                String codeRuleNumber = this.getCodeRuleNumber("eb_adjustbill", null);
                Long userId = UserUtils.getUserId();
                DynamicObject adjpstbillDoc = BusinessDataServiceHelper.newDynamicObject((String)"eb_adjustbill");
                long adjpstId = GlobalIdUtil.genGlobalLongId();
                adjpstbillDoc.set("billno", (Object)codeRuleNumber);
                adjpstbillDoc.set("billstatus", (Object)"E");
                adjpstbillDoc.set("applier", (Object)userId);
                adjpstbillDoc.set("applydate", (Object)TimeServiceHelper.now());
                adjpstbillDoc.set("billtype", (Object)"1");
                String entityName = this.getEntityName(dynamicObject);
                String number = this.getBillNumber(dynamicObject);
                adjpstbillDoc.set("adjustreason", (Object)ResManager.loadResFormat((String)"%1\u8c03\u6574\u5355,\u7f16\u7801\u4e3a%2", (String)"AdjustApi_6", (String)"epm-eb-formplugin", (Object[])new Object[]{entityName, number}));
                this.setUserMessage(adjpstbillDoc, userId);
                DynamicObjectCollection multperiod = adjpstbillDoc.getDynamicObjectCollection("multperiod");
                Map<String, String> entryHand = adjustMap.get(adjustMap.keySet().toArray()[0].toString());
                adjpstbillDoc.set("model", (Object)model.getId());
                adjpstbillDoc.set("datatype", (Object)numberAndDimMemberIdMap.get(SysDimensionEnum.DataType.getNumber()).get(entryHand.get(SysDimensionEnum.DataType.getNumber())).getId());
                adjpstbillDoc.set("version", (Object)numberAndDimMemberIdMap.get(SysDimensionEnum.Version.getNumber()).get(entryHand.get(SysDimensionEnum.Version.getNumber())).getId());
                adjpstbillDoc.set("year", (Object)numberAndDimMemberIdMap.get(SysDimensionEnum.Year.getNumber()).get(entryHand.get(SysDimensionEnum.Year.getNumber())).getId());
                adjpstbillDoc.set("changetype", (Object)numberAndDimMemberIdMap.get(SysDimensionEnum.ChangeType.getNumber()).get(entryHand.get(SysDimensionEnum.ChangeType.getNumber())).getId());
                adjpstbillDoc.set("currency", (Object)numberAndDimMemberIdMap.get(SysDimensionEnum.Currency.getNumber()).get(entryHand.get(SysDimensionEnum.Currency.getNumber())).getId());
                adjpstbillDoc.set("id", (Object)adjpstId);
                ArrayList<String> isExitNumber = new ArrayList<String>(16);
                HashMap<String, String> isExitkey = new HashMap<String, String>(16);
                DynamicObjectCollection adjdetailentity = adjpstbillDoc.getDynamicObjectCollection("adjdetailentity");
                int i = 0;
                for (Map.Entry<String, Map<String, String>> map : adjustMap.entrySet()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    DynamicObject doc = adjdetailentity.addNew();
                    Map<String, String> entry = map.getValue();
                    doc.set("seq", (Object)(i + 1));
                    Member member_entity = numberAndDimMemberIdMap.get(SysDimensionEnum.Entity.getNumber()).get(entry.get(SysDimensionEnum.Entity.getNumber()));
                    Member member_account = numberAndDimMemberIdMap.get(SysDimensionEnum.Account.getNumber()).get(entry.get(SysDimensionEnum.Account.getNumber()));
                    doc.set("entity", (Object)member_entity.getId());
                    stringBuilder.append(member_entity.getNumber()).append("!");
                    doc.set("account", (Object)member_account.getId());
                    stringBuilder.append(member_account.getNumber()).append("!");
                    for (int j = 0; j < defDimension.size(); ++j) {
                        Member member_def = numberAndDimMemberIdMap.get(defDimension.get(j).getNumber()).get(entry.get(defDimension.get(j).getNumber()));
                        doc.set("customdim" + (j + 1), (Object)member_def.getId());
                        stringBuilder.append(member_def.getNumber()).append("!");
                    }
                    Member member_period = numberAndDimMemberIdMap.get(SysDimensionEnum.Period.getNumber()).get(entry.get(SysDimensionEnum.Period.getNumber()));
                    String value = (String)isExitkey.get(stringBuilder.toString());
                    if (value == null) {
                        value = i + "";
                    }
                    if (!isExitNumber.contains(member_period.getId().toString())) {
                        DynamicObject periodDoc = multperiod.addNew();
                        periodDoc.set("fbasedataid", (Object)member_period.getId());
                        doc.set("ordersign", (Object)(value + ":" + (isExitNumber.size() + 1)));
                        isExitNumber.add(member_period.getId().toString());
                    }
                    if (!isExitkey.containsKey(stringBuilder.toString())) {
                        isExitkey.put(stringBuilder.toString(), i + "");
                    }
                    doc.set("period", (Object)numberAndDimMemberIdMap.get(SysDimensionEnum.Period.getNumber()).get(entry.get(SysDimensionEnum.Period.getNumber())).getId());
                    doc.set("budgetdata", (Object)new BigDecimal(entry.get("budget")));
                    doc.set("adjustdata", (Object)entry.get("adjust"));
                    if (entry.get("adjust").equals("0")) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u6574\u6570\u4e3a\u96f6\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"AdjustApi_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    doc.set("finaldata", (Object)entry.get("finaladjust"));
                    ++i;
                }
                Object[] nones = new Object[]{adjpstbillDoc};
                BusinessDataWriter.save((IDataEntityType)adjpstbillDoc.getDynamicObjectType(), (Object[])nones);
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public String getCodeRuleNumber(String entityNumber, String property) {
        ICodeRuleService service = (ICodeRuleService)ServiceFactory.getService((String)"ICodeRuleService");
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)entityNumber);
        if (property != null) {
            dy.set(property, (Object)TimeServiceHelper.getTimeStamp());
        }
        return service.getNumber(entityNumber, dy, null);
    }

    private String getEntityName(DynamicObject dynamicObject) {
        DynamicObject entities = QueryServiceHelper.queryOne((String)"bos_formmeta", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)dynamicObject.getDataEntityType().getExtendName())});
        String name = "";
        if (entities != null && (name = entities.getString("name")) != null && !name.isEmpty()) {
            return name;
        }
        return name;
    }

    private String getBillNumber(DynamicObject dynamicObject) {
        IDataEntityProperty number_p = (IDataEntityProperty)dynamicObject.getDynamicObjectType().getProperties().get((Object)"number");
        IDataEntityProperty billNo_p = (IDataEntityProperty)dynamicObject.getDynamicObjectType().getProperties().get((Object)"billno");
        if (number_p != null) {
            return dynamicObject.getString("number");
        }
        if (billNo_p != null) {
            return dynamicObject.getString("billno");
        }
        return "";
    }

    private void setUserMessage(DynamicObject adjustBillDoc, Long userId) {
        String position;
        DynamicObject user = this.getUserMessage(userId);
        if (user == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\u3002", (String)"AdjustApi_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection companyInfos = user.getDynamicObjectCollection("entryentity");
        if (companyInfos.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7533\u8bf7\u4eba\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002", (String)"AdjustApi_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObject department = ((DynamicObject)companyInfos.get(0)).getDynamicObject("dpt");
        if (department == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u7533\u8bf7\u4eba\u90e8\u95e8\u4fe1\u606f\u5931\u8d25\u3002", (String)"AdjustApi_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Map company = OrgUnitServiceHelper.getCompanyfromOrg((Long)department.getLong("id"));
        adjustBillDoc.set("department", (Object)department.getString("id"));
        if (company != null) {
            adjustBillDoc.set("company", company.get("id"));
        }
        if ((position = ((DynamicObject)companyInfos.get(0)).getString("position")) != null) {
            adjustBillDoc.set("position", (Object)position);
        }
    }

    private DynamicObject getUserMessage(Long userId) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "=", (Object)userId);
        return BusinessDataServiceHelper.loadSingle((String)"bos_user", (String)"entryentity,entryentity.dpt,entryentity.position", (QFilter[])qfBuilder.toArrays());
    }

    private List<Map<String, String>> removeMapOtherDataAndGetList(Map<String, Map<String, String>> adjustMap) {
        ArrayList<Map<String, String>> adjustList = new ArrayList<Map<String, String>>(16);
        for (Map.Entry<String, Map<String, String>> map : adjustMap.entrySet()) {
            map.getValue().remove("budget");
            map.getValue().remove("adjust");
            map.getValue().remove("balance");
            String removeValue = map.getValue().remove("finalbudget");
            map.getValue().put(FacTabFieldDefEnum.FIELD_MONEY.getField(), removeValue);
            adjustList.add(map.getValue());
        }
        return adjustList;
    }

    public void saveOlapData(List<Map<String, String>> dimList, long modelId, String modelNumber) {
        if (dimList == null || dimList.isEmpty() || modelId == 0L || modelNumber == null) {
            return;
        }
        EbBatchSave batchSave = EbOlapServiceHelper.getBatchSave();
        IModelCacheHelper cacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensions = cacheHelper.getDimensionList();
        ArrayList<String> dimensionNums = new ArrayList<String>(dimensions.size());
        for (Dimension dimension : dimensions) {
            dimensionNums.add(dimension.getNumber());
        }
        try {
            SaveCommandInfo saveCommandInfo = new SaveCommandInfo();
            saveCommandInfo.addDimensions(cacheHelper.getModelobj().getDimensionNums());
            saveCommandInfo.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            batchSave.open(modelNumber, saveCommandInfo);
            for (Map map : dimList) {
                String value = (String)map.get(FacTabFieldDefEnum.FIELD_MONEY.getField());
                if (value == null) continue;
                BgData bgData = new BgData(Long.valueOf(modelId), map);
                try {
                    batchSave.add(dimensionNums, bgData, (Object)new BigDecimal(value));
                }
                catch (Exception ex) {
                    batchSave.add(dimensionNums, bgData, (Object)value);
                }
            }
            batchSave.flush();
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadResFormat((String)"olap\u4fdd\u5b58\u5931\u8d25\uff1a%1\u3002", (String)"AdjustApi_11", (String)"epm-eb-formplugin", (Object[])new Object[]{e.getMessage()}));
        }
        finally {
            OlapContext.clearSaveDataContext();
            batchSave.close();
        }
    }

    private String getReturnData(List<Map<String, String>> adjustList) {
        try {
            return JSONUtils.toString(adjustList);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }
}

