/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.api;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebBusiness.serviceHelper.DimensionServiceHelper;
import kd.epm.eb.olap.OlapServiceCaller;

public class DimMemberCreateApi
implements IBillWebApiPlugin {
    private Member parentMem;

    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult result = null;
        if (params == null || params.size() == 0) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u4f20\u5165\u5b57\u6bb5\u4e3a\u7a7a", (String)"DimMemberCreateApi_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        try {
            this.checkMemberMessage(params);
            BizModel bizModel = CommonUtils.getModel((String)params.get("modelNumber").toString());
            this.checkDim(params, bizModel);
            DynamicObject parentMessage = this.getParentMessage(params, bizModel);
            Map<String, Object> dimmemberMap = this.putMessageToDimmemberMap(params, bizModel);
            this.createMemByAdjust(params, dimmemberMap, bizModel, parentMessage);
            result = ApiResult.success((Object)ResManager.loadKDString((String)"\u521b\u5efa\u6210\u5458\u6210\u529f", (String)"DimMemberCreateApi_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        catch (Exception ex) {
            result = ApiResult.ex((Throwable)ex);
        }
        return result;
    }

    private void checkMemberMessage(Map<String, Object> memberMessage) {
        if (memberMessage == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684map\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"DimMemberCreateApi_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (memberMessage.get("modelNumber") != null && StringUtils.isEmpty((String)memberMessage.get("modelNumber").toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u4f53\u7cfb\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"DimMemberCreateApi_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (memberMessage.get("dimNumber") != null && StringUtils.isEmpty((String)memberMessage.get("dimNumber").toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7ef4\u5ea6\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"DimMemberCreateApi_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (memberMessage.get("dimMemNumber") != null && StringUtils.isEmpty((String)memberMessage.get("dimMemNumber").toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"DimMemberCreateApi_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (memberMessage.get("dimMemName") != null && StringUtils.isEmpty((String)memberMessage.get("dimMemName").toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7ef4\u5ea6\u6210\u5458\u540d\u79f0\u4e3a\u7a7a\u3002", (String)"DimMemberCreateApi_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkDim(Map<String, Object> memberMessage, BizModel bizModel) {
        String dimNumber;
        List allDimNumber = CommonUtils.getAllDimNumber((Long)bizModel.getId());
        if (!allDimNumber.contains(dimNumber = memberMessage.get("dimNumber").toString())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7ef4\u5ea6\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"DimMemberCreateApi_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private DynamicObject getParentMessage(Map<String, Object> memberMessage, BizModel bizModel) {
        Object parentNumber = memberMessage.get("parentNumber");
        String dimNumber = memberMessage.get("dimNumber").toString();
        Dimension dimension = bizModel.getDimension(dimNumber);
        if (parentNumber == null) {
            this.parentMem = CommonUtils.getMemberByNumber((Dimension)dimension, (long)bizModel.getId(), (String)dimNumber);
            if (this.parentMem == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u76f8\u5e94\u7684\u7ef4\u5ea6\u6210\u5458\u3002", (String)"DimMemberCreateApi_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.parentMem = CommonUtils.getMemberByNumber((Dimension)dimension, (long)bizModel.getId(), (String)parentNumber.toString());
            if (this.parentMem == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7236\u8282\u70b9\u5728\u7ef4\u5ea6\u6210\u5458\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"DimMemberCreateApi_9", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            HashSet<Long> memberIds = new HashSet<Long>(16);
            memberIds.add(this.parentMem.getId());
            OlapServiceCaller olapServiceCaller = new OlapServiceCaller();
            if (this.parentMem.isLeaf() && olapServiceCaller.existData(bizModel.getId(), dimNumber, memberIds)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7236\u8282\u70b9\u5b58\u5728\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u521b\u5efa\u4e0b\u7ea7\u3002", (String)"DimMemberCreateApi_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        }
        return this.getParentDyn(bizModel, dimension);
    }

    private DynamicObject getParentDyn(BizModel bizModel, Dimension dimension) {
        QFBuilder qf = new QFBuilder("model", "=", (Object)String.valueOf(bizModel.getId()));
        qf.add("id", "=", (Object)String.valueOf(this.parentMem.getId()));
        return BusinessDataServiceHelper.loadSingle((String)dimension.getMemberModel(), (String)"id,number,longnumber,isleaf,level", (QFilter[])qf.toArray());
    }

    private Map<String, Object> putMessageToDimmemberMap(Map<String, Object> memberMessage, BizModel bizModel) {
        HashMap<String, Object> dimmember = new HashMap<String, Object>(16);
        String dimNumber = memberMessage.get("dimNumber").toString();
        Dimension dimension = bizModel.getDimension(dimNumber);
        dimmember.put("dimId", dimension.getId());
        dimmember.put("dimNum", dimension.getNumber());
        return dimmember;
    }

    private void createMemByAdjust(Map<String, Object> memberMessage, Map<String, Object> dimmemberMap, BizModel bizModel, DynamicObject parentMessage) {
        String dimMemNumber = memberMessage.get("dimMemNumber").toString();
        String dimMemName = memberMessage.get("dimMemName").toString();
        DLock lock = DLock.create((String)"eb/AdjustcreateMemByAdjust");
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (!lock.tryLock(5000L)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6210\u5458\u7533\u8bf7\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u5b58\u5728\u540c\u65f6\u521b\u5efa\u3002", (String)"DimMemberCreateApi_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
                this.createMemberToEb(DBServiceHelper.genGlobalLongId(), dimMemNumber, dimMemName, dimmemberMap, parentMessage, bizModel);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void createMemberToEb(Long memberid, String memNum, String memName, Map<String, Object> dimmember, DynamicObject parent, BizModel model) {
        Dimension dimension = model.getDimension(dimmember.get("dimNum").toString());
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)dimension.getMemberModel());
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        object.set("modifier", (Object)userId);
        object.set("modifytime", (Object)now);
        object.set("status", (Object)"C");
        object.set("creator", (Object)userId);
        object.set("createtime", (Object)now);
        object.set("enable", (Object)"1");
        object.set("membersource", (Object)"4");
        object.set("isleaf", (Object)"1");
        object.set("aggoprt", (Object)"1");
        object.set("id", (Object)memberid);
        object.set("number", (Object)memNum);
        object.set("name", (Object)memName);
        object.set("parent", (Object)parent.getString("id"));
        object.set("model", (Object)model.getId());
        object.set("dimension", (Object)dimmember.get("dimId").toString());
        object.set("longnumber", (Object)(parent.getString("longnumber") + "!" + memNum));
        if ("epm_userdefinedmembertree".equals(dimension.getMemberModel())) {
            object.set("datatype", (Object)"0");
        }
        object.set("level", (Object)(parent.getInt("level") + 1));
        object.set("dseq", (Object)DimensionServiceHelper.getDSeq((long)parent.getLong("id"), (String)dimension.getMemberModel(), (String)"DimMemberCreateApi"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
        DynamicObject object1 = BusinessDataServiceHelper.loadSingle((Object)parent.get("id"), (String)dimension.getMemberModel());
        if (object1 != null && object1.getBoolean("isleaf")) {
            object1.set("isleaf", (Object)"0");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object1});
        }
    }
}

