/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.api;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.utils.ModelUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.control.BgControlCallerImpl;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.control.face.ICalcParameter;
import kd.epm.eb.control.face.IControlParameter;
import kd.epm.eb.control.impl.CalcMemberParameter;
import kd.epm.eb.control.impl.ControlParameter;
import kd.epm.eb.control.impl.QueryBalanceImpl;
import kd.epm.eb.control.impl.model.ControlParam;

public class QueryBudgetBalance {
    public static final String FIELDS = "id, name, number, shortnumber, dseq, fieldmapped, model.id, membermodel, issysdimension";

    public static QueryBudgetBalance getInstance() {
        return new QueryBudgetBalance();
    }

    public Map<String, BigDecimal> queryTotalBalance(Long modelId, List<Map<String, String>> members) {
        Map<String, BigDecimal> dealBalances = null;
        BizModel model = ModelUtils.getBizModel((Long)modelId);
        List<Dimension> dimensionByModel = this.getDimensionByModel(modelId, null);
        Map<String, List<String>> allDimensionMem = this.getAllDimensionMem(dimensionByModel);
        this.creatDimListAndCheckDimension(members, allDimensionMem, model.isEBByModel());
        Map<Map<String, String>, Collection<String>> collectionMapMap = this.dealSettingTypeAndDimList(members, model);
        if (collectionMapMap != null) {
            Collection<IBudgetBalance> iBudgetBalances = this.queryData(collectionMapMap, modelId);
            dealBalances = this.dealBalances(iBudgetBalances, members, model.isEBByModel());
        }
        return dealBalances;
    }

    public String queryBudgetBalance(Long modelId, List<Map<String, String>> members) {
        ArrayList<String> types = new ArrayList<String>();
        BizModel model = ModelUtils.getBizModel((Long)modelId);
        ArrayList<String> usrDefineDimensionList = new ArrayList<String>(16);
        List<Dimension> dimensionByModel = this.getDimensionByModel(modelId, usrDefineDimensionList);
        this.addNoneToUsrDefDimension(members, dimensionByModel, usrDefineDimensionList);
        Map<String, List<String>> allDimensionMem = this.getAllDimensionMem(dimensionByModel);
        this.creatDimListAndCheckDimension(members, allDimensionMem, model.isEBByModel());
        types.add(BgControlSettingTypeEnum.MONTH.getNumber());
        return this.queryBalance(modelId, members, types);
    }

    private List<Dimension> getDimensionByModel(Long modelId, List<String> usrDefineDimensionList) {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>(16);
        if (modelId == null) {
            return dimensions;
        }
        QFBuilder builder = new QFBuilder();
        builder.add(new QFilter("model", "=", (Object)modelId));
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"epm_dimension", (String)FIELDS, (QFilter[])builder.toArrays(), (String)"dseq");
        dims.forEach(dim -> {
            Dimension dimension = Dimension.loadFromDynamicobject((DynamicObject)dim);
            dimension.setModelId(modelId);
            dimensions.add(dimension);
            if (usrDefineDimensionList != null && !dim.getBoolean("issysdimension")) {
                usrDefineDimensionList.add(dim.getString("number"));
            }
        });
        return dimensions;
    }

    private void addNoneToUsrDefDimension(List<Map<String, String>> members, List<Dimension> dimensionByModel, List<String> usrDefineDimensionList) {
        for (Map<String, String> map : members) {
            for (Dimension mapEntry : dimensionByModel) {
                String dimNumber = mapEntry.getNumber();
                String value = map.get(dimNumber);
                if (value != null || !usrDefineDimensionList.contains(dimNumber)) continue;
                map.put(dimNumber, mapEntry.getShortNumber() + "None");
            }
        }
    }

    private Map<String, List<String>> getAllDimensionMem(List<Dimension> dimensionByModel) {
        HashMap<String, List<String>> dimAndMemMap = new HashMap<String, List<String>>(dimensionByModel.size());
        for (Dimension dimension : dimensionByModel) {
            DynamicObjectCollection dimensions = QueryServiceHelper.query((String)dimension.getMemberModel(), (String)"id,number", (QFilter[])new QFilter[]{new QFilter("dimension", "=", (Object)dimension.getId())});
            ArrayList<String> list = new ArrayList<String>(16);
            for (DynamicObject dynamicObject : dimensions) {
                list.add(dynamicObject.getString("number"));
            }
            dimAndMemMap.put(dimension.getNumber(), list);
        }
        return dimAndMemMap;
    }

    private void creatDimListAndCheckDimension(List<Map<String, String>> dimList, Map<String, List<String>> allDimensionMem, Boolean isFromEb) {
        for (Map<String, String> map : dimList) {
            map.put(SysDimensionEnum.AuditTrail.getNumber(), "EntityInput");
            if (isFromEb.booleanValue()) {
                map.put(SysDimensionEnum.InternalCompany.getNumber(), "ICNone");
                map.put(SysDimensionEnum.Scenario.getNumber(), "NoScenario");
            }
            for (Map.Entry<String, List<String>> mapEntry : allDimensionMem.entrySet()) {
                String value = map.get(mapEntry.getKey());
                if (value == null || mapEntry.getValue().contains(value)) continue;
                throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u4e0d\u5b58\u5728\u7ef4\u5ea6\u6210\u5458%2\u3002", (String)"QueryBudgetBalance_0", (String)"epm-eb-formplugin", (Object[])new Object[]{mapEntry.getKey(), value}));
            }
        }
    }

    private Map<Map<String, String>, Collection<String>> dealSettingTypeAndDimList(List<Map<String, String>> dimlist, BizModel model) {
        ArrayList<String> type = new ArrayList<String>();
        HashMap<Map<String, String>, Collection<String>> map = new HashMap<Map<String, String>, Collection<String>>();
        for (Map<String, String> mapDim : dimlist) {
            type.clear();
            if (!model.isEBByModel()) {
                String budgetPeriod = mapDim.get(SysDimensionEnum.BudgetPeriod.getNumber());
                if (StringUtils.isEmpty((String)budgetPeriod)) {
                    return null;
                }
                String[] budgetPeriodArr = budgetPeriod.split("\\.");
                if ((budgetPeriod = budgetPeriodArr[1]).startsWith("Q")) {
                    type.add(BgControlSettingTypeEnum.QUARTER.getNumber());
                    map.put(mapDim, type);
                    this.dealQAndHFPeriod(budgetPeriod, mapDim, map, type);
                    continue;
                }
                if (budgetPeriod.startsWith("HF")) {
                    type.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
                    map.put(mapDim, type);
                    this.dealQAndHFPeriod(budgetPeriod, mapDim, map, type);
                    continue;
                }
                if (!budgetPeriod.startsWith("M")) continue;
                type.add(BgControlSettingTypeEnum.MONTH_BY_YEAR_CURR_GROSS.getNumber());
                map.put(mapDim, type);
                continue;
            }
            String period = mapDim.get("Period");
            if (period.startsWith("Q_Q")) {
                type.add(BgControlSettingTypeEnum.QUARTER.getNumber());
                map.put(mapDim, type);
                this.dealQAndHFPeriod(period, mapDim, map, type);
                continue;
            }
            if (period.startsWith("HF_")) {
                type.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
                map.put(mapDim, type);
                this.dealQAndHFPeriod(period, mapDim, map, type);
                continue;
            }
            if (!period.startsWith("M_")) continue;
            type.add(BgControlSettingTypeEnum.MONTH_BY_YEAR_CURR_GROSS.getNumber());
            map.put(mapDim, type);
        }
        return map;
    }

    private void dealQAndHFPeriod(String period, Map<String, String> mapDim, Map<Map<String, String>, Collection<String>> map, Collection<String> type) {
        for (int q = Integer.parseInt(period.substring(period.length() - 1)); q > 1; --q) {
            HashMap<String, String> mapDim_new = new HashMap<String, String>(mapDim.size());
            mapDim_new.putAll(mapDim);
            if (period.startsWith("Q_Q")) {
                mapDim_new.put("Period", "Q_Q" + (q - 1));
            } else {
                mapDim_new.put("Period", "HF_HF" + (q - 1));
            }
            map.put(mapDim_new, type);
        }
    }

    private Collection<IBudgetBalance> queryData(Map<Map<String, String>, Collection<String>> collectionMapMap, Long modelId) {
        BgControlCallerImpl bgControlCaller = new BgControlCallerImpl();
        ArrayList<Map<String, String>> dimlist = new ArrayList<Map<String, String>>(16);
        ArrayList<IBudgetBalance> iBudgetBalances = new ArrayList<IBudgetBalance>(16);
        for (Map.Entry<Map<String, String>, Collection<String>> mapEntry : collectionMapMap.entrySet()) {
            dimlist.clear();
            dimlist.add(mapEntry.getKey());
            try {
                iBudgetBalances.addAll(bgControlCaller.queryBalance(modelId, dimlist, mapEntry.getValue(), true));
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        }
        return iBudgetBalances;
    }

    private Map<String, BigDecimal> dealBalances(Collection<IBudgetBalance> iBudgetBalances, List<Map<String, String>> dimlist, Boolean isFromEb) {
        HashMap<String, BigDecimal> balance = new HashMap<String, BigDecimal>(16);
        for (Map<String, String> mapDim : dimlist) {
            BigDecimal balances = BigDecimal.ZERO;
            String period = null;
            period = isFromEb != false ? mapDim.get("Period") : mapDim.get(SysDimensionEnum.BudgetPeriod.getNumber());
            String key = "";
            int mon = Integer.parseInt(period.substring(period.length() - 1));
            String period_new = period.substring(7);
            for (IBudgetBalance iBudgetBalance : iBudgetBalances) {
                if (period.startsWith("Q_Q") || period.startsWith("HF_") || !isFromEb.booleanValue() && (period_new.startsWith("Q") || period_new.startsWith("HF"))) {
                    String period_m = iBudgetBalance.getPeriod(false).getNumber();
                    int mon_new = Integer.parseInt(period_m.substring(period_m.length() - 1));
                    if (!iBudgetBalance.getPeriod(false).getNumber().equals(period) && mon_new < mon) {
                        balances = balances.add(iBudgetBalance.getBalance());
                    }
                    if (iBudgetBalance.getPeriod(false).getNumber().equals(period)) {
                        balances = balances.add(iBudgetBalance.getBalance());
                        key = ((ControlParam)iBudgetBalance).getMemberKeyByBudget(true);
                    }
                    if (key.isEmpty()) continue;
                    balance.put(key, balances);
                    continue;
                }
                key = ((ControlParam)iBudgetBalance).getMemberKeyByBudget(true);
                balance.put(key, iBudgetBalance.getBalance());
            }
        }
        return balance;
    }

    private String queryBalance(Long modelId, List<Map<String, String>> members, Collection<String> types) {
        String jsonStr;
        if (modelId == 0L || members == null || members.isEmpty()) {
            return null;
        }
        ControlParameter parameter = new ControlParameter();
        parameter.setCalcParameter((ICalcParameter)new CalcMemberParameter(modelId, members, types));
        Collection balances = new QueryBalanceImpl((IControlParameter)parameter).queryMemberBalance();
        try {
            ArrayList<Map> tmpColls = new ArrayList<Map>(balances.size());
            for (IBudgetBalance balance : balances) {
                tmpColls.add(balance.toMap());
            }
            jsonStr = JSONUtils.toString(tmpColls);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        return jsonStr;
    }
}

