/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.apphome;

import java.util.EventObject;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.DimensionView.ViewMemberUpgradeService;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.apphome.ModelDetailsViewEditPlugin;
import kd.epm.eb.formplugin.utils.PluginUtils;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.utils.ModelUtil;
import kd.epm.eb.model.utils.UserSelectUtil;

public class BGMDHomePlugin
extends ModelDetailsViewEditPlugin
implements BeforeF7SelectListener {
    private static final String MODEL_KEY = "model";

    @Override
    public void afterCreateNewData(EventObject e) {
        ViewMemberUpgradeService.viewMemberUpgradeByAuto((IFormView)this.getView());
        this.initBgmdHome();
        super.afterCreateNewData(e);
        this.resetAppPageId();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit dataEdit = (BasedataEdit)this.getControl(MODEL_KEY);
        if (dataEdit != null) {
            dataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (this.isBgmd()) {
            if ("template".equals(source.getKey())) {
                Object obj = this.getModel().getValue(MODEL_KEY);
                if (obj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"BGMDHomePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                super.click(evt);
            } else {
                Object obj = this.getModel().getValue(MODEL_KEY);
                if (obj == null || "0".equals(this.getPageCache().get("KEY_MODEL_ID"))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"BGMDHomePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                } else {
                    super.click(evt);
                }
            }
        } else {
            super.click(evt);
        }
    }

    private void initBgmdHome() {
        this.getView().setVisible(aFalse, new String[]{"flexpanelap122"});
        long modelId = this.getModelIdFromCustomParam();
        if (this.isBgmd()) {
            Set<Long> userPerModelSet = this.userPerModelSet();
            if (userPerModelSet.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u65b0\u5efa\u4f53\u7cfb\u3002", (String)"BGMDHomePlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.setCustomModelParamValue(0L);
                this.getView().setVisible(aFalse, new String[]{"ldsum", "labeld", "dsum", "labelap42", "msum", "labelap421"});
            } else {
                this.getView().setVisible(aFalse, new String[]{"imaged111", "labeld111", "imaged11", "labeld11"});
                DynamicObject historyModel = this.userHistoryModel();
                if (historyModel != null) {
                    modelId = historyModel.getLong("id");
                    if (!userPerModelSet.contains(modelId)) {
                        modelId = userPerModelSet.iterator().next();
                        historyModel = BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"epm_model", (String)"id,number,shownumber,name");
                    }
                    this.setCustomModelParamValue(modelId);
                    this.getModel().setValue(MODEL_KEY, (Object)historyModel);
                    Label label = (Label)this.getControl("model_name");
                    if (label != null) {
                        label.setText(historyModel.getString("name"));
                    }
                } else if (modelId == 0L) {
                    this.setCustomModelParamValue(0L);
                    this.getView().setVisible(aFalse, new String[]{"ldsum"});
                    this.getView().setVisible(aFalse, new String[]{"labeld"});
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb", (String)"BGMDHomePlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private boolean isBgmd() {
        ApplicationTypeEnum applicationTypeEnum = ModelUtil.queryApp((IFormView)this.getView());
        return ApplicationTypeEnum.BGMD == applicationTypeEnum;
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String key = event.getProperty().getName();
        if (MODEL_KEY.equals(key)) {
            PluginUtils.setModelFilter(event, this.getView());
        }
    }

    private DynamicObject userHistoryModel() {
        Long modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)MODEL_KEY, (boolean)false);
        if (IDUtils.isNotNull((Long)modelId)) {
            return BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"epm_model", (String)"id,number,shownumber,name");
        }
        return null;
    }

    private void setCustomModelParamValue(long modelId) {
        this.getView().getFormShowParameter().setCustomParam("KEY_MODEL_ID", (Object)modelId);
    }

    private long getModelIdFromCustomParam() {
        Long modelId = (Long)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        return modelId == null ? 0L : modelId;
    }

    private void resetAppPageId() {
        if (this.getView().getParentView() != null) {
            this.getPageCache().put("appPageId", this.getView().getParentView().getPageId());
        }
    }

    private Set<Long> userPerModelSet() {
        ApplicationTypeEnum application = ModelUtil.queryApp((IFormView)this.getView());
        Set userPerModelSet = FunPermissionHelper.getEffectiveByPermModel((String)this.getView().getEntityId(), (ApplicationTypeEnum)application);
        Set manageModelids = MemberPermHelper.getLimitedModelListByUser();
        Set perRoleids = FunPermissionHelper.getRoleModel((long)UserUtils.getUserId(), (String)"epm_model", (ApplicationTypeEnum)application);
        userPerModelSet.addAll(manageModelids);
        userPerModelSet.addAll(perRoleids);
        return userPerModelSet;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object obj;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (key.equals(MODEL_KEY) && (obj = this.getModel().getValue(MODEL_KEY)) != null) {
            Long modelId = ((DynamicObject)obj).getLong("id");
            UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
            this.getView().getFormShowParameter().setCustomParam("KEY_MODEL_ID", (Object)modelId);
            this.resetAppPageId();
            super.afterCreateNewData(null);
        }
    }
}

