/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.apphome;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.cache.Cache;
import kd.epm.eb.common.utils.cache.ICache;

public class BgmHomeTaskPlugin
extends AbstractFormPlugin {
    private int task_submitnum = 0;
    private int task_pendingnum = 0;
    private int task_allnum = 0;
    private static final String EPM_TASK_HOME_KEY = "EPM_TASK_HOME_KEY_USER_";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"submitnum", "pendingnum", "allnum"});
        String parentPage = this.getView().getParentView().getPageId();
        this.getPageCache().put("appPageId", parentPage);
    }

    public void afterCreateNewData(EventObject e) {
        this.setData(this.getTaskSize());
        Map<String, Integer> taskMap = this.addKeyToMap();
        this.setLableValue(taskMap);
    }

    private void setLableValue(Map<String, Integer> taskMap) {
        for (Map.Entry<String, Integer> entry : taskMap.entrySet()) {
            ((Label)this.getControl(entry.getKey())).setText(entry.getValue().toString());
        }
    }

    private void setData(Map<String, Integer> taskSizeMap) {
        this.task_allnum = 0;
        this.task_submitnum = 0;
        this.task_pendingnum = 0;
        for (Map.Entry<String, Integer> entry : taskSizeMap.entrySet()) {
            if (StringUtils.equals((String)BgTaskStateEnum.UNSTARTED.getNumber(), (String)entry.getKey())) {
                this.task_pendingnum = entry.getValue();
            } else if (StringUtils.equals((String)BgTaskStateEnum.UNDERWAY.getNumber(), (String)entry.getKey()) || StringUtils.equals((String)BgTaskStateEnum.COMPLETED.getNumber(), (String)entry.getKey())) {
                this.task_submitnum = entry.getValue();
            }
            this.task_allnum += entry.getValue().intValue();
        }
    }

    private Map<String, Integer> getTaskSize() {
        Map<String, Integer> taskSizeMap = Maps.newHashMapWithExpectedSize((int)16);
        Long userId = UserUtils.getUserId();
        String taskKey = EPM_TASK_HOME_KEY + userId;
        ICache cache = Cache.get();
        String cacheData = cache.get(taskKey);
        if (StringUtils.isNotEmpty((String)cacheData)) {
            taskSizeMap = (Map)JSONUtils.parse((String)cacheData, Map.class);
        } else {
            SqlBuilder sql = new SqlBuilder();
            sql.append("select t.fstate, count(t.fid) as fcount from t_eb_taskprocess t inner join t_eb_taskproces_executors e on e.fid=t.fid and e.fbasedataid = ? group by t.fstate", new Object[]{UserUtils.getUserId()});
            try (DataSet ds = DB.queryDataSet((String)"queryTaskSize", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
                for (Row row : ds) {
                    taskSizeMap.put(row.getString("fstate"), row.getInteger("fcount"));
                }
            }
            cache.set(taskKey, JSONUtils.toString((Object)taskSizeMap), 1, TimeUnit.MINUTES);
        }
        return taskSizeMap;
    }

    private Map<String, Integer> addKeyToMap() {
        HashMap<String, Integer> taskMap = new HashMap<String, Integer>(16);
        taskMap.put("submitnum", this.task_submitnum);
        taskMap.put("pendingnum", this.task_pendingnum);
        taskMap.put("allnum", this.task_allnum);
        return taskMap;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "submitnum": 
            case "comingovernum": 
            case "donenum": 
            case "pendingnum": 
            case "overnum": 
            case "allnum": {
                this.showForm(control.getKey());
            }
        }
    }

    private void showForm(String key) {
        IFormView childFormView;
        FormShowParameter param = new FormShowParameter();
        param.setPageId(org.apache.commons.lang3.StringUtils.join((Object[])new String[]{param.getFormId(), "_", this.getView().getPageId()}));
        param.setCustomParam("formid", (Object)"eb_executetask");
        param.setCustomParam("showtype", (Object)"10");
        param.setCustomParam("isFormBegin", (Object)key);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setFormId("eb_executetask");
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            param.setParentPageId(parentView.getPageId());
        }
        if ((childFormView = this.getView().getView(param.getPageId())) != null) {
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        } else {
            this.getView().showForm(param);
        }
    }
}

