/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.apphome;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.model.permission.MemberPermHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class EbHomeReportTaskPlugin
extends AbstractFormPlugin {
    private long report_submitnum;
    private long report_savenum;
    private long report_approvenum;
    private boolean enable;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"savenum", "submitnum", "approvenum"});
        String parentPage = this.getView().getParentView().getPageId();
        this.getPageCache().put("appPageId", parentPage);
    }

    public void afterCreateNewData(EventObject e) {
        this.queryReport();
        Map<String, Long> taskMap = this.addKeyToMap();
        this.setLableValue(taskMap);
    }

    private void queryReport() {
        Row next;
        QFilter qFilter = new QFilter("application", "=", (Object)"6");
        qFilter.and("modifier", "=", (Object)UserUtils.getUserId());
        qFilter.and("date", "is not null", (Object)"");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"epm_userselect", (String)"model,model.reporttype", (QFilter[])qFilter.toArray(), (String)"date desc", (int)1);
        long modelId = 0L;
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            modelId = ((DynamicObject)query.get(0)).getLong("model");
        }
        HashSet permIds = new HashSet(16);
        ApplicationTypeEnum application = ApplicationTypeEnum.BG;
        String entityId = this.getView().getEntityId();
        Set effectives = FunPermissionHelper.getEffectiveByPermModel((String)entityId, (ApplicationTypeEnum)application);
        Set manageModelIds = MemberPermHelper.getLimitedModelListByUser((ApplicationTypeEnum)application);
        Set perRoleids = FunPermissionHelper.getRoleModel((long)UserUtils.getUserId(), (String)"epm_model", (ApplicationTypeEnum)application);
        permIds.addAll(effectives);
        permIds.addAll(manageModelIds);
        permIds.addAll(perRoleids);
        if (permIds.size() > 0) {
            if (!permIds.contains(modelId) || !QueryServiceHelper.exists((String)"epm_model", (Object)modelId)) {
                modelId = 0L;
            }
            this.enable = true;
        } else {
            this.enable = false;
        }
        String saveSql = "select count(fid) from t_eb_reportprocess where fstatus = '7' and fmodel = ?";
        String submitSql = "select count(fid) from t_eb_reportprocess where fstatus = '3'  and fmodel = ?";
        String approveSql = "select count(fid) from t_eb_reportprocess where fstatus = '5'  and fmodel = ?";
        Object[] params = new Object[]{modelId};
        try (DataSet dataSet = DB.queryDataSet((String)"getReportProcessList", (DBRoute)DBRoute.of((String)"epm"), (String)saveSql, (Object[])params);){
            while (dataSet.hasNext()) {
                next = dataSet.next();
                this.report_savenum = next.getLong(0);
            }
        }
        dataSet = DB.queryDataSet((String)"getReportProcessList", (DBRoute)DBRoute.of((String)"epm"), (String)submitSql, (Object[])params);
        var16_15 = null;
        try {
            while (dataSet.hasNext()) {
                next = dataSet.next();
                this.report_submitnum = next.getLong(0);
            }
        }
        catch (Throwable next2) {
            var16_15 = next2;
            throw next2;
        }
        finally {
            if (dataSet != null) {
                if (var16_15 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable next2) {
                        var16_15.addSuppressed(next2);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        dataSet = DB.queryDataSet((String)"getReportProcessList", (DBRoute)DBRoute.of((String)"epm"), (String)approveSql, (Object[])params);
        var16_15 = null;
        try {
            while (dataSet.hasNext()) {
                next = dataSet.next();
                this.report_approvenum = next.getLong(0);
            }
        }
        catch (Throwable throwable) {
            var16_15 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var16_15 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var16_15.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
    }

    private void setLableValue(Map<String, Long> taskMap) {
        for (Map.Entry<String, Long> entry : taskMap.entrySet()) {
            ((Label)this.getControl(entry.getKey())).setText(entry.getValue().toString());
            this.getView().setEnable(Boolean.valueOf(this.enable), new String[]{entry.getKey()});
        }
    }

    private Map<String, Long> addKeyToMap() {
        HashMap<String, Long> taskMap = new HashMap<String, Long>(16);
        taskMap.put("savenum", this.report_savenum);
        taskMap.put("submitnum", this.report_submitnum);
        taskMap.put("approvenum", this.report_approvenum);
        return taskMap;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "savenum": 
            case "submitnum": 
            case "approvenum": {
                this.showForm(control.getKey());
                break;
            }
        }
    }

    private void showForm(String key) {
        IFormView childFormView;
        FormShowParameter param = new FormShowParameter();
        param.setPageId(StringUtils.join((Object[])new String[]{param.getFormId(), "_", this.getView().getPageId()}));
        param.setCustomParam("formid", (Object)"bgm_rptpreparation");
        param.setCustomParam("showtype", (Object)"10");
        param.setCustomParam("isFormBegin", (Object)key);
        param.setCustomParam("newEbForm", (Object)"true");
        String status = "0";
        if ("savenum".equals(key)) {
            status = "7";
        } else if ("submitnum".equals(key)) {
            status = "3";
        } else if ("approvenum".equals(key)) {
            status = "5";
        }
        param.setCustomParam("status", (Object)status);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setFormId("bgm_rptpreparation");
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            param.setParentPageId(parentView.getPageId());
        }
        if ((childFormView = this.getView().getView(param.getPageId())) != null) {
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        } else {
            this.getView().showForm(param);
        }
    }
}

