/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.apphome;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;
import kd.epm.eb.model.permission.MemberPermHelper;
import org.apache.commons.collections.CollectionUtils;

public class EbHomeSchemeUpdatePlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        Set<Long> ids = this.getHasPermModel();
        if (ids == null || ids.isEmpty()) {
            return;
        }
        this.putData2Entry(ids);
    }

    private void putData2Entry(Set<Long> modelIds) {
        ArrayList<Pair> pairs = new ArrayList<Pair>(16);
        QFilter qFilter = new QFilter("application", "=", (Object)"6");
        qFilter.and("modifier", "=", (Object)UserUtils.getUserId());
        qFilter.and("date", "is not null", (Object)"");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"epm_userselect", (String)"model,model.reporttype", (QFilter[])qFilter.toArray(), (String)"date desc", (int)1);
        long modelId = 0L;
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            modelId = ((DynamicObject)query.get(0)).getLong("model");
        }
        qFilter = modelId != 0L ? new QFilter("model", "=", (Object)modelId) : new QFilter("model", "in", modelIds);
        HashSet status = Sets.newHashSet((Object[])new String[]{"0", "2"});
        qFilter.and(new QFilter("status", "in", (Object)status));
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryConvertUpdate", (String)"eb_currconvertupdate", (String)"scheme.name,model,entitys", (QFilter[])qFilter.toArray(), (String)"createdate desc", (int)5);){
            while (ds.hasNext()) {
                Row next = ds.next();
                pairs.add(new Pair((Object)next.getString("scheme.name"), (Object)next.getString("entitys")));
            }
        }
        if (modelId != 0L) {
            this.getModel().setValue("model", (Object)modelId);
        }
        if (pairs.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow("entryentity", pairs.size());
        for (int i = 0; i < pairs.size(); ++i) {
            Pair pair = (Pair)pairs.get(i);
            DynamicObject entity = this.getModel().getEntryRowEntity("entryentity", i);
            entity.set("schemes", pair.getKey());
            entity.set("entitys", pair.getValue());
        }
        this.getView().updateView("entryentity");
    }

    @Override
    public Long getModelId() {
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (model == null) {
            return 0L;
        }
        return model.getLong("id");
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing) {
            this.openSchemeUpdatePage();
        }
    }

    private void openSchemeUpdatePage() {
        IFormView toshowform;
        Long userId = UserUtils.getUserId();
        IFormView mainPageView = this.getView().getMainView();
        String pageId = this.getView().getPageId() + userId;
        IFormView iFormView = toshowform = mainPageView == null ? null : mainPageView.getView(pageId);
        if (toshowform == null) {
            IFormView parentview;
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"eb_currconvertupdate", (boolean)Boolean.TRUE, (int)0, (boolean)false);
            showParameter.setPageId(pageId);
            long modelId = this.getModelId();
            if (modelId != 0L) {
                showParameter.setCustomParam("model", (Object)modelId);
            }
            if ((parentview = this.getView().getParentView()) != null) {
                showParameter.setParentPageId(parentview.getPageId());
            }
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "callback"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("newEbForm", (Object)"true");
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            toshowform.activate();
            this.getView().sendFormAction(toshowform);
        }
    }

    public Set<Long> getHasPermModel() {
        ApplicationTypeEnum application = ApplicationTypeEnum.BG;
        Set ids = FunPermissionHelper.getEffectiveByPermModel((String)"eb_currconvertupdatelist", (ApplicationTypeEnum)application);
        Set manageModelIds = MemberPermHelper.getLimitedModelListByUser();
        Set perRoleids = FunPermissionHelper.getRoleModel((long)UserUtils.getUserId(), (String)"epm_model", (ApplicationTypeEnum)application);
        ids.addAll(manageModelIds);
        ids.addAll(perRoleids);
        return ids;
    }
}

