/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.apphome;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.EBPermission;
import kd.epm.eb.common.utils.AppUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.utils.OpenMenuPageUtil;
import kd.epm.eb.formplugin.utils.PageParamModel;
import kd.epm.eb.model.permission.MemberPermHelper;
import kd.epm.eb.model.utils.ModelUtil;
import org.jetbrains.annotations.NotNull;

public class ModelDetailsViewEditPlugin
extends AbstractFormPlugin
implements EBPermission {
    protected static Boolean aTrue = Boolean.TRUE;
    protected static Boolean aFalse = Boolean.FALSE;
    private QFilter mfilter = null;

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"model", "dimension", "template", "bizrule", "taskconfig"});
        this.addClickListeners(new String[]{"dsum", "msum", "ldsum", "tsize", "bsize", "labelc21", "labelc11", "tcsize"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        if (map == null) {
            return;
        }
        String modelid = map.get("KEY_MODEL_ID").toString();
        this.getPageCache().put("KEY_MODEL_ID", modelid);
        this.mfilter = new QFilter("model", "=", (Object)Long.parseLong(modelid));
        String appNum = ModelUtil.queryApp((IFormView)this.getView()).getAppnum();
        if (appNum.equals(ApplicationTypeEnum.EB.getAppnum()) || appNum.equals(ApplicationTypeEnum.BGMD.getAppnum()) || appNum.equals(ApplicationTypeEnum.BGBD.getAppnum())) {
            this.setEbData(modelid);
        } else {
            this.setData(modelid);
        }
        if (!ObjectUtils.isEmpty((Object)this.getView().getParentView()) && !ObjectUtils.isEmpty((Object)this.getView().getParentView().getParentView())) {
            String parentPage = this.getView().getParentView().getParentView().getPageId();
            this.getPageCache().put("appPageId", parentPage);
        }
    }

    private DynamicObject queryModelData(String modelid) {
        String selectFields = "id,number,name,presetyear,startfy,modifier.name,modifytime,beginperiodtext,shownumber,isspptproject,enable";
        QFilter fmodelid = new QFilter("id", "=", (Object)Long.parseLong(modelid));
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"epm_model", (String)selectFields, (QFilter[])fmodelid.toArray(), null);
        if (doc.size() == 1) {
            return (DynamicObject)doc.get(0);
        }
        return null;
    }

    private DynamicObjectCollection queryDimensionData(QFilter mfilter) {
        DynamicObjectCollection doc;
        String selectFields = "id,name,number,issysdimension,membermodel,membertable";
        QFBuilder qBuilder = new QFBuilder();
        qBuilder.add(mfilter);
        String appNum = ModelUtil.queryApp((IFormView)this.getView()).getAppnum();
        if (!appNum.equals(ApplicationTypeEnum.BGBD.getAppnum()) && !appNum.equals(ApplicationTypeEnum.BGMD.getAppnum()) && appNum.equals(ApplicationTypeEnum.EB.getAppnum())) {
            qBuilder.add("number", "!=", (Object)SysDimensionEnum.Scenario.getNumber());
            qBuilder.add("number", "!=", (Object)SysDimensionEnum.Process.getNumber());
        }
        if ((doc = QueryServiceHelper.query((String)"epm_dimension", (String)selectFields, (QFilter[])qBuilder.toArray())).size() > 0) {
            return doc;
        }
        return null;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        if (!this.isModelHasDelete()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728\u3002", (String)"ModelDetailsViewEditPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "dimension": 
            case "dsum": 
            case "msum": 
            case "ldsum": {
                this.checkViewPerm("epm_dimensionmanager");
                FormShowParameter parm = new FormShowParameter();
                parm.setCaption(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7ba1\u7406", (String)"ModelDetailsViewEditPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                this.showListView("epm_dimensionmanager", parm, null);
                break;
            }
            case "template": 
            case "tsize": 
            case "bsize": {
                this.checkViewPerm("eb_templatelist");
                if (AppUtil.isEpmAppId((String)this.getView().getFormShowParameter().getAppId())) {
                    this.showListView("eb_templatelist", (FormShowParameter)new ListShowParameter(), "eb_templateentity");
                    break;
                }
                this.showListView("eb_templatelist", (FormShowParameter)new ListShowParameter(), "bcm_templateentity");
                break;
            }
            case "bizrule": 
            case "labelc21": 
            case "labelc11": {
                break;
            }
            case "taskconfig": 
            case "tcsize": 
            case "confsize": {
                this.checkViewPerm("eb_taskhome");
                this.showListView("eb_taskhome", new FormShowParameter(), "eb_tasklist");
                break;
            }
            case "model": {
                this.showBaseView(ShowType.Modal, "epm_model", this.getPageCache().get("KEY_MODEL_ID"));
                break;
            }
        }
    }

    private boolean isModelHasDelete() {
        return QueryServiceHelper.exists((String)"epm_model", (Object)this.getPageCache().get("KEY_MODEL_ID"));
    }

    private void setData(String modelid) {
        this.setModelData(modelid);
        this.setDimensionData();
        this.setTemplateData();
        this.setTaskData();
        this.setCalculateData(true);
        this.setMergeData(true);
        this.setWorkPagper();
        this.setChecktmpl();
    }

    private void setEbData(String modelid) {
        this.setEbModelData(modelid);
        this.setTemplateData();
        this.setEbComputeRule();
        this.setEbTaskInfo();
        this.setEbTaskState();
        this.setEbUserInfo();
        this.setDimensionData();
    }

    private void setCheckedData() {
        int size = QueryServiceHelper.query((String)"eb_examine", (String)"id", (QFilter[])new QFilter[]{this.mfilter}).size();
        if (size > 0) {
            this.setLableText("labelc11", String.valueOf(size));
            this.setVisible(true, "labelc11", "labelc12");
            this.setVisible(false, "imagec1", "labelc1");
        } else {
            this.setVisible(false, "labelc11");
        }
    }

    private void setTaskData() {
        int cSize = QueryServiceHelper.query((String)"eb_tasklist", (String)"id", (QFilter[])new QFilter[]{this.mfilter}).size();
        if (cSize > 0) {
            this.setLableText("tcsize", String.valueOf(cSize));
            this.setVisible(false, "imagetc1", "labeltc1");
        } else {
            this.setVisible(false, "tcsize", "labeltc");
        }
        QFilter filter1 = new QFilter("tasktype", "in", (Object)new int[]{3, 5});
        int tSize = QueryServiceHelper.query((String)"epm_taskconfig", (String)"id", (QFilter[])new QFilter[]{this.mfilter, filter1}).size();
        if (tSize > 0) {
            this.setLableText("confsize", String.valueOf(tSize));
            this.setVisible(false, "imagetc2", "labeltc2");
        } else {
            this.setVisible(false, "confsize", "labelconf");
        }
    }

    private void setEbComputeRule() {
        this.setVisible(false, "labelc21", "labelc22");
        this.setVisible(false, "labelc11", "labelc12");
    }

    private void setEbTaskInfo() {
        this.setVisible(false, "labeltc", "tcsize");
        this.setVisible(false, "confsize", "labelconf");
    }

    private void setEbTaskState() {
        this.setVisible(false, "tcsize1", "labeltc3");
        this.setVisible(false, "confsize1", "labelconf1");
        this.setVisible(false, "confsize11", "labelconf11");
    }

    private void setEbUserInfo() {
        this.setVisible(false, "labelc211", "labelc221");
        this.setVisible(false, "labelc111", "labelc121");
    }

    private void setCalculateData(boolean value) {
        if (value) {
            this.setVisible(false, "labelc11", "labelc12");
        } else {
            this.setVisible(false, "imagec1", "labelc1");
        }
        this.setBizRuleData();
        this.setCheckedData();
    }

    private void setBizRuleData() {
        QFilter filter = new QFilter("deletestatus", "=", (Object)aFalse);
        int size = QueryServiceHelper.query((String)"eb_bizruleentity", (String)"id", (QFilter[])new QFilter[]{this.mfilter, filter}).size();
        if (size > 0) {
            this.setLableText("labelc21", String.valueOf(size));
            this.setVisible(false, "imagec2", "labelc2");
        } else {
            this.setVisible(false, "labelc21", "labelc22");
        }
    }

    private void setMergeData(boolean value) {
        if (value) {
            this.setVisible(false, "labelm11", "labelm12", "labelm21", "labelm22", "labelm31", "labelm32", "labelm41", "labelm42");
        } else {
            this.setVisible(false, "imagem1", "imagem2", "imagem3", "imagem4", "labelm1", "labelm2", "labelm3", "labelm4");
        }
    }

    private void setLableText(String pname, String text) {
        Label countLabel = (Label)this.getControl(pname);
        countLabel.setText(text);
    }

    private void setModelData(String modelid) {
        boolean language;
        DynamicObject dt = this.queryModelData(modelid);
        if (dt == null) {
            return;
        }
        this.setLableText("mnumber", dt.getString("shownumber") + " " + dt.getString("name"));
        this.setLableText("presetyear", dt.getString("beginperiodtext"));
        boolean bl = language = !Lang.get().equals((Object)Lang.zh_CN) && !Lang.get().equals((Object)Lang.zh_TW);
        if (language) {
            this.setLableText("startfy", String.valueOf(dt.getInt("startfy") + 1997 - 1));
        } else {
            this.setLableText("startfy", ResManager.loadResFormat((String)"%1\u5e74", (String)"ModelDetailsViewEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{dt.getInt("startfy") + 1997 - 1}));
        }
        this.setLableText("modifier", dt.getString("modifier.name"));
        this.setLableText("modifytime", dt.getString("modifytime").substring(0, dt.getString("modifytime").lastIndexOf(46)));
    }

    private void setEbModelData(String modelid) {
        boolean language = !Lang.get().equals((Object)Lang.zh_CN) && !Lang.get().equals((Object)Lang.zh_TW);
        DynamicObject dt = this.queryModelData(modelid);
        if (dt == null) {
            return;
        }
        IDataModel model = this.getModel();
        model.setValue("isspptproject", dt.get("isspptproject"));
        model.setValue("enable", dt.get("enable"));
        this.setLableText("mnumber", dt.getString("shownumber") + " " + dt.getString("name"));
        if (language) {
            this.setLableText("startfy", String.valueOf(dt.getInt("startfy") + 1997 - 1));
        } else {
            this.setLableText("startfy", ResManager.loadResFormat((String)"%1\u5e74", (String)"ModelDetailsViewEditPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{dt.getInt("startfy") + 1997 - 1}));
        }
    }

    private void setDimensionData() {
        DynamicObjectCollection doc = this.queryDimensionData(this.mfilter);
        if (doc == null) {
            return;
        }
        int dsum = 0;
        int msum = 0;
        int accountnum = 0;
        StringBuilder mnames = new StringBuilder();
        for (DynamicObject d : doc) {
            String tableName;
            if (!Boolean.parseBoolean(d.getString("issysdimension"))) {
                mnames.append(d.get("name")).append(',');
            } else {
                ++dsum;
            }
            if (SysDimensionEnum.Account.getNumber().equals(d.getString("number"))) {
                ++accountnum;
            }
            if (StringUtils.isEmpty((String)(tableName = SysDimensionEnum.getMemberTableByNumber((String)d.getString("number"))))) {
                tableName = "t_eb_structofdefined";
            }
            msum += this.querySizeFromModel(tableName, IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID")), d.getLong("id"));
        }
        this.setLableText("dsum", doc.size() - accountnum + "");
        this.setLableText("ldsum", doc.size() - dsum + "");
        if (doc.size() - dsum == 0) {
            this.setVisible(false, "ldsum", "labeld");
            this.setVisible(true, "imaged1", "labeld1");
        } else {
            this.setVisible(true, "ldsum", "labeld");
            this.setVisible(false, "imaged1", "labeld1");
        }
        this.setLableText("msum", msum + "");
    }

    private void setVisible(boolean value, String ... ctlKeys) {
        this.getView().setVisible(Boolean.valueOf(value), ctlKeys);
    }

    private int querySizeFromModel(String entityName, QFilter[] qFilters) {
        List ids = QueryServiceHelper.queryPrimaryKeys((String)entityName, (QFilter[])qFilters, null, (int)1000000);
        return ids.size();
    }

    private int querySizeFromModel(@NotNull String tableName, @NotNull Long modelId, @NotNull Long dimensionId) {
        int count = 0;
        SqlBuilder sql = new SqlBuilder();
        sql.append("select count(fid) from ", new Object[0]).append(tableName, new Object[0]).append(" where fmodelid = ?", new Object[]{modelId}).append(" and fdimensionid = ?", new Object[]{dimensionId});
        try (DataSet ds = DB.queryDataSet((String)"querySize", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null && ds.hasNext()) {
                count = ds.next().getInteger(0);
            }
        }
        return count;
    }

    private void setTemplateData() {
        int tsize = 0;
        tsize = AppUtil.isEpmAppId((String)this.getView().getFormShowParameter().getAppId()) ? this.querySizeFromModel("eb_templateentity", new QFilter[]{this.mfilter}) : this.querySizeFromModel("bcm_templateentity", new QFilter[]{this.mfilter});
        QFilter filter1 = new QFilter("usage", "=", (Object)"1");
        int bsize = 0;
        this.setLableText("tsize", tsize + "");
        if (tsize == 0) {
            this.setVisible(false, "tsize", "labeltsize");
            this.setVisible(true, "imaget1", "labelt1");
        } else {
            this.setVisible(true, "tsize", "labeltsize");
            this.setVisible(false, "imaget1", "labelt1");
        }
        this.setLableText("bsize", bsize + "");
        if (bsize == 0) {
            this.setVisible(false, "bsize", "labelbsize");
            this.setVisible(true, "imaget2", "labelt2");
        } else {
            this.setVisible(false, "imaget2", "labelt2");
            this.setVisible(true, "bsize", "labelbsize");
        }
    }

    private void showBaseView(ShowType showtype, String formid, Object pkid) {
        BaseShowParameter param = new BaseShowParameter();
        param.getOpenStyle().setShowType(showtype);
        param.setFormId(formid);
        param.setPkId(pkid);
        param.setStatus(OperationStatus.EDIT);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "status"));
        this.getView().showForm((FormShowParameter)param);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionid;
        super.closedCallBack(event);
        switch (actionid = event.getActionId()) {
            case "status": {
                if (!"success".equals(event.getReturnData())) break;
                String modelid = this.getPageCache().get("KEY_MODEL_ID");
                this.setModelData(modelid);
                break;
            }
        }
    }

    private void showListView(String formid, FormShowParameter param, String billFormId) {
        if (param instanceof ListShowParameter) {
            ((ListShowParameter)param).setBillFormId(billFormId);
        }
        PageParamModel pageModel = new PageParamModel(this.getView(), true, this.getPageCache().get("KEY_MODEL_ID"), this.getPageCache().get("appPageId"), formid, param);
        OpenMenuPageUtil.showFormViewByParam(pageModel);
    }

    private void setWorkPagper() {
        QFilter q = new QFilter("templatetype", "=", (Object)"2");
        DynamicObjectCollection dc = QueryServiceHelper.query((String)"bcm_templateentity", (String)"id", (QFilter[])new QFilter[]{q, this.mfilter});
        int i = dc.size();
        if (i != 0) {
            this.setLableText("labelm11", i + "");
            this.setVisible(true, "labelm11", "labelm12");
            this.setVisible(false, "imagem1", "labelm1");
        } else {
            this.setVisible(false, "labelm11", "labelm12");
            this.setVisible(true, "imagem1", "labelm1");
        }
    }

    private void setChecktmpl() {
        int i = this.querySizeFromModel("bcm_checktmpl", this.mfilter.toArray());
        if (i != 0) {
            this.setLableText("labelm21", i + "");
            this.setVisible(true, "labelm21", "labelm22");
            this.setVisible(false, "imagem2", "labelm2");
        } else {
            this.setVisible(false, "labelm21", "labelm22");
            this.setVisible(true, "imagem2", "labelm2");
        }
    }

    private void checkViewPerm(String formId) {
        Long userId = this.getUserId();
        Long modelId = this.getModelId();
        int is = this.checkItemPermission(userId, modelId, this.getBizAppId(), formId, "47150e89000000ac");
        if (is == 0) {
            if (MemberPermHelper.ifUserHasRootPermByModel((Long)userId, (Long)modelId)) {
                return;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u5f53\u524d\u83dc\u5355\u67e5\u8be2\u6743\u9650\u3002", (String)"BGMDHomePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public Long getModelId() {
        Object model = this.getModel().getValue("model");
        if (model != null) {
            return ((DynamicObject)model).getLong("id");
        }
        return 0L;
    }

    public String getBizAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }

    public boolean isCheckModel() {
        return true;
    }
}

