/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.apphome;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.control.BgControlCallerImpl;
import kd.epm.eb.control.face.IBudgetBalance;

public class MyAttentionPlugin
extends AbstractFormPlugin {
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"maddop", "mdelop", "delop", "addop", "editop"});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "maddop": {
                this.maddRow();
                break;
            }
            case "mdelop": {
                this.mdelRow();
            }
        }
    }

    public void maddRow() {
        if (this.getModel().getValue("model") != null && this.getModel().getValue("entity") != null && this.getModel().getValue("year") != null && this.getModel().getValue("period") != null && this.getModel().getValue("currency") != null) {
            DynamicObject dc = (DynamicObject)this.getModel().getValue("model");
            this.filterModel(dc, "account");
            BasedataEdit base = (BasedataEdit)this.getControl("account");
            base.click();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u4fdd\u201c\u4f53\u7cfb\u201d\u3001\u201c\u7ec4\u7ec7\u201d\u3001\u201c\u671f\u95f4\u201d\u3001\u201c\u5e74\u4efd\u201d\u3001\u201c\u5e01\u79cd\u201d\u4e0d\u4e3a\u7a7a\u3002", (String)"MyAttentionPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    public void mdelRow() {
        IDataModel model = this.getModel();
        EntryGrid entryGrid = (EntryGrid)this.getControl("mentryentity");
        int[] a = entryGrid.getSelectRows();
        DynamicObjectCollection doc = (DynamicObjectCollection)model.getValue("account");
        int size = doc.size();
        for (int index : a) {
            doc.remove(index - (size - doc.size()));
        }
        model.deleteEntryRows("mentryentity", a);
        model.setValue("account", (Object)doc);
        this.getView().updateView("account");
        this.getView().updateView("mentryentity");
    }

    public void getAccount(Collection<IBudgetBalance> iBudgetBalances, DynamicObjectCollection dcs) {
        String mentryentity = "mentryentity";
        IDataModel model = this.getModel();
        model.deleteEntryData(mentryentity);
        if (iBudgetBalances != null) {
            if (iBudgetBalances.size() > 0) {
                model.batchCreateNewEntryRow(mentryentity, iBudgetBalances.size());
                int i = 0;
                for (IBudgetBalance balance : iBudgetBalances) {
                    DynamicObject entryentity = model.getEntryRowEntity("mentryentity", i);
                    entryentity.set("msubject", (Object)balance.getAccount(true).getName());
                    entryentity.set("budget", Objects.isNull(balance.getBudget()) ? "0.00" : balance.getBudget().setScale(2, 6));
                    entryentity.set("taken", Objects.isNull(balance.getOccupation()) ? "0.00" : balance.getOccupation().setScale(2, 6));
                    entryentity.set("run", Objects.isNull(balance.getExecute()) ? "0.00" : balance.getExecute().setScale(2, 6));
                    entryentity.set("avaliable", Objects.isNull(balance.getBalance()) ? "0.00" : balance.getBalance().setScale(2, 6));
                    if (balance.getExecute() != null && balance.getBudget() != null && !balance.getBudget().equals(BigDecimal.ZERO)) {
                        entryentity.set("predictreal", (Object)(balance.getExecute().multiply(new BigDecimal("100.00")).divide(balance.getBudget(), 2, 6).doubleValue() + "%"));
                    } else {
                        entryentity.set("predictreal", (Object)"0.00%");
                    }
                    ++i;
                }
                if (iBudgetBalances.size() < dcs.size()) {
                    for (DynamicObject object : dcs) {
                        String number = ((DynamicObject)object.get("fbasedataid")).get("number").toString();
                        for (IBudgetBalance balance : iBudgetBalances) {
                            String number1 = balance.getAccount(true).getNumber();
                            if (number.equals(number1)) continue;
                            int line = this.getModel().getEntryRowCount("mentryentity");
                            model.createNewEntryRow("mentryentity");
                            DynamicObject entryentity = model.getEntryRowEntity("mentryentity", line);
                            entryentity.set("msubject", (Object)((DynamicObject)object.get("fbasedataid")).get("name").toString());
                        }
                    }
                }
            }
        } else {
            for (DynamicObject object : dcs) {
                int line = this.getModel().getEntryRowCount("mentryentity");
                model.createNewEntryRow("mentryentity");
                DynamicObject entryentity = model.getEntryRowEntity("mentryentity", line);
                entryentity.set("msubject", (Object)((DynamicObject)object.get("fbasedataid")).get("name").toString());
            }
        }
        this.getView().updateView(mentryentity);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (key.equals("account")) {
            this.refreshEntryentity();
        }
    }

    private void refreshEntryentity() {
        if (this.getModel().getValue("model") != null && this.getModel().getValue("entity") != null && this.getModel().getValue("year") != null && this.getModel().getValue("period") != null && this.getModel().getValue("currency") != null) {
            DynamicObjectCollection dcs = (DynamicObjectCollection)this.getModel().getValue("account");
            long modelid = 0L;
            BgControlCallerImpl bgControlCaller = new BgControlCallerImpl();
            ArrayList dimlist = new ArrayList(16);
            HashMap<String, String> accountMap = null;
            for (DynamicObject dynamicObject : dcs) {
                accountMap = new HashMap<String, String>(16);
                DynamicObject basedoc = (DynamicObject)dynamicObject.get("fbasedataid");
                accountMap.put(SysDimensionEnum.Account.getNumber(), basedoc.getString("number"));
                modelid = ((DynamicObject)this.getModel().getValue("model")).getLong("id");
                String entityNumber = ((DynamicObject)this.getModel().getValue("entity")).getString("number");
                accountMap.put(SysDimensionEnum.Entity.getNumber(), entityNumber);
                String currencyNumber = ((DynamicObject)this.getModel().getValue("currency")).getString("number");
                accountMap.put(SysDimensionEnum.Currency.getNumber(), currencyNumber);
                String yearNumber = ((DynamicObject)this.getModel().getValue("year")).getString("number");
                accountMap.put(SysDimensionEnum.Year.getNumber(), yearNumber);
                String periodNumber = ((DynamicObject)this.getModel().getValue("period")).getString("number");
                accountMap.put(SysDimensionEnum.Period.getNumber(), periodNumber);
                dimlist.add(accountMap);
            }
            ArrayList<String> type = new ArrayList<String>(16);
            type.add(BgControlSettingTypeEnum.MONTH.getNumber());
            Collection iBudgetBalances = null;
            try {
                iBudgetBalances = bgControlCaller.queryBalance(Long.valueOf(modelid), dimlist, type);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.getAccount(iBudgetBalances, dcs);
        }
    }

    public void filterModel(DynamicObject dc, String name) {
        if (dc == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u65e0\u5f53\u524d\u4f53\u7cfb\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6216\u91cd\u65b0\u9009\u62e9\u4f53\u7cfb\u3002", (String)"MyAttentionPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(name);
        basedataEdit.setQFilter(new QFilter("model", "=", (Object)dc.getLong("id")).and(new QFilter("number", "!=", (Object)"Account")));
    }
}

