/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.EntryFieldGroupAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.applybill.service.ApplyBillServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyBillPluginUitl;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateDimCfgService;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateDataInitCfgEntity;
import kd.epm.eb.common.applyTemplate.helper.CustomControlHelper;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnEnum;
import kd.epm.eb.common.applytemplatecolumn.DataMapDimension;
import kd.epm.eb.common.applytemplatecolumn.DimensionDataColumn;
import kd.epm.eb.common.applytemplatecolumn.DimensionMemberRange;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.applytemplatecolumn.FieldTypeEnum;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractBasePlugin;
import org.jetbrains.annotations.NotNull;

public class BgApplyBillDataInitListPlugin
extends AbstractBasePlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(BgApplyBillDataInitListPlugin.class);
    private static final String ENTRYENTITY = "entryentity";
    private static final String SEL_ENTRYENTITY = "sel_entryentity";
    private static String[] EntryArrays = new String[]{"entryentity", "sel_entryentity"};
    private static final String prefx = "sel_";
    private static final String Cache_DataInitCfgEntity = "Cache_DataInitCfgEntity";
    private static final String BTN_ADDSEL = "btn_addsel";
    private static final String BTN_REMOVESEL = "btn_removesel";

    private Map<String, String> getMap() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("entity", SysDimensionEnum.Entity.getNumber());
        map.put("account", SysDimensionEnum.Account.getNumber());
        return map;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadData();
    }

    private void loadData() {
        this.getModel().deleteEntryData(ENTRYENTITY);
        EntryTemplateConfig entityEntryTemplateConfig = this.getEntityEntryTemplateConfig();
        if (entityEntryTemplateConfig == null) {
            return;
        }
        ApplyTemplateDataInitCfgEntity applyTemplateDataInitCfgEntity = this.getApplyTemplateDataInitCfgEntity();
        List<BaseColumn> dimBaseColumns = this.getConfigColumns(entityEntryTemplateConfig, applyTemplateDataInitCfgEntity);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        if (dimBaseColumns.isEmpty()) {
            return;
        }
        HashMap<String, Set> queryOlapSourceData = new HashMap<String, Set>(16);
        long _modelId = entityEntryTemplateConfig.getModelId();
        BaseColumn baseColumn = dimBaseColumns.get(0);
        RowDimensionColumn first = (RowDimensionColumn)baseColumn;
        long datasetId = first.getBussinessModelId();
        DynamicObject dataset = BusinessDataServiceHelper.loadSingle((Object)datasetId, (String)"eb_dataset");
        DynamicObject bussRangeModel = dataset.getDynamicObject("businessmodel");
        Long bussModelId = bussRangeModel.getLong("id");
        Map viewIds = BusinessModelServiceHelper.getViewIds((Long)bussRangeModel.getLong("id"));
        Long viewId = null;
        Set columnKeys = applyTemplateDataInitCfgEntity.getColumnKeys();
        Set fields = entityEntryTemplateConfig.getEntryColumns().stream().filter(s -> s instanceof DimensionDataColumn && columnKeys.contains(s.getKey())).collect(Collectors.toSet());
        HashMap<Long, Set> dimIdMapMembers = new HashMap<Long, Set>(16);
        boolean isExitNoFromModel = false;
        if (!fields.isEmpty()) {
            for (BaseColumn field : fields) {
                DimensionDataColumn dataColumn = (DimensionDataColumn)field;
                boolean ispullfrommodel = dataColumn.getIspullfrommodel();
                if (ispullfrommodel) {
                    List dataMapDimensions = dataColumn.getDataMapDimensions();
                    List datamaps = dataMapDimensions.stream().filter(s -> applyTemplateDataInitCfgEntity.getDimIds().contains(s.getDimensionId())).collect(Collectors.toList());
                    if (datamaps.isEmpty()) continue;
                    for (DataMapDimension datamap : datamaps) {
                        Set memberIds;
                        long dimensionRememberId = datamap.getDimensionRememberId();
                        if (dimensionRememberId == 0L) {
                            BaseColumn baseColumn2 = this.getRowDimensionByDimenId(entityEntryTemplateConfig.getEntryColumns(), datamap.getDimensionId());
                            if (baseColumn2 == null) continue;
                            Set<Long> result = this.getDefaultMembersByRowsRange(baseColumn2, viewIds, modelCacheHelper);
                            memberIds = dimIdMapMembers.computeIfAbsent(datamap.getDimensionId(), s -> new HashSet(16));
                            memberIds.addAll(result);
                            continue;
                        }
                        Member member = modelCacheHelper.getMember(datamap.getDimNum(), (Long)viewIds.get(datamap.getDimNum()), Long.valueOf(dimensionRememberId));
                        if (member == null) continue;
                        List leaf = member.getLeaf();
                        memberIds = dimIdMapMembers.computeIfAbsent(datamap.getDimensionId(), s -> new HashSet(16));
                        memberIds.addAll(leaf.stream().map(s -> s.getId()).collect(Collectors.toSet()));
                    }
                    continue;
                }
                isExitNoFromModel = true;
            }
        }
        if (isExitNoFromModel) {
            for (BaseColumn dimBaseColumn : dimBaseColumns) {
                if (!(dimBaseColumn instanceof RowDimensionColumn)) continue;
                RowDimensionColumn rowDimensionColumn = (RowDimensionColumn)dimBaseColumn;
                String dimensionNumber = rowDimensionColumn.getDimNumber();
                ArrayList<Long> memberIds = new ArrayList<Long>(16);
                viewId = (Long)viewIds.get(dimensionNumber);
                List dimensionMemberRanges = rowDimensionColumn.getDimensionMemberRanges();
                if (dimensionMemberRanges != null && !dimensionMemberRanges.isEmpty()) {
                    for (DimensionMemberRange dimensionMemberRange : dimensionMemberRanges) {
                        int range;
                        String memberNumber = dimensionMemberRange.getNumber();
                        List list = modelCacheHelper.getMember(dimensionNumber, viewId, memberNumber, range = Integer.parseInt(dimensionMemberRange.getScope()));
                        if (list == null || list.isEmpty()) continue;
                        for (Member member : list) {
                            if (!member.isLeaf()) continue;
                            memberIds.add(member.getId());
                        }
                    }
                }
                Set prememberIds = dimIdMapMembers.computeIfAbsent(rowDimensionColumn.getDimensionId(), s -> new HashSet(16));
                prememberIds.addAll(memberIds);
            }
        }
        List relationDimColumns = entityEntryTemplateConfig.getEntryColumns().stream().filter(s -> {
            RowDimensionColumn rowDimensionColumn;
            return s instanceof RowDimensionColumn && (rowDimensionColumn = (RowDimensionColumn)s).getEnableDimensionRelation() != false && !rowDimensionColumn.getDimensionRelationSchemas().isEmpty();
        }).collect(Collectors.toList());
        Map rowMemberByFilterDimensionScheme = ApplyBillPluginUitl.getRowMemberByFilterDimensionScheme(relationDimColumns);
        log.info("BgApplyBillDataInitListPlugin.rowMemberByFilterDimensionScheme" + SerializationUtils.toJsonString((Object)rowMemberByFilterDimensionScheme));
        Map<String, Set<Long>> relationMaps = this.getRelationMaps(rowMemberByFilterDimensionScheme, modelCacheHelper, viewIds);
        log.info("BgApplyBillDataInitListPlugin.relationMaps" + SerializationUtils.toJsonString(relationMaps));
        for (BaseColumn dimBaseColumn : dimBaseColumns) {
            Set<Long> reids;
            if (!(dimBaseColumn instanceof RowDimensionColumn)) continue;
            RowDimensionColumn rowDimensionColumn = (RowDimensionColumn)dimBaseColumn;
            String dimensionNumber = rowDimensionColumn.getDimNumber();
            Set memberIds = (Set)dimIdMapMembers.get(rowDimensionColumn.getDimensionId());
            Set permissionsColumns = DimMembPermHelper.getPermMembIds((String)dimensionNumber, (Long)_modelId, (Long)bussModelId, (Long)((Long)viewIds.get(dimensionNumber)), (DimMembPermType)DimMembPermType.READ, (boolean)true);
            if (permissionsColumns != null) {
                memberIds.retainAll(permissionsColumns);
            }
            if (!relationMaps.isEmpty() && (reids = relationMaps.get(dimensionNumber)) != null) {
                memberIds.retainAll(reids);
            }
            Set sourceMemberIds = queryOlapSourceData.computeIfAbsent(dimensionNumber, s -> new HashSet(16));
            List list = modelCacheHelper.getMembers((Long)viewIds.get(dimensionNumber), dimensionNumber);
            Set memberNumbers = list.stream().filter(s -> memberIds.contains(s.getId())).map(s -> s.getNumber()).collect(Collectors.toSet());
            sourceMemberIds.addAll(memberNumbers);
        }
        Map applyBillInitDataMap = ApplyBillServiceHelper.getInstance().getApplyBillInitData(this.getModelId(), entityEntryTemplateConfig, queryOlapSourceData, applyTemplateDataInitCfgEntity.getColumnKeys());
        Set<String> applyBillInitData = this.getGroupPermMember(entityEntryTemplateConfig, modelCacheHelper, applyBillInitDataMap, viewIds);
        ArrayList leftEntrys = new ArrayList(16);
        ArrayList rightEntrys = new ArrayList(16);
        Long org = this.getOrg();
        if (!applyBillInitData.isEmpty()) {
            for (String data : applyBillInitData) {
                Map<String, String> map = this.getDimNumberMapMemberNumber(data);
                boolean iscurrentOrg = false;
                HashMap<String, Long> map2 = new HashMap<String, Long>(16);
                for (BaseColumn dimBaseColumn : dimBaseColumns) {
                    RowDimensionColumn rowDimensionColumn;
                    String dimNumber;
                    Member member;
                    String key = dimBaseColumn.getKey();
                    if (!(dimBaseColumn instanceof RowDimensionColumn) || (member = modelCacheHelper.getMember(dimNumber = (rowDimensionColumn = (RowDimensionColumn)dimBaseColumn).getDimNumber(), (Long)viewIds.get(dimNumber), map.get(dimNumber))) == null) continue;
                    if (SysDimensionEnum.Entity.getNumber().equals(dimNumber) && member.getId().equals(org)) {
                        iscurrentOrg = true;
                    }
                    map2.put(key, member.getId());
                }
                if (iscurrentOrg) {
                    rightEntrys.add(map2);
                    continue;
                }
                leftEntrys.add(map2);
            }
        }
        if (!leftEntrys.isEmpty()) {
            int rowIndex = 0;
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, leftEntrys.size());
            this.getModel().beginInit();
            for (Map map : leftEntrys) {
                for (Map.Entry stringLongEntry : map.entrySet()) {
                    this.getModel().setValue((String)stringLongEntry.getKey(), stringLongEntry.getValue(), rowIndex);
                }
                ++rowIndex;
            }
            this.getModel().endInit();
        }
        if (!rightEntrys.isEmpty()) {
            int rowIndex = 0;
            this.getModel().batchCreateNewEntryRow(SEL_ENTRYENTITY, rightEntrys.size());
            this.getModel().beginInit();
            for (Map map : rightEntrys) {
                for (Map.Entry stringLongEntry : map.entrySet()) {
                    this.getModel().setValue(prefx + (String)stringLongEntry.getKey(), stringLongEntry.getValue(), rowIndex);
                }
                ++rowIndex;
            }
            this.getModel().endInit();
        }
    }

    private BaseColumn getRowDimensionByDimenId(List<BaseColumn> baseColumns, long dimId) {
        for (BaseColumn baseColumn : baseColumns) {
            RowDimensionColumn rowDimensionColumn;
            if (!(baseColumn instanceof RowDimensionColumn) || (rowDimensionColumn = (RowDimensionColumn)baseColumn).getDimensionId() != dimId) continue;
            return baseColumn;
        }
        return null;
    }

    private Set<Long> getDefaultMembersByRowsRange(BaseColumn baseColumn, Map<String, Long> viewIds, IModelCacheHelper modelCacheHelper) {
        HashSet<Long> result = new HashSet<Long>(16);
        if (baseColumn instanceof RowDimensionColumn) {
            RowDimensionColumn rowDimensionColumn = (RowDimensionColumn)baseColumn;
            String dimensionNumber = rowDimensionColumn.getDimNumber();
            Long viewId = viewIds.get(dimensionNumber);
            List dimensionMemberRanges = rowDimensionColumn.getDimensionMemberRanges();
            if (dimensionMemberRanges != null && !dimensionMemberRanges.isEmpty()) {
                for (DimensionMemberRange dimensionMemberRange : dimensionMemberRanges) {
                    int range;
                    String memberNumber = dimensionMemberRange.getNumber();
                    List members = modelCacheHelper.getMember(dimensionNumber, viewId, memberNumber, range = Integer.parseInt(dimensionMemberRange.getScope()));
                    if (members == null || members.isEmpty()) continue;
                    for (Member member : members) {
                        if (!member.isLeaf()) continue;
                        result.add(member.getId());
                    }
                }
            }
        }
        return result;
    }

    private Map<String, Set<Long>> getRelationMaps(Map<String, List<Map<String, String>>> rowMemberByFilterDimensionScheme, IModelCacheHelper modelCacheHelper, Map<String, Long> dimViewMap) {
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>(16);
        for (List<Map<String, String>> value : rowMemberByFilterDimensionScheme.values()) {
            for (Map<String, String> map : value) {
                for (Map.Entry<String, String> stringStringEntry : map.entrySet()) {
                    Set memberIds = result.computeIfAbsent(stringStringEntry.getKey(), s -> new HashSet(16));
                    Long elementId = Long.valueOf(stringStringEntry.getValue());
                    Member member = modelCacheHelper.getMember(stringStringEntry.getKey(), dimViewMap.get(stringStringEntry.getKey()), elementId);
                    if (member == null) continue;
                    if (member.isLeaf()) {
                        memberIds.add(member.getId());
                        continue;
                    }
                    List leafs = member.getLeaf().stream().map(s -> s.getId()).collect(Collectors.toList());
                    memberIds.addAll(leafs);
                }
            }
        }
        return result;
    }

    private ApplyTemplateDataInitCfgEntity getApplyTemplateDataInitCfgEntity() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String customParam = (String)formShowParameter.getCustomParam(Cache_DataInitCfgEntity);
        ApplyTemplateDataInitCfgEntity applyTemplateDataInitCfgEntity = (ApplyTemplateDataInitCfgEntity)SerializationUtils.fromJsonString((String)customParam, ApplyTemplateDataInitCfgEntity.class);
        return applyTemplateDataInitCfgEntity;
    }

    private Map<String, String> getDimNumberMapMemberNumber(String data) {
        String[] memberNumbers;
        HashMap<String, String> map = new HashMap<String, String>(16);
        for (String memberNumber : memberNumbers = data.split("!")) {
            String[] value = memberNumber.split("#");
            map.put(value[0], value[1]);
        }
        return map;
    }

    private List<String> getDimKeys() {
        EntryTemplateConfig entityEntryTemplateConfig = this.getEntityEntryTemplateConfig();
        if (entityEntryTemplateConfig == null) {
            return new ArrayList<String>(16);
        }
        ApplyTemplateDataInitCfgEntity applyTemplateDataInitCfgEntity = this.getApplyTemplateDataInitCfgEntity();
        List<BaseColumn> dimBaseColumns = this.getConfigColumns(entityEntryTemplateConfig, applyTemplateDataInitCfgEntity);
        return dimBaseColumns.stream().map(s -> s.getKey()).collect(Collectors.toList());
    }

    public void initialize() {
        super.initialize();
        for (String entryArray : EntryArrays) {
            this.getView().addCustomControls(new String[]{entryArray});
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        this.renderEntryEntityCol(e);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        super.getEntityType(e);
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        this.registerDynamicProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String controlKey = e.getKey();
        if (controlKey.startsWith("h_") || controlKey.startsWith(prefx) && controlKey.contains("h_")) {
            String entryKey = controlKey.startsWith("h_") ? ENTRYENTITY : SEL_ENTRYENTITY;
            EntryAp entryAp = this.getEntryAp(entryKey);
            if (entryAp == null) {
                return;
            }
            List items = entryAp.getItems();
            this.setEntryApplyControls(items, controlKey, e, entryKey);
        } else if (controlKey.contains(ENTRYENTITY)) {
            Control entryControl = e.getControl();
            if (entryControl != null) {
                EntryGrid entryGrid = (EntryGrid)entryControl;
                entryGrid.getItems().removeIf(s -> this.getMap().containsKey(s.getKey()));
                if (entryGrid.getItems().isEmpty()) {
                    EntryAp entryAp = this.getEntryAp(controlKey);
                    if (entryAp == null) {
                        return;
                    }
                    List fieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
                    this.addThisViewToEntryGrid(entryGrid, fieldEdits);
                }
            } else {
                EntryGrid entryGrid = (EntryGrid)this.findControl(controlKey);
                if (entryGrid != null) {
                    entryGrid.getItems().removeIf(s -> this.getMap().containsKey(s.getKey()));
                    if (entryGrid.getItems().isEmpty()) {
                        EntryAp entryAp = this.getEntryAp(controlKey);
                        if (entryAp == null) {
                            return;
                        }
                        List fieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
                        this.addThisViewToEntryGrid(entryGrid, fieldEdits);
                    }
                }
            }
        }
    }

    private void addThisViewToEntryGrid(EntryGrid entryGrid, List<Control> fieldEdits) {
        for (Control fieldEdit : fieldEdits) {
            if (fieldEdit instanceof Container) {
                if (fieldEdit instanceof OperationColumn) {
                    fieldEdit.setView(this.getView());
                } else {
                    this.addThisViewToEntryEditField(((Container)fieldEdit).getItems());
                    fieldEdit.setView(this.getView());
                }
            } else if (fieldEdit != null) {
                fieldEdit.setView(this.getView());
            }
            entryGrid.getItems().add(fieldEdit);
        }
    }

    private void addThisViewToEntryEditField(List<Control> items) {
        for (Control fieldEdit : items) {
            if (fieldEdit instanceof Container) {
                if (!(fieldEdit instanceof OperationColumn)) {
                    this.addThisViewToEntryEditField(((Container)fieldEdit).getItems());
                }
                fieldEdit.setView(this.getView());
                continue;
            }
            if (fieldEdit == null) continue;
            fieldEdit.setView(this.getView());
        }
    }

    private void setEntryApplyControls(List<ControlAp<?>> items, String controlKey, OnGetControlArgs e, String entryKey) {
        for (ControlAp<?> item : items) {
            if (item instanceof EntryFieldAp) {
                EntryFieldAp entryFieldAp = (EntryFieldAp)item;
                String key = entryFieldAp.getKey();
                if (!StringUtils.equals((String)controlKey, (String)key)) continue;
                Field field = entryFieldAp.getField();
                if (field instanceof CheckBoxField) {
                    FieldEdit fieldEdit = new FieldEdit();
                    fieldEdit.setKey(controlKey);
                    fieldEdit.setModel(this.getModel());
                    fieldEdit.setView(this.getView());
                    fieldEdit.setFieldKey(controlKey);
                    fieldEdit.setEntryKey(entryKey);
                    e.setControl((Control)fieldEdit);
                    continue;
                }
                if (field instanceof TextField) {
                    TextEdit textEdit = new TextEdit();
                    textEdit.setKey(controlKey);
                    textEdit.setModel(this.getModel());
                    textEdit.setView(this.getView());
                    textEdit.setFieldKey(controlKey);
                    textEdit.setEntryKey(entryKey);
                    e.setControl((Control)textEdit);
                    continue;
                }
                if (!(field instanceof BasedataField)) continue;
                BasedataEdit bsEdit = new BasedataEdit();
                bsEdit.setKey(controlKey);
                bsEdit.setModel(this.getModel());
                bsEdit.setView(this.getView());
                bsEdit.setFieldKey(controlKey);
                bsEdit.setEntryKey(entryKey);
                e.setControl((Control)bsEdit);
                continue;
            }
            if (!(item instanceof EntryFieldGroupAp)) continue;
            EntryFieldGroupAp entryFieldGroupAp = (EntryFieldGroupAp)item;
            List entryFieldGroupApItems = entryFieldGroupAp.getItems();
            this.setEntryApplyControls(entryFieldGroupApItems, controlKey, e, entryKey);
        }
    }

    private void registerDynamicProps(MainEntityType newMainType) {
        for (String entryKey : EntryArrays) {
            this.registerEntryEntityApplyDynamicProps(newMainType, entryKey);
        }
    }

    private void registerEntryEntityApplyDynamicProps(MainEntityType newMainType, String entryKey) {
        List<ControlAp<?>> entryApItems = this.getEntryApItems(entryKey);
        EntryTemplateConfig entityEntryTemplateConfig = this.getEntityEntryTemplateConfig();
        if (entityEntryTemplateConfig == null) {
            return;
        }
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(entryKey);
        entryType.createPropIndexs();
        for (ControlAp<?> controlAp : entryApItems) {
            if (controlAp instanceof EntryFieldAp) {
                EntryFieldAp entryFieldAp = (EntryFieldAp)controlAp;
                this.registerEntryFieldAp(entryType, entryFieldAp, entityEntryTemplateConfig.getEntryColumns());
                continue;
            }
            if (!(controlAp instanceof EntryFieldGroupAp)) continue;
            EntryFieldGroupAp entryFieldGroupAp = (EntryFieldGroupAp)controlAp;
            List items = entryFieldGroupAp.getItems();
            for (ControlAp item : items) {
                if (!(item instanceof EntryFieldAp)) continue;
                EntryFieldAp entryFieldAp = (EntryFieldAp)item;
                this.registerEntryFieldAp(entryType, entryFieldAp, entityEntryTemplateConfig.getEntryColumns());
            }
        }
    }

    private void registerEntryFieldAp(EntryType entryType, EntryFieldAp entryFieldAp, List<BaseColumn> columns) {
        Optional<BaseColumn> dimColumn;
        Field field = entryFieldAp.getField();
        if (field instanceof TextField) {
            TextProp dynamicTextProp = (TextProp)CustomControlHelper.createDynamicFieldProp((String)entryFieldAp.getKey(), (String)entryFieldAp.getName().toString(), (FieldTypeEnum)FieldTypeEnum.TextField);
            entryType.addProperty((DynamicProperty)dynamicTextProp);
        } else if (field instanceof CheckBoxField) {
            BooleanProp dynamicBooleanProp = (BooleanProp)CustomControlHelper.createDynamicFieldProp((String)entryFieldAp.getKey(), (String)entryFieldAp.getName().toString(), (FieldTypeEnum)FieldTypeEnum.Boolean);
            entryType.addProperty((DynamicProperty)dynamicBooleanProp);
        } else if (field instanceof BasedataField && (dimColumn = columns.stream().filter(s -> field.getKey().contains(s.getKey())).findFirst()).isPresent()) {
            BaseColumn baseColumn = dimColumn.get();
            BasedataProp basedataProp = CustomControlHelper.createDynamicBaseDataProp((String)field.getKey(), (String)baseColumn.getBaseEntityId());
            entryType.addProperty((DynamicProperty)basedataProp);
            entryType.addProperty((DynamicProperty)((LongProp)basedataProp.getRefIdProp()));
        }
    }

    private List<ControlAp<?>> getEntryApItems(String entryKey) {
        EntryTemplateConfig entityEntryTemplateConfig = this.getEntityEntryTemplateConfig();
        if (entityEntryTemplateConfig == null) {
            return new ArrayList(16);
        }
        ApplyTemplateDataInitCfgEntity applyTemplateDataInitCfgEntity = this.getApplyTemplateDataInitCfgEntity();
        List<BaseColumn> dimBaseColumns = this.getConfigColumns(entityEntryTemplateConfig, applyTemplateDataInitCfgEntity);
        EntryAp entryAp = this.createEntryAp(dimBaseColumns, entryKey);
        return entryAp.getItems();
    }

    private void renderEntryEntityCol(LoadCustomControlMetasArgs e) {
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        String paramStr = (String)formShowParameter.getCustomParam("entityEntryTemplateConfig");
        if (paramStr == null) {
            return;
        }
        EntryTemplateConfig entityEntryTemplateConfig = (EntryTemplateConfig)SerializationUtils.fromJsonString((String)paramStr, EntryTemplateConfig.class);
        if (entityEntryTemplateConfig == null) {
            return;
        }
        ApplyTemplateDataInitCfgEntity applyTemplateDataInitCfgEntity = ApplyTemplateDimCfgService.getInstance().getApplyTemplateDataInitCfgEntity(entityEntryTemplateConfig.getTemplateID());
        if (applyTemplateDataInitCfgEntity == null || applyTemplateDataInitCfgEntity.getColumnKeys().isEmpty() || applyTemplateDataInitCfgEntity.getDimIds().isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u914d\u7f6e\u6a21\u677f\u6570\u636e\u521d\u59cb\u5316\u3002", (String)"BgApplyBillDataInitListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        formShowParameter.setCustomParam(Cache_DataInitCfgEntity, (Object)SerializationUtils.toJsonString((Object)applyTemplateDataInitCfgEntity));
        List<BaseColumn> dimBaseColumns = this.getConfigColumns(entityEntryTemplateConfig, applyTemplateDataInitCfgEntity);
        for (String entryKey : EntryArrays) {
            EntryAp entryAp = this.createEntryAp(dimBaseColumns, entryKey);
            this.setEntryApProperties(e, entryAp, entryKey);
        }
    }

    @NotNull
    private List<BaseColumn> getConfigColumns(EntryTemplateConfig entityEntryTemplateConfig, ApplyTemplateDataInitCfgEntity applyTemplateDataInitCfgEntity) {
        ArrayList<BaseColumn> dimBaseColumns = new ArrayList<BaseColumn>(16);
        for (BaseColumn entryColumn : entityEntryTemplateConfig.getEntryColumns()) {
            if (!(entryColumn instanceof RowDimensionColumn)) continue;
            RowDimensionColumn dimensionColumn = (RowDimensionColumn)entryColumn;
            if (!applyTemplateDataInitCfgEntity.getDimIds().contains(dimensionColumn.getDimensionId())) continue;
            dimBaseColumns.add(entryColumn);
        }
        return dimBaseColumns;
    }

    private void setEntryApProperties(LoadCustomControlMetasArgs e, EntryAp entryAp, String entryKey) {
        HashMap<String, String> mapEntry = new HashMap<String, String>(16);
        mapEntry.put("id", entryKey);
        mapEntry.put("columns", (String)entryAp.createControl().get("columns"));
        e.getItems().add(mapEntry);
    }

    private EntryAp createEntryAp(List<BaseColumn> columns, String entrykey) {
        List<ControlAp<?>> entryFieldAps = this.buildEntryFields(columns, entrykey);
        EntryAp entryAp = new EntryAp();
        entryAp.setKey(entrykey);
        entryAp.setOrderAndFilter(0);
        entryAp.setShowSeq(true);
        entryAp.setSplitPage(true);
        entryAp.setPageRow(100);
        entryAp.getItems().addAll(entryFieldAps);
        return entryAp;
    }

    private EntryAp getEntryAp(String entryKey) {
        EntryTemplateConfig entityEntryTemplateConfig = this.getEntityEntryTemplateConfig();
        if (entityEntryTemplateConfig == null) {
            return null;
        }
        ApplyTemplateDataInitCfgEntity applyTemplateDataInitCfgEntity = this.getApplyTemplateDataInitCfgEntity();
        List<BaseColumn> dimBaseColumns = this.getConfigColumns(entityEntryTemplateConfig, applyTemplateDataInitCfgEntity);
        EntryAp entryAp = this.createEntryAp(dimBaseColumns, entryKey);
        return entryAp;
    }

    private List<ControlAp<?>> buildEntryFields(List<BaseColumn> columns, String entrykey) {
        ArrayList entryFieldAps = new ArrayList(16);
        String prefxx = "";
        if (entrykey.equals(SEL_ENTRYENTITY)) {
            prefxx = prefx;
        }
        for (BaseColumn column : columns) {
            String key = column.getKey();
            key = prefxx + key;
            EntryFieldAp entryFieldAp = CustomControlHelper.createEntryFieldAp((String)key, (String)column.getTitle(), (FieldTypeEnum)FieldTypeEnum.BaseDataField);
            BasedataField baseDataField = (BasedataField)entryFieldAp.getField();
            baseDataField.setBaseEntityId(column.getBaseEntityId());
            entryFieldAps.add((ControlAp<?>)entryFieldAp);
        }
        return entryFieldAps;
    }

    private void setEntryEntityFocusRow(int row) {
        if (row < 0) {
            return;
        }
        EntryGrid entryentity = (EntryGrid)this.getControl(ENTRYENTITY);
        entryentity.getEntryState().setFocusRow(row);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addBaseDataListener();
        Button addsel = (Button)this.getControl(BTN_ADDSEL);
        addsel.addClickListener((ClickListener)this);
        Button removesel = (Button)this.getControl(BTN_REMOVESEL);
        removesel.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (StringUtils.equals((String)key, (String)BTN_ADDSEL)) {
            this.addSelect();
        } else if (StringUtils.equals((String)key, (String)BTN_REMOVESEL)) {
            this.removeSelect();
        }
    }

    private void removeSelect() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(SEL_ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u8981\u79fb\u9664\u7684\u6570\u636e\u3002", (String)"BgApplyBillDataInitListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        DynamicObjectCollection selentrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(SEL_ENTRYENTITY);
        int i = entrys.size();
        this.getModel().batchCreateNewEntryRow(ENTRYENTITY, selectRows.length);
        List<String> dimKeys = this.getDimKeys();
        for (int selectRow : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)selentrys.get(selectRow);
            for (String dimKey : dimKeys) {
                this.getModel().setValue(dimKey, (Object)dynamicObject.getLong(prefx + dimKey + ".id"), i);
            }
            ++i;
        }
        this.getModel().deleteEntryRows(SEL_ENTRYENTITY, selectRows);
    }

    private void addSelect() {
        DynamicObject dynamicObject;
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u8981\u6dfb\u52a0\u7684\u6570\u636e\u3002", (String)"BgApplyBillDataInitListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        DynamicObjectCollection selentrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(SEL_ENTRYENTITY);
        int i = selentrys.size();
        this.getModel().batchCreateNewEntryRow(SEL_ENTRYENTITY, selectRows.length);
        List<String> dimKeys = this.getDimKeys();
        HashSet<String> validateEmptyindexs = new HashSet<String>(16);
        block0: for (int selectRow : selectRows) {
            dynamicObject = (DynamicObject)entrys.get(selectRow);
            for (String dimKey : dimKeys) {
                Long sid = dynamicObject.getLong(dimKey + ".id");
                if (sid != null && sid != 0L) continue;
                validateEmptyindexs.add(String.valueOf(selectRow + 1));
                continue block0;
            }
        }
        if (!validateEmptyindexs.isEmpty()) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u7b2c%1\u884c\uff0c\u7ef4\u5ea6\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BgApplyBillDataInitListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", validateEmptyindexs)}));
        }
        for (int selectRow : selectRows) {
            dynamicObject = (DynamicObject)entrys.get(selectRow);
            for (String dimKey : dimKeys) {
                this.getModel().setValue(prefx + dimKey, (Object)dynamicObject.getLong(dimKey + ".id"), i);
            }
            ++i;
        }
        this.getModel().deleteEntryRows(ENTRYENTITY, selectRows);
    }

    private void addBaseDataListener() {
        EntryTemplateConfig entityEntryTemplateConfig = this.getEntityEntryTemplateConfig();
        if (entityEntryTemplateConfig == null) {
            return;
        }
        ApplyTemplateDataInitCfgEntity applyTemplateDataInitCfgEntity = this.getApplyTemplateDataInitCfgEntity();
        List<BaseColumn> dimBaseColumns = this.getConfigColumns(entityEntryTemplateConfig, applyTemplateDataInitCfgEntity);
        for (BaseColumn dimBaseColumn : dimBaseColumns) {
            BasedataEdit basedataEdit;
            if (dimBaseColumn.getType() != ColumnEnum.RowDimension || (basedataEdit = (BasedataEdit)this.getControl(dimBaseColumn.getKey())) == null) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        if (StringUtils.equals((String)opKey, (String)"btn_ok")) {
            DynamicObjectCollection selentrys = this.getModel().getDataEntity(true).getDynamicObjectCollection(SEL_ENTRYENTITY);
            if (selentrys.size() == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u8981\u521d\u59cb\u5316\u7684\u884c\u3002", (String)"BgApplyBillDataInitListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            EntryTemplateConfig entityEntryTemplateConfig = this.getEntityEntryTemplateConfig();
            List<Object> dimBaseColumns = new ArrayList(16);
            if (entityEntryTemplateConfig != null) {
                ApplyTemplateDataInitCfgEntity applyTemplateDataInitCfgEntity = this.getApplyTemplateDataInitCfgEntity();
                dimBaseColumns = this.getConfigColumns(entityEntryTemplateConfig, applyTemplateDataInitCfgEntity);
            }
            HashMap<String, String> columnKeyMapDimnumber = new HashMap<String, String>(16);
            for (BaseColumn dimBaseColumn : dimBaseColumns) {
                if (dimBaseColumn.getType() != ColumnEnum.RowDimension) continue;
                RowDimensionColumn rowDimensionColumn = (RowDimensionColumn)dimBaseColumn;
                columnKeyMapDimnumber.put(dimBaseColumn.getKey(), rowDimensionColumn.getDimNumber());
            }
            ArrayList values = new ArrayList(16);
            for (DynamicObject row : selentrys) {
                HashMap<String, String> value = new HashMap<String, String>(16);
                for (Map.Entry map : columnKeyMapDimnumber.entrySet()) {
                    String key = (String)map.getKey();
                    String dimNumber = (String)map.getValue();
                    String memberNumber = row.getString(prefx + key + ".number");
                    value.put(dimNumber, memberNumber);
                }
                values.add(value);
            }
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(values));
            this.getView().close();
        } else if (StringUtils.equals((String)opKey, (String)"btn_addrow")) {
            this.getModel().createNewEntryRow(ENTRYENTITY);
        } else if (StringUtils.equals((String)opKey, (String)"btn_delrow")) {
            EntryGrid entrygrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
            int[] selectRows = entrygrid.getSelectRows();
            if (selectRows == null || selectRows.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u884c\u3002", (String)"BgApplyBillDataInitListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            this.getModel().deleteEntryRows(ENTRYENTITY, selectRows);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        EntryTemplateConfig entityEntryTemplateConfig = this.getEntityEntryTemplateConfig();
        log.info("BgApplyBillDataInitListPlugin.ApplyDataInitF7:map.get(name):" + SerializationUtils.toJsonString((Object)entityEntryTemplateConfig));
        if (entityEntryTemplateConfig != null) {
            for (BaseColumn column : entityEntryTemplateConfig.getEntryColumns()) {
                if (column.getType() != ColumnEnum.RowDimension) continue;
                RowDimensionColumn dimensionColumn = (RowDimensionColumn)column;
                String dimNumber = dimensionColumn.getDimNumber();
                String name = beforeF7SelectEvent.getProperty().getName();
                log.info("BgApplyBillDataInitListPlugin.ApplyDataInitF7:name:" + name);
                log.info("BgApplyBillDataInitListPlugin.ApplyDataInitF7:dimNumber:" + dimNumber);
                if (!StringUtils.equals((String)name, (String)column.getKey())) continue;
                this.beforeFilterDimensionF7(dimNumber, dimensionColumn.getBussinessModelId(), dimensionColumn.getDimensionMemberRanges(), beforeF7SelectEvent);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
    }

    private void beforeFilterDimensionF7(String dimensionNumber, Long busModelId, List<DimensionMemberRange> dimensionMemberRanges, BeforeF7SelectEvent arg) {
        Set<Object> allMemberNumbers = new HashSet(16);
        Long bussModelId = 0L;
        if (dimensionNumber == null) {
            return;
        }
        Long viewId = null;
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        DynamicObject dataset = BusinessDataServiceHelper.loadSingle((Object)busModelId, (String)"eb_dataset");
        if (dataset != null) {
            DynamicObject bussRangeModel = dataset.getDynamicObject("businessmodel");
            bussModelId = bussRangeModel.getLong("id");
            Map viewIds = BusinessModelServiceHelper.getViewIds((Long)bussRangeModel.getLong("id"));
            viewId = (Long)viewIds.get(dimensionNumber);
            if (dimensionMemberRanges != null && !dimensionMemberRanges.isEmpty()) {
                for (DimensionMemberRange dimensionMemberRange : dimensionMemberRanges) {
                    int range;
                    String memberNumber = dimensionMemberRange.getNumber();
                    List members = modelCacheHelper.getMember(dimensionNumber, viewId, memberNumber, range = Integer.parseInt(dimensionMemberRange.getScope()));
                    if (members == null || members.isEmpty()) continue;
                    for (Member member : members) {
                        allMemberNumbers.add(member.getNumber());
                    }
                }
            }
        }
        List leafMembers = modelCacheHelper.getMembers(viewId, dimensionNumber).stream().filter(Member::isLeaf).map(BaseCache::getNumber).collect(Collectors.toList());
        allMemberNumbers = allMemberNumbers.stream().filter(leafMembers::contains).collect(Collectors.toSet());
        Long modelId = this.getModelId();
        MemberF7Parameter f7Param = NewF7Utils.multipleF7((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)dimensionNumber), (String)ListSelectedRow.class.getName());
        f7Param.setBusModelId(bussModelId);
        if (SysDimensionEnum.Account.getNumber().equals(dimensionNumber)) {
            f7Param.setDatasetId(busModelId);
        }
        if (IDUtils.isNotNull((Long)viewId)) {
            f7Param.setViewId(viewId);
        }
        f7Param.addCustomFilter(new QFilter("number", "in", allMemberNumbers));
        Map<String, Set<Long>> members = this.getMembers(this.getEntityEntryTemplateConfig(), dimensionNumber, modelCacheHelper);
        if (!members.isEmpty()) {
            f7Param.setCombPermMap(members);
        }
        NewF7Utils.openF7((BeforeF7SelectEvent)arg, (MemberF7Parameter)f7Param);
    }

    public String getCurrentDimNumber(String controlKey) {
        log.info("BgApplyBillDataInitListPlugin.ApplyDataInitF7:getCurrentDimNumber:controlKey:" + controlKey);
        log.info("BgApplyBillDataInitListPlugin.ApplyDataInitF7:getCurrentDimNumber:map.get(controlKey):" + this.getMap().get(controlKey));
        return this.getMap().get(controlKey);
    }

    private Map<String, Set<Long>> getMembers(EntryTemplateConfig entryTemplateConfig, String dimensionNumber, IModelCacheHelper modelCacheHelper) {
        HashMap<String, Set<Long>> combMembers = new HashMap<String, Set<Long>>(16);
        Set refDimGroupNums = DimMembPermHelper.getRefDimGroupNums((Long)this.getModelId(), (String)dimensionNumber);
        ApplyTemplateDataInitCfgEntity applyTemplateDataInitCfgEntity = this.getApplyTemplateDataInitCfgEntity();
        ArrayList dimgroups = new ArrayList(refDimGroupNums.size());
        modelCacheHelper.getDimensionList().stream().filter(s -> applyTemplateDataInitCfgEntity.getDimIds().contains(s.getId())).forEach(dimension -> {
            if (refDimGroupNums.contains(dimension.getNumber())) {
                dimgroups.add(dimension.getNumber());
            }
        });
        if (!dimgroups.isEmpty()) {
            String entityKey = ENTRYENTITY;
            int rowIndex = this.getModel().getEntryCurrentRowIndex(entityKey);
            if (rowIndex < 0) {
                return combMembers;
            }
            DynamicObject rowObj = this.getModel().getEntryRowEntity(entityKey, rowIndex);
            if (rowObj == null) {
                return combMembers;
            }
            if (entryTemplateConfig == null) {
                return combMembers;
            }
            List columns = entryTemplateConfig.getEntryColumns().stream().filter(s -> s instanceof RowDimensionColumn).collect(Collectors.toList());
            for (String refDimGroupNum : dimgroups) {
                HashSet<Long> members = new HashSet<Long>(16);
                long id = 0L;
                for (BaseColumn baseColumn : columns) {
                    String columnKey;
                    DynamicObject entityObj;
                    RowDimensionColumn rowColumn = (RowDimensionColumn)baseColumn;
                    if (!refDimGroupNum.equals(rowColumn.getDimNumber()) || (entityObj = rowObj.getDynamicObject(columnKey = rowColumn.getKey().toLowerCase())) == null) continue;
                    id = entityObj.getLong("id");
                }
                if (id == 0L) continue;
                members.add(id);
                combMembers.put(refDimGroupNum, members);
            }
        }
        return combMembers;
    }

    private EntryTemplateConfig getEntityEntryTemplateConfig() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String paramStr = (String)formShowParameter.getCustomParam("entityEntryTemplateConfig");
        if (paramStr != null) {
            return (EntryTemplateConfig)SerializationUtils.fromJsonString((String)paramStr, EntryTemplateConfig.class);
        }
        return null;
    }

    @Override
    public Long getModelId() {
        Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("modelId"));
        if (modelId == null || modelId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4f53\u7cfb\u4fe1\u606f\u5931\u8d25\u3002", (String)"BgApplyBillPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return modelId;
    }

    private Control findControl(String key) {
        FormRoot root = (FormRoot)this.getView().getRootControl();
        return this.findControl(key, root.getItems());
    }

    private Control findControl(String key, List<Control> items) {
        for (Control ctl : items) {
            Control subCtl;
            if (StringUtils.equals((String)key, (String)ctl.getKey())) {
                return ctl;
            }
            if (!(ctl instanceof Container) || (subCtl = this.findControl(key, ((Container)ctl).getItems())) == null) continue;
            return subCtl;
        }
        return null;
    }

    private Map<String, Set<Long>> getMembers(EntryTemplateConfig entryTemplateConfig, String dimensionNumber, IModelCacheHelper modelCacheHelper, RowDimensionColumn column) {
        HashMap<String, Set<Long>> combMembers = new HashMap<String, Set<Long>>(16);
        return combMembers;
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
    }

    private Long getOrg() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long org = (Long)formShowParameter.getCustomParam("org");
        return org;
    }

    private Set<String> getGroupPermMember(EntryTemplateConfig entryConfig, IModelCacheHelper modelCacheHelper, Map<String, Map<String, Object>> datamap, Map<String, Long> viewIds) {
        HashSet<String> results = new HashSet<String>(16);
        ArrayList<BaseColumn> measureCols = new ArrayList<BaseColumn>(16);
        List entryColumns = entryConfig.getEntryColumns();
        List columns = entryColumns.stream().filter(ee -> !ee.getKey().endsWith("_text")).collect(Collectors.toList());
        for (BaseColumn column : columns) {
            if (column.getType() != ColumnEnum.Measure && column.getType() != ColumnEnum.DimensionData) continue;
            measureCols.add(column);
        }
        Map allColDimMembers = BgApplyBillUtils.getInstance().getAllColDimMemberIds(measureCols, modelCacheHelper);
        Map hideDimMembers = entryConfig.getHiddenDimMemMap();
        for (Map.Entry<String, Map<String, Object>> map : datamap.entrySet()) {
            String key = map.getKey();
            Map<String, Object> colMap = map.getValue();
            Set<String> colkeys = colMap.keySet();
            String[] dimMember = key.split("!");
            HashMap<String, Long> rowMemMap = new HashMap<String, Long>(16);
            for (String s : dimMember) {
                String[] split = s.split("#");
                String dimNumber = split[0];
                String memberNumber = split[1];
                Member member = modelCacheHelper.getMember(dimNumber, viewIds.get(dimNumber), memberNumber);
                if (member == null) continue;
                rowMemMap.put(dimNumber, member.getId());
            }
            boolean exitHasPerm = false;
            for (String colkey : colkeys) {
                Map colDimMembers = (Map)allColDimMembers.get(colkey);
                if (colDimMembers == null) continue;
                colDimMembers.entrySet().removeIf(e -> rowMemMap.containsKey(e.getKey()) && (Long)e.getValue() == 0L);
                HashMap<String, Long> mergedDimMembers = new HashMap<String, Long>(rowMemMap);
                mergedDimMembers.putAll(colDimMembers);
                mergedDimMembers.putAll(hideDimMembers);
                exitHasPerm = this.filterPermRead(mergedDimMembers, entryConfig.getDatasetId(), modelCacheHelper);
                if (!exitHasPerm) continue;
                break;
            }
            if (!exitHasPerm) continue;
            results.add(key);
        }
        return results;
    }

    private Boolean filterPermRead(Map<String, Long> dimMap, long datasetId, IModelCacheHelper modelCache) {
        Long modelId = modelCache.getModelobj().getId();
        DimMemberPermChecker readPermChecker = DimMembPermHelper.getReadPermChecker((Long)modelId, (Long)datasetId);
        if (readPermChecker.hasAllPerm()) {
            return true;
        }
        HashMap<String, MemberItem> memberGroup = new HashMap<String, MemberItem>(16);
        for (Map.Entry<String, Long> dimEntry : dimMap.entrySet()) {
            MemberItem mi = new MemberItem(true, dimEntry.getValue());
            memberGroup.put(dimEntry.getKey(), mi);
        }
        boolean check = readPermChecker.check(memberGroup);
        log.info("BgApplyBillDataInitListPlugin.filterPermRead--\u8bfb\u6743\u9650\u8fc7\u6ee4\uff1a" + SerializationUtils.toJsonString(dimMap) + "----result:" + check);
        return check;
    }
}

