/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyBillPluginUitl;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.applybill.util.BgApplyBillHelper;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateColCfgService;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateDimCfgService;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateDimRangeService;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.applyTemplate.constants.ColCfgPropEnum;
import kd.epm.eb.common.applyTemplate.constants.DimUseTypeEnum;
import kd.epm.eb.common.applyTemplate.constants.FormTypeEnum;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateBizRange;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateDimCfgEntity;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateDimensionRelation;
import kd.epm.eb.common.applybill.ApplyBillConstant;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.applybill.BillFieldStatus;
import kd.epm.eb.common.applybill.BillSaveEventArgs;
import kd.epm.eb.common.applybill.BillVerifyResult;
import kd.epm.eb.common.applybill.EntityRowDataType;
import kd.epm.eb.common.applybill.SchemeAssignDimGroup;
import kd.epm.eb.common.applytemplatecolumn.ApplyTemplateModel;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.BgApplyENtryInfo;
import kd.epm.eb.common.applytemplatecolumn.BizEntryCacheData;
import kd.epm.eb.common.applytemplatecolumn.CalculateColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnEnum;
import kd.epm.eb.common.applytemplatecolumn.DataMapDimension;
import kd.epm.eb.common.applytemplatecolumn.DimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.DimensionDataColumn;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.applytemplatecolumn.FieldTypeEnum;
import kd.epm.eb.common.applytemplatecolumn.MeasureColumn;
import kd.epm.eb.common.applytemplatecolumn.NumberColumn;
import kd.epm.eb.common.applytemplatecolumn.RelationDimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.SimpleDynamicObject;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.formula.ExpressionContext;
import kd.epm.eb.common.formula.ExpressionParseHelper;
import kd.epm.eb.common.formula.Iexpression;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DateTimeUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.applybill.BgApplyBillBasePlugin;
import kd.epm.eb.formplugin.applybill.IApApplyCollectBill;
import kd.epm.eb.formplugin.applybill.fileImport.BgApplyAuditDataExportPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class BgApplyBillPluginNew
extends BgApplyBillBasePlugin
implements IApApplyCollectBill {
    protected Map<Long, List<ApplyTemplateBizRange>> batchTemplateDimRange = new HashMap<Long, List<ApplyTemplateBizRange>>(16);

    @Override
    protected void doCheckBeforeSave(BillVerifyResult verifyResult) {
        super.doCheckBeforeSave(verifyResult);
        this.checkRowDimComplete(verifyResult);
        this.checkBizMustInput(verifyResult);
        this.checkMinMustInput(verifyResult);
        this.checkBillNumberRepeat(verifyResult);
        if (verifyResult.isSuccess()) {
            boolean hasError = this.checkSameDimGroupEntry();
            verifyResult.setSuccess(!hasError && this.checkSchemeAssgin() != false);
        }
    }

    private void checkMinMustInput(BillVerifyResult verifyResult) {
        BgApplyENtryInfo entryInfoFromFormParam = this.getEntryInfoFromFormParam();
        Map templateConfig = entryInfoFromFormParam.getEntryTemplateConfig();
        for (Map.Entry configEntry : templateConfig.entrySet()) {
            if (!((String)configEntry.getKey()).startsWith("entryentity")) continue;
            List<String> enableEditCols = this.getEnableEditCols((String)configEntry.getKey());
            EntryTemplateConfig entryTemplateConfig = (EntryTemplateConfig)templateConfig.get(configEntry.getKey());
            List entryColumns = entryTemplateConfig.getEntryColumns();
            DynamicObjectCollection entity = this.getModel().getEntryEntity((String)configEntry.getKey());
            List enableEditCollect = entryColumns.stream().filter(e -> enableEditCols.contains(e.getKey()) && (e instanceof DimensionDataColumn || e instanceof NumberColumn)).collect(Collectors.toList());
            for (int i = 0; i < entity.size(); ++i) {
                if (((DynamicObject)entity.get(i)).getBoolean(entryTemplateConfig.getSubtotalKey())) continue;
                for (BaseColumn column : enableEditCollect) {
                    Object val;
                    if (!column.getIsmustinput().booleanValue() || !column.isEnable() || !column.isBaseVisible() || column.getIspullfrommodel() || !((val = ((DynamicObject)entity.get(i)).get(column.getKey())) == null || val instanceof Long && val.equals(0L) || val instanceof String && StringUtils.isEmpty((CharSequence)((String)val)) || val instanceof BigDecimal && ((BigDecimal)val).doubleValue() == 0.0) && (!(val instanceof Integer) || (Integer)val != 0)) continue;
                    String errMessage = ResManager.loadResFormat((String)"\u6a21\u677f\u201c%1\u201d\u4e2d\u7b2c%2\u884c\u7684\u9884\u7b97\u7533\u62a5\u4fe1\u606f\u7b2c\u5b58\u5728\u201c%3\u201d\u5fc5\u5f55\u9879\u672a\u586b\u3002", (String)"BgApplyBillPluginNew_6", (String)"epm-eb-formplugin", (Object[])new Object[]{entryTemplateConfig.getName(), i + 1, column.getTitle()});
                    verifyResult.addResutInfo(errMessage);
                }
            }
        }
        if (verifyResult.getResultInfo().size() > 0) {
            verifyResult.setSuccess(false);
            verifyResult.setCancel(true);
        }
    }

    @Override
    protected void afterInitEntityData() {
        super.afterInitEntityData();
    }

    private boolean isAutoOpenBusinessPlan(Long templateId) {
        return CollectionUtils.isNotEmpty(this.getBusinessPlanDimCfgList(templateId));
    }

    private List<ApplyTemplateDimCfgEntity> getBusinessPlanDimCfgList(Long templateId) {
        ArrayList<ApplyTemplateDimCfgEntity> dimCfgEntities = new ArrayList<ApplyTemplateDimCfgEntity>(16);
        List dimCfgListByTemplateId = ApplyTemplateDimCfgService.getInstance().getDimCfgListByTemplateId(templateId.longValue());
        if (CollectionUtils.isEmpty((Collection)dimCfgListByTemplateId)) {
            return dimCfgEntities;
        }
        for (ApplyTemplateDimCfgEntity applyTemplateDimCfgEntity : dimCfgListByTemplateId) {
            String usetype = applyTemplateDimCfgEntity.getUsetype();
            if (!StringUtils.equals((CharSequence)DimUseTypeEnum.BUSINESS_PLAN.getValue(), (CharSequence)usetype)) continue;
            dimCfgEntities.add(applyTemplateDimCfgEntity);
        }
        return dimCfgEntities;
    }

    @Override
    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        int row = evt.getRow();
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        String entryname = entryGrid.getEntryKey();
        this.refreshBizPlanTabs(row, entryname);
        this.entryentityRowClickToRefreshBizEntry(row, entryname);
    }

    private boolean checkSameDimGroupEntry() {
        boolean flag = false;
        Map entryTemplateConfig = this.getEntryInfoFromFormParam().getEntryTemplateConfig();
        Object pkValue = this.getValue("id", null);
        if (pkValue == null || pkValue.equals(0L)) {
            pkValue = GlobalIdUtil.genGlobalLongId();
            this.getModel().setValue("id", pkValue);
        }
        ArrayList showTipInfo = new ArrayList(16);
        for (Map.Entry entry : entryTemplateConfig.entrySet()) {
            String entryKey = (String)entry.getKey();
            EntryTemplateConfig entryTempCfg = (EntryTemplateConfig)entry.getValue();
            DynamicObject template = BusinessDataServiceHelper.loadSingleFromCache((Object)entryTempCfg.getTemplateID(), (String)"eb_applytemplate");
            if (!entryKey.startsWith("entryentity")) continue;
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryKey);
            ArrayList<String> entrydimgrp = new ArrayList<String>(16);
            List dimKeysList = entryTempCfg.getDimKeysList();
            HashMap<String, String> entryinfo = new HashMap<String, String>(16);
            Map columnMapDimNum = entryTempCfg.selectColumnMapDimNum();
            for (DynamicObject entrydata : entryEntity) {
                ArrayList<Pair> dimGroup = new ArrayList<Pair>(16);
                String entrydimgrpstr = "dim";
                for (String fieldname : dimKeysList) {
                    DynamicObject dynamicObject = entrydata.getDynamicObject(fieldname);
                    entrydimgrpstr = entrydimgrpstr + (dynamicObject == null ? "_0" : "_" + dynamicObject.getPkValue().toString());
                    if (columnMapDimNum == null || dynamicObject == null) continue;
                    dimGroup.add(new Pair(columnMapDimNum.get(fieldname), (Object)dynamicObject.getLong("id")));
                }
                entrydimgrp.add(entrydimgrpstr);
                Set entryInfoSet = entryinfo.keySet();
                if (entryInfoSet.contains(entrydimgrpstr)) {
                    String[] entrydimgrpstrSplit = entrydimgrpstr.split("_");
                    int zeroColumnCount = 0;
                    for (String s : entrydimgrpstrSplit) {
                        if (!StringUtils.equals((CharSequence)s, (CharSequence)"0")) continue;
                        ++zeroColumnCount;
                    }
                    if (entrydimgrpstrSplit.length - 1 == zeroColumnCount) continue;
                    HashMap<String, String> showInfo = new HashMap<String, String>(16);
                    showTipInfo.add(showInfo);
                    showInfo.put("dimGroup", SerializationUtils.serializeToBase64(dimGroup));
                    showInfo.put("template", template.getString("id"));
                    showInfo.put("rowindex", entrydata.getString("seq"));
                    showInfo.put("conflictbillno", this.getBillNumber());
                    showInfo.put("conflictentity", String.valueOf(this.getBgOrgId()));
                }
                entryinfo.put(entrydimgrpstr, entrydata.getString("seq"));
            }
            Long schemeId = this.getSchemeId();
            QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
            filter.and("applyscheme", "=", (Object)schemeId).and("id", "!=", pkValue);
            filter.and("year", "=", (Object)this.getYearId());
            filter.and("version", "=", (Object)this.getVersionId());
            filter.and("datatype", "=", (Object)this.getDataTypeId());
            Map applyBillMap = BusinessDataServiceHelper.loadFromCache((String)"eb_bgapplybill", (QFilter[])filter.toArray());
            if (applyBillMap == null || applyBillMap.size() <= 0) continue;
            String tablename = entryTempCfg.getEntryTable();
            StringBuilder selectStr = new StringBuilder("SELECT fid");
            for (String str : dimKeysList) {
                selectStr.append(",f").append(str);
            }
            selectStr.append(" FROM ").append(tablename).append(" t WHERE t.fid in ");
            selectStr.append("(");
            for (Object o : applyBillMap.keySet()) {
                selectStr.append('\'').append(o.toString()).append('\'').append(',');
            }
            selectStr.setCharAt(selectStr.length() - 1, ')');
            ArrayList<String> selectdimgrp = new ArrayList<String>(16);
            HashMap<String, String> dimgrpIdMap = new HashMap<String, String>(16);
            ArrayList<Pair> dimGroup = new ArrayList<Pair>(16);
            try (DataSet ds = this.queryDataSet("setEntryEntiryDefaultValue", selectStr.toString());){
                while (ds != null && ds.hasNext()) {
                    StringBuilder selectstr = new StringBuilder("dim");
                    Row row = ds.next();
                    for (String coll : dimKeysList) {
                        selectstr.append("_").append(row.get("f" + coll));
                        if (columnMapDimNum == null) continue;
                        dimGroup.add(new Pair(columnMapDimNum.get(coll), (Object)ConvertUtils.toLong((Object)row.get("f" + coll))));
                    }
                    dimgrpIdMap.put(selectstr.toString(), row.getString("fid"));
                    selectdimgrp.add(selectstr.toString());
                }
            }
            selectdimgrp.retainAll(entrydimgrp);
            if (selectdimgrp.size() <= 0) continue;
            for (String s : selectdimgrp) {
                DynamicObject dynamicObject;
                HashMap<String, String> showInfo = new HashMap<String, String>(16);
                String billId = (String)dimgrpIdMap.get(s);
                if (!StringUtils.isNotEmpty((CharSequence)billId) || (dynamicObject = (DynamicObject)applyBillMap.get(Long.parseLong(billId))) == null || dynamicObject.getDynamicObject("org") == null) continue;
                showInfo.put("conflictentity", dynamicObject.getDynamicObject("org").getString("id"));
                showInfo.put("conflictbillno", dynamicObject.getString("billnumber"));
                showInfo.put("rowindex", (String)entryinfo.get(s));
                showInfo.put("template", template.getString("id"));
                showTipInfo.add(showInfo);
            }
        }
        if (showTipInfo.size() != 0) {
            FormShowParameter formShowParameter = BgApplyBillHelper.getInstance().getClearDataTipFormShowParam(showTipInfo, new CloseCallBack((IFormPlugin)this, "clearData"));
            this.getView().showForm(formShowParameter);
            return true;
        }
        return flag;
    }

    private DataSet queryDataSet(String algoKey, String sql) {
        return DB.queryDataSet((String)algoKey, (DBRoute)BgBaseConstant.epm, (String)sql);
    }

    private List<Integer> getNeedDeleteRows(DynamicObjectCollection rows, EntryTemplateConfig templateconfig) {
        List columns = templateconfig.getEntryColumns();
        ArrayList<Integer> rowsindex = new ArrayList<Integer>(16);
        if (rows.size() > 0) {
            for (int i = 0; i < rows.size(); ++i) {
                DynamicObject row = (DynamicObject)rows.get(i);
                Boolean isremove = true;
                for (BaseColumn column : columns) {
                    String field;
                    Object value;
                    Boolean isnext = false;
                    switch (column.getType().getValue()) {
                        case 2: 
                        case 3: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 10: 
                        case 12: {
                            isnext = true;
                        }
                    }
                    if (!isnext.booleanValue() || "".equals(value = row.get(field = column.getKey())) || value == null || "0".equals(String.valueOf(value))) continue;
                    isremove = false;
                    break;
                }
                if (!isremove.booleanValue()) continue;
                rowsindex.add(i);
            }
        }
        return rowsindex;
    }

    @Override
    protected void setButtonStatus(BillFieldStatus fieldStatus) {
        super.setButtonStatus(fieldStatus);
        fieldStatus.addShowKeys(new String[]{"btn_datainit"});
        String billStatus = (String)this.getValue("billstatus", null);
        List<String> billstatusArr = Arrays.asList("A", "E");
        if (billstatusArr.contains(billStatus)) {
            fieldStatus.addShowKeys(new String[]{"hidesubtotal", "showsubtotal"});
        }
        fieldStatus.addHideKeys(ApplyBillConstant.btns_saveentity);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_viewadj);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_queryplan);
        fieldStatus.addHideKeys(new String[]{"btn_viewappbill", "btn_selappbill"});
        if (!this.isAddNewForm()) {
            fieldStatus.addHideKeys(new String[]{"btn_c_view", "btn_viewappbill", "btn_selappbill"});
        }
    }

    @Override
    protected void setCtrlStatusByBillStatus(BillFieldStatus fieldStatus) {
        super.setCtrlStatusByBillStatus(fieldStatus);
        String billStatus = (String)this.getValue("billstatus", null);
        if (billStatus.equals("C")) {
            this.updateStatusForSubmit(fieldStatus);
        } else if (billStatus.equals("A") || billStatus.equals("E")) {
            this.updateStatusForUnSubmit(fieldStatus);
        } else {
            fieldStatus.addHideKeys(new String[]{"submit", "unsubmit", "save", "btn_datainit"});
        }
    }

    @Override
    public void dealPropertyChanged(PropertyChangedArgs e) {
        this.handleBusinessPlanPropChange(e);
        this.rowDimensionChangeBizPlanTabs(e);
    }

    private void handleBusinessPlanPropChange(PropertyChangedArgs e) {
        this.busPlanDetailChange(e);
        this.handleBusinessPlanDimCfg(e);
    }

    private void handleBusinessPlanDimCfg(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        String name = e.getProperty().getName();
        int rowIndex = changeSet[0].getRowIndex();
        Object newValue = changeSet[0].getNewValue();
        DynamicObject dataEntity = changeSet[0].getDataEntity();
        String entityName = changeSet[0].getDataEntity().getDataEntityType().getName();
        if (!entityName.startsWith("entryentity")) {
            return;
        }
        this.autoOpenOrCloseBusinessPlan(newValue, entityName, rowIndex, name, dataEntity);
    }

    private void autoOpenOrCloseBusinessPlan(Object currentDimColDynamicObj, String entityName, int rowIndex, String colKey, DynamicObject dataEntity) {
        boolean flag;
        Map entryTemplateConfigMap = this.getEntryInfoFromFormParam().getEntryTemplateConfig();
        EntryTemplateConfig entryTemplateConfig = (EntryTemplateConfig)entryTemplateConfigMap.get(entityName);
        long templateID = entryTemplateConfig.getTemplateID();
        if (!this.isAutoOpenBusinessPlan(templateID)) {
            return;
        }
        String busPlanDetailKey = entryTemplateConfig.getBusPlanDetailKey();
        List dimKeysList = entryTemplateConfig.getDimKeysList();
        String busPlanDetailRowInfo = this.getView().getPageCache().get("combinedimension" + entityName);
        EntryTemplateConfig bizEntryTempCfg = (EntryTemplateConfig)entryTemplateConfigMap.get("biz" + entityName);
        if (!dimKeysList.contains(colKey)) {
            return;
        }
        this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{busPlanDetailKey});
        if (!(currentDimColDynamicObj instanceof DynamicObject)) {
            this.getModel().setValue(busPlanDetailKey, (Object)false, rowIndex);
            this.refreshBizEntryDataAndPutCombineInfo(dataEntity, entityName, true);
            this.removeBizEntryRowsToCache("biz" + entityName, busPlanDetailRowInfo, bizEntryTempCfg.getCombineDimensionKey(), false, "", "");
            return;
        }
        DynamicObject dynamicObject = (DynamicObject)currentDimColDynamicObj;
        long currentDimMemberId = dynamicObject.getLong("id");
        String currentDimNumber = dynamicObject.getDynamicObject("dimension").getString("number");
        long templateId = entryTemplateConfig.getTemplateID();
        List dimRange = entryTemplateConfig.getApplyTemplateBizRanges();
        if (CollectionUtils.isEmpty((Collection)dimRange)) {
            return;
        }
        List applyTemplateBizRanges = ApplyTemplateDimRangeService.getInstance().compareMemberId(dimRange, currentDimNumber, Long.valueOf(currentDimMemberId));
        boolean bl = flag = !applyTemplateBizRanges.isEmpty();
        if (!flag) {
            this.getModel().setValue(busPlanDetailKey, (Object)false, rowIndex);
            this.refreshBizEntryDataAndPutCombineInfo(dataEntity, entityName, false);
            this.removeBizEntryRowsToCache("biz" + entityName, busPlanDetailRowInfo, bizEntryTempCfg.getCombineDimensionKey(), false, "", "");
            return;
        }
        for (String dimKey : dimKeysList) {
            if (StringUtils.equals((CharSequence)dimKey, (CharSequence)colKey)) continue;
            Object value = this.getModel().getValue(dimKey, rowIndex);
            if (!(value instanceof DynamicObject)) {
                flag = false;
                break;
            }
            DynamicObject valueObj = (DynamicObject)value;
            DynamicObject dimension = valueObj.getDynamicObject("dimension");
            String dimensionNum = dimension.getString("number");
            long id = valueObj.getLong("id");
            applyTemplateBizRanges = ApplyTemplateDimRangeService.getInstance().compareMemberId(applyTemplateBizRanges, dimensionNum, Long.valueOf(id));
            flag = !applyTemplateBizRanges.isEmpty();
            if (flag) continue;
            break;
        }
        if (flag) {
            this.refreshBizEntryDataAndPutCombineInfo(dataEntity, entityName, true);
            this.getModel().setValue(busPlanDetailKey, (Object)true, rowIndex);
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{busPlanDetailKey});
            if (!applyTemplateBizRanges.isEmpty()) {
                List<BaseColumn> dimCollect = entryTemplateConfig.getEntryColumns().stream().filter(ee -> dimKeysList.contains(ee.getKey())).collect(Collectors.toList());
                DynamicObject dataentity = this.getModel().getEntryRowEntity(entityName, rowIndex);
                String dimStr = this.joinCombineDimensionIds(dimCollect, dataentity);
                String templateIdAndDimStr = ApplyTemplateDimRangeService.getInstance().getTemplateIdAndDimStr(String.valueOf(templateID), dimStr);
                this.getBizPlanRangeSumKeys(templateIdAndDimStr, entityName, dataentity);
            }
        } else {
            this.getModel().setValue(busPlanDetailKey, (Object)false, rowIndex);
            this.refreshBizEntryDataAndPutCombineInfo(dataEntity, entityName, true);
            this.removeBizEntryRowsToCache("biz" + entityName, busPlanDetailRowInfo, bizEntryTempCfg.getCombineDimensionKey(), false, "", "");
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        Map<String, Long> templateIds = this.getTemplateIds();
        Map<Long, List<String>> enableCols = this.getEnableEditCols(templateIds);
        SchemeAssignDimGroup schemeAssignDimGroup = new SchemeAssignDimGroup(this.getModelId(), this.getSchemeId(), this.getYearId(), this.getVersionId(), this.getDataTypeId());
        if (StringUtils.equals((CharSequence)"import", (CharSequence)opKey)) {
            BgApplyBillUtils.getInstance().openMainEntryImportPage((IFormPlugin)this, this.getView(), enableCols, this.getTemplateIds(), this.getBillNumber(), this.getModelId(), schemeAssignDimGroup);
        } else if (StringUtils.equals((CharSequence)"showsubtotal", (CharSequence)opKey)) {
            this.setSubtotalStatus(true);
            this.getView().invokeOperation("save");
        } else if (StringUtils.equals((CharSequence)"hidesubtotal", (CharSequence)opKey)) {
            this.setSubtotalStatus(false);
            this.clearSubtotalOlap();
            this.getView().invokeOperation("save");
        }
    }

    @Override
    protected void mainEntryEntityExport() {
        Map<String, Long> templateIds = this.getTemplateIds();
        Map<Long, List<String>> enableCols = this.getEnableEditCols(templateIds);
        Map<String, String> entityUnitSet = this.getOrCacheEntityUnitSet(null);
        SchemeAssignDimGroup schemeAssignDimGroup = new SchemeAssignDimGroup(this.getModelId(), this.getReportSchemeId(), this.getYearId(), this.getVersionId(), this.getDataTypeId());
        HashMap<String, Map<String, Map<String, String>>> RowDimMemberMap = new HashMap<String, Map<String, Map<String, String>>>(templateIds.size());
        HashMap<String, Map<String, Map<String, String>>> otherDimMemberMap = new HashMap<String, Map<String, Map<String, String>>>(templateIds.size());
        this.getRowDimMap(templateIds, RowDimMemberMap, otherDimMemberMap);
        BgApplyAuditDataExportPlugin.getInstance().colExport(null, templateIds, this.getModelId(), this.getView(), this.getBillNumber(), enableCols, entityUnitSet, null, false, schemeAssignDimGroup, RowDimMemberMap, null, otherDimMemberMap);
    }

    private void getRowDimMap(Map<String, Long> templateIds, Map<String, Map<String, Map<String, String>>> RowDimMemberMap, Map<String, Map<String, Map<String, String>>> otherDimMemberMap) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (String entryKey : templateIds.keySet()) {
            LinkedHashMap<String, HashMap<String, String>> RowDimMap = new LinkedHashMap<String, HashMap<String, String>>(templateIds.size());
            LinkedHashMap otherDimMap = new LinkedHashMap(templateIds.size());
            DynamicObjectCollection entryData = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryKey);
            EntryTemplateConfig tempConfig = this.getTempConfig(entryKey);
            Map dimViewMap = modelCacheHelper.getViewsByDataSet(Long.valueOf(tempConfig.getDatasetId()));
            if (entryData == null) continue;
            for (int i = 0; i < entryData.size(); ++i) {
                HashMap<String, String> rowMap = new HashMap<String, String>(entryData.size());
                HashMap<String, String> otherMap = new HashMap<String, String>(entryData.size());
                DynamicObject entryDataObj = (DynamicObject)entryData.get(i);
                for (BaseColumn baseColumn : tempConfig.getEntryColumns()) {
                    DimensionColumn rowDimensionColumn;
                    String dimNumber = null;
                    String key = null;
                    if (baseColumn instanceof DimensionColumn) {
                        rowDimensionColumn = (DimensionColumn)baseColumn;
                        dimNumber = rowDimensionColumn.getDimNumber();
                        key = rowDimensionColumn.getKey();
                        this.getRowDimMap(modelCacheHelper, rowMap, entryDataObj, dimNumber, key, dimViewMap);
                        continue;
                    }
                    if (baseColumn instanceof RowDimensionColumn) {
                        rowDimensionColumn = (RowDimensionColumn)baseColumn;
                        dimNumber = rowDimensionColumn.getDimNumber();
                        key = rowDimensionColumn.getKey();
                        this.getRowDimMap(modelCacheHelper, rowMap, entryDataObj, dimNumber, key, dimViewMap);
                        continue;
                    }
                    key = "f" + baseColumn.getKey();
                    Object value = entryDataObj.get(baseColumn.getKey());
                    if (value == null) continue;
                    if (value instanceof Date) {
                        String dateString = sdf.format(value);
                        otherMap.put(key, dateString);
                        continue;
                    }
                    otherMap.put(key, String.valueOf(value));
                }
                String id = entryDataObj.getString("id");
                if ("0".equals(id)) {
                    id = String.valueOf(DBServiceHelper.genGlobalLongId());
                }
                RowDimMap.put(id, rowMap);
                otherDimMap.put(id, otherMap);
            }
            RowDimMemberMap.put(entryKey, RowDimMap);
            otherDimMemberMap.put(entryKey, otherDimMap);
        }
    }

    private void getRowDimMap(IModelCacheHelper modelCacheHelper, HashMap<String, String> rowMap, DynamicObject entryDataObj, String dimNumber, String key, Map<String, Long> dimViewMap) {
        DynamicObject dynamicObject = entryDataObj.getDynamicObject(key);
        if (dynamicObject != null) {
            Member member = modelCacheHelper.getMember(dimNumber, dimViewMap.get(dimNumber), Long.valueOf(dynamicObject.getLong("id")));
            if (member == null) {
                return;
            }
            rowMap.put(dimNumber, member.getNumber());
        }
    }

    private void busPlanDetailChange(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        String entityname = changeData.getDataEntity().getDataEntityType().getName();
        if (StringUtils.isEmpty((CharSequence)entityname) || !entityname.startsWith("entryentity")) {
            return;
        }
        int rowIndex = changeData.getRowIndex();
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        BgApplyENtryInfo entryInfoFromFormParam = this.getEntryInfoFromFormParam();
        Map entryTemplateConfig = entryInfoFromFormParam.getEntryTemplateConfig();
        EntryTemplateConfig entityEntryTemplateConfig = (EntryTemplateConfig)entryTemplateConfig.get(entityname);
        long templateID = entityEntryTemplateConfig.getTemplateID();
        String bizentityName = "biz" + entityname;
        EntryTemplateConfig bizentityEntryTemplateConfig = (EntryTemplateConfig)entryTemplateConfig.get(bizentityName);
        if (entityEntryTemplateConfig == null || bizentityEntryTemplateConfig == null) {
            return;
        }
        String busPlanDetailKey = entityEntryTemplateConfig.getBusPlanDetailKey();
        DynamicObject dataEntity = changeData.getDataEntity();
        DynamicObjectCollection mainentryEntity = this.getModel().getEntryEntity(entityname);
        DynamicObject dynamicObjectRow = (DynamicObject)mainentryEntity.get(rowIndex);
        List dimKeysList = entityEntryTemplateConfig.getDimKeysList();
        if (StringUtils.equals((CharSequence)name, (CharSequence)busPlanDetailKey)) {
            boolean isCheck = true;
            if (newValue != null) {
                isCheck = (Boolean)newValue;
            } else {
                newValue = "false";
            }
            if (!isCheck) {
                if (CollectionUtils.isEmpty((Collection)dimKeysList)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5f53\u524d\u5206\u5f55\u7684\u7ef4\u5ea6\u4fe1\u606f\u3002", (String)"BgApplyBillPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.setNeedDealPropchange(false);
                    this.getModel().setValue(busPlanDetailKey, (Object)true, rowIndex);
                    this.setNeedDealPropchange(true);
                    return;
                }
                for (String key : dimKeysList) {
                    if (dynamicObjectRow.get(key) != null) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5f53\u524d\u5206\u5f55\u7684\u7ef4\u5ea6\u4fe1\u606f\u3002", (String)"BgApplyBillPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.setNeedDealPropchange(false);
                    this.getModel().setValue(busPlanDetailKey, (Object)true, rowIndex);
                    this.setNeedDealPropchange(true);
                    return;
                }
                DynamicObjectCollection bizentryEntity = this.getModel().getEntryEntity(bizentityName);
                List dimRange = entityEntryTemplateConfig.getApplyTemplateBizRanges();
                if (CollectionUtils.isNotEmpty((Collection)dimRange)) {
                    List applyTemplateBizRanges = dimRange;
                    boolean flag = false;
                    for (String dimKey : dimKeysList) {
                        Object value = this.getModel().getValue(dimKey, rowIndex);
                        if (!(value instanceof DynamicObject)) {
                            flag = false;
                            break;
                        }
                        DynamicObject valueObj = (DynamicObject)value;
                        DynamicObject dimension = valueObj.getDynamicObject("dimension");
                        String dimensionNum = dimension.getString("number");
                        long id = valueObj.getLong("id");
                        applyTemplateBizRanges = ApplyTemplateDimRangeService.getInstance().compareMemberId(applyTemplateBizRanges, dimensionNum, Long.valueOf(id));
                        flag = !applyTemplateBizRanges.isEmpty();
                        if (flag) continue;
                        break;
                    }
                    if (flag) {
                        this.setNeedDealPropchange(false);
                        this.getModel().setValue(busPlanDetailKey, (Object)true, rowIndex);
                        this.setNeedDealPropchange(true);
                        this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{busPlanDetailKey});
                        return;
                    }
                }
                if (bizentryEntity != null && bizentryEntity.size() > 0) {
                    Map bizSumColumns = bizentityEntryTemplateConfig.getBizSumColumns();
                    List entryColumns = entityEntryTemplateConfig.getEntryColumns();
                    this.getPageCache().put("busPlanDetailKey", entityEntryTemplateConfig.getBusPlanDetailKey());
                    this.getPageCache().put("rowIndex", rowIndex + "");
                    this.getPageCache().put("isCheck", newValue.toString());
                    this.getPageCache().put("dataEntity", SerializationUtils.serializeToBase64((Object)dataEntity));
                    this.getPageCache().put("entityname", entityname);
                    ArrayList notCalColumns = new ArrayList(16);
                    ArrayList calColumns = new ArrayList(16);
                    Collection values = bizSumColumns.values();
                    HashMap<String, String> refFormulaMap = new HashMap<String, String>(16);
                    for (BaseColumn entryColumn : entryColumns) {
                        if (!StringUtils.equals((CharSequence)entryColumn.getType().getName(), (CharSequence)ColumnEnum.Cal.getName())) continue;
                        refFormulaMap.put(entryColumn.getKey(), ((CalculateColumn)entryColumn).getFormula());
                    }
                    block5: for (String key : values) {
                        for (BaseColumn entryColumn : entryColumns) {
                            HashMap<String, String> tempMap = new HashMap<String, String>(16);
                            String formula = (String)refFormulaMap.get(entryColumn.getKey());
                            if (formula != null && StringUtils.equals((CharSequence)key, (CharSequence)entryColumn.getKey())) {
                                Iexpression exp = null;
                                try {
                                    exp = ExpressionParseHelper.parse((String)formula, refFormulaMap);
                                    exp.setContext(new ExpressionContext(rowIndex, this.getView(), this.getModel()));
                                    BigDecimal calculate = exp.calculate();
                                    tempMap.put(key, calculate.toString());
                                    calColumns.add(tempMap);
                                }
                                catch (Exception exception) {
                                    log.error((Throwable)exception);
                                }
                                continue block5;
                            }
                            tempMap.put(key, "");
                            notCalColumns.add(tempMap);
                        }
                    }
                    this.getPageCache().put("notCalColumns", SerializationUtils.serializeToBase64(notCalColumns));
                    this.getPageCache().put("calColumns", SerializationUtils.serializeToBase64(calColumns));
                    this.getPageCache().put("combineDimensionKey", bizentityEntryTemplateConfig.getCombineDimensionKey());
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u53d6\u6d88\u52fe\u9009\u4e1a\u52a1\u8ba1\u5212\u660e\u7ec6\u5c06\u5220\u9664\u9884\u7b97\u5173\u8054\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u53d6\u6d88\u52fe\u9009\uff1f", (String)"BgApplyBillPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("cancelCheckBusinessPlan", (IFormPlugin)this));
                }
            } else {
                for (String key : dimKeysList) {
                    if (dynamicObjectRow.get(key) != null) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5f53\u524d\u5206\u5f55\u7684\u7ef4\u5ea6\u4fe1\u606f\u3002", (String)"BgApplyBillPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.setNeedDealPropchange(false);
                    this.getModel().setValue(busPlanDetailKey, (Object)false, rowIndex);
                    this.setNeedDealPropchange(true);
                    return;
                }
                this.refreshBizEntryDataAndPutCombineInfo(dataEntity, entityname, (Boolean)newValue);
            }
            if (isCheck) {
                this.reCalcSummaryField(bizentityName);
            } else {
                this.handleMainHcolumn(entityname, rowIndex);
                this.refreshBizEntryDataAndPutCombineInfo(dataEntity, entityname, (Boolean)newValue);
            }
        }
        if (dimKeysList.contains(name)) {
            boolean hasvalue = true;
            for (String key : dimKeysList) {
                if (dynamicObjectRow.get(key) != null) continue;
                hasvalue = false;
                break;
            }
            List<BaseColumn> dimCollect = entityEntryTemplateConfig.getEntryColumns().stream().filter(ee -> dimKeysList.contains(ee.getKey())).collect(Collectors.toList());
            if (oldValue != null) {
                String dimStr = this.joinCombineDimensionIds(dimCollect, dataEntity, name, (DynamicObject)oldValue);
                this.removeBizEntryRowsToCache(bizentityName, dimStr, bizentityEntryTemplateConfig.getCombineDimensionKey(), false, "", "");
            }
            if (hasvalue) {
                super.entryentityRowClickToRefreshBizEntry(rowIndex, entityname);
            } else {
                this.setNeedDealPropchange(false);
                this.getModel().setValue(busPlanDetailKey, (Object)false, rowIndex);
                this.setNeedDealPropchange(true);
            }
        }
    }

    @Override
    protected void setCellsStatus(BillFieldStatus fieldStatus) {
        super.setCellsStatus(fieldStatus);
        this.lockBizSumColumn();
    }

    @Override
    protected void addLockFixValue(String billType, Set<String> lockCellKeys, int row, String ... keys) {
        for (String key : keys) {
            Object value = this.getModel().getValue(key, row);
            if (value != null && BigDecimal.ZERO.compareTo((BigDecimal)value) == 0) {
                lockCellKeys.remove(key);
                continue;
            }
            lockCellKeys.add(key);
        }
    }

    @Override
    protected List<Long> getTempIdsFromFormParam(FormShowParameter formShowParameter) {
        return this.queryTempIdsByScheme(formShowParameter);
    }

    @Override
    protected void initBillBaseInfo() {
        super.initBillBaseInfo();
        if (this.isAddNewForm()) {
            this.setNewBillBaseInfo();
        }
    }

    @Override
    protected void fillEntryData(Map<String, List<Object[]>> billDataFromDB) {
        this.dealEntryData(billDataFromDB);
    }

    @Override
    protected Map<String, List<Object[]>> getBillDataFromDB(BgApplyENtryInfo bgApplyENtryInfo) {
        HashMap<String, List<Object[]>> billData = new HashMap<String, List<Object[]>>(16);
        Long id = (Long)this.getValue("id", null);
        if (id == null || id == 0L) {
            return billData;
        }
        Map entryTemplateConfig = bgApplyENtryInfo.getEntryTemplateConfig();
        for (Map.Entry entry : entryTemplateConfig.entrySet()) {
            String entityKey = (String)entry.getKey();
            String tableName = ((EntryTemplateConfig)entry.getValue()).getEntryTable();
            EntryTemplateConfig entryConfig = (EntryTemplateConfig)entry.getValue();
            List entryColumns = entryConfig.getEntryColumns();
            List main_collect = entryColumns.stream().filter(ee -> !ee.getKey().endsWith("_text")).collect(Collectors.toList());
            List entityData = ApplyTemplateUtils.getEntityData((String)tableName, (Object)id, main_collect);
            billData.put(entityKey, entityData);
        }
        return billData;
    }

    @Override
    protected void setColumnStatus(BillFieldStatus fieldStatus) {
        super.setColumnStatus(fieldStatus);
    }

    @Override
    protected void saveBillData(BillSaveEventArgs eventArgs) {
        BgApplyENtryInfo entryconfiginfo = this.getEntryInfoFromFormParam();
        Object pkValue = this.getValue("id", null);
        if (pkValue == null || pkValue.equals(0L)) {
            pkValue = GlobalIdUtil.genGlobalLongId();
            this.getModel().setValue("id", pkValue);
        }
        String billNumber = (String)this.getValue("billnumber", null);
        Map<String, List<Object[]>> initEntityDatas = this.getCachedInitEntityData();
        for (Map.Entry entry : entryconfiginfo.getEntryTemplateConfig().entrySet()) {
            String entityNumber = (String)entry.getKey();
            List<Object[]> initEntityData = initEntityDatas.get(entityNumber);
            Map columnIndex = ((EntryTemplateConfig)entry.getValue()).getColumnIndex();
            Set currencyColumnKeys = ((EntryTemplateConfig)entry.getValue()).getCurrencyColumnKeys();
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity(entityNumber);
            ArrayList columns = (ArrayList)((EntryTemplateConfig)entry.getValue()).getEntryColumns();
            List<BaseColumn> main_collect = columns.stream().filter(ee -> !ee.getKey().endsWith("_text") && !ee.getKey().startsWith(ApplyTemplateUtils.FIELD_SUBTOTAL_STATUS)).collect(Collectors.toList());
            String fulltablename = ((EntryTemplateConfig)entry.getValue()).getEntryTable();
            BigDecimal unitData = this.getUnitData(((EntryTemplateConfig)entry.getValue()).getUnit());
            if (entityNumber.startsWith("entryentity")) {
                String subtotalKey = ((EntryTemplateConfig)entry.getValue()).getSubtotalKey();
                List notSubtotalEntrys = dynamicObjectCollection.stream().filter(s -> !s.getBoolean(subtotalKey)).collect(Collectors.toList());
                DynamicObjectCollection filterdatas = new DynamicObjectCollection(dynamicObjectCollection.getDynamicObjectType(), dynamicObjectCollection.getParent());
                filterdatas.addAll(notSubtotalEntrys);
                this.saveEntryRowData(filterdatas, initEntityData, columnIndex, pkValue, billNumber, fulltablename, main_collect, currencyColumnKeys, unitData, entityNumber);
                continue;
            }
            Map stringSimpleDynamicObjectMap = this.getBizEntryCacheData().getBizEntryDynamicObjCol(entityNumber);
            if (stringSimpleDynamicObjectMap == null) continue;
            Collection values = stringSimpleDynamicObjectMap.values();
            DynamicObjectType dynamicObjectType = this.getModel().getEntryEntity(entityNumber).getDynamicObjectType();
            DynamicObjectCollection bizDynamicObjs = new DynamicObjectCollection(dynamicObjectType, null);
            for (SimpleDynamicObject val : values) {
                if (this.checkBizPlanEmptyRow(main_collect, val)) continue;
                DynamicObject dynamicObject = bizDynamicObjs.addNew();
                for (BaseColumn baseColumn : main_collect) {
                    Object colValue = val.getValue(baseColumn.getKey());
                    if (FieldTypeEnum.Date == baseColumn.getFieldtype() && colValue != null) {
                        colValue = DateTimeUtils.parseToDate((String)colValue.toString());
                    } else if (FieldTypeEnum.BaseDataField == baseColumn.getFieldtype()) {
                        DynamicObject baseData = BusinessDataServiceHelper.newDynamicObject((String)baseColumn.getBaseEntityId());
                        if (colValue instanceof Map) {
                            Map map = (Map)colValue;
                            baseData.set("id", map.get("id"));
                            colValue = baseData;
                        }
                    }
                    dynamicObject.set(baseColumn.getKey(), colValue);
                }
            }
            this.saveEntryRowData(bizDynamicObjs, initEntityData, columnIndex, pkValue, billNumber, fulltablename, main_collect, new HashSet<String>(16), unitData, entityNumber);
        }
    }

    @Override
    protected void reCacheInitEntityData() {
        BgApplyENtryInfo entryInfoFromFormParam = this.getEntryInfoFromFormParam();
        Map<String, List<Object[]>> billDataFromDB = this.getBillDataFromDB(entryInfoFromFormParam);
        this.cacheInitEntityData(billDataFromDB);
    }

    private void checkRowDimComplete(BillVerifyResult verifyResult) {
        Long modelId = this.getModelId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Map entryTemplateConfig = this.getEntryInfoFromFormParam().getEntryTemplateConfig();
        for (Map.Entry templateConfigEntry : entryTemplateConfig.entrySet()) {
            String entityKey = (String)templateConfigEntry.getKey();
            EntryTemplateConfig templateConfig = (EntryTemplateConfig)templateConfigEntry.getValue();
            Map dimColumnNumbers = BgApplyBillUtils.getInstance().getDimColumnNumbers(templateConfig, modelCacheHelper);
            DynamicObjectCollection entity = this.getModel().getEntryEntity(entityKey);
            if (entityKey.startsWith("entryentity")) {
                this.deleteNoDataRows(entityKey, entity, templateConfig);
            }
            if (entityKey.startsWith("bizentryentity")) continue;
            this.checkRowDimComplete(entity, dimColumnNumbers, entityKey, verifyResult);
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent event) {
        MessageBoxResult result;
        super.confirmCallBack(event);
        if ("incompleteDelete".equals(event.getCallBackId()) && MessageBoxResult.Yes.equals((Object)(result = event.getResult()))) {
            String incompleteDeleteRows = this.getView().getPageCache().get("incompleteDeleteRows");
            HashMap deleteEntityRowsMap = (HashMap)SerializationUtils.fromJsonString((String)incompleteDeleteRows, Map.class);
            Set entries = deleteEntityRowsMap.entrySet();
            for (Map.Entry entry : entries) {
                String entityKey = (String)entry.getKey();
                List delRows = (List)entry.getValue();
                if (!entityKey.startsWith("entryentity")) continue;
                DynamicObjectCollection entity = this.getModel().getEntryEntity(entityKey);
                ArrayList<Object> list = new ArrayList<Object>(16);
                int[] arr = new int[delRows.size()];
                for (int i = 0; i < delRows.size(); ++i) {
                    int needDeleteRow = (Integer)delRows.get(i);
                    list.add(entity.get(needDeleteRow));
                    arr[i] = needDeleteRow;
                }
                this.getModel().deleteEntryRows(entityKey, arr);
                entity.removeAll(list);
            }
            this.getView().invokeOperation("save");
        }
    }

    private void checkRowDimComplete(DynamicObjectCollection entity, Map<String, String> dimColumnNumbers, String entityKey, BillVerifyResult verifyResult) {
        ArrayList<Integer> rowIndexes = new ArrayList<Integer>(16);
        for (int i = 0; i < entity.size(); ++i) {
            DynamicObject entryRow = (DynamicObject)entity.get(i);
            for (Map.Entry<String, String> dimCol : dimColumnNumbers.entrySet()) {
                DynamicObject dimMember = entryRow.getDynamicObject(dimCol.getKey());
                if (dimMember != null || rowIndexes.contains(i)) continue;
                rowIndexes.add(i);
            }
        }
        if (rowIndexes.size() != 0) {
            String name;
            verifyResult.setSuccess(false);
            verifyResult.setCancel(true);
            ApplyTemplateModel templateInfo = this.getTemplateInfo(entityKey);
            if (templateInfo != null && StringUtils.isNotEmpty((CharSequence)(name = templateInfo.getName()))) {
                String errMessage = ResManager.loadResFormat((String)"\u6a21\u677f\u201c%1\u201d\u4e2d\u7b2c%2\u884c\u7684\u7ef4\u5ea6\u7ec4\u5408\u4e0d\u5b8c\u6574\uff0c\u6570\u636e\u4e0d\u4f1a\u4fdd\u5b58\uff0c\u662f\u5426\u7ee7\u7eed?", (String)"BgApplyBillPluginNew_1", (String)"epm-eb-formplugin", (Object[])new Object[]{name, rowIndexes.stream().map(e -> e + 1 + "").collect(Collectors.joining(","))});
                this.getView().showConfirm(errMessage, MessageBoxOptions.YesNo, new ConfirmCallBackListener("incompleteDelete", (IFormPlugin)this));
                HashMap<String, ArrayList<Integer>> deleteEntityRowsMap = new HashMap<String, ArrayList<Integer>>(16);
                deleteEntityRowsMap.put(entityKey, rowIndexes);
                this.getView().getPageCache().put("incompleteDeleteRows", SerializationUtils.toJsonString(deleteEntityRowsMap));
            }
        }
    }

    @Override
    protected void cacheInitEntityData(Map<String, List<Object[]>> billDataFromDB) {
        this.getPageCache().put("initEntityData", ObjectSerialUtil.toByteSerialized(billDataFromDB));
    }

    protected Map<String, List<Object[]>> getCachedInitEntityData() {
        String billData = this.getPageCache().get("initEntityData");
        if (StringUtils.isEmpty((CharSequence)billData)) {
            return new HashMap<String, List<Object[]>>(16);
        }
        return (Map)ObjectSerialUtil.deSerializedBytes((String)billData);
    }

    @Override
    protected void saveAllTemplateDataToOlap(BillSaveEventArgs eventArgs) {
        Map entryTemplateConfig = this.getEntryInfoFromFormParam().getEntryTemplateConfig();
        Map<String, List<Object[]>> initEntityData = this.getCachedInitEntityData();
        entryTemplateConfig.forEach((key, value) -> this.saveTemplateDataToOlap((String)key, (EntryTemplateConfig)value, initEntityData, null));
    }

    @Override
    protected void deleteNoDataRows(String entityKey, DynamicObjectCollection entity, EntryTemplateConfig templateConfig) {
        List<Integer> needDeleteRows = this.getNeedDeleteRows(entity, templateConfig);
        ArrayList<Object> list = new ArrayList<Object>(16);
        int[] arr = new int[needDeleteRows.size()];
        for (int i = 0; i < needDeleteRows.size(); ++i) {
            int needDeleteRow = needDeleteRows.get(i);
            list.add(entity.get(needDeleteRow));
            arr[i] = needDeleteRow;
        }
        this.getModel().deleteEntryRows(entityKey, arr);
        entity.removeAll(list);
    }

    private boolean checkBizPlanEmptyRow(List<BaseColumn> main_collect, SimpleDynamicObject val) {
        for (BaseColumn baseColumn : main_collect) {
            Object value;
            if (!baseColumn.isFinalVisible() || (value = val.getValue(baseColumn.getKey())) == null) continue;
            if (value instanceof BigDecimal && ((BigDecimal)value).compareTo(BigDecimal.ZERO) != 0) {
                return false;
            }
            if (!(value instanceof String) || !StringUtils.isNotEmpty((CharSequence)((String)value))) continue;
            return false;
        }
        return true;
    }

    private void saveEntryRowData(DynamicObjectCollection dynamicObjectCollection, List<Object[]> initEntityData, Map<String, Integer> columnIndex, Object pkValue, String billnumber, String fulltablename, List<BaseColumn> collect, Set<String> currencyColumnKeys, BigDecimal unitData, String entityNumber) {
        HashSet<Long> entryIds = new HashSet<Long>(16);
        try (DataSet dataSet = DB.queryDataSet((String)"queryEntityDataId", (DBRoute)DBRoute.of((String)"epm"), (String)("select fentryid from " + fulltablename + " where fid = " + pkValue));){
            Row row = null;
            while (dataSet.hasNext()) {
                row = dataSet.next();
                entryIds.add(row.getLong("fentryid"));
            }
        }
        String insertSql = null;
        String updateSql = null;
        ArrayList<Object[]> insertParameters = new ArrayList<Object[]>(16);
        ArrayList<Object[]> updateParameters = new ArrayList<Object[]>(16);
        HashSet<Long> curEntryIds = new HashSet<Long>(16);
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        Timestamp nowTimestamp = this.formatDateToTimestamp(now);
        for (DynamicObject entryInfo : dynamicObjectCollection) {
            boolean isAdd = true;
            ArrayList<Object> valueParameters = new ArrayList<Object>(16);
            ArrayList<String> selectFields = new ArrayList<String>(16);
            Long id = entryInfo.getLong("id");
            if (entryIds.contains(id)) {
                curEntryIds.add(id);
                isAdd = false;
            }
            for (BaseColumn bs : collect) {
                Object entryValue = entryInfo.get(bs.getKey());
                if (bs.getKey().startsWith(ApplyTemplateUtils.FIELD_COMBINEDIMENSION)) {
                    selectFields.add(ApplyTemplateUtils.FIELDSQL_COMBINEDIMENSION);
                    valueParameters.add(entryValue.toString());
                    continue;
                }
                if (bs.getKey().startsWith(ApplyTemplateUtils.FIELD_DETAILID)) {
                    selectFields.add(ApplyTemplateUtils.FIELDSQL_DETAILID);
                    valueParameters.add(entryValue.toString());
                    continue;
                }
                if (bs.getKey().startsWith(ApplyTemplateUtils.FIELD_BUSPLANDETAIL)) {
                    selectFields.add(ApplyTemplateUtils.FIELDSQL_BUSPLANDETAIL);
                    valueParameters.add((Boolean)entryValue != false ? "1" : "0");
                    continue;
                }
                if (bs.getKey().startsWith(ApplyTemplateUtils.FIELD_BIZPLAN_TABKEY)) {
                    selectFields.add(ApplyTemplateUtils.FIELDSQL_BIZPLAN_TABKEY);
                    valueParameters.add(entryValue.toString());
                    continue;
                }
                selectFields.add("f" + bs.getKey());
                valueParameters.add(this.selectColumnVal(bs, entryInfo, currencyColumnKeys, unitData));
            }
            selectFields.addAll(Arrays.asList("fid", "fentryid", "fbillnumber", "fbilltype"));
            if (isAdd) {
                long pkId_new = DBServiceHelper.genGlobalLongId();
                valueParameters.addAll(Arrays.asList(pkValue, pkId_new, billnumber, ApplyBillType.APPLY.getNumber(), EntityRowDataType.NEW_DETAIL.getNumber(), userId, nowTimestamp, userId, nowTimestamp));
                insertParameters.add(valueParameters.toArray());
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(entityNumber, Math.max(entryInfo.getInt("seq") - 1, 0));
                if (entryRowEntity != null) {
                    entryRowEntity.set("id", (Object)pkId_new);
                }
            } else {
                valueParameters.addAll(Arrays.asList(pkValue, id, billnumber, ApplyBillType.APPLY.getNumber()));
                if (!this.existSameRecord(initEntityData, columnIndex, id, selectFields, valueParameters)) {
                    valueParameters.addAll(Arrays.asList(EntityRowDataType.EDIT_DETAIL.getNumber(), userId, nowTimestamp, id));
                    updateParameters.add(valueParameters.toArray());
                } else {
                    valueParameters.add(Arrays.asList(EntityRowDataType.EDIT_DETAIL.getNumber(), userId, nowTimestamp));
                }
            }
            selectFields.add("fdatatype");
            if (StringUtils.isEmpty(updateSql)) {
                selectFields.addAll(Arrays.asList("fmodifier", "fmodifydate"));
                updateSql = "update " + fulltablename + " set" + selectFields.stream().collect(Collectors.joining(" = ?, ", " ", " = ? ")) + "where fentryid = ?";
            }
            if (!StringUtils.isEmpty(insertSql)) continue;
            selectFields.addAll(Arrays.asList("fcreator", "fcreatedate"));
            insertSql = "insert into " + fulltablename + selectFields.stream().collect(Collectors.joining(",", "(", ")")) + " values" + selectFields.stream().map(e -> "?").collect(Collectors.joining(",", "(", ")"));
        }
        if (insertParameters.size() != 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), insertSql, insertParameters);
        }
        if (updateParameters.size() != 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), updateSql, updateParameters);
        }
        entryIds.removeAll(curEntryIds);
        if (entryIds.size() != 0) {
            String deleteSql = "delete from " + fulltablename + " where fentryid in " + entryIds.stream().map(e -> e + "").collect(Collectors.joining(",", "(", ")"));
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)deleteSql);
        }
    }

    private boolean existSameRecord(List<Object[]> initEntityData, Map<String, Integer> columnIndex, Long id, List<String> selectFields, List<Object> valueParameters) {
        boolean hasSameRecord = true;
        Integer fEntryIdIndex = columnIndex.get("fentryid");
        block0: for (Object[] initEntityDatum : initEntityData) {
            Object pkId = initEntityDatum[fEntryIdIndex];
            if (!id.equals(IDUtils.toLong((Object)pkId))) continue;
            for (Map.Entry<String, Integer> entry : columnIndex.entrySet()) {
                Object initData;
                Object value;
                String fieldKey = entry.getKey();
                Integer colIndex = entry.getValue();
                String columnKey = this.getColumnKey(fieldKey);
                int index = selectFields.indexOf(columnKey);
                if (index == -1) {
                    index = selectFields.indexOf("f" + columnKey);
                }
                if (index == -1 || this.compareValueSame(value = valueParameters.get(index), initData = initEntityDatum[colIndex])) continue;
                hasSameRecord = false;
                continue block0;
            }
        }
        return hasSameRecord;
    }

    private String getColumnKey(String fieldKey) {
        if (fieldKey.startsWith(ApplyTemplateUtils.FIELD_COMBINEDIMENSION)) {
            return ApplyTemplateUtils.FIELDSQL_COMBINEDIMENSION;
        }
        if (fieldKey.startsWith(ApplyTemplateUtils.FIELD_DETAILID)) {
            return ApplyTemplateUtils.FIELDSQL_DETAILID;
        }
        if (fieldKey.startsWith(ApplyTemplateUtils.FIELD_BUSPLANDETAIL)) {
            return ApplyTemplateUtils.FIELDSQL_BUSPLANDETAIL;
        }
        return fieldKey;
    }

    private boolean compareValueSame(Object value, Object initData) {
        boolean same = true;
        if (value instanceof BigDecimal) {
            BigDecimal bdInitData = new BigDecimal(initData.toString());
            if (((BigDecimal)value).compareTo(bdInitData) != 0) {
                same = false;
            }
        } else if (value instanceof Timestamp) {
            if (initData == null) {
                same = false;
            } else {
                Date date = DateTimeUtils.parseToDate((String)initData.toString());
                Timestamp timestamp = new Timestamp(date.getTime());
                if (((Timestamp)value).after(timestamp) || ((Timestamp)value).before(timestamp)) {
                    same = false;
                }
            }
        } else {
            same = initData == null || value == null ? initData == null && value == null : value.toString().equals(initData.toString());
        }
        return same;
    }

    @Override
    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.doBizPlanUpAfterDelRow(e);
    }

    @Override
    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        this.doBizPlanUpAfterAddRow(e);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String backKey = closedCallBackEvent.getActionId();
        if ("mainEntryImport".equals(backKey)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData instanceof Map) {
                Map retData = (Map)returnData;
                log.info("BgApplyBillDataImportPlugin_importData: loadImportData ---- start time :" + TimeServiceHelper.now());
                this.loadImportData((Map)retData.get("importData"), (Map)retData.get("colInfo"));
                log.info("BgApplyBillDataImportPlugin_importData: checkLimitCols ---- start time :" + TimeServiceHelper.now());
                this.checkLimitCols((Map)retData.get("limitCol"));
                log.info("BgApplyBillDataImportPlugin_importData: loadImportData ---- end time :" + TimeServiceHelper.now());
            }
            this.getView().updateView();
        }
    }

    private void checkLimitCols(Map<Long, List<String>> limitInputInfos) {
        HashMap<Long, List> tipMessage = new HashMap<Long, List>(16);
        Map entryTemplateConfig = this.getEntryInfoFromFormParam().getEntryTemplateConfig();
        for (Map.Entry template : entryTemplateConfig.entrySet()) {
            EntryTemplateConfig templateConfig;
            long templateId;
            List<String> cols;
            DynamicObject[] entityKey = (DynamicObject[])template.getKey();
            if (entityKey.startsWith("bizentryentity") || (cols = limitInputInfos.get(templateId = (templateConfig = (EntryTemplateConfig)template.getValue()).getTemplateID())) == null || cols.size() == 0) continue;
            List entryColumns = templateConfig.getEntryColumns();
            ArrayList colNames = new ArrayList(16);
            entryColumns.forEach(e -> {
                String key = e.getKey();
                if (cols.contains(key)) {
                    colNames.add(e.getTitle());
                }
            });
            if (colNames.size() == 0) continue;
            tipMessage.put(templateId, colNames);
        }
        if (tipMessage.size() == 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f", (String)"BgApplyBillPluginNew_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            DynamicObject[] templates = BusinessDataServiceHelper.load((String)"eb_applytemplate", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "in", tipMessage.keySet())});
            if (templates == null) {
                throw new KDBizException("");
            }
            HashMap<Long, String> templateInfo = new HashMap<Long, String>(16);
            for (DynamicObject template : templates) {
                templateInfo.put(template.getLong("id"), template.getString("name"));
            }
            ArrayList tipInfos = new ArrayList(16);
            tipMessage.forEach((key, value) -> tipInfos.add(ResManager.loadResFormat((String)"\u6a21\u677f\u201c%1\u201d\u4e2d\u7684 %2 \u5217", (String)"BgApplyBillPluginNew_3", (String)"epm-eb-formplugin", (Object[])new Object[]{templateInfo.get(key), String.join((CharSequence)"\u3001", value)})));
            this.getView().showTipNotification(ResManager.loadResFormat((String)"%1\u4e3a\u4e0d\u53ef\u7f16\u8f91\u5217\uff0c\u65e0\u6cd5\u5bfc\u5165\u6570\u636e\u3002", (String)"BgApplyBillPluginNew_4", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)"; ", tipInfos)}));
        }
    }

    private void loadImportData(Map<Long, List<Map<String, Object>>> importInfos, Map<Long, List<BaseColumn>> colInfos) {
        Map entryTemplateConfig = this.getEntryInfoFromFormParam().getEntryTemplateConfig();
        IDataModel iDataModel = this.getModel();
        for (Map.Entry entryTemplateInfo : entryTemplateConfig.entrySet()) {
            String entryKey = (String)entryTemplateInfo.getKey();
            if (entryKey.startsWith("bizentryentity")) continue;
            EntryTemplateConfig templateConfig = (EntryTemplateConfig)entryTemplateInfo.getValue();
            Long tempId = templateConfig.getTemplateID();
            Set currencyColumnKeys = templateConfig.getCurrencyColumnKeys();
            List<Map<String, Object>> importInfo = importInfos.get(tempId);
            if (importInfo == null || importInfo.size() == 0) continue;
            this.replaceDimensionRelation(importInfo, templateConfig, this.getModelCacheHelper());
            List<BaseColumn> columns = colInfos.get(tempId);
            ArrayList dimKeys = new ArrayList(16);
            ArrayList<BaseColumn> calCols = new ArrayList<BaseColumn>(16);
            columns.forEach(e -> {
                if (e instanceof DimensionColumn || e instanceof RelationDimensionColumn || e instanceof RowDimensionColumn) {
                    dimKeys.add(e.getKey());
                } else if (e instanceof CalculateColumn || e instanceof NumberColumn) {
                    calCols.add((BaseColumn)e);
                }
            });
            DynamicObjectCollection entity = this.getModel().getEntryEntity(entryKey);
            HashMap<Integer, Map<String, Object>> importDatas = new HashMap<Integer, Map<String, Object>>(16);
            this.setNeedDealPropchange(false);
            for (Map<String, Object> importData : importInfo) {
                int row = BgApplyBillUtils.getInstance().filterMemMapRow(entity, importData, dimKeys);
                if (row == -1) {
                    iDataModel.beginInit();
                    row = this.getModel().createNewEntryRow(entryKey);
                    iDataModel.endInit();
                }
                int finalRow = row;
                importData.forEach((key, value) -> {
                    Object Value = null;
                    if (value instanceof Long) {
                        Value = IDUtils.toLong((Object)value);
                    } else if (value instanceof String) {
                        Value = currencyColumnKeys.contains(key) ? (ConvertUtils.toDecimal((Object)value) == null ? value : ConvertUtils.toDecimal((Object)value)) : value;
                    } else if (value instanceof BigDecimal) {
                        Value = value;
                    }
                    try {
                        this.getModel().setValue(key, Value, finalRow);
                        Object curValue = this.getModel().getValue(key, finalRow);
                        if (!templateConfig.getDimKeysList().contains(key)) {
                            this.handleMonitorColumnChange((String)key, finalRow, curValue);
                        }
                        boolean isNeedLock = this.fillFixedValue(entryKey, finalRow);
                        this.lockCellsByRows(entryKey, new int[]{finalRow}, false, isNeedLock);
                    }
                    catch (Exception e) {
                        this.getModel().deleteEntryRow(entryKey, finalRow);
                        throw new KDBizException(e.getMessage());
                    }
                });
                String dimKey = (String)dimKeys.get(0);
                Object value2 = this.getModel().getValue(dimKey, row);
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(entryKey, row);
                this.autoOpenOrCloseBusinessPlan(value2, entryKey, row, dimKey, entryRowEntity);
                importDatas.put(row, importData);
            }
            this.replaceDataByOlap(templateConfig, importDatas, tempId);
            log.info("BgApplyBillPluginNew_importDatas: " + importDatas);
            this.updateCalculateDataByValueMap(importDatas, calCols, entryKey);
            this.setNeedDealPropchange(true);
        }
    }

    private void replaceDimensionRelation(List<Map<String, Object>> applyBillInitData, EntryTemplateConfig config, IModelCacheHelper modelCache) {
        long startTime = System.currentTimeMillis();
        Map targetKeyMapApplyTemplateDimensionRelations = ApplyBillPluginUitl.getTargetKeyMapApplyTemplateDimensionRelations((List)config.getEntryColumns());
        long query = System.currentTimeMillis();
        logger.info("replaceDimensionRelation: getApplyTemplateDimensionRelations data time is " + (query - startTime) + " ms");
        if (targetKeyMapApplyTemplateDimensionRelations.isEmpty()) {
            return;
        }
        Map columnMapDimNum = config.selectColumnMapDimNum();
        Map<String, String> dimMapColumnKey = columnMapDimNum.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        List dimKeysList = config.getDimKeysList();
        Map dimViewMap = modelCache.getViewsByDataSet(Long.valueOf(config.getDatasetId()));
        for (Map<String, Object> data : applyBillInitData) {
            block1: for (Map.Entry stringApplyTemplateDimensionRelationEntry : targetKeyMapApplyTemplateDimensionRelations.entrySet()) {
                String relationDimKey = (String)stringApplyTemplateDimensionRelationEntry.getKey();
                ApplyTemplateDimensionRelation value = (ApplyTemplateDimensionRelation)stringApplyTemplateDimensionRelationEntry.getValue();
                Map relationIdMapSourceIdjoinMapTargetIds = value.getRelationIdMapSourceIdjoinMapTargetIds();
                String relationDimNumber = (String)columnMapDimNum.get(relationDimKey);
                Map relationIdMapsourceDimNumbersMap = value.getRelationIdMapsourceDimNumbersMap();
                Long relationDimMemberId = (Long)data.get(relationDimKey);
                for (Map.Entry longMapEntry : relationIdMapSourceIdjoinMapTargetIds.entrySet()) {
                    Long relationId = (Long)longMapEntry.getKey();
                    Map sourceIdStrMapTargetIds = (Map)longMapEntry.getValue();
                    List sourceDimNumbers = (List)relationIdMapsourceDimNumbersMap.get(relationId);
                    ArrayList<String> dataSourceMemberIds = new ArrayList<String>(sourceDimNumbers.size());
                    LinkedHashMap<String, Long> dimNumberMapMemberId = new LinkedHashMap<String, Long>(16);
                    for (String sourceDimNumber : sourceDimNumbers) {
                        String columnKey = dimMapColumnKey.get(sourceDimNumber);
                        String eid = data.get(columnKey).toString();
                        dataSourceMemberIds.add(eid);
                        dimNumberMapMemberId.put(sourceDimNumber, Long.valueOf(eid));
                    }
                    String source = String.join((CharSequence)"_", dataSourceMemberIds);
                    Set targetDimMemberIds = (Set)sourceIdStrMapTargetIds.get(source);
                    if (targetDimMemberIds != null) {
                        if (targetDimMemberIds.size() > 1) {
                            if (targetDimMemberIds.contains(relationDimMemberId)) continue block1;
                            data.put(relationDimKey, null);
                            continue block1;
                        }
                        if (targetDimMemberIds.size() != 1) continue;
                        data.put(relationDimKey, targetDimMemberIds.iterator().next());
                        continue block1;
                    }
                    ArrayList allArrays = new ArrayList(16);
                    for (Map.Entry entry : dimNumberMapMemberId.entrySet()) {
                        Long _viewId = (Long)dimViewMap.get(entry.getKey());
                        Member member = modelCache.getMember((String)entry.getKey(), _viewId, (Long)entry.getValue());
                        List parentOrgList = modelCache.getParents(_viewId, member, true);
                        ArrayList subArrays = new ArrayList(16);
                        parentOrgList.forEach(s -> subArrays.add(s.getId()));
                        allArrays.add(subArrays);
                    }
                    ArrayList arrays = new ArrayList();
                    ApplyBillPluginUitl.arrangeCombine(allArrays, new ArrayList(), (int)0, arrays);
                    HashSet hashSet = new HashSet(16);
                    if (!arrays.isEmpty()) {
                        for (List array : arrays) {
                            String source2 = String.join((CharSequence)"_", array.stream().map(s -> String.valueOf(s)).collect(Collectors.toList()));
                            Set targetDimMemberIdss = (Set)sourceIdStrMapTargetIds.get(source2);
                            if (targetDimMemberIdss == null || targetDimMemberIdss.isEmpty()) continue;
                            hashSet.addAll(targetDimMemberIdss);
                        }
                    }
                    if (hashSet.size() == 1) {
                        data.put(relationDimKey, hashSet.iterator().next());
                        continue block1;
                    }
                    if (hashSet.size() <= 1) continue;
                    if (hashSet.contains(relationDimMemberId)) continue block1;
                    data.put(relationDimKey, null);
                    continue block1;
                }
            }
        }
    }

    private void replaceDataByOlap(EntryTemplateConfig templateConfig, Map<Integer, Map<String, Object>> importDatas, Long tempId) {
        if (importDatas.size() == 0) {
            return;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelId());
        Map dimViewMap = modelCacheHelper.getViewsByDataSet(Long.valueOf(templateConfig.getDatasetId()));
        HashMap<String, Set<String>> dimMembers = new HashMap<String, Set<String>>(16);
        HashMap<String, String> rowDimKeys = new HashMap<String, String>(16);
        Map hidDimMembers = BgApplyBillUtils.getInstance().getHideDimMembersFromTempConfig(modelCacheHelper, templateConfig);
        hidDimMembers.forEach((key, value) -> dimMembers.put((String)key, Collections.singleton(value)));
        HashMap<String, Map<String, String>> colDimMemberMap = new HashMap<String, Map<String, String>>(16);
        HashMap<String, BaseColumn> columnMap = new HashMap<String, BaseColumn>(16);
        this.collectColDims(templateConfig, modelCacheHelper, colDimMemberMap, dimMembers, columnMap, rowDimKeys, tempId);
        if (colDimMemberMap.size() == 0) {
            return;
        }
        HashMap rowDimMemberMap = new HashMap(16);
        for (Map.Entry<Integer, Map<String, Object>> importDataEntry : importDatas.entrySet()) {
            Integer rowIndex = importDataEntry.getKey();
            HashMap<String, String> rowMemberInfo = new HashMap<String, String>(16);
            Map<String, Object> importData = importDataEntry.getValue();
            boolean hasNull = false;
            for (Map.Entry stringStringEntry : rowDimKeys.entrySet()) {
                String key2 = (String)stringStringEntry.getKey();
                String value2 = (String)stringStringEntry.getValue();
                Object memberIdObj = importData.get(key2);
                if (memberIdObj == null) {
                    hasNull = true;
                    break;
                }
                Long memberId = ConvertUtils.toLong((Object)memberIdObj);
                Member member = modelCacheHelper.getMember(value2, (Long)dimViewMap.get(value2), memberId);
                if (member == null) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u83b7\u53d6\u7ef4\u5ea6[%1]\u7684\u6210\u5458[%2]\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"", (String)"", (Object[])new Object[]{value2, memberId}));
                }
                rowMemberInfo.put(value2, member.getNumber());
                Set members = dimMembers.computeIfAbsent(value2, k -> new HashSet(16));
                members.add(member.getNumber());
            }
            if (hasNull) continue;
            rowDimMemberMap.put(rowIndex, rowMemberInfo);
        }
        String[] dimensionNums = modelCacheHelper.getDimensionNums(Long.valueOf(templateConfig.getDatasetId()));
        BigDecimal unitData = BigDecimal.ONE.divide(this.getUnitData(templateConfig.getUnit()));
        Map olapDatas = BgApplyBillUtils.getInstance().queryOlapData(modelCacheHelper, this.getModelId(), Long.valueOf(templateConfig.getDatasetId()), dimMembers, true, templateConfig.getTemplateID());
        for (Map.Entry rowDimMemberEntry : rowDimMemberMap.entrySet()) {
            Integer rowIndex = (Integer)rowDimMemberEntry.getKey();
            Map<String, Object> importData = importDatas.get(rowIndex);
            Map memberMap = (Map)rowDimMemberEntry.getValue();
            memberMap.putAll(hidDimMembers);
            for (Map.Entry colDimMemberEntry : colDimMemberMap.entrySet()) {
                String colKey = (String)colDimMemberEntry.getKey();
                BaseColumn column = (BaseColumn)columnMap.get(colKey);
                HashMap tmp = new HashMap(memberMap);
                tmp.putAll((Map)colDimMemberEntry.getValue());
                MembersKey membersKey = BgApplyBillUtils.getInstance().getMembersKey(tmp, dimensionNums);
                Object data = olapDatas.get(membersKey);
                data = this.setDefaultData(data, column);
                if (templateConfig.getCurrencyColumnKeys().contains(colKey)) {
                    data = this.changeValByUnit(data, unitData);
                    data = this.checkNumSize((BigDecimal)data, column.getTitle());
                }
                this.getModel().setValue(colKey, data, rowIndex.intValue());
                importData.put(colKey, data);
            }
        }
    }

    private void collectColDims(EntryTemplateConfig templateConfig, IModelCacheHelper modelCacheHelper, Map<String, Map<String, String>> colDimMemberMap, Map<String, Set<String>> dimMembers, Map<String, BaseColumn> columnMap, Map<String, String> rowDimKeys, Long tempId) {
        Map colTypes = ApplyTemplateColCfgService.getInstance().queryColCfgMapByTemplateId(tempId, FormTypeEnum.APPLY);
        List<ColCfgPropEnum> types = Arrays.asList(ColCfgPropEnum.HIDE, ColCfgPropEnum.READONLY);
        List configCols = CentralAppBillService.getInstance().getConfigCols(colTypes, types);
        if (configCols.size() == 0) {
            return;
        }
        Map viewIds = modelCacheHelper.getViewsByDataSet(Long.valueOf(templateConfig.getDatasetId()));
        List entryColumns = templateConfig.getEntryColumns();
        for (BaseColumn entryColumn : entryColumns) {
            if (ColumnEnum.Measure != entryColumn.getType() || ColumnEnum.DimensionData != entryColumn.getType()) {
                if (ColumnEnum.Dimension != entryColumn.getType() && ColumnEnum.RelationDimension != entryColumn.getType() && ColumnEnum.RowDimension != entryColumn.getType()) continue;
                String dimNumber = BgApplyBillUtils.getInstance().getDimOrRelateDimNumber(entryColumn, modelCacheHelper);
                rowDimKeys.put(entryColumn.getKey(), dimNumber);
                continue;
            }
            if (!configCols.contains(entryColumn.getKey())) continue;
            HashMap<String, String> colMemberMap = new HashMap<String, String>(16);
            List dataMapDimensions = new ArrayList(16);
            if (entryColumn instanceof MeasureColumn) {
                dataMapDimensions = ((MeasureColumn)entryColumn).getDataMapDimensions();
            } else if (entryColumn instanceof DimensionDataColumn) {
                dataMapDimensions = ((DimensionDataColumn)entryColumn).getDataMapDimensions();
            }
            for (DataMapDimension dataMapDimension : dataMapDimensions) {
                Dimension dimension = modelCacheHelper.getDimension(Long.valueOf(dataMapDimension.getDimensionId()));
                if (dimension == null) continue;
                Set members = dimMembers.computeIfAbsent(dimension.getNumber(), j -> new HashSet(16));
                Member member = dimension.getMember((Long)viewIds.get(dimension.getNumber()), Long.valueOf(dataMapDimension.getDimensionRememberId()));
                members.add(member.getNumber());
                colMemberMap.put(dimension.getNumber(), member.getNumber());
            }
            if (colMemberMap.size() == 0) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u83b7\u53d6[%1]\u5217\u7ef4\u5ea6\u6210\u5458\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"", (String)"", (Object[])new Object[]{entryColumn.getTitle()}));
            }
            colDimMemberMap.put(entryColumn.getKey(), colMemberMap);
            columnMap.put(entryColumn.getKey(), entryColumn);
        }
    }

    @Override
    protected void saveQuoteInfo(BillSaveEventArgs eventArgs) {
        Long billId = this.getBillId();
        BgApplyBillUtils.getInstance().deleteDimQuote(Collections.singleton(billId));
        List<MemberQuoteDao> quoteList = this.selectMemberQList(null);
        if (quoteList.size() > 0) {
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"save", (Object[])new Object[]{quoteList});
        }
    }

    @Override
    protected void afterUnSumbit() {
        super.afterUnSumbit();
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_datainit"});
    }

    @Override
    protected BaseShowParameter getStatsShowParameter() {
        BaseShowParameter baseShowParameter = BgApplyBillHelper.getInstance().getBgApplyTypeBillFormShow(this.getModelId(), this.getBillNumber(), ApplyBillType.APPLYSTATISTICS);
        baseShowParameter.setCustomParam("schemeId", (Object)this.getSchemeId());
        baseShowParameter.setCustomParam("orgId", (Object)this.getBgOrgId());
        baseShowParameter.setCustomParam("billInfos", (Object)SerializationUtils.toJsonString((Object)ApplyTemplateUtils.instanceApplyBillModel((DynamicObject)this.getModel().getDataEntity())));
        return baseShowParameter;
    }

    @Override
    protected boolean setOrderAndFilter(EntryTemplateConfig templateConfig) {
        return true;
    }

    @Override
    protected String checkOpenStatsForm() {
        String reuslt = null;
        String billNum = this.getBillNumber();
        if (StringUtils.isEmpty((CharSequence)billNum)) {
            reuslt = ResManager.loadKDString((String)"\u8bf7\u4fdd\u5b58\u5355\u636e\u3002", (String)"BgApplyBillPluginNew_5", (String)"epm-eb-formplugin", (Object[])new Object[0]);
        }
        return reuslt;
    }

    @Override
    protected void batchSetItemVisable(boolean visable, BillFieldStatus status) {
        super.batchSetItemVisable(visable, status);
        if (visable) {
            status.addShowKeys(ApplyBillConstant.btns_saveentity);
            status.addShowKeys(ApplyBillConstant.btns_newentry);
            status.addShowKeys(ApplyBillConstant.btns_deleteentry);
            status.addShowKeys(ApplyBillConstant.btns_biznewentry);
            status.addShowKeys(ApplyBillConstant.btns_bizdeleteentry);
            status.addShowKeys(ApplyBillConstant.btns_import);
        } else {
            status.addHideKeys(ApplyBillConstant.btns_saveentity);
            status.addHideKeys(ApplyBillConstant.btns_newentry);
            status.addHideKeys(ApplyBillConstant.btns_deleteentry);
            status.addHideKeys(ApplyBillConstant.btns_biznewentry);
            status.addHideKeys(ApplyBillConstant.btns_bizdeleteentry);
            status.addHideKeys(ApplyBillConstant.btns_import);
        }
    }

    private void checkBizMustInput(BillVerifyResult verifyResult) {
        BgApplyENtryInfo entryInfoFromFormParam = this.getEntryInfoFromFormParam();
        Map entryTemplateConfig = entryInfoFromFormParam.getEntryTemplateConfig();
        BizEntryCacheData bizEntryCacheData = this.getBizEntryCacheData();
        Map bizEntryCache = bizEntryCacheData.getBizEntryCache();
        for (Map.Entry templateConfigEntry : entryTemplateConfig.entrySet()) {
            String entityKey = (String)templateConfigEntry.getKey();
            if (!this.isMainEntry(entityKey)) continue;
            EntryTemplateConfig entryConfig = (EntryTemplateConfig)templateConfigEntry.getValue();
            EntryTemplateConfig bizEntryConfig = (EntryTemplateConfig)entryTemplateConfig.get(entityKey.replace("entryentity", "bizentryentity"));
            if (bizEntryConfig == null) continue;
            DynamicObjectCollection entity = this.getModel().getEntryEntity(entityKey);
            Map bizEntryData = (Map)bizEntryCache.get(entityKey.replace("entryentity", "bizentryentity"));
            this.checkBizMustInput(entity, verifyResult, entryConfig, bizEntryConfig, bizEntryData);
        }
    }

    private void checkBizMustInput(DynamicObjectCollection entity, BillVerifyResult verifyResult, EntryTemplateConfig entryConfig, EntryTemplateConfig bizEntryConfig, Map<String, SimpleDynamicObject> bizEntryData) {
        List columnList = bizEntryConfig.getEntryColumns();
        HashSet dimKeysList = new HashSet(entryConfig.getDimKeysList());
        List<BaseColumn> dimCollect = entryConfig.getEntryColumns().stream().filter(ee -> dimKeysList.contains(ee.getKey())).collect(Collectors.toList());
        String combineDimensionKey = bizEntryConfig.getCombineDimensionKey();
        String bizPlanTabKey = bizEntryConfig.getBizPlanTabKey();
        Map bizplanTabKeyFieldsMap = bizEntryConfig.getBizplanTabKeyFieldsMap();
        for (DynamicObject rowObject : entity) {
            int rowIndex = rowObject.getInt("seq");
            String busPlanDetailKey = entryConfig.getBusPlanDetailKey();
            boolean busDetail = rowObject.getBoolean(busPlanDetailKey);
            String dimStr = this.joinCombineDimensionIds(dimCollect, rowObject);
            if (!busDetail || bizEntryData == null) continue;
            int row = 0;
            HashMap<String, Integer> tabkeyMapRow = new HashMap<String, Integer>(16);
            for (SimpleDynamicObject entry : bizEntryData.values()) {
                String bizplankey;
                Object combineDimensions = entry.getValue(combineDimensionKey);
                String string = bizplankey = entry.getValue(bizPlanTabKey) == null ? "" : entry.getValue(bizPlanTabKey).toString();
                if (combineDimensions == null || !this.isMatchEntry(combineDimensions.toString(), dimStr).booleanValue()) continue;
                ++row;
                Integer tabrow = (Integer)tabkeyMapRow.get(bizplankey);
                if (tabrow == null) {
                    tabkeyMapRow.put(bizplankey, 1);
                } else {
                    tabkeyMapRow.put(bizplankey, tabrow + 1);
                }
                for (BaseColumn column : columnList) {
                    Object val;
                    List bizfields;
                    if (StringUtils.isNotEmpty((CharSequence)bizplankey) && ((bizfields = (List)bizplanTabKeyFieldsMap.get(bizplankey)) == null || !bizfields.contains(column.getKey())) || !column.getIsmustinput().booleanValue() || !column.isEnable() || !column.isBaseVisible() || !((val = entry.getValue(column.getKey())) == null || val instanceof Long && val.equals(0L) || val instanceof String && StringUtils.isEmpty((CharSequence)((String)val)) || val instanceof BigDecimal && ((BigDecimal)val).doubleValue() == 0.0) && (!(val instanceof Integer) || (Integer)val != 0)) continue;
                    String errMessage = ResManager.loadResFormat((String)"\u6a21\u677f\u201c%1\u201d\u4e2d\u7b2c%2\u884c\u7684\u9884\u7b97\u5173\u8054\u4fe1\u606f\u7b2c%3\u884c\u5b58\u5728\u201c%4\u201d\u5fc5\u5f55\u9879\u672a\u586b\u3002", (String)"BgApplyBillPluginNew_7", (String)"epm-eb-formplugin", (Object[])new Object[]{entryConfig.getName(), rowIndex, tabkeyMapRow.get(bizplankey) != null ? tabkeyMapRow.get(bizplankey) : Integer.valueOf(row), column.getTitle()});
                    verifyResult.addResutInfo(errMessage);
                }
            }
        }
        if (verifyResult.getResultInfo().size() > 0) {
            verifyResult.setSuccess(false);
            verifyResult.setCancel(true);
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.dealMemberShowTypeChange();
    }

    private void handleMainHcolumn(String entityname, int rowIndex) {
        BgApplyENtryInfo entryInfoFromFormParam = this.getEntryInfoFromFormParam();
        Map entryTemplateConfigMap = entryInfoFromFormParam.getEntryTemplateConfig();
        EntryTemplateConfig entityEntryTemplateConfig = (EntryTemplateConfig)entryTemplateConfigMap.get(entityname);
        String bizentityName = "biz" + entityname;
        EntryTemplateConfig bizentityEntryTemplateConfig = (EntryTemplateConfig)entryTemplateConfigMap.get(bizentityName);
        if (entityEntryTemplateConfig == null || bizentityEntryTemplateConfig == null) {
            return;
        }
        String busPlanDetailKey = entityEntryTemplateConfig.getBusPlanDetailKey();
        String monitorColumnKeyListStr = this.getPageCache().get("monitorColumnKeyList");
        if (monitorColumnKeyListStr != null) {
            List monitorColumnKeyList = (List)SerializationUtils.fromJsonString((String)monitorColumnKeyListStr, List.class);
            Map updateColumnKeyMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("updateColumnKeyMap"), Map.class);
            if (updateColumnKeyMap != null && updateColumnKeyMap.size() > 0) {
                ArrayList allvallues = new ArrayList(16);
                updateColumnKeyMap.values().stream().forEach(s -> allvallues.addAll(s));
                for (Map.Entry map : updateColumnKeyMap.entrySet()) {
                    String key = (String)map.getKey();
                    List updateKeyList = (List)map.getValue();
                    for (String updateKey : updateKeyList) {
                        this.updateNeedNumberColumn(entityEntryTemplateConfig, updateKey, rowIndex, entityname, entryTemplateConfigMap);
                    }
                }
            }
        }
    }

    private void updateNeedNumberColumn(EntryTemplateConfig entryTemplateConfig, String updateKey, int rowIndex, String enityName, Map<String, EntryTemplateConfig> entryTemplateConfigMap) {
        List list = entryTemplateConfig.getEntryColumns();
        for (BaseColumn column : list) {
            String key = column.getKey();
            if (!key.equals(updateKey)) continue;
            ColumnEnum type = column.getType();
            int value = type.getValue();
            switch (value) {
                case 7: {
                    this.handleNumberColumnUpdate(rowIndex, updateKey, column, enityName, entryTemplateConfigMap, entryTemplateConfig);
                    break;
                }
                case 12: {
                    if (this.checkBillEntity(enityName, rowIndex)) break;
                    this.handleDimonsionDataColumnUpdate(rowIndex, updateKey, column, enityName, entryTemplateConfigMap, entryTemplateConfig);
                }
            }
        }
    }

    private void setSubtotalStatus(boolean status) {
        this.getModel().setValue("showsubtotal", (Object)status);
    }

    private void clearSubtotalOlap() {
        Map entryTemplateConfig = this.getEntryInfoFromFormParam().getEntryTemplateConfig();
        for (Map.Entry stringEntryTemplateConfigEntry : entryTemplateConfig.entrySet()) {
            List<String> enableEditCols;
            Map stringSimpleDynamicObjectMap;
            String entityKey = (String)stringEntryTemplateConfigEntry.getKey();
            if (!this.isMainEntry(entityKey)) continue;
            EntryTemplateConfig templateConfig = (EntryTemplateConfig)stringEntryTemplateConfigEntry.getValue();
            Map subtotalCache = this.getSubtotalEntryCacheData().getBizEntryCache();
            if (subtotalCache == null || (stringSimpleDynamicObjectMap = (Map)subtotalCache.get(entityKey)) == null) continue;
            IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
            Collection values = stringSimpleDynamicObjectMap.values();
            List subtotaltemplateData = BgApplyBillUtils.getDeleteSubtotalOlapByTemplateData((EntryTemplateConfig)templateConfig, new ArrayList(values), (IModelCacheHelper)modelCacheHelper, enableEditCols = this.getEnableEditCols(entityKey));
            if (subtotaltemplateData.size() == 0) continue;
            BgApplyBillUtils.getInstance().saveOlapData(subtotaltemplateData, templateConfig.getDatasetId(), this.getUserId().longValue(), modelCacheHelper, templateConfig.getNumber());
        }
        this.clearSubtotalEntryCacheData();
    }
}

