/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.report.CellStyle;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyBillAggHelper;
import kd.epm.eb.business.applybill.util.ApplyBillPluginUitl;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.applybill.util.BgApplySplitUtil;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateColCfgService;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.mutex.MutexRecordHelper;
import kd.epm.eb.common.MutexRecordObj;
import kd.epm.eb.common.applyTemplate.constants.FormTypeEnum;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateAtAllCfgEntity;
import kd.epm.eb.common.applybill.AdjustShowTypeEnum;
import kd.epm.eb.common.applybill.AggTypeEnum;
import kd.epm.eb.common.applybill.ApplyBillConstant;
import kd.epm.eb.common.applybill.ApplyBillEntityData;
import kd.epm.eb.common.applybill.ApplyBillEntityNodeData;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.applybill.AuditRecordObj;
import kd.epm.eb.common.applybill.BillFieldStatus;
import kd.epm.eb.common.applybill.BillSaveEventArgs;
import kd.epm.eb.common.applybill.BillVerifyResult;
import kd.epm.eb.common.applybill.CellGroupStatusEnum;
import kd.epm.eb.common.applybill.CellValueObj;
import kd.epm.eb.common.applybill.ColumnsContext;
import kd.epm.eb.common.applybill.Count;
import kd.epm.eb.common.applybill.DecpBillData;
import kd.epm.eb.common.applybill.DecpRowData;
import kd.epm.eb.common.applybill.DecpStepData;
import kd.epm.eb.common.applybill.DecpStepManager;
import kd.epm.eb.common.applybill.DetailMembBillData;
import kd.epm.eb.common.applybill.DimensionColumnObj;
import kd.epm.eb.common.applybill.EntityCellBaseData;
import kd.epm.eb.common.applybill.EntityPathNode;
import kd.epm.eb.common.applybill.EntityRowDataType;
import kd.epm.eb.common.applybill.ParentRowSplitInfo;
import kd.epm.eb.common.applybill.PreSubmitSplitInfo;
import kd.epm.eb.common.applybill.RowDataStatus;
import kd.epm.eb.common.applybill.RowDimMembGroup;
import kd.epm.eb.common.applybill.RowIndexInfo;
import kd.epm.eb.common.applybill.RowInfo;
import kd.epm.eb.common.applybill.RowStatus;
import kd.epm.eb.common.applybill.SplitRowData;
import kd.epm.eb.common.applybill.SplitStatus;
import kd.epm.eb.common.applybill.SplitedDataInfo;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.BgApplyENtryInfo;
import kd.epm.eb.common.applytemplatecolumn.ColumnStyle;
import kd.epm.eb.common.applytemplatecolumn.DataMapDimension;
import kd.epm.eb.common.applytemplatecolumn.DimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.DimensionDataColumn;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.applytemplatecolumn.FieldTypeEnum;
import kd.epm.eb.common.applytemplatecolumn.NumberColumn;
import kd.epm.eb.common.applytemplatecolumn.OlapDataEntry;
import kd.epm.eb.common.applytemplatecolumn.TextColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.centralapproval.AdjustRecordColInfo;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.centralapproval.CentralAppShowInfo;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.split.BillRow;
import kd.epm.eb.common.split.DimMember;
import kd.epm.eb.common.split.NewRowInfo;
import kd.epm.eb.common.split.NewRowStatusEnum;
import kd.epm.eb.common.split.SplitDataCheckResult;
import kd.epm.eb.common.split.SplitLogObj;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.LogHelper;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.formplugin.applybill.BgApplyBillMultColTreePlugin;
import kd.epm.eb.olap.transaction.OlapTX;
import kd.epm.eb.olap.transaction.OlapTXHandle;

public class BgApplySplitBillPlugin
extends BgApplyBillMultColTreePlugin
implements SelectRowsEventListener,
HyperLinkClickListener {
    private DecpBillData decpBillData = null;
    private Map<String, Long> currentSplitRowId;
    private Map<String, Map<Long, Map<Long, Set<String>>>> allSplitedRowColKeys;
    private Map<String, Map<Long, Map<String, Integer>>> mutexSplitRowMembNums = null;
    private Map<String, Map<Long, SplitRowData>> allSplitRowInfo = null;
    private Map<String, String> currentSplitDimKeys = null;
    private Map<String, String> currentFocusDimKeys = null;
    private Map<Long, NewRowInfo> allNewRows = null;
    private String onCleanRepDim = null;
    private static final String NEWROWCOLOR = "#f2f2f2";

    private Map<String, String> getOrCacheCurrentSplitDimKeys(Map<String, String> currentSplitDimKeys) {
        if (currentSplitDimKeys == null) {
            if (this.currentSplitDimKeys == null) {
                String cacheStr = this.getPageCache().get("CurrentSplitDimKeys");
                this.currentSplitDimKeys = StringUtils.isNotEmpty((CharSequence)cacheStr) ? (Map<Object, Object>)SerializationUtils.fromJsonString((String)cacheStr, Map.class) : new HashMap<String, String>(16);
            }
        } else {
            this.currentSplitDimKeys = currentSplitDimKeys;
            this.getPageCache().put("CurrentSplitDimKeys", SerializationUtils.toJsonString(currentSplitDimKeys));
        }
        return this.currentSplitDimKeys;
    }

    private Map<String, String> getOrCacheCurrentFocusDimKeys(Map<String, String> currentFocusDimKeys) {
        if (currentFocusDimKeys == null) {
            if (this.currentFocusDimKeys == null) {
                String cacheStr = this.getPageCache().get("CurrentFocusDimKeys");
                this.currentFocusDimKeys = StringUtils.isNotEmpty((CharSequence)cacheStr) ? (Map<Object, Object>)SerializationUtils.fromJsonString((String)cacheStr, Map.class) : new HashMap<String, String>(16);
            }
        } else {
            this.currentFocusDimKeys = currentFocusDimKeys;
            this.getPageCache().put("CurrentFocusDimKeys", SerializationUtils.toJsonString(currentFocusDimKeys));
        }
        return this.currentFocusDimKeys;
    }

    private Map<Long, NewRowInfo> getOrCacheAllNewRowInfo(Map<Long, NewRowInfo> newRowsIds) {
        if (newRowsIds == null) {
            if (this.allNewRows == null) {
                String cacheStr = this.getPageCache().get("AllNewRowIds");
                this.allNewRows = StringUtils.isNotEmpty((CharSequence)cacheStr) ? (Map<Object, Object>)SerializationUtils.deSerializeFromBase64((String)cacheStr) : new HashMap<Long, NewRowInfo>(16);
            }
        } else {
            this.allNewRows = newRowsIds;
            this.getPageCache().put("AllNewRowIds", SerializationUtils.serializeToBase64(newRowsIds));
        }
        return this.allNewRows;
    }

    private void cacheAllSplitRowInfo() {
        if (this.allSplitRowInfo != null) {
            for (Map.Entry<String, Map<Long, SplitRowData>> entry : this.allSplitRowInfo.entrySet()) {
                this.getPageCache().put("SplitRowInfo_" + entry.getKey(), SerializationUtils.toJsonString(entry.getValue()));
            }
        }
    }

    private Map<Long, Map<Long, Set<String>>> getOrCacheSplitedRowColKeys(Map<Long, Map<Long, Set<String>>> splitedRowColKeys, String mainEntryKey) {
        if (this.allSplitedRowColKeys == null) {
            this.allSplitedRowColKeys = new HashMap<String, Map<Long, Map<Long, Set<String>>>>();
        }
        if (splitedRowColKeys == null) {
            splitedRowColKeys = this.allSplitedRowColKeys.get(mainEntryKey);
            if (splitedRowColKeys == null) {
                String cacheStr = this.getPageCache().get("SplitedRowColKeys_" + mainEntryKey);
                splitedRowColKeys = StringUtils.isNotEmpty((CharSequence)cacheStr) ? (HashMap)SerializationUtils.deSerializeFromBase64((String)cacheStr) : new HashMap(16);
                this.allSplitedRowColKeys.put(mainEntryKey, splitedRowColKeys);
            }
        } else {
            this.allSplitedRowColKeys.put(mainEntryKey, splitedRowColKeys);
            this.getPageCache().put("SplitedRowColKeys_" + mainEntryKey, SerializationUtils.serializeToBase64(splitedRowColKeys));
        }
        return splitedRowColKeys;
    }

    public Map<String, Map<Long, SplitRowData>> getAllSplitRowInfo(boolean loadAll) {
        if (this.allSplitRowInfo == null) {
            this.allSplitRowInfo = new HashMap<String, Map<Long, SplitRowData>>(16);
        }
        if (loadAll) {
            Set allMainEntryKeys = this.getEntryInfoFromFormParam().getEntryTemplateConfig().keySet();
            for (String entryKey : allMainEntryKeys) {
                if (!this.isMainEntry(entryKey) || this.allSplitRowInfo.containsKey(entryKey)) continue;
                this.getOrCacheSplitRowInfo(null, entryKey);
            }
        }
        return this.allSplitRowInfo;
    }

    private Map<Long, SplitRowData> getOrCacheSplitRowInfo(Map<Long, SplitRowData> splitRowDataMap, String mainEntryKey) {
        Map<String, Map<Long, SplitRowData>> allSplitRowInfo = this.getAllSplitRowInfo(false);
        if (splitRowDataMap == null) {
            splitRowDataMap = allSplitRowInfo.get(mainEntryKey);
            if (splitRowDataMap == null) {
                String cacheStr = this.getPageCache().get("SplitRowInfo_" + mainEntryKey);
                if (StringUtils.isNotEmpty((CharSequence)cacheStr)) {
                    ObjectMapper objectMapper = SerializationUtils.getObjectMapper2();
                    try {
                        splitRowDataMap = (Map<Long, SplitRowData>)objectMapper.readValue(cacheStr, (TypeReference)new TypeReference<Map<Long, SplitRowData>>(){});
                    }
                    catch (Exception e) {
                        throw new KDBizException(e.getMessage());
                    }
                } else {
                    splitRowDataMap = new HashMap<Long, SplitRowData>(16);
                }
                allSplitRowInfo.put(mainEntryKey, splitRowDataMap);
            }
        } else {
            allSplitRowInfo.put(mainEntryKey, splitRowDataMap);
            this.getPageCache().put("SplitRowInfo_" + mainEntryKey, SerializationUtils.toJsonString(splitRowDataMap));
        }
        return splitRowDataMap;
    }

    private void setCurrentSplitRowId(String splitEntryKey, Long rowId) {
        Map<String, Long> currentSplitRowId = this.getOrCacheCurrentSplitRowId(null);
        currentSplitRowId.put(splitEntryKey, rowId);
        this.getOrCacheCurrentSplitRowId(currentSplitRowId);
    }

    private Map<String, Long> getOrCacheCurrentSplitRowId(Map<String, Long> currentSplitRowId) {
        if (currentSplitRowId == null) {
            if (this.currentSplitRowId == null) {
                String cacheStr = this.getPageCache().get("CurrentSplitRowId");
                this.currentSplitRowId = StringUtils.isNotEmpty((CharSequence)cacheStr) ? (Map<Object, Object>)SerializationUtils.fromJsonString((String)cacheStr, Map.class) : new HashMap<String, Long>(16);
            }
        } else {
            this.currentSplitRowId = currentSplitRowId;
            this.getPageCache().put("CurrentSplitRowId", SerializationUtils.toJsonString(currentSplitRowId));
        }
        return this.currentSplitRowId;
    }

    protected DecpBillData getOrCacheDecpBillData(DecpBillData decpBillData) {
        if (decpBillData == null) {
            if (this.decpBillData == null) {
                String cacheStr = this.getPageCache().get("DecpBillDataCache");
                this.decpBillData = (DecpBillData)SerializationUtils.fromJsonString((String)cacheStr, DecpBillData.class);
            }
            decpBillData = this.decpBillData;
        } else {
            this.decpBillData = decpBillData;
            this.getPageCache().put("DecpBillDataCache", SerializationUtils.toJsonString((Object)decpBillData));
        }
        return decpBillData;
    }

    @Override
    public void initialize() {
        super.initialize();
        for (String entryKey : this.getEntryInfoFromFormParam().getSplitEntryConfig().keySet()) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
            entryGrid.addRowClickListener((RowClickEventListener)this);
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
        this.dealMemberShowTypeChange();
    }

    @Override
    protected void beforeInitEntityData() {
        super.beforeInitEntityData();
    }

    private void selectSplitedRowColKeys() {
        this.getEntryInfoFromFormParam().getEntryTemplateConfig().forEach((entryKey, tempConfig) -> {
            if (this.isMainEntry((String)entryKey)) {
                Set splitColKeys = tempConfig.getSplitSubKeyMap().keySet();
                Map<Long, SplitRowData> splitRowInfo = this.getOrCacheSplitRowInfo(null, (String)entryKey);
                HashMap<Long, Map<Long, Set<String>>> splitedKeys = new HashMap<Long, Map<Long, Set<String>>>(16);
                splitRowInfo.forEach((preSplitRowId, splitedRowDataOnDim) -> splitedRowDataOnDim.getSplitedRows().values().forEach(splitRowDatas -> splitRowDatas.forEach((rowId, rowData) -> {
                    Map keysOnPreSplitRow = splitedKeys.computeIfAbsent((Long)rowId, key -> new HashMap(16));
                    Set keys = keysOnPreSplitRow.computeIfAbsent(preSplitRowId, key -> new HashSet(16));
                    boolean pastSplitKey = rowData.isPastByZero() && this.noChangeSplitData((SplitedDataInfo)rowData, splitColKeys);
                    for (String key2 : rowData.getHadSaveData().keySet()) {
                        if (pastSplitKey && splitColKeys.contains(key2)) continue;
                        keys.add(key2);
                    }
                })));
                this.getOrCacheSplitedRowColKeys((Map<Long, Map<Long, Set<String>>>)splitedKeys, (String)entryKey);
            }
        });
    }

    @Override
    protected void setEntityInitData(EntryTemplateConfig mainEntryConfig, Map<String, Map<String, Set<Long>>> groupMembsByStats, DetailMembBillData detailMembBillData, String entityKey, Long bizCtrlRangeId, IModelCacheHelper modelCacheHelper, ApplyBillEntityData billEntityData) {
        DecpBillData decpBillData = this.getOrCacheDecpBillData(null);
        if (decpBillData.isFirstStep() && decpBillData.isNotInitedDecpData()) {
            this.copyAuditSubData2SplitData(mainEntryConfig, detailMembBillData.getAllRowData());
        }
        String entrySeq = entityKey.replace("entryentity", "");
        String splitEntryKey = "splitentryentity" + entrySeq;
        EntryTemplateConfig splitEntryConfig = (EntryTemplateConfig)this.getEntryInfoFromFormParam().getSplitEntryConfig().get(splitEntryKey);
        Map<Long, SplitRowData> splitRowDataMap = this.getOrCacheSplitRowInfo(null, entityKey);
        List<Object[]> splitData = null;
        if (splitRowDataMap.isEmpty()) {
            splitData = this.selectSplitData(decpBillData, detailMembBillData, mainEntryConfig);
            this.filterNoAdjRowAndSelectAdjData(splitData, mainEntryConfig, splitEntryConfig, detailMembBillData, splitRowDataMap);
        } else {
            splitData = this.selectSplitData(detailMembBillData, mainEntryConfig, splitEntryConfig, splitRowDataMap);
        }
        this.handleLogSplitRowDataMap(splitRowDataMap, this.getBillNumber(), mainEntryConfig.getNumber());
        this.updateCalculateData(splitData, splitEntryConfig, true);
        this.initPreSplitEntry(splitEntryKey, splitData, splitRowDataMap, splitEntryConfig, mainEntryConfig);
    }

    private void handleLogSplitRowDataMap(Map<Long, SplitRowData> splitRowDataMap, String billNumber, String tempNumber) {
        String sign;
        Set<String> logSignsFromForm = this.getLogSignsFromForm();
        if (logSignsFromForm.contains(sign = "LogSplitRowDataMap-" + billNumber)) {
            CommonServiceHelper.handleLog((Log)this.getLog(), (String)("SplitRowData:" + billNumber + ":" + tempNumber), (String)SerializationUtils.toJsonString(splitRowDataMap));
        }
    }

    private void initPreSplitEntry(String splitEntryKey, List<Object[]> splitData, Map<Long, SplitRowData> splitRowDataMap, EntryTemplateConfig splitEntryConfig, EntryTemplateConfig mainEntryConfig) {
        if (splitData.isEmpty()) {
            return;
        }
        IDataModel dataModel = this.getModel();
        dataModel.deleteEntryData(splitEntryKey);
        dataModel.batchCreateNewEntryRow(splitEntryKey, splitData.size());
        int rowIndex = 0;
        Map<String, String> subKeyMapSplitCol = splitEntryConfig.getSplitSubKeyMap().entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getValue(), entry -> (String)entry.getKey()));
        for (Object[] rowData : splitData) {
            Long rowId = ApplyBillAggHelper.getInstance().getRowId(rowData);
            SplitRowData splitRowData = splitRowDataMap.get(rowId);
            DynamicObject rowObj = dataModel.getEntryRowEntity(splitEntryKey, rowIndex);
            rowObj.set("id", (Object)rowId);
            for (BaseColumn column : splitEntryConfig.getEntryColumns()) {
                String key = column.getKey();
                if (key.contains("splitdim")) {
                    String splitDimStr = this.buildSplitDimStr(mainEntryConfig.selectColumnMap(), splitRowData.getNotDetailDimColumn());
                    dataModel.setValue(key, (Object)splitDimStr, rowIndex);
                    continue;
                }
                if (key.contains("splitdata")) {
                    String splitCol = subKeyMapSplitCol.get(key);
                    BigDecimal subData = (BigDecimal)splitRowData.getSubData().get(splitCol);
                    dataModel.setValue(key, (Object)subData, rowIndex);
                    continue;
                }
                if (key.contains("splitstatus")) {
                    boolean modified;
                    Map allSubData = splitRowData.getSubData();
                    boolean end = true;
                    for (Map.Entry subDataEntry : allSubData.entrySet()) {
                        if (((BigDecimal)subDataEntry.getValue()).compareTo(BigDecimal.ZERO) == 0) continue;
                        end = false;
                        break;
                    }
                    if (end) {
                        dataModel.setValue(key, (Object)SplitStatus.SPLITEND.getName(), rowIndex);
                        continue;
                    }
                    boolean bl = modified = splitRowData.getSplitedData() != null && !splitRowData.getSplitedData().getHadSaveData().isEmpty();
                    if (modified) {
                        dataModel.setValue(key, (Object)SplitStatus.SPLITING.getName(), rowIndex);
                        continue;
                    }
                    dataModel.setValue(key, (Object)SplitStatus.NOTSPLIT.getName(), rowIndex);
                    continue;
                }
                if (key.endsWith("_text") || column.isIgnoreDB()) continue;
                int index = (Integer)splitEntryConfig.getColumnIndex().get(key);
                dataModel.setValue(key, rowData[index], rowIndex);
            }
            ++rowIndex;
        }
    }

    private String buildSplitDimStr(Map<String, BaseColumn> columnMap, List<String> notDetailDimColumn) {
        StringBuilder sb = new StringBuilder();
        for (String dimKey : notDetailDimColumn) {
            BaseColumn dimColumn = columnMap.get(dimKey);
            sb.append(dimColumn.getTitle()).append(',');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private void copyAuditSubData2SplitData(EntryTemplateConfig templateConfig, List<Object[]> rowDatas) {
        ApplyBillAggHelper billAggHelper = ApplyBillAggHelper.getInstance();
        Map columnIndex = templateConfig.getColumnIndex();
        Count copyRowCount = new Count();
        for (Object[] rowData : rowDatas) {
            String dataType = billAggHelper.getRowDataType(rowData);
            if (EntityRowDataType.isDetailData((String)dataType)) continue;
            templateConfig.getSplitColumnMap().forEach((splitCol, auditCol) -> {
                rowData[((Integer)columnIndex.get((Object)splitCol)).intValue()] = rowData[(Integer)columnIndex.get(auditCol)];
            });
            copyRowCount.addOne();
        }
        this.getLog().info("copyAuditData2SplitData-count:" + this.getBillNumber() + ":" + templateConfig.getNumber() + ":" + copyRowCount.getCount());
    }

    private void filterNoAdjRowAndSelectAdjData(List<Object[]> splitAllRowData, EntryTemplateConfig mainEntryTempConfig, EntryTemplateConfig splitEntryConfig, DetailMembBillData detailMembBillData, Map<Long, SplitRowData> splitRowDataMap) {
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        Iterator<Object[]> iterator = splitAllRowData.iterator();
        while (iterator.hasNext()) {
            Object[] rowData = iterator.next();
            Map<String, BigDecimal> subData = this.selectSubData(rowData, splitEntryConfig);
            if (subData.isEmpty()) {
                iterator.remove();
                continue;
            }
            SplitRowData splitRowData = new SplitRowData();
            Long rowId = ApplyBillAggHelper.getInstance().getRowId(rowData);
            splitRowDataMap.put(rowId, splitRowData);
            splitRowData.setSubData(subData);
            ArrayList<String> notDetailDim = new ArrayList<String>(16);
            HashMap<String, String> dimMembNums = new HashMap<String, String>(16);
            this.selectRowDimMembInfo(dimMembNums, notDetailDim, rowData, mainEntryTempConfig, modelCacheHelper);
            this.updateAggData(rowData, mainEntryTempConfig, dimMembNums, detailMembBillData);
            splitRowData.setNotDetailDimColumn(notDetailDim);
        }
    }

    private void updateAggData(Object[] rowData, EntryTemplateConfig mainEntryTempConfig, Map<String, String> dimMembNums, DetailMembBillData detailMembBillData) {
        Map aggData = ApplyBillAggHelper.getInstance().getData(dimMembNums, detailMembBillData, (Collection)mainEntryTempConfig.getAggKeys(), mainEntryTempConfig);
        for (Map.Entry entry : aggData.entrySet()) {
            int index = (Integer)mainEntryTempConfig.getColumnIndex().get(entry.getKey());
            rowData[index] = entry.getValue();
        }
    }

    private Map<String, BigDecimal> selectSubData(Object[] rowData, EntryTemplateConfig splitEntryConfig) {
        HashMap<String, BigDecimal> subData = new HashMap<String, BigDecimal>(16);
        for (Map.Entry splitAuditColEntry : splitEntryConfig.getSplitColumnMap().entrySet()) {
            String splitCol = (String)splitAuditColEntry.getKey();
            int index = (Integer)splitEntryConfig.getColumnIndex().get(splitCol);
            BigDecimal data = (BigDecimal)rowData[index];
            if (data == null || data.compareTo(BigDecimal.ZERO) == 0) continue;
            subData.put(splitCol, data);
        }
        return subData;
    }

    private void selectRowDimMembInfo(Map<String, String> dimMembs, List<String> notDetailDim, Object[] rowData, EntryTemplateConfig templateConfig, IModelCacheHelper modelCacheHelper) {
        List dimKeysList = templateConfig.getDimKeysList();
        Map columnIndex = templateConfig.getColumnIndex();
        Map columnMapDimNum = templateConfig.selectColumnMapDimNum();
        Map viewsByDataSet = modelCacheHelper.getViewsByDataSet(Long.valueOf(templateConfig.getDatasetId()));
        for (String dimColumn : dimKeysList) {
            Long membId = (Long)rowData[(Integer)columnIndex.get(dimColumn)];
            String dimNum = (String)columnMapDimNum.get(dimColumn);
            Long viewId = (Long)viewsByDataSet.get(dimNum);
            Member member = modelCacheHelper.getMember(dimNum, viewId, membId);
            if (notDetailDim != null && !member.isLeaf()) {
                notDetailDim.add(dimColumn);
            }
            String membNumber = member.getNumber();
            dimMembs.put(dimColumn, membNumber);
        }
    }

    private List<Object[]> selectSplitData(DetailMembBillData detailMembBillData, EntryTemplateConfig templateConfig, EntryTemplateConfig splitEntryConfig, Map<Long, SplitRowData> splitRowDataMap) {
        ArrayList<Object[]> result = new ArrayList<Object[]>(16);
        ApplyBillAggHelper billAggHelper = ApplyBillAggHelper.getInstance();
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        detailMembBillData.getAllRowData().forEach(rowData -> {
            Long rowId = billAggHelper.getRowId(rowData);
            SplitRowData splitRowData = (SplitRowData)splitRowDataMap.get(rowId);
            if (splitRowData != null) {
                Object[] rowDataCopy = Arrays.copyOf(rowData, ((Object[])rowData).length);
                Map<String, BigDecimal> subData = this.selectSubData(rowDataCopy, splitEntryConfig);
                splitRowData.getSubData().clear();
                splitRowData.getSubData().putAll(subData);
                result.add(rowDataCopy);
                HashMap<String, String> dimMembs = new HashMap<String, String>(16);
                this.selectRowDimMembInfo(dimMembs, null, rowDataCopy, templateConfig, modelCacheHelper);
                this.updateAggData(rowDataCopy, templateConfig, dimMembs, detailMembBillData);
            }
        });
        return result;
    }

    private List<Object[]> selectSplitData(DecpBillData decpBillData, DetailMembBillData detailMembBillData, EntryTemplateConfig templateConfig) {
        ArrayList<Object[]> result = new ArrayList<Object[]>(16);
        int orgColumnIndex = (Integer)templateConfig.getColumnIndex().get(templateConfig.getOrgColumnKey());
        if (orgColumnIndex > 0) {
            Set nextStepDecpOrgIds = decpBillData.getNextStepDecpOrgIds();
            Set<Long> splitOrgRangeMembIds = this.getSplitRangeOrgIds(nextStepDecpOrgIds, decpBillData.getOrderOrgId());
            for (Object[] rowData : detailMembBillData.getAllRowData()) {
                Long orgId;
                String dataType = ApplyBillAggHelper.getInstance().getRowDataType(rowData);
                if (EntityRowDataType.isDetailData((String)dataType) || !splitOrgRangeMembIds.contains(orgId = (Long)rowData[orgColumnIndex])) continue;
                result.add(Arrays.copyOf(rowData, rowData.length));
            }
        }
        return result;
    }

    @Override
    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"advcontoolbarap1"});
        super.registerListener(e);
    }

    @Override
    protected void doViewAjust() {
        Tab tab = (Tab)this.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        String entityName = currentTab.replaceAll("tabentryentity", "splitentryentity");
        EntryGrid entrygrid = (EntryGrid)this.getView().getControl(entityName);
        int[] selectRows = entrygrid.getSelectRows();
        if (selectRows != null && selectRows.length == 1) {
            int currentRowIndex = selectRows[0];
            if (currentRowIndex > -1) {
                DynamicObject currentRowObj = this.getModel().getEntryRowEntity(entityName, currentRowIndex);
                EntryTemplateConfig splitEntryConfig = this.getSplitEntryConfig(entityName);
                HashMap dims = new HashMap(16);
                Map columnMapDimNum = splitEntryConfig.selectColumnMapDimNum();
                for (String dimKey : splitEntryConfig.getDimKeysList()) {
                    DynamicObject dimObj = currentRowObj.getDynamicObject(dimKey);
                    if (dimObj == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ef4\u5ea6\u7ec4\u5408\u4e0d\u5168\u3002", (String)"BgApplyBillPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    dims.put(columnMapDimNum.get(dimKey), dimObj.getString("number"));
                }
                log.info("showAdjInfo:" + this.getBillNumber() + " dimInfo:" + ((Object)dims).toString());
                FormShowParameter adjustShowPage = CentralAppBillService.getInstance().getAdjustShowPage(this.getSrcApproveBillNo(), null, dims, Long.valueOf(splitEntryConfig.getTemplateID()), AdjustShowTypeEnum.Adjust, ApplyBillType.APPLYAUDIT, Long.valueOf(splitEntryConfig.getDatasetId()), this.getModelId());
                adjustShowPage.setCustomParam("billFormType", (Object)ApplyBillType.SPLIT.getNumber());
                this.getView().showForm(adjustShowPage);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"BgApplyBillPlugin_53", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private String getSrcApproveBillNo() {
        DecpBillData billData = this.getOrCacheDecpBillData(null);
        Long sourceBillId = billData.getSourceBillId();
        DynamicObject query = QueryServiceHelper.queryOne((String)"eb_centralappbill", (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourceBillId)});
        if (query == null) {
            return "";
        }
        return query.getString("billno");
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        if ("changesplitdim".equals(opKey)) {
            this.handleChangeSplitDim();
        } else if ("savesplit".equals(opKey)) {
            this.handleSubmit(args);
        }
    }

    private void handleChangeSplitDim() {
        String currentSplitEntryKey = this.getCurrentSplitEntryKey();
        EntryGrid entryGrid = (EntryGrid)this.getControl(currentSplitEntryKey);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"BgApplyBillPlugin_53", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.showPreDimSetForm();
        }
    }

    private void updateSplitResultEntryData(String splitEntryKey, int rowIndex) {
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(splitEntryKey, rowIndex);
        Long rowId = entryRowEntity.getLong("id");
        String mainEntryKey = this.getMainEntryKey(splitEntryKey);
        Map<String, Long> allSplitRowId = this.getOrCacheCurrentSplitRowId(null);
        allSplitRowId.put(splitEntryKey, rowId);
        Map<Long, SplitRowData> splitRowInfo = this.getOrCacheSplitRowInfo(null, mainEntryKey);
        this.updateSplitResultEntryData(mainEntryKey, splitEntryKey, rowId, splitRowInfo, entryRowEntity, null);
        this.getOrCacheCurrentSplitRowId(allSplitRowId);
        this.updateSplitDimPathShow(mainEntryKey, rowId);
    }

    private void updateSplitResultEntryData(String mainEntryKey, String splitEntryKey, Long currenSplitrowId, Map<Long, SplitRowData> splitRowInfo, DynamicObject entryRowEntity, String toSplitDimKey) {
        SplitRowData newSplitRowData = splitRowInfo.get(currenSplitrowId);
        DetailMembBillData detailMembBillData = this.getSourceData(mainEntryKey);
        EntryTemplateConfig mainEntryTempConfig = this.getTempConfig(mainEntryKey);
        this.getModel().deleteEntryData(mainEntryKey);
        if (newSplitRowData == null) {
            return;
        }
        if (toSplitDimKey != null) {
            newSplitRowData.setCurrentFocusSplitDim(toSplitDimKey);
        }
        List<Map<String, String>> rowsMembNums = this.getToShowFirstSplitRowMembNums(newSplitRowData, entryRowEntity, currenSplitrowId, splitEntryKey);
        HashMap<Integer, Map<String, String>> noDetailMembers = new HashMap<Integer, Map<String, String>>(rowsMembNums.size());
        for (int i = 0; i < rowsMembNums.size(); ++i) {
            Map<String, String> membNums = rowsMembNums.get(i);
            noDetailMembers.put(i, membNums);
        }
        ApplyBillEntityNodeData billEntityNodeData = this.getOrCacheBillEntityNodeData(mainEntryKey, null, true);
        ApplyBillEntityData billEntityData = new ApplyBillEntityData();
        ArrayList<RowInfo> levelOneSplitRowIndexs = new ArrayList<RowInfo>(16);
        this.getOrCacheMutexMembNums(null, mainEntryKey).clear();
        this.setNeedDealPropchange(false);
        int index = 0;
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        String currentSplitDim = newSplitRowData.getCurrentFocusSplitDim();
        Set<String> allParentNums = this.getAllParentNums(currentSplitDim, this.getSourceData(mainEntryKey));
        Map columnMapDimNum = mainEntryTempConfig.selectColumnMapDimNum();
        String currentDimNum = (String)columnMapDimNum.get(currentSplitDim);
        Long viewId = modelCacheHelper.getViewByDataSetAndDimNumber(Long.valueOf(mainEntryTempConfig.getDatasetId()), currentDimNum);
        billEntityNodeData.getNodeEntityData().clear();
        billEntityNodeData.addNodeData(billEntityData);
        Map<Long, NewRowInfo> allNewRowIds = this.getOrCacheAllNewRowInfo(null);
        HashMap newRowMapSplitRow = new HashMap(16);
        String tempNumber = mainEntryTempConfig.getNumber();
        allNewRowIds.forEach((newRowId, refSplitRowInfo) -> {
            if (tempNumber.equals(refSplitRowInfo.getTemplateNumber()) && refSplitRowInfo.getStatus() != NewRowStatusEnum.DELETED) {
                Set rowIds = newRowMapSplitRow.computeIfAbsent(refSplitRowInfo.getRefLevelOneSplitRowId(), key -> new HashSet(16));
                rowIds.add(newRowId);
            }
        });
        boolean showNewRow = (Boolean)this.getValue("shownewrow", null);
        Map aggColumnDataMap = BgApplyBillUtils.getInstance().getOlapDataForNoDetail(mainEntryTempConfig, noDetailMembers, mainEntryTempConfig.getAggKeys());
        for (Map<String, String> membNums : rowsMembNums) {
            Map data = (Map)aggColumnDataMap.get(index);
            this.initFirstRow(null, index, membNums, detailMembBillData, modelCacheHelper, billEntityData, mainEntryKey, mainEntryTempConfig, data);
            Long levelOneSplitRowId = billEntityData.getRowIbByIndex(index);
            levelOneSplitRowIndexs.add(new RowInfo(index, index, levelOneSplitRowId));
            Member mainMemb = modelCacheHelper.getMember(currentDimNum, viewId, membNums.get(currentSplitDim));
            int childRowCount = this.initRowDataToCache(index, currentSplitDim, mainEntryKey, mainMemb, allParentNums, mainEntryTempConfig.getAggKeys(), false);
            index = childRowCount + 1;
            Set newRowIds = (Set)newRowMapSplitRow.get(levelOneSplitRowId);
            if (newRowIds == null || newRowIds.size() <= 0 || !showNewRow) continue;
            int newRowCount = this.initNewRowToCache(index, newRowIds, detailMembBillData.getAllRowData(), billEntityData, mainEntryTempConfig, modelCacheHelper, currentSplitDim);
            int beginIndex = index;
            index += newRowCount;
            while (beginIndex < index) {
                ++beginIndex;
            }
        }
        List indexs = CommonServiceHelper.buildIntArrays((int)index);
        Map<Long, Map<String, Integer>> mutexMembOnDim = this.selectMutexMembOnDim(mainEntryKey, newSplitRowData, currenSplitrowId);
        this.getOrCacheMutexMembNums(mutexMembOnDim, mainEntryKey);
        this.openChildRowFromCache(this.getModel(), billEntityData, -1, -1, CommonServiceHelper.changeIntArrays((Collection)indexs), mainEntryKey, mainEntryTempConfig.getColumnIndex(), currentSplitDim);
        this.addPathNode(billEntityNodeData, newSplitRowData.getCurrentFocusSplitDim(), newSplitRowData.getNotDetailDimColumn());
        this.updateFirstSplitRowSplitSubData(levelOneSplitRowIndexs, mainEntryTempConfig);
        List<Integer> rowIndexsOnPage = levelOneSplitRowIndexs.stream().map(row -> row.getIndexOnPage()).collect(Collectors.toList());
        this.updateRowsRelationValues(rowIndexsOnPage, mainEntryTempConfig);
        this.setNeedDealPropchange(true);
        this.signFirstSplitRow(levelOneSplitRowIndexs, mainEntryKey);
        this.getOrCacheBillEntityNodeData(mainEntryKey, billEntityNodeData);
        this.checkLockResultEntry(newSplitRowData, mainEntryKey);
        Map<String, String> currentSplitDimKeys = this.getOrCacheCurrentSplitDimKeys(null);
        Map<String, String> currentFocusDimKeys = this.getOrCacheCurrentFocusDimKeys(null);
        currentSplitDimKeys.put(mainEntryKey, newSplitRowData.getCurrentSplitDim());
        currentFocusDimKeys.put(mainEntryKey, newSplitRowData.getCurrentFocusSplitDim());
        this.getOrCacheCurrentSplitDimKeys(currentSplitDimKeys);
        this.getOrCacheCurrentFocusDimKeys(currentFocusDimKeys);
        this.changeNewRowItemShow(mainEntryKey);
    }

    @Override
    protected boolean childRowCanShow(Map<String, BigDecimal> bizData, EntryTemplateConfig templateConfig, String entryKey, Set<Long> matchRowIds) {
        boolean result = super.childRowCanShow(bizData, templateConfig, entryKey, matchRowIds);
        if (result) {
            Map<Long, NewRowInfo> newRowIds = this.getOrCacheAllNewRowInfo(null);
            result = !newRowIds.keySet().containsAll(matchRowIds);
        }
        return result;
    }

    private int initNewRowToCache(int beginIndex, Set<Long> newRowIds, List<Object[]> allRowData, ApplyBillEntityData billEntityData, EntryTemplateConfig templateConfig, IModelCacheHelper modelCacheHelper, String currentSplitDim) {
        Map viewIds = modelCacheHelper.getViewsByDataSet(Long.valueOf(templateConfig.getDatasetId()));
        int count = 0;
        for (Object[] rowData : allRowData) {
            Long rowId = ApplyBillAggHelper.getInstance().getRowId(rowData);
            if (!newRowIds.remove(rowId)) continue;
            this.initOneRowToCahce(templateConfig, rowData, null, beginIndex, viewIds, modelCacheHelper, rowId, currentSplitDim, billEntityData);
            ++beginIndex;
            ++count;
        }
        if (newRowIds.size() > 0) {
            Map<Long, NewRowInfo> allNewRowInfo = this.getOrCacheAllNewRowInfo(null);
            for (Long rowId : newRowIds) {
                NewRowInfo newRowInfo = allNewRowInfo.get(rowId);
                if (newRowInfo == null || newRowInfo.getRowDimMembIds() == null) continue;
                this.initOneRowToCahce(templateConfig, null, newRowInfo.getRowDimMembIds(), beginIndex, viewIds, modelCacheHelper, rowId, currentSplitDim, billEntityData);
                ++beginIndex;
                ++count;
            }
        }
        return count;
    }

    private void initOneRowToCahce(EntryTemplateConfig templateConfig, Object[] rowData, Map<String, Long> rowDimMembIds, int beginIndex, Map<String, Long> viewIds, IModelCacheHelper modelCacheHelper, Long rowId, String currentSplitDim, ApplyBillEntityData billEntityData) {
        Map columnIndex = templateConfig.getColumnIndex();
        Long membId = 0L;
        for (String dimColKey : templateConfig.getDimKeysList()) {
            if (rowData != null) {
                membId = (Long)rowData[(Integer)columnIndex.get(dimColKey)];
            } else if (rowDimMembIds != null) {
                membId = rowDimMembIds.get(dimColKey);
            }
            String dimNum = (String)templateConfig.selectColumnMapDimNum().get(dimColKey);
            Member member = modelCacheHelper.getMember(dimNum, viewIds.get(dimNum), membId);
            this.setData(billEntityData, beginIndex, null, dimColKey, member);
        }
        HashMap<String, BigDecimal> bizData = new HashMap<String, BigDecimal>(16);
        Object aggVal = null;
        for (String aggKey : templateConfig.getAggKeys()) {
            if (rowData != null) {
                aggVal = rowData[(Integer)columnIndex.get(aggKey)];
            }
            if (aggVal instanceof BigDecimal) {
                bizData.put(aggKey, (BigDecimal)aggVal);
                continue;
            }
            bizData.put(aggKey, this.getZero());
        }
        billEntityData.addRowId(beginIndex, rowId);
        this.setOtherData(null, bizData, columnIndex, rowData, templateConfig.selectColumnMapDimNum().keySet(), beginIndex, beginIndex, billEntityData);
        billEntityData.getRowChanged().add(beginIndex, false);
        EntityCellBaseData currentSplitDimCellData = billEntityData.getCellBaseData(beginIndex, currentSplitDim);
        if (currentSplitDimCellData != null) {
            currentSplitDimCellData.setLevel(2);
        }
    }

    @Override
    protected boolean signNotFocusDimCell() {
        return false;
    }

    private List<Map<String, String>> getToShowFirstSplitRowMembNums(SplitRowData newSplitRowData, DynamicObject entryRowEntity, Long currenSplitrowId, String splitEntryKey) {
        EntryTemplateConfig splitEntryConfig = this.getSplitEntryConfig(splitEntryKey);
        String mainEntryKey = this.getMainEntryKey(splitEntryKey);
        EntryTemplateConfig mainEntryTempConfig = this.getTempConfig(mainEntryKey);
        DetailMembBillData detailMembBillData = this.getSourceData(mainEntryKey);
        String preSplitDim = newSplitRowData.getPreSplitDim(newSplitRowData.getCurrentFocusSplitDim());
        ArrayList<Map<String, String>> rowsMembNums = new ArrayList<Map<String, String>>(16);
        if (preSplitDim == null) {
            Map<String, String> membNumList = this.getDimMembNumList(currenSplitrowId, splitEntryKey, entryRowEntity, splitEntryConfig.getDimKeysList());
            Map<String, String> membNumListToMain = membNumList.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).replace("s_", "h_"), e -> (String)e.getValue()));
            rowsMembNums.add(membNumListToMain);
        } else {
            Map toSplitRowDataOnDim = (Map)newSplitRowData.getSplitedRows().get(preSplitDim);
            List allRowData = detailMembBillData.getAllRowData();
            Set<String> splitKeys = mainEntryTempConfig.getSplitSubKeyMap().keySet();
            IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
            for (Object[] rowData : allRowData) {
                Long rowID = ApplyBillAggHelper.getInstance().getRowId(rowData);
                SplitedDataInfo splitedDataInfo = (SplitedDataInfo)toSplitRowDataOnDim.get(rowID);
                if (splitedDataInfo == null || this.noChangeSplitData(splitedDataInfo, splitKeys) && splitedDataInfo.isPastByZero() || this.isNewRow(rowID)) continue;
                HashMap<String, String> rowMembNums = new HashMap<String, String>();
                this.selectRowDimMembInfo(rowMembNums, null, rowData, mainEntryTempConfig, modelCacheHelper);
                rowsMembNums.add(rowMembNums);
            }
        }
        return rowsMembNums;
    }

    private boolean noChangeSplitData(SplitedDataInfo splitedDataInfo, Set<String> splitColKeys) {
        Map hadSaveData = splitedDataInfo.getHadSaveData();
        Map notSaveData = splitedDataInfo.getNotSaveData();
        for (String key : splitColKeys) {
            CellValueObj nVal;
            BigDecimal sum = this.getZero();
            CellValueObj sVal = (CellValueObj)hadSaveData.get(key);
            if (sVal != null && sVal.getCurrentVal() != null) {
                sum = sum.add((BigDecimal)sVal.getCurrentVal());
            }
            if ((nVal = (CellValueObj)notSaveData.get(key)) != null && nVal.getCurrentVal() != null) {
                sum = sum.add((BigDecimal)nVal.getCurrentVal());
            }
            if (sum.compareTo(BigDecimal.ZERO) == 0) continue;
            return false;
        }
        return true;
    }

    private void checkLockResultEntry(SplitRowData newSplitRowData, String entryKey) {
        boolean canEdit = newSplitRowData.getCurrentSplitDim().equals(newSplitRowData.getCurrentFocusSplitDim());
        this.getView().setEnable(Boolean.valueOf(canEdit), new String[]{entryKey});
    }

    private boolean isCommited() {
        DecpBillData decpBillData = this.getOrCacheDecpBillData(null);
        return decpBillData.isSplited();
    }

    private void addPathNode(ApplyBillEntityNodeData billEntityNodeData, String currentSplitDimCol, List<String> splitDimCols) {
        List nodes = billEntityNodeData.getNodes();
        nodes.clear();
        for (String dimCol : splitDimCols) {
            EntityPathNode pathNode = new EntityPathNode(null, null);
            pathNode.setRefDimColumnKey(dimCol);
            nodes.add(pathNode);
            if (!dimCol.equals(currentSplitDimCol)) continue;
            break;
        }
    }

    @Override
    protected void upNodePathShow4CellClick(int currentIndex, int preIndex, String columnKey, String entityKey, boolean isUp) {
    }

    private void updateFirstSplitRowSplitSubData(List<RowInfo> newRowInfo, EntryTemplateConfig mainEntryTempConfig) {
        IDataModel dataModel = this.getModel();
        for (RowInfo rowInfo : newRowInfo) {
            mainEntryTempConfig.getSplitSubKeyMap().forEach((splitCol, preSplitCol) -> {
                BigDecimal splitData = (BigDecimal)dataModel.getValue(splitCol, rowInfo.getIndexOnPage());
                BigDecimal splitSubData = (BigDecimal)dataModel.getValue(preSplitCol, rowInfo.getIndexOnPage());
                dataModel.setValue(splitCol, (Object)splitData.subtract(splitSubData), rowInfo.getIndexOnPage());
            });
        }
    }

    private void signFirstSplitRow(List<RowInfo> newRowInfo, String mainEntryKey) {
        int[] toLockRows = new int[newRowInfo.size()];
        for (int count = 0; count < newRowInfo.size(); ++count) {
            toLockRows[count] = newRowInfo.get(count).getIndexOnPage();
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(mainEntryKey);
        entryGrid.setRowLock(true, toLockRows);
        entryGrid.setRowBackcolor("#e5e5e5", toLockRows);
    }

    @Override
    public void afterModifColumnCellChange(String entityKey, Object newValue, Object oldValue, Long currentRowId, String columnKey, int rowIndex) {
        BgApplyBillUtils.getInstance().setOneAdjustedColumnColor(this.getView(), entityKey, rowIndex, columnKey);
        this.cacheModifColKey(entityKey, currentRowId, columnKey);
    }

    private void cacheModifColKey(String entityKey, Long currentRowId, String columnKey) {
        Long currentSplitRowId;
        Map<Long, Map<Long, Set<String>>> splitedRowColKeys = this.getOrCacheSplitedRowColKeys(null, entityKey);
        Map keysOnPreSplitRow = splitedRowColKeys.computeIfAbsent(currentRowId, key -> new HashMap(16));
        Set keys = keysOnPreSplitRow.computeIfAbsent(currentSplitRowId = this.getCurrentSplitRowId(entityKey), key -> new HashSet(16));
        if (keys.add(columnKey)) {
            this.getOrCacheSplitedRowColKeys(splitedRowColKeys, entityKey);
        }
    }

    @Override
    protected void recordColumnInitData(String entryKey, Long currentRowId, Object oldValue, String columnKey) {
    }

    @Override
    protected boolean dealNewRowColChanged() {
        return true;
    }

    @Override
    public void dealOthModifColumnCellChange(String mainEntityKey, Object newValue, Object oldValue, Long currentRowId, String columnKey, int rowIndex) {
        Map<Long, SplitRowData> splitRowInfo = this.getOrCacheSplitRowInfo(null, mainEntityKey);
        this.recordChangedVal(mainEntityKey, splitRowInfo, newValue, oldValue, currentRowId, columnKey, rowIndex);
        this.updatePreSplitDataOnChange(mainEntityKey, splitRowInfo, newValue, oldValue, currentRowId, columnKey, rowIndex);
        this.getOrCacheSplitRowInfo(splitRowInfo, mainEntityKey);
    }

    private void recordChangedVal(String mainEntityKey, Map<Long, SplitRowData> splitRowInfo, Object newValue, Object oldValue, Long currentRowId, String columnKey, int rowIndex) {
        Long currentSplitRowId;
        SplitRowData splitRowData;
        String currentSplitDim;
        EntryTemplateConfig tempConfig = this.getTempConfig(mainEntityKey);
        if (tempConfig.getModifKeys().contains(columnKey) && (currentSplitDim = (splitRowData = splitRowInfo.get(currentSplitRowId = this.getCurrentSplitRowId(mainEntityKey))).getCurrentFocusSplitDim()) != null) {
            this.addChangedValToModifyRow(splitRowData, tempConfig, currentRowId, currentSplitDim, columnKey, oldValue, newValue);
        }
    }

    private void addChangedValToModifyRow(SplitRowData splitRowData, EntryTemplateConfig tempConfig, Long currentRowId, String currentSplitDim, String columnKey, Object oldValue, Object newValue) {
        Map modifedRowsInfo = splitRowData.getSplitedRows().computeIfAbsent(currentSplitDim, key -> new HashMap(16));
        SplitedDataInfo rowInfo = modifedRowsInfo.computeIfAbsent(currentRowId, key -> new SplitedDataInfo());
        this.addChangedValToModifyRow(rowInfo, tempConfig, columnKey, oldValue, newValue);
    }

    private void addChangedValToModifyRow(SplitedDataInfo rowInfo, EntryTemplateConfig tempConfig, String columnKey, Object oldValue, Object newValue) {
        Map notSaveData = rowInfo.getNotSaveData();
        CellValueObj cellValue = notSaveData.computeIfAbsent(columnKey, key -> new CellValueObj());
        BaseColumn column = (BaseColumn)tempConfig.selectColumnMap().get(columnKey);
        if (column.getFieldtype() == FieldTypeEnum.IntField) {
            if (oldValue == null) {
                oldValue = 0;
            }
            Integer subData = (Integer)newValue - (Integer)oldValue;
            Integer currentVal = cellValue.getCurrentVal() == null ? 0 : Integer.parseInt(cellValue.getCurrentVal().toString());
            newValue = currentVal + subData;
        } else if (column.getFieldtype() == FieldTypeEnum.NumberField) {
            if (oldValue == null) {
                oldValue = this.getZero();
            }
            BigDecimal subData = ((BigDecimal)newValue).subtract((BigDecimal)oldValue);
            BigDecimal currentVal = cellValue.getCurrentVal() == null ? this.getZero() : (BigDecimal)cellValue.getCurrentVal();
            newValue = currentVal.add(subData);
        } else if (cellValue.getPreModifVal() == null) {
            cellValue.setPreModifVal(oldValue);
        }
        cellValue.setCurrentVal(newValue);
    }

    private SplitRowData getCurrentSplitRowData(String mainEntityKey) {
        Map<Long, SplitRowData> splitRowDataMap = this.getOrCacheSplitRowInfo(null, mainEntityKey);
        Long curretSplitRowId = this.getOrCacheCurrentSplitRowId(null).get(this.getSplitEntryKey(mainEntityKey));
        SplitRowData splitRowData = splitRowDataMap.get(curretSplitRowId);
        return splitRowData;
    }

    private Long getCurrentSplitRowId(String mainEntryKey) {
        String splitEntryKey = this.getSplitEntryKey(mainEntryKey);
        Long curretSplitRowId = this.getOrCacheCurrentSplitRowId(null).get(splitEntryKey);
        return curretSplitRowId;
    }

    private void updatePreSplitDataOnChange(String mainEntityKey, Map<Long, SplitRowData> splitRowInfo, Object newValue, Object oldValue, Long currentRowId, String columnKey, int rowIndexOnPage) {
        this.setNeedDealPropchange(false);
        EntryTemplateConfig tempConfig = this.getTempConfig(mainEntityKey);
        if (tempConfig.getSplitColumnMap().containsKey(columnKey)) {
            int currentLevel;
            ApplyBillEntityData entityData = this.getOrCacheBillEntityNodeData(mainEntityKey, null).getCurrentNodeData();
            int rowIndexByRowId = entityData.getRowIndexByRowId(currentRowId);
            boolean isDetail = true;
            for (String dimKey : entityData.getBaseDataKeys()) {
                EntityCellBaseData cellBaseData = entityData.getCellBaseData(rowIndexByRowId, dimKey);
                if (cellBaseData != null && cellBaseData.isLeaf()) continue;
                isDetail = false;
                break;
            }
            String preSplitCol = (String)tempConfig.getSplitSubKeyMap().get(columnKey);
            if (newValue == null) {
                newValue = this.getZero();
            }
            if (oldValue == null) {
                oldValue = this.getZero();
            }
            BigDecimal subData = ((BigDecimal)newValue).subtract((BigDecimal)oldValue);
            if (!isDetail) {
                BigDecimal currentRowSubData = (BigDecimal)this.getModel().getValue(preSplitCol, rowIndexOnPage);
                this.getModel().setValue(preSplitCol, (Object)currentRowSubData.add(subData), rowIndexOnPage);
            }
            int preSplitRowIndexOnCache = -1;
            Long currentSplitRowId = this.getCurrentSplitRowId(mainEntityKey);
            SplitRowData splitRowData = splitRowInfo.get(currentSplitRowId);
            String currentSplitDim = splitRowData.getCurrentSplitDim();
            ParentRowSplitInfo parentRowSplitInfo = null;
            Map splitedDataInfoMap = (Map)splitRowData.getSplitedRows().get(currentSplitDim);
            Set<String> splitColKeys = tempConfig.getSplitSubKeyMap().keySet();
            int pastLevel = currentLevel = entityData.getCellBaseData(rowIndexByRowId, currentSplitDim).getLevel();
            for (int index = rowIndexByRowId - 1; index >= 0; --index) {
                EntityCellBaseData cellBaseData = entityData.getCellBaseData(index, currentSplitDim);
                if (cellBaseData.getLevel() == 1) {
                    preSplitRowIndexOnCache = index;
                    break;
                }
                if (currentLevel <= cellBaseData.getLevel() || pastLevel <= cellBaseData.getLevel()) continue;
                Long rowId = entityData.getRowIbByIndex(index);
                pastLevel = cellBaseData.getLevel();
                if (parentRowSplitInfo != null || splitedDataInfoMap == null) continue;
                parentRowSplitInfo = this.findModifiedParentRow(rowId, index, splitedDataInfoMap, splitColKeys);
            }
            if (preSplitRowIndexOnCache != -1) {
                Long preSplitRowId = entityData.getRowIbByIndex(preSplitRowIndexOnCache);
                DynamicObjectCollection entryRowObjs = this.getModel().getEntryEntity(mainEntityKey);
                HashMap<Long, Integer> rowIdMapIndex = new HashMap<Long, Integer>(16);
                for (int index = rowIndexOnPage; index >= 0; --index) {
                    DynamicObject rowObj = (DynamicObject)entryRowObjs.get(index);
                    if (rowObj == null) continue;
                    Long cRowId = rowObj.getLong("id");
                    rowIdMapIndex.put(cRowId, index);
                    if (parentRowSplitInfo != null && parentRowSplitInfo.getRowId().equals(cRowId)) {
                        this.revokeParentRowSplitData(mainEntityKey, parentRowSplitInfo, tempConfig, rowObj, index, entityData);
                    }
                    if (!preSplitRowId.equals(cRowId)) continue;
                    this.updatePreSplitRowData(mainEntityKey, preSplitRowIndexOnCache, columnKey, subData, parentRowSplitInfo, rowObj, index, preSplitRowId, splitRowData);
                    ArrayList<Integer> toUpFormRowIndexs = new ArrayList<Integer>(16);
                    toUpFormRowIndexs.add(index);
                    if (this.isNewRow(currentRowId)) {
                        List<RowInfo> updatedRowIndexs = this.updateAggDataToForm(mainEntityKey, Collections.singleton(columnKey), Collections.singleton(preSplitRowId), rowIndexOnPage, false);
                        updatedRowIndexs.forEach(rowInfo -> toUpFormRowIndexs.add(rowInfo.getIndexOnPage()));
                    }
                    this.updateRowsRelationValues(Collections.singletonList(index), tempConfig);
                    break;
                }
                if (!this.isNewRow(currentRowId)) {
                    SplitedDataInfo splitedDataInfo;
                    Map<Long, Map<String, Integer>> mutexMembNums = this.getOrCacheMutexMembNums(null, mainEntityKey);
                    if (parentRowSplitInfo != null) {
                        splitedDataInfo = (SplitedDataInfo)splitedDataInfoMap.get(parentRowSplitInfo.getRowId());
                        this.lockMutexRowAfterModify(mutexMembNums, splitedDataInfo, entityData, tempConfig, rowIdMapIndex, parentRowSplitInfo.getRowIndexOnCache(), currentSplitDim);
                    }
                    splitedDataInfo = (SplitedDataInfo)splitedDataInfoMap.get(currentRowId);
                    this.lockMutexRowAfterModify(mutexMembNums, splitedDataInfo, entityData, tempConfig, rowIdMapIndex, rowIndexByRowId, currentSplitDim);
                    this.getOrCacheMutexMembNums(mutexMembNums, mainEntityKey);
                }
            }
        }
        this.setNeedDealPropchange(true);
    }

    @Override
    protected void afterUpdateAggDataToForm(List<RowInfo> updatedRowInfo, String entityKey, Set<String> toUpAggKeys, Set<Long> ignoreRowIds, int rowIndex, AggTypeEnum aggType, Map<String, Set<String>> allParentNumsOnRow) {
        super.afterUpdateAggDataToForm(updatedRowInfo, entityKey, toUpAggKeys, ignoreRowIds, rowIndex, aggType, allParentNumsOnRow);
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(entityKey, rowIndex);
        Map<Long, NewRowInfo> allNewRowInfo = this.getOrCacheAllNewRowInfo(null);
        Long currentRowId = entryRowEntity.getLong("id");
        NewRowInfo newRowInfo = allNewRowInfo.get(currentRowId);
        Set updatedRowIds = updatedRowInfo.stream().map(rowInfo -> rowInfo.getRowId()).collect(Collectors.toSet());
        EntryTemplateConfig tempConfig = this.getTempConfig(entityKey);
        List dimKeysList = tempConfig.getDimKeysList();
        DetailMembBillData sourceData = this.getSourceData(entityKey);
        if (this.isNewRow(entryRowEntity)) {
            ApplyBillEntityData currentNodeData = this.getCurrentNodeData(entityKey);
            Long refSplitRowId = newRowInfo.getRefLevelOneSplitRowId();
            boolean matchLevelOne = false;
            int indexOnCache = -1;
            for (Long rowId : currentNodeData.getRowIds()) {
                ++indexOnCache;
                if (!matchLevelOne && refSplitRowId.equals(rowId)) {
                    matchLevelOne = true;
                }
                if (!matchLevelOne) continue;
                if (currentRowId.equals(rowId)) break;
                if (updatedRowIds.contains(rowId) || allNewRowInfo.containsKey(rowId)) continue;
                Map dimMembNums = ApplyBillAggHelper.getInstance().selectRowDimMembNums(currentNodeData, indexOnCache, dimKeysList);
                if (allParentNumsOnRow != null && !this.matchParentRow(dimKeysList, allParentNumsOnRow, dimMembNums)) continue;
                Map data = ApplyBillAggHelper.getInstance().getData(dimMembNums, sourceData, toUpAggKeys, tempConfig);
                for (String auditKey : toUpAggKeys) {
                    BigDecimal auditData = (BigDecimal)data.get(auditKey);
                    List otherDataOfColumn = currentNodeData.getOtherDataOfColumn(auditKey);
                    if (otherDataOfColumn == null) continue;
                    otherDataOfColumn.set(indexOnCache, auditData);
                }
            }
        }
    }

    private void lockMutexRowAfterModify(Map<Long, Map<String, Integer>> mutexRowMembNums, SplitedDataInfo splitedDataInfo, ApplyBillEntityData entityData, EntryTemplateConfig templateConfig, Map<Long, Integer> rowIdMapIndex, int currentRowIndexOnCache, String currentSplitDim) {
        Integer n;
        int currentLevel;
        Set<String> splitKeys = templateConfig.getSplitSubKeyMap().keySet();
        List listDataOfColumn = entityData.getListDataOfColumn(currentSplitDim);
        int pastLevel = currentLevel = ((EntityCellBaseData)listDataOfColumn.get(currentRowIndexOnCache)).getLevel();
        HashMap<Long, String> rowIdMapMembNum = new HashMap<Long, String>(16);
        Long preSplitRowId = null;
        for (int index = currentRowIndexOnCache - 1; index >= 0; --index) {
            EntityCellBaseData cellBaseData = (EntityCellBaseData)listDataOfColumn.get(index);
            int level = cellBaseData.getLevel();
            if (currentLevel <= level || pastLevel <= level) continue;
            pastLevel = level;
            Long id = entityData.getRowIbByIndex(index);
            rowIdMapMembNum.put(id, cellBaseData.getNumber());
            if (level != 1) continue;
            preSplitRowId = id;
            break;
        }
        if (preSplitRowId == null) {
            return;
        }
        Map membNumCount = mutexRowMembNums.computeIfAbsent(preSplitRowId, key -> new HashMap(16));
        ArrayList<Integer> toLockIndex = new ArrayList<Integer>(16);
        boolean isLock = false;
        if (this.noChangeSplitData(splitedDataInfo, splitKeys)) {
            for (Map.Entry iterator : rowIdMapMembNum.entrySet()) {
                Long rowId = (Long)iterator.getKey();
                String membNum = (String)iterator.getValue();
                Integer count = (Integer)membNumCount.get(membNum);
                if (count == null) continue;
                Integer n2 = count;
                n = count = Integer.valueOf(count - 1);
                if (count == 0) {
                    membNumCount.remove(membNum);
                    toLockIndex.add(rowIdMapIndex.get(rowId));
                    continue;
                }
                membNumCount.put(membNum, count);
            }
        } else {
            isLock = true;
            HashMap<String, Integer> newCount = new HashMap<String, Integer>(16);
            for (Map.Entry entry : rowIdMapMembNum.entrySet()) {
                Long rowId = (Long)entry.getKey();
                String membNum = (String)entry.getValue();
                Integer count = (Integer)membNumCount.get(membNum);
                if (count == null) {
                    count = 0;
                }
                n = count;
                Integer n3 = count = Integer.valueOf(count + 1);
                if (count == 1) {
                    toLockIndex.add(rowIdMapIndex.get(rowId));
                }
                newCount.put(membNum, count);
            }
            if (toLockIndex.size() > 0) {
                membNumCount.putAll(newCount);
            }
        }
        if (toLockIndex.size() > 0) {
            String[] lockKeys = splitKeys.toArray(new String[0]);
            Iterator iterator = toLockIndex.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                this.getView().setEnable(Boolean.valueOf(!isLock), index, lockKeys);
            }
        }
    }

    private void updatePreSplitRowData(String mainEntityKey, int preSplitRowIndexOnCache, String currentColKey, BigDecimal subData, ParentRowSplitInfo parentRowSplitInfo, DynamicObject rowObj, int indexOnPage, Long preSplitRowId, SplitRowData splitRowData) {
        EntryTemplateConfig tempConfig = this.getTempConfig(mainEntityKey);
        Object[] rowData = this.getRowSourceData(mainEntityKey, preSplitRowIndexOnCache);
        Set splitColKeys = tempConfig.getSplitColumnMap().keySet();
        HashSet<String> toUpSubDataKeys = new HashSet<String>(16);
        String preSplitDim = splitRowData.getPreSplitDim(null);
        for (String col : splitColKeys) {
            BigDecimal toDelVal;
            BigDecimal toSubData = this.getZero();
            if (col.equals(currentColKey)) {
                toSubData = toSubData.add(subData);
            }
            if (parentRowSplitInfo != null && (toDelVal = (BigDecimal)parentRowSplitInfo.getTotalModifiedData().get(col)) != null) {
                toSubData = toSubData.subtract(toDelVal);
            }
            if (toSubData.compareTo(BigDecimal.ZERO) == 0) continue;
            String preSplitColKey = (String)tempConfig.getSplitSubKeyMap().get(col);
            BigDecimal preSplitRowSubData = rowObj.getBigDecimal(preSplitColKey);
            BigDecimal nowPreSplitRowSubData = preSplitRowSubData.subtract(toSubData);
            this.getModel().setValue(preSplitColKey, (Object)nowPreSplitRowSubData, indexOnPage);
            int colIndex = (Integer)tempConfig.getColumnIndex().get(col);
            rowData[colIndex] = nowPreSplitRowSubData;
            BigDecimal splitData = rowObj.getBigDecimal(col);
            this.getModel().setValue(col, (Object)splitData.subtract(preSplitRowSubData), indexOnPage);
            toUpSubDataKeys.add(col);
            if (preSplitDim == null) {
                this.addChangedValToModifyRow(splitRowData.getSplitedData(), tempConfig, col, toSubData, this.getZero());
                continue;
            }
            this.addChangedValToModifyRow(splitRowData, tempConfig, preSplitRowId, preSplitDim, col, toSubData, this.getZero());
        }
        if (preSplitDim == null) {
            this.updatePreSplitEntryRow(toUpSubDataKeys, preSplitRowId, mainEntityKey);
        }
    }

    private void revokeParentRowSplitData(String mainEntityKey, ParentRowSplitInfo parentRowSplitInfo, EntryTemplateConfig tempConfig, DynamicObject rowObj, int index, ApplyBillEntityData entityData) {
        Object[] rowData = this.getRowSourceData(mainEntityKey, parentRowSplitInfo.getRowIndexOnCache());
        Set<String> splitColKeys = tempConfig.getSplitSubKeyMap().keySet();
        for (String colKey : splitColKeys) {
            BigDecimal toDelVal = (BigDecimal)parentRowSplitInfo.getTotalModifiedData().get(colKey);
            if (toDelVal == null) continue;
            String preSplitCol = (String)tempConfig.getSplitSubKeyMap().get(colKey);
            int colIndex = (Integer)tempConfig.getColumnIndex().get(colKey);
            rowData[colIndex] = ((BigDecimal)rowData[colIndex]).subtract(toDelVal);
            BigDecimal currVal = rowObj.getBigDecimal(colKey);
            BigDecimal newVal = currVal.subtract(toDelVal);
            this.getModel().setValue(colKey, (Object)newVal, index);
            currVal = rowObj.getBigDecimal(preSplitCol);
            newVal = currVal.subtract(toDelVal);
            this.getModel().setValue(preSplitCol, (Object)newVal, index);
            entityData.getOtherDataOfColumn(colKey).set(parentRowSplitInfo.getRowIndexOnCache(), newVal);
        }
        List<RowInfo> udpatedRowIndexs = this.updateAggDataToForm(mainEntityKey, splitColKeys, null, index, false);
        List<Integer> rowIndexs = udpatedRowIndexs.stream().map(rowInfo -> rowInfo.getIndexOnPage()).collect(Collectors.toList());
        this.updateRowsRelationValues(rowIndexs, tempConfig);
    }

    private ParentRowSplitInfo findModifiedParentRow(Long rowId, int rowIndexOnCache, Map<Long, SplitedDataInfo> splitedDataInfoMap, Set<String> splitCols) {
        ParentRowSplitInfo result = null;
        SplitedDataInfo splitedDataInfo = splitedDataInfoMap.get(rowId);
        if (splitedDataInfo != null) {
            HashMap<String, BigDecimal> totalModifiedData = new HashMap<String, BigDecimal>();
            for (String colKey : splitCols) {
                CellValueObj savedVal = (CellValueObj)splitedDataInfo.getHadSaveData().get(colKey);
                CellValueObj noSaveVal = (CellValueObj)splitedDataInfo.getNotSaveData().get(colKey);
                BigDecimal toDelVal = this.getZero();
                if (savedVal == null && noSaveVal == null) continue;
                if (savedVal != null && savedVal.getCurrentVal() != null) {
                    toDelVal = toDelVal.add((BigDecimal)savedVal.getCurrentVal());
                }
                if (noSaveVal != null && noSaveVal.getCurrentVal() != null) {
                    toDelVal = toDelVal.add((BigDecimal)noSaveVal.getCurrentVal());
                } else {
                    noSaveVal = new CellValueObj();
                    splitedDataInfo.getNotSaveData().put(colKey, noSaveVal);
                }
                if (toDelVal.compareTo(BigDecimal.ZERO) == 0) continue;
                if (savedVal != null && savedVal.getCurrentVal() != null) {
                    noSaveVal.setCurrentVal((Object)this.getZero().subtract((BigDecimal)savedVal.getCurrentVal()));
                } else {
                    noSaveVal.setCurrentVal((Object)this.getZero());
                }
                totalModifiedData.put(colKey, toDelVal);
            }
            if (!totalModifiedData.isEmpty()) {
                result = new ParentRowSplitInfo();
                result.setTotalModifiedData(totalModifiedData);
                result.setRowIndexOnCache(rowIndexOnCache);
                result.setRowId(rowId);
            }
        }
        return result;
    }

    private void updatePreSplitEntryRow(Set<String> toUpSubDataKeys, Long rowId, String mainEntryKey) {
        String splitEntryKey = this.getSplitEntryKey(mainEntryKey);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(splitEntryKey);
        for (int index = 0; index < entryEntity.size(); ++index) {
            DynamicObject rowObj = (DynamicObject)entryEntity.get(index);
            if (rowObj == null || !rowId.equals(rowObj.getLong("id"))) continue;
            this.updatePreSplitEntryRow(rowObj, toUpSubDataKeys, mainEntryKey, index);
            break;
        }
    }

    private void updatePreSplitEntryRow(DynamicObject rowObj, Set<String> toUpSubDataKeys, String mainEntryKey, int index) {
        String splitEntryKey = this.getSplitEntryKey(mainEntryKey);
        EntryTemplateConfig splitEntryConfig = this.getSplitEntryConfig(splitEntryKey);
        EntryTemplateConfig templateConfig = this.getTempConfig(mainEntryKey);
        Map<String, Object> allSplitSubData = this.selectRowSplitSubData(rowObj, templateConfig, splitEntryConfig, mainEntryKey);
        for (String splitCol : toUpSubDataKeys) {
            Object val = allSplitSubData.get(splitCol);
            String splitColNew = splitCol.replace("h_", "s_");
            this.getModel().setValue((String)splitEntryConfig.getSplitSubKeyMap().get(splitColNew), val, index);
        }
        String seq = splitEntryKey.replace("splitentryentity", "");
        if (this.rowIsFinishSplit(templateConfig, allSplitSubData)) {
            this.getModel().setValue("s_splitstatus" + seq, (Object)SplitStatus.SPLITEND.getName(), index);
        } else {
            this.getModel().setValue("s_splitstatus" + seq, (Object)SplitStatus.SPLITING.getName(), index);
        }
    }

    private Map<String, Object> selectRowSplitSubData(DynamicObject rowObj, EntryTemplateConfig mainEntryConfig, EntryTemplateConfig splitEntryConfig, String entryKey) {
        String rowDimMembIdStr = ApplyBillAggHelper.getInstance().getRowDimMembIdStr(rowObj, splitEntryConfig.getDimKeysList());
        DetailMembBillData sourceData = this.getSourceData(entryKey);
        RowDataStatus rowDataStatus = (RowDataStatus)sourceData.getDetailRowStatus().get(rowDimMembIdStr);
        Object[] rowData = null;
        HashMap<String, Object> selectSplitSubData = new HashMap<String, Object>(16);
        if (rowDataStatus != null && (rowData = (Object[])sourceData.getAllRowData().get(rowDataStatus.getRowIndex())) != null) {
            for (String key : mainEntryConfig.getSplitSubKeyMap().keySet()) {
                Object subData = rowData[(Integer)mainEntryConfig.getColumnIndex().get(key)];
                selectSplitSubData.put(key, subData);
            }
        }
        return selectSplitSubData;
    }

    private boolean rowIsFinishSplit(EntryTemplateConfig templateConfig, Map<String, Object> splitSubDatas) {
        boolean end = true;
        for (String key : templateConfig.getSplitSubKeyMap().keySet()) {
            Object subData = splitSubDatas.get(key);
            if (subData == null || (!(subData instanceof BigDecimal) || BigDecimal.ZERO.compareTo((BigDecimal)subData) == 0) && (!(subData instanceof Integer) || subData.equals(0))) continue;
            end = false;
            break;
        }
        return end;
    }

    private Object[] getRowSourceData(String entityKey, int rowIndexOnCache) {
        EntryTemplateConfig tempConfig = this.getTempConfig(entityKey);
        ApplyBillEntityData currentNodeData = this.getCurrentNodeData(entityKey);
        String rowDimMembIdStr = ApplyBillAggHelper.getInstance().getRowDimMembIdStr(currentNodeData, rowIndexOnCache, tempConfig.getDimKeysList());
        DetailMembBillData sourceData = this.getSourceData(entityKey);
        RowDataStatus rowDataStatus = (RowDataStatus)sourceData.getDetailRowStatus().get(rowDimMembIdStr);
        Object[] rowData = (Object[])sourceData.getAllRowData().get(rowDataStatus.getRowIndex());
        return rowData;
    }

    @Override
    protected void updateAllEntryNodePathShow() {
    }

    @Override
    protected void updatePathShow(String entityKey, List<EntityPathNode> allNode) {
    }

    private void updateSplitDimPathShow(String mainEntryKey, Long splitRowId) {
        String seq = mainEntryKey.replace("entryentity", "");
        String pathPanalKey = "path" + seq;
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(pathPanalKey);
        flexPanelAp.setId(pathPanalKey);
        if (splitRowId != null) {
            EntryTemplateConfig tempConfig = this.getTempConfig(mainEntryKey);
            SplitRowData splitRowData = this.getOrCacheSplitRowInfo(null, mainEntryKey).get(splitRowId);
            List splitDimColList = splitRowData.getNotDetailDimColumn();
            Map columnMap = tempConfig.selectColumnMap();
            String currentFocusColKey = splitRowData.getCurrentFocusSplitDim();
            String currentSplitColKey = splitRowData.getCurrentSplitDim();
            for (String colKey : splitDimColList) {
                LabelAp labelAp = new LabelAp();
                String labelId = "splitdim_" + colKey;
                BaseColumn column = (BaseColumn)columnMap.get(colKey);
                labelAp.setKey(labelId);
                labelAp.setName(new LocaleString(column.getTitle()));
                flexPanelAp.getItems().add(labelAp);
                if (colKey.equals(currentFocusColKey)) {
                    labelAp.setFontSize(14);
                } else {
                    labelAp.setClickable(true);
                    labelAp.setForeColor("blue");
                }
                if (colKey.equals(currentSplitColKey)) break;
                LabelAp labelSignAp = new LabelAp();
                labelSignAp.setName(new LocaleString(">>"));
                labelSignAp.setKey(labelAp.getKey() + "_sign");
                flexPanelAp.getItems().add(labelSignAp);
            }
        }
        this.getView().updateControlMetadata(flexPanelAp.getKey(), flexPanelAp.createControl());
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (key != null && key.startsWith("splitdim_")) {
            Label label = new Label();
            label.setView(this.getView());
            label.setModel(this.getModel());
            label.setKey(key);
            label.addClickListener((ClickListener)this);
            e.setControl((Control)label);
        }
    }

    private String getMainEntryKey(String splitEntryKey) {
        return splitEntryKey.replace("splitentryentity", "entryentity");
    }

    private String getCurrentSplitEntryKey() {
        String currentEntityKey = this.getCurrentEntityKey();
        return this.getSplitEntryKey(currentEntityKey);
    }

    private String getSplitEntryKey(String MainEntryKey) {
        return MainEntryKey.replace("entryentity", "splitentryentity");
    }

    private boolean isSplitEntry(String entryKey) {
        return entryKey.startsWith("splitentryentity");
    }

    @Override
    protected void addCustomColumn(ColumnsContext columnsContext) {
        super.addCustomColumn(columnsContext);
    }

    @Override
    protected void addCustomEntry(BgApplyENtryInfo bgApplyENtryInfo, LoadCustomControlMetasArgs e) {
        super.addCustomEntry(bgApplyENtryInfo, e);
        HashMap splitEntry = new HashMap(16);
        bgApplyENtryInfo.setSplitEntryConfig(splitEntry);
        bgApplyENtryInfo.getEntryTemplateConfig().forEach((entryKey, tempConfig) -> {
            if (this.isMainEntry((String)entryKey)) {
                String index = entryKey.replace("entryentity", "");
                List columns = tempConfig.selectEntryColumnsNoDimText();
                columns.removeIf(BaseColumn::isIgnoreDB);
                if (tempConfig.getBusPlanDetailKey() != null) {
                    columns.forEach(column -> {
                        if (column.getKey().equals(tempConfig.getBusPlanDetailKey())) {
                            column.setBaseVisible(false);
                        }
                    });
                }
                String jsonStr = SerializationUtils.toJsonString((Object)tempConfig);
                for (BaseColumn column2 : columns) {
                    String newKey = column2.getKey().replace("h_", "s_");
                    jsonStr = jsonStr.replaceAll(column2.getKey(), newKey);
                }
                EntryTemplateConfig newTemplateConfig = (EntryTemplateConfig)SerializationUtils.fromJsonString((String)jsonStr, EntryTemplateConfig.class);
                newTemplateConfig.getEntryColumns().removeIf(column -> column.getKey().endsWith("_text") || column.getKey().contains("splitstatus") || column.getKey().contains("splitdata"));
                newTemplateConfig.getEntryColumns().forEach(column -> column.setIsmustinput(false));
                newTemplateConfig.getEntryColumns().forEach(column -> {
                    if (column instanceof DimensionColumn) {
                        ((DimensionColumn)column).getDimensionMemberRanges().clear();
                    }
                });
                this.addSubSplitColumn(newTemplateConfig, index, "s_");
                TextColumn splitDimColumn = new TextColumn();
                splitDimColumn.setKey("s_splitdims" + index);
                splitDimColumn.setTitle(ResManager.loadKDString((String)"\u5f85\u5206\u89e3\u7ef4\u5ea6", (String)"BgApplySplitBillPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                ColumnStyle columnStyle = new ColumnStyle();
                columnStyle.setHyperlink(true);
                splitDimColumn.setStyle(columnStyle);
                newTemplateConfig.getEntryColumns().add(splitDimColumn);
                TextColumn splitStatusColumn = new TextColumn();
                splitStatusColumn.setKey("s_splitstatus" + index);
                splitStatusColumn.setTitle(ResManager.loadKDString((String)"\u5206\u89e3\u72b6\u6001", (String)"BgApplySplitBillPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                newTemplateConfig.getEntryColumns().add(splitStatusColumn);
                String newEntryKey = "splitentryentity" + index;
                splitEntry.put(newEntryKey, newTemplateConfig);
                this.createColApToFormParam(newEntryKey, newTemplateConfig, e);
            }
        });
    }

    @Override
    protected EntryAp createEntryAp(String entityNumber, EntryTemplateConfig templateConfig) {
        EntryAp entryAp = super.createEntryAp(entityNumber, templateConfig);
        if (this.isSplitEntry(entityNumber)) {
            entryAp.setOrderAndFilter(0);
        }
        return entryAp;
    }

    @Override
    protected void setColumnStatus(BillFieldStatus fieldStatus) {
        super.setColumnStatus(fieldStatus);
        Map entryTemplateConfig = this.getEntryInfoFromFormParam().getEntryTemplateConfig();
        Map splitEntryConfig = this.getEntryInfoFromFormParam().getSplitEntryConfig();
        entryTemplateConfig.forEach((entryKey, templateConfig) -> {
            if (this.isMainEntry((String)entryKey)) {
                templateConfig.getRefDimKeyMap().keySet().forEach(key -> fieldStatus.addColumnDisableKeys(new String[]{this.getDimColTextKey((String)key)}));
            }
        });
        splitEntryConfig.forEach((entryKey, templateConfig) -> templateConfig.getSplitColumnMap().keySet().forEach(auditKey -> fieldStatus.addHideKeys(new String[]{auditKey})));
    }

    public void addSubSplitColumn(EntryTemplateConfig templateConfig, String entrySeq, String preKey) {
        Map splitColumnMap = templateConfig.getSplitColumnMap();
        HashMap splitSubKeyMap = new HashMap(splitColumnMap.size());
        int count = 1;
        for (Map.Entry entry : splitColumnMap.entrySet()) {
            BaseColumn column = (BaseColumn)templateConfig.selectColumnMap().get(entry.getValue());
            NumberColumn numberColumn = new NumberColumn();
            numberColumn.setKey(preKey + "splitdata" + entrySeq + "_" + count);
            numberColumn.setTitle(ResManager.loadResFormat((String)"\u5f85\u5206\u89e3\u6570(%1)", (String)"BgApplySplitBillPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{column.getTitle()}));
            numberColumn.setIgnoreDB(true);
            numberColumn.setEnable(false);
            ++count;
            templateConfig.getEntryColumns().add(numberColumn);
            splitSubKeyMap.put(entry.getKey(), numberColumn.getKey());
        }
        templateConfig.setSplitSubKeyMap(splitSubKeyMap);
    }

    @Override
    public void dealPropertyChanged(PropertyChangedArgs e) {
        this.updateNewRowShow(e);
        this.dealDimColumnChange4CollectBill(e);
        this.dealDimTextColumnChange(e);
        this.cacheNewCellDimMemb(e);
    }

    private void updateNewRowShow(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (!"shownewrow".equals(propName)) {
            return;
        }
        boolean showNewRow = (Boolean)e.getChangeSet()[0].getNewValue();
        IDataModel dataModel = this.getModel();
        Map<Long, NewRowInfo> allNewRowInfo = this.getOrCacheAllNewRowInfo(null);
        this.changeNewRowItemShow(this.getCurrentEntityKey());
        if (allNewRowInfo.isEmpty()) {
            return;
        }
        ArrayList newRowIndexOnPage = new ArrayList(16);
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        LinkedList updateEntryKeys = new LinkedList();
        this.setNeedDealPropchange(false);
        this.getEntryInfoFromFormParam().getEntryTemplateConfig().forEach((entryKey, tempConfig) -> {
            block8: {
                ApplyBillEntityData currentNodeData;
                DynamicObjectCollection entryRowDatas;
                block9: {
                    if (!this.isMainEntry((String)entryKey)) break block8;
                    newRowIndexOnPage.clear();
                    Long currentSplitRowId = this.getCurrentSplitRowId((String)entryKey);
                    if (currentSplitRowId == null || currentSplitRowId.equals(0L)) break block8;
                    updateEntryKeys.add(entryKey);
                    DetailMembBillData sourceData = this.getSourceData((String)entryKey);
                    entryRowDatas = dataModel.getEntryEntity(entryKey);
                    currentNodeData = this.getCurrentNodeData((String)entryKey);
                    if (!showNewRow) break block9;
                    String currentSplitDimCol = this.getCurrentSplitDimCol((String)entryKey);
                    LinkedHashMap<Long, Integer> levelOneSplitMap = this.selectNewRowInsertIndexOnPage(entryRowDatas, (String)entryKey);
                    HashMap newRowMapSplitRow = new HashMap(16);
                    String tempNumber = tempConfig.getNumber();
                    allNewRowInfo.forEach((newRowId, refSplitRowInfo) -> {
                        if (refSplitRowInfo.getStatus() != NewRowStatusEnum.DELETED && tempNumber.equals(refSplitRowInfo.getTemplateNumber()) && levelOneSplitMap.containsKey(refSplitRowInfo.getRefLevelOneSplitRowId())) {
                            Set rowIds = newRowMapSplitRow.computeIfAbsent(refSplitRowInfo.getRefLevelOneSplitRowId(), key -> new HashSet(16));
                            rowIds.add(newRowId);
                        }
                    });
                    if (newRowMapSplitRow.size() <= 0) break block8;
                    Map<Long, RowStatus> insertIndexsOnCache = this.selectNewRowInsertIndexOnCache(currentNodeData, levelOneSplitMap.keySet(), currentSplitDimCol);
                    ArrayList<RowIndexInfo> indexInfoList = new ArrayList<RowIndexInfo>(16);
                    int offsetOnCache = 0;
                    for (Map.Entry<Long, Integer> entrySet : levelOneSplitMap.entrySet()) {
                        Long splitRowId = entrySet.getKey();
                        int indexOnPage = entrySet.getValue();
                        RowStatus rowStatus = insertIndexsOnCache.get(splitRowId);
                        if (rowStatus == null) continue;
                        int insertIndexOnCache = rowStatus.getIndex() + offsetOnCache;
                        Set newRowIds = (Set)newRowMapSplitRow.get(splitRowId);
                        if (newRowIds == null || newRowIds.size() <= 0) continue;
                        int newRowCount = this.initNewRowToCache(insertIndexOnCache, newRowIds, sourceData.getAllRowData(), currentNodeData, (EntryTemplateConfig)tempConfig, modelCacheHelper, currentSplitDimCol);
                        if (!rowStatus.isClose()) {
                            int[] allInsertIndexOnCache = new int[newRowCount];
                            for (int i = 0; i < newRowCount; ++i) {
                                allInsertIndexOnCache[i] = i + insertIndexOnCache;
                            }
                            RowIndexInfo rowIndexInfo = new RowIndexInfo(indexOnPage - 1, insertIndexOnCache, allInsertIndexOnCache);
                            indexInfoList.add(rowIndexInfo);
                        }
                        offsetOnCache += newRowCount;
                    }
                    if (indexInfoList.size() <= 0) break block8;
                    this.openChildRowFromCache1(dataModel, currentNodeData, (List<RowIndexInfo>)indexInfoList, (String)entryKey, tempConfig.getColumnIndex(), currentSplitDimCol);
                    break block8;
                }
                int index = 0;
                for (DynamicObject row : entryRowDatas) {
                    Long rowId = row.getLong("id");
                    if (allNewRowInfo.containsKey(rowId)) {
                        newRowIndexOnPage.add(index);
                    }
                    ++index;
                }
                if (newRowIndexOnPage.size() > 0) {
                    dataModel.deleteEntryRows(entryKey, CommonServiceHelper.changeIntArrays((Collection)newRowIndexOnPage));
                }
                index = 0;
                Iterator iterator = currentNodeData.getRowIds().iterator();
                while (iterator.hasNext()) {
                    Long rowId = (Long)iterator.next();
                    if (allNewRowInfo.containsKey(rowId)) {
                        currentNodeData.removeRow(index, false);
                        iterator.remove();
                        continue;
                    }
                    ++index;
                }
            }
        });
        this.setNeedDealPropchange(false);
        for (String entryKey2 : updateEntryKeys) {
            this.cacheBillEntryNodeData(entryKey2);
        }
    }

    private LinkedHashMap<Long, Integer> selectNewRowInsertIndexOnPage(DynamicObjectCollection entryRowDatas, String entryKey) {
        String levelColKey = this.getLevelColKey(entryKey);
        LinkedHashMap<Long, Integer> levelOneSplitMap = new LinkedHashMap<Long, Integer>();
        int index = 0;
        Long preSplitRowId = null;
        for (DynamicObject rowObj : entryRowDatas) {
            int level = rowObj.getInt(levelColKey);
            if (level == 1) {
                if (preSplitRowId != null) {
                    levelOneSplitMap.put(preSplitRowId, index);
                }
                preSplitRowId = rowObj.getLong("id");
            }
            ++index;
        }
        if (preSplitRowId != null) {
            levelOneSplitMap.put(preSplitRowId, index);
        }
        return levelOneSplitMap;
    }

    private Map<Long, RowStatus> selectNewRowInsertIndexOnCache(ApplyBillEntityData currentNodeData, Set<Long> lOneSplitRowIds, String currentSplitDimCol) {
        Long preSplitRowId = null;
        int index = 0;
        boolean preSplitRowIsClose = false;
        HashMap<Long, RowStatus> insertIndexOnCache = new HashMap<Long, RowStatus>(16);
        for (Long rowId : currentNodeData.getRowIds()) {
            if (lOneSplitRowIds.contains(rowId)) {
                EntityCellBaseData cellBaseData;
                if (preSplitRowId != null) {
                    insertIndexOnCache.put(preSplitRowId, new RowStatus(index, preSplitRowIsClose));
                }
                preSplitRowIsClose = (cellBaseData = currentNodeData.getCellBaseData(index, currentSplitDimCol)).getGroupStatus() == CellGroupStatusEnum.CLOSE;
                preSplitRowId = rowId;
            }
            ++index;
        }
        if (preSplitRowId != null) {
            insertIndexOnCache.put(preSplitRowId, new RowStatus(index, preSplitRowIsClose));
        }
        return insertIndexOnCache;
    }

    private void cacheNewCellDimMemb(PropertyChangedArgs e) {
        String entityKey;
        EntryTemplateConfig entryTemplateConfig;
        String itemKey = e.getProperty().getName();
        if (this.onCleanRepDim != null) {
            return;
        }
        if (e.getProperty() instanceof BasedataProp && itemKey.startsWith("h_") && (entryTemplateConfig = this.getTempConfig(entityKey = e.getProperty().getParent().getName())).getDimKeysList().contains(itemKey)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            DynamicObject rowObj = e.getChangeSet()[0].getDataEntity();
            Long rowId = rowObj.getLong("id");
            Map<Long, NewRowInfo> allNewRowInfo = this.getOrCacheAllNewRowInfo(null);
            NewRowInfo newRowInfo = allNewRowInfo.get(rowId);
            if (newRowInfo != null) {
                if (newRowInfo.getStatus() == NewRowStatusEnum.EDIT && newValue == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u589e\u884c\u5df2\u4fdd\u5b58\uff0c\u65e0\u6cd5\u4fee\u6539\u6210\u5458\u3002", (String)"BgApplySplitBillPlugin_36", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    this.onCleanRepDim = "true";
                    this.getModel().setValue(itemKey, e.getChangeSet()[0].getOldValue(), rowIndex);
                    this.onCleanRepDim = null;
                    return;
                }
                ApplyBillEntityData currentNodeData = this.getCurrentNodeData(entityKey);
                int indexOnCache = currentNodeData.getRowIndexByRowId(rowId);
                this.checkNewRowAndAddSourceData(currentNodeData, entryTemplateConfig, indexOnCache, rowIndex, itemKey, newValue, entityKey);
            }
        }
    }

    @Override
    protected void updateLock(String key, Object value, int rowIndex) {
    }

    private void lockModifyColKeys(int indexOnPage, EntryTemplateConfig templateConfig, boolean isLock) {
        String[] modifyKeys = CommonServiceHelper.changeStringArrays((Collection)templateConfig.getModifKeys());
        this.getView().setEnable(Boolean.valueOf(!isLock), indexOnPage, modifyKeys);
    }

    private void addNewDimCellInfo(DynamicObject rowObj, ApplyBillEntityData currentNodeData, int indexOnCache, List<String> dimKeyList) {
        for (String dimKey : dimKeyList) {
            DynamicObject membObj = rowObj.getDynamicObject(dimKey);
            EntityCellBaseData cellBaseData = currentNodeData.getCellBaseData(indexOnCache, dimKey);
            if (membObj == null) {
                cellBaseData.setNumber("");
                cellBaseData.setName("");
                cellBaseData.setId(Long.valueOf(0L));
                continue;
            }
            cellBaseData.setName(membObj.getString("name"));
            cellBaseData.setNumber(membObj.getString("number"));
            cellBaseData.setId(Long.valueOf(membObj.getLong("id")));
        }
    }

    @Override
    protected boolean compareDimensionValue(String entrykey, String currentvalue, List<BaseColumn> columns, int rowIndex, String key) {
        return true;
    }

    private void checkNewRowAndAddSourceData(ApplyBillEntityData currentNodeData, EntryTemplateConfig entryTemplateConfig, int indexOnCache, int indexOnPage, String currentDimKey, DynamicObject newValue, String entryKey) {
        DetailMembBillData sourceData;
        String newMembIdStr;
        RowDimMembGroup dimMembGroup = this.getOrCacheDimMembGroup(null);
        if (dimMembGroup == null || !currentDimKey.equals(dimMembGroup.getCurrentDimCol())) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sbName = new StringBuilder();
        boolean newIsAllSet = true;
        DynamicObject currentRowObj = this.getModel().getEntryRowEntity(entryKey, indexOnPage);
        HashMap<String, Long> rowDimMembIds = new HashMap<String, Long>(16);
        for (String dimKey : entryTemplateConfig.getDimKeysList()) {
            DynamicObject membObj = currentRowObj.getDynamicObject(dimKey);
            if (membObj != null) {
                rowDimMembIds.put(dimKey, membObj.getLong("id"));
                sb1.append(membObj.getString("id")).append(',');
                sbName.append(membObj.getString("name")).append(',');
                continue;
            }
            newIsAllSet = false;
        }
        if (sbName.length() > 0) {
            sbName.deleteCharAt(sbName.length() - 1);
        }
        boolean oldIsALlSet = true;
        Map dimMembIds = dimMembGroup.getDimMembIds();
        for (String dimCol : entryTemplateConfig.getDimKeysList()) {
            Long membId = (Long)dimMembIds.get(dimCol);
            if (membId == null || membId.equals(0L)) {
                oldIsALlSet = false;
                break;
            }
            sb.append(membId).append(',');
        }
        Long rowId = currentNodeData.getRowIbByIndex(indexOnCache);
        Map<Long, NewRowInfo> allNewRowInfo = this.getOrCacheAllNewRowInfo(null);
        NewRowInfo newRowInfo = allNewRowInfo.get(rowId);
        String oldMembIdStr = sb.length() == 0 ? "" : sb.deleteCharAt(sb.length() - 1).toString();
        String string = newMembIdStr = newValue != null ? sb1.deleteCharAt(sb1.length() - 1).toString() : "";
        if (newIsAllSet) {
            sourceData = this.getSourceData(entryKey);
            if (sourceData.getDetailRowStatus().containsKey(newMembIdStr)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u5f53\u524d\u7ef4\u5ea6\u7ec4\u5408[%1]\u5df2\u5b58\u5728\u3002", (String)"BgApplySplitBillPlugin_24", (String)"epm-eb-formplugin", (Object[])new Object[]{sbName.toString()}));
                this.onCleanRepDim = "true";
                this.getModel().setValue(currentDimKey, dimMembIds.get(currentDimKey), indexOnPage);
                this.onCleanRepDim = null;
                return;
            }
            Map<String, Set<String>> rowDimMembLongNums = this.getRowDimMembLongNums(entryTemplateConfig, rowDimMembIds);
            Long refParentRowId = newRowInfo.getRefLevelOneSplitRowId();
            int rowIndexOnCache = currentNodeData.getRowIndexByRowId(refParentRowId);
            for (Object key : entryTemplateConfig.getDimKeysList()) {
                EntityCellBaseData cellBaseData = currentNodeData.getCellBaseData(rowIndexOnCache, (String)key);
                Set<String> parentNums = rowDimMembLongNums.get(key);
                if (cellBaseData != null && parentNums != null && parentNums.contains(cellBaseData.getNumber())) continue;
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u7ec4\u5408\u201c%1\u201d\u4e0d\u662f\u5f53\u524d\u5206\u89e3\u884c\u7684\u4e0b\u7ea7\u3002", (String)"BgApplySplitBillPlugin_25", (String)"epm-eb-formplugin", (Object[])new Object[]{sbName.toString()}));
                this.onCleanRepDim = "true";
                this.getModel().setValue(currentDimKey, dimMembIds.get(currentDimKey), indexOnPage);
                this.onCleanRepDim = null;
                return;
            }
        }
        this.addNewDimCellInfo(currentRowObj, currentNodeData, indexOnCache, entryTemplateConfig.getDimKeysList());
        if (newIsAllSet || oldIsALlSet) {
            sourceData = this.getSourceData(entryKey);
            RowDataStatus rowDataStatus = null;
            if (oldIsALlSet) {
                rowDataStatus = (RowDataStatus)sourceData.getDetailRowStatus().remove(oldMembIdStr);
                if (newRowInfo != null) {
                    this.addBackValToParentRow(entryTemplateConfig, entryKey, sourceData, rowId, newRowInfo.getRefLevelOneSplitRowId());
                }
            }
            if (newIsAllSet) {
                Object[] rows = null;
                if (rowDataStatus != null) {
                    rows = (Object[])sourceData.getAllRowData().get(rowDataStatus.getRowIndex());
                    rowDataStatus = new RowDataStatus(true, rowDataStatus.getRowIndex(), true);
                    sourceData.getDetailRowStatus().put(newMembIdStr, rowDataStatus);
                } else {
                    rows = new Object[((Object[])sourceData.getAllRowData().get(0)).length];
                    this.addNewRow(rows, currentNodeData.getRowIbByIndex(indexOnCache), true, sourceData, newMembIdStr);
                }
                IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
                Map viewIds = modelCacheHelper.getViewsByDataSet(Long.valueOf(entryTemplateConfig.getDatasetId()));
                for (Object key : currentNodeData.getBaseDataKeys()) {
                    Integer columnIndex = (Integer)entryTemplateConfig.getColumnIndex().get(key);
                    EntityCellBaseData cellBaseData = currentNodeData.getCellBaseData(indexOnCache, (String)key);
                    rows[columnIndex.intValue()] = cellBaseData.getId();
                }
                Map columnMap = entryTemplateConfig.selectColumnMap();
                this.setNeedDealPropchange(false);
                for (String key : currentNodeData.getOtherDataKeys()) {
                    Object defaultData;
                    BaseColumn column = (BaseColumn)columnMap.get(key);
                    if (column == null || column.isIgnoreDB()) continue;
                    Integer columnIndex = (Integer)entryTemplateConfig.getColumnIndex().get(key);
                    rows[columnIndex.intValue()] = defaultData = this.setDefaultData(null, column);
                    this.getModel().setValue(key, defaultData, indexOnPage);
                }
                Map allOlapData = BgApplyBillUtils.getInstance().updateMeasureValue(this.getModelCacheHelper(), entryTemplateConfig, this.getModel(), Collections.singleton(indexOnPage), this.getUnitData(entryTemplateConfig.getUnit()));
                Map olapData = (Map)allOlapData.get(indexOnPage);
                if (olapData != null) {
                    for (Map.Entry olapDataEntry : olapData.entrySet()) {
                        Integer columnIndex = (Integer)entryTemplateConfig.getColumnIndex().get(olapDataEntry.getKey());
                        rows[columnIndex.intValue()] = olapDataEntry.getValue();
                    }
                }
                this.setNeedDealPropchange(true);
            }
            if (oldIsALlSet && !newIsAllSet && rowDataStatus != null) {
                Object data = sourceData.getAllRowData().remove(rowDataStatus.getRowIndex());
                if (data != null) {
                    this.updateMembIdsMapIndex(sourceData, Collections.singletonList(rowDataStatus.getRowIndex()));
                }
                this.setNeedDealPropchange(false);
                Map columnMap = entryTemplateConfig.selectColumnMap();
                for (Object key : currentNodeData.getOtherDataKeys()) {
                    BaseColumn column = (BaseColumn)columnMap.get(key);
                    if (column == null || column.isIgnoreDB()) continue;
                    Object defaultData = this.setDefaultData(null, column);
                    this.getModel().setValue((String)key, defaultData, indexOnPage);
                }
                this.setNeedDealPropchange(true);
            }
            this.setNeedDealPropchange(false);
            List<RowInfo> udpatedRowIndexs = this.updateAggDataToForm(entryKey, (Set<String>)entryTemplateConfig.getAggKeys(), null, indexOnPage, AggTypeEnum.LEVELALL);
            if (newRowInfo != null) {
                this.updateLevelOneSplitRow(entryTemplateConfig, sourceData, newRowInfo.getRefLevelOneSplitRowId(), entryKey);
            }
            List<Integer> rowIndexs = udpatedRowIndexs.stream().map(RowInfo::getIndexOnPage).collect(Collectors.toList());
            rowIndexs.add(indexOnPage);
            this.updateRowsRelationValues(rowIndexs, entryTemplateConfig);
            this.setNeedDealPropchange(true);
            this.cacheSourceData(entryKey);
        }
        if (newRowInfo != null) {
            if (!newIsAllSet) {
                newRowInfo.setRowDimMembIds(rowDimMembIds);
            } else {
                newRowInfo.setRowDimMembIds(null);
            }
        }
        this.lockModifyColKeys(indexOnPage, entryTemplateConfig, !newIsAllSet);
        this.cacheBillEntryNodeData(entryKey);
        this.getOrCacheAllNewRowInfo(allNewRowInfo);
    }

    private Map<String, Set<String>> getRowDimMembLongNums(EntryTemplateConfig templateConfig, Map<String, Long> rowDimMembIds) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(templateConfig.getDimKeysList().size());
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        Map viewIds = modelCacheHelper.getViewsByDataSet(Long.valueOf(templateConfig.getDatasetId()));
        for (String dimKey : templateConfig.getDimKeysList()) {
            String dimNum = (String)templateConfig.selectColumnMapDimNum().get(dimKey);
            Long viewId = (Long)viewIds.get(dimNum);
            Member member = modelCacheHelper.getMember(dimNum, viewId, rowDimMembIds.get(dimKey));
            Set parentNums = CommonServiceHelper.changeLongNumToSet((String)member.getLongNumber());
            result.put(dimKey, parentNums);
        }
        return result;
    }

    @Override
    protected boolean dealDeffDimCellClick() {
        return false;
    }

    private void updateLevelOneSplitRow(EntryTemplateConfig templateConfig, DetailMembBillData sourceData, Long splitRowId, String entryKey) {
        DynamicObjectCollection entryDatas = this.getModel().getEntryEntity(entryKey);
        int index = 0;
        for (DynamicObject row : entryDatas) {
            Long rowId = row.getLong("id");
            if (splitRowId.equals(rowId)) {
                String rowDimMembIdStr = ApplyBillAggHelper.getInstance().getRowDimMembIdStr(row, templateConfig.getDimKeysList());
                RowDataStatus rowDataStatus = (RowDataStatus)sourceData.getDetailRowStatus().get(rowDimMembIdStr);
                if (rowDataStatus == null) break;
                Object[] rowData = (Object[])sourceData.getAllRowData().get(rowDataStatus.getRowIndex());
                for (Map.Entry splitSubKeyMap : templateConfig.getSplitSubKeyMap().entrySet()) {
                    String splitColKey = (String)splitSubKeyMap.getKey();
                    String splitSubColKey = (String)splitSubKeyMap.getValue();
                    BigDecimal subData = (BigDecimal)rowData[(Integer)templateConfig.getColumnIndex().get(splitColKey)];
                    if (subData == null) {
                        subData = this.getZero();
                    }
                    BigDecimal splitDataOnPage = row.getBigDecimal(splitColKey);
                    this.getModel().setValue(splitColKey, (Object)splitDataOnPage.subtract(subData), index);
                    this.getModel().setValue(splitSubColKey, (Object)subData, index);
                }
                break;
            }
            ++index;
        }
    }

    @Override
    protected Set<String> getCustomDimMembFilter(IModelCacheHelper modelCacheHelper, String dimNum, String columnKey, Long viewId, String entryKey, int rowIndex) {
        Member parentMember;
        HashSet<String> membNums = new HashSet<String>(16);
        DynamicObjectCollection entryDatas = this.getModel().getEntryEntity(entryKey);
        Long parentDimMembId = null;
        String levelColKey = this.getLevelColKey(entryKey);
        int level = 0;
        for (int index = rowIndex - 1; index >= 0; --index) {
            DynamicObject row = (DynamicObject)entryDatas.get(index);
            level = row.getInt(levelColKey);
            if (level != 1) continue;
            DynamicObject dimMembObj = row.getDynamicObject(columnKey);
            if (dimMembObj == null) break;
            parentDimMembId = dimMembObj.getLong("id");
            break;
        }
        if (parentDimMembId != null && (parentMember = modelCacheHelper.getMember(dimNum, viewId, parentDimMembId)) != null) {
            parentMember.iterate(childMemb -> {
                if (childMemb.isLeaf()) {
                    membNums.add(childMemb.getNumber());
                }
            });
        }
        return membNums;
    }

    private void updateMembIdsMapIndex(DetailMembBillData sourceData, List<Integer> deledIndexs) {
        if (deledIndexs.isEmpty()) {
            return;
        }
        sourceData.getDetailRowStatus().values().forEach(rowDataStatus -> {
            int rowIndex = rowDataStatus.getRowIndex();
            int nearIndex = this.getNearNumIndex(rowIndex, deledIndexs);
            if (nearIndex != -1) {
                rowDataStatus.setRowIndex(rowIndex - nearIndex - 1);
            }
        });
    }

    private int getNearNumIndex(int num, List<Integer> nums) {
        int maxIndex = nums.size() - 1;
        int minIndex = 0;
        int midIndex = 0;
        while (minIndex <= maxIndex) {
            midIndex = (maxIndex + minIndex) / 2;
            int number = nums.get(midIndex);
            if (number > num) {
                --maxIndex;
                continue;
            }
            if (number < num) {
                ++minIndex;
                continue;
            }
            return midIndex;
        }
        return maxIndex;
    }

    private void addBackValToParentRow(EntryTemplateConfig templateConfig, String mainEntryKey, DetailMembBillData sourceData, Long backRowId, Long parentSplitRowId) {
        SplitRowData currentSplitRowData = this.getCurrentSplitRowData(mainEntryKey);
        String focusDim = currentSplitRowData.getCurrentFocusSplitDim();
        Map splitedDataInfoMap = (Map)currentSplitRowData.getSplitedRows().get(focusDim);
        SplitedDataInfo splitedDataInfo = null;
        if (splitedDataInfoMap != null && (splitedDataInfo = (SplitedDataInfo)splitedDataInfoMap.get(backRowId)) != null) {
            HashMap<Long, Map<String, Object>> totalBackData = new HashMap<Long, Map<String, Object>>();
            HashMap<String, Object> allBackData = new HashMap<String, Object>(16);
            this.mergeCellData(splitedDataInfo.getNotSaveData(), allBackData, null, templateConfig.getColumnIndex());
            this.mergeCellData(splitedDataInfo.getHadSaveData(), allBackData, null, templateConfig.getColumnIndex());
            totalBackData.put(parentSplitRowId, allBackData);
            HashMap<Long, Integer> parentRowIndex = new HashMap<Long, Integer>(16);
            for (int index = sourceData.getAllRowData().size() - 1; index >= 0; --index) {
                Object[] rowData = (Object[])sourceData.getAllRowData().get(index);
                Long rowId = ApplyBillAggHelper.getInstance().getRowId(rowData);
                if (!parentSplitRowId.equals(rowId)) continue;
                parentRowIndex.put(rowId, index);
                break;
            }
            Map<Long, SplitedDataInfo> preSplitRowData = this.getPreSplitRowData(currentSplitRowData, this.getCurrentSplitRowId(mainEntryKey), currentSplitRowData.getPreSplitDim(focusDim));
            this.addBackValToParentRow(totalBackData, parentRowIndex, sourceData, templateConfig.getColumnIndex(), preSplitRowData);
            splitedDataInfoMap.remove(backRowId);
            Map<Long, SplitRowData> splitRowDataMap = this.getOrCacheSplitRowInfo(null, mainEntryKey);
            this.getOrCacheSplitRowInfo(splitRowDataMap, mainEntryKey);
        }
    }

    @Override
    protected List<Long> getTempIdsFromFormParam(FormShowParameter formShowParameter) {
        return this.queryTempIdsByAuditConfig(formShowParameter);
    }

    private void splitBillLockCell() {
        if (this.getOrCacheDecpBillData(null).isSplited()) {
            this.lockSplitBill();
        }
    }

    private void lockSplitColumn(String entityKey, List<RowInfo> insertRowsInfo) {
        ApplyBillEntityData entityData = this.getOrCacheBillEntityNodeData(entityKey, null).getCurrentNodeData();
        DecpBillData decpBillData = this.getOrCacheDecpBillData(null);
        Set nextStepDecpOrgIds = decpBillData.getNextStepDecpOrgIds();
        String currentSplitDimCol = this.getCurrentSplitDimCol(entityKey);
        ArrayList<Integer> toLockRows = new ArrayList<Integer>(16);
        EntryTemplateConfig tempConfig = this.getTempConfig(entityKey);
        for (RowInfo rowInfo : insertRowsInfo) {
            EntityCellBaseData cellBaseData;
            boolean needLock = false;
            if (decpBillData.getNextStepNumber() == null) {
                if (currentSplitDimCol != null && !(cellBaseData = entityData.getCellBaseData(rowInfo.getIndexOnCache(), currentSplitDimCol)).isLeaf()) {
                    needLock = true;
                }
            } else {
                cellBaseData = entityData.getCellBaseData(rowInfo.getIndexOnCache(), tempConfig.getOrgColumnKey());
                if (cellBaseData != null && !nextStepDecpOrgIds.contains(cellBaseData.getId())) {
                    needLock = true;
                }
            }
            if (!needLock || this.isNewRow(rowInfo.getRowId())) continue;
            toLockRows.add(rowInfo.getIndexOnPage());
        }
        if (!toLockRows.isEmpty()) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(entityKey);
            entryGrid.setRowLock(true, CommonServiceHelper.changeIntArrays(toLockRows));
        }
    }

    private String getCurrentSplitDimCol(String entityKey) {
        SplitRowData splitRowData;
        Map<Long, SplitRowData> splitRowDataMap = this.getOrCacheSplitRowInfo(null, entityKey);
        Long splitRowId = this.getCurrentSplitRowId(entityKey);
        String currentSplitDim = null;
        if (splitRowDataMap != null && splitRowId != null && (splitRowData = splitRowDataMap.get(splitRowId)) != null) {
            currentSplitDim = splitRowData.getCurrentFocusSplitDim();
        }
        return currentSplitDim;
    }

    @Override
    protected List<OlapDataEntry> getOlapByTemplateData(String entityKey, EntryTemplateConfig templateConfig, Map<String, List<Object[]>> initEntityData, Set<String> measureColKeys) {
        return null;
    }

    private String getSplitBillNumber() {
        return null;
    }

    @Override
    protected void afterInitEntityData() {
        super.afterInitEntityData();
        this.selectSplitedRowColKeys();
        this.getOrCacheOpenTime(TimeServiceHelper.now());
        this.getOrCacheDecpBillData(this.decpBillData);
        this.cacheAllSplitRowInfo();
    }

    @Override
    protected void setEntryEntityStatus(BillFieldStatus fieldStatus) {
        super.setEntryEntityStatus(fieldStatus);
        BgApplyENtryInfo entryInfoFromFormParam = this.getEntryInfoFromFormParam();
        entryInfoFromFormParam.getSplitEntryConfig().forEach((entryKey, tempConfig) -> fieldStatus.addDisableKeys(new String[]{entryKey}));
    }

    @Override
    protected void setCellsStatus(BillFieldStatus fieldStatus) {
        super.setCellsStatus(fieldStatus);
        this.splitBillLockCell();
    }

    @Override
    protected void setEntityInitData(int newEntryRowIndex, Map<String, String> sameParentNum, DetailMembBillData detailMembBillData, IModelCacheHelper modelCacheHelper, ApplyBillEntityData billEntityData, String entityKey, EntryTemplateConfig templateConfig, Map<String, BigDecimal> data) {
        super.setEntityInitData(newEntryRowIndex, sameParentNum, detailMembBillData, modelCacheHelper, billEntityData, entityKey, templateConfig, Maps.newHashMap());
    }

    @Override
    protected Map<String, List<Object[]>> getBillDataFromDB(BgApplyENtryInfo bgApplyENtryInfo) {
        String cacheStr = (String)this.getView().getFormShowParameter().getCustomParam("applyAuditParam");
        CommonServiceHelper.handleLog((Log)log, (String)("getBillData:" + this.getBillNumber()), (String)cacheStr);
        CentralAppShowInfo showInfo = (CentralAppShowInfo)SerializationUtils.fromJsonString((String)cacheStr, CentralAppShowInfo.class);
        Map entryTemplateConfig = bgApplyENtryInfo.getEntryTemplateConfig();
        Map rowDatas = BgApplyBillUtils.getInstance().getAuditBillData(showInfo, this.getBillNumber(), entryTemplateConfig, false);
        return rowDatas;
    }

    @Override
    protected boolean checkChildMembCanShow(Member childMemb, Set<String> allRangeMembNums) {
        return super.checkChildMembCanShow(childMemb, allRangeMembNums);
    }

    private Map<String, Map<Long, Map<String, Object>>> selectSplitDataOnDetailRow(Map<String, List<Object[]>> allRowDatas) {
        DecpBillData decpBillData = this.getOrCacheDecpBillData(null);
        boolean needCacheDetailData = !decpBillData.isFirstStep() || !decpBillData.isNotInitedDecpData();
        HashMap<String, Map<Long, Map<String, Object>>> detailRowSplitData = new HashMap<String, Map<Long, Map<String, Object>>>(16);
        if (needCacheDetailData) {
            ApplyBillAggHelper billAggHelper = ApplyBillAggHelper.getInstance();
            for (Map.Entry<String, List<Object[]>> rowdataEntry : allRowDatas.entrySet()) {
                String entryKey = rowdataEntry.getKey();
                List<Object[]> rowsData = rowdataEntry.getValue();
                if (rowsData == null || rowsData.isEmpty()) continue;
                EntryTemplateConfig tempConfig = this.getTempConfig(entryKey);
                Map columnIndex = tempConfig.getColumnIndex();
                Set splitColKeys = tempConfig.getSplitSubKeyMap().keySet();
                HashMap rowSplitData = new HashMap(16);
                for (Object[] rowData : rowsData) {
                    if (!billAggHelper.isDetailRow(rowData)) continue;
                    HashMap<String, Object> splitData = new HashMap<String, Object>(splitColKeys.size());
                    for (String colKey : splitColKeys) {
                        int index = (Integer)columnIndex.get(colKey);
                        Object val = rowData[index];
                        if ((!(val instanceof BigDecimal) || ((BigDecimal)val).compareTo(BigDecimal.ZERO) == 0) && (!(val instanceof Integer) || ((Integer)val).equals(0))) continue;
                        splitData.put(colKey, val);
                    }
                    if (splitData.size() <= 0) continue;
                    rowSplitData.put(billAggHelper.getRowId(rowData), splitData);
                }
                detailRowSplitData.put(entryKey, rowSplitData);
            }
        }
        return detailRowSplitData;
    }

    @Override
    protected void replaceMeasureFromOlap(Map<String, List<Object[]>> dataFromDB, BgApplyENtryInfo bgApplyENtryInfo) {
        Map<String, Map<Long, Map<String, Object>>> detailRowSplitData = this.selectSplitDataOnDetailRow(dataFromDB);
        super.replaceMeasureFromOlap(dataFromDB, bgApplyENtryInfo);
        if (!detailRowSplitData.isEmpty()) {
            this.addDetailDataAfterReadOlap(dataFromDB, detailRowSplitData);
            this.getOrCacheDetailRowSplitData(detailRowSplitData);
        }
    }

    private void addDetailDataAfterReadOlap(Map<String, List<Object[]>> allRowDatas, Map<String, Map<Long, Map<String, Object>>> detailRowSplitData) {
        ApplyBillAggHelper billAggHelper = ApplyBillAggHelper.getInstance();
        for (Map.Entry<String, List<Object[]>> rowdataEntry : allRowDatas.entrySet()) {
            String entryKey = rowdataEntry.getKey();
            EntryTemplateConfig tempConfig = this.getTempConfig(entryKey);
            Map columnIndex = tempConfig.getColumnIndex();
            Map<Long, Map<String, Object>> allRowSplitData = detailRowSplitData.get(entryKey);
            Set splitColKeys = tempConfig.getSplitSubKeyMap().keySet();
            if (allRowSplitData == null || allRowSplitData.size() <= 0) continue;
            List<Object[]> allRowData = rowdataEntry.getValue();
            for (Object[] rowDatas : allRowData) {
                Long rowId = billAggHelper.getRowId(rowDatas);
                Map<String, Object> splitData = allRowSplitData.get(rowId);
                if (splitData == null) continue;
                for (String colKey : splitColKeys) {
                    Object subVal = splitData.get(colKey);
                    if (subVal == null) continue;
                    int index = (Integer)columnIndex.get(colKey);
                    Object olapVal = rowDatas[index];
                    if (subVal instanceof BigDecimal) {
                        rowDatas[index] = ((BigDecimal)subVal).add((BigDecimal)olapVal);
                        continue;
                    }
                    if (!(subVal instanceof Integer)) continue;
                    rowDatas[index] = (Integer)subVal + (Integer)olapVal;
                }
            }
        }
    }

    private Map<String, Map<Long, Map<String, Object>>> getOrCacheDetailRowSplitData(Map<String, Map<Long, Map<String, Object>>> detailRowData) {
        if (detailRowData == null) {
            String cacheStr = this.getPageCache().get("DetailRowSplitData");
            detailRowData = StringUtils.isNotEmpty((CharSequence)cacheStr) ? (HashMap)SerializationUtils.deSerializeFromBase64((String)cacheStr) : new HashMap(16);
        } else {
            this.getPageCache().put("DetailRowSplitData", SerializationUtils.serializeToBase64(detailRowData));
        }
        return detailRowData;
    }

    private void initSplitBillInfo() {
        String billno = (String)this.getView().getFormShowParameter().getCustomParam("billno");
        DynamicObject splitBillObj = BgApplySplitUtil.getInstance().getSplitBillObjByNumber(billno);
        if (splitBillObj == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5206\u89e3\u5355\u5b9e\u4f53\u5931\u8d25", (String)"BgApplybillListPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        BgApplySplitUtil.getInstance().setSplitBillHead(this.getModel(), splitBillObj);
        this.splitBillData(splitBillObj);
        this.initNewRowInfo();
    }

    protected void splitBillData(DynamicObject rowDy) {
        String billno = rowDy.getString("billnumber");
        String stepPath = rowDy.getString("decppath");
        String currentStep = rowDy.getString("decpstep");
        DecpBillData decpBillData = new DecpBillData();
        decpBillData.setBillId(Long.valueOf(rowDy.getLong("id")));
        decpBillData.setBillNumber(billno);
        decpBillData.setSourceBillId(Long.valueOf(rowDy.getLong("sourcebillid")));
        decpBillData.setApplySchemeId(Long.valueOf(rowDy.getLong("bgapplyscheme.id")));
        decpBillData.setOrderOrgNumber(rowDy.getDynamicObject("splitorg").getString("number"));
        decpBillData.setOrderOrgId(Long.valueOf(rowDy.getDynamicObject("splitorg").getLong("id")));
        decpBillData.setDecpSchemeId(Long.valueOf(rowDy.getLong("decomposescheme.id")));
        decpBillData.setFirstStep(rowDy.getBoolean("isfirststep"));
        String splitstatus = rowDy.getString("splitstatus");
        if (!splitstatus.equals(SplitStatus.NOTSPLIT.getValue())) {
            Map<Long, String> tempIdMapEntry = this.getTempIdMapEntry();
            Map splitRowDataMap = BgApplySplitUtil.getInstance().querySplitedRowDatas(decpBillData.getBillId(), tempIdMapEntry);
            this.changeSplitRowInfoUnit(splitRowDataMap, false);
            Map<String, Map<Long, SplitRowData>> allSplitRowInfo = this.getAllSplitRowInfo(false);
            allSplitRowInfo.putAll(splitRowDataMap);
            decpBillData.setNotInitedDecpData(false);
        } else {
            decpBillData.setNotInitedDecpData(true);
        }
        if (splitstatus.equals(SplitStatus.SPLITEND.getValue())) {
            decpBillData.setSplited(true);
        }
        decpBillData.setStepNumber(currentStep);
        decpBillData.setDecpPath(stepPath);
        DecpStepManager stepDatas = BgApplySplitUtil.getInstance().getStepDatasBySchemeId(decpBillData.getDecpSchemeId());
        int stepIndex = stepDatas.getStepIndex(decpBillData.getStepNumber());
        DecpStepData nextStepData = stepDatas.getStepDataByIndex(stepIndex + 1);
        if (nextStepData != null) {
            Long orderOrg = rowDy.getDynamicObject("splitorg").getLong("id");
            HashSet<Long> hasNextDecpOrgIds = new HashSet<Long>();
            for (DecpRowData rowData : nextStepData.getRowDataList()) {
                if (!rowData.getOrderOrgId().equals(orderOrg)) continue;
                hasNextDecpOrgIds.add(rowData.getDecpOrgId());
            }
            decpBillData.setNextStepDecpOrgIds(hasNextDecpOrgIds);
            if (!hasNextDecpOrgIds.isEmpty()) {
                decpBillData.setNextStepNumber(nextStepData.getNumber());
            }
        }
        this.decpBillData = decpBillData;
    }

    private Map<Long, String> getTempIdMapEntry() {
        HashMap<Long, String> tempIdMapEntry = new HashMap<Long, String>();
        this.getEntryInfoFromFormParam().getEntryTemplateConfig().forEach((entryKey, tempConfig) -> {
            if (this.isMainEntry((String)entryKey)) {
                tempIdMapEntry.put(tempConfig.getTemplateID(), (String)entryKey);
            }
        });
        return tempIdMapEntry;
    }

    private Set<Long> getSplitRangeOrgIds(Set<Long> nextSplitOrgMembIds, Long currentSplitOrgId) {
        HashSet<Long> result = new HashSet<Long>(16);
        IModelCacheHelper iModelCacheHelper = this.getIModelCacheHelper();
        Long bizCtrlRangeId = this.getBizCtrlRangeId();
        Map viewIds = BusinessModelServiceHelper.getViewIds((Long)bizCtrlRangeId);
        Long viewId = (Long)viewIds.get(SysDimensionEnum.Entity.getNumber());
        Dimension dimension = iModelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber());
        Member splitMemb = dimension.getMember(viewId, currentSplitOrgId);
        result.add(splitMemb.getId());
        if (nextSplitOrgMembIds.isEmpty()) {
            splitMemb.getAllMembers().forEach(childMemb -> result.add(childMemb.getId()));
        } else {
            List members = dimension.getMember(viewId, nextSplitOrgMembIds);
            String currentSplitLongNums = splitMemb.getLongNumber();
            if (members != null && members.size() > 0) {
                for (Member member : members) {
                    if (member.getLongNumber() == null || !member.getLongNumber().contains(currentSplitLongNums)) continue;
                    while (member.getParentId() != null && (member = dimension.getMember(viewId, member.getParentId())) != null && !result.contains(member.getId())) {
                        result.add(member.getId());
                    }
                }
            }
        }
        return result;
    }

    private void updateFormBySubmitStatus(boolean isSplited) {
        this.getView().setVisible(Boolean.valueOf(!isSplited), new String[]{"save", "savesplit", "rollbackall"});
        this.getView().setVisible(Boolean.valueOf(isSplited), new String[]{"unsubmitsplit"});
        this.getView().setEnable(Boolean.valueOf(!isSplited), ApplyBillConstant.entry_splitresultentry);
        this.getView().setEnable(Boolean.valueOf(!isSplited), new String[]{"autosplit", "prestep", "nextstep", "changesplitdim", "addnewrow", "delnewrow"});
    }

    @Override
    protected void setButtonStatus(BillFieldStatus fieldStatus) {
        super.setButtonStatus(fieldStatus);
        fieldStatus.addHideKeys(new String[]{"submit", "unsubmit", "btn_stats", "btn_selappbill", "btn_c_view", "btn_viewappbill", "view_workflow"});
        fieldStatus.addShowKeys(new String[]{"savesplit", "btn_viewdetail"});
        fieldStatus.addHideKeys(ApplyBillConstant.btns_saveentity);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_newentry);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_deleteentry);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_viewadj);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_biznewentry);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_bizdeleteentry);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_queryplan);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_export);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_formatset);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_viewdata);
    }

    @Override
    protected void setMutexLock(BillFieldStatus fieldStatus) {
        super.setMutexLock(fieldStatus);
        String billNumber = this.getBillNumber();
        String billType = "eb_bgdecompose";
        String opType = "edit";
        Long lockId = MutexRecordHelper.addLock((String)billType, (String)billNumber, (String)opType);
        if (lockId.equals(0L)) {
            fieldStatus.addHideKeys(new String[]{"save", "savesplit", "unsubmitsplit", "rollbackall"});
            fieldStatus.addDisableKeys(new String[]{"autosplit", "prestep", "nextstep", "changesplitdim", "addnewrow", "delnewrow"});
            fieldStatus.addDisableKeys(ApplyBillConstant.entry_splitresultentry);
            MutexRecordObj lockRecord = MutexRecordHelper.getLockRecord((String)billType, (String)billNumber, (String)opType);
            if (lockRecord == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u9501\u5931\u8d25\uff0c\u5f53\u524d\u9875\u9762\u4ee5\u67e5\u770b\u65b9\u5f0f\u6253\u5f00\u3002", (String)"BgApplySplitBillPlugin_21", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            } else if (!this.isSameIpOpen(lockRecord)) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"%1\u6b63\u5728\u7f16\u8f91\u8be5\u5355\u636e\uff0c\u5f53\u524d\u9875\u9762\u4ee5\u67e5\u770b\u65b9\u5f0f\u6253\u5f00\u3002", (String)"BgApplySplitBillPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[]{lockRecord.getCreatorName()}));
            } else {
                lockId = lockRecord.getPkId();
            }
        }
        this.getOrCacheMutexLockId(lockId);
    }

    private boolean isSameIpOpen(MutexRecordObj lockRecord) {
        Long creator = lockRecord.getCreator();
        String ipAddress = lockRecord.getIpAddress();
        Long curUserId = UserUtils.getUserId();
        RequestContext requestContext = RequestContext.getOrCreate();
        String loginIP = requestContext.getLoginIP();
        return curUserId.equals(creator) && loginIP.equals(ipAddress);
    }

    private Long getOrCacheMutexLockId(Long lockId) {
        if (lockId == null) {
            String cacheStr = this.getPageCache().get("MutexLockId");
            if (StringUtils.isNotEmpty((CharSequence)cacheStr)) {
                lockId = Long.valueOf(cacheStr);
            }
        } else {
            this.getPageCache().put("MutexLockId", lockId.toString());
        }
        return lockId;
    }

    @Override
    protected void setOtherControlStatus(BillFieldStatus fieldStatus) {
        super.setOtherControlStatus(fieldStatus);
        if (this.getOrCacheDecpBillData(null).isSplited()) {
            fieldStatus.addHideKeys(new String[]{"save", "savesplit", "rollbackall"});
            fieldStatus.addShowKeys(new String[]{"unsubmitsplit"});
            fieldStatus.addDisableKeys(ApplyBillConstant.entry_splitresultentry);
            fieldStatus.addDisableKeys(new String[]{"autosplit", "prestep", "nextstep", "changesplitdim", "addnewrow", "delnewrow"});
        } else {
            fieldStatus.addShowKeys(new String[]{"save", "savesplit", "rollbackall"});
            fieldStatus.addHideKeys(new String[]{"unsubmitsplit"});
        }
    }

    @Override
    protected void setFieldStatus(BillFieldStatus fieldStatus) {
        super.setFieldStatus(fieldStatus);
        fieldStatus.addDisableKeys(new String[]{"budgetorg"});
        fieldStatus.addHideKeys(new String[]{"org", "applydate", "applydate", "proposer", "collectorg", "auditor", "auditdate", "accessoryap", "remark"});
        fieldStatus.addShowKeys(new String[]{"budgetorg", "splitorg"});
    }

    @Override
    protected void initBillBaseInfo() {
        super.initBillBaseInfo();
        this.initSplitBillInfo();
    }

    @Override
    protected void beforeFinishSaveData(BillSaveEventArgs saveEventArgs) {
        super.beforeFinishSaveData(saveEventArgs);
        DecpBillData decpBillData = this.getOrCacheDecpBillData(null);
        this.mergeAndSaveModifedVals(decpBillData);
        this.saveNewRowInfo(saveEventArgs);
        BgApplySplitUtil.getInstance().saveBillEditInfo(decpBillData.getBillId(), SplitStatus.SPLITING);
    }

    private void saveNewRowInfo(BillSaveEventArgs saveEventArgs) {
        Map<Long, NewRowInfo> allNewRowInfo = this.getOrCacheAllNewRowInfo(null);
        DecpBillData decpBillData = this.getOrCacheDecpBillData(null);
        Long billId = decpBillData.getBillId();
        if (allNewRowInfo.size() > 0) {
            ArrayList toSaveNewRowInfo = new ArrayList(16);
            ArrayList toDelNewRowIds = new ArrayList(16);
            HashMap newRowIdMapTempNum = new HashMap(16);
            allNewRowInfo.forEach((rowId, newRowInfo) -> {
                if (newRowInfo.getStatus() == NewRowStatusEnum.NEW) {
                    DynamicObject rowObj = BusinessDataServiceHelper.newDynamicObject((String)"eb_splitnewrow");
                    rowObj.set("id", rowId);
                    rowObj.set("splitbillid", (Object)billId);
                    rowObj.set("presplitrowid", (Object)newRowInfo.getPreSplitRowId());
                    rowObj.set("reffirstsplitrowid", (Object)newRowInfo.getRefLevelOneSplitRowId());
                    rowObj.set("templatenumber", (Object)newRowInfo.getTemplateNumber());
                    toSaveNewRowInfo.add(rowObj);
                    newRowInfo.setStatus(NewRowStatusEnum.EDIT);
                    Set rowIds = newRowIdMapTempNum.computeIfAbsent(newRowInfo.getTemplateNumber(), key -> new HashSet(16));
                    rowIds.add(rowId);
                } else if (newRowInfo.getStatus() == NewRowStatusEnum.DELETED) {
                    toDelNewRowIds.add(rowId);
                }
            });
            if (toDelNewRowIds.size() > 0) {
                DeleteServiceHelper.delete((String)"eb_splitnewrow", (QFilter[])new QFilter[]{new QFilter("id", "in", toDelNewRowIds)});
                CommonServiceHelper.handleLog((Log)this.getLog(), (String)("DelNewRowIds:" + this.getBillNumber()), (String)SerializationUtils.toJsonString(toDelNewRowIds));
            }
            if (toSaveNewRowInfo.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])toSaveNewRowInfo.toArray(new DynamicObject[toSaveNewRowInfo.size()]));
                CommonServiceHelper.handleLog((Log)this.getLog(), (String)("SaveNewRowInfo:" + this.getBillNumber()), (String)SerializationUtils.toJsonString(newRowIdMapTempNum));
            }
            saveEventArgs.setNewRowIdsToLock(newRowIdMapTempNum);
        }
    }

    private void updateModifyInfo() {
        this.getModel().setValue("modifier", (Object)UserUtils.getUserId());
        this.getModel().setValue("modifydate", (Object)new Timestamp(TimeServiceHelper.now().getTime()));
    }

    private void mergeAndSaveModifedVals(DecpBillData decpBillData) {
        Map<String, Map<Long, SplitRowData>> splitRowDataMap = this.getAllSplitRowInfo(false);
        splitRowDataMap.forEach((entryKey, allSplitRowData) -> {
            Long templateID = this.getTempConfig((String)entryKey).getTemplateID();
            HashMap toSaveDataSign = new HashMap();
            allSplitRowData.forEach((rowId, spliRowData) -> {
                boolean preSplitRowHasChange = !spliRowData.getSplitedData().getNotSaveData().isEmpty();
                this.mergeModifedVals(spliRowData.getSplitedData());
                HashSet<String> toSaveDimCol = new HashSet<String>();
                if (preSplitRowHasChange) {
                    toSaveDimCol.add("preRowChangeSign");
                }
                spliRowData.getSplitedRows().forEach((splitDimCol, modifedRows) -> {
                    Count count = new Count();
                    modifedRows.forEach((rowId2, rowChangedVals) -> {
                        if (!rowChangedVals.getNotSaveData().isEmpty()) {
                            count.addOne();
                        }
                        this.mergeModifedVals((SplitedDataInfo)rowChangedVals);
                    });
                    if (count.getCount() > 0) {
                        toSaveDimCol.add((String)splitDimCol);
                    }
                });
                if (!toSaveDimCol.isEmpty()) {
                    toSaveDataSign.put(rowId, toSaveDimCol);
                }
            });
            BgApplySplitUtil.getInstance().saveSplitedRowDatas(decpBillData.getBillId(), templateID, allSplitRowData, toSaveDataSign);
        });
    }

    @Override
    protected void beforeSaveBillData(BillSaveEventArgs eventArgs) {
        super.beforeSaveBillData(eventArgs);
        this.changeSplitRowInfoUnit(this.getAllSplitRowInfo(true), true);
    }

    private void changeSplitRowInfoUnit(Map<String, Map<Long, SplitRowData>> splitRowDataMap, boolean up) {
        splitRowDataMap.forEach((entryKey, splitRowData) -> {
            boolean needChangeSplitCol;
            EntryTemplateConfig tempConfig = this.getTempConfig((String)entryKey);
            BigDecimal unitData = this.getUnitData(tempConfig.getUnit());
            Set currencyColumnKeys = tempConfig.getCurrencyColumnKeys();
            Set splitColKeys = tempConfig.getSplitColumnMap().keySet();
            boolean bl = needChangeSplitCol = !Collections.disjoint(currencyColumnKeys, tempConfig.getSplitSubKeyMap().keySet());
            if (!currencyColumnKeys.isEmpty()) {
                splitRowData.values().forEach(rowData -> {
                    SplitedDataInfo splitedData = rowData.getSplitedData();
                    if (needChangeSplitCol) {
                        this.changeSubDataUnit(splitColKeys, currencyColumnKeys, unitData, rowData.getSubData(), tempConfig.getSplitSubKeyMap(), up);
                    }
                    this.changeUnit(splitedData, (Set<String>)currencyColumnKeys, up, unitData);
                    rowData.getSplitedRows().values().forEach(splitedRowMap -> splitedRowMap.values().forEach(modifRow -> this.changeUnit((SplitedDataInfo)modifRow, (Set<String>)currencyColumnKeys, up, unitData)));
                });
            }
        });
    }

    private void changeSubDataUnit(Set<String> splitKeys, Set<String> currencyColumnKeys, BigDecimal unitData, Map<String, BigDecimal> subDatas, Map<String, String> splitKeyMapSubKeys, boolean isUp) {
        for (String key : splitKeys) {
            String subKey;
            BigDecimal val;
            if (!currencyColumnKeys.contains(key) || (val = subDatas.get(subKey = splitKeyMapSubKeys.get(key))) == null) continue;
            subDatas.put(subKey, (BigDecimal)this.changeValByUnit(val, unitData, isUp));
        }
    }

    private void changeUnit(SplitedDataInfo splitedData, Set<String> currencyColumnKeys, boolean isUp, BigDecimal unitData) {
        this.changeUnit(splitedData.getNotSaveData(), currencyColumnKeys, isUp, unitData);
        this.changeUnit(splitedData.getHadSaveData(), currencyColumnKeys, isUp, unitData);
    }

    private void changeUnit(Map<String, CellValueObj> cellValueObjMap, Set<String> currencyColumnKeys, boolean isUp, BigDecimal unitData) {
        for (String key : currencyColumnKeys) {
            BigDecimal val;
            CellValueObj cellValueObj = cellValueObjMap.get(key);
            if (cellValueObj == null || (val = (BigDecimal)cellValueObj.getCurrentVal()) == null) continue;
            cellValueObj.setCurrentVal(this.changeValByUnit(val, unitData, isUp));
        }
    }

    private void mergeModifedVals(SplitedDataInfo rowChangedVals) {
        Map hadSaveData = rowChangedVals.getHadSaveData();
        Map notSaveData = rowChangedVals.getNotSaveData();
        notSaveData.forEach((colKey, cellVal) -> {
            Object currentVal = cellVal.getCurrentVal();
            CellValueObj saveVal = (CellValueObj)hadSaveData.get(colKey);
            if (saveVal == null) {
                saveVal = new CellValueObj();
                saveVal.setPreModifVal(cellVal.getPreModifVal());
                hadSaveData.put(colKey, saveVal);
            }
            if (currentVal instanceof Integer) {
                Integer sVal = (Integer)saveVal.getCurrentVal();
                sVal = sVal == null ? (Integer)currentVal : sVal + (Integer)currentVal;
                saveVal.setCurrentVal((Object)sVal);
            } else if (currentVal instanceof BigDecimal) {
                BigDecimal sVal = (BigDecimal)saveVal.getCurrentVal();
                sVal = sVal == null ? (BigDecimal)currentVal : sVal.add((BigDecimal)currentVal);
                saveVal.setCurrentVal((Object)sVal);
            } else {
                saveVal.setCurrentVal(currentVal);
            }
        });
        notSaveData.clear();
    }

    @Override
    protected void afterSaveData(BillSaveEventArgs eventArgs) {
        this.updateModifyInfo();
        super.afterSaveData(eventArgs);
        DecpBillData decpBillData = this.getOrCacheDecpBillData(null);
        decpBillData.setNotInitedDecpData(false);
        this.changeSplitRowInfoUnit(this.getAllSplitRowInfo(false), false);
        this.getOrCacheDecpBillData(decpBillData);
        this.cacheAllSplitRowInfo();
        this.getOrCacheDetailRowSplitData(eventArgs.getDetailRowSplitData());
        this.getOrCacheRollBackSplitData(new HashMap<String, Map<Long, Map<String, Object>>>(16));
        if (this.allNewRows != null) {
            this.getOrCacheAllNewRowInfo(this.allNewRows);
        }
        this.updatePreEntryAfterSave(null, null);
        this.lockNewRowAfterSave(eventArgs);
        this.getModel().setDataChanged(false);
    }

    private void lockNewRowAfterSave(BillSaveEventArgs eventArgs) {
        Map newRowIdsToLock = eventArgs.getNewRowIdsToLock();
        if (newRowIdsToLock == null || newRowIdsToLock.isEmpty()) {
            return;
        }
        Map entryTemplateConfig = this.getEntryInfoFromFormParam().getEntryTemplateConfig();
        entryTemplateConfig.forEach((entryKey, tempConfig) -> {
            if (this.isMainEntry((String)entryKey)) {
                String[] toLockKeys = new String[tempConfig.getDimKeysList().size()];
                int count = 0;
                for (String baseKey : tempConfig.getDimKeysList()) {
                    toLockKeys[count++] = this.getDimColTextKey(baseKey);
                }
                Set newRowIds = (Set)newRowIdsToLock.get(tempConfig.getNumber());
                if (newRowIds != null && newRowIds.size() > 0) {
                    int rowIndex = 0;
                    DynamicObjectCollection entryRows = this.getModel().getEntryEntity(entryKey);
                    for (DynamicObject rowObj : entryRows) {
                        Long rowId = rowObj.getLong("id");
                        if (newRowIds.contains(rowId)) {
                            this.getView().setEnable(Boolean.valueOf(false), rowIndex, toLockKeys);
                        }
                        ++rowIndex;
                    }
                }
            }
        });
    }

    private void updatePreEntryAfterSave(Set<Long> filterRowIds, Set<String> filterEntryKeys) {
        this.setNeedDealPropchange(false);
        Map allMainTempConfig = this.getEntryInfoFromFormParam().getEntryTemplateConfig();
        for (Map.Entry entry : allMainTempConfig.entrySet()) {
            String mainEntryKey = (String)entry.getKey();
            if (!this.isMainEntry(mainEntryKey) || filterEntryKeys != null && !filterEntryKeys.contains(mainEntryKey)) continue;
            String splitEntryKey = this.getSplitEntryKey(mainEntryKey);
            EntryTemplateConfig mainEntryConfig = (EntryTemplateConfig)entry.getValue();
            EntryTemplateConfig splitEntryConfig = this.getSplitEntryConfig(splitEntryKey);
            DynamicObjectCollection rowObjs = this.getModel().getEntryEntity(splitEntryKey);
            DetailMembBillData sourceData = this.getSourceData(mainEntryKey);
            Map splitSubKeyMap = mainEntryConfig.getSplitSubKeyMap();
            Map columnIndex = mainEntryConfig.getColumnIndex();
            Map<Long, SplitRowData> preSplitRows = this.getOrCacheSplitRowInfo(null, mainEntryKey);
            int rowIndex = -1;
            IDataModel dataModel = this.getModel();
            String seq = splitEntryKey.replace("splitentryentity", "");
            StringBuilder sb = new StringBuilder();
            for (DynamicObject row : rowObjs) {
                boolean modified;
                ++rowIndex;
                Long rowId = row.getLong("id");
                if (filterRowIds != null && !filterRowIds.contains(rowId)) continue;
                SplitRowData splitRowData = preSplitRows == null ? null : preSplitRows.get(rowId);
                String rowDimMembStr = ApplyBillPluginUitl.selectDimMembIdStr((StringBuilder)sb, (DynamicObject)row, (List)splitEntryConfig.getDimKeysList());
                RowDataStatus rowDataStatus = (RowDataStatus)sourceData.getDetailRowStatus().get(rowDimMembStr);
                if (rowDataStatus == null) continue;
                Object[] rowData = (Object[])sourceData.getAllRowData().get(rowDataStatus.getRowIndex());
                boolean end = true;
                for (Map.Entry splitSubKeyEntry : splitSubKeyMap.entrySet()) {
                    String splitKey = (String)splitSubKeyEntry.getKey();
                    String subDataKey = (String)splitSubKeyEntry.getValue();
                    BigDecimal subVal = (BigDecimal)rowData[(Integer)columnIndex.get(splitKey)];
                    if (subVal == null || subVal.compareTo(BigDecimal.ZERO) != 0) {
                        end = false;
                    }
                    dataModel.setValue(subDataKey.replace("h_", "s_"), (Object)subVal, rowIndex);
                }
                String splitStatusKey = "s_splitstatus" + seq;
                if (end) {
                    dataModel.setValue(splitStatusKey, (Object)SplitStatus.SPLITEND.getName(), rowIndex);
                    continue;
                }
                boolean bl = modified = splitRowData != null && splitRowData.getSplitedData() != null && !splitRowData.getSplitedData().getHadSaveData().isEmpty();
                if (modified) {
                    dataModel.setValue(splitStatusKey, (Object)SplitStatus.SPLITING.getName(), rowIndex);
                    continue;
                }
                dataModel.setValue(splitStatusKey, (Object)SplitStatus.NOTSPLIT.getName(), rowIndex);
            }
        }
        this.setNeedDealPropchange(true);
    }

    @Override
    protected boolean fillFixedValue(String entryKey, int row) {
        return false;
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    private void handleCreateNextSplitBill() {
        DecpBillData splitBillData = this.getOrCacheDecpBillData(null);
        DecpStepManager stepDatas = BgApplySplitUtil.getInstance().getStepDatasBySchemeId(splitBillData.getDecpSchemeId());
        int stepIndex = stepDatas.getStepIndex(splitBillData.getStepNumber());
        DecpStepData nextStepData = stepDatas.getStepDataByIndex(stepIndex + 1);
        List rowDataList = nextStepData.getRowDataList();
        DynamicObject applySchemeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)splitBillData.getApplySchemeId(), (String)"eb_rptscheme");
        DynamicObject bgDecomposeDy = BusinessDataServiceHelper.newDynamicObject((String)"eb_bgdecompose");
        bgDecomposeDy.set("bgapplyscheme", (Object)applySchemeObj);
        ArrayList<PreSubmitSplitInfo> preSubmitSplitInfos = new ArrayList<PreSubmitSplitInfo>(16);
        for (DecpRowData rowData : rowDataList) {
            if (!splitBillData.getOrderOrgId().equals(rowData.getOrderOrgId())) continue;
            PreSubmitSplitInfo submitSplitInfo = new PreSubmitSplitInfo();
            submitSplitInfo.setSplitOrgId(rowData.getDecpOrgId());
            submitSplitInfo.setSplitUserIds(rowData.getChargePersonsId());
            submitSplitInfo.setOrderOrgId(rowData.getOrderOrgId());
            preSubmitSplitInfos.add(submitSplitInfo);
        }
        if (preSubmitSplitInfos.size() > 0) {
            String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)"eb_bgdecompose", (DynamicObject)bgDecomposeDy, null, (int)preSubmitSplitInfos.size());
            for (int i = 0; i < batchNumber.length; ++i) {
                ((PreSubmitSplitInfo)preSubmitSplitInfos.get(i)).setBillNumber(batchNumber[i]);
            }
            String paramStr = SerializationUtils.serializeToBase64(preSubmitSplitInfos);
            this.getPageCache().put("SubmitSplitInfo", paramStr);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("eb_submitsplitconfirm");
            formShowParameter.setCustomParam("SubmitSplitInfo", (Object)paramStr);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "handleCreateNextSplitBill"));
            this.getView().showForm(formShowParameter);
        }
    }

    private void createNextStepSplitBill(DecpBillData splitBillData) {
        if (splitBillData.getNextStepNumber() == null) {
            return;
        }
        DecpStepManager stepDatas = BgApplySplitUtil.getInstance().getStepDatasBySchemeId(splitBillData.getDecpSchemeId());
        int stepIndex = stepDatas.getStepIndex(splitBillData.getStepNumber());
        DecpStepData nextStepData = stepDatas.getStepDataByIndex(stepIndex + 1);
        ApproveBill sourceBillObj = null;
        DynamicObject applySchemeObj = null;
        Long sourceBillId = splitBillData.getSourceBillId();
        if (sourceBillId == 0L) {
            throw new KDBizException("");
        }
        sourceBillObj = ApproveBillUtil.getInstance().getApproveBill(new QFilter("id", "=", (Object)sourceBillId));
        if (splitBillData.getApplySchemeId() != 0L) {
            applySchemeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)splitBillData.getApplySchemeId(), (String)"eb_rptscheme");
        }
        ArrayList<DynamicObject> bgDecomposeDys = new ArrayList<DynamicObject>(16);
        String submitSplitInfo = this.getPageCache().get("SubmitSplitInfo");
        List submitSplitInfoList = (List)SerializationUtils.deSerializeFromBase64((String)submitSplitInfo);
        String splitPath = splitBillData.getDecpPath() + "!";
        StringBuilder newBillInfoStr = new StringBuilder();
        for (PreSubmitSplitInfo splitInfo : submitSplitInfoList) {
            DynamicObject dynamicObject = BgApplySplitUtil.getInstance().createBgDecomposeBillNew(splitInfo.getBillNumber(), nextStepData.getNumber(), splitBillData.getDecpSchemeId(), splitInfo.getOrderOrgId(), splitInfo.getSplitOrgId(), splitInfo.getSplitUserIds(), sourceBillObj, applySchemeObj, false, splitPath);
            dynamicObject.set("prebillid", (Object)splitBillData.getBillId());
            bgDecomposeDys.add(dynamicObject);
        }
        if (!bgDecomposeDys.isEmpty()) {
            String checkResult = BgApplySplitUtil.getInstance().checkCreateBillsRepeat(bgDecomposeDys, this.getModelId());
            if (StringUtils.isNotEmpty((CharSequence)checkResult)) {
                throw new KDBizException(checkResult);
            }
            SaveServiceHelper.save((DynamicObject[])bgDecomposeDys.toArray(new DynamicObject[0]));
            bgDecomposeDys.forEach(billObj -> newBillInfoStr.append('(').append(billObj.getLong("id")).append('-').append(billObj.getString("billnumber")).append(')'));
        }
        CommonServiceHelper.handleLog((Log)this.getLog(), (String)("SubmitSplitBill:" + this.getBillNumber()), (String)newBillInfoStr.toString());
    }

    @Override
    protected void afterOpenChildRow(String entityKey, List<RowInfo> insertRowsInfo) {
        super.afterOpenChildRow(entityKey, insertRowsInfo);
        this.setPreSplitDataInfo(insertRowsInfo, entityKey);
        this.lockRowByMutexSplitedRow(entityKey, insertRowsInfo);
        this.lockSplitColumn(entityKey, insertRowsInfo);
        this.setSplitedColumnSign(entityKey, insertRowsInfo);
        this.setNewRowStatus(entityKey, insertRowsInfo);
    }

    private void setNewRowStatus(String entityKey, List<RowInfo> insertRowsInfo) {
        EntryTemplateConfig tempConfig = this.getTempConfig(entityKey);
        String[] toUnLockKeys = new String[tempConfig.getDimKeysList().size()];
        int count = 0;
        for (String baseKey : tempConfig.getDimKeysList()) {
            toUnLockKeys[count++] = this.getDimColTextKey(baseKey);
        }
        String[] modifyKeys = CommonServiceHelper.changeStringArrays((Collection)tempConfig.getModifKeys());
        Map<Long, NewRowInfo> allNewRowInfo = this.getOrCacheAllNewRowInfo(null);
        ArrayList<Integer> toSignIndexs = new ArrayList<Integer>(16);
        ArrayList<Integer> toLockIndexs = new ArrayList<Integer>(16);
        Long currentSplitRowId = this.getCurrentSplitRowId(entityKey);
        for (RowInfo rowInfo : insertRowsInfo) {
            NewRowInfo newRowInfo = allNewRowInfo.get(rowInfo.getRowId());
            if (newRowInfo == null) continue;
            if (!newRowInfo.getPreSplitRowId().equals(currentSplitRowId)) {
                toLockIndexs.add(rowInfo.getIndexOnPage());
            } else {
                if (newRowInfo.getStatus() == NewRowStatusEnum.NEW) {
                    this.getView().setEnable(Boolean.valueOf(true), rowInfo.getIndexOnPage(), toUnLockKeys);
                }
                if (newRowInfo.getRowDimMembIds() != null) {
                    this.getView().setEnable(Boolean.valueOf(false), rowInfo.getIndexOnPage(), modifyKeys);
                }
            }
            toSignIndexs.add(rowInfo.getIndexOnPage());
        }
        if (toSignIndexs.size() > 0) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(entityKey);
            if (toLockIndexs.size() > 0) {
                entryGrid.setRowLock(true, CommonServiceHelper.changeIntArrays(toLockIndexs));
            }
            entryGrid.setRowBackcolor(NEWROWCOLOR, CommonServiceHelper.changeIntArrays(toSignIndexs));
        }
    }

    @Override
    protected boolean isNewRow(DynamicObject rowObj) {
        Long rowId = rowObj.getLong("id");
        return this.isNewRow(rowId);
    }

    private boolean isNewRow(Long rowId) {
        Map<Long, NewRowInfo> allNewRowIds = this.getOrCacheAllNewRowInfo(null);
        return allNewRowIds.containsKey(rowId);
    }

    private void setSplitedColumnSign(String entityKey, List<RowInfo> insertRowsInfo) {
        Map<Long, Map<Long, Set<String>>> splitededColumn = this.getOrCacheSplitedRowColKeys(null, entityKey);
        SplitRowData splitRowData = this.getCurrentSplitRowData(entityKey);
        String currentFocusSplitDim = splitRowData.getCurrentFocusSplitDim();
        if (splitededColumn != null) {
            HashSet toSignKeys = new HashSet(16);
            ArrayList<CellStyle> cellStyleList = new ArrayList<CellStyle>(insertRowsInfo.size());
            BgApplyBillUtils bgApplyBillUtils = BgApplyBillUtils.getInstance();
            for (RowInfo row : insertRowsInfo) {
                Long rowId = row.getRowId();
                Map<Long, Set<String>> splitedKeys = splitededColumn.get(rowId);
                if (splitedKeys != null) {
                    splitedKeys.values().forEach(keys -> toSignKeys.addAll(keys));
                }
                for (String key : toSignKeys) {
                    CellStyle cellStyle = bgApplyBillUtils.createCellStype(key, row.getIndexOnPage());
                    cellStyleList.add(cellStyle);
                }
                toSignKeys.clear();
            }
            if (cellStyleList.size() > 0) {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entityKey);
                entryGrid.setCellStyle(cellStyleList);
            }
        }
    }

    private void lockRowByMutexSplitedRow(String mainEntryKey, List<RowInfo> insertRowsInfo) {
        Map<Long, Map<String, Integer>> mutexMembNums = this.getOrCacheMutexMembNums(null, mainEntryKey);
        if (mutexMembNums.size() > 0 && insertRowsInfo.size() > 0) {
            SplitRowData currentSplitRowData = this.getCurrentSplitRowData(mainEntryKey);
            String currentSplitDim = currentSplitRowData.getCurrentSplitDim();
            ApplyBillEntityData currentNodeData = this.getCurrentNodeData(mainEntryKey);
            Map<Long, List<RowInfo>> firstRowMap = this.getFirstLevelRowId(currentNodeData, currentSplitDim, insertRowsInfo);
            ArrayList<Integer> toLockRowIndexs = new ArrayList<Integer>(16);
            for (Map.Entry<Long, List<RowInfo>> entry : firstRowMap.entrySet()) {
                Long firstLevelRowId = entry.getKey();
                List<RowInfo> childRows = entry.getValue();
                Map<String, Integer> membCount = mutexMembNums.get(firstLevelRowId);
                if (membCount == null || membCount.size() <= 0) continue;
                for (RowInfo rowInfo : childRows) {
                    EntityCellBaseData cellBaseData = currentNodeData.getCellBaseData(rowInfo.getIndexOnCache(), currentSplitDim);
                    if (!membCount.containsKey(cellBaseData.getNumber())) continue;
                    toLockRowIndexs.add(rowInfo.getIndexOnPage());
                }
            }
            if (toLockRowIndexs.size() > 0) {
                EntryTemplateConfig tempConfig = this.getTempConfig(mainEntryKey);
                String[] toLockKeys = tempConfig.getSplitSubKeyMap().keySet().toArray(new String[0]);
                Iterator iterator = toLockRowIndexs.iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    this.getView().setEnable(Boolean.valueOf(false), index, toLockKeys);
                }
            }
        }
    }

    private Map<Long, List<RowInfo>> getFirstLevelRowId(ApplyBillEntityData currentNodeData, String currentDimCol, List<RowInfo> insertRowsInfo) {
        Long rowId = null;
        HashMap<Long, List<RowInfo>> result = new HashMap<Long, List<RowInfo>>(16);
        ArrayList<RowInfo> childRows = null;
        List listDataOfColumn = currentNodeData.getListDataOfColumn(currentDimCol);
        for (int i = insertRowsInfo.size() - 1; i >= 0; --i) {
            RowInfo rowInfo = insertRowsInfo.get(i);
            int indexOnCache = rowInfo.getIndexOnCache();
            EntityCellBaseData cellBaseData = (EntityCellBaseData)listDataOfColumn.get(indexOnCache);
            if (childRows == null) {
                childRows = new ArrayList<RowInfo>(16);
            }
            if (cellBaseData.getLevel() == 1) {
                rowId = currentNodeData.getRowIbByIndex(indexOnCache);
                result.put(rowId, childRows);
                childRows = null;
                continue;
            }
            childRows.add(rowInfo);
        }
        if (result.isEmpty() && childRows != null) {
            int beginIndex = insertRowsInfo.get(0).getIndexOnCache();
            Long firstLevelRowId = this.getFirstLevelRowId(currentNodeData, currentDimCol, beginIndex);
            result.put(firstLevelRowId, childRows);
        }
        return result;
    }

    private Long getFirstLevelRowId(ApplyBillEntityData currentNodeData, String currentDimCol, int beginIndex) {
        Long rowId = null;
        List listDataOfColumn = currentNodeData.getListDataOfColumn(currentDimCol);
        for (int index = beginIndex; index >= 0; --index) {
            EntityCellBaseData cellBaseData = (EntityCellBaseData)listDataOfColumn.get(index);
            if (cellBaseData.getLevel() != 1) continue;
            rowId = currentNodeData.getRowIbByIndex(index);
            break;
        }
        return rowId;
    }

    private void setPreSplitDataInfo(List<RowInfo> insertRowsInfo, String entityKey) {
        EntryTemplateConfig tempConfig = this.getTempConfig(entityKey);
        DetailMembBillData detailMembBillData = this.getSourceData(entityKey);
        ApplyBillEntityData entityData = this.getCurrentNodeData(entityKey);
        ApplyBillAggHelper billAggHelper = ApplyBillAggHelper.getInstance();
        IDataModel dataModel = this.getModel();
        for (RowInfo rowInfo : insertRowsInfo) {
            String rowDimMembIdStr = billAggHelper.getRowDimMembIdStr(entityData, rowInfo.getIndexOnCache(), tempConfig.getDimKeysList());
            RowDataStatus rowDataStatus = (RowDataStatus)detailMembBillData.getDetailRowStatus().get(rowDimMembIdStr);
            if (rowDataStatus == null || rowDataStatus.isDetail()) continue;
            Object[] rowData = (Object[])detailMembBillData.getAllRowData().get(rowDataStatus.getRowIndex());
            Map splitSubKeyMap = tempConfig.getSplitSubKeyMap();
            splitSubKeyMap.forEach((splitCol, preSplitCol) -> dataModel.setValue(preSplitCol, rowData[(Integer)tempConfig.getColumnIndex().get(splitCol)], rowInfo.getIndexOnPage()));
        }
    }

    private Map<Long, Map<String, Integer>> getOrCacheMutexMembNums(Map<Long, Map<String, Integer>> mutexMemb, String mainEntryKey) {
        if (this.mutexSplitRowMembNums == null) {
            this.mutexSplitRowMembNums = new HashMap<String, Map<Long, Map<String, Integer>>>(16);
        }
        if (mutexMemb == null) {
            mutexMemb = this.mutexSplitRowMembNums.get(mainEntryKey);
            if (mutexMemb == null) {
                String cacheStr = this.getPageCache().get("MutexMembNums_" + mainEntryKey);
                mutexMemb = StringUtils.isNotEmpty((CharSequence)cacheStr) ? (HashMap)SerializationUtils.deSerializeFromBase64((String)cacheStr) : new HashMap(16);
                this.mutexSplitRowMembNums.put(mainEntryKey, mutexMemb);
            }
        } else {
            this.mutexSplitRowMembNums.put(mainEntryKey, mutexMemb);
            this.getPageCache().put("MutexMembNums_" + mainEntryKey, SerializationUtils.serializeToBase64(mutexMemb));
        }
        return mutexMemb;
    }

    private Map<Long, Map<String, Integer>> selectMutexMembOnDim(String mainEntryKey, SplitRowData splitRowData, Long currentSplitRowId) {
        Map splitedDataInfoMap;
        HashMap<Long, Map<String, Integer>> result = new HashMap<Long, Map<String, Integer>>(16);
        Map splitedRows = splitRowData.getSplitedRows();
        String currentSplitDim = splitRowData.getCurrentSplitDim();
        String preSplitDim = splitRowData.getPreSplitDim(currentSplitDim);
        if (currentSplitDim != null && !currentSplitDim.equals(preSplitDim) && splitedRows != null && (splitedDataInfoMap = (Map)splitedRows.get(currentSplitDim)) != null) {
            Map<Long, SplitedDataInfo> preSplitedDataInfoMap = this.getPreSplitRowData(splitRowData, currentSplitRowId, preSplitDim);
            ApplyBillEntityData currentNodeData = this.getCurrentNodeData(mainEntryKey);
            EntryTemplateConfig tempConfig = this.getTempConfig(mainEntryKey);
            String currentDimNum = (String)tempConfig.selectColumnMapDimNum().get(currentSplitDim);
            Map<Long, Map<String, DimMember>> parentRowDimMembMap = this.getEntryParentRowDimMembMap(preSplitedDataInfoMap.keySet(), currentNodeData, tempConfig);
            DetailMembBillData sourceData = this.getSourceData(mainEntryKey);
            ApplyBillAggHelper billAggHelper = new ApplyBillAggHelper();
            IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
            Map viewsByDataSet = modelCacheHelper.getViewsByDataSet(Long.valueOf(tempConfig.getDatasetId()));
            Long viewId = (Long)viewsByDataSet.get(currentDimNum);
            int dimColIndex = (Integer)tempConfig.getColumnIndex().get(currentSplitDim);
            Set<String> splitKeys = tempConfig.getSplitSubKeyMap().keySet();
            for (Long splitRowId : preSplitedDataInfoMap.keySet()) {
                Map<String, DimMember> dimMemberMap = parentRowDimMembMap.get(splitRowId);
                if (dimMemberMap == null) continue;
                Map numberCount = result.computeIfAbsent(splitRowId, key -> new HashMap(16));
                Map<String, String> members = dimMemberMap.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> ((DimMember)entry.getValue()).getNumber()));
                Map detailChildMemb = billAggHelper.getDetailChildMemb(members, modelCacheHelper, viewsByDataSet, tempConfig);
                for (Object[] rowData : sourceData.getAllRowData()) {
                    String[] parentNums;
                    boolean match;
                    Long rowId = billAggHelper.getRowId(rowData);
                    SplitedDataInfo splitedDataInfo = (SplitedDataInfo)splitedDataInfoMap.get(rowId);
                    if (splitedDataInfo == null || this.noChangeSplitData(splitedDataInfo, splitKeys) || this.isNewRow(rowId) || !(match = billAggHelper.matchChildRow(tempConfig.getDimKeysList(), tempConfig.getColumnIndex(), detailChildMemb, rowData))) continue;
                    Long membId = (Long)rowData[dimColIndex];
                    Member member = modelCacheHelper.getMember(currentDimNum, viewId, membId);
                    for (String num : parentNums = member.getLongNumber().split("!")) {
                        Integer count;
                        if (member.getNumber().equals(num)) continue;
                        Integer n2 = count = numberCount.computeIfAbsent(num, n -> 0);
                        Integer n3 = count = Integer.valueOf(count + 1);
                        numberCount.put(num, count);
                    }
                }
            }
        }
        return result;
    }

    private Map<Long, SplitedDataInfo> getPreSplitRowData(SplitRowData splitRowData, Long currentSplitRowId, String preSplitDim) {
        Map<Long, Object> preSplitedDataInfoMap;
        if (preSplitDim == null) {
            preSplitedDataInfoMap = new HashMap<Long, SplitedDataInfo>(16);
            preSplitedDataInfoMap.put(currentSplitRowId, splitRowData.getSplitedData());
        } else {
            preSplitedDataInfoMap = (Map)splitRowData.getSplitedRows().get(preSplitDim);
        }
        if (preSplitedDataInfoMap == null) {
            preSplitedDataInfoMap = new HashMap(16);
        }
        return preSplitedDataInfoMap;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String backKey;
        super.closedCallBack(closedCallBackEvent);
        switch (backKey = closedCallBackEvent.getActionId()) {
            case "handleCreateNextSplitBill": {
                String returnData = (String)closedCallBackEvent.getReturnData();
                if (!StringUtils.isNotEmpty((CharSequence)returnData) || !returnData.equals("confirm")) break;
                this.finishSubmit(this.getOrCacheDecpBillData(null));
                break;
            }
            case "splitDimSeting": {
                this.dealPreDimSetBack(closedCallBackEvent);
            }
        }
    }

    private void dealPreDimSetBack(ClosedCallBackEvent closedCallBackEvent) {
        String returnData = (String)closedCallBackEvent.getReturnData();
        if (StringUtils.isNotEmpty((CharSequence)returnData)) {
            String currentEntityKey = this.getCurrentEntityKey();
            String splitEntryKey = this.getSplitEntryKey(currentEntityKey);
            IDataModel model = this.getModel();
            int currentRowIndex = model.getEntryCurrentRowIndex(splitEntryKey);
            Map<Long, SplitRowData> splitRowDataMap = this.getOrCacheSplitRowInfo(null, currentEntityKey);
            Long currentSplitRowId = this.getCurrentSplitRowId(currentEntityKey);
            SplitRowData splitRowData = splitRowDataMap.get(currentSplitRowId);
            List newSetting = SerializationUtils.fromJsonStringToList((String)returnData, DimensionColumnObj.class);
            StringBuilder sb = new StringBuilder();
            ArrayList<String> splitDimList = new ArrayList<String>(16);
            for (DimensionColumnObj dimcol : newSetting) {
                sb.append(dimcol.getColName()).append(',');
                splitDimList.add(dimcol.getColKey());
            }
            sb.deleteCharAt(sb.length() - 1);
            this.setNeedDealPropchange(false);
            this.getModel().setValue("s_splitdims" + splitEntryKey.replace("splitentryentity", ""), (Object)sb.toString(), currentRowIndex);
            this.setNeedDealPropchange(true);
            splitRowData.setNotDetailDimColumn(splitDimList);
            this.getOrCacheSplitRowInfo(splitRowDataMap, currentEntityKey);
        }
    }

    public void finishSubmit(DecpBillData decpBillData) {
        this.checkMutexLockB4Op();
        try (OlapTXHandle tx = OlapTX.required((String)"finishSubmit");){
            try {
                this.createNextStepSplitBill(decpBillData);
                Map<String, List<AuditRecordObj>> toSaveOlap = this.select4SaveOlapData(false);
                BillSaveEventArgs eventArgs = new BillSaveEventArgs();
                eventArgs.setBlendedSaveOlap(true);
                eventArgs.setAllChangeRecord(toSaveOlap);
                this.saveAllTemplateDataToOlap(eventArgs);
                this.handleLogToSaveOlapData(toSaveOlap);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
        this.afterSubmitSplit(decpBillData);
    }

    private void handleLogToSaveOlapData(Map<String, List<AuditRecordObj>> toSaveOlap) {
        String sign = "LogToSaveOlapData-" + this.getBillNumber();
        Set<String> logSignsFromForm = this.getLogSignsFromForm();
        if (logSignsFromForm.contains(sign)) {
            CommonServiceHelper.handleLog((Log)this.getLog(), (String)sign, (String)SerializationUtils.toJsonString(toSaveOlap));
        }
    }

    private void afterSubmitSplit(DecpBillData decpBillData) {
        this.updateModifyInfo();
        BgApplySplitUtil.getInstance().saveBillEditInfo(decpBillData.getBillId(), SplitStatus.SPLITEND);
        decpBillData.setSplited(true);
        this.getModel().setDataChanged(false);
        this.getOrCacheDecpBillData(decpBillData);
        this.updateFormBySubmitStatus(true);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"BgApplySplitBillPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private Map<String, List<AuditRecordObj>> select4SaveOlapData(boolean isRollBack) {
        Map<String, Map<Long, SplitRowData>> splitRowDataMap = this.getAllSplitRowInfo(true);
        HashMap<String, List<AuditRecordObj>> allToSaveOlapDatas = new HashMap<String, List<AuditRecordObj>>(16);
        splitRowDataMap.forEach((entryKey, preSplitRows) -> {
            ArrayList toSaveOlapDatas = new ArrayList(16);
            EntryTemplateConfig tempConfig = this.getTempConfig((String)entryKey);
            DetailMembBillData sourceData = this.getSourceData((String)entryKey);
            Set modifKeys = tempConfig.getModifKeys();
            sourceData.initRowStatusByRowId();
            Map<Long, List<SplitedDataInfo>> splitRowDataMapRowId = this.changeSplitRowData((Map<Long, SplitRowData>)preSplitRows);
            splitRowDataMapRowId.forEach((rowId, splitedRowDataList) -> {
                Map<String, Object> allModifSplitData = this.selectAllModifSplitData((List<SplitedDataInfo>)splitedRowDataList, (Set<String>)modifKeys, true, isRollBack);
                if (isRollBack) {
                    this.turnVal(allModifSplitData);
                }
                this.select4SaveOlapData(tempConfig, allModifSplitData, (Long)rowId, toSaveOlapDatas, sourceData);
            });
            if (toSaveOlapDatas.size() > 0) {
                allToSaveOlapDatas.put((String)entryKey, toSaveOlapDatas);
            }
        });
        return allToSaveOlapDatas;
    }

    private void select4SaveOlapData(EntryTemplateConfig tempConfig, Map<String, Object> modifiedDatas, Long rowId, List<AuditRecordObj> toSaveOlapDatas, DetailMembBillData sourceData) {
        BgApplyBillUtils applyBillUtils = BgApplyBillUtils.getInstance();
        AuditRecordObj recordObj = new AuditRecordObj();
        List changeDataInfos = recordObj.getChangeDataInfos();
        Map sourceDataRow = sourceData.getSourceDataRowStatus();
        Set modifKeys = tempConfig.getModifKeys();
        Set currencyColumnKeys = tempConfig.getCurrencyColumnKeys();
        BigDecimal unitData = this.getUnitData(tempConfig.getUnit());
        for (String colKey : modifKeys) {
            Object val = modifiedDatas.get(colKey);
            if (val == null || val instanceof BigDecimal && BigDecimal.ZERO.compareTo((BigDecimal)val) == 0) continue;
            if (currencyColumnKeys.contains(colKey) && val instanceof BigDecimal) {
                val = this.changeValByUnit(val, unitData);
            }
            AdjustRecordColInfo recordColInfo = new AdjustRecordColInfo();
            recordColInfo.setAdjust(val);
            recordColInfo.setKey(colKey);
            changeDataInfos.add(recordColInfo);
        }
        if (changeDataInfos.size() > 0) {
            recordObj.setDataSetId(Long.valueOf(tempConfig.getDatasetId()));
            recordObj.setTemplateId(Long.valueOf(tempConfig.getTemplateID()));
            RowDataStatus rowDataStatus = (RowDataStatus)sourceDataRow.get(rowId);
            if (rowDataStatus != null) {
                Object[] rowVals = (Object[])sourceData.getAllRowData().get(rowDataStatus.getRowIndex());
                Map rowDimGroup = applyBillUtils.getDimMembList(tempConfig.getDimKeysList(), tempConfig.selectColumnMapDimNum(), rowVals, tempConfig.getColumnIndex());
                recordObj.setRowDimGroup(rowDimGroup);
                recordObj.setDetail(rowDataStatus.isDetail());
                recordObj.setNew(false);
            }
            toSaveOlapDatas.add(recordObj);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "nextstep": {
                this.handleNextStep();
                break;
            }
            case "prestep": {
                this.handlePreStep();
                break;
            }
            case "autosplit": {
                this.handleAutoSplit();
                break;
            }
            case "unsubmitsplit": {
                this.handleUnSubmit();
                break;
            }
            case "savesplit": {
                break;
            }
            case "addnewrow": {
                this.addNewRow();
                break;
            }
            case "delnewrow": {
                this.handleDelNewRow();
                break;
            }
            case "rollbackall": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u6e05\u9664\u6240\u6709\u5df2\u4fee\u6539\u7684\u6570\u636e\uff1f", (String)"BgApplySplitBillPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("rollBackAll", (IFormPlugin)this));
            }
        }
    }

    private void handleDelNewRow() {
        String currentEntityKey = this.getCurrentEntityKey();
        EntryGrid entryGrid = (EntryGrid)this.getControl(currentEntityKey);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u65b0\u589e\u884c\u3002", (String)"BgApplySplitBillPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection rows = this.getModel().getEntryEntity(currentEntityKey);
        Map<Long, NewRowInfo> allNewRowInfo = this.getOrCacheAllNewRowInfo(null);
        Long currentSplitRowId = this.getCurrentSplitRowId(currentEntityKey);
        for (int index : selectRows) {
            DynamicObject rowObj = (DynamicObject)rows.get(index);
            Long rowId = rowObj.getLong("id");
            NewRowInfo newRowInfo = allNewRowInfo.get(rowId);
            if (newRowInfo == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5220\u9664\u65b0\u589e\u7684\u884c\u3002", (String)"BgApplySplitBillPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
            if (currentSplitRowId.equals(newRowInfo.getPreSplitRowId())) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u5220\u9664\u5728\u5f53\u524d\u5206\u89e3\u884c\u4e0b\u65b0\u589e\u7684\u884c\u3002", (String)"BgApplySplitBillPlugin_29", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String splitDimKey = this.getOrCacheCurrentSplitDimKeys(null).get(currentEntityKey);
        String focusDimKey = this.getOrCacheCurrentFocusDimKeys(null).get(currentEntityKey);
        if (splitDimKey != null && !splitDimKey.equals(focusDimKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7ef4\u5ea6\u4e0d\u662f\u5f85\u5206\u89e3\u7ef4\u5ea6\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u884c\u3002", (String)"BgApplySplitBillPlugin_30", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadResFormat((String)"\u786e\u8ba4\u5220\u9664\u9009\u4e2d\u7684%1\u884c?", (String)"BgApplySplitBillPlugin_31", (String)"epm-eb-formplugin", (Object[])new Object[]{selectRows.length}), MessageBoxOptions.YesNo, new ConfirmCallBackListener("delNewRow", (IFormPlugin)this));
    }

    private void delNewRow() {
        String currentEntityKey = this.getCurrentEntityKey();
        EntryGrid entryGrid = (EntryGrid)this.getControl(currentEntityKey);
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection rows = this.getModel().getEntryEntity(currentEntityKey);
        Map<Long, NewRowInfo> allNewRowInfo = this.getOrCacheAllNewRowInfo(null);
        Long currentSplitRowId = this.getCurrentSplitRowId(currentEntityKey);
        DetailMembBillData sourceData = this.getSourceData(currentEntityKey);
        EntryTemplateConfig tempConfig = this.getTempConfig(currentEntityKey);
        this.setNeedDealPropchange(false);
        ArrayList<Integer> deledIndexsOnSource = new ArrayList<Integer>(selectRows.length);
        HashSet<Long> deledRowIds = new HashSet<Long>(16);
        for (int index : selectRows) {
            DynamicObject rowObj = (DynamicObject)rows.get(index);
            Long rowId = rowObj.getLong("id");
            deledRowIds.add(rowId);
            NewRowInfo newRowInfo = allNewRowInfo.get(rowId);
            if (newRowInfo.getStatus() == NewRowStatusEnum.EDIT) {
                newRowInfo.setStatus(NewRowStatusEnum.DELETED);
            } else {
                allNewRowInfo.remove(rowId);
            }
            if (newRowInfo.getRowDimMembIds() != null) continue;
            this.addBackValToParentRow(tempConfig, currentEntityKey, sourceData, rowId, newRowInfo.getRefLevelOneSplitRowId());
            String rowDimMembIdStr = ApplyBillAggHelper.getInstance().getRowDimMembIdStr(rowObj, tempConfig.getDimKeysList());
            RowDataStatus row = (RowDataStatus)sourceData.getDetailRowStatus().get(rowDimMembIdStr);
            Object[] objects = (Object[])sourceData.getAllRowData().get(row.getRowIndex());
            for (String key : tempConfig.getAggKeys()) {
                int colIndex = (Integer)tempConfig.getColumnIndex().get(key);
                objects[colIndex] = this.getZero();
            }
            deledIndexsOnSource.add(row.getRowIndex());
            List<RowInfo> udpatedRowInfos = this.updateAggDataToForm(currentEntityKey, (Set<String>)tempConfig.getAggKeys(), null, index, AggTypeEnum.ROWPARENTS);
            List<Integer> rowIndexs = udpatedRowInfos.stream().map(rowInfo -> rowInfo.getIndexOnPage()).collect(Collectors.toList());
            this.updateLevelOneSplitRow(tempConfig, sourceData, newRowInfo.getRefLevelOneSplitRowId(), currentEntityKey);
            this.updateRowsRelationValues(rowIndexs, tempConfig);
        }
        this.setNeedDealPropchange(true);
        if (!deledRowIds.isEmpty()) {
            ApplyBillEntityData currentNodeData = this.getCurrentNodeData(currentEntityKey);
            currentNodeData.removeRowDataByRowIds(deledRowIds);
        }
        if (!deledIndexsOnSource.isEmpty()) {
            this.cleanNewRowInfoAfterRoll(deledIndexsOnSource, sourceData, tempConfig);
            this.cacheNewRowInfo();
        }
        this.setNeedDealPropchange(false);
        this.updatePreSplitEntryRow(tempConfig.getSplitSubKeyMap().keySet(), currentSplitRowId, currentEntityKey);
        this.setNeedDealPropchange(true);
        this.getModel().deleteEntryRows(currentEntityKey, selectRows);
        this.getOrCacheAllNewRowInfo(allNewRowInfo);
        this.cacheSourceData(currentEntityKey);
        this.cacheBillEntryNodeData(currentEntityKey);
        Map<Long, SplitRowData> splitRowDataMap = this.getOrCacheSplitRowInfo(null, currentEntityKey);
        this.getOrCacheSplitRowInfo(splitRowDataMap, currentEntityKey);
    }

    private void addNewRow() {
        int refSplitRowIndexOnCache;
        int level;
        DynamicObject rowObj;
        int index;
        String currentEntityKey = this.getCurrentEntityKey();
        EntryGrid entryGrid = (EntryGrid)this.getControl(currentEntityKey);
        int focusRow = entryGrid.getEntryState().getFocusRow();
        if (focusRow < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u5e94\u7684\u5206\u89e3\u884c\u3002", (String)"BgApplySplitBillPlugin_32", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String splitDimKey = this.getOrCacheCurrentSplitDimKeys(null).get(currentEntityKey);
        String focusDimKey = this.getOrCacheCurrentFocusDimKeys(null).get(currentEntityKey);
        if (splitDimKey != null && !splitDimKey.equals(focusDimKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7ef4\u5ea6\u4e0d\u662f\u5f85\u5206\u89e3\u7ef4\u5ea6\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u884c\u3002", (String)"BgApplySplitBillPlugin_33", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection rows = this.getModel().getEntryEntity(currentEntityKey);
        int refSplitRowIndex = -1;
        int nextSplitRowIndex = rows.size();
        Long refSplitRowId = null;
        Long nextSplitRowId = null;
        String levelColKey = this.getLevelColKey(currentEntityKey);
        for (index = focusRow; index >= 0; --index) {
            rowObj = (DynamicObject)rows.get(index);
            level = rowObj.getInt(levelColKey);
            if (level != 1) continue;
            refSplitRowIndex = index;
            refSplitRowId = rowObj.getLong("id");
            break;
        }
        for (index = focusRow + 1; index < rows.size(); ++index) {
            rowObj = (DynamicObject)rows.get(index);
            level = rowObj.getInt(levelColKey);
            if (level != 1) continue;
            nextSplitRowIndex = index;
            nextSplitRowId = rowObj.getLong("id");
            break;
        }
        if (refSplitRowId == null) {
            return;
        }
        ApplyBillEntityData currentNodeData = this.getCurrentNodeData(currentEntityKey);
        EntityCellBaseData parentMembCell = currentNodeData.getCellBaseData(refSplitRowIndexOnCache = currentNodeData.getRowIndexByRowId(refSplitRowId), splitDimKey);
        if (parentMembCell.getGroupStatus() == CellGroupStatusEnum.CLOSE) {
            entryGrid.clickCell(this.getDimColTextKey(splitDimKey), focusRow);
            rows = this.getModel().getDataEntity(true).getDynamicObjectCollection(currentEntityKey);
            nextSplitRowIndex = rows.size();
            for (int index2 = refSplitRowIndex + 1; index2 < rows.size(); ++index2) {
                rowObj = (DynamicObject)rows.get(index2);
                level = rowObj.getInt(levelColKey);
                if (level != 1) continue;
                nextSplitRowId = rowObj.getLong("id");
                nextSplitRowIndex = index2;
                break;
            }
        }
        int indexInCache = nextSplitRowId == null ? currentNodeData.getRowIds().size() : currentNodeData.getRowIndexByRowId(nextSplitRowId);
        this.addNewRow(currentNodeData, currentEntityKey, nextSplitRowIndex, indexInCache, refSplitRowId);
    }

    private void addNewRow(ApplyBillEntityData currentNodeData, String currentEntityKey, int insertIndexOnPage, int insertIndexOnCache, Long refSplitRowId) {
        IDataModel dataModel = this.getModel();
        int newRowIndex = dataModel.insertEntryRow(currentEntityKey, insertIndexOnPage);
        Long newRowId = GlobalIdUtil.genGlobalLongId();
        DynamicObject newRowObj = dataModel.getEntryRowEntity(currentEntityKey, newRowIndex);
        newRowObj.set("id", (Object)newRowId);
        newRowObj.set(this.getLevelColKey(currentEntityKey), (Object)2);
        for (String dimColKey : currentNodeData.getBaseDataKeys()) {
            EntityCellBaseData cellBaseData = new EntityCellBaseData();
            cellBaseData.setLevel(2);
            cellBaseData.setLeaf(true);
            cellBaseData.setName("");
            cellBaseData.setNumber("");
            cellBaseData.setId(Long.valueOf(0L));
            currentNodeData.addCellBaseData(insertIndexOnCache, dimColKey, cellBaseData);
        }
        for (String otherKey : currentNodeData.getOtherDataKeys()) {
            currentNodeData.addCellOtherData(insertIndexOnCache, otherKey, null);
        }
        EntryTemplateConfig tempConfig = this.getTempConfig(currentEntityKey);
        currentNodeData.addRowId(insertIndexOnCache, newRowId);
        currentNodeData.getRowChanged().add(insertIndexOnCache, false);
        Map<Long, NewRowInfo> allNewRowIds = this.getOrCacheAllNewRowInfo(null);
        NewRowInfo newRowInfo = new NewRowInfo(refSplitRowId, this.getCurrentSplitRowId(currentEntityKey), tempConfig.getNumber(), NewRowStatusEnum.NEW);
        newRowInfo.setRowDimMembIds(new HashMap(16));
        allNewRowIds.put(newRowId, newRowInfo);
        this.setNewRowStatus(currentEntityKey, Collections.singletonList(new RowInfo(insertIndexOnPage, insertIndexOnCache, newRowId)));
        this.getOrCacheAllNewRowInfo(allNewRowIds);
        this.cacheBillEntryNodeData(currentEntityKey);
    }

    private void handleSubmit(BeforeDoOperationEventArgs args) {
        try {
            BillVerifyResult verifyResult = new BillVerifyResult();
            this.saveBillData(true, "savesplit", verifyResult);
            this.checkSubmit(verifyResult);
            if (verifyResult.isSuccess()) {
                DecpBillData splitBillData = this.getOrCacheDecpBillData(null);
                if (splitBillData.getNextStepNumber() == null) {
                    this.finishSubmit(splitBillData);
                    return;
                }
                this.handleCreateNextSplitBill();
            }
            verifyResult.setCancel(true);
            this.handleVerifyResult(args, verifyResult, ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ReportSchemeEditPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25", (String)"BgApplyBillPlugin_82", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u63d0\u4ea4\u5931\u8d25\uff1a%1\u3002", (String)"BgApplyBillPlugin_54", (String)"epm-eb-formplugin", (Object[])new Object[]{e.getMessage()}));
        }
    }

    private void handleUnSubmit() {
        DynamicObject billObj = this.checkBillStatus("unsubmitsplit");
        long billId = billObj.getLong("id");
        DynamicObjectCollection nextBills = QueryServiceHelper.query((String)"eb_bgdecompose", (String)"id,billnumber,splitstatus", (QFilter[])new QFilter[]{new QFilter("prebillid", "=", (Object)billId)});
        StringBuilder sbErrorNumber = new StringBuilder();
        ArrayList sbOKNumbers = new ArrayList(16);
        ArrayList billIds = new ArrayList(16);
        nextBills.forEach(obj -> {
            String status = obj.getString("splitstatus");
            String number = obj.getString("billnumber");
            Long id = obj.getLong("id");
            if (status.equals(SplitStatus.SPLITEND.getValue())) {
                sbErrorNumber.append(number).append(',');
            } else {
                sbOKNumbers.add(number);
                billIds.add(id);
            }
        });
        if (sbErrorNumber.length() > 0) {
            sbErrorNumber.deleteCharAt(sbErrorNumber.length() - 1);
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u64a4\u9500\u5931\u8d25\uff0c\u4e0b\u4e00\u6b65\u5355\u636e\u4e2d\uff1a%1 \u5df2\u5206\u89e3\u3002", (String)"BgApplySplitBillPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[]{sbErrorNumber.toString()}));
            return;
        }
        StringBuilder mes = new StringBuilder();
        if (sbOKNumbers.size() > 0) {
            this.getPageCache().put("unSumbmitSplitBillIds", SerializationUtils.toJsonString(billIds));
            mes.append(ResManager.loadResFormat((String)"\u5c06\u64a4\u9500\u5df2\u63d0\u4ea4\u7684\u591a\u7ef4\u6570\u636e\uff0c\u5e76\u5220\u9664\u5206\u89e3\u5355\uff1a%1,\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BgApplySplitBillPlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[]{SerializationUtils.toJsonString(sbOKNumbers)}));
        } else {
            mes.append(ResManager.loadKDString((String)"\u5c06\u64a4\u9500\u5df2\u63d0\u4ea4\u7684\u591a\u7ef4\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BgApplySplitBillPlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[]{SerializationUtils.toJsonString(sbOKNumbers)}));
        }
        this.getView().showConfirm(mes.toString(), MessageBoxOptions.YesNo, new ConfirmCallBackListener("unSumbmitSplitBill", (IFormPlugin)this));
    }

    private void checkMutexLockB4Op() {
        Long lockId = this.getOrCacheMutexLockId(null);
        if (lockId == null || lockId.equals(0L)) {
            return;
        }
        MutexRecordObj lockRecord = MutexRecordHelper.getLockRecord((Long)lockId);
        if (lockRecord == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u5df2\u5931\u6548\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u8fdb\u5165\u3002", (String)"BgApplySplitBillPlugin_23", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private DynamicObject checkBillStatus(String opKey) {
        String billNumber = this.getBillNumber();
        Long modelId = this.getModelId();
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_bgdecompose", (String)"id,splitstatus", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId), new QFilter("billnumber", "=", (Object)billNumber)});
        if (dynamicObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728\u3002", (String)"BgApplySplitBillPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        String status = dynamicObject.getString("splitstatus");
        if ("save".equals(opKey) && SplitStatus.SPLITEND.getValue().equals(status)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u4e3a\u5df2\u5206\u89e3\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002", (String)"BgApplySplitBillPlugin_12", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if ("savesplit".equals(opKey) && SplitStatus.SPLITEND.getValue().equals(status)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u4e3a\u5df2\u5206\u89e3\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"BgApplySplitBillPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if ("unsubmitsplit".equals(opKey) && !SplitStatus.SPLITEND.getValue().equals(status)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u4e3a\u975e\u5206\u89e3\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u64a4\u9500\u3002", (String)"BgApplySplitBillPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return dynamicObject;
    }

    @Override
    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        String entryKey = entryGrid.getEntryKey();
        if (this.isSplitEntry(entryKey)) {
            String mainEntryKey = this.getMainEntryKey(entryKey);
            int[] selectRows = entryGrid.getSelectRows();
            Long currentSplitRowId = this.getCurrentSplitRowId(mainEntryKey);
            if (selectRows.length > 0) {
                int currentRowIndex = selectRows[0];
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(entryKey, currentRowIndex);
                Long rowId = entryRowEntity.getLong("id");
                if (currentSplitRowId == null || !currentSplitRowId.equals(rowId)) {
                    this.updateSplitResultEntryData(entryGrid.getKey(), currentRowIndex);
                }
            } else if (currentSplitRowId != null) {
                this.getModel().deleteEntryData(mainEntryKey);
                this.setCurrentSplitRowId(entryGrid.getEntryKey(), null);
                this.updateSplitDimPathShow(mainEntryKey, null);
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String ctrlKey = ((Control)evt.getSource()).getKey();
        if (ctrlKey.startsWith("splitdim_")) {
            this.handleSplitDimClick(ctrlKey);
        }
    }

    private void handleSplitDimClick(String ctrlKey) {
        String splitDimKey = ctrlKey.replace("splitdim_", "");
        String currentMaimEntryKey = this.getCurrentEntityKey();
        String splitEntryKey = this.getSplitEntryKey(currentMaimEntryKey);
        Long preSplitRowId = this.getOrCacheCurrentSplitRowId(null).get(splitEntryKey);
        Map<Long, SplitRowData> splitRowInfo = this.getOrCacheSplitRowInfo(null, currentMaimEntryKey);
        this.updateSplitResultEntryData(currentMaimEntryKey, splitEntryKey, preSplitRowId, splitRowInfo, null, splitDimKey);
        this.updateSplitDimPathShow(currentMaimEntryKey, preSplitRowId);
        this.getOrCacheSplitRowInfo(splitRowInfo, currentMaimEntryKey);
    }

    private void handleAutoSplit() {
        String currentFocusSplitDim;
        String currentEntityKey = this.getCurrentEntityKey();
        Long currentSplitRowId = this.getCurrentSplitRowId(currentEntityKey);
        if (currentSplitRowId == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f85\u5206\u89e3\u884c\u6570\u636e\u3002", (String)"BgApplySplitBillPlugin_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<Long, SplitRowData> splitRowDataMap = this.getOrCacheSplitRowInfo(null, currentEntityKey);
        SplitRowData splitRowData = splitRowDataMap.get(currentSplitRowId);
        String currentSplitDim = splitRowData.getCurrentSplitDim();
        if (!currentSplitDim.equals(currentFocusSplitDim = splitRowData.getCurrentFocusSplitDim())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f53\u524d\u5206\u89e3\u7ef4\u5ea6\u3002", (String)"BgApplySplitBillPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u81ea\u52a8\u5206\u89e3\u5c06\u6e05\u9664\u5f53\u524d\u5206\u89e3\u7ef4\u5ea6\u4e0b\u5df2\u5206\u89e3\u7684\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BgApplySplitBillPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("AutoSplit", (IFormPlugin)this));
    }

    private void handleNextStep() {
        String currentFocusSplitDim;
        String mainEntityKey = this.getCurrentEntityKey();
        String splitEntryKey = this.getSplitEntryKey(mainEntityKey);
        Long currentSplitRowId = this.getOrCacheCurrentSplitRowId(null).get(splitEntryKey);
        if (currentSplitRowId == null || currentSplitRowId.equals(0L)) {
            return;
        }
        EntryTemplateConfig tempConfig = this.getTempConfig(mainEntityKey);
        Map<Long, SplitRowData> splitRowDataMap = this.getOrCacheSplitRowInfo(null, mainEntityKey);
        SplitRowData splitRowDataInfo = splitRowDataMap.get(currentSplitRowId);
        String nextSplitDim = splitRowDataInfo.getNextSplitDim(currentFocusSplitDim = splitRowDataInfo.getCurrentFocusSplitDim());
        if (nextSplitDim == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u6700\u540e\u4e00\u4e2a\u5206\u89e3\u7ef4\u5ea6\u3002", (String)"BgApplySplitBillPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        SplitDataCheckResult checkResult = this.splitDimHasChangeData(splitRowDataInfo, currentFocusSplitDim, tempConfig);
        if (checkResult == SplitDataCheckResult.NOCHANGE) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u672a\u6539\u52a8\u3002", (String)"BgApplySplitBillPlugin_39", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Set preSplitRowIds = splitRowDataInfo.selectPreSplitRowIdOnCurrentDim(currentSplitRowId);
        ApplyBillAggHelper billAggHelper = ApplyBillAggHelper.getInstance();
        ApplyBillEntityData currentNodeData = this.getCurrentNodeData(mainEntityKey);
        DetailMembBillData sourceData = this.getSourceData(mainEntityKey);
        Set splitColKeys = tempConfig.getSplitColumnMap().keySet();
        for (int rowIndx = 0; rowIndx < currentNodeData.getRowIds().size(); ++rowIndx) {
            Long rowId = currentNodeData.getRowIbByIndex(rowIndx);
            if (!preSplitRowIds.contains(rowId)) continue;
            String rowDimMembIdStr = billAggHelper.getRowDimMembIdStr(currentNodeData, rowIndx, tempConfig.getDimKeysList());
            RowDataStatus rowDataStatus = (RowDataStatus)sourceData.getDetailRowStatus().get(rowDimMembIdStr);
            Object[] rowData = (Object[])sourceData.getAllRowData().get(rowDataStatus.getRowIndex());
            for (String splitCol : splitColKeys) {
                BigDecimal subData = (BigDecimal)rowData[(Integer)tempConfig.getColumnIndex().get(splitCol)];
                if (subData == null || subData.compareTo(BigDecimal.ZERO) == 0) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f85\u5206\u89e3\u884c\u672a\u5b8c\u6210\u5206\u89e3\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u4e0b\u4e00\u6b65\u3002", (String)"BgApplySplitBillPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if (checkResult == SplitDataCheckResult.OLNYNEWROWCHANGE) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u6709\u6570\u636e\u5df2\u5206\u89e3\u5230\u660e\u7ec6\u884c\u3002", (String)"BgApplySplitBillPlugin_37", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<Long, NewRowInfo> allNewRowInfo = this.getOrCacheAllNewRowInfo(null);
        for (Map.Entry<Long, NewRowInfo> newRowInfoEntry : allNewRowInfo.entrySet()) {
            NewRowInfo rowInfo = newRowInfoEntry.getValue();
            Long preSplitRowId = rowInfo.getPreSplitRowId();
            Long refLevelOneSplitRowId = rowInfo.getRefLevelOneSplitRowId();
            if (rowInfo.getRowDimMembIds() == null || !preSplitRowIds.contains(refLevelOneSplitRowId) || !currentSplitRowId.equals(preSplitRowId)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b0\u589e\u884c\u7684\u7ef4\u5ea6\u6210\u5458\u672a\u8bbe\u7f6e\u5b8c\u6574\u3002", (String)"BgApplySplitBillPlugin_38", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (currentFocusSplitDim.equals(splitRowDataInfo.getCurrentSplitDim())) {
            this.markRowNotPastZero(splitRowDataInfo, splitRowDataInfo.getCurrentSplitDim(), tempConfig.getSplitColumnMap().keySet(), true);
            splitRowDataInfo.setCurrentSplitDim(nextSplitDim);
            splitRowDataInfo.getSplitedRows().put(nextSplitDim, new HashMap(16));
        }
        splitRowDataInfo.setCurrentFocusSplitDim(nextSplitDim);
        this.updateSplitResultEntryData(mainEntityKey, splitEntryKey, currentSplitRowId, splitRowDataMap, null, nextSplitDim);
        this.updateSplitDimPathShow(mainEntityKey, currentSplitRowId);
        this.getOrCacheSplitRowInfo(splitRowDataMap, mainEntityKey);
    }

    private SplitDataCheckResult splitDimHasChangeData(SplitRowData splitRowDataInfo, String splitDim, EntryTemplateConfig tempConfig) {
        Map splitedDataInfoMap = (Map)splitRowDataInfo.getSplitedRows().get(splitDim);
        boolean hasChange = false;
        boolean olnyNewRowChange = true;
        if (splitedDataInfoMap != null && !splitedDataInfoMap.isEmpty()) {
            Map<Long, NewRowInfo> allNewRowInfo = this.getOrCacheAllNewRowInfo(null);
            for (Map.Entry entry : splitedDataInfoMap.entrySet()) {
                Long rowId = (Long)entry.getKey();
                SplitedDataInfo splitedDataInfo = (SplitedDataInfo)entry.getValue();
                if (this.noChangeSplitData(splitedDataInfo, tempConfig.getSplitColumnMap().keySet())) continue;
                hasChange = true;
                if (allNewRowInfo.containsKey(rowId)) continue;
                olnyNewRowChange = false;
                break;
            }
        }
        SplitDataCheckResult result = !hasChange ? SplitDataCheckResult.NOCHANGE : (olnyNewRowChange ? SplitDataCheckResult.OLNYNEWROWCHANGE : SplitDataCheckResult.NONEWROWCHANGE);
        return result;
    }

    private void markRowNotPastZero(SplitRowData splitRowDataInfo, String currentSplitDim, Set<String> splitColKeys, boolean isPast) {
        Map splitedDataInfoMap = (Map)splitRowDataInfo.getSplitedRows().get(currentSplitDim);
        if (splitedDataInfoMap != null) {
            splitedDataInfoMap.values().forEach(rowData -> {
                if (isPast) {
                    if (!this.noChangeSplitData((SplitedDataInfo)rowData, splitColKeys)) {
                        rowData.setPastByZero(false);
                    }
                } else {
                    rowData.setPastByZero(true);
                }
            });
        }
    }

    private void handlePreStep() {
        String currentEntityKey = this.getCurrentEntityKey();
        SplitRowData currentSplitRowData = this.getCurrentSplitRowData(currentEntityKey);
        if (currentSplitRowData != null) {
            String preSplitDim;
            String currentSplitDim = currentSplitRowData.getCurrentSplitDim();
            String currentFocusSplitDim = currentSplitRowData.getCurrentFocusSplitDim();
            if (currentFocusSplitDim.equals(currentSplitDim) && (preSplitDim = currentSplitRowData.getPreSplitDim(currentFocusSplitDim)) != null) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u64a4\u9500\u5f53\u524d\u5206\u89e3\u7ef4\u5ea6\u7684\u4fee\u6539\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BgApplySplitBillPlugin_18", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("preStep", (IFormPlugin)this));
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (event.getResult() == MessageBoxResult.Yes) {
            if ("preStep".equals(callBackId)) {
                this.rollbackDimSplit();
            } else if ("AutoSplit".equals(callBackId)) {
                this.autoSplit();
            } else if ("unSumbmitSplitBill".equals(callBackId)) {
                this.unSubmitBill();
            } else if ("delNewRow".equals(callBackId)) {
                this.delNewRow();
            } else if ("rollBackAll".equals(callBackId)) {
                this.rollbackALlData();
            }
        }
    }

    private void unSubmitBill() {
        this.checkMutexLockB4Op();
        LogHelper logHelper = new LogHelper(this.getBillNumber(), log);
        try (OlapTXHandle tx = OlapTX.required((String)"saveBillData");){
            try {
                this.rollBackDbForUnSubmit();
                logHelper.addInfoLog("rollBackDbForUnSubmit");
                this.rollBackOlapForUnSubmit();
                logHelper.addInfoLog("rollBackOlapForUnSubmit");
                DecpBillData decpBillData = this.getOrCacheDecpBillData(null);
                BgApplySplitUtil.getInstance().saveBillEditInfo(decpBillData.getBillId(), SplitStatus.SPLITING);
                decpBillData.setSplited(false);
            }
            catch (Throwable e) {
                tx.markRollback();
                log.info(this.getClass().getName() + "unSubmitBill:" + ThrowableHelper.toString((Throwable)e));
                throw e;
            }
        }
        this.updateModifyInfo();
        this.reloadEntityData();
        logHelper.addInfoLog("reloadEntityData");
        this.clearPreSplitRowStatus();
        this.updateFormBySubmitStatus(false);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f", (String)"BgApplySplitBillPlugin_19", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private void clearPreSplitRowStatus() {
        this.getOrCacheCurrentSplitRowId(new HashMap<String, Long>());
        this.getEntryInfoFromFormParam().getEntryTemplateConfig().keySet().forEach(entryKey -> {
            if (this.isMainEntry((String)entryKey)) {
                this.updateSplitDimPathShow((String)entryKey, null);
            }
        });
    }

    private void rollBackDbForUnSubmit() {
        List toDelBillIDs = null;
        String nextBillNums = this.getPageCache().get("unSumbmitSplitBillIds");
        if (StringUtils.isNotEmpty((CharSequence)nextBillNums)) {
            this.getPageCache().remove("unSumbmitSplitBillIds");
            toDelBillIDs = SerializationUtils.fromJsonStringToList((String)nextBillNums, Long.class);
        }
        if (toDelBillIDs == null || toDelBillIDs.isEmpty()) {
            return;
        }
        Map<Long, String> tempIdMapEntry = this.getTempIdMapEntry();
        ApplyBillAggHelper billAggHelper = ApplyBillAggHelper.getInstance();
        Map<String, Map<Long, Map<String, Object>>> detailRowSplitData = this.getOrCacheDetailRowSplitData(null);
        DynamicObjectCollection billObjs = QueryServiceHelper.query((String)"eb_bgdecompose", (String)"id,billnumber,modifydate", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)toDelBillIDs)});
        this.checkModifyTimeBeforeUnSubmit(billObjs);
        HashMap<String, Set> toDelRowIds = new HashMap<String, Set>(16);
        HashMap<String, Map> allToUpdateVals = new HashMap<String, Map>(16);
        Long userId = UserUtils.getUserId();
        Long modelId = this.getModelId();
        Timestamp now = new Timestamp(TimeServiceHelper.now().getTime());
        List splitBillIds = billObjs.stream().map(billOjb -> billOjb.getLong("id")).collect(Collectors.toList());
        Map allSplitBillDatas = BgApplySplitUtil.getInstance().querySplitedRowDatas(splitBillIds, tempIdMapEntry);
        ArrayList<SplitLogObj> toSaveLogInfo = new ArrayList<SplitLogObj>(16);
        StringBuilder billIdNumsStr = new StringBuilder();
        for (Object billObj : billObjs) {
            Long l = billObj.getLong("id");
            Map splitRowDataMap = (Map)allSplitBillDatas.get(l);
            String currentBillNum = billObj.getString("billnumber");
            billIdNumsStr.append('(').append(l).append('-').append(currentBillNum).append(')');
            if (splitRowDataMap == null) continue;
            for (Map.Entry entry : splitRowDataMap.entrySet()) {
                String entryKey = (String)entry.getKey();
                DetailMembBillData sourceData = this.getSourceData(entryKey);
                Map sourceDataRowStatus = sourceData.getSourceDataRowStatus();
                if (sourceDataRowStatus == null || sourceDataRowStatus.isEmpty()) {
                    sourceData.initRowStatusByRowId();
                    sourceDataRowStatus = sourceData.getSourceDataRowStatus();
                }
                Map splitedData = (Map)entry.getValue();
                Map<Long, List<SplitedDataInfo>> splitRowData = this.changeSplitRowData(splitedData);
                EntryTemplateConfig tempConfig = this.getTempConfig(entryKey);
                BigDecimal unitData = this.getUnitData(tempConfig.getUnit());
                Set<String> splitColKeys = tempConfig.getSplitSubKeyMap().keySet();
                Set modifyKeys = tempConfig.getModifKeys();
                Map columnIndex = tempConfig.getColumnIndex();
                Map<Long, Map<String, Object>> detaiRowSubData = detailRowSplitData.get(entryKey);
                Map toUpdateVals = allToUpdateVals.computeIfAbsent(entryKey, key -> new HashMap(16));
                for (Map.Entry<Long, List<SplitedDataInfo>> splitRowEntry : splitRowData.entrySet()) {
                    Long rowId = splitRowEntry.getKey();
                    Map<String, Object> modifSplitData = this.selectAllModifSplitData(splitRowEntry.getValue(), (Set<String>)modifyKeys, true, true);
                    if (modifSplitData.isEmpty()) continue;
                    this.turnVal(modifSplitData);
                    RowDataStatus rowDataStatus = (RowDataStatus)sourceDataRowStatus.get(rowId);
                    if (rowDataStatus == null) continue;
                    Object[] rowData = (Object[])sourceData.getAllRowData().get(rowDataStatus.getRowIndex());
                    String billNumber = billAggHelper.getBillNumberOnRow(rowData);
                    if (currentBillNum.equals(billNumber)) {
                        toDelRowIds.computeIfAbsent(entryKey, key -> new HashSet(16)).add(rowId);
                        toSaveLogInfo.add(new SplitLogObj("US_D", currentBillNum, tempConfig.getNumber(), null, rowId, userId, now, modelId));
                        continue;
                    }
                    this.updateUnit(rowData, unitData, tempConfig.getCurrencyColumnKeys(), columnIndex, false);
                    if (billAggHelper.isDetailRow(rowData) && detaiRowSubData != null) {
                        this.setSubDataToRowData(rowData, detaiRowSubData.get(rowId), splitColKeys, columnIndex);
                    }
                    ApplyBillPluginUitl.rollBackVal((Object[])rowData, (Map)tempConfig.getColumnIndex(), modifSplitData);
                    toSaveLogInfo.add(new SplitLogObj("US_U", currentBillNum, tempConfig.getNumber(), modifSplitData, rowId, userId, now, modelId));
                    ApplyBillPluginUitl.selectToUpdateVal(modifSplitData, (String)tempConfig.getEntryTable(), (Long)userId, (Timestamp)now, (Long)rowId, (Map)toUpdateVals);
                }
            }
        }
        DBRoute route = new DBRoute("epm");
        if (toDelBillIDs.size() > 0) {
            DeleteServiceHelper.delete((String)"eb_splitedrowdata", (QFilter[])new QFilter[]{new QFilter("splitbillid", "in", (Object)toDelBillIDs)});
            DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"eb_bgdecompose"), (Object[])toDelBillIDs.toArray());
        }
        if (toDelRowIds.size() > 0) {
            for (Map.Entry entry : toDelRowIds.entrySet()) {
                String entryKey = (String)entry.getKey();
                Set rowIds = (Set)entry.getValue();
                if (rowIds == null || rowIds.size() <= 0) continue;
                EntryTemplateConfig tempConfig = this.getTempConfig(entryKey);
                String sql = "delete from %s where fentryid in (%s)";
                this.executeOrBatch(route, String.format(sql, tempConfig.getEntryTable(), SqlBatchUtils.getBatchParamsSql((int)rowIds.size())), Collections.singletonList(rowIds.toArray()), false);
            }
        }
        if (allToUpdateVals.size() > 0) {
            for (Map.Entry entry : allToUpdateVals.entrySet()) {
                Map toUpdateVals = (Map)entry.getValue();
                if (toUpdateVals == null || toUpdateVals.size() <= 0) continue;
                for (Map.Entry toUpVal : toUpdateVals.entrySet()) {
                    this.executeOrBatch(route, (String)toUpVal.getKey(), (List)toUpVal.getValue(), true);
                }
            }
        }
        if (!toSaveLogInfo.isEmpty()) {
            ArrayList toSaveVals = new ArrayList(toSaveLogInfo.size());
            toSaveLogInfo.forEach(log -> toSaveVals.add(log.getSaveObj()));
            String string = "insert into t_eb_splitmodifylog(fid,fbillnumber,ftempnumber,flogtext,fmodifyrowid,fcreator,fcreatedate,fmodelid) values(?,?,?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)route, (String)string, toSaveVals);
        }
        CommonServiceHelper.handleLog((Log)this.getLog(), (String)("UnSubmitSplitBill:" + this.getBillNumber()), (String)billIdNumsStr.toString());
    }

    private void executeOrBatch(DBRoute route, String sql, List<Object[]> paramsList, boolean isBatch) {
        if (isBatch) {
            DB.executeBatch((DBRoute)route, (String)sql, paramsList);
        } else {
            DB.execute((DBRoute)route, (String)sql, (Object[])paramsList.get(0));
        }
    }

    private void checkModifyTimeBeforeUnSubmit(DynamicObjectCollection billObjs) {
        Date openTime;
        if (billObjs.isEmpty()) {
            return;
        }
        Date modifyTime = (Date)this.getValue("modifydate", null);
        Date newTime = modifyTime.compareTo(openTime = this.getOrCacheOpenTime(null)) > 0 ? modifyTime : openTime;
        for (DynamicObject object : billObjs) {
            Date modifydate = object.getDate("modifydate");
            if (modifydate.compareTo(newTime) <= 0) continue;
            throw new KDBizException(ResManager.loadResFormat((String)"\u4e0b\u6e38\u5355\u636e(%1)\u4e8e(%2)\u53d1\u751f\u4fee\u6539,\u8bf7\u9000\u51fa\u91cd\u8fdb\u5f53\u524d\u5355\u636e\u518d\u8fdb\u884c\u64a4\u9500\u3002", (String)"BgApplySplitBillPlugin_20", (String)"epm-eb-formplugin", (Object[])new Object[]{object.getString("billnumber"), modifydate}));
        }
    }

    private void rollBackOlapForUnSubmit() {
        Map<String, List<AuditRecordObj>> toSaveOlap = this.select4SaveOlapData(true);
        BillSaveEventArgs eventArgs = new BillSaveEventArgs();
        eventArgs.setBlendedSaveOlap(true);
        eventArgs.setAllChangeRecord(toSaveOlap);
        this.saveAllTemplateDataToOlap(eventArgs);
    }

    private void setSubDataToRowData(Object[] rowData, Map<String, Object> subData, Set<String> splitColKeys, Map<String, Integer> columnIndex) {
        for (String key : splitColKeys) {
            BigDecimal subVal;
            BigDecimal bigDecimal = subVal = subData == null ? this.getZero() : (BigDecimal)subData.get(key);
            if (subVal == null) {
                subVal = this.getZero();
            }
            rowData[columnIndex.get((Object)key).intValue()] = subVal;
        }
    }

    private void turnVal(Map<String, Object> modifSplitData) {
        for (Map.Entry<String, Object> entry : modifSplitData.entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            if (val == null) continue;
            if (val instanceof BigDecimal) {
                modifSplitData.put(key, BigDecimal.ZERO.subtract((BigDecimal)val));
                continue;
            }
            if (!(val instanceof Integer)) continue;
            modifSplitData.put(key, 0 - (Integer)val);
        }
    }

    private void autoSplit() {
        String currentMainEntryKey = this.getCurrentEntityKey();
        Map<Long, SplitRowData> splitRowInfo = this.getOrCacheSplitRowInfo(null, currentMainEntryKey);
        Long currentSplitRowId = this.getCurrentSplitRowId(currentMainEntryKey);
        SplitRowData currentSplitRowData = splitRowInfo.get(currentSplitRowId);
        String currentSplitDim = currentSplitRowData.getCurrentSplitDim();
        String preSplitDim = currentSplitRowData.getPreSplitDim(currentSplitDim);
        HashMap<Long, SplitedDataInfo> splitedDataInfoMap = (HashMap<Long, SplitedDataInfo>)currentSplitRowData.getSplitedRows().get(currentSplitDim);
        HashMap<Long, SplitedDataInfo> preDimSplitedRowData = (HashMap<Long, SplitedDataInfo>)currentSplitRowData.getSplitedRows().get(preSplitDim);
        if (preDimSplitedRowData == null) {
            preDimSplitedRowData = new HashMap<Long, SplitedDataInfo>();
            preDimSplitedRowData.put(currentSplitRowId, currentSplitRowData.getSplitedData());
        }
        if (splitedDataInfoMap != null) {
            this.clearSplitDataOnDim(splitedDataInfoMap, currentSplitRowId, currentMainEntryKey, preDimSplitedRowData, true, false);
        } else {
            splitedDataInfoMap = new HashMap<Long, SplitedDataInfo>(16);
            currentSplitRowData.getSplitedRows().put(currentSplitDim, splitedDataInfoMap);
        }
        EntryTemplateConfig tempConfig = this.getTempConfig(currentMainEntryKey);
        ApplyBillEntityData currentNodeData = this.getCurrentNodeData(currentMainEntryKey);
        DetailMembBillData sourceData = this.getSourceData(currentMainEntryKey);
        Map<Long, Map<String, DimMember>> parentRowDimMembMap = this.getEntryParentRowDimMembMap(preDimSplitedRowData.keySet(), currentNodeData, tempConfig);
        Map<Long, Map<Long, List<DimMember>>> detailRowDimMemb = this.selectDetailRowDimMemb(parentRowDimMembMap, sourceData, tempConfig);
        Map<Long, Map<String, Object>> olapData = this.readOlapData(detailRowDimMemb, tempConfig);
        Map<Long, List<BillRow>> splitTargetRows = this.createSplitTargetRows(detailRowDimMemb, parentRowDimMembMap, sourceData, tempConfig, olapData, currentSplitDim, tempConfig.getSplitSubKeyMap().keySet(), currentSplitRowId);
        this.updateNewRowToSourceData(splitTargetRows, tempConfig, sourceData, splitedDataInfoMap, preDimSplitedRowData, parentRowDimMembMap, currentMainEntryKey, currentSplitRowId);
        this.updateSplitResultEntryData(currentMainEntryKey, this.getSplitEntryKey(currentMainEntryKey), currentSplitRowId, splitRowInfo, null, currentSplitDim);
        if (StringUtils.isEmpty((CharSequence)preSplitDim)) {
            this.updatePreEntryAfterSave(Collections.singleton(currentSplitRowId), Collections.singleton(currentMainEntryKey));
        }
        this.getOrCacheSplitRowInfo(splitRowInfo, currentMainEntryKey);
        this.cacheSourceData(currentMainEntryKey);
    }

    private Map<Long, DimMember> getDetailOrgMapSplitOrg(Map<Long, Map<Long, List<DimMember>>> detailRowDimMemb, EntryTemplateConfig templateConfig, String currentSplitDim, IModelCacheHelper modelCacheHelper) {
        HashMap<Long, DimMember> result = new HashMap<Long, DimMember>(16);
        int index = templateConfig.getDimKeysList().indexOf(currentSplitDim);
        String dimNum = (String)templateConfig.selectColumnMapDimNum().get(currentSplitDim);
        Long viewId = modelCacheHelper.getViewByDataSetAndDimNumber(Long.valueOf(templateConfig.getDatasetId()), dimNum);
        Set nextStepDecpOrgIds = this.getOrCacheDecpBillData(null).getNextStepDecpOrgIds();
        detailRowDimMemb.values().forEach(rowMap -> rowMap.values().forEach(rowDimMemb -> {
            DimMember entityMemb = (DimMember)rowDimMemb.get(index);
            if (!result.containsKey(entityMemb.getMembId())) {
                if (nextStepDecpOrgIds != null && !nextStepDecpOrgIds.isEmpty()) {
                    Member member = modelCacheHelper.getMember(dimNum, viewId, entityMemb.getMembId());
                    List parents = modelCacheHelper.getParents(viewId, member, true);
                    if (parents != null) {
                        for (Member m : parents) {
                            if (!nextStepDecpOrgIds.contains(m.getId())) continue;
                            result.put(entityMemb.getMembId(), new DimMember(m.getId(), m.getNumber(), m.getLongNumber(), m.isLeaf()));
                            break;
                        }
                    }
                } else {
                    result.put(entityMemb.getMembId(), new DimMember(entityMemb.getMembId(), entityMemb.getNumber(), entityMemb.getLongNumber(), entityMemb.isLeaf()));
                }
            }
        }));
        return result;
    }

    private void updateNewRowToSourceData(Map<Long, List<BillRow>> splitTargetRows, EntryTemplateConfig templateConfig, DetailMembBillData sourceData, Map<Long, SplitedDataInfo> splitedDataInfoMap, Map<Long, SplitedDataInfo> preDimSplitedRowData, Map<Long, Map<String, DimMember>> parentRowDimMembMap, String currentMainEntryKey, Long currentPreSplitRowId) {
        StringBuilder sb = new StringBuilder();
        if (sourceData.getAllRowData().isEmpty()) {
            return;
        }
        int rowValLength = ((Object[])sourceData.getAllRowData().get(0)).length;
        List dimKeysList = templateConfig.getDimKeysList();
        Map columnIndex = templateConfig.getColumnIndex();
        Set<String> splitColKeys = templateConfig.getSplitSubKeyMap().keySet();
        ApplyBillAggHelper billAggHelper = ApplyBillAggHelper.getInstance();
        Map<Long, Map<Long, Set<String>>> splitedRowColKeys = this.getOrCacheSplitedRowColKeys(null, currentMainEntryKey);
        for (Map.Entry<Long, List<BillRow>> rowEntry : splitTargetRows.entrySet()) {
            Long preSplitRowId = rowEntry.getKey();
            Map<String, DimMember> dimMemberMap = parentRowDimMembMap.get(preSplitRowId);
            Map<String, Object> splitedData = this.selectRowDataAndClean(dimMemberMap, dimKeysList, splitColKeys, columnIndex, sourceData, true);
            SplitedDataInfo preSpliteDataInfo = preDimSplitedRowData.get(preSplitRowId);
            this.mergeCellVal(preSpliteDataInfo, splitedData, splitColKeys, true);
            List<BillRow> newRows = rowEntry.getValue();
            for (BillRow row : newRows) {
                Object[] rowObj;
                sb.setLength(0);
                for (String col : dimKeysList) {
                    DimMember member = (DimMember)row.getRowDimMembInfo().get(col);
                    sb.append(member.getMembId()).append(',');
                }
                sb.deleteCharAt(sb.length() - 1);
                RowDataStatus rowDataStatus = (RowDataStatus)sourceData.getDetailRowStatus().get(sb.toString());
                if (rowDataStatus != null) {
                    rowObj = (Object[])sourceData.getAllRowData().get(rowDataStatus.getRowIndex());
                } else {
                    rowObj = new Object[rowValLength];
                    boolean leaf = true;
                    for (String key2 : templateConfig.getDimKeysList()) {
                        DimMember member = (DimMember)row.getRowDimMembInfo().get(key2);
                        Integer index = (Integer)columnIndex.get(key2);
                        rowObj[index.intValue()] = member.getMembId();
                        if (member.isLeaf()) continue;
                        leaf = false;
                    }
                    this.addNewRow(rowObj, null, leaf, sourceData, sb.toString());
                }
                Map shareVals = row.getColVals();
                this.mergeRowVal(rowObj, shareVals, columnIndex, splitColKeys);
                Long newRowId = billAggHelper.getRowId(rowObj);
                Map changedColKeys = splitedRowColKeys.computeIfAbsent(newRowId, key -> new HashMap(16));
                Set mdyColKeys = changedColKeys.computeIfAbsent(currentPreSplitRowId, key -> new HashSet(16));
                mdyColKeys.addAll(splitColKeys);
                SplitedDataInfo splitedDataInfo = splitedDataInfoMap.computeIfAbsent(newRowId, key -> new SplitedDataInfo());
                this.mergeCellVal(splitedDataInfo, shareVals, splitColKeys, false);
            }
        }
        this.getOrCacheSplitedRowColKeys(splitedRowColKeys, currentMainEntryKey);
    }

    private void mergeRowVal(Object[] rowObj, Map<String, Object> sourceVals, Map<String, Integer> columnIndex, Set<String> keys) {
        for (String key : keys) {
            BigDecimal sVal;
            int index = columnIndex.get(key);
            BigDecimal val = (BigDecimal)rowObj[index];
            if (val == null) {
                val = this.getZero();
            }
            if ((sVal = (BigDecimal)sourceVals.get(key)) == null) {
                sVal = this.getZero();
            }
            rowObj[index] = val.add(sVal);
        }
    }

    private void mergeCellVal(SplitedDataInfo splitedDataInfo, Map<String, Object> sourceVals, Set<String> keys, boolean isSub) {
        for (String key : keys) {
            CellValueObj cellValueObj;
            Object currentVal;
            BigDecimal sVal = (BigDecimal)sourceVals.get(key);
            if (sVal == null) {
                sVal = this.getZero();
            }
            if ((currentVal = (cellValueObj = splitedDataInfo.getNotSaveData().computeIfAbsent(key, k -> new CellValueObj())).getCurrentVal()) == null) {
                currentVal = this.getZero();
            }
            if (isSub) {
                cellValueObj.setCurrentVal((Object)((BigDecimal)currentVal).subtract(sVal));
                continue;
            }
            cellValueObj.setCurrentVal((Object)sVal.add((BigDecimal)currentVal));
        }
    }

    private Map<Long, List<BillRow>> createSplitTargetRows(Map<Long, Map<Long, List<DimMember>>> detailRowDimMemb, Map<Long, Map<String, DimMember>> entryParentRowMap, DetailMembBillData sourceData, EntryTemplateConfig templateConfig, Map<Long, Map<String, Object>> allRateData, String currentSplitDim, Set<String> splitKeys, Long currentSplitRowId) {
        HashMap<Long, List<BillRow>> result = new HashMap<Long, List<BillRow>>(16);
        int index = templateConfig.getDimKeysList().indexOf(currentSplitDim);
        HashMap<Long, DimMember> detailOrgMapSplitOrg = new HashMap<Long, DimMember>(16);
        Map<Long, NewRowInfo> allNewRowInfo = this.getOrCacheAllNewRowInfo(null);
        boolean isEntityDim = currentSplitDim.equals(templateConfig.getOrgColumnKey());
        HashMap detailOrgOfSplitOrg = new HashMap(16);
        if (isEntityDim) {
            detailOrgMapSplitOrg.putAll(this.getDetailOrgMapSplitOrg(detailRowDimMemb, templateConfig, currentSplitDim, this.getModelCacheHelper()));
            detailOrgMapSplitOrg.forEach((detailOrgId, splitOrg) -> {
                Set detailOrgIds = detailOrgOfSplitOrg.computeIfAbsent(splitOrg.getMembId(), key -> new HashSet(16));
                detailOrgIds.add(detailOrgId);
            });
        }
        entryParentRowMap.forEach((parentRowId, dimMembInfo) -> {
            HashMap total = new HashMap(16);
            HashMap allTargetRow = new HashMap(16);
            Map detailRowInfo = (Map)detailRowDimMemb.get(parentRowId);
            HashMap mainMembMapRowIds = new HashMap(16);
            HashSet newRowIds = new HashSet(16);
            detailRowInfo.forEach((rowId, rowDimMembs) -> {
                DimMember mainMemb = (DimMember)rowDimMembs.get(index);
                Set rowIds = mainMembMapRowIds.computeIfAbsent(mainMemb.getMembId(), key -> new HashSet());
                rowIds.add(rowId);
                if (allNewRowInfo.containsKey(rowId)) {
                    newRowIds.add(rowId);
                }
            });
            Map<String, Object> toSplitData = this.selectRowDataAndClean((Map<String, DimMember>)dimMembInfo, templateConfig.getDimKeysList(), splitKeys, templateConfig.getColumnIndex(), sourceData, false);
            HashSet pastMembIds = new HashSet(16);
            detailRowInfo.forEach((rowId, rowDimMemb) -> {
                Map rateData = (Map)allRateData.get(rowId);
                DimMember mainMemb = (DimMember)rowDimMemb.get(index);
                if (isEntityDim) {
                    mainMemb = (DimMember)detailOrgMapSplitOrg.get(mainMemb.getMembId());
                }
                if (mainMemb != null && !pastMembIds.contains(mainMemb.getMembId())) {
                    BillRow billRow = (BillRow)allTargetRow.get(mainMemb.getMembId());
                    if (billRow == null) {
                        HashMap<Object, DimMember> rowDimMembs = new HashMap<Object, DimMember>(16);
                        for (Map.Entry entry : dimMembInfo.entrySet()) {
                            String colKey = (String)entry.getKey();
                            DimMember member = (DimMember)entry.getValue();
                            if (colKey.equals(currentSplitDim)) {
                                rowDimMembs.put(colKey, mainMemb.cloneObj());
                                continue;
                            }
                            rowDimMembs.put(colKey, member.cloneObj());
                        }
                        boolean past = false;
                        if (newRowIds.size() > 0) {
                            StringBuilder sb = new StringBuilder();
                            for (String dimKey : templateConfig.getDimKeysList()) {
                                DimMember member = (DimMember)rowDimMembs.get(dimKey);
                                sb.append(member.getMembId()).append(',');
                            }
                            sb.deleteCharAt(sb.length() - 1);
                            String rowDimMembStr = sb.toString();
                            RowDataStatus rowDataStatus = (RowDataStatus)sourceData.getDetailRowStatus().get(rowDimMembStr);
                            if (rowDataStatus != null) {
                                if (rowDataStatus.isDetail()) {
                                    Object[] rowData = (Object[])sourceData.getAllRowData().get(rowDataStatus.getRowIndex());
                                    Long rowId1 = ApplyBillAggHelper.getInstance().getRowId(rowData);
                                    NewRowInfo newRowInfo = (NewRowInfo)allNewRowInfo.get(rowId1);
                                    if (newRowInfo != null && !parentRowId.equals(newRowInfo.getRefLevelOneSplitRowId())) {
                                        past = true;
                                    }
                                }
                            } else if (isEntityDim) {
                                Set detailChildIds = (Set)detailOrgOfSplitOrg.get(mainMemb.getMembId());
                                boolean orgPast = true;
                                for (Long membId : detailChildIds) {
                                    Set refRowIds = (Set)mainMembMapRowIds.get(membId);
                                    if (refRowIds == null || newRowIds.containsAll(refRowIds)) continue;
                                    orgPast = false;
                                    break;
                                }
                                past = orgPast;
                            } else {
                                Set refRowIds = (Set)mainMembMapRowIds.get(mainMemb.getMembId());
                                if (newRowIds.containsAll(refRowIds)) {
                                    past = true;
                                }
                            }
                        }
                        if (!past) {
                            billRow = new BillRow();
                            billRow.setRowDimMembInfo(rowDimMembs);
                            allTargetRow.put(mainMemb.getMembId(), billRow);
                        } else {
                            pastMembIds.add(mainMemb.getMembId());
                        }
                    }
                    if (billRow != null) {
                        this.mergeVal(billRow.getColVals(), rateData, splitKeys, true, false);
                        this.mergeVal(total, rateData, splitKeys, true, false);
                    }
                }
            });
            HashMap<String, Object> allLastVal = new HashMap<String, Object>(16);
            allLastVal.putAll(toSplitData);
            for (String key : splitKeys) {
                BigDecimal sumVal = (BigDecimal)total.get(key);
                BigDecimal toSplitVal = (BigDecimal)toSplitData.get(key);
                if (sumVal.compareTo(BigDecimal.ZERO) == 0) {
                    if (allTargetRow.size() <= 0) continue;
                    BillRow firstRow = (BillRow)allTargetRow.values().iterator().next();
                    firstRow.getColVals().put(key, toSplitVal);
                    continue;
                }
                Count count = new Count(allTargetRow.size());
                allTargetRow.values().forEach(billRow -> {
                    Map calcVals = billRow.getColVals();
                    BigDecimal calcDataVal = (BigDecimal)calcVals.get(key);
                    BigDecimal lastVal = (BigDecimal)allLastVal.get(key);
                    BigDecimal targetVal = null;
                    if (count.getCount() == 1) {
                        targetVal = lastVal;
                    } else {
                        targetVal = calcDataVal.divide(sumVal, 10, RoundingMode.HALF_UP).multiply(toSplitVal).setScale(2, RoundingMode.HALF_UP);
                        lastVal = lastVal.subtract(targetVal);
                        allLastVal.put(key, lastVal);
                    }
                    calcVals.put(key, targetVal);
                    count.subOne();
                });
            }
            result.put((Long)parentRowId, new ArrayList(allTargetRow.values()));
        });
        return result;
    }

    private Map<String, Object> selectRowDataAndClean(Map<String, DimMember> dimMemberMap, List<String> dimKeys, Set<String> splitKeys, Map<String, Integer> colIndex, DetailMembBillData sourceData, boolean clean) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        StringBuilder sb = new StringBuilder();
        for (String key : dimKeys) {
            DimMember member = dimMemberMap.get(key);
            sb.append(member.getMembId()).append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        RowDataStatus rowDataStatus = (RowDataStatus)sourceData.getDetailRowStatus().get(sb.toString());
        if (rowDataStatus != null) {
            Object[] rowData = (Object[])sourceData.getAllRowData().get(rowDataStatus.getRowIndex());
            for (String key : splitKeys) {
                result.put(key, (BigDecimal)rowData[colIndex.get(key)]);
                if (!clean) continue;
                rowData[colIndex.get((Object)key).intValue()] = this.getZero();
            }
        }
        return result;
    }

    private void mergeVal(Map<String, Object> target, Map<String, Object> source, Set<String> keys, boolean needAbsolute, boolean isSub) {
        if (source != null) {
            for (String key : keys) {
                target.put(key, this.mergeVal(target.get(key), source.get(key), needAbsolute, isSub));
            }
        }
    }

    private Object mergeVal(Object targetVal, Object sourceVal, boolean needAbsolute, boolean isSub) {
        BigDecimal sVal;
        BigDecimal tVal = (BigDecimal)targetVal;
        if (tVal == null) {
            tVal = this.getZero();
        }
        if (needAbsolute) {
            tVal = tVal.abs();
        }
        if ((sVal = (BigDecimal)sourceVal) == null) {
            sVal = this.getZero();
        }
        tVal = isSub ? tVal.subtract(sVal) : tVal.add(sVal);
        return tVal;
    }

    private Map<Long, Map<String, Object>> readOlapData(Map<Long, Map<Long, List<DimMember>>> detailRowDimMemb, EntryTemplateConfig templateConfig) {
        BgApplyBillUtils applyBillUtils = BgApplyBillUtils.getInstance();
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        Set<String> splitColKeys = templateConfig.getSplitSubKeyMap().keySet();
        List splitCols = templateConfig.getEntryColumns().stream().filter(col -> splitColKeys.contains(col.getKey())).collect(Collectors.toList());
        Map colDimMembers = applyBillUtils.getAllColDimMembers(splitCols, Long.valueOf(templateConfig.getDatasetId()), modelCacheHelper, Boolean.valueOf(true));
        Map<String, String> splitColMapRateAtMemb = this.getSplitColMapRateAtMemb(splitColKeys, templateConfig.getTemplateID());
        Map hideDimMembers = applyBillUtils.getHideDimMembersFromTempConfig(modelCacheHelper, templateConfig);
        HashMap dimMembGroup = new HashMap(16);
        applyBillUtils.mergeMap(hideDimMembers, dimMembGroup);
        colDimMembers.values().forEach(colMembs -> applyBillUtils.mergeMap(colMembs, dimMembGroup));
        List rowDimNums = templateConfig.getRowDimNums();
        int dimCount = rowDimNums.size();
        detailRowDimMemb.forEach((parentRowId, allChildRow) -> allChildRow.forEach((rowId, rowDimMembs) -> {
            for (int i = 0; i < dimCount; ++i) {
                String dimNum = (String)rowDimNums.get(i);
                Set membNums = dimMembGroup.computeIfAbsent(dimNum, key -> new HashSet(16));
                membNums.add(((DimMember)rowDimMembs.get(i)).getNumber());
            }
        }));
        if (CollectionUtils.isEmpty(splitColMapRateAtMemb)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u7ef4\u62a4\u6c47\u603b\u6570\u636e\u5411\u4e0b\u62c6\u5206\u7684\u7ebf\u7d22\u6210\u5458\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BgApplySplitBillPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        ((Set)dimMembGroup.get(SysDimensionEnum.AuditTrail.getNumber())).clear();
        ((Set)dimMembGroup.get(SysDimensionEnum.AuditTrail.getNumber())).addAll(splitColMapRateAtMemb.values());
        Map olapData = BgApplyBillUtils.getInstance().queryOlapData(modelCacheHelper, this.getModelId(), Long.valueOf(templateConfig.getDatasetId()), dimMembGroup, true, templateConfig.getTemplateID());
        List dimensionList = modelCacheHelper.getDimensionList(Long.valueOf(templateConfig.getDatasetId()));
        HashMap<Long, Map<String, Object>> allRateData = new HashMap<Long, Map<String, Object>>(16);
        detailRowDimMemb.forEach((parentRowId, allChildRow) -> allChildRow.forEach((rowId, rowDimMembs) -> {
            HashMap<String, String> dimMembNums = new HashMap<String, String>(16);
            for (int i = 0; i < dimCount; ++i) {
                String dimNum = (String)rowDimNums.get(i);
                dimMembNums.put(dimNum, ((DimMember)rowDimMembs.get(i)).getNumber());
            }
            dimMembNums.putAll(hideDimMembers);
            HashMap rateData = new HashMap(splitColKeys.size());
            for (String splitCol : splitColKeys) {
                Map colDimMembs = (Map)colDimMembers.get(splitCol);
                dimMembNums.putAll(colDimMembs);
                dimMembNums.put(SysDimensionEnum.AuditTrail.getNumber(), (String)splitColMapRateAtMemb.get(splitCol));
                MembersKey membersKey = BgApplyBillUtils.getInstance().getMembersKey(dimMembNums, dimensionList);
                rateData.put(splitCol, olapData.get(membersKey));
            }
            allRateData.put((Long)rowId, rateData);
        }));
        return allRateData;
    }

    private Map<String, String> getSplitColMapRateAtMemb(Set<String> splitColKeys, Long tempId) {
        HashSet<Long> templateIds = new HashSet<Long>(1);
        templateIds.add(tempId);
        FormTypeEnum byBillType = ApplyTemplateColCfgService.getInstance().getFormTypeEnumByBillType(this.getBillType());
        Map auditTrailAllCfg = ApplyTemplateColCfgService.getInstance().queryColAuditTrailAllCfgByTemplateId(templateIds, byBillType);
        Map cfgEntityMap = (Map)auditTrailAllCfg.get(tempId);
        HashMap<String, String> splitColMapRateAtMemb = new HashMap<String, String>(16);
        for (String splitCol : splitColKeys) {
            splitColMapRateAtMemb.put(splitCol, ((ApplyTemplateAtAllCfgEntity)cfgEntityMap.get(splitCol)).getRatioMembNum());
        }
        return splitColMapRateAtMemb;
    }

    private Map<Long, Map<Long, List<DimMember>>> selectDetailRowDimMemb(Map<Long, Map<String, DimMember>> entryParentRowMap, DetailMembBillData sourceData, EntryTemplateConfig templateConfig) {
        HashMap<Long, Map<Long, List<DimMember>>> result = new HashMap<Long, Map<Long, List<DimMember>>>(16);
        ApplyBillAggHelper billAggHelper = ApplyBillAggHelper.getInstance();
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        Map viewIds = modelCacheHelper.getViewsByDataSet(Long.valueOf(templateConfig.getDatasetId()));
        Map dimColMapDimNum = templateConfig.selectColumnMapDimNum();
        List dimKeysList = templateConfig.getDimKeysList();
        Map columnIndex = templateConfig.getColumnIndex();
        for (Map.Entry<Long, Map<String, DimMember>> entry : entryParentRowMap.entrySet()) {
            Long parentRowId = entry.getKey();
            HashMap detailChildRowMembNums = new HashMap(16);
            Map<String, String> members = entry.getValue().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((DimMember)e.getValue()).getNumber()));
            Map detailChildMemb = billAggHelper.getDetailChildMemb(members, modelCacheHelper, viewIds, templateConfig);
            for (Object[] rowData : sourceData.getAllRowData()) {
                boolean match;
                if (!billAggHelper.isDetailRow(rowData) || !(match = billAggHelper.matchChildRow(dimKeysList, columnIndex, detailChildMemb, rowData))) continue;
                ArrayList<DimMember> rowDimMembs = new ArrayList<DimMember>(dimKeysList.size());
                for (String dimColKey : dimKeysList) {
                    Long membId = (Long)rowData[(Integer)columnIndex.get(dimColKey)];
                    String dimNum = (String)dimColMapDimNum.get(dimColKey);
                    Member member = modelCacheHelper.getMember(dimNum, (Long)viewIds.get(dimNum), membId);
                    DimMember dimMember = new DimMember(membId, member.getNumber(), member.getLongNumber(), member.isLeaf());
                    rowDimMembs.add(dimMember);
                }
                detailChildRowMembNums.put(billAggHelper.getRowId(rowData), rowDimMembs);
            }
            result.put(parentRowId, detailChildRowMembNums);
        }
        return result;
    }

    private void clearSplitDataOnDim(Map<Long, SplitedDataInfo> splitedDataInfoMap, Long currentSplitRowId, String currentMainEntryKey, Map<Long, SplitedDataInfo> preDimSplitedRowData, boolean reWriteNoSaveData, boolean cleanNewRow) {
        EntryTemplateConfig tempConfig = this.getTempConfig(currentMainEntryKey);
        ArrayList<Integer> deledRowIndexOnSource = new ArrayList<Integer>(16);
        if (splitedDataInfoMap.size() > 0) {
            Map<Long, Map<Long, Set<String>>> splitedRowColKeys = this.getOrCacheSplitedRowColKeys(null, currentMainEntryKey);
            ApplyBillEntityData currentNodeData = this.getCurrentNodeData(currentMainEntryKey);
            Map<Long, Map<String, String>> entryParentRowMap = this.getEntryParentRowMap(preDimSplitedRowData.keySet(), currentNodeData, tempConfig, true);
            DetailMembBillData sourceData = this.getSourceData(currentMainEntryKey);
            ApplyBillAggHelper billAggHelper = ApplyBillAggHelper.getInstance();
            Map columnIndex = tempConfig.getColumnIndex();
            HashMap<Long, Map<String, Object>> totalBackData = new HashMap<Long, Map<String, Object>>(16);
            HashMap<Long, Integer> parentRowIndex = new HashMap<Long, Integer>(16);
            IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
            Map dimNumMapViewIds = modelCacheHelper.getViewsByDataSet(Long.valueOf(tempConfig.getDatasetId()));
            Map columnMapDimNum = tempConfig.selectColumnMapDimNum();
            int seq = 0;
            Map<Long, NewRowInfo> allNewRowIds = this.getOrCacheAllNewRowInfo(null);
            for (Object[] rowData : sourceData.getAllRowData()) {
                Long rowId = billAggHelper.getRowId(rowData);
                SplitedDataInfo rowDataInfo = splitedDataInfoMap.get(rowId);
                if (rowDataInfo != null) {
                    Map<Long, Set<String>> changedKeysOnPreSplitRow;
                    NewRowInfo newRowInfo;
                    Map<String, String> longNums = this.getRowDimMembLongNums(tempConfig.getDimKeysList(), columnIndex, rowData, modelCacheHelper, columnMapDimNum, dimNumMapViewIds);
                    Long parentRowId = this.getMatchParentRow(entryParentRowMap, longNums);
                    Map allBackData = totalBackData.computeIfAbsent(parentRowId, key -> new HashMap(16));
                    this.mergeCellData(rowDataInfo.getNotSaveData(), allBackData, rowData, columnIndex);
                    this.mergeCellData(rowDataInfo.getHadSaveData(), allBackData, rowData, columnIndex);
                    if (reWriteNoSaveData) {
                        this.reWriteHadSaveData(rowDataInfo);
                    }
                    if (cleanNewRow && (newRowInfo = allNewRowIds.get(rowId)) != null) {
                        if (newRowInfo.getStatus() == NewRowStatusEnum.EDIT) {
                            newRowInfo.setStatus(NewRowStatusEnum.DELETED);
                        } else if (newRowInfo.getStatus() == NewRowStatusEnum.NEW) {
                            allNewRowIds.remove(rowId);
                        }
                        deledRowIndexOnSource.add(seq);
                    }
                    if ((changedKeysOnPreSplitRow = splitedRowColKeys.get(rowId)) != null) {
                        changedKeysOnPreSplitRow.remove(currentSplitRowId);
                    }
                }
                if (entryParentRowMap.containsKey(rowId)) {
                    parentRowIndex.put(rowId, seq);
                }
                ++seq;
            }
            this.addBackValToParentRow(totalBackData, parentRowIndex, sourceData, columnIndex, preDimSplitedRowData);
            this.cleanNewRowInfoAfterRoll(deledRowIndexOnSource, sourceData, tempConfig);
            this.getOrCacheSplitedRowColKeys(splitedRowColKeys, currentMainEntryKey);
        }
        this.cleanNotEndNewRow(currentMainEntryKey, preDimSplitedRowData.keySet());
        this.cacheNewRowInfo();
    }

    private void cleanNotEndNewRow(String entryKey, Set<Long> preSplitRowIds) {
        Long currentSplitRowId = this.getCurrentSplitRowId(entryKey);
        if (currentSplitRowId == null) {
            return;
        }
        Map<Long, NewRowInfo> allNewRowInfo = this.getOrCacheAllNewRowInfo(null);
        Iterator<Map.Entry<Long, NewRowInfo>> iterator = allNewRowInfo.entrySet().iterator();
        while (iterator.hasNext()) {
            NewRowInfo rowInfo = iterator.next().getValue();
            Long preSplitRowId = rowInfo.getPreSplitRowId();
            Long refLevelOneSplitRowId = rowInfo.getRefLevelOneSplitRowId();
            if (!preSplitRowIds.contains(refLevelOneSplitRowId) || !currentSplitRowId.equals(preSplitRowId) || rowInfo.getRowDimMembIds() == null) continue;
            if (rowInfo.getStatus() == NewRowStatusEnum.EDIT) {
                rowInfo.setStatus(NewRowStatusEnum.DELETED);
                continue;
            }
            if (rowInfo.getStatus() != NewRowStatusEnum.NEW) continue;
            iterator.remove();
        }
    }

    private void cleanNewRowInfoAfterRoll(List<Integer> deledRowIndexOnSource, DetailMembBillData sourceData, EntryTemplateConfig tempConfig) {
        if (deledRowIndexOnSource.size() > 0) {
            Collections.sort(deledRowIndexOnSource);
            for (Integer index : deledRowIndexOnSource) {
                Object[] rowData2 = (Object[])sourceData.getAllRowData().get(index);
                sourceData.getAllRowData().set(index, null);
                String rowDimMembIdStr = ApplyBillAggHelper.getInstance().getRowDimMembIdStr(rowData2, tempConfig.getDimKeysList(), tempConfig.getColumnIndex());
                sourceData.getDetailRowStatus().remove(rowDimMembIdStr);
            }
            sourceData.getAllRowData().removeIf(rowData -> rowData == null);
            this.updateMembIdsMapIndex(sourceData, deledRowIndexOnSource);
        }
    }

    private void cacheNewRowInfo() {
        Map<Long, NewRowInfo> allNewRowInfo = this.getOrCacheAllNewRowInfo(null);
        this.getOrCacheAllNewRowInfo(allNewRowInfo);
    }

    private void reWriteHadSaveData(SplitedDataInfo rowDataInfo) {
        rowDataInfo.getNotSaveData().clear();
        for (Map.Entry entry : rowDataInfo.getHadSaveData().entrySet()) {
            Object currentVal;
            CellValueObj valueObj = (CellValueObj)entry.getValue();
            String key = (String)entry.getKey();
            if (valueObj == null || (currentVal = valueObj.getCurrentVal()) == null) continue;
            CellValueObj cellValueObj = new CellValueObj();
            if (currentVal instanceof BigDecimal) {
                cellValueObj.setCurrentVal(this.mergeVal(this.getZero(), valueObj.getCurrentVal(), false, true));
            } else {
                cellValueObj.setCurrentVal(valueObj.getPreModifVal());
                cellValueObj.setPreModifVal(null);
            }
            rowDataInfo.getNotSaveData().put(key, cellValueObj);
        }
    }

    private void rollbackALlData() {
        Map entryTemplateConfig = this.getEntryInfoFromFormParam().getEntryTemplateConfig();
        Map<Long, NewRowInfo> allNewRowInfo = this.getOrCacheAllNewRowInfo(null);
        HashMap<String, Set<Long>> newRowIdMapTempNum = new HashMap<String, Set<Long>>(entryTemplateConfig.size());
        allNewRowInfo.forEach((rowId, newRowInfo) -> {
            Set newRowIds = newRowIdMapTempNum.computeIfAbsent(newRowInfo.getTemplateNumber(), key -> new HashSet(16));
            newRowIds.add(rowId);
        });
        Map<String, Map<Long, Map<String, Object>>> rollBackSplitData = this.getOrCacheRollBackSplitData(null);
        this.rollBackAllSplitData(entryTemplateConfig, rollBackSplitData, newRowIdMapTempNum, allNewRowInfo);
        this.updateEntry4RollBackALl(entryTemplateConfig);
        this.updateCacheAfterRollBackAll(entryTemplateConfig, rollBackSplitData);
    }

    private void rollBackAllSplitData(Map<String, EntryTemplateConfig> entryTemplateConfig, Map<String, Map<Long, Map<String, Object>>> rollBackSplitData, Map<String, Set<Long>> newRowIdMapTempNum, Map<Long, NewRowInfo> allNewRowInfo) {
        for (Map.Entry<String, EntryTemplateConfig> configEntry : entryTemplateConfig.entrySet()) {
            String entryKey = configEntry.getKey();
            if (!this.isMainEntry(entryKey)) continue;
            DetailMembBillData sourceData = this.getSourceData(entryKey);
            sourceData.initRowStatusByRowId();
            EntryTemplateConfig templateConfig = configEntry.getValue();
            Map columnIndex = templateConfig.getColumnIndex();
            Map<Long, SplitRowData> preSplitRowInfo = this.getOrCacheSplitRowInfo(null, entryKey);
            preSplitRowInfo.forEach((preSplitRowId, splitRowInfo) -> {
                splitRowInfo.getSplitedRows().forEach((splitDim, rowsSplitedInfo) -> {
                    rowsSplitedInfo.forEach((rowId, splitedInfo) -> this.rollbackSplitData2Source(sourceData, (Long)rowId, (SplitedDataInfo)splitedInfo, columnIndex));
                    this.cacheRollBackSplitData((Map<Long, SplitedDataInfo>)rowsSplitedInfo, entryKey, rollBackSplitData);
                });
                this.rollbackSplitData2Source(sourceData, (Long)preSplitRowId, splitRowInfo.getSplitedData(), columnIndex);
                this.reWriteHadSaveData(splitRowInfo.getSplitedData());
                splitRowInfo.setCurrentSplitDim((String)splitRowInfo.getNotDetailDimColumn().get(0));
                splitRowInfo.setCurrentFocusSplitDim((String)splitRowInfo.getNotDetailDimColumn().get(0));
                splitRowInfo.getSplitedRows().clear();
            });
            Set<Long> newRowIds = newRowIdMapTempNum.get(templateConfig.getNumber());
            if (newRowIds == null) continue;
            ArrayList<Integer> toDelIndex = new ArrayList<Integer>(16);
            for (Long newRowId : newRowIds) {
                RowDataStatus dataStatus;
                NewRowInfo newRowInfo = allNewRowInfo.get(newRowId);
                if (newRowInfo.getStatus() == NewRowStatusEnum.NEW) {
                    allNewRowInfo.remove(newRowId);
                } else if (newRowInfo.getStatus() == NewRowStatusEnum.EDIT) {
                    newRowInfo.setStatus(NewRowStatusEnum.DELETED);
                }
                if ((dataStatus = (RowDataStatus)sourceData.getSourceDataRowStatus().remove(newRowId)) == null) continue;
                toDelIndex.add(dataStatus.getRowIndex());
            }
            if (toDelIndex.size() <= 0) continue;
            this.cleanNewRowInfoAfterRoll(toDelIndex, sourceData, templateConfig);
        }
    }

    private void updateCacheAfterRollBackAll(Map<String, EntryTemplateConfig> entryTemplateConfig, Map<String, Map<Long, Map<String, Object>>> rollBackSplitData) {
        entryTemplateConfig.keySet().forEach(entryKey -> {
            if (this.isMainEntry((String)entryKey)) {
                Map<Long, SplitRowData> preSplitRowInfo = this.getOrCacheSplitRowInfo(null, (String)entryKey);
                this.getOrCacheSplitedRowColKeys((Map<Long, Map<Long, Set<String>>>)new HashMap<Long, Map<Long, Set<String>>>(16), (String)entryKey);
                this.getOrCacheSplitRowInfo(preSplitRowInfo, (String)entryKey);
            }
        });
        this.getOrCacheRollBackSplitData(rollBackSplitData);
        this.getOrCacheCurrentSplitRowId(new HashMap<String, Long>(16));
        this.cacheAllBillEntityNodeData(true);
        this.cacheNewRowInfo();
        this.cacheAllSourceData();
    }

    private void updateEntry4RollBackALl(Map<String, EntryTemplateConfig> entryTemplateConfig) {
        for (Map.Entry<String, EntryTemplateConfig> configEntry : entryTemplateConfig.entrySet()) {
            String entryKey = configEntry.getKey();
            if (!this.isMainEntry(entryKey)) continue;
            DetailMembBillData sourceData = this.getSourceData(entryKey);
            EntryTemplateConfig templateConfig = configEntry.getValue();
            int entrySeq = this.getEntrySeqByMainEntryKey(entryKey);
            String splitEntryKey = this.getSplitEntryKey(entryKey);
            DynamicObjectCollection preSplitEntryDatas = this.getModel().getEntryEntity(splitEntryKey);
            if (preSplitEntryDatas.size() > 0) {
                StringBuilder sb = new StringBuilder();
                EntryTemplateConfig splitEntryConfig = this.getSplitEntryConfig(splitEntryKey);
                for (DynamicObject row : preSplitEntryDatas) {
                    String rowDimMembStr = ApplyBillPluginUitl.selectDimMembIdStr((StringBuilder)sb, (DynamicObject)row, (List)splitEntryConfig.getDimKeysList());
                    RowDataStatus rowDataStatus = (RowDataStatus)sourceData.getDetailRowStatus().get(rowDimMembStr);
                    if (rowDataStatus == null) continue;
                    Object[] rowData = (Object[])sourceData.getAllRowData().get(rowDataStatus.getRowIndex());
                    for (String splitKey : templateConfig.getSplitSubKeyMap().keySet()) {
                        String subKey = (String)templateConfig.getSplitSubKeyMap().get(splitKey);
                        Object subData = rowData[(Integer)templateConfig.getColumnIndex().get(splitKey)];
                        row.set(subKey.replace("h_", "s_"), subData);
                    }
                    row.set("s_splitstatus" + entrySeq, (Object)SplitStatus.NOTSPLIT.getName());
                }
            }
            this.getView().updateView(splitEntryKey);
            EntryGrid entryGrid = (EntryGrid)this.getControl(splitEntryKey);
            entryGrid.clearEntryState();
            entryGrid = (EntryGrid)this.getControl(entryKey);
            entryGrid.clearEntryState();
            this.getModel().deleteEntryData(entryKey);
            this.updateSplitDimPathShow(entryKey, null);
        }
    }

    private void rollbackSplitData2Source(DetailMembBillData sourceData, Long rowId, SplitedDataInfo splitedData, Map<String, Integer> columnIndex) {
        RowDataStatus rowDataStatus = (RowDataStatus)sourceData.getSourceDataRowStatus().get(rowId);
        if (rowDataStatus != null) {
            Object[] rowData = (Object[])sourceData.getAllRowData().get(rowDataStatus.getRowIndex());
            this.mergeCellData(splitedData.getNotSaveData(), null, rowData, columnIndex);
            this.mergeCellData(splitedData.getHadSaveData(), null, rowData, columnIndex);
        }
    }

    private void rollbackDimSplit() {
        String currentMainEntryKey = this.getCurrentEntityKey();
        Long currentSplitRowId = this.getCurrentSplitRowId(currentMainEntryKey);
        Map<Long, SplitRowData> splitRowInfo = this.getOrCacheSplitRowInfo(null, currentMainEntryKey);
        SplitRowData currentSplitRowData = splitRowInfo.get(currentSplitRowId);
        String currentSplitDim = currentSplitRowData.getCurrentSplitDim();
        String preSplitDim = currentSplitRowData.getPreSplitDim(currentSplitDim);
        Map splitedDataInfoMap = (Map)currentSplitRowData.getSplitedRows().get(currentSplitDim);
        HashMap<Long, SplitedDataInfo> preDimSplitedRowData = (HashMap<Long, SplitedDataInfo>)currentSplitRowData.getSplitedRows().get(preSplitDim);
        if (preDimSplitedRowData == null) {
            preDimSplitedRowData = new HashMap<Long, SplitedDataInfo>();
            preDimSplitedRowData.put(currentSplitRowId, currentSplitRowData.getSplitedData());
        }
        if (splitedDataInfoMap != null) {
            this.clearSplitDataOnDim(splitedDataInfoMap, currentSplitRowId, currentMainEntryKey, preDimSplitedRowData, false, true);
            this.cacheRollBackSplitData(splitedDataInfoMap, currentMainEntryKey);
        }
        currentSplitRowData.getSplitedRows().remove(currentSplitDim);
        currentSplitRowData.setCurrentSplitDim(preSplitDim);
        currentSplitRowData.setCurrentFocusSplitDim(preSplitDim);
        this.markRowNotPastZero(currentSplitRowData, preSplitDim, this.getTempConfig(currentMainEntryKey).getSplitColumnMap().keySet(), false);
        this.updateSplitResultEntryData(currentMainEntryKey, this.getSplitEntryKey(currentMainEntryKey), currentSplitRowId, splitRowInfo, null, preSplitDim);
        this.updateSplitDimPathShow(currentMainEntryKey, currentSplitRowId);
        this.getOrCacheSplitRowInfo(splitRowInfo, currentMainEntryKey);
        this.cacheSourceData(currentMainEntryKey);
    }

    private void addBackValToParentRow(Map<Long, Map<String, Object>> totalBackData, Map<Long, Integer> parentRowIndex, DetailMembBillData sourceData, Map<String, Integer> columnIndex, Map<Long, SplitedDataInfo> preDimSplitedRowData) {
        if (totalBackData.size() > 0) {
            for (Map.Entry<Long, Map<String, Object>> backDataEntry : totalBackData.entrySet()) {
                int rowIndex = parentRowIndex.get(backDataEntry.getKey());
                Object[] rowData = (Object[])sourceData.getAllRowData().get(rowIndex);
                SplitedDataInfo splitedDataInfo = preDimSplitedRowData.get(backDataEntry.getKey());
                Map notSaveData = splitedDataInfo.getNotSaveData();
                for (Map.Entry<String, Object> dataEntry : backDataEntry.getValue().entrySet()) {
                    Object val = dataEntry.getValue();
                    int colIndex = columnIndex.get(dataEntry.getKey());
                    Object oldVal = rowData[colIndex];
                    CellValueObj cellValueObj = notSaveData.computeIfAbsent(dataEntry.getKey(), key -> new CellValueObj());
                    Object currentVal = cellValueObj.getCurrentVal();
                    if (val instanceof BigDecimal) {
                        rowData[colIndex] = ((BigDecimal)oldVal).add((BigDecimal)val);
                        if (currentVal == null) {
                            currentVal = this.getZero();
                        }
                        cellValueObj.setCurrentVal((Object)((BigDecimal)currentVal).add((BigDecimal)val));
                        continue;
                    }
                    if (!(val instanceof Integer)) continue;
                    rowData[colIndex] = (Integer)oldVal + (Integer)val;
                    if (currentVal == null) {
                        currentVal = 0;
                    }
                    cellValueObj.setCurrentVal((Object)((Integer)currentVal + (Integer)val));
                }
            }
        }
    }

    private Map<String, String> getRowDimMembLongNums(List<String> dimKeysList, Map<String, Integer> columnIndex, Object[] rowData, IModelCacheHelper modelCacheHelper, Map<String, String> colMapDimNums, Map<String, Long> viewIds) {
        HashMap<String, String> longNums = new HashMap<String, String>(16);
        for (String dimKey : dimKeysList) {
            Long membId = (Long)rowData[columnIndex.get(dimKey)];
            String dimNum = colMapDimNums.get(dimKey);
            Long viewId = viewIds.get(dimNum);
            Member member = modelCacheHelper.getMember(dimNum, viewId, membId);
            longNums.put(dimKey, "!" + member.getLongNumber() + "!");
        }
        return longNums;
    }

    private Long getMatchParentRow(Map<Long, Map<String, String>> entryParentRowMap, Map<String, String> longNums) {
        Long parentRowId = null;
        block0: for (Map.Entry<Long, Map<String, String>> parentRowMap : entryParentRowMap.entrySet()) {
            for (Map.Entry<String, String> membNumEntry : parentRowMap.getValue().entrySet()) {
                String longNum = longNums.get(membNumEntry.getKey());
                if (longNum != null && longNum.contains(membNumEntry.getValue())) continue;
                continue block0;
            }
            parentRowId = parentRowMap.getKey();
            break;
        }
        return parentRowId;
    }

    private Map<Long, Map<String, DimMember>> getEntryParentRowDimMembMap(Set<Long> parentRowIds, ApplyBillEntityData entityData, EntryTemplateConfig templateConfig) {
        HashMap<Long, Map<String, DimMember>> result = new HashMap<Long, Map<String, DimMember>>(16);
        List rowIds = entityData.getRowIds();
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        Map columnMapDimNum = templateConfig.selectColumnMapDimNum();
        Map viewIds = modelCacheHelper.getViewsByDataSet(Long.valueOf(templateConfig.getDatasetId()));
        for (int index = 0; index < rowIds.size(); ++index) {
            Long rowId = (Long)rowIds.get(index);
            if (!parentRowIds.contains(rowId)) continue;
            HashMap<String, DimMember> dimMembInfo = new HashMap<String, DimMember>(16);
            for (String key : templateConfig.getDimKeysList()) {
                Long viewId;
                EntityCellBaseData cellBaseData = entityData.getCellBaseData(index, key);
                String dimNum = (String)columnMapDimNum.get(key);
                Member member = modelCacheHelper.getMember(dimNum, viewId = (Long)viewIds.get(key), cellBaseData.getId());
                if (member == null) continue;
                DimMember dimMember = new DimMember(member.getId(), member.getNumber(), member.getLongNumber(), member.isLeaf());
                dimMembInfo.put(key, dimMember);
            }
            result.put(rowId, dimMembInfo);
        }
        return result;
    }

    private Map<Long, Map<String, String>> getEntryParentRowMap(Set<Long> parentRowIds, ApplyBillEntityData entityData, EntryTemplateConfig templateConfig, boolean needSign) {
        HashMap<Long, Map<String, String>> result = new HashMap<Long, Map<String, String>>(16);
        List rowIds = entityData.getRowIds();
        for (int index = 0; index < rowIds.size(); ++index) {
            Long rowId = (Long)rowIds.get(index);
            if (!parentRowIds.contains(rowId)) continue;
            HashMap<String, String> dimMembNums = new HashMap<String, String>(16);
            for (String key : templateConfig.getDimKeysList()) {
                EntityCellBaseData cellBaseData = entityData.getCellBaseData(index, key);
                if (needSign) {
                    dimMembNums.put(key, "!" + cellBaseData.getNumber() + "!");
                    continue;
                }
                dimMembNums.put(key, cellBaseData.getNumber());
            }
            result.put(rowId, dimMembNums);
        }
        return result;
    }

    private void cacheRollBackSplitData(Map<Long, SplitedDataInfo> rollbackData, String mainEntryKey) {
        if (rollbackData.isEmpty()) {
            return;
        }
        Map<String, Map<Long, Map<String, Object>>> rollBackSplitData = this.getOrCacheRollBackSplitData(null);
        this.cacheRollBackSplitData(rollbackData, mainEntryKey, rollBackSplitData);
        this.getOrCacheRollBackSplitData(rollBackSplitData);
    }

    private void cacheRollBackSplitData(Map<Long, SplitedDataInfo> rollbackData, String mainEntryKey, Map<String, Map<Long, Map<String, Object>>> rollBackSplitData) {
        Map splitKeysOnRow = rollBackSplitData.computeIfAbsent(mainEntryKey, key -> new HashMap(16));
        rollbackData.forEach((rowId, rowInfo) -> {
            Map hadSaveData = rowInfo.getHadSaveData();
            if (hadSaveData.size() > 0) {
                Map rollBackData = splitKeysOnRow.computeIfAbsent(rowId, key -> new HashMap(16));
                for (Map.Entry dataEntry : hadSaveData.entrySet()) {
                    String colKey = (String)dataEntry.getKey();
                    Object val = ((CellValueObj)dataEntry.getValue()).getCurrentVal();
                    Object sumVal = rollBackData.get(colKey);
                    if (val != null) {
                        if (val instanceof BigDecimal) {
                            if (sumVal == null) {
                                sumVal = this.getZero();
                            }
                            sumVal = ((BigDecimal)sumVal).add((BigDecimal)val);
                        } else if (val instanceof Integer) {
                            if (sumVal == null) {
                                sumVal = 0;
                            }
                            sumVal = (Integer)sumVal + (Integer)val;
                        } else {
                            sumVal = null;
                        }
                    }
                    rollBackData.put(colKey, sumVal);
                }
            }
        });
    }

    private Map<String, Map<Long, Map<String, Object>>> getOrCacheRollBackSplitData(Map<String, Map<Long, Map<String, Object>>> rollbackDataKeys) {
        if (rollbackDataKeys == null) {
            String cacheStr = this.getPageCache().get("RollBackSplitDataKeys");
            rollbackDataKeys = StringUtils.isNotEmpty((CharSequence)cacheStr) ? (HashMap)SerializationUtils.deSerializeFromBase64((String)cacheStr) : new HashMap(16);
        } else {
            this.getPageCache().put("RollBackSplitDataKeys", SerializationUtils.serializeToBase64(rollbackDataKeys));
        }
        return rollbackDataKeys;
    }

    private void mergeCellData(Map<String, CellValueObj> modifiedData, Map<String, Object> allBackData, Object[] rowData, Map<String, Integer> columnIndex) {
        if (modifiedData != null) {
            for (Map.Entry<String, CellValueObj> dataEntry : modifiedData.entrySet()) {
                Object sumVal;
                Object val;
                String key = dataEntry.getKey();
                CellValueObj cellVal = dataEntry.getValue();
                int index = columnIndex.get(key);
                Object currentVal = cellVal.getCurrentVal();
                if (currentVal instanceof BigDecimal) {
                    if (rowData != null) {
                        val = rowData[index];
                        rowData[index] = ((BigDecimal)val).subtract((BigDecimal)currentVal);
                    }
                    if (allBackData == null) continue;
                    sumVal = allBackData.get(key);
                    if (sumVal == null) {
                        sumVal = this.getZero();
                    }
                    allBackData.put(key, ((BigDecimal)sumVal).add((BigDecimal)currentVal));
                    continue;
                }
                if (currentVal instanceof Integer) {
                    if (rowData != null) {
                        val = rowData[index];
                        rowData[index] = (Integer)val - (Integer)currentVal;
                    }
                    if (allBackData == null) continue;
                    sumVal = allBackData.get(key);
                    if (sumVal == null) {
                        sumVal = 0;
                    }
                    allBackData.put(key, (Integer)sumVal + (Integer)currentVal);
                    continue;
                }
                if (rowData == null) continue;
                rowData[index] = cellVal.getPreModifVal();
            }
        }
    }

    private Map<String, Object> selectAllModifSplitData(List<SplitedDataInfo> splitedDataInfos, Set<String> splitColKeys, boolean needHadSave, boolean isRollBack) {
        HashMap<String, Object> splitData = new HashMap<String, Object>(16);
        if (splitedDataInfos != null) {
            splitedDataInfos.forEach(modifData -> this.selectAllModifSplitData(needHadSave ? modifData.getHadSaveData() : modifData.getNotSaveData(), splitColKeys, splitData, isRollBack));
        }
        return splitData;
    }

    private void selectAllModifSplitData(Map<String, CellValueObj> modifiedData, Set<String> splitColKeys, Map<String, Object> splitData, boolean isRollBack) {
        for (String colKey : splitColKeys) {
            CellValueObj cellValueObj = modifiedData.get(colKey);
            if (cellValueObj == null) continue;
            Object currentVal = cellValueObj.getCurrentVal();
            if (currentVal != null) {
                Object sumVal = splitData.get(colKey);
                if (currentVal instanceof BigDecimal) {
                    if (sumVal == null) {
                        sumVal = this.getZero();
                    }
                    splitData.put(colKey, ((BigDecimal)sumVal).add((BigDecimal)currentVal));
                    continue;
                }
                if (currentVal instanceof Integer) {
                    if (sumVal == null) {
                        sumVal = 0;
                    }
                    splitData.put(colKey, (Integer)sumVal + (Integer)currentVal);
                    continue;
                }
                if (isRollBack) {
                    splitData.put(colKey, cellValueObj.getPreModifVal());
                    continue;
                }
                splitData.put(colKey, currentVal);
                continue;
            }
            if (!isRollBack) continue;
            splitData.put(colKey, cellValueObj.getPreModifVal());
        }
    }

    private Date getOrCacheOpenTime(Date date) {
        if (date == null) {
            String cacheStr = this.getPageCache().get("OpenTimeCache");
            date = StringUtils.isNotEmpty((CharSequence)cacheStr) ? new Date(Long.parseLong(cacheStr)) : new Date(1000L);
        } else {
            this.getPageCache().put("OpenTimeCache", String.valueOf(date.getTime()));
        }
        return date;
    }

    private void lockSplitBill() {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"save"});
    }

    @Override
    protected void doCheckBeforeSave(BillVerifyResult verifyResult) {
        super.doCheckBeforeSave(verifyResult);
        this.checkMutexLockB4Op();
        this.checkBillStatus(verifyResult.getEventArgs().getOpKey());
        this.validateMustInput(verifyResult);
        this.checkNewRowComplete(verifyResult);
    }

    private void checkNewRowComplete(BillVerifyResult verifyResult) {
        if (!verifyResult.isSuccess()) {
            return;
        }
        HashMap tempNumMapName = new HashMap();
        this.getEntryInfoFromFormParam().getEntryTemplateConfig().forEach((entryKey, config) -> {
            if (this.isMainEntry((String)entryKey)) {
                tempNumMapName.put(config.getNumber(), config.getName());
            }
        });
        Map<Long, NewRowInfo> allNewRowInfo = this.getOrCacheAllNewRowInfo(null);
        for (NewRowInfo newRowInfo : allNewRowInfo.values()) {
            if (newRowInfo.getRowDimMembIds() == null) continue;
            verifyResult.addResutInfo(ResManager.loadResFormat((String)"\u6a21\u677f\u201c%1\u201d\u4e2d\u6709\u65b0\u589e\u884c\u7684\u7ef4\u5ea6\u6210\u5458\u672a\u8bbe\u7f6e\u5b8c\u6574\u3002", (String)"BgApplySplitBillPlugin_34", (String)"epm-eb-formplugin", (Object[])new Object[]{tempNumMapName.get(newRowInfo.getTemplateNumber())}));
            verifyResult.setSuccess(false);
        }
    }

    private void checkSubmit(BillVerifyResult verifyResult) {
        if (!verifyResult.isSuccess()) {
            return;
        }
        DecpBillData decpBillData = this.getOrCacheDecpBillData(null);
        Map entryTemplateConfig = this.getEntryInfoFromFormParam().getEntryTemplateConfig();
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        for (Map.Entry templateConfigEntry : entryTemplateConfig.entrySet()) {
            String entryKey = (String)templateConfigEntry.getKey();
            EntryTemplateConfig tempConfig = (EntryTemplateConfig)templateConfigEntry.getValue();
            if (!this.isMainEntry(entryKey)) continue;
            String splitEntryKey = this.getSplitEntryKey(entryKey);
            EntryTemplateConfig splitEntryConfig = this.getSplitEntryConfig(splitEntryKey);
            DynamicObjectCollection splitEntryRows = this.getModel().getEntryEntity(splitEntryKey);
            if (splitEntryRows.isEmpty()) continue;
            block1: for (DynamicObject rowObj : splitEntryRows) {
                for (String splitSubKey : splitEntryConfig.getSplitSubKeyMap().values()) {
                    BigDecimal subData = rowObj.getBigDecimal(splitSubKey);
                    if (subData.compareTo(BigDecimal.ZERO) == 0) continue;
                    verifyResult.setSuccess(false);
                    String membNames = this.selectRowDimMembNames(rowObj, splitEntryConfig.getDimKeysList());
                    verifyResult.addResutInfo(ResManager.loadResFormat((String)"\u6a21\u677f\u201c%1\u201d\u4e2d\u7684\u884c\u201c%2\u201d\u5c1a\u672a\u5b8c\u6210\u5206\u89e3\u3002", (String)"BgApplySplitBillPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[]{tempConfig.getName(), membNames}));
                    continue block1;
                }
            }
            if (decpBillData.getNextStepNumber() != null || !verifyResult.isSuccess()) continue;
            DetailMembBillData sourceData = this.getSourceData(entryKey);
            ApplyBillAggHelper applyBillAggHelper = ApplyBillAggHelper.getInstance();
            Map columnIndex = tempConfig.getColumnIndex();
            Map columnMapDimNum = tempConfig.selectColumnMapDimNum();
            Map viewIds = modelCacheHelper.getViewsByDataSet(Long.valueOf(tempConfig.getDatasetId()));
            List dimKeysList = tempConfig.getDimKeysList();
            Set splitColKeys = tempConfig.getSplitSubKeyMap().keySet();
            block3: for (Object[] rowData : sourceData.getAllRowData()) {
                if (applyBillAggHelper.isDetailRow(rowData)) continue;
                for (String col : splitColKeys) {
                    int index = (Integer)columnIndex.get(col);
                    BigDecimal subData = (BigDecimal)rowData[index];
                    if (subData.compareTo(BigDecimal.ZERO) == 0) continue;
                    verifyResult.setSuccess(false);
                    String membNames = this.selectRowDimMembNames(rowData, dimKeysList, columnIndex, columnMapDimNum, modelCacheHelper, viewIds);
                    verifyResult.addResutInfo(ResManager.loadResFormat((String)"\u6a21\u677f\u201c%1\u201d\u4e2d\u7684\u884c\u201c%2\u201d\u5c1a\u672a\u5b8c\u6210\u5206\u89e3\u3002", (String)"BgApplySplitBillPlugin_35", (String)"epm-eb-formplugin", (Object[])new Object[]{tempConfig.getName(), membNames}));
                    continue block3;
                }
            }
        }
    }

    private String selectRowDimMembNames(DynamicObject rowObj, List<String> dimColKeys) {
        StringBuilder sb = new StringBuilder();
        for (String colKey : dimColKeys) {
            DynamicObject membObj = rowObj.getDynamicObject(colKey);
            if (membObj == null) continue;
            sb.append(membObj.getString("name")).append(',');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private String selectRowDimMembNames(Object[] rowData, List<String> dimColKeys, Map<String, Integer> columnIndex, Map<String, String> dimColMapDimNum, IModelCacheHelper modelCacheHelper, Map<String, Long> viewIs) {
        StringBuilder sb = new StringBuilder();
        for (String colKey : dimColKeys) {
            int index;
            Long membId;
            Long viewId;
            String dimNum = dimColMapDimNum.get(colKey);
            Member member = modelCacheHelper.getMember(dimNum, viewId = viewIs.get(dimNum), membId = (Long)rowData[index = columnIndex.get(colKey).intValue()]);
            if (member == null) continue;
            sb.append(member.getName()).append(',');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private EntryTemplateConfig getSplitEntryConfig(String splitEntryKey) {
        EntryTemplateConfig splitEntryConfig = (EntryTemplateConfig)this.getEntryInfoFromFormParam().getSplitEntryConfig().get(splitEntryKey);
        return splitEntryConfig;
    }

    @Override
    protected void afterMainEntityTabChange(String entityKey) {
        super.afterMainEntityTabChange(entityKey);
        this.showCurrentResultEntry(entityKey);
        this.changeNewRowItemShow(entityKey);
    }

    private void changeNewRowItemShow(String currentEntityKey) {
        boolean showNewRow = (Boolean)this.getValue("shownewrow", null);
        if (this.isCommited() || !showNewRow) {
            this.lockNewRowItems(true);
        } else {
            String splitDimKey = this.getOrCacheCurrentSplitDimKeys(null).get(currentEntityKey);
            String focusDimKey = this.getOrCacheCurrentFocusDimKeys(null).get(currentEntityKey);
            boolean lock = splitDimKey == null || !splitDimKey.equals(focusDimKey);
            this.lockNewRowItems(lock);
        }
    }

    private void lockNewRowItems(boolean lock) {
        this.getView().setEnable(Boolean.valueOf(!lock), new String[]{"addnewrow", "delnewrow"});
    }

    private void showCurrentResultEntry(String entityKey) {
        String tabKey = entityKey.replace("entryentity", "splitresulttab");
        Tab tab = (Tab)this.getControl("tabap1");
        tab.activeTab(tabKey);
    }

    @Override
    protected void addCustomInfoToTempConfig(EntryTemplateConfig mainEntrytemplateConfig, String entryNumber) {
        super.addCustomInfoToTempConfig(mainEntrytemplateConfig, entryNumber);
        Map<String, String> splitColumnMap = this.selectSplitColumn(mainEntrytemplateConfig);
        mainEntrytemplateConfig.setSplitColumnMap(splitColumnMap);
        this.addCustomColumn2Main(mainEntrytemplateConfig, entryNumber);
    }

    private void addCustomColumn2Main(EntryTemplateConfig mainEntrytemplateConfig, String entryNumber) {
        String index = entryNumber.replace("entryentity", "");
        this.addSubSplitColumn(mainEntrytemplateConfig, index, "h_");
    }

    private Map<String, String> selectSplitColumn(EntryTemplateConfig templateConfig) {
        LinkedHashMap<String, String> splitColumnMap = new LinkedHashMap<String, String>(16);
        templateConfig.getEntryColumns().forEach(column -> {
            if (column.isEnable() && column instanceof DimensionDataColumn && (column.getFieldtype() == FieldTypeEnum.IntField || column.getFieldtype() == FieldTypeEnum.NumberField)) {
                String columnKey = column.getKey();
                List dataMapDimensions = ((DimensionDataColumn)column).getDataMapDimensions();
                Map<Long, Long> dimMembMap = dataMapDimensions.stream().collect(Collectors.toMap(dim -> dim.getDimensionId(), dim -> dim.getDimensionRememberId()));
                block0: for (BaseColumn column1 : templateConfig.getEntryColumns()) {
                    if (column1.getKey().equals(columnKey) || !(column1 instanceof DimensionDataColumn)) continue;
                    List dataMapDimensions1 = ((DimensionDataColumn)column1).getDataMapDimensions();
                    for (DataMapDimension dimension : dataMapDimensions1) {
                        Long membId = dimMembMap.get(dimension.getDimensionId());
                        if (membId != null && membId.equals(dimension.getDimensionRememberId())) continue;
                        continue block0;
                    }
                    splitColumnMap.put(columnKey, column1.getKey());
                }
                if (!splitColumnMap.containsKey(columnKey)) {
                    splitColumnMap.put(columnKey, columnKey);
                }
            }
        });
        return splitColumnMap;
    }

    private void changeRollBackDataUnit(Map<String, Map<Long, Map<String, Object>>> allRollBackSplitData) {
        allRollBackSplitData.forEach((entryKey, rowsData) -> {
            EntryTemplateConfig tempConfig = this.getTempConfig((String)entryKey);
            Set currencyColumnKeys = tempConfig.getCurrencyColumnKeys();
            if (currencyColumnKeys.size() > 0) {
                BigDecimal unitData = this.getUnitData(tempConfig.getUnit());
                rowsData.values().forEach(rowData -> {
                    for (String key : currencyColumnKeys) {
                        Object val = rowData.get(key);
                        if (val == null) continue;
                        rowData.put(key, this.changeValByUnit(val, unitData, true));
                    }
                });
            }
        });
    }

    @Override
    protected void saveBillData(BillSaveEventArgs eventArgs) {
        DecpBillData decpBillData = this.getOrCacheDecpBillData(null);
        Map<String, Map<Long, SplitRowData>> splitRowDataMap = this.getAllSplitRowInfo(true);
        Map<String, DetailMembBillData> sourceData = this.getAllSourceData();
        String billNumber = this.getBillNumber();
        Long userId = UserUtils.getUserId();
        Timestamp now = new Timestamp(TimeServiceHelper.now().getTime());
        DBRoute route = new DBRoute("epm");
        Map<String, Map<Long, Map<String, Object>>> allRollBackSplitData = this.getOrCacheRollBackSplitData(null);
        this.changeRollBackDataUnit(allRollBackSplitData);
        Map<String, Map<Long, Map<String, Object>>> detailRowSplitData = this.getOrCacheDetailRowSplitData(null);
        Long modelId = this.getModelId();
        Map<Long, NewRowInfo> allNewRowInfo = this.getOrCacheAllNewRowInfo(null);
        for (Map.Entry<String, Map<Long, SplitRowData>> splitDataEntry : splitRowDataMap.entrySet()) {
            ArrayList<Object[]> toSaveRowsData = new ArrayList<Object[]>();
            ArrayList toDelRowIds = new ArrayList(16);
            HashMap toUpdateVals = new HashMap(16);
            Map<Long, SplitRowData> preSplitRowDatas = splitDataEntry.getValue();
            String mainEntryKey = splitDataEntry.getKey();
            HashMap<Long, Set<String>> modifedRowInfo = new HashMap<Long, Set<String>>(16);
            this.addModifiedKeys(preSplitRowDatas, modifedRowInfo);
            EntryTemplateConfig templateConfig = this.getTempConfig(mainEntryKey);
            BigDecimal unitData = this.getUnitData(templateConfig.getUnit());
            List columns = templateConfig.selectEntryColumnsNoDimText();
            Map columnMap = templateConfig.selectColumnMap();
            ApplyBillAggHelper billAggHelper = ApplyBillAggHelper.getInstance();
            boolean saveInitSplit = decpBillData.isFirstStep() && decpBillData.isNotInitedDecpData();
            Set<String> splitColKeys = templateConfig.getSplitColumnMap().keySet();
            DetailMembBillData detailMembBillData = sourceData.get(mainEntryKey);
            Map oldSplitData = detailRowSplitData.computeIfAbsent(mainEntryKey, key -> new HashMap(16));
            Map rollBackSplitData = allRollBackSplitData.computeIfAbsent(mainEntryKey, key -> new HashMap(16));
            Map<Long, List<SplitedDataInfo>> splitRowDataInMap = this.changeSplitRowData(preSplitRowDatas);
            ArrayList<SplitLogObj> toSaveLog = new ArrayList<SplitLogObj>(16);
            if (splitRowDataInMap.isEmpty() && rollBackSplitData.isEmpty() && !saveInitSplit) continue;
            this.addRollBackColToModifedKeys(modifedRowInfo, rollBackSplitData);
            for (Map.Entry rowInfo : detailMembBillData.getDetailRowStatus().entrySet()) {
                RowDataStatus rowDataStatus = (RowDataStatus)rowInfo.getValue();
                Object[] rowData = (Object[])detailMembBillData.getAllRowData().get(rowDataStatus.getRowIndex());
                Long rowId2 = billAggHelper.getRowId(rowData);
                this.addCopyColToModifiedKeys(rowData, rowId2, templateConfig.getColumnIndex(), saveInitSplit, splitColKeys, modifedRowInfo);
                HashSet<String> modifedKeys = (HashSet<String>)modifedRowInfo.get(rowId2);
                if (saveInitSplit && billAggHelper.isDetailRow(rowData)) {
                    if (modifedKeys == null) {
                        modifedKeys = new HashSet<String>(16);
                    }
                    modifedKeys.addAll(splitColKeys);
                }
                if (modifedKeys == null || modifedKeys.isEmpty()) {
                    NewRowInfo newRowInfo2 = allNewRowInfo.get(rowId2);
                    if (newRowInfo2 == null || newRowInfo2.getStatus() != NewRowStatusEnum.NEW) continue;
                    if (modifedKeys == null) {
                        modifedKeys = new HashSet(16);
                    }
                    modifedKeys.addAll(splitColKeys);
                }
                if (rowDataStatus.isNewEdit()) {
                    this.setDefaultColumnVal(rowData, rowId2, this.getBillType(), billNumber, this.isNewRow(rowId2) ? EntityRowDataType.NEW_DETAIL.getNumber() : EntityRowDataType.EDIT_NOTDETAIL.getNumber(), columns, templateConfig.getColumnIndex());
                    Object[] rowDataCopy = Arrays.copyOf(rowData, rowData.length);
                    this.updateUnit(rowDataCopy, unitData, templateConfig.getCurrencyColumnKeys(), templateConfig.getColumnIndex(), false);
                    HashMap<String, Object> changedVal = new HashMap<String, Object>(16);
                    this.selectChangeVal(changedVal, rowDataCopy, Collections.EMPTY_SET, unitData, modifedKeys, columnMap, templateConfig.getColumnIndex());
                    if (billAggHelper.isDetailRow(rowDataCopy)) {
                        this.updateDetailSplitData4Save(rowId2, changedVal, splitColKeys, oldSplitData, rollBackSplitData, splitRowDataInMap);
                        this.backSubDataToNewRow(changedVal, rowDataCopy, templateConfig.getColumnIndex(), templateConfig.getAggKeys());
                    }
                    toSaveLog.add(new SplitLogObj(billNumber, templateConfig.getNumber(), changedVal, rowId2, userId, now, modelId));
                    toSaveRowsData.add(rowDataCopy);
                    continue;
                }
                HashMap<String, Object> changedVal = new HashMap<String, Object>(16);
                this.selectChangeVal(changedVal, rowData, templateConfig.getCurrencyColumnKeys(), unitData, modifedKeys, columnMap, templateConfig.getColumnIndex());
                if (billAggHelper.isDetailRow(rowData)) {
                    this.updateDetailSplitData4Save(rowId2, changedVal, splitColKeys, oldSplitData, rollBackSplitData, splitRowDataInMap);
                }
                toSaveLog.add(new SplitLogObj(billNumber, templateConfig.getNumber(), changedVal, rowId2, userId, now, modelId));
                ApplyBillPluginUitl.selectToUpdateVal(changedVal, (String)templateConfig.getEntryTable(), (Long)userId, (Timestamp)now, (Long)rowId2, toUpdateVals);
            }
            String templateNum = templateConfig.getNumber();
            allNewRowInfo.forEach((rowId, newRowInfo) -> {
                if (newRowInfo.getTemplateNumber().equals(templateNum) && newRowInfo.getStatus() == NewRowStatusEnum.DELETED) {
                    toDelRowIds.add(rowId);
                }
            });
            if (!toDelRowIds.isEmpty()) {
                String delSql = "delete from " + templateConfig.getEntryTable() + " where fentryid in (" + SqlBatchUtils.getBatchParamsSql((int)toDelRowIds.size()) + ")";
                this.executeOrBatch(route, delSql, Collections.singletonList(toDelRowIds.toArray()), false);
                CommonServiceHelper.handleLog((Log)this.getLog(), (String)("DelRowIds:" + billNumber + ":" + templateNum), (String)SerializationUtils.toJsonString(toDelRowIds));
            }
            if (!toSaveRowsData.isEmpty()) {
                String insertSql = ApplyTemplateUtils.buildInsertSql((String)templateConfig.getEntryTable(), (List)columns);
                this.updateModifInfo(toSaveRowsData, userId, now);
                this.executeOrBatch(route, insertSql, toSaveRowsData, true);
                eventArgs.setToSaveRowsData(toSaveRowsData);
            }
            if (!toUpdateVals.isEmpty()) {
                for (Map.Entry entry : toUpdateVals.entrySet()) {
                    this.executeOrBatch(route, (String)entry.getKey(), (List)entry.getValue(), true);
                }
            }
            if (toSaveLog.isEmpty()) continue;
            ArrayList<Object[]> toSaveVals = new ArrayList<Object[]>(toSaveLog.size());
            toSaveLog.forEach(log -> toSaveVals.add(log.getSaveObj()));
            String string = "insert into t_eb_splitmodifylog(fid,fbillnumber,ftempnumber,flogtext,fmodifyrowid,fcreator,fcreatedate,fmodelid) values(?,?,?,?,?,?,?,?)";
            this.executeOrBatch(route, string, toSaveVals, true);
        }
        eventArgs.setDetailRowSplitData(detailRowSplitData);
    }

    private void backSubDataToNewRow(Map<String, Object> changedVal, Object[] rowData, Map<String, Integer> columnIndex, Set<String> aggKeys) {
        changedVal.forEach((colKey, val) -> {
            if (val != null && aggKeys.contains(colKey)) {
                rowData[((Integer)columnIndex.get((Object)colKey)).intValue()] = val;
            }
        });
    }

    private Map<Long, List<SplitedDataInfo>> changeSplitRowData(Map<Long, SplitRowData> preSplitRowDatas) {
        HashMap<Long, List<SplitedDataInfo>> result = new HashMap<Long, List<SplitedDataInfo>>(16);
        preSplitRowDatas.forEach((splitRowId, splitRowData) -> {
            splitRowData.getSplitedRows().forEach((splitDim, modifRowsData) -> modifRowsData.forEach((rowId, rowData) -> {
                List splitedDataInfos = result.computeIfAbsent((Long)rowId, key -> new ArrayList(16));
                splitedDataInfos.add(rowData);
            }));
            List splitedDataInfos = result.computeIfAbsent((Long)splitRowId, key -> new ArrayList(16));
            splitedDataInfos.add(splitRowData.getSplitedData());
        });
        return result;
    }

    private void updateDetailSplitData4Save(Long rowId, Map<String, Object> changedVals, Set<String> splitColKeys, Map<Long, Map<String, Object>> oldSplitData, Map<Long, Map<String, Object>> rollBackSplitData, Map<Long, List<SplitedDataInfo>> splitRowDataInMap) {
        Map<String, Object> oldData = oldSplitData.get(rowId);
        Map<String, Object> rollBackData = rollBackSplitData.get(rowId);
        List<SplitedDataInfo> modifyInfo = splitRowDataInMap.get(rowId);
        if (!Collections.disjoint(changedVals.keySet(), splitColKeys)) {
            Map<String, Object> modifSplitData = this.selectAllModifSplitData(modifyInfo, splitColKeys, false, false);
            for (String colKey : splitColKeys) {
                Number oldVal;
                Number mVal;
                Number rollVal;
                Number toSaveVal;
                Object changeVal = changedVals.get(colKey);
                if (changeVal == null) continue;
                if (changeVal instanceof BigDecimal) {
                    toSaveVal = this.getZero();
                    if (rollBackData != null && (rollVal = (BigDecimal)rollBackData.get(colKey)) != null) {
                        toSaveVal = ((BigDecimal)toSaveVal).subtract((BigDecimal)rollVal);
                    }
                    if (modifSplitData != null && (mVal = (BigDecimal)modifSplitData.get(colKey)) != null) {
                        toSaveVal = ((BigDecimal)toSaveVal).add((BigDecimal)mVal);
                    }
                    if (oldData != null) {
                        oldVal = (BigDecimal)oldData.get(colKey);
                        if (oldVal != null) {
                            toSaveVal = ((BigDecimal)toSaveVal).add((BigDecimal)oldVal);
                        }
                    } else {
                        oldData = new HashMap<String, Object>(16);
                        oldSplitData.put(rowId, oldData);
                    }
                    oldData.put(colKey, toSaveVal);
                    changedVals.put(colKey, toSaveVal);
                    continue;
                }
                if (!(changeVal instanceof Integer)) continue;
                toSaveVal = 0;
                if (rollBackData != null && (rollVal = (Integer)rollBackData.get(colKey)) != null) {
                    toSaveVal = (Integer)toSaveVal + (Integer)rollVal;
                }
                if (modifSplitData != null && (mVal = (Integer)modifSplitData.get(colKey)) != null) {
                    toSaveVal = (Integer)toSaveVal + (Integer)mVal;
                }
                if (oldData != null) {
                    oldVal = (Integer)oldData.get(colKey);
                    if (oldVal != null) {
                        toSaveVal = (Integer)toSaveVal + (Integer)oldVal;
                    }
                } else {
                    oldData = new HashMap<String, Object>(16);
                    oldSplitData.put(rowId, oldData);
                }
                oldData.put(colKey, toSaveVal);
                changedVals.put(colKey, toSaveVal);
            }
        }
    }

    @Override
    protected void cleanChangeCache() {
        super.cleanChangeCache();
        this.getPageCache().remove("ChangedRowByRef");
    }

    private void addRollBackColToModifedKeys(Map<Long, Set<String>> modifedRowInfo, Map<Long, Map<String, Object>> rollBackKeysOnRow) {
        if (rollBackKeysOnRow != null && rollBackKeysOnRow.size() > 0) {
            rollBackKeysOnRow.forEach((rowId, rollData) -> {
                Set modifiedColKeys = modifedRowInfo.computeIfAbsent((Long)rowId, key -> new HashSet(16));
                modifiedColKeys.addAll(rollData.keySet());
            });
        }
    }

    private void addCopyColToModifiedKeys(Object[] rowData, Long rowId, Map<String, Integer> columnIndex, boolean saveInitSplit, Set<String> splitColKeys, Map<Long, Set<String>> modifedRowInfo) {
        ApplyBillAggHelper billAggHelper = ApplyBillAggHelper.getInstance();
        String rowDataType = billAggHelper.getRowDataType(rowData);
        if (!EntityRowDataType.isDetailData((String)rowDataType) && saveInitSplit) {
            for (String colKey : splitColKeys) {
                int index = columnIndex.get(colKey);
                BigDecimal subData = (BigDecimal)rowData[index];
                if (subData == null || subData.compareTo(BigDecimal.ZERO) == 0) continue;
                Set modifedKeys = modifedRowInfo.computeIfAbsent(rowId, key -> new HashSet(16));
                modifedKeys.add(colKey);
            }
        }
    }

    private void addModifiedKeys(Map<Long, SplitRowData> preSplitRowDatas, Map<Long, Set<String>> modifedRowInfo) {
        preSplitRowDatas.forEach((preSplitRowId, splitData) -> {
            SplitedDataInfo splitedData = splitData.getSplitedData();
            this.addModifiedKeys(splitedData, (Long)preSplitRowId, modifedRowInfo);
            splitData.getSplitedRows().values().forEach(splitedRows -> splitedRows.forEach((rowId, modifedData) -> this.addModifiedKeys((SplitedDataInfo)modifedData, (Long)rowId, modifedRowInfo)));
        });
    }

    private void addModifiedKeys(SplitedDataInfo modifedData, Long rowId, Map<Long, Set<String>> modifedRowInfo) {
        if (modifedData.getNotSaveData().size() > 0) {
            Set modifedKeys = modifedRowInfo.computeIfAbsent(rowId, key -> new HashSet(16));
            modifedKeys.addAll(modifedData.getNotSaveData().keySet());
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if (fieldName != null && fieldName.startsWith("s_splitdims") && !this.getOrCacheDecpBillData(null).isSplited()) {
            this.showPreDimSetForm();
        }
    }

    private void showPreDimSetForm() {
        String currentEntityKey = this.getCurrentEntityKey();
        SplitRowData currentSplitRowData = this.getCurrentSplitRowData(currentEntityKey);
        List notDetailDimColumn = currentSplitRowData.getNotDetailDimColumn();
        if (notDetailDimColumn.isEmpty()) {
            return;
        }
        EntryTemplateConfig tempConfig = this.getTempConfig(currentEntityKey);
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        Map columnMapDimNum = tempConfig.selectColumnMapDimNum();
        Map columnMap = tempConfig.selectColumnMap();
        ArrayList<DimensionColumnObj> columnObjList = new ArrayList<DimensionColumnObj>(notDetailDimColumn.size());
        String currentSplitDim = currentSplitRowData.getCurrentSplitDim();
        boolean match = false;
        for (String key : notDetailDimColumn) {
            BaseColumn column = (BaseColumn)columnMap.get(key);
            String dimNum = (String)columnMapDimNum.get(key);
            Dimension dimension = modelCacheHelper.getDimension(dimNum);
            DimensionColumnObj columnObj = new DimensionColumnObj(dimNum, dimension.getName(), dimension.getId(), key, column.getTitle());
            columnObj.setLock(!match);
            columnObjList.add(columnObj);
            if (match || !key.equals(currentSplitDim)) continue;
            match = true;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_presplitdimensions");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("dimColumnInfo", (Object)SerializationUtils.toJsonString(columnObjList));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "splitDimSeting"));
        this.getView().showForm(formShowParameter);
    }

    @Override
    protected boolean beforeOpenF7Form(DynamicObject rowObj, String columnKey, String entityKey, int rowIndex) {
        RowDimMembGroup rowDimMembGroup = new RowDimMembGroup();
        columnKey = columnKey.replaceAll("_text", "");
        EntryTemplateConfig tempConfig = this.getTempConfig(entityKey);
        Long currentSplitRowId = this.getCurrentSplitRowId(entityKey);
        Long rowId = rowObj.getLong("id");
        NewRowInfo newRowInfo = this.getOrCacheAllNewRowInfo(null).get(rowId);
        if (newRowInfo == null || !currentSplitRowId.equals(newRowInfo.getPreSplitRowId()) || newRowInfo.getStatus() != NewRowStatusEnum.NEW) {
            return false;
        }
        for (String dimColKey : tempConfig.getDimKeysList()) {
            DynamicObject membObj = rowObj.getDynamicObject(dimColKey);
            if (membObj == null) continue;
            rowDimMembGroup.getDimMembIds().put(dimColKey, membObj.getLong("id"));
        }
        rowDimMembGroup.setEntryKey(entityKey);
        rowDimMembGroup.setRowId(Long.valueOf(rowObj.getLong("id")));
        rowDimMembGroup.setCurrentDimCol(columnKey);
        this.getOrCacheDimMembGroup(rowDimMembGroup);
        return true;
    }

    private RowDimMembGroup getOrCacheDimMembGroup(RowDimMembGroup rowDimMembGroup) {
        if (rowDimMembGroup == null) {
            String cacheStr = this.getPageCache().get("DimMembGroupOnRow");
            if (StringUtils.isNotEmpty((CharSequence)cacheStr)) {
                rowDimMembGroup = (RowDimMembGroup)SerializationUtils.deSerializeFromBase64((String)cacheStr);
            }
        } else {
            this.getPageCache().put("DimMembGroupOnRow", SerializationUtils.serializeToBase64((Object)rowDimMembGroup));
        }
        return rowDimMembGroup;
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        this.removeLock();
    }

    private void removeLock() {
        Long lockId = this.getOrCacheMutexLockId(null);
        if (lockId != null && !lockId.equals(0L)) {
            MutexRecordHelper.removeLock((Long)lockId);
        }
    }

    private void initNewRowInfo() {
        DecpBillData decpBillData = this.getOrCacheDecpBillData(null);
        Long billId = decpBillData.getBillId();
        Map<Long, NewRowInfo> allNewRowInfo = this.getOrCacheAllNewRowInfo(null);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"initNewRowInfo", (String)"eb_splitnewrow", (String)"id,presplitrowid,templatenumber,reffirstsplitrowid", (QFilter[])new QFilter[]{new QFilter("splitbillid", "=", (Object)billId)}, null);){
            for (Row row : dataSet) {
                Long rowId = row.getLong("id");
                Long refSplitRowId = row.getLong("reffirstsplitrowid");
                Long preSplitRowId = row.getLong("presplitrowid");
                String templateNumber = row.getString("templatenumber");
                allNewRowInfo.put(rowId, new NewRowInfo(refSplitRowId, preSplitRowId, templateNumber, NewRowStatusEnum.EDIT));
            }
        }
        this.getOrCacheAllNewRowInfo(allNewRowInfo);
        this.handleLogNewRowInfo(allNewRowInfo);
    }

    private void handleLogNewRowInfo(Map<Long, NewRowInfo> allNewRowInfo) {
        String sign = "LogNewRowInfo-" + this.getBillNumber();
        Set<String> logSignsFromForm = this.getLogSignsFromForm();
        if (logSignsFromForm.contains(sign)) {
            CommonServiceHelper.handleLog((Log)this.getLog(), (String)sign, (String)SerializationUtils.toJsonString(allNewRowInfo));
        }
    }

    @Override
    protected boolean needCheckSameShowType() {
        return false;
    }
}

