/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.FieldEdit;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.applybill.ViewDataWayEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class BgApplyViewDataSetPlugin
extends AbstractFormPlugin {
    private static final String dimItemPreKey = "dim";
    private static final String directChildItem = "directchild";
    private static final String alldetailItem = "alldetail";

    public void afterCreateNewData(EventObject e) {
        this.initDimList();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"bnt_conform"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("bnt_conform".equals(key)) {
            this.backDataAndClose();
        }
    }

    private void backDataAndClose() {
        String lastCheckItem = this.getOrCacheLastCheckItem(null);
        Boolean isDirect = (Boolean)this.getValue(directChildItem, null);
        HashMap<String, String> result = new HashMap<String, String>(2);
        Map<String, String> itemMap = this.getOrCacheItemMap(null);
        result.put("viewDimColumn", itemMap.get(lastCheckItem));
        result.put("viewWay", isDirect != false ? ViewDataWayEnum.DIRECTCHILD.getNumber() : ViewDataWayEnum.ALLDETAIL.getNumber());
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(result));
        this.getView().close();
    }

    private void initDimList() {
        String dimStr = (String)this.getView().getFormShowParameter().getCustomParam("ROWDIMINFO");
        List dimInfo = SerializationUtils.fromJsonStringToList((String)dimStr, Pair.class);
        String defaultDimColumn = (String)this.getView().getFormShowParameter().getCustomParam("DEFAULTDIMCOLUMN");
        int dimCount = dimInfo.size();
        HashMap<String, String> dimItemMap = new HashMap<String, String>(dimCount);
        int seq = 1;
        for (Pair dim : dimInfo) {
            String itemKey = dimItemPreKey + seq;
            dimItemMap.put(itemKey, (String)dim.p1);
            FieldEdit fieldEdit = (FieldEdit)this.getControl(itemKey);
            fieldEdit.setCaption(new LocaleString((String)dim.p2));
            if (((String)dim.p1).equals(defaultDimColumn)) {
                this.getModel().setValue(itemKey, (Object)Boolean.TRUE);
                this.getOrCacheLastCheckItem(itemKey);
            }
            ++seq;
        }
        this.getView().setVisible(Boolean.valueOf(true), dimItemMap.keySet().toArray(new String[dimCount]));
        this.getOrCacheItemMap(dimItemMap);
    }

    private Map<String, String> getOrCacheItemMap(Map<String, String> dimItemMap) {
        if (dimItemMap == null) {
            String cacheStr = this.getPageCache().get("dimItemMap");
            dimItemMap = StringUtils.isNotEmpty((String)cacheStr) ? (HashMap)SerializationUtils.fromJsonString((String)cacheStr, Map.class) : new HashMap(16);
        } else {
            this.getPageCache().put("dimItemMap", SerializationUtils.toJsonString(dimItemMap));
        }
        return dimItemMap;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.needDealPropChange()) {
            return;
        }
        String propName = e.getProperty().getName();
        Object newVal = e.getChangeSet()[0].getNewValue();
        if (propName.startsWith(dimItemPreKey)) {
            this.dealDimItemChange(propName, (Boolean)newVal);
        } else if (directChildItem.equals(propName)) {
            this.dealWayItemChange(propName, false, (Boolean)newVal);
        } else if (alldetailItem.equals(propName)) {
            this.dealWayItemChange(propName, true, (Boolean)newVal);
        }
    }

    private String getOrCacheLastCheckItem(String itemKey) {
        if (itemKey == null) {
            itemKey = this.getPageCache().get("LastCheckItem");
        } else {
            this.getPageCache().put("LastCheckItem", itemKey);
        }
        return itemKey;
    }

    private void dealDimItemChange(String key, boolean newVal) {
        String lastCheckItem = this.getOrCacheLastCheckItem(null);
        if (newVal) {
            this.getOrCacheLastCheckItem(key);
        }
        this.setNeedDealPropChange(false);
        this.getModel().setValue(lastCheckItem, (Object)(!newVal ? 1 : 0));
        this.setNeedDealPropChange(true);
    }

    private void dealWayItemChange(String key, boolean isAllDetail, boolean newVal) {
        String lastKey = newVal ? (isAllDetail ? directChildItem : alldetailItem) : key;
        this.setNeedDealPropChange(false);
        this.getModel().setValue(lastKey, (Object)(!newVal ? 1 : 0));
        this.setNeedDealPropChange(true);
    }

    private void setNeedDealPropChange(boolean needDeal) {
        if (needDeal) {
            this.getPageCache().remove("NeedDealPropChange");
        } else {
            this.getPageCache().put("NeedDealPropChange", "true");
        }
    }

    private boolean needDealPropChange() {
        String needDealPropChange = this.getPageCache().get("NeedDealPropChange");
        return StringUtils.isEmpty((String)needDealPropChange);
    }
}

