/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.operate.UnSubmit;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BillClosedCallBackEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyBillAttachmentHelper;
import kd.epm.eb.business.applybill.util.BgApplyBillHelper;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.business.reportscheme.service.ReportSchemeAssignService;
import kd.epm.eb.business.reportscheme.service.ReportSchemeService;
import kd.epm.eb.common.applybill.AdjustShowTypeEnum;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.centralapproval.AppBillStatusEnum;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.formplugin.applybill.util.BgApplyBillListBasePlugin;
import kd.epm.eb.formplugin.approveBill.CommitExaminCheck;

public class BgApplybillListPlugin
extends BgApplyBillListBasePlugin
implements TreeNodeClickListener,
BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(BgApplybillListPlugin.class);
    private static final String APPLY_ADD = "applyAdd";

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_new": {
                this.showAddNewForm(true, "btn_new");
                break;
            }
            case "btn_new_c": {
                this.showAddNewForm(false, "btn_new_c");
                break;
            }
            case "btn_reflesh": {
                this.initSchemeTree();
                break;
            }
            case "view_workflow": {
                this.viewWorkFlow();
                break;
            }
            case "btn_adjrecord": {
                this.openAppAdjPage();
                break;
            }
            case "btn_examinereport": {
                this.showExamineReportPage();
                break;
            }
            case "btn_examinecheck": {
                ListSelectedRowCollection selectedRows = this.getSelectedRows();
                if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u6570\u636e", (String)"MntExecutePlanListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    return;
                }
                Set idSet = selectedRows.stream().map(x -> x.getPrimaryKeyValue()).collect(Collectors.toSet());
                Map billDynamicMap = BusinessDataServiceHelper.loadFromCache((String)"eb_bgapplybill", (QFilter[])new QFilter("id", "in", idSet).toArray());
                new CommitExaminCheck().examineCheck(billDynamicMap.values(), this.getView(), false);
                break;
            }
        }
    }

    private void showExamineReportPage() {
        ListShowParameter showParameter = new ListShowParameter();
        String clickNodeId = this.getOrCacheLeftTreeClickNodeId(null);
        TreeNode leftTreeNode = this.getOrCacheLeftTree(null);
        TreeNode clickNode = new TreeNode();
        if (leftTreeNode != null) {
            clickNode = leftTreeNode.getTreeNode(clickNodeId, 20);
        }
        QFBuilder qb = new QFBuilder("model", "=", (Object)this.getModelId());
        HashMap<String, Serializable> conditionMap = new HashMap<String, Serializable>(16);
        if (clickNode != null) {
            String[] focus = clickNode.getId().split("_");
            conditionMap.put("period", IDUtils.toLong((Object)focus[1]));
            conditionMap.put("version", IDUtils.toLong((Object)focus[2]));
            conditionMap.put("datatype", IDUtils.toLong((Object)focus[0]));
            HashSet<Long> orgSet = new HashSet<Long>(16);
            this.buildOrgSet(clickNode, orgSet);
            if (orgSet.size() > 0) {
                conditionMap.put("entity", orgSet);
            }
        } else {
            qb.add("1", "=", (Object)-1);
        }
        showParameter.setBillFormId("eb_examine_result_report");
        showParameter.setFormId("eb_examine_report_list");
        showParameter.setCustomParam("formCondition", (Object)SerializationUtils.serializeToBase64(conditionMap));
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        showParameter.setCustomParam("processType", (Object)ProcessTypeEnum.APPLY);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "examineCheckReport"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void openAppAdjPage() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"ApplyBgApplybillListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow row = (ListSelectedRow)selectedRows.iterator().next();
        Long key = Long.parseLong(row.getPrimaryKeyValue().toString());
        String billNo = row.getNumber();
        DynamicObject billQuery = QueryServiceHelper.queryOne((String)"eb_bgapplybill", (String)"billtype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)key)});
        String billType = billQuery.getString("billtype");
        List<ApproveBill> query = this.getCenAppBillByRptOrColBill(billNo, billType);
        String spBillNo = "";
        if (query != null && query.size() == 1) {
            ApproveBill bill = query.get(0);
            spBillNo = bill.getBillNo();
        }
        if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)spBillNo)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u8bb0\u5f55\u7684\u5ba1\u6279\u5355\u636e\u7f16\u53f7\u4e3a\u7a7a\u3002", (String)"ApproveBillListNew_15", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = CentralAppBillService.getInstance().getAdjustShowPage(spBillNo, Long.valueOf(0L), null, Long.valueOf(0L), AdjustShowTypeEnum.ApproveAdjust, ApplyBillType.APPLYAUDIT, Long.valueOf(0L), this.getModelId());
        this.getView().showForm(formShowParameter);
    }

    private List<ApproveBill> getCenAppBillByRptOrColBill(String billNo, String billType) {
        QFilter qFilter = new QFilter("billstatus", "!=", (Object)AppBillStatusEnum.CANCEL.getNumber());
        String billNoField = "sumbillno";
        if (billType.equals(ApplyBillType.APPLY.getNumber())) {
            billNoField = "reportbillno";
            qFilter.and(new QFilter("centralapprptentity.sumbillno", "=", (Object)""));
        }
        qFilter.and(new QFilter("centralapprptentity." + billNoField, "=", (Object)billNo));
        return ApproveBillUtil.getInstance().getApproveBills(qFilter);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.size() == 0) {
            return;
        }
        if (source instanceof Submit) {
            Set idSet = selectedRows.stream().map(x -> x.getPrimaryKeyValue()).collect(Collectors.toSet());
            Map billDynamicMap = BusinessDataServiceHelper.loadFromCache((String)"eb_bgapplybill", (QFilter[])new QFilter("id", "in", idSet).toArray());
            if (!new CommitExaminCheck().examineCheck(billDynamicMap.values(), this.getView(), true)) {
                args.setCancel(true);
            }
            return;
        }
        if (!(source instanceof UnSubmit)) {
            return;
        }
        ArrayList<Long> billHasSubmitIdList = new ArrayList<Long>(16);
        for (ListSelectedRow selectedRow : selectedRows) {
            String billStatus = selectedRow.getBillStatus();
            Object primaryKeyValue = selectedRow.getPrimaryKeyValue();
            if (!"C".equals(billStatus) || primaryKeyValue == null) continue;
            billHasSubmitIdList.add(IDUtils.toLong((Object)primaryKeyValue));
        }
        if (billHasSubmitIdList.size() == 0) {
            return;
        }
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and("id", "in", billHasSubmitIdList);
        Map billDynamicMap = BusinessDataServiceHelper.loadFromCache((String)"eb_bgapplybill", (QFilter[])filter.toArray());
        Collection<DynamicObject> billObjs = billDynamicMap.values();
        this.filterCreator(billObjs);
        if (billObjs.isEmpty()) {
            return;
        }
        HashMap<String, String> bills = new HashMap<String, String>(16);
        for (DynamicObject applyBillDynamicObj : billObjs) {
            String billNumber = applyBillDynamicObj.getString("billnumber");
            String billType = applyBillDynamicObj.getString("billtype");
            if (kd.epm.eb.common.utils.StringUtils.isEmpty((String)billNumber) || kd.epm.eb.common.utils.StringUtils.isEmpty((String)billType)) continue;
            bills.put(billNumber, billType);
        }
        String confirmMessage = CentralAppBillService.getInstance().checkBeforeRevoke(bills);
        if (kd.epm.eb.common.utils.StringUtils.isNotEmpty((String)confirmMessage)) {
            this.getView().showConfirm(confirmMessage, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("unSubmit", (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = formOperate.getOperateKey();
        if (kd.epm.eb.common.utils.StringUtils.equals((String)operateKey, (String)"delete")) {
            HashSet<Long> billIds = new HashSet<Long>(16);
            ListSelectedRowCollection listSelectedData = formOperate.getListSelectedData();
            for (ListSelectedRow data : listSelectedData) {
                billIds.add(IDUtils.toLong((Object)data.getPrimaryKeyValue()));
            }
            ApplyBillAttachmentHelper.removeApplyBillAttachments(billIds);
        }
    }

    private void filterCreator(Collection<DynamicObject> bills) {
        Long currentUserid = this.getUserId();
        boolean isModelManager = this.isModelManager(currentUserid);
        if (!isModelManager) {
            bills.removeIf(bill -> !this.checkCreator((DynamicObject)bill, currentUserid));
        }
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        if (StringUtils.equals((CharSequence)"billnumber", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            IFormView parentView = this.getView().getParentView();
            Object objId = this.getFocusRowPkId();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)objId, (String)"eb_bgapplybill");
            ApplyBillType billType = ApplyBillType.getBillTypeByNumber((String)dynamicObject.getString("billtype"));
            String billNumber = dynamicObject.getString("billnumber");
            BaseShowParameter baseShowParameter = BgApplyBillHelper.getInstance().getBgApplyTypeBillFormShow(Long.valueOf(dynamicObject.getLong("applyscheme.id")), this.getModelId(), billNumber, billType);
            Long orgId = dynamicObject.getLong("org.id");
            baseShowParameter.setCustomParam("orgId", (Object)orgId);
            baseShowParameter.setPkId(this.getFocusRowPkId());
            baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            String billStatus = dynamicObject.getString("billstatus");
            baseShowParameter.setStatus(OperationStatus.EDIT);
            if ("D".equals(billStatus) || "B".equals(billStatus)) {
                baseShowParameter.setStatus(OperationStatus.VIEW);
            } else {
                baseShowParameter.setStatus(OperationStatus.EDIT);
            }
            if (!this.checkCreator(dynamicObject)) {
                baseShowParameter.setStatus(OperationStatus.VIEW);
                baseShowParameter.setCustomParam("NOT_CREATOR", (Object)"true");
            }
            baseShowParameter.setPageId(this.getView().getPageId() + objId.toString());
            if (parentView != null) {
                baseShowParameter.setParentPageId(parentView.getPageId());
                baseShowParameter.setParentFormId(parentView.getEntityId());
                parentView.showForm((FormShowParameter)baseShowParameter);
                this.getView().sendFormAction(parentView);
            } else {
                this.getView().showForm((FormShowParameter)baseShowParameter);
            }
        }
    }

    private boolean checkCreator(DynamicObject dynamicObject) {
        Long userId = this.getUserId();
        return this.checkCreator(dynamicObject, userId) || this.isModelManager(userId);
    }

    private boolean checkCreator(DynamicObject dynamicObject, Long currentUser) {
        Long creator = dynamicObject.getLong("creater.id");
        return creator != null && creator.equals(currentUser);
    }

    private void showAddNewForm(boolean isApply, String flag) {
        Long orgId;
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        Map focusNodeData = treeView.getTreeState().getFocusNode();
        if (focusNodeData == null || ((String)focusNodeData.get("id")).split("_").length < 5) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u8282\u70b9\u3002", (String)"ApplyBgApplybillListPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        String[] focus = ((String)focusNodeData.get("id")).split("_");
        Long datatypeId = IDUtils.toLong((Object)focus[0]);
        Long yearId = IDUtils.toLong((Object)focus[1]);
        Long versionId = IDUtils.toLong((Object)focus[2]);
        Long schemeId = IDUtils.toLong((Object)focus[3]);
        if (this.memberLimitAdd(isApply, schemeId, orgId = IDUtils.toLong((Object)focus[4])).booleanValue()) {
            return;
        }
        if (flag.equals("btn_new_c") && this.validateAdd((String)focusNodeData.get("id"), isApply)) {
            return;
        }
        if (!ReportSchemeAssignService.checkSchemeAssgin((Long)yearId, (Long)versionId, (Long)datatypeId, (Long)schemeId).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6240\u5728\u7684\u65b9\u6848\u5df2\u53d6\u6d88\u4e0b\u8fbe\u3002", (String)"ApplyBgApplybillListPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (ReportSchemeService.getInstance().isSchemeClose(schemeId).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u6240\u5728\u7684\u65b9\u6848\u5df2\u5173\u95ed\u3002", (String)"ApplyBgApplybillListPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ApplyBillType applyBillType = isApply ? ApplyBillType.APPLY : ApplyBillType.COLLECY;
        BaseShowParameter baseShowParameter = BgApplyBillHelper.getInstance().getBgApplyTypeBillFormShow(schemeId, yearId, versionId, datatypeId, orgId, this.getModelId(), null, applyBillType);
        if (!isApply) {
            baseShowParameter.setCustomParam("collectOrgId", (Object)orgId);
        }
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setStatus(OperationStatus.ADDNEW);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, APPLY_ADD);
        baseShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private Boolean memberLimitAdd(boolean isApply, Long schemeId, Long orgId) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_rptscheme", (String)"bizrange", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)});
        if (object == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"ApplyBgApplybillListPlugin_10", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        Map viewsByBusModel = modelCache.getViewsByBusModel(Long.valueOf(object.getLong("bizrange.id")));
        Member member = modelCache.getMember("Entity", (Long)viewsByBusModel.get("Entity"), orgId);
        if (member == null) {
            return true;
        }
        if (isApply) {
            if (!member.isLeaf()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u672b\u7ea7\u7ec4\u7ec7\u65b0\u589e\u7533\u62a5\u5355\u636e\u3002", (String)"ApplyBgApplybillListPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                return true;
            }
        } else if (member.isLeaf()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5728\u975e\u672b\u7ea7\u7ec4\u7ec7\u65b0\u589e\u6c47\u603b\u5355\u636e\u3002", (String)"ApplyBgApplybillListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void billClosedCallBack(BillClosedCallBackEvent e) {
        String key = e.getCloseCallBack().getActionId();
        if (APPLY_ADD.equals(key)) {
            this.refleshRightBillList();
        }
    }

    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFBuilder qb = new QFBuilder();
        HashSet<String> billTypeSet = new HashSet<String>(16);
        billTypeSet.add("apply");
        billTypeSet.add("collect");
        qb.add("billtype", "in", billTypeSet);
        e.getCustomQFilters().addAll(qb.toList());
        log.info("setFilters:" + e.getCustomQFilters().toString());
    }

    private boolean validateAdd(String focusNode, boolean isApply) {
        String billtype = ApplyBillType.APPLY.getNumber();
        String tinfo = ApplyBillType.APPLY.getName();
        if (!isApply) {
            billtype = ApplyBillType.COLLECY.getNumber();
            tinfo = ApplyBillType.COLLECY.getName();
        }
        String[] focus = focusNode.split("_");
        QFBuilder qfBuilder = new QFBuilder("applyscheme", "=", (Object)IDUtils.toLong((Object)focus[3]));
        qfBuilder.add("datatype", "=", (Object)IDUtils.toLong((Object)focus[0]));
        qfBuilder.add("year", "=", (Object)IDUtils.toLong((Object)focus[1]));
        qfBuilder.add("version", "=", (Object)IDUtils.toLong((Object)focus[2]));
        qfBuilder.add("org.id", "=", (Object)IDUtils.toLong((Object)focus[4]));
        qfBuilder.add("billtype", "=", (Object)billtype);
        if (QueryServiceHelper.exists((String)"eb_bgapplybill", (QFilter[])qfBuilder.toArrays())) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u8be5\u7ec4\u7ec7\u5728\u8be5\u7ef4\u5ea6\u7ec4\u5408\u4e0b\u7684\u65b9\u6848\u4e2d\u5df2\u7ecf\u5b58\u5728\u201c%1\u201d\u3002", (String)"ApplyBgApplybillListPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{tinfo}));
            return true;
        }
        return false;
    }

    private void viewWorkFlow() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"ApplyBgApplybillListPlugin_6", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow row = (ListSelectedRow)selectedRows.iterator().next();
        Long key = Long.parseLong(row.getPrimaryKeyValue().toString());
        String billNo = row.getNumber();
        DynamicObject bill = QueryServiceHelper.queryOne((String)"eb_bgapplybill", (String)"billtype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)key)});
        String billType = bill.getString("billtype");
        CentralAppBillService.getInstance().viewWorkFlow(billNo, billType, this.getView());
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (!"unSubmit".equals(callBackId)) {
            return;
        }
        if (MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) {
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        OperateOption op = OperateOption.create();
        op.setVariableValue("currbizappid", "bgmd");
        op.setVariableValue("appnumber", "bgmd");
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"unsubmit", (String)"eb_bgapplybill", (Object[])selectedRows.getPrimaryKeyValues(), (OperateOption)op);
        if (!operationResult.isSuccess()) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u64a4\u9500\u5931\u8d25%1\u3002", (String)"ApplyBgApplybillListPlugin_11", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getErrMessage(operationResult)}));
        }
        log.info("BgApplyBillListPlugin.unSubmit: successful");
        this.refleshRightBillList();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f\u3002", (String)"ApplyBgApplybillListPlugin_7", (String)"epm-eb-formplugin", (Object[])new Object[0]));
    }

    private String getErrMessage(OperationResult operationResult) {
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        if (allErrorOrValidateInfo.size() > 0) {
            String message = ((IOperateInfo)allErrorOrValidateInfo.get(0)).getMessage();
            return message;
        }
        return "";
    }
}

