/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyBillAggHelper;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.applybill.util.BgApplyBillHelper;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.business.rejectbill.RejectBillService;
import kd.epm.eb.business.rejectbill.constant.RejectStatusEnum;
import kd.epm.eb.business.rejectbill.entity.RejectUserDto;
import kd.epm.eb.common.applybill.ApplyBillConstant;
import kd.epm.eb.common.applybill.ApplyBillEntityData;
import kd.epm.eb.common.applybill.ApplyBillEntityNodeData;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.applybill.BillFieldStatus;
import kd.epm.eb.common.applybill.BillSaveEventArgs;
import kd.epm.eb.common.applybill.BillVerifyResult;
import kd.epm.eb.common.applybill.ColumnsContext;
import kd.epm.eb.common.applybill.DetailMembBillData;
import kd.epm.eb.common.applybill.EntityCellBaseData;
import kd.epm.eb.common.applybill.EntityRowDataType;
import kd.epm.eb.common.applybill.MemberShowType;
import kd.epm.eb.common.applybill.RowDataStatus;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.BgApplyENtryInfo;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.applytemplatecolumn.FieldTypeEnum;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.centralapproval.ApproveMutex;
import kd.epm.eb.common.centralapproval.CentralAppShowInfo;
import kd.epm.eb.common.centralapproval.MutexLockInfo;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.applybill.BgApplyBillMultColTreePlugin;
import kd.epm.eb.formplugin.applybill.IApAuditBill;
import org.apache.commons.collections4.CollectionUtils;

public class BgCollectAuditBillPlugin
extends BgApplyBillMultColTreePlugin
implements SelectRowsEventListener,
IApAuditBill,
RowClickEventListener {
    @Override
    public Long getBillId() {
        return this.getCenBillId();
    }

    @Override
    public void initialize() {
        super.initialize();
        for (String entryKey : this.getEntryInfoFromFormParam().getEntryTemplateConfig().keySet()) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(entryKey);
            entryGrid.addSelectRowsListener((SelectRowsEventListener)this);
        }
    }

    @Override
    public void saveAttachment() {
        AttachmentPanel attachmentPanel = this.getAttachmentPanel();
        List attachmentData = attachmentPanel.getAttachmentData();
        Long billId = this.getBillId();
        HashMap<String, List> saveMap = new HashMap<String, List>(4);
        saveMap.put("attachmentpanelap", attachmentData);
        AttachmentServiceHelper.saveTempAttachments((String)"eb_centralappbill", (Object)billId, (String)ApplicationTypeEnum.BGMD.getAppnum(), saveMap);
    }

    @Override
    protected void getDataForSelectRows(String entityKey, int[] selectRows, int valLength, List<BaseColumn> main_columns, EntryTemplateConfig entryTemplateConfig, Set<String> currencyColumnKeys, BigDecimal unitData, List<Object[]> result) {
        ApplyBillEntityData entityData = this.getOrCacheBillEntityNodeData(entityKey, null).getCurrentNodeData();
        DetailMembBillData detailMembBillData = this.getSourceData(entityKey);
        Map detailRowStatus = detailMembBillData.getDetailRowStatus();
        String billNumber = this.getBillNumber();
        int fixLen = ApplyBillConstant.fixEntityTableKey.length;
        for (int rowIndex : selectRows) {
            DynamicObject rowObj = this.getModel().getEntryRowEntity(entityKey, rowIndex);
            Long rowId = rowObj.getLong("id");
            int rowIndexForCacheData = entityData.getRowIndexByRowId(rowId);
            Object[] rowVal = new Object[valLength];
            rowVal[0] = rowId;
            rowVal[1] = this.billType;
            rowVal[2] = billNumber;
            rowVal[3] = EntityRowDataType.EDIT_DETAIL.getNumber();
            ArrayList<Long> dimKeyList = new ArrayList<Long>(10);
            for (int i = 0; i < main_columns.size(); ++i) {
                BaseColumn column = main_columns.get(i);
                String columnKey = column.getKey();
                if (entryTemplateConfig.getDimKeysList().contains(columnKey)) {
                    Long memberId = entityData.getCellBaseData(rowIndexForCacheData, columnKey).getId();
                    rowVal[i + fixLen] = memberId;
                    dimKeyList.add(memberId);
                    continue;
                }
                Object o = rowObj.get(columnKey);
                if (column.getFieldtype() == FieldTypeEnum.BaseDataField) {
                    if (o == null) {
                        rowVal[i + fixLen] = 0L;
                        continue;
                    }
                    rowVal[i + fixLen] = ((DynamicObject)o).getPkValue();
                    continue;
                }
                rowVal[i + fixLen] = o;
            }
            String dimKey = org.apache.commons.lang3.StringUtils.join(dimKeyList, (String)",");
            RowDataStatus rowDataStatus = (RowDataStatus)detailRowStatus.get(dimKey);
            if (rowDataStatus == null || !rowDataStatus.isDetail()) {
                rowVal[3] = EntityRowDataType.EDIT_NOTDETAIL.getNumber();
            }
            result.add(rowVal);
        }
    }

    @Override
    protected void doCheckBeforeSave(BillVerifyResult verifyResult) {
        super.doCheckBeforeSave(verifyResult);
        this.checkMutexLock(verifyResult);
        this.checkMainBillSave(verifyResult);
    }

    private void checkMutexLock(BillVerifyResult verifyResult) {
        String mutexInfoStr;
        if (verifyResult.isSuccess() && StringUtils.isNotEmpty((CharSequence)(mutexInfoStr = (String)this.getView().getFormShowParameter().getCustomParam("mutexInfo")))) {
            MutexLockInfo mutexLockInfo = (MutexLockInfo)SerializationUtils.fromJsonString((String)mutexInfoStr, MutexLockInfo.class);
            ApproveMutex approveMutexes = ApproveBillUtil.getInstance().getApproveMutexes(mutexLockInfo.getBillNo(), mutexLockInfo.getCurNode(), mutexLockInfo.getUserId(), mutexLockInfo.getUniqueKey());
            if (approveMutexes == null) {
                verifyResult.addResutInfo(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u3002", (String)"", (String)"", (Object[])new Object[0]));
                verifyResult.setSuccess(false);
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        if (opKey.startsWith("rejectrow")) {
            this.rejectSelectedRows();
        }
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        super.selectRowsChange(evt);
        this.setAttachments();
    }

    @Override
    protected Long getOwnerBillId() {
        IFormView view = this.getView();
        if (view == null) {
            return 0L;
        }
        if (view.getParentView() == null) {
            return 0L;
        }
        if (view.getParentView().getModel() == null) {
            return 0L;
        }
        return IDUtils.toLong((Object)view.getParentView().getModel().getValue("id"));
    }

    @Override
    protected List<Long> getOtherBillIds() {
        ArrayList<Long> relationIds = new ArrayList<Long>(16);
        Set<String> numbers = this.getSelectedRowBillNumbers();
        if (CollectionUtils.isEmpty(numbers)) {
            return relationIds;
        }
        Map<Object, DynamicObject> dynamicObjectMap = this.queryApplyBill(numbers);
        Map<Object, DynamicObject> dynamicObjectMap1 = this.queryCenApplyBill(numbers);
        for (Map.Entry<Object, DynamicObject> entry : dynamicObjectMap.entrySet()) {
            relationIds.add(IDUtils.toLong((Object)entry.getKey().toString()));
        }
        for (Map.Entry<Object, DynamicObject> entry : dynamicObjectMap1.entrySet()) {
            relationIds.add(IDUtils.toLong((Object)entry.getKey().toString()));
        }
        return relationIds;
    }

    private void rejectSelectedRows() {
        Tab tab = (Tab)this.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        String entityName = currentTab.replaceAll("tabentryentity", "entryentity");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entityName);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9a73\u56de\u8bb0\u5f55\u3002", (String)"BgApplyBillPlugin_40", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        EntryTemplateConfig tempConfig = this.getTempConfig(entityName);
        List allLog = RejectBillService.getInstance().listRejectLogBySpnumber(this.getBillNumber(), Long.valueOf(tempConfig.getTemplateID()));
        List rejectLogs = allLog.stream().filter(e -> RejectStatusEnum.reject.getCode().equals(e.getRejectStatus())).collect(Collectors.toList());
        List rejectLogArrayList = rejectLogs.stream().map(e -> (List)SerializationUtils.fromJsonString((String)e.getDataJson(), List.class)).collect(Collectors.toList());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entityName);
        List entryColumns = tempConfig.getEntryColumns();
        List dimCols = entryColumns.stream().filter(t -> StringUtils.isNotEmpty((CharSequence)t.getBaseEntityId())).collect(Collectors.toList());
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        Map dimViewMap = modelCacheHelper.getViewsByDataSet(Long.valueOf(tempConfig.getDatasetId()));
        ArrayList<String> hasRejectChildRowIndex = new ArrayList<String>(16);
        BaseColumn baseColumn = entryColumns.stream().filter(t -> t.getKey().startsWith(ApplyTemplateUtils.FIELD_REJECT_STATUS)).findFirst().orElse(null);
        List baseColumns = entryColumns.stream().filter(t -> !t.getKey().endsWith("_text") && !t.isIgnoreDB()).collect(Collectors.toList());
        ArrayList<String> hasRejectRowIndex = new ArrayList<String>(16);
        ArrayList<String> notSaveRowIndex = new ArrayList<String>(16);
        ArrayList<String> inCompleteRowIndex = new ArrayList<String>(16);
        ArrayList<String> hasSubtotalRowIndex = new ArrayList<String>(16);
        for (int selectRow : selectRows) {
            Object rejectStatus;
            boolean subtotalstatus;
            String rowIndexStr = selectRow + 1 + "";
            DynamicObject entryRowEntity = (DynamicObject)entryEntity.get(selectRow);
            if (entryRowEntity == null) {
                notSaveRowIndex.add(rowIndexStr);
                continue;
            }
            long id = entryRowEntity.getLong("id");
            if (IDUtils.isEmptyLong((Long)id).booleanValue()) {
                notSaveRowIndex.add(rowIndexStr);
            }
            if (subtotalstatus = entryRowEntity.getBoolean(tempConfig.getSubtotalKey())) {
                hasSubtotalRowIndex.add(rowIndexStr);
            }
            if (baseColumn != null && StringUtils.equals((CharSequence)(rejectStatus = (Object)entryRowEntity.getString(baseColumn.getKey())), (CharSequence)RejectStatusEnum.reject.getDesc())) {
                hasRejectRowIndex.add(rowIndexStr);
            }
            rejectStatus = selectRows;
            int n = ((int[])rejectStatus).length;
            for (int i = 0; i < n; ++i) {
                int row = rejectStatus[i];
                if (selectRow == row) continue;
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(row);
                for (BaseColumn dimCol : dimCols) {
                    String key = dimCol.getKey();
                    long selectDimColMemberId = dynamicObject.getDynamicObject(key).getLong("id");
                    DynamicObject memberObj = entryRowEntity.getDynamicObject(key);
                    long memberId = memberObj.getLong("id");
                    DynamicObject dimension = memberObj.getDynamicObject("dimension");
                    String number = dimension.getString("number");
                    Member member = modelCacheHelper.getMember(number, (Long)dimViewMap.get(number), Long.valueOf(memberId));
                    ArrayList<Long> childIds = new ArrayList<Long>(16);
                    this.getAllMemberChildren(member, childIds);
                    if (!childIds.contains(selectDimColMemberId)) continue;
                    this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6570\u636e\u4e0d\u5141\u8bb8\u4e0e\u5176\u4e0a\u7ea7\u6570\u636e\u540c\u65f6\u9a73\u56de\u3002", (String)"BgCollectAuditBillPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[]{row + 1}));
                    return;
                }
            }
            HashSet<Long> rejectDimCombinationAll = new HashSet<Long>(16);
            for (BaseColumn column : baseColumns) {
                String baseEntityId = column.getBaseEntityId();
                String key = column.getKey();
                if (StringUtils.isEmpty((CharSequence)baseEntityId)) continue;
                DynamicObject dimMemberObj = entryRowEntity.getDynamicObject(key);
                if (dimMemberObj == null) {
                    inCompleteRowIndex.add(rowIndexStr);
                    break;
                }
                rejectDimCombinationAll.add(dimMemberObj.getLong("id"));
                String dimNum = dimMemberObj.getString("dimension.number");
                String memberNum = dimMemberObj.getString("number");
                List members = modelCacheHelper.getMember(dimNum, (Long)dimViewMap.get(dimNum), memberNum, RangeEnum.ALL.getIndex());
                rejectDimCombinationAll.addAll(members.stream().map(BaseCache::getId).collect(Collectors.toSet()));
            }
            boolean flag = true;
            if (CollectionUtils.isEmpty(rejectLogArrayList)) {
                flag = false;
            }
            block4: for (List objects : rejectLogArrayList) {
                for (Object object : objects) {
                    if (!(object instanceof Map)) continue;
                    for (BaseColumn column : baseColumns) {
                        Map map;
                        Object o;
                        String baseEntityId = column.getBaseEntityId();
                        String key = column.getKey();
                        if (StringUtils.isEmpty((CharSequence)baseEntityId) || !((o = (map = (Map)object).get(key)) instanceof Long)) continue;
                        Long memberId = IDUtils.toLong(o);
                        if (rejectDimCombinationAll.contains(memberId)) break;
                        flag = false;
                        break;
                    }
                    if (flag) continue;
                    continue block4;
                }
            }
            if (!flag) continue;
            hasRejectChildRowIndex.add(rowIndexStr);
        }
        if (CollectionUtils.isNotEmpty(inCompleteRowIndex)) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6570\u636e\u7ef4\u5ea6\u4e0d\u5b8c\u6574\uff0c\u4e0d\u80fd\u8fdb\u884c\u9a73\u56de\u3002", (String)"BgCollectAuditBillPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", inCompleteRowIndex)}));
            return;
        }
        if (CollectionUtils.isNotEmpty(notSaveRowIndex)) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u4e0d\u80fd\u8fdb\u884c\u9a73\u56de\u3002", (String)"BgCollectAuditBillPlugin_1", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", notSaveRowIndex)}));
            return;
        }
        if (CollectionUtils.isNotEmpty(hasRejectRowIndex)) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6570\u636e\u5df2\u9a73\u56de\uff0c\u65e0\u6cd5\u91cd\u590d\u9a73\u56de\u3002", (String)"BgCollectAuditBillPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", hasRejectRowIndex)}));
            return;
        }
        if (CollectionUtils.isNotEmpty(hasRejectChildRowIndex)) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6570\u636e\u5b58\u5728\u5df2\u9a73\u56de\u7684\u4e0b\u7ea7\u6570\u636e\uff0c\u4e0d\u80fd\u8fdb\u884c\u9a73\u56de\u3002", (String)"BgCollectAuditBillPlugin_3", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", hasRejectChildRowIndex)}));
            return;
        }
        if (CollectionUtils.isNotEmpty(hasSubtotalRowIndex)) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"\u7b2c%1\u884c\u6570\u636e\u662f\u5c0f\u8ba1\u884c\uff0c\u4e0d\u80fd\u8fdb\u884c\u9a73\u56de\u3002", (String)"BgCollectAuditBillPlugin_5", (String)"epm-eb-formplugin", (Object[])new Object[]{String.join((CharSequence)",", hasSubtotalRowIndex)}));
            return;
        }
        this.cacheModifyRowIds(entityName, selectRows);
        long l = System.currentTimeMillis();
        List<RejectUserDto> rejectUserList = this.getRejectUserList(entityName);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_billrejectuserlist");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("rejectUser", (Object)SerializationUtils.serializeToBase64(rejectUserList));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "eb_billrejectuserlist"));
        this.getView().showForm(formShowParameter);
    }

    private void cacheModifyRowIds(String entityName, int[] selectRows) {
        BgApplyENtryInfo entryInfoFromFormParam = this.getEntryInfoFromFormParam();
        Map entryTemplateConfig = entryInfoFromFormParam.getEntryTemplateConfig();
        EntryTemplateConfig tempConfig = (EntryTemplateConfig)entryTemplateConfig.get(entityName);
        HashMap<Integer, List> modifyDataMap = new HashMap<Integer, List>(16);
        for (int i = 0; i < selectRows.length; ++i) {
            int selectRow = selectRows[i];
            Map<String, String> colMemberMap = this.buildSingleColMemberNumberMap(tempConfig, entityName, selectRow);
            DetailMembBillData detailMembBillData = this.getSourceData(entityName);
            HashSet rejectRowDetailRowDataIndex = new HashSet(16);
            rejectRowDetailRowDataIndex.addAll(ApplyBillAggHelper.getInstance().getRejectRowModifyRowDataIndex(colMemberMap, tempConfig.getDimKeysList(), tempConfig.getColumnIndex(), detailMembBillData));
            List allRowData = detailMembBillData.getAllRowData();
            List modifyRowDataList = modifyDataMap.computeIfAbsent(i, t -> new ArrayList(16));
            for (Integer index : rejectRowDetailRowDataIndex) {
                Object[] objects = (Object[])allRowData.get(index);
                modifyRowDataList.add(objects);
            }
        }
        this.getPageCache().put("modifyRowDataMap", SerializationUtils.serializeToBase64(modifyDataMap));
    }

    private Map<Long, Map<String, String>> buildColMemberNumberMap(EntryTemplateConfig tempConfig, String entityName, int[] selectRows) {
        HashMap<Long, Map<String, String>> result = new HashMap<Long, Map<String, String>>(16);
        if (tempConfig == null) {
            return result;
        }
        List mainColumns = tempConfig.getEntryColumns().stream().filter(ee -> StringUtils.isNotEmpty((CharSequence)ee.getKey()) && !ee.getKey().endsWith("_text")).collect(Collectors.toList());
        for (int selectRow : selectRows) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(entityName, selectRow);
            if (entryRowEntity == null) continue;
            Map map = result.computeIfAbsent(Long.valueOf(selectRow), t -> new HashMap(16));
            for (BaseColumn mainColumn : mainColumns) {
                DynamicObject dynamicObject;
                String baseEntityId = mainColumn.getBaseEntityId();
                if (StringUtils.isEmpty((CharSequence)baseEntityId) || (dynamicObject = entryRowEntity.getDynamicObject(mainColumn.getKey())) == null) continue;
                String number = dynamicObject.getString("number");
                map.put(mainColumn.getKey(), number);
            }
        }
        return result;
    }

    private Map<String, String> buildSingleColMemberNumberMap(EntryTemplateConfig tempConfig, String entityName, int selectRow) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        List mainColumns = tempConfig.getEntryColumns().stream().filter(ee -> !ee.getKey().endsWith("_text")).collect(Collectors.toList());
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(entityName, selectRow);
        for (BaseColumn mainColumn : mainColumns) {
            String baseEntityId = mainColumn.getBaseEntityId();
            if (StringUtils.isEmpty((CharSequence)baseEntityId)) continue;
            String number = entryRowEntity.getDynamicObject(mainColumn.getKey()).getString("number");
            result.put(mainColumn.getKey(), number);
        }
        return result;
    }

    private List<RejectUserDto> getRejectUserList(String entityName) {
        Object billNo = this.getView().getParentView().getModel().getValue("billno");
        List<Map<String, String>> rejectDataList = this.getSelectedMemberScope(entityName);
        List<Map<String, String>> rejectDataAllLowLevelList = this.getSelectedAllLowerLeveList(rejectDataList, entityName);
        EntryTemplateConfig entryTemplateConfig = (EntryTemplateConfig)this.getEntryInfoFromFormParam().getEntryTemplateConfig().get(entityName);
        List<RejectUserDto> rejectUserList = RejectBillService.getInstance().getRejectUserList(billNo.toString(), rejectDataList, rejectDataAllLowLevelList, this.getModelId(), this.getDatasetId(entityName), entryTemplateConfig);
        rejectUserList = this.filterRejectUser(rejectUserList, entityName, entryTemplateConfig);
        return rejectUserList;
    }

    private List<Map<String, String>> getSelectedAllLowerLeveList(List<Map<String, String>> rejectDataList, String entityName) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(16);
        EntryTemplateConfig entryTemplateConfig = (EntryTemplateConfig)this.getEntryInfoFromFormParam().getEntryTemplateConfig().get(entityName);
        Map hiddenDimMemMap = entryTemplateConfig.getHiddenDimMemMap();
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        Map viewIds = modelCacheHelper.getViewsByDataSet(Long.valueOf(entryTemplateConfig.getDatasetId()));
        for (Map<String, String> map : rejectDataList) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String dimNumber = entry.getKey();
                String memberNumber = entry.getValue();
                if (hiddenDimMemMap.containsKey(dimNumber)) continue;
                Member member = modelCacheHelper.getMember(dimNumber, (Long)viewIds.get(dimNumber), memberNumber);
                ArrayList<Member> children = new ArrayList<Member>(16);
                this.getAllChildrenMember(member, children);
                if (CollectionUtils.isEmpty(children)) continue;
                for (Member child : children) {
                    HashMap<String, String> childrenMap = new HashMap<String, String>(16);
                    childrenMap.put(child.getDimension().getNumber(), child.getNumber());
                    for (Map.Entry<String, String> entry1 : map.entrySet()) {
                        String key = entry1.getKey();
                        String value = entry1.getValue();
                        if (StringUtils.equals((CharSequence)value, (CharSequence)memberNumber) && StringUtils.equals((CharSequence)key, (CharSequence)dimNumber)) continue;
                        childrenMap.put(key, value);
                    }
                    result.add(childrenMap);
                }
            }
        }
        return result;
    }

    private void getAllChildrenMember(Member member, List<Member> children) {
        if (member == null) {
            return;
        }
        if (member.isLeaf()) {
            return;
        }
        List memberChildren = member.getChildren();
        for (Member memberChild : memberChildren) {
            children.add(memberChild);
            this.getAllChildrenMember(memberChild, children);
        }
    }

    private Set<String> getSelectedRowBillNumbers() {
        HashSet<String> numbers = new HashSet<String>(16);
        String currentEntityKey = this.getCurrentEntityKey();
        EntryGrid entryGrid = (EntryGrid)this.getControl(currentEntityKey);
        int[] selectRows = entryGrid.getSelectRows();
        BgApplyENtryInfo entryInfoFromFormParam = this.getEntryInfoFromFormParam();
        Map entryTemplateConfigMap = entryInfoFromFormParam.getEntryTemplateConfig();
        EntryTemplateConfig tempConfig = (EntryTemplateConfig)entryTemplateConfigMap.get(currentEntityKey);
        Map<Long, Map<String, String>> colMemberMapMap = this.buildColMemberNumberMap(tempConfig, currentEntityKey, selectRows);
        DetailMembBillData detailMembBillData = this.getSourceData(currentEntityKey);
        if (detailMembBillData == null) {
            return numbers;
        }
        HashSet rejectRowDetailRowDataIndex = new HashSet(16);
        for (Map.Entry<Long, Map<String, String>> entry : colMemberMapMap.entrySet()) {
            Map<String, String> colMemberMap = entry.getValue();
            rejectRowDetailRowDataIndex.addAll(ApplyBillAggHelper.getInstance().getRejectRowModifyRowDataIndex(colMemberMap, tempConfig.getDimKeysList(), tempConfig.getColumnIndex(), detailMembBillData));
        }
        List allRowData = detailMembBillData.getAllRowData();
        for (Integer index : rejectRowDetailRowDataIndex) {
            Object[] objects = (Object[])allRowData.get(index);
            if (objects == null || objects[2] == null) continue;
            String billNumber = objects[2].toString();
            numbers.add(billNumber);
        }
        return numbers;
    }

    @Override
    protected void addCustomInfoToTempConfig(EntryTemplateConfig mainEntrytemplateConfig, String entryNumber) {
        super.addCustomInfoToTempConfig(mainEntrytemplateConfig, entryNumber);
        mainEntrytemplateConfig.getRowDimNums().forEach(rowDimNum -> {
            SysDimensionEnum dimensionEnum = SysDimensionEnum.getEnumByNumber((String)rowDimNum);
            if (dimensionEnum == null || dimensionEnum == SysDimensionEnum.Entity || dimensionEnum == SysDimensionEnum.Account || "epm_userdefinedmembertree".equals(dimensionEnum.getMemberTreemodel())) {
                mainEntrytemplateConfig.getAdjDetailDimNums().add(rowDimNum);
            }
        });
    }

    @Override
    protected void addCustomColumn(ColumnsContext columnsContext) {
        super.addCustomColumn(columnsContext);
        this.addAuditCustomColumn(columnsContext);
    }

    @Override
    protected void setColumnStatus(BillFieldStatus fieldStatus) {
        super.setColumnStatus(fieldStatus);
        this.addLog("collectaudit:showinfo", SerializationUtils.toJsonString((Object)this.getCentralAppShowInfo()));
        this.filterMetricCol4AuditBill(fieldStatus, this.getCentralAppShowInfo());
    }

    @Override
    protected void getRejectLog(Object[] rowData, String entityName, DynamicObject log) {
        if (rowData[3].equals(EntityRowDataType.EDIT_NOTDETAIL.getNumber())) {
            DetailMembBillData detailMembBillData = this.getSourceData(entityName);
            EntryTemplateConfig templateConfig = (EntryTemplateConfig)this.getEntryInfoFromFormParam().getEntryTemplateConfig().get(entityName);
            String rejectDimKey = RejectBillService.getInstance().getDimKeyByData(rowData, templateConfig);
            BigDecimal unitData = this.getUnitData(templateConfig.getUnit());
            unitData = BigDecimal.ONE.divide(unitData);
            for (Object[] row : detailMembBillData.getAllRowData()) {
                String rowDimKey = RejectBillService.getInstance().getDimKeyByData(row, templateConfig);
                if (!rejectDimKey.equals(rowDimKey)) continue;
                int fixLen = ApplyBillConstant.fixEntityTableKey.length;
                Set currencyColumnKeys = templateConfig.getCurrencyColumnKeys();
                List mainColumns = templateConfig.getEntryColumns().stream().filter(ee -> !ee.getKey().endsWith("_text")).collect(Collectors.toList());
                for (BaseColumn column : mainColumns) {
                    if (currencyColumnKeys.contains(column.getKey())) {
                        row[fixLen] = this.changeValByDivideUnit(row[fixLen], unitData);
                    }
                    ++fixLen;
                }
                log.set("summarydatajson", (Object)JSON.toJSONString((Object)row));
                break;
            }
        }
    }

    @Override
    public boolean isLockNotDetail(EntryTemplateConfig templateConfig, String entryKey, String dimNum, String dimKey, DynamicObject rowObj) {
        if (templateConfig.getAdjDetailDimNums().contains(dimNum) && rowObj != null) {
            int rowIndexOnCahce;
            Long rowId = rowObj.getLong("id");
            ApplyBillEntityNodeData entityNodeData = this.getOrCacheBillEntityNodeData(entryKey, null);
            ApplyBillEntityData currentNodeData = entityNodeData.getCurrentNodeData();
            EntityCellBaseData cellBaseData = currentNodeData.getCellBaseData(rowIndexOnCahce = currentNodeData.getRowIndexByRowId(rowId), dimKey);
            if (cellBaseData != null && !cellBaseData.isLeaf()) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void initSetRowRejectTxt() {
        Map entryTemplateConfigMap = this.getEntryInfoFromFormParam().getEntryTemplateConfig();
        for (Map.Entry entry : entryTemplateConfigMap.entrySet()) {
            String entityName = (String)entry.getKey();
            if (entityName.startsWith("bizentryentity")) continue;
            EntryTemplateConfig templateConfig = (EntryTemplateConfig)entry.getValue();
            List mainColumn = templateConfig.getEntryColumns();
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entityName);
            ApplyBillEntityData entityData = this.getOrCacheBillEntityNodeData(entityName, null).getCurrentNodeData();
            IModelCacheHelper iModelCacheHelper = this.getIModelCacheHelper();
            List logs = RejectBillService.getInstance().listRejectLogBySpnumber(this.getBillNumber(), Long.valueOf(templateConfig.getTemplateID()));
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject row = (DynamicObject)entryEntity.get(i);
                Long rowId = row.getLong("id");
                ArrayList<Long> dimMemberIdList = new ArrayList<Long>(10);
                for (BaseColumn column : mainColumn) {
                    int rowIndexForCacheData;
                    EntityCellBaseData cellBaseData;
                    String columnKey = column.getKey();
                    if (!templateConfig.getDimKeysList().contains(columnKey) || (cellBaseData = entityData.getCellBaseData(rowIndexForCacheData = entityData.getRowIndexByRowId(rowId), columnKey)) == null) continue;
                    Long memberId = cellBaseData.getId();
                    dimMemberIdList.add(memberId);
                }
                String rejectStatusTxt = RejectBillService.getInstance().getRejectStatusTxtByRowDimKey(StringUtils.join(dimMemberIdList, (String)","), templateConfig, logs);
                Optional<String> opt = mainColumn.stream().map(BaseColumn::getKey).filter(e -> e.startsWith(ApplyTemplateUtils.FIELD_REJECT_STATUS)).findFirst();
                if (!opt.isPresent()) continue;
                if (StringUtils.isEmpty((CharSequence)rejectStatusTxt)) {
                    rejectStatusTxt = ((DynamicObject)entryEntity.get(i)).getString(ApplyTemplateUtils.FIELD_REJECT_STATUS + entityName.replace("entryentity", "") + "_text");
                }
                this.setRowRejectStatus(rejectStatusTxt, entityName, i, entryEntity, mainColumn, iModelCacheHelper, logs);
            }
        }
    }

    @Override
    protected void afterInitEntityData() {
        super.afterInitEntityData();
        CentralAppShowInfo centralAppShowInfo = this.getCentralAppShowInfo();
        this.selectRowDimEnableMemb(centralAppShowInfo);
        this.initAdjustRecord(this.getCentralAppShowInfo(), this.getEntryInfoFromFormParam());
    }

    @Override
    protected void setCellsStatus(BillFieldStatus fieldStatus) {
        super.setCellsStatus(fieldStatus);
        this.lockRowByDetailAt();
    }

    @Override
    protected void reloadEntityData() {
        super.reloadEntityData();
    }

    @Override
    protected void afterOpenChildRow(List<Integer> rowNums, String entityKey) {
        super.afterOpenChildRow(rowNums, entityKey);
        this.lockRowByRowDim(rowNums, entityKey);
        this.lockRowByDetailAt(entityKey, rowNums);
        this.setAdjustedColumnSign(entityKey, this.getTempConfig(entityKey), rowNums);
    }

    @Override
    protected void afterReloadEntityData(String entityKey, EntryTemplateConfig templateConfig, List<Integer> rowsIndex) {
        super.afterReloadEntityData(entityKey, templateConfig, rowsIndex);
        if (this.isMainEntry(entityKey)) {
            int[] indexs = CommonServiceHelper.changeIntArrays(rowsIndex);
            this.lockCellsByRows(entityKey, indexs, true, true);
            this.lockRowByRowDim(rowsIndex, entityKey);
            this.lockRowByDetailAt(entityKey, rowsIndex);
            this.setAdjustedColumnSign(entityKey, templateConfig, rowsIndex);
        }
    }

    private void lockRowByRowDim(List<Integer> rowNums, String entityKey) {
        Map rowDimContrlMembs = this.getOrCacheRowDimContrlMemb(null);
        EntryTemplateConfig tempConfig = this.getTempConfig(entityKey);
        List toLockRow = this.getLockRowIndex(rowNums, tempConfig, entityKey, rowDimContrlMembs);
        if (this.getLogSignsFromForm().contains("lockRowByRowDim")) {
            log.info("lockRowByRowDim:" + toLockRow.toString());
        }
        if (toLockRow.size() > 0) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(entityKey);
            entryGrid.setRowLock(true, CommonServiceHelper.changeIntArrays((Collection)toLockRow));
        }
    }

    @Override
    protected List<Long> getTempIdsFromFormParam(FormShowParameter formShowParameter) {
        return this.queryTempIdsByAuditConfig(formShowParameter);
    }

    @Override
    public void dealPropertyChanged(PropertyChangedArgs e) {
        this.dealDimColumnChange4CollectBill(e);
        this.dealDimTextColumnChange(e);
    }

    @Override
    protected void initBillBaseInfo() {
        super.initBillBaseInfo();
        this.setAuditTypeBillBaseInfo();
    }

    @Override
    protected void setButtonStatus(BillFieldStatus fieldStatus) {
        super.setButtonStatus(fieldStatus);
        fieldStatus.addShowKeys(new String[]{"statistics"});
        this.setAuditTypeBillBtnStatus(fieldStatus);
    }

    @Override
    protected void setFieldStatus(BillFieldStatus fieldStatus) {
        super.setFieldStatus(fieldStatus);
        fieldStatus.addHideKeys(new String[]{"proposer", "applydate", "org"});
    }

    @Override
    protected void setOtherControlStatus(BillFieldStatus fieldStatus) {
        super.setOtherControlStatus(fieldStatus);
        this.dealDisableDimMemb(fieldStatus, this.getEntryInfoFromFormParam());
        this.setAdjustedColumnSign(this.getEntryInfoFromFormParam());
    }

    @Override
    protected Map<String, List<Object[]>> getBillDataFromDB(BgApplyENtryInfo bgApplyENtryInfo) {
        CentralAppShowInfo showInfo = this.getCentralAppShowInfo();
        CommonServiceHelper.handleLog((Log)log, (String)("getBillData:" + this.getBillNumber()), (String)SerializationUtils.toJsonString((Object)showInfo));
        return BgApplyBillUtils.getInstance().getAuditBillDataNew(showInfo, this.getBillNumber(), bgApplyENtryInfo.getEntryTemplateConfig(), false, false);
    }

    @Override
    protected void beforeFinishSaveData(BillSaveEventArgs saveEventArgs) {
        super.beforeFinishSaveData(saveEventArgs);
        this.saveAuditRecord(this.getEntryInfoFromFormParam(), saveEventArgs.getAllChangeRecord(), this.getIModelCacheHelper(), this.getView().getFormShowParameter());
    }

    @Override
    protected BaseShowParameter getStatsShowParameter() {
        CentralAppShowInfo centralAppShowInfo = this.getCentralAppShowInfo();
        BaseShowParameter baseShowParameter = BgApplyBillHelper.getInstance().openAuditForm(centralAppShowInfo, ApplyBillType.COLLECTAUDITSTATISTICS.getNumber(), true);
        return baseShowParameter;
    }

    @Override
    protected void setMemberShowInfoBtnStatus(BillFieldStatus fieldStatus) {
        fieldStatus.addHideKeys(new String[]{"btn_changeshow0", "btn_changeshow1", "btn_changeshow2"});
    }

    @Override
    protected String getMemberShowTypeNumber() {
        return "changemembershow";
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        Object operateSource = afterDoOperationEventArgs.getSource();
        if (operateSource instanceof Donothing) {
            Donothing operate = (Donothing)operateSource;
            String operateKey = operate.getOperateKey();
            if (!operateKey.contains(this.getMemberShowTypeNumber())) {
                return;
            }
            String showType = operateKey.replace(this.getMemberShowTypeNumber(), "");
            MemberShowType showTypeEnum = MemberShowType.getEnumByValue((String)showType);
            if (showTypeEnum == null || showTypeEnum == this.getMemberShowType()) {
                return;
            }
            this.getView().getPageCache().put("memberShowType", showType);
            this.showMemberInfo();
        }
    }
}

