/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.applybill.util.BgApplyBillHelper;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.common.applybill.ApplyBillConstant;
import kd.epm.eb.common.applybill.ApplyBillEntityData;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.applybill.BillFieldStatus;
import kd.epm.eb.common.applybill.BillSaveEventArgs;
import kd.epm.eb.common.applybill.BillVerifyResult;
import kd.epm.eb.common.applybill.EntityCellBaseData;
import kd.epm.eb.common.applytemplatecolumn.BgApplyENtryInfo;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.centralapproval.CentralAppChain;
import kd.epm.eb.common.centralapproval.CentralAppShowInfo;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.applybill.BgApplyBillMultColTreePlugin;
import kd.epm.eb.formplugin.applybill.IApApplyCollectBill;
import kd.epm.eb.formplugin.applybill.IApAuditBill;

public class BgCollectBillPlugin
extends BgApplyBillMultColTreePlugin
implements IApApplyCollectBill,
IApAuditBill {
    @Override
    public void dealPropertyChanged(PropertyChangedArgs e) {
        this.dealCollectOrgChange(e);
        this.dealDimColumnChange4CollectBill(e);
        this.dealDimTextColumnChange(e);
    }

    @Override
    protected void afterInitEntityData() {
        super.afterInitEntityData();
        this.initAdjustRecord(this.getCentralAppShowInfo(), this.getEntryInfoFromFormParam());
    }

    @Override
    protected List<Long> getTempIdsFromFormParam(FormShowParameter formShowParameter) {
        return this.queryTempIdsByScheme(formShowParameter);
    }

    private void dealCollectOrgChange(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("collectorg".equals(name)) {
            ChangeData[] changeSet = e.getChangeSet();
            DynamicObject dy = (DynamicObject)changeSet[0].getOldValue();
            if (dy == null) {
                this.updateCollectBillEntity();
            } else {
                this.getPageCache().put("oldOrg", dy.getString("id"));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u6c47\u603b\u7ec4\u7ec7\u5c06\u6e05\u9664\u6570\u636e\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"BgApplyBillPlugin_80", (String)"epm-eb-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("orgPropChange", (IFormPlugin)this));
            }
        }
    }

    @Override
    protected void doCheckBeforeSave(BillVerifyResult verifyResult) {
        super.doCheckBeforeSave(verifyResult);
        this.checkCollectOrg(verifyResult);
        this.checkBillExist(verifyResult);
        this.checkBillNumberRepeat(verifyResult);
    }

    private void checkCollectOrg(BillVerifyResult verifyResult) {
        Long currentOrgId = this.getCurrentCollectOrg();
        if (currentOrgId == null) {
            verifyResult.setSuccess(false);
            verifyResult.addResutInfo(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6c47\u603b\u7ec4\u7ec7\u3002", (String)"BgApplyBillPlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    private void updateCollectBillEntity() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("collectorg");
        this.clearEntryData();
        this.reloadEntityData();
    }

    private void setAuditPath(CentralAppChain chain) {
        String string = SerializationUtils.toJsonString((Object)chain);
        this.getModel().setValue("auditpath", (Object)string);
    }

    @Override
    protected void afterReloadEntityData(String entityKey, EntryTemplateConfig templateConfig, List<Integer> rowsIndex) {
        super.afterReloadEntityData(entityKey, templateConfig, rowsIndex);
        if (this.isMainEntry(entityKey)) {
            int[] indexs = CommonServiceHelper.changeIntArrays(rowsIndex);
            this.lockCellsByRows(entityKey, indexs, true, true);
            this.lockRowByDetailAt(entityKey, rowsIndex);
            this.lockNotDetailRow(rowsIndex, entityKey);
            this.setAdjustedColumnSign(entityKey, templateConfig, rowsIndex);
        }
    }

    @Override
    protected void afterOpenChildRow(List<Integer> rowNums, String entityKey) {
        super.afterOpenChildRow(rowNums, entityKey);
        this.lockRowByDetailAt(entityKey, rowNums);
        this.lockNotDetailRow(rowNums, entityKey);
        this.setAdjustedColumnSign(entityKey, this.getTempConfig(entityKey), rowNums);
    }

    private void lockNotDetailRow(List<Integer> rowNums, String entityKey) {
        if (rowNums.isEmpty()) {
            return;
        }
        ApplyBillEntityData currentNodeData = this.getOrCacheBillEntityNodeData(entityKey, null).getCurrentNodeData();
        BillFieldStatus billFieldStatus = new BillFieldStatus();
        for (int index : rowNums) {
            if (this.isDetailRow(entityKey, index, currentNodeData)) continue;
            billFieldStatus.addLockRow(entityKey, index);
        }
        this.handleFieldUpdate(billFieldStatus);
    }

    private void selectLockRow4NoDetail(BillFieldStatus billFieldStatus) {
        this.getEntryInfoFromFormParam().getEntryTemplateConfig().forEach((entryKey, tempConfig) -> {
            int entryRowCount;
            if (this.isMainEntry((String)entryKey) && (entryRowCount = this.getModel().getEntryRowCount(entryKey)) > 0) {
                ApplyBillEntityData currentNodeData = this.getOrCacheBillEntityNodeData((String)entryKey, null).getCurrentNodeData();
                for (int index = 0; index < entryRowCount; ++index) {
                    if (this.isDetailRow((String)entryKey, index, currentNodeData)) continue;
                    billFieldStatus.addLockRow(entryKey, index);
                }
            }
        });
    }

    private boolean isDetailRow(String entryKey, int rowIndex, ApplyBillEntityData currentNodeData) {
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(entryKey, rowIndex);
        if (entryRowEntity != null) {
            Long rowId = entryRowEntity.getLong("id");
            int rowIndexByRowId = currentNodeData.getRowIndexByRowId(rowId);
            for (String dimColKey : currentNodeData.getBaseDataKeys()) {
                EntityCellBaseData cellBaseData = currentNodeData.getCellBaseData(rowIndexByRowId, dimColKey);
                if (cellBaseData != null && cellBaseData.isLeaf()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected void updateStatusForUnSubmit(BillFieldStatus status) {
        super.updateStatusForUnSubmit(status);
        status.addHideKeys(new String[]{"btn_datainit"});
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String backKey;
        super.closedCallBack(closedCallBackEvent);
        switch (backKey = closedCallBackEvent.getActionId()) {
            case "collectorg": {
                this.dealCollectOrgCallBack(closedCallBackEvent);
                break;
            }
            case "btn_selappbill": {
                Set selAppBills = (Set)closedCallBackEvent.getReturnData();
                this.callUpdateCollectBill(selAppBills);
                break;
            }
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId;
        super.confirmCallBack(event);
        switch (callBackId = event.getCallBackId()) {
            case "orgPropChange": {
                if (event.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.getPageCache().remove("selappbills");
                    this.getPageCache().remove("selBillAfterFilter");
                    this.clearEntryData();
                    this.updateCollectBillEntity();
                    break;
                }
                this.getModel().beginInit();
                String oldOrg = this.getPageCache().get("oldOrg");
                this.getModel().setValue("collectorg", (Object)oldOrg);
                this.getModel().endInit();
                this.getView().updateView("collectorg");
            }
        }
    }

    private void dealCollectOrgCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        if (rows == null || rows.size() == 0) {
            return;
        }
        Long collectOrgId = IDUtils.toLong((Object)rows.get(0).getPrimaryKeyValue());
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and("billtype", "=", (Object)"collect");
        filter.and("applyscheme", "=", (Object)this.getSchemeId());
        filter.and("collectorg", "=", (Object)collectOrgId);
        try {
            Map eb_bgapplybill = BusinessDataServiceHelper.loadFromCache((String)"eb_bgapplybill", (QFilter[])filter.toArray());
            int size = eb_bgapplybill.size();
            if (size > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u6c47\u603b\u7ec4\u7ec7\u5b58\u5728\u591a\u4e2a\u6c47\u603b\u5355\u3002", (String)"BgApplyBillPlugin_27", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
            if (size == 1) {
                for (Map.Entry billEntry : eb_bgapplybill.entrySet()) {
                    DynamicObject collectBill = (DynamicObject)billEntry.getValue();
                    if (collectBill != null) {
                        String billnumber = collectBill.getString("billnumber");
                        Object billnumber1 = this.getModel().getValue("billnumber");
                        if (billnumber1 != null && !StringUtils.equals((CharSequence)billnumber, (CharSequence)billnumber1.toString()) && this.needCheckCollectOrg()) {
                            this.getModel().setValue("collectorg", (Object)"");
                            DynamicObject org = collectBill.getDynamicObject("org");
                            DynamicObject collectorg = collectBill.getDynamicObject("collectorg");
                            if (org == null || collectorg == null) continue;
                            String applyOrgName = org.getString("name");
                            String collectOrgName = collectorg.getString("name");
                            String tip = ResManager.loadResFormat((String)"\u7533\u62a5\u7ec4\u7ec7\u201c%1\u201d\u6c47\u603b\u5355\u7f16\u53f7\u201c%2\u201d\u5df2\u5bf9\u6c47\u603b\u7ec4\u7ec7\u201c%3\u201d\u8fdb\u884c\u6c47\u603b\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u6c47\u603b\u5355\u3002", (String)"BgApplyBillPlugin_55", (String)"epm-eb-formplugin", (Object[])new Object[]{applyOrgName, billnumber, collectOrgName});
                            this.getView().showTipNotification(tip);
                            continue;
                        }
                        this.getModel().setValue("collectorg", (Object)collectOrgId);
                        continue;
                    }
                    this.getModel().setValue("collectorg", (Object)collectOrgId);
                }
            } else {
                this.getModel().setValue("collectorg", (Object)collectOrgId);
            }
        }
        catch (Exception exception) {
            log.error(CommonServiceHelper.getStackTraceStr((Throwable)exception));
            throw new KDBizException(ResManager.loadKDString((String)"\u6c47\u603b\u7ec4\u7ec7\u9009\u62e9\u53d1\u751f\u5f02\u5e38\u3002", (String)"BgApplyBillPlugin_56", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    protected boolean needCheckCollectOrg() {
        return true;
    }

    private void callUpdateCollectBill(Set<Long> selAppBills) {
        if (selAppBills == null || selAppBills.size() == 0) {
            return;
        }
        String selAppBillsJson = SerializationUtils.toJsonString(selAppBills);
        this.getModel().setValue("selappbills", (Object)this.getView().getPageCache().get("selBillAfterFilter"));
        this.getPageCache().put("selappbills", selAppBillsJson);
        this.updateCollectBillEntity();
    }

    @Override
    protected Map<String, List<Object[]>> getBillDataFromDB(BgApplyENtryInfo bgApplyENtryInfo) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("collectorg");
        if (org == null) {
            this.getOrCacheAppShowInfo("");
            return new HashMap<String, List<Object[]>>(16);
        }
        List tempIds = bgApplyENtryInfo.getEntryTemplateConfig().values().stream().map(p -> p.getTemplateID()).distinct().collect(Collectors.toList());
        Set<Long> appBillIds = this.getSelAppBillIds();
        String billStatus = (String)this.getValue("billstatus", null);
        boolean isNew = StringUtils.isEmpty((CharSequence)billStatus) || billStatus.equals("A");
        CentralAppShowInfo showInfo = CentralAppBillService.getInstance().getCenAppInfosByEntity(this.getDataModel().getDataEntity(), Long.valueOf(org.getLong("id")), tempIds, this.getModelId(), this.getBizCtrlRangeId(), Boolean.valueOf(true), appBillIds, this.getSchemeId(), isNew);
        CentralAppChain chain = showInfo.getCentralAppChain();
        if (isNew) {
            this.setAuditPath(chain);
        }
        String jsonStr = SerializationUtils.toJsonString((Object)showInfo);
        CommonServiceHelper.handleLog((Log)log, (String)("getBillData:" + this.getBillNumber()), (String)jsonStr);
        this.getOrCacheAppShowInfo(jsonStr);
        Set applyBillNumbers = showInfo.getReportBillNos();
        Set refedBillNumbers = showInfo.getRefedBillNos();
        Set entityIds = showInfo.getEntitySet();
        this.getPageCache().put("orgIdsForCollectBill", SerializationUtils.serializeToBase64((Object)entityIds));
        return BgApplyBillUtils.getInstance().getCollectData(chain, applyBillNumbers, refedBillNumbers, this.getBillNumber(), entityIds, null, bgApplyENtryInfo.getEntryTemplateConfig(), false, false);
    }

    @Override
    public CentralAppShowInfo getCentralAppShowInfo() {
        return this.getOrCacheAppShowInfo(null);
    }

    protected CentralAppShowInfo getOrCacheAppShowInfo(String jsonStr) {
        CentralAppShowInfo showInfo = null;
        if (jsonStr == null) {
            jsonStr = this.getPageCache().get("CacheAppShowInfo");
            showInfo = StringUtils.isNotEmpty((CharSequence)jsonStr) ? (CentralAppShowInfo)SerializationUtils.fromJsonString((String)jsonStr, CentralAppShowInfo.class) : new CentralAppShowInfo();
        } else {
            this.getPageCache().put("CacheAppShowInfo", jsonStr);
        }
        return showInfo;
    }

    @Override
    protected void beforeFinishSaveData(BillSaveEventArgs saveEventArgs) {
        super.beforeFinishSaveData(saveEventArgs);
        this.saveAuditRecord(this.getEntryInfoFromFormParam(), saveEventArgs.getAllChangeRecord(), this.getIModelCacheHelper(), this.getView().getFormShowParameter());
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_c_view": {
                this.openViewCollectForm();
            }
        }
    }

    private Long getCurrentCollectOrg() {
        return (Long)this.getValue("collectorg", "id");
    }

    private void openViewCollectForm() {
        BaseShowParameter baseShowParameter = this.getCollectBillForm(false);
        baseShowParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    protected BaseShowParameter getCollectBillForm(boolean isStatas) {
        return this.getCollectBillForm(isStatas ? ApplyBillType.COLLECTSTATISTICS : ApplyBillType.COLLECYVIEW);
    }

    protected BaseShowParameter getCollectBillForm(ApplyBillType billType) {
        Long collectOrgId = this.getCurrentCollectOrg();
        Long datatypeId = (Long)this.getValue("datatype", "id");
        Long yearId = (Long)this.getValue("year", "id");
        Long versionId = (Long)this.getValue("version", "id");
        Long schemeId = this.getSchemeId();
        BaseShowParameter baseShowParameter = BgApplyBillHelper.getInstance().getBgApplyTypeBillFormShow(schemeId, yearId, versionId, datatypeId, this.getBgOrgId(), this.getModelId(), this.getBillNumber(), billType);
        baseShowParameter.setFormId("eb_bgapplybill");
        baseShowParameter.setCustomParam("collectOrgId", (Object)collectOrgId);
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return baseShowParameter;
    }

    @Override
    protected void initBillBaseInfo() {
        super.initBillBaseInfo();
        if (this.isAddNewForm()) {
            this.setNewBillBaseInfo();
        } else {
            Long orgId = this.getCurrentCollectOrg();
            this.getOrCacheLastCollectOrg(orgId);
        }
    }

    @Override
    protected void setCellsStatus(BillFieldStatus fieldStatus) {
        super.setCellsStatus(fieldStatus);
        this.lockRowByDetailAt();
    }

    @Override
    protected void setButtonStatus(BillFieldStatus fieldStatus) {
        super.setButtonStatus(fieldStatus);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_deleteentry);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_newentry);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_saveentity);
        fieldStatus.addShowKeys(ApplyBillConstant.btns_viewattachment);
        fieldStatus.addShowKeys(new String[]{"btn_viewreject", "btn_c_view"});
    }

    @Override
    protected void setCtrlStatusByBillStatus(BillFieldStatus fieldStatus) {
        super.setCtrlStatusByBillStatus(fieldStatus);
        String billStatus = (String)this.getValue("billstatus", null);
        if (billStatus.equals("C")) {
            this.updateStatusForSubmit(fieldStatus);
        } else if (billStatus.equals("A") || billStatus.equals("E")) {
            this.updateStatusForUnSubmit(fieldStatus);
        } else {
            fieldStatus.addHideKeys(new String[]{"submit", "unsubmit", "save", "btn_selappbill"});
            fieldStatus.addHideKeys(ApplyBillConstant.btns_saveentity);
            fieldStatus.addDisableKeys(new String[]{"attachmentpanelap"});
        }
    }

    @Override
    protected void setOtherControlStatus(BillFieldStatus fieldStatus) {
        super.setOtherControlStatus(fieldStatus);
        this.setAdjustedColumnSign(this.getEntryInfoFromFormParam());
    }

    @Override
    protected void setFieldStatus(BillFieldStatus fieldStatus) {
        super.setFieldStatus(fieldStatus);
        fieldStatus.addShowKeys(new String[]{"collectorg"});
        fieldStatus.addDisableKeys(new String[]{"collectorg"});
    }

    @Override
    protected void setRowStatus(BillFieldStatus fieldStatus) {
        super.setRowStatus(fieldStatus);
        this.selectLockRow4NoDetail(fieldStatus);
    }

    @Override
    protected BaseShowParameter getStatsShowParameter() {
        BaseShowParameter baseShowParameter = this.getCollectBillForm(true);
        Long id = (Long)this.getValue("id", null);
        if (id != 0L) {
            baseShowParameter.setPkId((Object)id);
        }
        baseShowParameter.setCustomParam("billInfos", (Object)SerializationUtils.toJsonString((Object)ApplyTemplateUtils.instanceApplyBillModel((DynamicObject)this.getModel().getDataEntity())));
        return baseShowParameter;
    }

    @Override
    protected boolean setOrderAndFilter(EntryTemplateConfig templateConfig) {
        int rowDimCount = templateConfig.getDimKeysList() == null ? 0 : templateConfig.getDimKeysList().size();
        int notTreeDimCount = templateConfig.getNotTreeDimKeys() == null ? 0 : templateConfig.getNotTreeDimKeys().size();
        return rowDimCount == notTreeDimCount;
    }
}

