/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyBillAggHelper;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.common.applybill.ApplyBillConstant;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.applybill.BillFieldStatus;
import kd.epm.eb.common.applytemplatecolumn.BgApplyENtryInfo;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.formplugin.applybill.BgCollectBillPlugin;
import org.apache.commons.collections4.CollectionUtils;

public class BgCollectBillViewPlugin
extends BgCollectBillPlugin {
    @Override
    protected void initBillBaseInfo() {
        super.initBillBaseInfo();
        this.setNewBillBaseInfo();
    }

    @Override
    protected void setButtonStatus(BillFieldStatus fieldStatus) {
        super.setButtonStatus(fieldStatus);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_newentry);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_deleteentry);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_saveentity);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_viewadj);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_export);
        fieldStatus.addHideKeys(new String[]{"btn_c_view", "btn_viewappbill", "btn_selappbill", "submit", "save", "view_workflow"});
    }

    @Override
    protected Map<String, List<Object[]>> getBillDataFromDB(BgApplyENtryInfo bgApplyENtryInfo) {
        DynamicObject collectOrg = (DynamicObject)this.getValue("collectorg", null);
        if (collectOrg == null) {
            this.getOrCacheAppShowInfo("");
            return new HashMap<String, List<Object[]>>(16);
        }
        return this.getCollectBillViewRowData(bgApplyENtryInfo);
    }

    @Override
    protected void setOtherControlStatus(BillFieldStatus fieldStatus) {
        super.setOtherControlStatus(fieldStatus);
        this.setEntityDisable(fieldStatus);
    }

    @Override
    protected boolean needCheckCollectOrg() {
        return false;
    }

    private Map<String, List<Object[]>> getCollectBillViewRowData(BgApplyENtryInfo bgApplyENtryInfo) {
        HashMap<String, List<Object[]>> rowDataMap = new HashMap<String, List<Object[]>>(16);
        Long schemeId = this.getSchemeId();
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and("applyscheme", "=", (Object)schemeId);
        Map applyBillMap = BusinessDataServiceHelper.loadFromCache((String)"eb_bgapplybill", (QFilter[])filter.toArray());
        HashSet<Long> entityIds = new HashSet<Long>(16);
        DynamicObject org = (DynamicObject)this.getModel().getValue("collectorg");
        if (org == null) {
            return rowDataMap;
        }
        String number = org.getString("number");
        Member entity = this.getIModelCacheHelper().getMember("Entity", null, number);
        this.getEntityAllChildren(entityIds, entity);
        HashMap<String, Long> billNumMapIds = new HashMap<String, Long>(16);
        for (Map.Entry applyBillObject : applyBillMap.entrySet()) {
            DynamicObject value = (DynamicObject)applyBillObject.getValue();
            billNumMapIds.put(value.getString("billnumber"), value.getLong("id"));
        }
        HashSet<Long> refApplyBillIds = new HashSet<Long>(16);
        ApplyBillAggHelper billAggHelper = ApplyBillAggHelper.getInstance();
        for (Map.Entry entry : bgApplyENtryInfo.getEntryTemplateConfig().entrySet()) {
            String entityname = (String)entry.getKey();
            if (!this.isMainEntry(entityname)) continue;
            List dimKeysList = ((EntryTemplateConfig)entry.getValue()).getDimKeysList();
            List columns = ((EntryTemplateConfig)entry.getValue()).getEntryColumns();
            List main_collect = columns.stream().filter(ee -> !ee.getKey().endsWith("_text")).collect(Collectors.toList());
            List collectBillData = ApplyTemplateUtils.getBatchBillData((String)((EntryTemplateConfig)bgApplyENtryInfo.getEntryTemplateConfig().get(entityname)).getEntryTable(), billNumMapIds.keySet(), main_collect);
            ApplyTemplateUtils.filterDataByOrg((List)collectBillData, main_collect, entityIds, (List)dimKeysList);
            for (Object[] rowData : collectBillData) {
                String billNum = billAggHelper.getBillNumberOnRow(rowData);
                Long billId = (Long)billNumMapIds.get(billNum);
                if (billId == null) continue;
                refApplyBillIds.add(billId);
            }
            rowDataMap.put(entityname, collectBillData);
        }
        if (refApplyBillIds.size() > 0) {
            this.getOrCacheRefApplyBillIds(new ArrayList<Long>(refApplyBillIds));
        }
        return rowDataMap;
    }

    private List<Long> getOrCacheRefApplyBillIds(List<Long> applyBillIds) {
        if (applyBillIds == null) {
            String cacheStr = this.getPageCache().get("RefApplyBillIds");
            applyBillIds = StringUtils.isNotEmpty((CharSequence)cacheStr) ? (ArrayList)SerializationUtils.fromJsonString((String)cacheStr, List.class) : new ArrayList(16);
        } else {
            this.getPageCache().put("RefApplyBillIds", SerializationUtils.toJsonString(applyBillIds));
        }
        return applyBillIds;
    }

    @Override
    protected List<Long> getRelationIds() {
        List<Long> result = super.getRelationIds();
        List<Long> refApplyBillIds = this.getOrCacheRefApplyBillIds(null);
        result.addAll(refApplyBillIds);
        return result;
    }

    private void getEntityAllChildren(Set<Long> entityIds, Member entity) {
        if (entity == null || entity.getId() == null) {
            return;
        }
        entityIds.add(entity.getId());
        List children = entity.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        for (Member child : children) {
            this.getEntityAllChildren(entityIds, child);
        }
    }

    @Override
    protected BaseShowParameter getStatsShowParameter() {
        BaseShowParameter baseShowParameter = this.getCollectBillForm(ApplyBillType.COLLECTVIEWSTATISTICS);
        return baseShowParameter;
    }
}

