/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.business.centralapproval.ApproveRecordUtil;
import kd.epm.eb.business.centralapproval.ShowInfoCreateUtil;
import kd.epm.eb.business.rejectbill.RejectBillService;
import kd.epm.eb.business.rejectbill.constant.RejectStatusEnum;
import kd.epm.eb.business.rejectbill.entity.RejectLog;
import kd.epm.eb.business.rejectbill.entity.RejectLogDetail;
import kd.epm.eb.business.utils.WorkFlowUtil;
import kd.epm.eb.common.applybill.ApplyBillConstant;
import kd.epm.eb.common.applybill.ApplyBillEntityData;
import kd.epm.eb.common.applybill.ApplyBillEntityNodeData;
import kd.epm.eb.common.applybill.AuditRecordObj;
import kd.epm.eb.common.applybill.BillFieldStatus;
import kd.epm.eb.common.applybill.BillSaveEventArgs;
import kd.epm.eb.common.applybill.ColumnsContext;
import kd.epm.eb.common.applybill.DetailMembBillData;
import kd.epm.eb.common.applybill.EntityCellBaseData;
import kd.epm.eb.common.applybill.EntityRowDataType;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.BgApplyENtryInfo;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.centralapproval.AppBillStatusEnum;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.centralapproval.CentralAppShowInfo;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.applybill.BgCollectAuditBillPlugin;
import kd.epm.eb.formplugin.applybill.IApAuditBill;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BgCollectRejectBillPlugin
extends BgCollectAuditBillPlugin
implements IApAuditBill {
    private static final String ENTRY_ENTITY_NAME = "entryentity1";
    private static final String PROCESSREJECTION = "processrejection";

    @Override
    protected void replaceMeasureFromOlap(Map<String, List<Object[]>> dataFromDB, BgApplyENtryInfo bgApplyENtryInfo) {
        super.replaceMeasureFromOlap(dataFromDB, bgApplyENtryInfo);
    }

    @Override
    public void setAuditTypeBillBaseInfo() {
    }

    @Override
    public void addAuditCustomColumn(ColumnsContext columnsContext) {
    }

    @Override
    public CentralAppShowInfo getCentralAppShowInfo() {
        Object auditpath = this.getModel().getValue("auditpath");
        if (auditpath == null || StringUtils.isEmpty((CharSequence)auditpath.toString())) {
            return null;
        }
        BgApplyENtryInfo entryInfoFromFormParam = this.getEntryInfoFromFormParam();
        Map entryTemplateConfig = entryInfoFromFormParam.getEntryTemplateConfig();
        EntryTemplateConfig entryTemplateConfig1 = (EntryTemplateConfig)entryTemplateConfig.get(ENTRY_ENTITY_NAME);
        long templateID = 0L;
        if (entryTemplateConfig1 != null) {
            templateID = entryTemplateConfig1.getTemplateID();
        }
        HashSet<Long> templateIds = new HashSet<Long>(16);
        templateIds.add(templateID);
        CentralAppShowInfo centralAppShowInfo = (CentralAppShowInfo)SerializationUtils.fromJsonString((String)auditpath.toString(), CentralAppShowInfo.class);
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        String billNo = centralAppShowInfo.getBillNo();
        filter.and("billno", "=", (Object)(StringUtils.isEmpty((CharSequence)billNo) ? this.getSrcBillNumber() : billNo));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_centralappbill", (QFilter[])filter.toArray());
        ApproveBill approveBill = ApproveBillUtil.getInstance().createApproveBill(dynamicObject);
        this.addLog("applyrejectshowinfo:createShowInfo\uff1aapproveBill", approveBill);
        this.addLog("applyrejectshowinfo:createShowInfo\uff1acentralAppShowInfo", centralAppShowInfo);
        this.addLog("applyrejectshowinfo:createShowInfo\uff1atemplateIds", templateIds);
        CentralAppShowInfo showInfo = ShowInfoCreateUtil.getInstance().createShowInfo(approveBill, centralAppShowInfo.getCurPlans(), templateIds, DimMembPermType.WRITE);
        this.addLog("collectrejectshowinfo", showInfo);
        showInfo.setStatus(AppBillStatusEnum.AUDITING.getNumber());
        showInfo.setRejectapprovebillno(centralAppShowInfo.getRejectapprovebillno());
        showInfo.setRejectNodeName(centralAppShowInfo.getRejectNodeName());
        showInfo.setAppDimMemLevel(centralAppShowInfo.getAppDimMemLevel());
        this.setApproveBillConfigs(approveBill, showInfo);
        return showInfo;
    }

    @Override
    protected void setRowRejectTxt(String entityKey, List<Integer> rowNums) {
    }

    @Override
    protected void setFieldStatus(BillFieldStatus fieldStatus) {
        super.setFieldStatus(fieldStatus);
        fieldStatus.addHideKeys(new String[]{"applydate", "proposer", "auditor", "auditdate"});
        fieldStatus.addShowKeys(new String[]{"approvelevel", "rejectadjtime", "rejectadjuser", "srcbillnumber"});
        fieldStatus.addDisableKeys(new String[]{"srcbillnumber", "attachmentpanelap"});
    }

    @Override
    protected List<Map<String, Object>> setAttachments() {
        return new ArrayList<Map<String, Object>>(16);
    }

    @Override
    protected Map<String, List<Object[]>> getBillDataFromDB(BgApplyENtryInfo bgApplyENtryInfo) {
        HashMap<String, List<Object[]>> result = new HashMap<String, List<Object[]>>(16);
        BgApplyENtryInfo entryInfoFromFormParam = this.getEntryInfoFromFormParam();
        Map entryTemplateConfig = entryInfoFromFormParam.getEntryTemplateConfig();
        if (this.isProcessregection()) {
            return this.getOtherBillDataFromDB(bgApplyENtryInfo);
        }
        List<RejectLog> rejectLogs = this.getRejectLogs();
        for (Map.Entry templateConfigEntry : entryTemplateConfig.entrySet()) {
            String entityname = (String)templateConfigEntry.getKey();
            if (entityname.startsWith("bizentryentity")) continue;
            EntryTemplateConfig entryValue = (EntryTemplateConfig)templateConfigEntry.getValue();
            long configTemplateId = entryValue.getTemplateID();
            List objects = result.computeIfAbsent(entityname, t -> new ArrayList(16));
            for (RejectLog rejectLog : rejectLogs) {
                Long templateId = rejectLog.getTemplateId();
                if (!templateId.equals(configTemplateId)) continue;
                List rejectLogDetails = rejectLog.getRejectLogDetails();
                for (RejectLogDetail rejectLogDetail : rejectLogDetails) {
                    String fmodifyrowdatajsonnew = rejectLogDetail.getFmodifyrowdatajsonnew();
                    String fmodifyrowdatajson = rejectLogDetail.getFmodifyrowdatajson();
                    if (StringUtils.isEmpty((CharSequence)fmodifyrowdatajsonnew)) {
                        fmodifyrowdatajsonnew = fmodifyrowdatajson;
                    }
                    if (StringUtils.isEmpty((CharSequence)fmodifyrowdatajsonnew)) continue;
                    List rowData = (List)SerializationUtils.fromJsonString((String)fmodifyrowdatajsonnew, List.class);
                    objects.add(this.parseModifyRowData(rowData));
                }
            }
        }
        return result;
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        Object rejectadjtime = this.getModel().getValue("rejectadjtime");
        Object rejectadjuser = this.getModel().getValue("rejectadjuser");
        e.setCheckDataChange(rejectadjtime == null || rejectadjuser == null);
    }

    private Map<String, List<Object[]>> getOtherBillDataFromDB(BgApplyENtryInfo bgApplyENtryInfo) {
        return super.getBillDataFromDB(bgApplyENtryInfo);
    }

    private void setApproveBillConfigs(ApproveBill approveBill, CentralAppShowInfo showInfo) {
        Long parentId = approveBill.getParentId();
        ArrayList configs = new ArrayList(16);
        showInfo.setHasSubChildren(approveBill.isHasSubitems());
        if (parentId == null || parentId == 0L) {
            showInfo.setMainBill(true);
            QFilter filter = new QFilter("parentid", "=", (Object)approveBill.getId());
            filter.and(new QFilter("billstatus", "=", (Object)AppBillStatusEnum.AUDITED.getNumber()));
            List approveBills = ApproveBillUtil.getInstance().getApproveBills(filter);
            for (ApproveBill bill : approveBills) {
                configs.addAll(bill.getApproveconfig());
            }
        } else {
            configs.addAll(approveBill.getApproveconfig());
            showInfo.setMainBill(false);
        }
        showInfo.setApproveBillConfigs(configs);
    }

    private Object[] parseModifyRowData(List<Object> rowDataList) {
        List<BaseColumn> baseColumns = this.getBaseColumns(ENTRY_ENTITY_NAME);
        List newColKeys = baseColumns.stream().map(BaseColumn::getKey).collect(Collectors.toList());
        Set bigDecimalKeys = RejectBillService.getInstance().getBigDecimalKeys(baseColumns);
        Map<String, Integer> columnIndexMap = this.getColumnIndexMap(ENTRY_ENTITY_NAME);
        ArrayList<Object> rebuildRowDataList = new ArrayList<Object>(16);
        rebuildRowDataList.addAll(rowDataList);
        for (Object data : rowDataList) {
            if (!(data instanceof Map)) continue;
            Map dataMap = (Map)data;
            String key = (String)dataMap.keySet().iterator().next();
            newColKeys.remove(key);
            newColKeys.removeIf(t -> t.startsWith(ApplyTemplateUtils.FIELD_BUSPLANDETAIL));
            newColKeys.removeIf(t -> t.startsWith(ApplyTemplateUtils.FIELD_SUBTOTAL_STATUS));
        }
        if (CollectionUtils.isNotEmpty(newColKeys)) {
            block1: for (String newColKey : newColKeys) {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                for (BaseColumn baseColumn : baseColumns) {
                    if (!StringUtils.equals((CharSequence)baseColumn.getKey(), (CharSequence)newColKey)) continue;
                    if (RejectBillService.getInstance().isBigDecimalCol(baseColumn)) {
                        map.put(newColKey, 0L);
                    } else {
                        map.put(newColKey, "");
                    }
                    rebuildRowDataList.add(map);
                    continue block1;
                }
            }
        }
        Object[] newResultData = new Object[rebuildRowDataList.size()];
        for (int i = 0; i < rebuildRowDataList.size(); ++i) {
            BigDecimal bigDecimal;
            Object data = rebuildRowDataList.get(i);
            if (!(data instanceof Map)) {
                newResultData[i] = data;
                continue;
            }
            Map dataMap = (Map)data;
            String key = (String)dataMap.keySet().iterator().next();
            Object value = dataMap.values().iterator().next();
            Integer integer = columnIndexMap.get(key);
            if (key.startsWith(ApplyTemplateUtils.FIELD_BUSPLANDETAIL)) {
                integer = columnIndexMap.get(ApplyTemplateUtils.FIELD_BUSPLANDETAIL + 1);
            }
            if (key.startsWith(ApplyTemplateUtils.FIELD_SUBTOTAL_STATUS)) continue;
            newResultData[integer.intValue()] = !bigDecimalKeys.contains(key) ? value : (value == null || StringUtils.isEmpty((CharSequence)value.toString()) ? value : ((bigDecimal = RejectBillService.getInstance().changeValueToBigDecimal(baseColumns, key, value)).compareTo(BigDecimal.ZERO) > 0 ? bigDecimal : value));
        }
        return newResultData;
    }

    private List<RejectLog> getRejectLogs() {
        String billNumber = (String)this.getValue("billnumber", null);
        QFilter qf = new QFilter("bhbillnumber", "=", (Object)billNumber);
        return RejectBillService.getInstance().getRejectLogsByFilter(qf);
    }

    private boolean isProcessregection() {
        String rejectiontype = (String)this.getModel().getValue("rejectiontype");
        return PROCESSREJECTION.equals(rejectiontype);
    }

    @Override
    protected List<Map<String, String>> getAllFirstRow(EntryTemplateConfig templateConfig, Map<String, Map<String, Set<Long>>> groupMembsByStats, DetailMembBillData detailMembBillData) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(16);
        if (this.isProcessregection()) {
            return super.getAllFirstRow(templateConfig, groupMembsByStats, detailMembBillData);
        }
        List<RejectLog> rejectLogs = this.getRejectLogs();
        if (CollectionUtils.isEmpty(rejectLogs)) {
            return result;
        }
        List entryColumns = templateConfig.getEntryColumns();
        List dimKeysList = templateConfig.getDimKeysList();
        List baseColumns = entryColumns.stream().filter(t -> !t.getKey().endsWith("_text")).collect(Collectors.toList());
        for (RejectLog rejectLog : rejectLogs) {
            String dataJson = rejectLog.getDataJson();
            String afterDataJson = rejectLog.getAfterDataJson();
            List dataList = new ArrayList(16);
            if (StringUtils.isNotEmpty((CharSequence)afterDataJson)) {
                dataList = (List)SerializationUtils.fromJsonString((String)afterDataJson, List.class);
            } else if (StringUtils.isNotEmpty((CharSequence)dataJson)) {
                dataList = (List)SerializationUtils.fromJsonString((String)dataJson, List.class);
            }
            if (!CollectionUtils.isNotEmpty(dataList)) continue;
            HashMap<String, String> map = new HashMap<String, String>(16);
            for (BaseColumn baseColumn : baseColumns) {
                Object memberValue;
                Long memberId;
                String key = baseColumn.getKey();
                String baseEntityId = baseColumn.getBaseEntityId();
                if (!dimKeysList.contains(key) && StringUtils.isEmpty((CharSequence)baseEntityId) || IDUtils.isEmptyLong((Long)(memberId = IDUtils.toLong((Object)(memberValue = RejectBillService.getInstance().getValueFromRowDataArray(dataList.toArray(), key))))).booleanValue()) continue;
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)memberId, (String)baseEntityId);
                map.put(key, dynamicObject.getString("number"));
            }
            map.put("rowId", dataList.get(0).toString());
            result.add(map);
        }
        return result;
    }

    @Override
    public Long getBillId() {
        return IDUtils.toLong((Object)this.getModel().getValue("id"));
    }

    @Override
    protected List<Long> getTempIdsFromFormParam(FormShowParameter formShowParameter) {
        ArrayList<Long> tempIds = new ArrayList<Long>(1);
        Long pkId = (Long)formShowParameter.getCustomParam("pkId");
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"eb_bgapplybill");
        String rejectiontype = dy.getString("rejectiontype");
        if (PROCESSREJECTION.equals(rejectiontype)) {
            QFilter filter = new QFilter("model", "=", (Object)dy.getLong("model.id"));
            String billNo = dy.getString("srcbillnumber");
            filter.and("billno", "=", (Object)billNo);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_centralappbill", (QFilter[])filter.toArray());
            ApproveBill approveBill = ApproveBillUtil.getInstance().createApproveBill(dynamicObject);
            List approveconfig = approveBill.getApproveconfig();
            Long parentId = approveBill.getParentId();
            if (!(parentId != null && parentId != 0L || approveBill.isHasSubitems())) {
                return tempIds;
            }
            if (approveconfig != null && !approveconfig.isEmpty()) {
                List configtemplateIds = approveconfig.stream().filter(s -> s.getTemplateId() != 0L && !s.getMatchMemberIds().isEmpty()).map(s -> s.getTemplateId()).collect(Collectors.toList());
                tempIds.addAll(configtemplateIds);
                return tempIds;
            }
        }
        tempIds.add(dy.getLong("templateid"));
        return tempIds;
    }

    @Override
    protected void setButtonStatus(BillFieldStatus fieldStatus) {
        super.setButtonStatus(fieldStatus);
        fieldStatus.addHideKeys(new String[]{"save", "savesplit", "unsubmit", "statistics", "btn_stats", "viewrejectlogpanel", "btn_selappbill", "btn_c_view", "btn_viewappbill", "view_workflow", "btn_viewappbill", "btn_selappbill", "org"});
        fieldStatus.addHideKeys(ApplyBillConstant.btns_viewadj);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_newentry);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_deleteentry);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_export);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_import);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_saveentity);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_viewdata);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_formatset);
        fieldStatus.addHideKeys(ApplyBillConstant.btns_viewattachment);
        fieldStatus.addDisableKeys(new String[]{"attachmentpanelap"});
        fieldStatus.addShowKeys(new String[]{"submit", "close"});
        Object rejectiontype = this.getModel().getValue("rejectiontype");
        if (rejectiontype != null && this.getModel().getValue("rejectiontype").equals(PROCESSREJECTION)) {
            fieldStatus.addShowKeys(new String[]{"save"});
        }
        if (this.getModel().getValue("billstatus").equals("C")) {
            fieldStatus.addDisableKeys(new String[]{"submit"});
        }
    }

    @Override
    protected void beforeFinishSaveData(BillSaveEventArgs saveEventArgs) {
        super.beforeFinishSaveData(saveEventArgs);
        BgApplyENtryInfo eNtryInfo = this.getEntryInfoFromFormParam();
        Map allAuditRecord = saveEventArgs.getAllChangeRecord();
        IModelCacheHelper modelCacheHelper = this.getIModelCacheHelper();
        if (allAuditRecord.size() > 0) {
            HashMap hideDimMap = new HashMap(16);
            HashMap colDimMap = new HashMap(16);
            ApplyTemplateUtils.selectDimMembInfoOnTemp((BgApplyENtryInfo)eNtryInfo, hideDimMap, colDimMap, (IModelCacheHelper)modelCacheHelper);
            ArrayList recordObjs = new ArrayList(16);
            CentralAppShowInfo centralAppShowInfo = this.getCentralAppShowInfo();
            allAuditRecord.values().forEach(recordObjs::addAll);
            String rejectnode = (String)this.getModel().getValue("rejectnode");
            String billnumber = (String)this.getModel().getValue("srcbillnumber");
            String nodenumber = null;
            DynamicObject buiskey = QueryServiceHelper.queryOne((String)"eb_centralappbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billnumber)});
            List approvalRecords = WorkFlowUtil.getApprovalRecords((String)"eb_centralappbill", (String)buiskey.getString("id"), (boolean)true);
            for (IApprovalRecordGroup approvalRecord : approvalRecords) {
                IApprovalRecordItem iApprovalRecordItem = (IApprovalRecordItem)approvalRecord.getChildren().get(0);
                String activityName = iApprovalRecordItem.getActivityName();
                if (!activityName.equals(rejectnode)) continue;
                String[] split = iApprovalRecordItem.getActivityId().split("_");
                nodenumber = split[split.length - 1];
            }
            ApproveRecordUtil.getInstance().saveAdjustRecord(recordObjs, hideDimMap, colDimMap, centralAppShowInfo.getCurPlans(), centralAppShowInfo.getCurCentralScheme(), this.getModelId(), this.getSrcBillNumber(), "0", this.getBhBillNumber(), nodenumber, rejectnode);
        }
        this.handleRejectSubmit(saveEventArgs);
    }

    @Override
    public void saveAuditRecord(BgApplyENtryInfo eNtryInfo, Map<String, List<AuditRecordObj>> allAuditRecord, IModelCacheHelper modelCacheHelper, FormShowParameter parameter) {
    }

    private String getBhBillNumber() {
        return this.getModel().getValue("billnumber").toString();
    }

    @Override
    public String getBillNumber() {
        return this.getSrcBillNumber();
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String operateKey = eventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"submit")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"submit", "unsubmit", "save"});
            if (eventArgs.getOperationResult() != null && eventArgs.getOperationResult().isSuccess() && !this.isProcessregection()) {
                String currentEntityKey = this.getCurrentEntityKey();
                List<Map<String, String>> rejectDataList = this.getSelectedMemberScope(currentEntityKey);
                String bhbillnumber = this.getBhBillNumber();
                String frombillno = this.getSrcBillNumber();
                CentralAppShowInfo centralAppShowInfo = this.getCentralAppShowInfo();
                String tobillno = centralAppShowInfo.getRejectapprovebillno();
                String rejectNodeName = centralAppShowInfo.getRejectNodeName();
                long modelId = this.getModelId();
                long createrId = 0L;
                DynamicObject creater = (DynamicObject)this.getModel().getValue("creater");
                if (creater != null) {
                    createrId = creater.getLong("id");
                }
                RejectBillService.getInstance().sendMessageToApproveUsers(bhbillnumber, frombillno, tobillno, modelId, createrId, rejectNodeName, rejectDataList);
            }
            this.getModel().setDataChanged(false);
        }
    }

    private String getSrcBillNumber() {
        return (String)this.getModel().getValue("srcbillnumber");
    }

    private void handleRejectSubmit(BillSaveEventArgs eventArgs) {
        EntryTemplateConfig templateConfig = (EntryTemplateConfig)this.getEntryInfoFromFormParam().getEntryTemplateConfig().get(ENTRY_ENTITY_NAME);
        if (templateConfig != null) {
            this.saveRejectLog(eventArgs);
        } else {
            this.updateRejectLogStatus(this.getBhBillNumber(), RejectStatusEnum.handled);
        }
        this.setRejectBillFieldValue();
    }

    private void updateRejectLogStatus(String bhBillNumber, RejectStatusEnum rejectStatusEnum) {
        QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
        filter.and("bhbillnumber", "=", (Object)bhBillNumber);
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"eb_billrejectlog", (QFilter[])filter.toArray());
        ArrayList<DynamicObject> toUpdateObjs = new ArrayList<DynamicObject>(16);
        if (dynamicObjectMap != null && dynamicObjectMap.size() > 0) {
            for (Map.Entry entry : dynamicObjectMap.entrySet()) {
                DynamicObject value = (DynamicObject)entry.getValue();
                value.set("rejectstatus", (Object)rejectStatusEnum.getCode());
                toUpdateObjs.add(value);
            }
        }
        SaveServiceHelper.save((DynamicObject[])toUpdateObjs.toArray(new DynamicObject[0]));
    }

    private void saveRejectLog(BillSaveEventArgs eventArgs) {
        EntryTemplateConfig templateConfig = (EntryTemplateConfig)this.getEntryInfoFromFormParam().getEntryTemplateConfig().get(ENTRY_ENTITY_NAME);
        List toSaveRowsData = eventArgs.getToSaveRowsData();
        List toSaveList = toSaveRowsData.stream().map(Arrays::asList).collect(Collectors.toList());
        List toUpdateRowsData = eventArgs.getToUpdateRowsData();
        List<RejectLog> rejectLogs = this.getRejectLogs();
        List dimKeysList = templateConfig.getDimKeysList();
        Set currencyColumnKeys = templateConfig.getCurrencyColumnKeys();
        List<BaseColumn> baseColumns = this.getBaseColumns(ENTRY_ENTITY_NAME);
        ArrayList<DynamicObject> toUpdateLogs = new ArrayList<DynamicObject>(16);
        IModelCacheHelper iModelCacheHelper = this.getIModelCacheHelper();
        Map dimViewMap = iModelCacheHelper.getViewsByDataSet(Long.valueOf(templateConfig.getDatasetId()));
        Map<Integer, Object[]> rowDataList = this.buildRowDataFromCache(baseColumns);
        for (RejectLog rejectLog : rejectLogs) {
            String dataJson = rejectLog.getDataJson();
            if (StringUtils.isEmpty((CharSequence)dataJson)) continue;
            List dataJsonList = (List)SerializationUtils.fromJsonString((String)dataJson, List.class);
            List rejectLogDetailsOld = rejectLog.getRejectLogDetails();
            ArrayList<RejectLogDetail> rejectLogDetailsNew = new ArrayList<RejectLogDetail>(16);
            for (Object[] updateRow : toUpdateRowsData) {
                Object[] objects = RejectBillService.getInstance().setRowDataToMap(updateRow, baseColumns);
                boolean isChildData = RejectBillService.getInstance().isDataJsonChildData(dataJsonList.toArray(), objects, baseColumns, iModelCacheHelper, dimViewMap);
                if (!isChildData) continue;
                block2: for (RejectLogDetail rejectLogDetail : rejectLogDetailsOld) {
                    String fmodifyrowdatajson = rejectLogDetail.getFmodifyrowdatajson();
                    List oldRow = (List)SerializationUtils.fromJsonString((String)fmodifyrowdatajson, List.class);
                    boolean flag = RejectBillService.getInstance().compareTowRowDataDim(oldRow.toArray(), objects, dimKeysList);
                    if (!flag) continue;
                    Object[] newRow = oldRow.toArray();
                    RejectBillService.getInstance().copyColValue(objects, newRow, baseColumns);
                    rejectLogDetail.setFmodifyrowdatajsonnew(SerializationUtils.toJsonString((Object)newRow));
                    rejectLogDetail.setIsUpdate("1");
                    String dataType = updateRow[3].toString();
                    if (!StringUtils.equals((CharSequence)dataType, (CharSequence)EntityRowDataType.NEW_NOTDETAIL.getNumber()) && !StringUtils.equals((CharSequence)dataType, (CharSequence)EntityRowDataType.EDIT_NOTDETAIL.getNumber())) continue;
                    Object[] objectsValueMap = RejectBillService.getInstance().setRowDataToMap(objects, baseColumns);
                    for (Map.Entry<Integer, Object[]> entry : rowDataList.entrySet()) {
                        Object[] data = entry.getValue();
                        Object[] dataValueMap = RejectBillService.getInstance().setRowDataToMap(data, baseColumns);
                        boolean b = RejectBillService.getInstance().compareTowRowDataDim(objectsValueMap, dataValueMap, dimKeysList);
                        if (!b) continue;
                        rejectLogDetail.setFaftermodifyrowdatajson(SerializationUtils.toJsonString((Object)dataValueMap));
                        continue block2;
                    }
                }
            }
            for (List newRow : toSaveList) {
                RejectLogDetail newDetail = new RejectLogDetail();
                newDetail.setIsUpdate("1");
                Object[] objects = RejectBillService.getInstance().setRowDataToMap(newRow.toArray(), baseColumns);
                boolean isChildData = RejectBillService.getInstance().isDataJsonChildData(dataJsonList.toArray(), objects, baseColumns, iModelCacheHelper, dimViewMap);
                if (!isChildData) continue;
                newDetail.setFmodifyrowdatajsonnew(SerializationUtils.toJsonString((Object)objects));
                Object[] objectsValueMap = RejectBillService.getInstance().setRowDataToMap(objects, baseColumns);
                for (Map.Entry<Integer, Object[]> entry : rowDataList.entrySet()) {
                    Object[] data = entry.getValue();
                    Object[] dataValueMap = RejectBillService.getInstance().setRowDataToMap(data, baseColumns);
                    boolean b = RejectBillService.getInstance().compareTowRowDataDim(objectsValueMap, dataValueMap, dimKeysList);
                    if (!b) continue;
                    dataValueMap = RejectBillService.getInstance().changeRowMapValueByUnit(dataValueMap, templateConfig.getUnit(), baseColumns, currencyColumnKeys, false);
                    newDetail.setFaftermodifyrowdatajson(SerializationUtils.toJsonString((Object)dataValueMap));
                    break;
                }
                rejectLogDetailsNew.add(newDetail);
            }
            rejectLogDetailsNew.addAll(rejectLogDetailsOld);
            rejectLog.setRejectLogDetails(rejectLogDetailsNew);
            rejectLog.setRejectStatus(RejectStatusEnum.handled.getCode());
            toUpdateLogs.add(rejectLog.convertToDynamicObj());
        }
        SaveServiceHelper.save((DynamicObject[])toUpdateLogs.toArray(new DynamicObject[0]));
    }

    private void updateHandleUser() {
        this.getModel().setValue("proposer", (Object)this.getUserId());
    }

    private Map<Integer, Object[]> buildRowDataFromCache(List<BaseColumn> baseColumns) {
        HashMap<Integer, Object[]> rowDataList = new HashMap<Integer, Object[]>(16);
        ApplyBillEntityNodeData applyBillEntityNodeData = this.getOrCacheBillEntityNodeData(ENTRY_ENTITY_NAME, null);
        List nodeEntityData = applyBillEntityNodeData.getNodeEntityData();
        int dataLength = ApplyBillConstant.fixEntityTableKey.length + baseColumns.size();
        for (ApplyBillEntityData nodeEntityDatum : nodeEntityData) {
            Object[] data;
            int i;
            List otherDataOfColumn;
            int colIndex = 0;
            for (String key : ApplyBillConstant.fixEntityTableKey) {
                otherDataOfColumn = nodeEntityDatum.getOtherDataOfColumn(key);
                if (!CollectionUtils.isNotEmpty((Collection)otherDataOfColumn)) continue;
                for (i = 0; i < otherDataOfColumn.size(); ++i) {
                    data = rowDataList.computeIfAbsent(i, t -> new Object[dataLength]);
                    data[colIndex] = otherDataOfColumn.get(i);
                }
                ++colIndex;
            }
            for (BaseColumn baseColumn : baseColumns) {
                String key = baseColumn.getKey();
                List listDataOfColumn = nodeEntityDatum.getListDataOfColumn(key);
                otherDataOfColumn = nodeEntityDatum.getOtherDataOfColumn(key);
                if (CollectionUtils.isNotEmpty((Collection)listDataOfColumn)) {
                    for (i = 0; i < listDataOfColumn.size(); ++i) {
                        EntityCellBaseData cellBaseData = (EntityCellBaseData)listDataOfColumn.get(i);
                        Object[] data2 = rowDataList.computeIfAbsent(i, t -> new Object[dataLength]);
                        Long dimMemberId = cellBaseData.getId();
                        data2[colIndex] = dimMemberId;
                    }
                    ++colIndex;
                }
                if (!CollectionUtils.isNotEmpty((Collection)otherDataOfColumn)) continue;
                for (i = 0; i < otherDataOfColumn.size(); ++i) {
                    data = rowDataList.computeIfAbsent(i, t -> new Object[dataLength]);
                    data[colIndex] = otherDataOfColumn.get(i);
                }
                ++colIndex;
            }
        }
        return rowDataList;
    }

    private void setRejectBillFieldValue() {
        this.getModel().setValue("rejectadjtime", (Object)new Date());
        this.getModel().setValue("rejectadjuser", (Object)this.getUserId());
        this.updateHandleUser();
    }

    private List<BaseColumn> getBaseColumns(String entityName) {
        BgApplyENtryInfo entryInfoFromFormParam = this.getEntryInfoFromFormParam();
        Map entryTemplateConfigMap = entryInfoFromFormParam.getEntryTemplateConfig();
        EntryTemplateConfig entryTemplateConfig = (EntryTemplateConfig)entryTemplateConfigMap.get(entityName);
        List entryColumns = entryTemplateConfig.getEntryColumns();
        return entryColumns.stream().filter(t -> !t.getKey().endsWith("_text") && !t.isIgnoreDB()).collect(Collectors.toList());
    }

    private Map<String, Integer> getColumnIndexMap(String entityName) {
        BgApplyENtryInfo entryInfoFromFormParam = this.getEntryInfoFromFormParam();
        Map entryTemplateConfigMap = entryInfoFromFormParam.getEntryTemplateConfig();
        EntryTemplateConfig entryTemplateConfig = (EntryTemplateConfig)entryTemplateConfigMap.get(entityName);
        return entryTemplateConfig.getColumnIndex();
    }

    @Override
    protected String getMemberShowTypeNumber() {
        return "btn_changeshow";
    }

    @Override
    protected void setMemberShowInfoBtnStatus(BillFieldStatus fieldStatus) {
        fieldStatus.addHideKeys(new String[]{"changemembershow0", "changemembershow1", "changemembershow2"});
    }

    @Override
    protected boolean isChangeShowType(String[] split) {
        return split.length == 2 && split[1].contains(this.getMemberShowTypeNumber());
    }
}

