/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.common.applybill.ApplyBillEntityData;
import kd.epm.eb.common.applybill.ApplyBizplanHelper;
import kd.epm.eb.common.applybill.EntityCellBaseData;
import kd.epm.eb.common.applybill.TemplateBizPlan;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.BgApplyENtryInfo;
import kd.epm.eb.common.applytemplatecolumn.BizEntryCacheData;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class BgQueryPlan
extends AbstractFormPlugin
implements UploadListener,
EntryGridBindDataListener,
TabSelectListener {
    private static final Log log = LogFactory.getLog(BgQueryPlan.class);
    private static final String TABAP = "tabap";
    private static final String TAB_PAGE_BUSPLAN = "tab_page_busplan_";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl(TABAP);
        if (tab != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entryentityname = (String)formShowParameter.getCustomParam("entryname");
        DynamicObject dny = this.getDny(formShowParameter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        BgApplyENtryInfo bgApplyENtryInfo = this.getEntryInfoFromFormParam(formShowParameter);
        if (bgApplyENtryInfo == null) {
            return;
        }
        String entryentityname = (String)formShowParameter.getCustomParam("entryentityname");
        EntryTemplateConfig entryTemplateConfig = (EntryTemplateConfig)bgApplyENtryInfo.getEntryTemplateConfig().get(entryentityname);
        List biz_collect = entryTemplateConfig.getEntryColumns();
        this.setFieldDefaultVisible(biz_collect);
        this.buildBusPlanTab();
        BgApplyENtryInfo entryInfoFromFormParam = this.getEntryInfoFromFormParam(formShowParameter);
        if (entryInfoFromFormParam == null) {
            return;
        }
        this.filterNotDataTableKeys(entryInfoFromFormParam);
    }

    private void setFieldDefaultVisible(List<BaseColumn> biz_collect) {
        for (BaseColumn basecolumn : biz_collect) {
            boolean visible = basecolumn.isFinalVisible();
            this.getView().setVisible(Boolean.valueOf(visible), new String[]{basecolumn.getKey()});
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"entryentity"});
    }

    private BizEntryCacheData getBizEntryCacheData() {
        String bizEntryCacheStr = (String)this.getView().getFormShowParameter().getCustomParam("bizEntryCache");
        BizEntryCacheData bizEntryCacheData = StringUtils.isEmpty((CharSequence)bizEntryCacheStr) ? new BizEntryCacheData() : (BizEntryCacheData)SerializationUtils.fromJsonString((String)bizEntryCacheStr, BizEntryCacheData.class);
        return bizEntryCacheData;
    }

    private void refreshBizEntryDataAndPutCombineInfo(DynamicObject dataEntity, String entityname, boolean busdetail, String tabkey) {
        BgApplyENtryInfo entryInfoFromFormParam = this.getEntryInfoFromFormParam(this.getView().getFormShowParameter());
        if (entryInfoFromFormParam == null) {
            return;
        }
        Map entryTemplateConfig = entryInfoFromFormParam.getEntryTemplateConfig();
        EntryTemplateConfig entryTemplateConfig1 = (EntryTemplateConfig)entryTemplateConfig.get(entityname);
        HashSet dimKeysList = new HashSet(entryTemplateConfig1.getDimKeysList());
        List dimCollect = entryTemplateConfig1.getEntryColumns().stream().filter(ee -> dimKeysList.contains(ee.getKey())).collect(Collectors.toList());
        String bizentityName = "biz" + entityname;
        int row = (Integer)this.getView().getFormShowParameter().getCustomParam("row");
        EntryTemplateConfig bizEntryCfg = (EntryTemplateConfig)entryTemplateConfig.get(bizentityName);
        DynamicObjectCollection bizentryEntity = this.getModel().getEntryEntity("entryentity");
        this.getView().updateView("entryentity");
        if (busdetail) {
            StringBuilder dimStr = new StringBuilder();
            for (BaseColumn col : dimCollect) {
                DynamicObject dimObject = dataEntity.getDynamicObject(col.getKey());
                dimStr.append(dimObject == null ? "0" : dimObject.getPkValue().toString()).append("_");
            }
            this.getView().getPageCache().put("combinedimension" + entityname, dimStr.toString());
            ApplyBillEntityData billEntityData = this.getApplyBillEntryData();
            StringBuilder filed = new StringBuilder();
            HashMap<String, Long> rowDimGroup = new HashMap<String, Long>(16);
            for (BaseColumn col : dimCollect) {
                EntityCellBaseData cellBaseData = billEntityData.getCellBaseData(row, col.getKey());
                DynamicObject dynamicObject = dataEntity.getDynamicObject(col.getKey());
                filed.append(dynamicObject.getPkValue()).append("_");
                rowDimGroup.put(((RowDimensionColumn)col).getDimNumber(), (Long)dynamicObject.getPkValue());
            }
            HashMap hideDimMembers = new HashMap(16);
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)bizEntryCfg.getModelId());
            Map viewIds = modelCacheHelper.getViewsByDataSet(Long.valueOf(entryTemplateConfig1.getDatasetId()));
            Map bizHideDimMembersFromTempConfig = BgApplyBillUtils.getInstance().getBizHideDimMembersFromTempConfig(modelCacheHelper, bizEntryCfg);
            Map bizHidCloumMap = (Map)bizHideDimMembersFromTempConfig.get(tabkey);
            for (Map.Entry hiacloumn : bizHidCloumMap.entrySet()) {
                Member metric = modelCacheHelper.getMember((String)hiacloumn.getKey(), (Long)viewIds.get(hiacloumn.getKey()), (String)hiacloumn.getValue());
                hideDimMembers.put(hiacloumn.getKey(), metric.getId());
            }
            String rowSourceBillNumber = (String)billEntityData.getCellOtherData(row, "fbillnumber");
            rowSourceBillNumber = this.sqlQueryData(bizEntryCfg.getEntryTable(), filed.toString(), rowSourceBillNumber, tabkey);
            BigDecimal unitData = BgApplyBillUtils.getInstance().getUnitData(bizEntryCfg.getUnit());
            Set currencyColumnKeys = bizEntryCfg.getCurrencyColumnKeys();
            ApplyTemplateUtils.setEntryEntiryDefaultValueByDim((String)bizEntryCfg.getEntryTable(), (String)filed.toString(), (List)bizEntryCfg.getEntryColumns(), (DynamicObjectCollection)bizentryEntity, (String)rowSourceBillNumber, (BigDecimal)unitData, (Set)currencyColumnKeys, (String)tabkey, (Long)bizEntryCfg.getModelId(), rowDimGroup, hideDimMembers, (EntryTemplateConfig)entryTemplateConfig1);
        } else {
            this.getView().getPageCache().put("combinedimension" + entityname, null);
            bizentryEntity.clear();
        }
        this.getModel().updateEntryCache(bizentryEntity);
        this.getView().updateView("entryentity");
    }

    private String sqlQueryData(String tableName, String filed, String rowSourceBillNumber, String tabkey) {
        String sql = "select fbillnumber from  " + tableName + " t WHERE t.fcombinedimension ='" + filed + "' and fbizplantabkey = '" + tabkey + "'";
        DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)BgBaseConstant.epm, (String)sql);
        if (dataSet != null && dataSet.hasNext()) {
            Row row = dataSet.next();
            return row.getString("fbillnumber");
        }
        return rowSourceBillNumber;
    }

    private void addFiledToEntity(BgApplyENtryInfo entryInfoFromFormParam, String bizEntityNumber, LoadCustomControlMetasArgs e) {
        if (entryInfoFromFormParam == null) {
            return;
        }
        EntryTemplateConfig entryTemplateConfig = (EntryTemplateConfig)entryInfoFromFormParam.getEntryTemplateConfig().get(bizEntityNumber);
        List biz_collect = entryTemplateConfig.getEntryColumns();
        EntryAp bizentryAp = ApplyTemplateUtils.createEntryAp((String)"entryentity", (Collection)biz_collect);
        HashMap<String, String> mapbizEntry = new HashMap<String, String>();
        mapbizEntry.put("id", bizEntityNumber);
        mapbizEntry.put("columns", (String)bizentryAp.createControl().get("columns"));
        e.getItems().add(mapbizEntry);
        HashMap<String, String> bizprops = new HashMap<String, String>(1);
        bizprops.put("id", "tab" + bizEntityNumber);
        e.getItems().add(bizprops);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        BgApplyENtryInfo entryInfoFromFormParam = this.getEntryInfoFromFormParam(formShowParameter);
        String entryentityname = (String)formShowParameter.getCustomParam("entryentityname");
        this.addFiledToEntity(entryInfoFromFormParam, entryentityname, e);
    }

    private BgApplyENtryInfo getEntryInfoFromFormParam(FormShowParameter formShowParameter) {
        String paramStr = (String)formShowParameter.getCustomParam("bgApplyENtryInfo");
        if (paramStr != null) {
            return (BgApplyENtryInfo)SerializationUtils.fromJsonString((String)paramStr, BgApplyENtryInfo.class);
        }
        return null;
    }

    private DynamicObject getDny(FormShowParameter formShowParameter) {
        String dny = (String)formShowParameter.getCustomParam("dny");
        if (dny != null) {
            return (DynamicObject)SerializationUtils.deSerializeFromBase64((String)dny);
        }
        return null;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entryentityname = (String)formShowParameter.getCustomParam("entryentityname");
        BgApplyENtryInfo entryInfoFromFormParam = this.getEntryInfoFromFormParam(formShowParameter);
        if (entryInfoFromFormParam == null) {
            return;
        }
        EntryTemplateConfig entryTemplateConfig = (EntryTemplateConfig)entryInfoFromFormParam.getEntryTemplateConfig().get(entryentityname);
        List biz_collect = entryTemplateConfig.getEntryColumns();
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            log.error((Throwable)exp);
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        EntryType entryType = (EntryType)newMainType.getAllEntities().get("entryentity");
        entryType.createPropIndexs();
        ApplyTemplateUtils.registEntryDynamicProps((EntryType)entryType, (List)biz_collect);
        EntryAp entryAp = ApplyTemplateUtils.createEntryAp((String)"entryentity", (Collection)biz_collect);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.preInvokeControlMethod("entryentity", "createGridColumns", new Object[]{entryAp.createControl()});
        e.setNewEntityType(newMainType);
    }

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"entryentity"});
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        grid.addDataBindListener((EntryGridBindDataListener)this);
    }

    public void onGetControl(OnGetControlArgs e) {
        Control entryControl;
        super.onGetControl(e);
        String controlKey = e.getKey();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entryentityname = (String)formShowParameter.getCustomParam("entryentityname");
        BgApplyENtryInfo entryInfoFromFormParam = this.getEntryInfoFromFormParam(formShowParameter);
        if (entryInfoFromFormParam == null) {
            return;
        }
        EntryTemplateConfig entryTemplateConfig = (EntryTemplateConfig)entryInfoFromFormParam.getEntryTemplateConfig().get(entryentityname);
        List biz_collect = entryTemplateConfig.getEntryColumns();
        if (controlKey.startsWith("e_")) {
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            grid.setPageRow(10000);
            ApplyTemplateUtils.initControl((OnGetControlArgs)e, (String)controlKey, (String)"entryentity", (EntryGrid)grid, (List)biz_collect);
        } else if (controlKey.equals("entryentity") && (entryControl = e.getControl()) != null) {
            EntryGrid entryGrid = (EntryGrid)entryControl;
            entryGrid.setPageRow(10000);
            if (entryGrid.getItems().isEmpty()) {
                EntryAp entryAp = ApplyTemplateUtils.createEntryAp((String)"entryentity", (Collection)biz_collect);
                List fieldEdits = ((Container)entryAp.buildRuntimeControl()).getItems();
                this.addThisViewToEntryGrid(entryGrid, fieldEdits);
            }
        }
    }

    private void addThisViewToEntryGrid(EntryGrid entryGrid, List<Control> fieldEdits) {
        for (Control fieldEdit : fieldEdits) {
            if (fieldEdit instanceof Container) {
                if (fieldEdit instanceof OperationColumn) {
                    fieldEdit.setView(this.getView());
                } else {
                    this.addThisViewToEntryEditField(((Container)fieldEdit).getItems());
                    fieldEdit.setView(this.getView());
                }
            } else if (fieldEdit instanceof Control) {
                fieldEdit.setView(this.getView());
            }
            entryGrid.getItems().add(fieldEdit);
        }
    }

    private void addThisViewToEntryEditField(List<Control> items) {
        for (Control fieldEdit : items) {
            if (fieldEdit instanceof Container) {
                if (fieldEdit instanceof OperationColumn) {
                    fieldEdit.setView(this.getView());
                    continue;
                }
                this.addThisViewToEntryEditField(((Container)fieldEdit).getItems());
                fieldEdit.setView(this.getView());
                continue;
            }
            if (!(fieldEdit instanceof Control)) continue;
            fieldEdit.setView(this.getView());
        }
    }

    private ApplyBillEntityData getApplyBillEntryData() {
        String cacheStr = (String)this.getView().getFormShowParameter().getCustomParam("allApplyBillEntityData");
        ApplyBillEntityData billEntityData = cacheStr == null ? new ApplyBillEntityData() : (ApplyBillEntityData)SerializationUtils.deSerializeFromBase64((String)cacheStr);
        return billEntityData;
    }

    private void buildBusPlanTab() {
        List<TemplateBizPlan.BizPlan> bizplans = this.getBizPlans();
        Tab tabEdit = (Tab)this.getControl(TABAP);
        if (tabEdit == null) {
            return;
        }
        TabAp tabap = new TabAp();
        tabap.setKey(tabEdit.getKey());
        tabap.setGrow(0);
        String defaultSelectTabkey = "";
        int i = 0;
        for (TemplateBizPlan.BizPlan bizplan : bizplans) {
            TabPageAp page = new TabPageAp();
            page.setKey(TAB_PAGE_BUSPLAN + bizplan.getTabkey());
            if (i == 0) {
                defaultSelectTabkey = TAB_PAGE_BUSPLAN + bizplan.getTabkey();
            }
            page.setId(bizplan.getTabkey());
            page.setName(new LocaleString(bizplan.getTabName()));
            tabap.getItems().add(page);
            ++i;
        }
        Map features = tabap.createControl();
        this.getView().updateControlMetadata(tabap.getKey(), features);
        tabEdit.selectTab(defaultSelectTabkey);
        tabEdit.activeTab(defaultSelectTabkey);
    }

    private List<TemplateBizPlan.BizPlan> getBizPlans() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entryentityname = (String)formShowParameter.getCustomParam("entryentityname");
        BgApplyENtryInfo entryInfoFromFormParam = this.getEntryInfoFromFormParam(formShowParameter);
        if (entryInfoFromFormParam == null) {
            return new ArrayList<TemplateBizPlan.BizPlan>(16);
        }
        EntryTemplateConfig entryTemplateConfig = (EntryTemplateConfig)entryInfoFromFormParam.getEntryTemplateConfig().get(entryentityname);
        List biz_collect = entryTemplateConfig.getEntryColumns();
        long templateId = entryTemplateConfig.getTemplateID();
        DynamicObject template = BusinessDataServiceHelper.loadSingleFromCache((Object)templateId, (String)"eb_applytemplate");
        ColumnList columnList = ApplyTemplateUtils.getEntrycfgByApplyTemplate((DynamicObject)template);
        TemplateBizPlan templateBizPlan = ApplyBizplanHelper.getTemplateBizPlan((Long)templateId, (ColumnList)columnList);
        return templateBizPlan.getBizPlans();
    }

    private void filterNotDataTableKeys(BgApplyENtryInfo entryInfoFromFormParam) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entryname = (String)formShowParameter.getCustomParam("entryname");
        String bizPlanRangeSumKeysStr = (String)formShowParameter.getCustomParam("BizPlanRangeSumKeys");
        List bizTableKeys = new ArrayList(16);
        if (bizPlanRangeSumKeysStr != null) {
            bizTableKeys = (List)SerializationUtils.deSerializeFromBase64((String)bizPlanRangeSumKeysStr);
        }
        Map entryTemplateConfigMap = entryInfoFromFormParam.getEntryTemplateConfig();
        EntryTemplateConfig entryTemplateConfig1 = (EntryTemplateConfig)entryTemplateConfigMap.get(entryname);
        HashSet dimKeysList = new HashSet(entryTemplateConfig1.getDimKeysList());
        List dimCollect = entryTemplateConfig1.getEntryColumns().stream().filter(ee -> dimKeysList.contains(ee.getKey())).collect(Collectors.toList());
        String bizentityName = "biz" + entryname;
        int row = (Integer)this.getView().getFormShowParameter().getCustomParam("row");
        EntryTemplateConfig bizEntryCfg = (EntryTemplateConfig)entryTemplateConfigMap.get(bizentityName);
        if (bizEntryCfg == null) {
            return;
        }
        ApplyBillEntityData billEntityData = this.getApplyBillEntryData();
        StringBuilder filed = new StringBuilder();
        for (BaseColumn col : dimCollect) {
            EntityCellBaseData cellBaseData = billEntityData.getCellBaseData(row, col.getKey());
            if (cellBaseData == null) continue;
            filed.append(cellBaseData.getId()).append("_");
        }
        String rowSourceBillNumber = (String)billEntityData.getCellOtherData(row, "fbillnumber");
        ArrayList openTableKeys = new ArrayList(16);
        for (String tableKey : bizEntryCfg.getBizplanTabKeyFieldsMap().keySet()) {
            ApplyTemplateUtils.getHaveDataTableKeys((String)bizEntryCfg.getEntryTable(), (String)filed.toString(), (List)bizEntryCfg.getEntryColumns(), (String)rowSourceBillNumber, (String)tableKey, openTableKeys);
        }
        if (openTableKeys.size() > 0) {
            openTableKeys.retainAll(bizTableKeys);
        }
        if (openTableKeys.size() == 0) {
            openTableKeys.addAll(bizTableKeys);
        }
        List list = bizEntryCfg.getBizplanTabKeyFieldsMap().keySet().stream().filter(e -> !openTableKeys.contains(e)).collect(Collectors.toList());
        for (String openTableKey : list) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TAB_PAGE_BUSPLAN + openTableKey});
        }
    }

    public void tabSelected(TabSelectEvent tabevn) {
        String tabKey = tabevn.getTabKey();
        if (tabKey.startsWith(TAB_PAGE_BUSPLAN)) {
            this.filterBusPlanData(tabKey);
        }
    }

    private void filterBusPlanData(String tabkey) {
        List<TemplateBizPlan.BizPlan> bizPlans = this.getBizPlans();
        if (bizPlans.isEmpty()) {
            return;
        }
        String realtabkey = tabkey.replace(TAB_PAGE_BUSPLAN, "");
        List<String> showkeys = this.getBizFieldsByTabkey(bizPlans, realtabkey, true);
        List<String> hidekeys = this.getBizFieldsByTabkey(bizPlans, realtabkey, false);
        this.getView().setVisible(Boolean.valueOf(true), showkeys.toArray(new String[0]));
        this.getView().setVisible(Boolean.valueOf(false), hidekeys.toArray(new String[0]));
        this.getModel().deleteEntryData("entryentity");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entryentityname = (String)formShowParameter.getCustomParam("entryname");
        DynamicObject dny = this.getDny(formShowParameter);
        this.refreshBizEntryDataAndPutCombineInfo(dny, entryentityname, true, realtabkey);
    }

    private List<String> getBizFieldsByTabkey(List<TemplateBizPlan.BizPlan> bizPlans, String tabkey, boolean iscontain) {
        ArrayList<String> fields = new ArrayList<String>(16);
        List bizPlansBytabkey = null;
        bizPlansBytabkey = iscontain ? bizPlans.stream().filter(s -> s.getTabkey().equals(tabkey)).collect(Collectors.toList()) : bizPlans.stream().filter(s -> !s.getTabkey().equals(tabkey)).collect(Collectors.toList());
        for (TemplateBizPlan.BizPlan bizPlan : bizPlansBytabkey) {
            fields.addAll(bizPlan.getFields());
        }
        return fields;
    }
}

