/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.applytemplatecolumn.FormatColumn;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.formplugin.applybill.util.BgUserTemplateFormatService;

public class BgUserTemplateFormatPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(BgUserTemplateFormatPlugin.class);
    private static final String BTN_OK = "btn_ok";
    private static final String ENTRYENTITY = "entryentity";
    private static final String FREEZE = "freeze";
    private static final String COLUMNNAME = "columnname";
    private static final String COLUMNKEY = "columnkey";
    private static final String HIDE = "hide";

    public void afterCreateNewData(EventObject e) {
        this.fillEntryData();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Button)evt.getSource()).getKey()) {
            case "btn_ok": {
                this.save();
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String itemName = e.getProperty().getName();
        if (FREEZE.equals(itemName)) {
            this.checkFreezeRule(e.getChangeSet()[0]);
        }
    }

    private void checkFreezeRule(ChangeData changeData) {
        Boolean newValue = (Boolean)changeData.getNewValue();
        this.getModel().beginInit();
        int curIdx = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        if (newValue.booleanValue()) {
            for (int i = curIdx - 1; i >= 0; --i) {
                this.getModel().setValue(FREEZE, (Object)newValue, i);
            }
        } else {
            for (int i = curIdx + 1; i < this.getModel().getEntryRowCount(ENTRYENTITY); ++i) {
                this.getModel().setValue(FREEZE, (Object)newValue, i);
            }
        }
        this.getModel().endInit();
        this.updateViewAndRecoverSelectRows();
    }

    private void fillEntryData() {
        List<FormatColumn> editableColumn = this.getEditableColumn();
        int size = editableColumn.size();
        this.getModel().beginInit();
        int[] cloIndex = this.getModel().batchCreateNewEntryRow(ENTRYENTITY, size);
        this.getModel().endInit();
        for (int i = 0; i < size; ++i) {
            int index = cloIndex[i];
            this.getModel().setValue(COLUMNNAME, (Object)editableColumn.get(i).getTitle(), index);
            this.getModel().setValue(HIDE, (Object)(!editableColumn.get(i).isVisible() ? 1 : 0), index);
            this.getModel().setValue(FREEZE, (Object)editableColumn.get(i).isFreeze(), index);
            this.getModel().setValue(COLUMNKEY, (Object)editableColumn.get(i).getKey(), index);
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private Long getModelId() {
        Long modelId = IDUtils.toLong((Object)this.getModel().getValue("model"));
        if ((modelId == null || modelId == 0L) && (modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("modelId"))) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u201c\u4f53\u7cfb\u201d\u4fe1\u606f\u5931\u8d25\u3002", (String)"EbSchemeSyncPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        return modelId;
    }

    private List<FormatColumn> getEditableColumn() {
        String editableColumn = (String)this.getView().getFormShowParameter().getCustomParam("editableColumn");
        if (editableColumn != null) {
            List columns = (List)JSONObject.parseObject((String)editableColumn, (TypeReference)new TypeReference<List<FormatColumn>>(){}, (Feature[])new Feature[0]);
            Long templateId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("templateId"));
            Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("modelId"));
            Map<String, FormatColumn> templateColumnsFormat = BgUserTemplateFormatService.getInstance().getSingleTemplateColumnsFormat(templateId, modelId);
            for (FormatColumn column : columns) {
                if (templateColumnsFormat.get(column.getKey()) == null) continue;
                if (!templateColumnsFormat.get(column.getKey()).isVisible()) {
                    column.setVisible(false);
                }
                if (!templateColumnsFormat.get(column.getKey()).isFreeze()) continue;
                column.setFreeze(true);
            }
            return columns;
        }
        return new ArrayList<FormatColumn>();
    }

    private void save() {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
        Long templateId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("templateId"));
        BgUserTemplateFormatService.getInstance().saveFormat((List<DynamicObject>)dynamicObjects, this.getModelId(), templateId);
        this.getView().close();
    }

    private void updateViewAndRecoverSelectRows() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        int[] selectRows = grid.getSelectRows();
        this.getView().updateView();
        if (selectRows != null && selectRows.length > 0) {
            grid.selectRows(selectRows, selectRows[0]);
        }
    }
}

