/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.formplugin.applybill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.formplugin.AbstractFormPlugin;

public class ConflictRowTipPlugin
extends AbstractFormPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_clear"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDimsVisible();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String infos = (String)formShowParameter.getCustomParam("infos");
        List showInfos = (List)SerializationUtils.deSerializeFromBase64((String)infos);
        List<Map<String, String>> showInfoInSort = this.sortByTemplateAndRowIndex(showInfos);
        for (int i = 0; i < showInfoInSort.size(); ++i) {
            this.getModel().createNewEntryRow("entryentity");
            Map<String, String> showInfo = showInfoInSort.get(i);
            this.setColValue(i, showInfo, (DataType)DataType.LongType, "template", "conflictentity");
            this.setColValue(i, showInfo, (DataType)DataType.StringType, "rowindex", "conflictbillno");
        }
    }

    private List<Map<String, String>> sortByTemplateAndRowIndex(List<Map<String, String>> showInfos) {
        ArrayList<Map<String, String>> showInfoInSort = new ArrayList<Map<String, String>>(16);
        HashMap<String, List> showInfoInTemplate = new HashMap<String, List>(16);
        for (Map<String, String> showInfo : showInfos) {
            String template = showInfo.get("template");
            List list = showInfoInTemplate.computeIfAbsent(template, k -> new ArrayList(16));
            if (list.contains(showInfo)) continue;
            list.add(showInfo);
        }
        showInfoInTemplate.values().forEach(e -> showInfoInSort.addAll(this.sortWithRowIndex((List<Map<String, String>>)e)));
        return showInfoInSort;
    }

    private List<Map<String, String>> sortWithRowIndex(List<Map<String, String>> showInfoInTemplate) {
        ArrayList<Map<String, String>> showInfoInSort = new ArrayList<Map<String, String>>(16);
        HashMap<String, List<Map<String, String>>> showInfoInRowIndex = new HashMap<String, List<Map<String, String>>>(16);
        for (Map<String, String> showInfo : showInfoInTemplate) {
            String template = showInfo.get("rowindex");
            List list = showInfoInRowIndex.computeIfAbsent(template, k -> new ArrayList(16));
            if (list.contains(showInfo)) continue;
            list.add(showInfo);
        }
        int size = showInfoInRowIndex.size();
        for (int i = 0; i < size; ++i) {
            String minIndex = this.getMinIndex(showInfoInRowIndex);
            showInfoInSort.addAll((Collection)showInfoInRowIndex.remove(minIndex));
        }
        return showInfoInSort;
    }

    private String getMinIndex(Map<String, List<Map<String, String>>> showInfoInRowIndex) {
        String minIndex = null;
        for (Map.Entry<String, List<Map<String, String>>> showInfo : showInfoInRowIndex.entrySet()) {
            String key = showInfo.getKey();
            if (minIndex != null && ConvertUtils.toLong((Object)key) >= ConvertUtils.toLong((Object)minIndex)) continue;
            minIndex = key;
        }
        return minIndex;
    }

    private void setColValue(int i, Map<String, String> showInfo, DataType type, String ... keys) {
        for (String key : keys) {
            String value = showInfo.get(key);
            if (StringUtils.isEmpty((String)value)) continue;
            if (DataType.LongType.equals((Object)type)) {
                this.getModel().setValue(key, (Object)ConvertUtils.toLong((Object)value), i);
                continue;
            }
            if (!DataType.StringType.equals((Object)type)) continue;
            this.getModel().setValue(key, (Object)value, i);
        }
    }

    private void setDimGroup(String dimGroup, int i) {
    }

    private void setDimsVisible() {
        for (int i = 1; i < 7; ++i) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"dim" + i});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        HashMap<Long, List> retData = new HashMap<Long, List>(16);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] rows = entryGrid.getSelectRows();
        if (rows != null && rows.length != 0) {
            for (int row : rows) {
                Integer clearRow;
                List rowList;
                DynamicObject template = (DynamicObject)this.getModel().getValue("template", row);
                if (template == null) continue;
                long templateId = template.getLong("id");
                Object rowindex = this.getModel().getValue("rowindex", row);
                if (rowindex == null || (rowList = retData.computeIfAbsent(templateId, k -> new ArrayList(16))).contains(clearRow = Integer.valueOf(Integer.parseInt(rowindex.toString())))) continue;
                rowList.add(clearRow);
            }
        }
        this.getView().returnDataToParent((Object)SerializationUtils.serializeToBase64(retData));
        this.getView().close();
    }
}

